#!/usr/bin/perl
use Time::Local;
# This is the script processing Aqua-AIRS support product
#
# define dir
#$ANCDIR = $ENV {ANCHOR};
#$MYDIR = "apps/soundings/a4/wrk/bsun";

$OUTFILE_DIR = "/data/data065/nprovs/source/matchup/airsV06_support.processing";
$MYDIR = "/data/data065/nprovs/source/matchup";
$WORKING_DIR = "$MYDIR/airsV06_support.processing";
$EXE_DIR = "$WORKING_DIR/code";
$INCOMING_DIR = "/data/data065/nprovs/data/matchup/DailyGranules_incoming/AIRv6_data_incoming";
#$INCOMING_DIR = "$WORKING_DIR/incoming";
$LOG_DIR = "$WORKING_DIR/logs";


# define file name
$LOG_FILE = "LOG_DAILY";

open (LOGFILE, ">>$LOG_DIR/$LOG_FILE");
print LOGFILE "\n++++++ Begin to start the main script++++\n";
print LOGFILE `date`;
print LOGFILE "  \n";
print LOGFILE "Remove all files that are currently in the local directory\n";

# Remove all files that are currently in the local directory
@files = glob "$INCOMING_DIR/"."*";
foreach $file (@files)
  {
  unlink $file;
  }



#my $addf_file = "$OUTFILE_DIR/airs.addf";
#$addf_file = "$OUTFILE_DIR/airsV06.addf";
$addf_file = "$OUTFILE_DIR/airsV06.addf.manual";

print LOGFILE "Remove the previous addf\n";

# Remove the previous ADDF
unlink $addf_file or warn "Cannot unlink the addf file";



# ftp the airs data from nasa site
# system " perl /DEV/PROD/apps/soundings/a4/wrk/bsun/airs_support.processing/code/get_airs_from_airscal1u.pl";


# 1 day preceding to the current day
$data_date = time();
$data_date -= 86400*0;
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime ($data_date);
$year += 1900;
$yday1=sprintf("%03d",$yday);
$year1=sprintf("%02d",$year-2000);

$year =2024;
#$year =2019;
#$year =2018;
#$year =2017;
#$yday1 =203;
#$yday1 =202;
#$yday1 =365;
#$yday1 =212;
#$yday1 =213;
#$yday1 =278;
#$yday1 =279;
#$yday1 =280;
#$yday1 =63;
#$yday1 =64;
#$yday1 =65;
#$yday1 =68;
#$yday1 =69;
#$yday1 =70;
#$yday1 =117;
#$yday1 =127;
#$yday1 =50;
#$yday1 =51;
#$yday1 =218;
#$yday1 =261;
#$yday1 =262;
#$yday1 =268;
$yday1 =308;

$yday1=sprintf("%03d",$yday1);

print "\n $year \n";
print "\n $yday1 \n";
#
system ("$EXE_DIR/ftp.y $year $yday1");
#
##system ("$EXE_DIR/ftp.y $year $yday1>> $LOG_DIR/$LOG_FILE");

# Goto exec directory
chdir ("$EXE_DIR") or die "Cannot cd to $EXE_DIR:$!\n";


print LOGFILE "decode each airs file\n";
# process each AIRS oper file

#my @airsfiles = glob "$INCOMING_DIR/AIRS*.hdf";
@airsfiles = glob "$INCOMING_DIR/AIRS*.hdf";

foreach $file (@airsfiles)
  {
  print LOGFILE "Processing file: ". $file, "\n";

  # Link the files
  symlink $addf_file, "out.file" or warn "Cannot link $addf_file to out.file";

  # process the conversion
 system ("$EXE_DIR/swath_read $file >>$LOG_DIR/$LOG_FILE");

 # Unlink the files
 unlink "out.file" or warn "Cannot unlink the out.file";

  }

print LOGFILE "The execution is successfully completed !!!\n";
print LOGFILE `date`;
print LOGFILE "  \n";
close(LOGFILE);

# end of file
