/*   Updated for V6 by Feng Ding in January 2013 */

/* Structure holds an entire granule of airs_sup */
typedef struct {

  /* Attributes */
  char            processing_level[256];
  char            instrument[256];
  char            DayNightFlag[256];
  char            AutomaticQAFlag[256];
  long            NumTotalData;
  long            NumProcessData;
  long            NumSpecialData;
  long            NumBadData;
  long            NumMissingData;
  long            NumLandSurface;
  long            NumOceanSurface;
  char            node_type[256];
  long            start_year;
  long            start_month;
  long            start_day;
  long            start_hour;
  long            start_minute;
  float           start_sec;
  long            start_orbit;
  long            end_orbit;
  long            orbit_path;
  long            start_orbit_row;
  long            end_orbit_row;
  long            granule_number;
  long            num_scansets;
  long            num_scanlines;
  double          start_Latitude;
  double          start_Longitude;
  double          start_Time;
  double          end_Latitude;
  double          end_Longitude;
  double          end_Time;
  float           eq_x_longitude;
  double          eq_x_tai;
  short           LonGranuleCen;
  short           LatGranuleCen;
  short           LocTimeGranuleCen;
  short           num_fpe;
  unsigned long   orbitgeoqa;
  short           num_satgeoqa;
  short           num_glintgeoqa;
  short           num_moongeoqa;
  short           num_ftptgeoqa;
  short           num_zengeoqa;
  short           num_demgeoqa;
  unsigned short  NumSO2FOVs;
  char            CO_first_guess[256];
  char            CH4_first_guess[256];
  long            numHingeSurfInit;
  short           nFOV_big_ang_adj;
  short           num_retrieval_type_000;
  short           num_retrieval_type_010;
  short           num_retrieval_type_020;
  short           num_retrieval_type_030;
  short           num_retrieval_type_040;
  short           num_retrieval_type_050;
  short           num_retrieval_type_100;
  long            NumMWStratIrRetOnly;
  long            NumNoHSB;
  long            NumNoAMSUA;
  long            NumNoAIRS;
  long            NumNoVis;
  long            DCRCount;
  long            PopCount;
  long            MoonInViewMWCount;

  /* Geolocation fields */
  double           Latitude[AIRS_SUP_GEOTRACK][AIRS_SUP_GEOXTRACK];
  double           Longitude[AIRS_SUP_GEOTRACK][AIRS_SUP_GEOXTRACK];
  double           Time[AIRS_SUP_GEOTRACK][AIRS_SUP_GEOXTRACK];

  /* Data Fields */
  float           satheight[45];
  float           satroll[45];
  float           satpitch[45];
  float           satyaw[45];
  float           satzen[45][30];
  float           satazi[45][30];
  float           solzen[45][30];
  float           solazi[45][30];
  float           glintlat[45];
  float           glintlon[45];
  short           sun_glint_distance[45][30];
  double          nadirTAI[45];
  double          sat_lat[45];
  double          sat_lon[45];
  signed char     scan_node_type[45];
  float           topog[45][30];
  float           topog_err[45][30];
  float           landFrac[45][30];
  float           landFrac_err[45][30];
  unsigned long   satgeoqa[45];
  unsigned short  glintgeoqa[45];
  unsigned short  moongeoqa[45];
  float           latAIRS[45][30][3][3];
  float           lonAIRS[45][30][3][3];
  float           pressSupp[100];
  float           pressStd[28];
  float           PSurfStd[45][30];
  unsigned short  PSurfStd_QC[45][30];
  long            nSurfSup[45][30];
  long            nSurfStd[45][30];
  short           dust_flag[45][30][3][3];
  short           dust_score[45][30][3][3];
  float           BT_diff_SO2[45][30][3][3];
  unsigned short  BT_diff_SO2_QC[45][30][3][3];
  short           cloud_phase_3x3[45][30][3][3];
  short           cloud_phase_bits[45][30][3][3];
  float           PBest[45][30];
  float           PGood[45][30];
  short           nBestSup[45][30];
  short           nGoodSup[45][30];
  short           nBestStd[45][30];
  short           nGoodStd[45][30];
  float           TSurfStd[45][30];
  unsigned short  TSurfStd_QC[45][30];
  float           TSurfStdErr[45][30];
  short           numHingeSurf[45][30];
  float           freqEmis[45][30][100];
  float           emisIRStd[45][30][100];
  unsigned short  emisIRStd_QC[45][30][100];
  float           emisIRStdErr[45][30][100];
  float           Effective_Solar_Reflectance[45][30][100];
  unsigned short  Effective_Solar_Reflectance_QC[45][30][100];
  float           TAirSup[45][30][100];
  unsigned short  TAirSup_QC[45][30][100];
  float           TAirSupErr[45][30][100];
  float           TSurfAir[45][30];
  unsigned short  TSurfAir_QC[45][30];
  float           TSurfAirErr[45][30];
  short           num_Temp_Func[45][30];
  float           Temp_ave_kern[45][30][23][23];
  float           Temp_verticality[45][30][23];
  float           Temp_dof[45][30];
  float           H2OMMRSatLevSup[45][30][100];
  unsigned short  H2OMMRSatLevSup_QC[45][30][100];
  float           H2OMMRSatSurf[45][30];
  unsigned short  H2OMMRSatSurf_QC[45][30];
  float           H2OMMRSatLevSup_liquid[45][30][100];
  unsigned short  H2OMMRSatLevSup_liquid_QC[45][30][100];
  float           H2OMMRSatSurf_liquid[45][30];
  unsigned short  H2OMMRSatSurf_liquid_QC[45][30];
  float           PTropopause[45][30];
  unsigned short  PTropopause_QC[45][30];
  float           T_Tropopause[45][30];
  unsigned short  T_Tropopause_QC[45][30];
  float           totH2OStd[45][30];
  unsigned short  totH2OStd_QC[45][30];
  float           totH2OStdErr[45][30];
  float           H2OCDSup[45][30][100];
  unsigned short  H2OCDSup_QC[45][30][100];
  float           H2OCDSupErr[45][30][100];
  float           H2OMMRLevSup[45][30][100];
  unsigned short  H2OMMRLevSup_QC[45][30][100];
  float           H2OMMRLevSupErr[45][30][100];
  float           H2OMMRSurf[45][30];
  unsigned short  H2OMMRSurf_QC[45][30];
  float           H2OMMRSurfErr[45][30];
  short           num_H2O_Func[45][30];
  float           H2O_eff_press[45][30][11];
  float           H2O_VMR_eff[45][30][11];
  unsigned short  H2O_VMR_eff_QC[45][30][11];
  float           H2O_VMR_eff_err[45][30][11];
  long            H2O_trapezoid_layers[11];
  float           H2O_verticality[45][30][11];
  float           H2O_dof[45][30];
  float           H2O_ave_kern[45][30][11][11];
  float           RelHum[45][30][15];
  unsigned short  RelHum_QC[45][30][15];
  float           RelHumSurf[45][30];
  unsigned short  RelHumSurf_QC[45][30];
  float           RelHum_liquid[45][30][15];
  unsigned short  RelHum_liquid_QC[45][30][15];
  float           RelHumSurf_liquid[45][30];
  unsigned short  RelHumSurf_liquid_QC[45][30];
  float           bndry_lyr_top[45][30];
  unsigned short  bndry_lyr_top_QC[45][30];
  float           GP_Tropopause[45][30];
  unsigned short  GP_Tropopause_QC[45][30];
  float           GP_HeightSup[45][30][100];
  unsigned short  GP_HeightSup_QC[45][30][100];
  float           GP_Surface[45][30];
  unsigned short  GP_Surface_QC[45][30];
  float           CldFrcTot[45][30];
  unsigned short  CldFrcTot_QC[45][30];
  float           CldFrcStd[45][30][3][3][2];
  unsigned short  CldFrcStd_QC[45][30][3][3][2];  
  float           CldFrcStdErr[45][30][3][3][2];
  float           PCldTop[45][30][3][3][2];
  unsigned short  PCldTop_QC[45][30][3][3][2];
  float           PCldTopErr[45][30][3][3][2];
  float           TCldTop[45][30][3][3][2];
  unsigned short  TCldTop_QC[45][30][3][3][2];
  float           TCldTopErr[45][30][3][3][2];
  long            nCld[45][30][3][3];
  float           PCldTopStd[45][30][2];
  unsigned short  PCldTopStd_QC[45][30][2];
  float           PCldTopStdErr[45][30][2];
  float           TCldTopStd[45][30][2];
  unsigned short  TCldTopStd_QC[45][30][2];
  float           TCldTopStdErr[45][30][2];
  int             numCloud[45][30];
  short           numHingeCloud[45][30];
  float           cldFreq[45][30][2][7];
  float           CldEmis[45][30][2][7];
  unsigned short  CldEmis_QC[45][30][2][7];
  float           CldEmisErr[45][30][2][7];
  float           CldRho[45][30][2][7];
  unsigned short  CldRho_QC[45][30][2][7];
  float           CldRhoErr[45][30][2][7];
  float           ice_cld_opt_dpth[45][30][3][3];
  unsigned short  ice_cld_opt_dpth_QC[45][30][3][3];   
  float           ice_cld_eff_diam[45][30][3][3];
  unsigned short  ice_cld_eff_diam_QC[45][30][3][3];   
  float           ice_cld_temp_eff[45][30][3][3];
  unsigned short  ice_cld_temp_eff_QC[45][30][3][3];   
  float           ice_cld_fit_reduced_chisq[45][30][3][3];
  float           ice_cld_opt_dpth_ave_kern[45][30][3][3];
  float           ice_cld_eff_diam_ave_kern[45][30][3][3];
  float           ice_cld_temp_eff_ave_kern[45][30][3][3];
  float           ice_cld_opt_dpth_err[45][30][3][3];
  float           ice_cld_eff_diam_err[45][30][3][3];
  float           ice_cld_temp_eff_err[45][30][3][3];
  float           log_ice_cld_opt_dpth_prior_var[45][30][3][3];
  float           log_ice_cld_eff_diam_prior_var[45][30][3][3];
  float           ice_cld_temp_eff_prior_var[45][30][3][3];
  float           ice_cld_opt_dpth_first_guess[45][30][3][3];
  float           ice_cld_eff_diam_first_guess[45][30][3][3];
  float           ice_cld_temp_eff_first_guess[45][30][3][3];
  float           totO3Std[45][30];
  unsigned short  totO3Std_QC[45][30];
  float           totO3StdErr[45][30];
  float           O3CDSup[45][30][100];
  unsigned short  O3CDSup_QC[45][30][100];
  float           O3CDSupErr[45][30][100];
  float           O3VMRLevSup[45][30][100];
  unsigned short  O3VMRLevSup_QC[45][30][100];
  float           O3VMRLevSupErr[45][30][100];
  float           O3VMRSurf[45][30];
  unsigned short  O3VMRSurf_QC[45][30];
  float           O3VMRSurfErr[45][30];
  short           num_O3_Func[45][30];
  long            O3_trapezoid_layers[9];
  float           O3_eff_press[45][30][9];
  float           O3_VMR_eff[45][30][9];
  unsigned short  O3_VMR_eff_QC[45][30][9];
  float           O3_VMR_eff_err[45][30][9];
  float           O3_verticality[45][30][9];
  float           O3_dof[45][30];
  float           O3_ave_kern[45][30][9][9];
  float           CO_total_column[45][30];
  unsigned short  CO_total_column_QC[45][30];
  float           COCDSup[45][30][100];
  unsigned short  COCDSup_QC[45][30][100];
  float           COCDSupErr[45][30][100];
  float           COVMRLevSup[45][30][100];
  unsigned short  COVMRLevSup_QC[45][30][100];
  float           COVMRLevSupErr[45][30][100];
  float           COVMRSurf[45][30];
  unsigned short  COVMRSurf_QC[45][30];
  float           COVMRSurfErr[45][30];
  short           num_CO_Func[45][30];
  long            CO_trapezoid_layers[9];
  float           CO_eff_press[45][30][9];
  float           CO_VMR_eff[45][30][9];
  unsigned short  CO_VMR_eff_QC[45][30][9];
  float           CO_VMR_eff_err[45][30][9];
  float           CO_verticality[45][30][9];
  float           CO_dof[45][30];
  float           CO_ave_kern[45][30][9][9];
  float           CH4_total_column[45][30];
  unsigned short  CH4_total_column_QC[45][30];
  float           CH4CDSup[45][30][100];
  unsigned short  CH4CDSup_QC[45][30][100];
  float           CH4CDSupErr[45][30][100];
  float           CH4VMRLevSup[45][30][100];
  unsigned short  CH4VMRLevSup_QC[45][30][100];
  float           CH4VMRLevSupErr[45][30][100];
  float           CH4VMRSurf[45][30];
  unsigned short  CH4VMRSurf_QC[45][30];
  float           CH4VMRSurfErr[45][30];
  short           num_CH4_Func[45][30];
  long            CH4_trapezoid_layers_10func[10];
  float           CH4_eff_press_10func[45][30][10];
  float           CH4_VMR_eff_10func[45][30][10];
  unsigned short  CH4_VMR_eff_10func_QC[45][30][10];
  float           CH4_VMR_eff_10func_err[45][30][10];
  float           CH4_verticality_10func[45][30][10];
  float           CH4_dof[45][30];
  float           CH4_ave_kern_10func[45][30][10][10];
  float           olr[45][30];
  unsigned short  olr_QC[45][30];
  float           spectralolr[45][30][16];
  unsigned short  spectralolr_QC[45][30][16];
  float           olr3x3[45][30][3][3];
  unsigned short  olr3x3_QC[45][30][3][3];
  float           olr_err[45][30];
  float           clrolr[45][30];
  unsigned short  clrolr_QC[45][30];
  float           clrolr_err[45][30];
  float           spectralclrolr[45][30][16];
  unsigned short  spectralclrolr_QC[45][30][16];
  unsigned long   ftptgeoqa[45][30];
  unsigned short  zengeoqa[45][30];
  unsigned short  demgeoqa[45][30];
  signed char     all_spots_avg[45][30];
  signed char     retrieval_type[45][30];
  signed char     SurfClass[45][30];
  float           IR_Precip_Est[45][30];
  unsigned short  IR_Precip_Est_QC[45][30];
  float           IR_Precip_Est3x3[45][30][3][3];
  unsigned short  IR_Precip_Est3x3_QC[45][30][3][3];
  float           IR_Precip_Est_Err[45][30];
  float           TAirMWOnly[45][30][100];
  unsigned short  TAirMWOnly_QC[45][30][100];
  float           TAirMWOnlyErr[45][30][28];
  signed char     MWSurfClass[45][30];
  float           sfcTbMWStd[45][30][7];
  unsigned short  sfcTbMWStd_QC[45][30][7];
  float           EmisMWStd[45][30][7];
  unsigned short  EmisMWStd_QC[45][30][7];
  float           EmisMWStdErr[45][30][7];
  float           Emis50GHz[45][30];
  unsigned short  Emis50GHz_QC[45][30];
  float           totH2OMWOnlyStd[45][30];
  unsigned short  totH2OMWOnlyStd_QC[45][30];
  float           H2OCDMWOnly[45][30][100];
  unsigned short  H2OCDMWOnly_QC[45][30][100];  
  float           totCldH2OStd[45][30];
  unsigned short  totCldH2OStd_QC[45][30];
  float           totCldH2OStdErr[45][30];
  float           satzen_amsu[45][30];
  float           satazi_amsu[45][30];
  float           MWHingeSurfFreqGHz[7];
  unsigned char   PrecipAA4_50km[45][30];
  unsigned char   PrecipAA5_50km[45][30];
  unsigned char   PrecipAA6_50km[45][30];
  unsigned char   PrecipAA7_50km[45][30];
  unsigned char   PrecipAA8_50km[45][30];
  unsigned char   PrecipAA9_50km[45][30];
  unsigned char   PrecipAA4_15km[45][30][3][3];
  unsigned char   PrecipAA5_15km[45][30][3][3];
  unsigned char   PrecipAA6_15km[45][30][3][3];
  unsigned char   PrecipAA7_15km[45][30][3][3];
  unsigned char   PrecipAA8_15km[45][30][3][3];
  unsigned char   PrecipAA9_15km[45][30][3][3];
  float           AMSU_A_4_Precip_Corr_50km[45][30];
  float           AMSU_A_5_Precip_Corr_50km[45][30];
  float           AMSU_A_6_Precip_Corr_50km[45][30];
  float           AMSU_A_7_Precip_Corr_50km[45][30];
  float           AMSU_A_8_Precip_Corr_50km[45][30];
  float           AMSU_A_9_Precip_Corr_50km[45][30];
  float           AMSU_A_4_Precip_Corr_15km[45][30][3][3];
  float           AMSU_A_5_Precip_Corr_15km[45][30][3][3];
  float           AMSU_A_6_Precip_Corr_15km[45][30][3][3];
  float           AMSU_A_7_Precip_Corr_15km[45][30][3][3];
  float           AMSU_A_8_Precip_Corr_15km[45][30][3][3];
  float           AMSU_A_9_Precip_Corr_15km[45][30][3][3];
  float           rain_rate_50km[45][30];
  float           rain_rate_15km[45][30][3][3];
  float           lwCDSup[45][30][100];
  unsigned short  lwCDSup_QC[45][30][100];
  float           lwCDSupErr[45][30][100];
  long            cIWSup[45][30][100];
  float           satzen_hsb[45][30];
  float           satazi_hsb[45][30];
  float           tsurf_forecast[45][30];
  float           Forecast_Wind_U[45][30];
  float           Forecast_Wind_V[45][30];
  float           MODIS_emis[45][30][6];
  float           MODIS_emis_dev[45][30][6];
  short           MODIS_emis_qct[45][30][4];
  float           MODIS_emis_spots[45][30][6][3][3];
  float           MODIS_emis_spots_dev[45][30][6][3][3];
  float           MODIS_emis_10_hinge[45][30][10];
  float           MODIS_LST[45][30];
  float           MODIS_LST_dev[45][30];
  short           MODIS_LST_qct[45][30][4];
  float           MODIS_LST_spots[45][30][3][3];
  float           MODIS_LST_spots_dev[45][30][3][3];
  float           CO2ppmv[45][30];
  unsigned short  CO2ppmv_QC[45][30];
  float           CO2ppmvErr[45][30];
  float           TSurfClim[45][30];
  float           TSurfAirClim[45][30];
  float           TAirClim[45][30][100];
  float           H2OCDClim[45][30][100];
  float           Tropo_CCI[45][30];
  unsigned short  Tropo_CCI_QC[45][30];
  float           Tropo_CCI_Est_Err[45][30];
  float           Strato_CCI[45][30];
  unsigned short  Strato_CCI_QC[45][30];
  float           Strato_CCI_Est_Err[45][30];
  short           MoonInViewIR[45][30];
  float           pseudo_lapse_rate[45][30][3][3];    
  float           TAirSCCNN[45][30][100];
  float           TAirCldyReg[45][30][100];
  float           H2OCDSCCNN[45][30][100];
  float           H2OCDCldyReg[45][30][100];
  float           TSurfSCCNN[45][30];
  float           TSurf1Ret[45][30];
  float           TSurfAir1Ret[45][30];
  float           TAir1Ret[45][30][100];
  float           H2OCD1Ret[45][30][100];
  float           O3CDInit[45][30][100];
  short           numHingeSurfFG[45][30];
  float           freqEmisFG[45][30][100];
  float           emisIRFG[45][30][100];
  float           freqEmisInit[50];
  float           emisIRInit[45][30][50];
  float           rhoIRInit[45][30][50];
  float           FracLandPlusIce[45][30];
  float           CldClearParam[45][30][3][3];
  float           CC1_Noise_Amp[45][30];
  float           Tsurf_4_CC1[45][30];
  float           TotCld_4_CC1[45][30];
  long            CC1_RCode[45][30];
  long            CC2_RCode[45][30];
  long            Phys_RCode[45][30];
  float           TotCld_below_500mb[45][30];
  float           Phys_resid_AMSUA[45][30][15];
  float           Phys_resid_IR_window_790[45][30];
  float           Phys_resid_IR_window_844[45][30];
  float           Phys_resid_IR_window_917[45][30];
  float           Phys_resid_IR_window_1231[45][30];
  float           Phys_resid_IR_window_2513[45][30];
  float           Phys_resid_IR_window_2616[45][30];
  float           CBTmOBT1231[45][30][3][3];
  float           CBTmOBT1231s[45][30][3][3];
  float           CC_noise_eff_amp_factor[45][30];
  float           CC1_noise_eff_amp_factor[45][30];
  float           CC1_Resid[45][30];
  float           CCfinal_Resid[45][30];
  float           CCfinal_Noise_Amp[45][30];
  float           Tdiff_IR_MW_ret[45][30];
  float           Tdiff_IR_4CC1[45][30];
  float           TSurfdiff_IR_4CC1[45][30];
  float           TSurfdiff_IR_4CC2[45][30];
  float           AMSU_Chans_Resid[45][30];
  float           TotCld_4_CCfinal[45][30];
  float           Surf_Resid_Ratio[45][30];
  float           Temp_Resid_Ratio[45][30];
  float           Water_Resid_Ratio[45][30];
  float           Cloud_Resid_Ratio3x3[45][30][3][3];
  float           Cloud_Resid_Ratio[45][30];
  float           O3_Resid_Ratio[45][30];
  float           CO_Resid_Ratio[45][30];
  float           CH4_Resid_Ratio[45][30];
  float           MWCheck_Resid_Ratio[45][30];
  signed char     invalid[45][30];
  signed char     MW_ret_used[45][30];
  signed char     bad_clouds[45][30];
  signed char     Start_Clim[45][30];
  signed char     Startup[45][30];
  signed char     cld_surf_fallback[45][30];
  short           nchan_big_ang_adj[45][30];
  signed char     bad_l1b[45][30];
  signed char     bad_l1b_amsu[45][30];
  signed char     bad_l1b_hsb[45][30];
  signed char     bad_l1b_airs[45][30];
  signed char     bad_l1b_vis[45][30];
  signed char     forecast[45][30];
  signed char     no_psurf_guess[45][30];
  signed char     bad_temps[45][30];
  signed char     bad_h2o[45][30];
  signed char     bad_o3[45][30];
  signed char     bad_co[45][30];
  signed char     no_tuning[45][30];
  signed char     no_ang_corr[45][30];
  signed char     no_mw[45][30];
  signed char     no_initial[45][30];
  signed char     no_final[45][30];
  signed char     mw_fpe[45][30];
  signed char     cloudy_reg_fpe[45][30];
  signed char     initial_fpe[45][30];
  signed char     final_fpe[45][30];
  signed char     MWPrecip[45][30];
  float           MWsurf_T0[45][30];
  float           MWsurf_Tinf[45][30];
  float           MWsecant_ratio[45][30];
  float           MWseaice_conc[45][30];
  float           MWresidual_temp[45][30];
  float           MWresidual_mois[45][30];
  float           MWresidual_AMSUA[45][30][15];
  float           MWresidual_HSB[45][30][5];
  signed char     MWiter_temp[45][30];
  signed char     MWiter_mois[45][30];
  signed char     mw_ret_code[45][30];
  signed char     sccnn_ret_code[45][30];
  signed char     cloudy_reg_ret_code[45][30];
  short           Cloudy_Reg_FOV_chan[45][30];
  short           Cloudy_Reg_FOV[45][30];
  float           Cloudy_Reg_FOV_BT[45][30];
  float           Cloudy_Reg_Score[45][30];
  signed char     cloud_ice[45][30];
  signed char     icc_too_cloudy[45][30];
  signed char     icc_low_contrast[45][30];
  signed char     icc_bad_rad[45][30];
  float           icc_contrast[45][30];
  signed char     bad_1st[45][30];
  signed char     bad_1st_surf[45][30];
  signed char     bad_1st_cc[45][30];
  signed char     bad_1st_regres[45][30];
  signed char     bad_1st_phys[45][30];
  signed char     fcc_too_cloudy[45][30];
  signed char     fcc_low_contrast[45][30];
  signed char     fcc_bad_rad[45][30];
  float           fcc_contrast1[45][30];
  float           fcc_contrast2[45][30];
  signed char     bad_final[45][30];
  signed char     bad_final_cc[45][30];
  signed char     bad_final_ir[45][30];
  signed char     bad_final_surf[45][30];
  signed char     bad_final_temp[45][30];
  signed char     bad_final_h2o[45][30];
  signed char     bad_final_o3[45][30];
  signed char     bad_final_cloud[45][30];
  signed char     bad_cc_cld_ret[45][30];
  signed char     MW_IR_ret_differ[45][30];
  signed char     bad_MW_low_resid[45][30];
  float           MW_low_atm_resid[45][30];
  signed char     final_AMSU_ret[45][30];
  signed char     final_HSB_ret[45][30];
  signed char     final_cloud_ret[45][30];
  signed char     final_cloud_spot_ret3x3[45][30][3][3];
  signed char     final_surf_ret[45][30];
  signed char     final_temp_ret[45][30];
  signed char     final_h2o_ret[45][30];
  signed char     final_o3_ret[45][30];
  signed char     final_ch4_ret[45][30];
  signed char     final_co_ret[45][30];
  signed char     final_co2_ret[45][30];
  signed char     bad_vis_rad[45][30];
  signed char     bad_vis_cal[45][30];
  signed char     bad_vis_det_temp[45][30];
  signed char     bad_scan_hd_temp[45][30];
  float           Initial_CC_score[45][30];
  float           Initial_CC_subscores[45][30][10];
  float           sccnn_bt_corr[45][30][2];
  float           sccnn_bt_corr_freq[45][30][2];
  long            relayer_num_nonpos_coef_h2o[45][30];
  long            relayer_num_nonpos_coef_o3[45][30];
  long            relayer_num_nonpos_coef_co[45][30];
  long            relayer_num_nonpos_coef_ch4[45][30];
  long            relayer_num_knots[45][30];
  long            relayer_degree[45][30];
  long            relayer_runge_kutta_bits[45][30];
  short           Num_Fill_Chan_Cloudy_Reg[45][30];
  short           Num_Fill_Chan_SCCNN[45][30];
  short           Num_Fill_Chan_Ang_Adj[45][30];
  float           Doppler_shift_ppm[45][30];
  short           spectral_clear_indicator[45][30][3][3];
  short           num_clear_spectral_indicator[45][30];
  float           orbit_phase_deg[45];
  float           shift_y0[45][17];
  float           scan_freq[45][2378];
  unsigned char   L1cProc[45][2378]; 
  unsigned char   L1cCleanReason[45][2378]; 
  float           L1C_Reconst_Bias[2378];  
  float           L1C_Reconst_Dev[2378];  

} airs_sup_gran_t;

/* proptotype for reader function */
extern void airs_sup_rdr(char * file_name, airs_sup_gran_t * airs_sup_gran );

