#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "airs_sup_typ.h"
#include "airs_sup_struct.h"


/*
 * Note: this struct is large.  On my system this works
 * when allocated this way but not when allocated as an automatic
 * local variable in main().  It could also be dynamically allocated
 * with malloc().
 */

#define MYTRUE  0
#define MYFALSE	1

#define SWAP_IN MYFALSE
#define SWAP_OUT MYFALSE

#define	ADDF_RECORD_LEN		5000
#define	ADDF_HEADER_WDS		ADDF_RECORD_LEN/4
#define ADDF_DATA_WDS		ADDF_RECORD_LEN/2

#define	ISPV			-32768
#define MISVAL			-9999.0

static airs_sup_gran_t airs_sup_gran;		
void convert_time(double, int *, int *, int *, int *);
float cden_to_mr(float, float *, int);

int main(int argc, char * argv[]) { 


  int layer; /* 0-based atmospheric pressure layer index. */
             /* 0 is surface (or below) */
  int track; /* 0-based index along track */
  int xtrack;/* 0-based index across-track */
  char * file_name = 0;


	int	out_header[ADDF_DATA_WDS];
	short	buffer[ADDF_DATA_WDS];		
	FILE	*out;
	struct  tm *ts;
	long	offset;
	int	frame_record, in_file_num, out_record;
	int	year, mmdd, hour, mmss;
	int	month, day, yyyymmdd; 
	double	spot_time;
	time_t	date_time;
	float	cden, mxratio,pobs[100];
	int 	i,j,k,np, nrecord=0;
	int     i0,j0, num_fov;
        float   cf_tot;



/*-------------------------------------------------------------*/

	track=AIRS_SUP_GEOTRACK;
	xtrack=AIRS_SUP_GEOXTRACK;


	/* if the output file does not exist, a new header wil be created 
	   containing defalut values. If teh file exists, the header record
	   is read out */

	if ( (out=fopen("out.file","r"))==NULL)
	  {
		for (i=0; i<ADDF_HEADER_WDS; i++)
			out_header[i]= -32768;
		out_header[0]=65686870;
		out_header[1]=10;
		out_header[2]=1;
		out_header[3]=ADDF_RECORD_LEN;
		out_header[4]=ADDF_RECORD_LEN;
		out_header[6]=0;

		
		if(SWAP_OUT ==MYTRUE)
		  {
			for(i=0;i<ADDF_HEADER_WDS;i++)
			out_header[i]= htonl(out_header[i]);
		  }

	/* chech to see if the file can be open for output */
		if ((out=fopen("out.file", "w")) == NULL)
	  	{
		printf("\n the output file can not be opened for output.\n");
		exit(1);
	 	 }

		fseek(out, 0, SEEK_SET);		
		fwrite(&out_header, ADDF_RECORD_LEN, 1, out);
		fclose(out);
	  }


	/* link to the subroutine	*/
	file_name=argv[1];
  	airs_sup_rdr(file_name, &airs_sup_gran); 	


	/* open the out file for writing */      
	if ((out=fopen("out.file", "r+"))== NULL)
	  {
		printf("\n the output file can not be opened for writing.\n");
		printf("stop running.\n");
		exit(1);
	  }


	/* read the output file header */
	fread(&out_header, ADDF_RECORD_LEN, 1, out);	

	/* initilize some para */
	out_record=out_header[2];

	/*data frame record */
	out_record++;
	frame_record = out_record;
	in_file_num = out_header[6] + 1;
	
/*
	printf("\n frame_record=%d\n",frame_record);
	printf("\n in_file_num=%d\n",in_file_num);
*/

/*
	printf("\ngranule number=%d\n",airs_sup_gran.granule_number);	
	printf("\nnum_scansets=%d\n",airs_sup_gran.num_scansets);	
	printf("\nnum_scanlines=%d\n",airs_sup_gran.num_scanlines);	
*/

	/* loop through all of the FOV. For each FOV, scale and copy the
	 data to the output buffer and write the buffer data to the output
	 file */			
	for (j=0; j<track; j++)
	  {
		for (i=0;i<xtrack; i++)
		  {
			for(np=0; np<ADDF_DATA_WDS;np++)
				buffer[np] = ISPV;
			
			nrecord++;
			buffer[0] = 0;
			buffer[3] = airs_sup_gran.Latitude[j][i] * 128 +0.5;
			buffer[4] = airs_sup_gran.Longitude[j][i] * 128+0.5; 	

			spot_time = airs_sup_gran.Time[j][i];
			convert_time (spot_time, &year, &mmdd, &hour, &mmss);
			buffer[5] = year;
			buffer[6] = mmdd;
			buffer[7] = hour;
			buffer[8] = mmss;

			buffer[9] = airs_sup_gran.granule_number;
			buffer[10] = airs_sup_gran.num_scansets;
			/* scan line */
			buffer[11] =  j+1; 
			/* spot in a scan line */
			buffer[12] = i+1; 
			for (k=0;k<6;k++)
			buffer[13+k] = airs_sup_gran.DayNightFlag[k];

			for (k=0;k<10;k++)
			buffer[19+k] = airs_sup_gran.node_type[k];

			buffer[29] = airs_sup_gran.topog[j][i]+0.5;
			buffer[30] = airs_sup_gran.topog_err[j][i]+0.5;
			buffer[31] = airs_sup_gran.landFrac[j][i] * 1000+0.5;
			buffer[32] = airs_sup_gran.landFrac_err[j][i] *1000+0.5;
			buffer[33] = airs_sup_gran.MWSurfClass[j][i];

			if(airs_sup_gran.solzen[j][i] != MISVAL)
			buffer[34] = airs_sup_gran.solzen[j][i]*100 +0.5;

/*	reserve for future	
			buffer[35-54] = -32768;
*/


			for (k=0;k<100; k++)
			{
			pobs[k] = airs_sup_gran.pressSupp[k];
			if(k<20)
			buffer[55+k] = airs_sup_gran.pressSupp[k] * 1000 +0.5;
			else
			buffer[55+k] = airs_sup_gran.pressSupp[k] * 10 + 0.5;
			}
			buffer[155] = airs_sup_gran.PSurfStd[j][i] * 10 +0.5;
			buffer[156] = airs_sup_gran.PSurfStd_QC[j][i];
			buffer[157] = airs_sup_gran.nSurfSup[j][i];
			buffer[158] = airs_sup_gran.PBest[j][i]*10 + 0.5;
			buffer[159] = airs_sup_gran.PGood[j][i]*10 + 0.5;
/*
			buffer[158] = airs_sup_gran.PBest[j][i]*10;
			buffer[159] = airs_sup_gran.PGood[j][i]*10;
*/
			buffer[160] = airs_sup_gran.nBestSup[j][i];
			buffer[161] = airs_sup_gran.nGoodSup[j][i];

			if(airs_sup_gran.TSurfStd[j][i] != MISVAL)
			buffer[162] = airs_sup_gran.TSurfStd[j][i]*64+0.5;

			if(airs_sup_gran.TSurfStd_QC[j][i] != MISVAL)
			buffer[163] = airs_sup_gran.TSurfStd_QC[j][i];

			if(airs_sup_gran.TSurfStdErr[j][i] != MISVAL)
			buffer[164] = airs_sup_gran.TSurfStdErr[j][i]*64+0.5;

/* reserve some spaces
 			buffer[165-169] = -32768;
*/

			for (k=0;k<100;k++)
			if(airs_sup_gran.TAirSup[j][i][k] != MISVAL)
			buffer[170+k] = airs_sup_gran.TAirSup[j][i][k]*64+0.5;

			for (k=0;k<100;k++)
			if(airs_sup_gran.TAirSup_QC[j][i][k] != MISVAL)
			buffer[270+k] = airs_sup_gran.TAirSup_QC[j][i][k];

			for (k=0;k<100;k++)
			if(airs_sup_gran.TAirSupErr[j][i][k] != MISVAL)
			buffer[370+k] = airs_sup_gran.TAirSupErr[j][i][k]*64+0.5;

			if(airs_sup_gran.TSurfAir[j][i] != MISVAL)
			buffer[470] = airs_sup_gran.TSurfAir[j][i]*64+0.5;

			if(airs_sup_gran.TSurfAir_QC[j][i] != MISVAL)
			buffer[471] = airs_sup_gran.TSurfAir_QC[j][i];

			if(airs_sup_gran.TSurfAirErr[j][i] != MISVAL)
			buffer[472] = airs_sup_gran.TSurfAirErr[j][i]*64+0.5;


/* place hold for temp kernal
  			buffer[473] = num_Temp_Func
			for (k=0;k<23;k++)
			if(airs_sup_gran.Temp_ave_kern[j][i][k] != MISVAL)
			buffer[474+k] = airs_sup_gran.Temp_ave_kern[j][i][k]*64;
			for (k=0;k<23;k++)
			if(airs_sup_gran.Temp_vertically[j][i][k] != MISVAL)
			buffer[497+k]=airs_sup_gran.Temp_vertically[j][i][k]*64;
			buffer[520] = Temp_dof;
*/ 

/* reserve spaces 
			buffer[521-525]= -32768;
*/
			if(airs_sup_gran.PTropopause[j][i] != MISVAL)
			buffer[526] = airs_sup_gran.PTropopause[j][i] * 10+0.5;
/*
			buffer[526] = airs_sup_gran.PTropopause[j][i] * 10;
*/

			if(airs_sup_gran.PTropopause_QC[j][i] != MISVAL)
			buffer[527] = airs_sup_gran.PTropopause_QC[j][i];

			if(airs_sup_gran.T_Tropopause[j][i] != MISVAL)
			buffer[528] = airs_sup_gran.T_Tropopause[j][i] * 64+0.5;

			if(airs_sup_gran.T_Tropopause_QC[j][i] != MISVAL)
			buffer[529] = airs_sup_gran.T_Tropopause_QC[j][i];

/* reserve space
			buffer[530-531] = -32768;
*/
			if(airs_sup_gran.totH2OStd[j][i] != MISVAL)
			buffer[532] = airs_sup_gran.totH2OStd[j][i] * 100+0.5;

			if(airs_sup_gran.totH2OStd_QC[j][i] != MISVAL)
			buffer[533] = airs_sup_gran.totH2OStd_QC[j][i];

			if(airs_sup_gran.totH2OStdErr[j][i] != MISVAL)
			buffer[534] = airs_sup_gran.totH2OStdErr[j][i] *100+0.5;


			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OCDSup[j][i][k] != MISVAL)
			{
			cden = airs_sup_gran.H2OCDSup[j][i][k];
			mxratio = cden_to_mr (cden, pobs, k);
			buffer[535+k] = log (mxratio) * 1024+0.5;
/*
	printf("\n cden_ori=%e\n",airs_sup_gran.H2OCDSup[j][i][k]);
	printf("\n cden=%f\n",mxratio);
*/
			}
			
			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OCDSup_QC[j][i][k] != MISVAL)
			buffer[635+k] = airs_sup_gran.H2OCDSup_QC[j][i][k];

			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OCDSupErr[j][i][k] != MISVAL)
			{
			cden = airs_sup_gran.H2OCDSupErr[j][i][k];
			mxratio = cden_to_mr (cden, pobs, k);
			buffer [735+k] = log (mxratio) * 1024+0.5;
			}

			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OMMRLevSup[j][i][k] != MISVAL)
			buffer[835+k] =airs_sup_gran.H2OMMRLevSup[j][i][k]*1000;

			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OMMRLevSup_QC[j][i][k] != MISVAL)
			buffer[935+k] =airs_sup_gran.H2OMMRLevSup_QC[j][i][k];

			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OMMRLevSupErr[j][i][k] != MISVAL)
			buffer[1035+k] =airs_sup_gran.H2OMMRLevSupErr[j][i][k]*1000+0.5;

			if(airs_sup_gran.H2OMMRSurf[j][i]!= MISVAL)
			buffer[1135] =airs_sup_gran.H2OMMRSurf[j][i]*1000+0.5;

			if(airs_sup_gran.H2OMMRSurf_QC[j][i]!= MISVAL)
			buffer[1136] =airs_sup_gran.H2OMMRSurf_QC[j][i];

			if(airs_sup_gran.H2OMMRSurfErr[j][i]!= MISVAL)
			buffer[1137] =airs_sup_gran.H2OMMRSurfErr[j][i]*1000+0.5;
/* place hold 
			buffer[1138] = num_H2O_Func;
			buffer[1139+10] = H2O_eff_press;
			buffer[1150+10] = H2O_VMR_eff;
			buffer[1161+10] =H2O_VMR_eff_QC;
			buffer[1172+10] = H2O_VMR_eff_err;
			buffer[1183+10] = H2O_vertically;
			buffer[1194] = H2O_dof;
			buffer[1195+10] = H2O_ave_kern; 
*/

/* reserve space 
			buffer[1206-1215] = -32768
*/

		for (k=0;k<15;k++)
                if(airs_sup_gran.RelHum[j][i][k] != MISVAL)
                buffer[1216+k] = airs_sup_gran.RelHum[j][i][k]*100+0.5;

		for (k=0;k<15;k++)
                if(airs_sup_gran.RelHum_QC[j][i][k] != MISVAL)
                buffer[1231+k] = airs_sup_gran.RelHum_QC[j][i][k];

                if(airs_sup_gran.RelHumSurf[j][i] != MISVAL)
                buffer[1246] = airs_sup_gran.RelHumSurf[j][i]*100+0.5;

                if(airs_sup_gran.RelHumSurf_QC[j][i] != MISVAL)
                buffer[1247] = airs_sup_gran.RelHumSurf_QC[j][i];

		for (k=0;k<15;k++)
                if(airs_sup_gran.RelHum_liquid[j][i][k] != MISVAL)
                buffer[1248+k] = airs_sup_gran.RelHum_liquid[j][i][k]*100+0.5;

		for (k=0;k<15;k++)
                if(airs_sup_gran.RelHum_liquid_QC[j][i][k] != MISVAL)
                buffer[1263+k] = airs_sup_gran.RelHum_liquid_QC[j][i][k];

                if(airs_sup_gran.RelHumSurf_liquid[j][i] != MISVAL)
                buffer[1278] = airs_sup_gran.RelHumSurf_liquid[j][i]*100+0.5;

                if(airs_sup_gran.RelHumSurf_liquid_QC[j][i] != MISVAL)
                buffer[1279] = airs_sup_gran.RelHumSurf_liquid_QC[j][i];

			if(airs_sup_gran.bndry_lyr_top[j][i] != MISVAL)
                        buffer[1280] = airs_sup_gran.bndry_lyr_top[j][i]*10+0.5;

			if(airs_sup_gran.bndry_lyr_top_QC[j][i] != MISVAL)
                        buffer[1281] = airs_sup_gran.bndry_lyr_top_QC[j][i];

		 	if(airs_sup_gran.GP_Tropopause[j][i] != MISVAL)
                        buffer[1282] = airs_sup_gran.GP_Tropopause[j][i] + 0.5;

			if(airs_sup_gran.GP_Tropopause_QC[j][i] != MISVAL)
                        buffer[1283] = airs_sup_gran.GP_Tropopause_QC[j][i];

		for (k=0;k<100;k++)
                if(airs_sup_gran.GP_HeightSup[j][i][k] != MISVAL)
                {
                buffer[1284+k] = airs_sup_gran.GP_HeightSup[j][i][k] -32760;
                }

		for (k=0;k<100;k++)
                if(airs_sup_gran.GP_HeightSup_QC[j][i][k] != MISVAL)
                buffer[1384+k] = airs_sup_gran.GP_HeightSup_QC[j][i][k];

		if(airs_sup_gran.GP_Surface[j][i] != MISVAL)
                buffer[1484] = airs_sup_gran.GP_Surface[j][i] + 0.5;

                if(airs_sup_gran.GP_Surface_QC[j][i] != MISVAL)
                buffer[1485] = airs_sup_gran.GP_Surface_QC[j][i];



/* reserve space
			buffer[1486-1490] = -32767;
*/

		if(airs_sup_gran.CldFrcTot[j][i] != MISVAL)
		buffer[1491] = airs_sup_gran.CldFrcTot[j][i]*1000+0.5;

		if(airs_sup_gran.CldFrcTot_QC[j][i] != MISVAL)
		buffer[1492] = airs_sup_gran.CldFrcTot_QC[j][i];

		if(airs_sup_gran.numCloud[j][i] != MISVAL)
		buffer[1493] = airs_sup_gran.numCloud[j][i];

		for (k=0;k<2;k++)
		if(airs_sup_gran.TCldTopStd[j][i][k] != MISVAL)
		buffer[1494+k] = airs_sup_gran.TCldTopStd[j][i][k] *64+0.5;


		for (k=0;k<2;k++)
		if(airs_sup_gran.TCldTopStd_QC[j][i][k] != MISVAL)
		{
		buffer[1496+k] = airs_sup_gran.TCldTopStd_QC[j][i][k];
		}

		for (k=0;k<2;k++)
		if(airs_sup_gran.PCldTopStd[j][i][k] != MISVAL)
		{
		buffer[1498+k] = airs_sup_gran.PCldTopStd[j][i][k] *10+0.5;
		}

		for (k=0;k<2;k++)
		if(airs_sup_gran.PCldTopStd[j][i][k] != MISVAL)
		{
		buffer[1500+k] = airs_sup_gran.PCldTopStd_QC[j][i][k];
		}

		/* bomin add 9 fov cloud fract for FOR cloud fra aug 2 2013 */
		for (k=0;k<2;k++)
		{
		num_fov=0;
        	cf_tot=0;
        	for (j0=0;j0<3;j0++)
        	for (i0=0;i0<3;i0++)
                	if(airs_sup_gran.CldFrcStd[j][i][j0][i0][k] != MISVAL)
			{
			 num_fov=num_fov+1;
       			 cf_tot=cf_tot+airs_sup_gran.CldFrcStd[j][i][i0][j0][k];
        		}
		if (num_fov >0)
		{
			cf_tot = cf_tot/num_fov;
                	buffer[1502+k] = cf_tot*1000+0.5;
		}
		if (num_fov ==0)
		{
                	buffer[1502+k] = ISPV;
		}
		}


/*
		for (k=0;k<2;k++)
		if(airs_sup_gran.CldFrcStd[j][i][1][1][k] != MISVAL)
		{
		buffer[1502+k] = airs_sup_gran.CldFrcStd[j][i][1][1][k]*1000;
		}
*/

		for (k=0;k<2;k++)
		if(airs_sup_gran.CldFrcStd_QC[j][i][1][1][k] != MISVAL)
		{
		buffer[1504+k] = airs_sup_gran.CldFrcStd_QC[j][i][1][1][k];
		}

/* reserve space
		buffer[1506-1509] = -32768;
*/
		if(airs_sup_gran.demgeoqa[j][i] != MISVAL)
		buffer[1510] = log(airs_sup_gran.demgeoqa[j][i]*1.)/log(2.0);

		if(airs_sup_gran.all_spots_avg[j][i] != MISVAL)
		buffer[1511] = airs_sup_gran.all_spots_avg[j][i];

		if(airs_sup_gran.retrieval_type[j][i] != MISVAL)
		buffer[1512] = airs_sup_gran.retrieval_type[j][i];

		if(airs_sup_gran.SurfClass[j][i] != MISVAL)
		buffer[1513] = airs_sup_gran.SurfClass[j][i];


/*   reserve space 
		buffer[1514] = -32768;
*/
		for (k=0;k<100;k++)
		if(airs_sup_gran.TAirMWOnly[j][i][k] != MISVAL)
		buffer[1515+k] = airs_sup_gran.TAirMWOnly[j][i][k] * 64+0.5;

		for (k=0;k<100;k++)
		if(airs_sup_gran.TAirMWOnly_QC[j][i][k] != MISVAL)
		buffer[1615+k] = airs_sup_gran.TAirMWOnly_QC[j][i][k] * 64+0.5;

/* place hold or reserve a space
 		buffer[1715] = MWSurfClass
*/

		if(airs_sup_gran.totH2OMWOnlyStd[j][i] != MISVAL)
		buffer[1716] = airs_sup_gran.totH2OMWOnlyStd[j][i] * 100+0.5;

		if(airs_sup_gran.totH2OMWOnlyStd_QC[j][i] != MISVAL)
		buffer[1717] = airs_sup_gran.totH2OMWOnlyStd_QC[j][i];

		for(k=0;k<100;k++)
		if(airs_sup_gran.H2OCDMWOnly[j][i][k] != MISVAL)
		{
		cden = airs_sup_gran.H2OCDMWOnly[j][i][k];
		mxratio = cden_to_mr (cden, pobs, k);
		buffer [1718+k] = log (mxratio) * 1024+0.5;
		}

		for(k=0;k<100;k++)
		if(airs_sup_gran.H2OCDMWOnly_QC[j][i][k] != MISVAL)
		buffer[1818+k] = airs_sup_gran.H2OCDMWOnly_QC[j][i][k];

		if(airs_sup_gran.TSurf1Ret[j][i] != MISVAL)
		buffer[1918] = airs_sup_gran.TSurf1Ret[j][i] * 64+0.5;

		if(airs_sup_gran.TSurfAir1Ret[j][i] != MISVAL)
		buffer[1919] = airs_sup_gran.TSurfAir1Ret[j][i] * 64+0.5;

		for (k=0;k<100;k++)
		if(airs_sup_gran.TAir1Ret[j][i][k] != MISVAL)
		buffer[1920+k] = airs_sup_gran.TAir1Ret[j][i][k] * 64+0.5;

		for (k=0;k<100;k++)
		if(airs_sup_gran.H2OCD1Ret[j][i][k] != MISVAL)
		{
		cden = airs_sup_gran.H2OCD1Ret[j][i][k];
		mxratio = cden_to_mr (cden, pobs, k);
		buffer[2020+k] = log (mxratio) * 1024+0.5;
		}





		/* write the data buffer to the output file */
			out_record++;
			offset = (out_record - 1) * ADDF_RECORD_LEN;
			fseek(out, offset, SEEK_SET);
			fwrite(&buffer, ADDF_RECORD_LEN, 1, out);
		  }
	  }	  	

/*	printf("\nout_record=%d\n",out_record);	*/

	/* write the data frame */
	for (i=0; i<ADDF_DATA_WDS; i++)
		buffer[i] = ISPV;
	
	buffer[0] = 3;
	buffer[1] = in_file_num;
	buffer[2] = nrecord;       

	buffer[4] = airs_sup_gran.Latitude[0][0] * 128+0.5; 
	buffer[5] = airs_sup_gran.Latitude[0][xtrack-1] * 128+0.5; 
	buffer[6] = airs_sup_gran.Latitude[track-1][xtrack-1] * 128+0.5; 
	buffer[7] = airs_sup_gran.Latitude[track-1][0] * 128+0.5; 
	buffer[8] = airs_sup_gran.Longitude[0][0] * 128+0.5; 
	buffer[9] = airs_sup_gran.Longitude[0][xtrack-1] * 128+0.5; 
	buffer[10] = airs_sup_gran.Longitude[track-1][xtrack-1] * 128+0.5; 
	buffer[11] = airs_sup_gran.Longitude[track-1][0] * 128+0.5; 



	/* write the frame buffer to the output file */
/*	printf("\n frame_record=%d\n",frame_record);	*/
	offset = (frame_record - 1) * ADDF_RECORD_LEN;
	fseek(out, offset, SEEK_SET);
	fwrite(&buffer, ADDF_RECORD_LEN, 1, out);

	/* obtain the current time */
	time(&date_time);
	ts = localtime(&date_time);
	month = ts->tm_mon + 1;
	day = ts->tm_mday;
	year = ts->tm_year + 1900;
	yyyymmdd = year * 10000 + month * 100 + day; 

	/* update the header records */
	out_header[2] = out_record;
	out_header[5] = yyyymmdd;
	out_header[6] = in_file_num;
	
	/* write the header buffer to the output file */
	fseek(out, 0, SEEK_SET);
	fwrite(&out_header, ADDF_RECORD_LEN, 1, out);
	fclose(out);

}


