#include <stdio.h>
#include <stdlib.h>
#include "hdf.h"        /* defines int32, intn, etc. */
#include "HdfEosDef.h"  /* declares SWopen(), etc. */
#include "airs_sup_typ.h"
#include "airs_sup_struct.h"


/*
   Updated for V6 by Feng Ding in January 2013 

 * This function is autogenerated by the mkezio program to read
 * an AIRS swath of type "L2_Support_atmospheric&surface_product" from file given by the
 * file_name argument into a buffer pointed to by the airs_sup_gran
 * argument.  The caller owns the buffer.  The entire granule
 * is read -- every attribute and field, the whole lat/lon/time
 * extent.
 *
 * Errors opening the file, etc. are fatal and cause exit(EXIT_FAILURE).
 * Problems reading individual attributes or fields are reported to
 * the console but do not interrupt program flow.
 */
void airs_sup_rdr(
      char * file_name,     /* name of file to read */
      airs_sup_gran_t * airs_sup_gran ) /* structured buffer to hold entire granule */
{
  intn statn;            /* HDF-EOS status. 0 for success */
  int32 fid;             /* HDF-EOS file ID */
  int32 swid;            /* HDF-EOS swath ID */
  int32 nchar;           /* Number of characters */
  char swathname[256];   /* Name of swath */
  int nswath;            /* Number of swaths */
  char * cp = 0;         /* pointer to start of version # in file name */
  int major = 0, minor = 0, patch = 0, subpatch = 0;
                         /* parts of version number */

  /* Figure out version from file name */

  /* skip past directories if full path is present */
  cp = strrchr(file_name, '/');
  if (!cp) cp = file_name;

  /*
   * File will look more or less like:
   *   AIRS.2002.09.06.125.L1B.AIRS_Rad.v4.0.6.0.PGE_Verify.T04352025159.hdf
   */
  cp = strstr(cp, ".v");

  if (cp) {
    int nscanned = sscanf(cp, ".v%d.%d.%d.%d",
                         &major, &minor, &patch, &subpatch);
    if (nscanned != 4)
      printf("Failed to get version from file name %s starting at %s\n",
                    file_name, cp);
  } else {
    printf("Failed to get version from file name %s\n", file_name);
    printf("so version number cannot be checked.\n\n");
  }

  /* if we did get a version number, check it */
  if (major + minor + patch + subpatch) {
    if (major != 6 || minor != 0 || patch != 7 || subpatch != 0) {
      printf("Warning: airs_sup file read is version %d.%d.%d.%d ",
             major, minor, patch, subpatch);
      printf("but reader is designed for 6.0.7.0\n");
    }
  }

  /* Clear granule structure */
  memset(airs_sup_gran, 0, sizeof(airs_sup_gran));

  fid = SWopen(file_name, DFACC_READ);
  if (fid <= 0) {
    printf("Error %ld opening file %s\n", (long)fid, file_name);
    exit(EXIT_FAILURE);
  }

  /* Get name of swath(s) */
  nswath = SWinqswath(file_name, swathname, &nchar);
  if (nswath != 1) {
    printf("SWinqswath found %d swaths for file \"%s\".  Need exactly 1\n", nswath, file_name);
    exit(EXIT_FAILURE);
  }

  /* There's exactly one swath.  Make sure it is the right one. */
  if (strcmp(swathname, "L2_Support_atmospheric&surface_product")) {
    printf("Error: bad swath name \"%s\" in file \"%s\"\n", swathname, file_name);
    printf("Expected \"L2_Support_atmospheric&surface_product\"\n");
    exit(EXIT_FAILURE);
  }

  /* Attach to (open) the one swath. */
  swid = SWattach(fid, swathname);
  if (swid <= 0) {
    printf("Failed to attach to swath \"%s\" in file %s\n", swathname, file_name);
    exit(EXIT_FAILURE);
  }

  /* Attributes */
  statn = SWreadattr(swid, "processing_level",
		(void *)airs_sup_gran->processing_level);
  if (statn != 0)
    printf("Error %d reading attribute processing_level\n", statn);

  statn = SWreadattr(swid, "instrument",
		(void *)airs_sup_gran->instrument);
  if (statn != 0)
    printf("Error %d reading attribute instrument\n", statn);

  statn = SWreadattr(swid, "DayNightFlag",
		(void *)airs_sup_gran->DayNightFlag);
  if (statn != 0)
    printf("Error %d reading attribute DayNightFlag\n", statn);

  statn = SWreadattr(swid, "AutomaticQAFlag",
		(void *)airs_sup_gran->AutomaticQAFlag);
  if (statn != 0)
    printf("Error %d reading attribute AutomaticQAFlag\n", statn);

  statn = SWreadattr(swid, "NumTotalData",
		(void *)&airs_sup_gran->NumTotalData);
  if (statn != 0)
    printf("Error %d reading attribute NumTotalData\n", statn);

  statn = SWreadattr(swid, "NumProcessData",
		(void *)&airs_sup_gran->NumProcessData);
  if (statn != 0)
    printf("Error %d reading attribute NumProcessData\n", statn);

  statn = SWreadattr(swid, "NumSpecialData",
		(void *)&airs_sup_gran->NumSpecialData);
  if (statn != 0)
    printf("Error %d reading attribute NumSpecialData\n", statn);

  statn = SWreadattr(swid, "NumBadData",
		(void *)&airs_sup_gran->NumBadData);
  if (statn != 0)
    printf("Error %d reading attribute NumBadData\n", statn);

  statn = SWreadattr(swid, "NumMissingData",
		(void *)&airs_sup_gran->NumMissingData);
  if (statn != 0)
    printf("Error %d reading attribute NumMissingData\n", statn);

  statn = SWreadattr(swid, "NumLandSurface",
		(void *)&airs_sup_gran->NumLandSurface);
  if (statn != 0)
    printf("Error %d reading attribute NumLandSurface\n", statn);

  statn = SWreadattr(swid, "NumOceanSurface",
		(void *)&airs_sup_gran->NumOceanSurface);
  if (statn != 0)
    printf("Error %d reading attribute NumOceanSurface\n", statn);

  statn = SWreadattr(swid, "node_type",
		(void *)airs_sup_gran->node_type);
  if (statn != 0)
    printf("Error %d reading attribute node_type\n", statn);

  statn = SWreadattr(swid, "start_year",
		(void *)&airs_sup_gran->start_year);
  if (statn != 0)
    printf("Error %d reading attribute start_year\n", statn);

  statn = SWreadattr(swid, "start_month",
		(void *)&airs_sup_gran->start_month);
  if (statn != 0)
    printf("Error %d reading attribute start_month\n", statn);

  statn = SWreadattr(swid, "start_day",
		(void *)&airs_sup_gran->start_day);
  if (statn != 0)
    printf("Error %d reading attribute start_day\n", statn);

  statn = SWreadattr(swid, "start_hour",
		(void *)&airs_sup_gran->start_hour);
  if (statn != 0)
    printf("Error %d reading attribute start_hour\n", statn);

  statn = SWreadattr(swid, "start_minute",
		(void *)&airs_sup_gran->start_minute);
  if (statn != 0)
    printf("Error %d reading attribute start_minute\n", statn);

  statn = SWreadattr(swid, "start_sec",
		(void *)&airs_sup_gran->start_sec);
  if (statn != 0)
    printf("Error %d reading attribute start_sec\n", statn);

  statn = SWreadattr(swid, "start_orbit",
		(void *)&airs_sup_gran->start_orbit);
  if (statn != 0)
    printf("Error %d reading attribute start_orbit\n", statn);

  statn = SWreadattr(swid, "end_orbit",
		(void *)&airs_sup_gran->end_orbit);
  if (statn != 0)
    printf("Error %d reading attribute end_orbit\n", statn);

  statn = SWreadattr(swid, "orbit_path",
		(void *)&airs_sup_gran->orbit_path);
  if (statn != 0)
    printf("Error %d reading attribute orbit_path\n", statn);

  statn = SWreadattr(swid, "start_orbit_row",
		(void *)&airs_sup_gran->start_orbit_row);
  if (statn != 0)
    printf("Error %d reading attribute start_orbit_row\n", statn);

  statn = SWreadattr(swid, "end_orbit_row",
		(void *)&airs_sup_gran->end_orbit_row);
  if (statn != 0)
    printf("Error %d reading attribute end_orbit_row\n", statn);

  statn = SWreadattr(swid, "granule_number",
		(void *)&airs_sup_gran->granule_number);
  if (statn != 0)
    printf("Error %d reading attribute granule_number\n", statn);

  statn = SWreadattr(swid, "num_scansets",
		(void *)&airs_sup_gran->num_scansets);
  if (statn != 0)
    printf("Error %d reading attribute num_scansets\n", statn);

  statn = SWreadattr(swid, "num_scanlines",
		(void *)&airs_sup_gran->num_scanlines);
  if (statn != 0)
    printf("Error %d reading attribute num_scanlines\n", statn);

  statn = SWreadattr(swid, "start_Latitude",
		(void *)&airs_sup_gran->start_Latitude);
  if (statn != 0)
    printf("Error %d reading attribute start_Latitude\n", statn);

  statn = SWreadattr(swid, "start_Longitude",
		(void *)&airs_sup_gran->start_Longitude);
  if (statn != 0)
    printf("Error %d reading attribute start_Longitude\n", statn);

  statn = SWreadattr(swid, "start_Time",
		(void *)&airs_sup_gran->start_Time);
  if (statn != 0)
    printf("Error %d reading attribute start_Time\n", statn);

  statn = SWreadattr(swid, "end_Latitude",
		(void *)&airs_sup_gran->end_Latitude);
  if (statn != 0)
    printf("Error %d reading attribute end_Latitude\n", statn);

  statn = SWreadattr(swid, "end_Longitude",
		(void *)&airs_sup_gran->end_Longitude);
  if (statn != 0)
    printf("Error %d reading attribute end_Longitude\n", statn);

  statn = SWreadattr(swid, "end_Time",
		(void *)&airs_sup_gran->end_Time);
  if (statn != 0)
    printf("Error %d reading attribute end_Time\n", statn);

  statn = SWreadattr(swid, "eq_x_longitude",
		(void *)&airs_sup_gran->eq_x_longitude);
  if (statn != 0)
    printf("Error %d reading attribute eq_x_longitude\n", statn);

  statn = SWreadattr(swid, "eq_x_tai",
		(void *)&airs_sup_gran->eq_x_tai);
  if (statn != 0)
    printf("Error %d reading attribute eq_x_tai\n", statn);
    
  statn = SWreadattr(swid, "LonGranuleCen",
		(void *)&airs_sup_gran->LonGranuleCen);
  if (statn != 0)
    printf("Error %d reading attribute LonGranuleCen\n", statn);

  statn = SWreadattr(swid, "LatGranuleCen",
		(void *)&airs_sup_gran->LatGranuleCen);
  if (statn != 0)
    printf("Error %d reading attribute LatGranuleCen\n", statn);

  statn = SWreadattr(swid, "LocTimeGranuleCen",
		(void *)&airs_sup_gran->LocTimeGranuleCen);
  if (statn != 0)
    printf("Error %d reading attribute LocTimeGranuleCen\n", statn);

  statn = SWreadattr(swid, "num_fpe",
		(void *)&airs_sup_gran->num_fpe);
  if (statn != 0)
    printf("Error %d reading attribute num_fpe\n", statn);

  statn = SWreadattr(swid, "orbitgeoqa",
		(void *)&airs_sup_gran->orbitgeoqa);
  if (statn != 0)
    printf("Error %d reading attribute orbitgeoqa\n", statn);

  statn = SWreadattr(swid, "num_satgeoqa",
		(void *)&airs_sup_gran->num_satgeoqa);
  if (statn != 0)
    printf("Error %d reading attribute num_satgeoqa\n", statn);

  statn = SWreadattr(swid, "num_glintgeoqa",
		(void *)&airs_sup_gran->num_glintgeoqa);
  if (statn != 0)
    printf("Error %d reading attribute num_glintgeoqa\n", statn);

  statn = SWreadattr(swid, "num_moongeoqa",
		(void *)&airs_sup_gran->num_moongeoqa);
  if (statn != 0)
    printf("Error %d reading attribute num_moongeoqa\n", statn);

  statn = SWreadattr(swid, "num_ftptgeoqa",
		(void *)&airs_sup_gran->num_ftptgeoqa);
  if (statn != 0)
    printf("Error %d reading attribute num_ftptgeoqa\n", statn);

  statn = SWreadattr(swid, "num_zengeoqa",
		(void *)&airs_sup_gran->num_zengeoqa);
  if (statn != 0)
    printf("Error %d reading attribute num_zengeoqa\n", statn);

  statn = SWreadattr(swid, "num_demgeoqa",
		(void *)&airs_sup_gran->num_demgeoqa);
  if (statn != 0)
    printf("Error %d reading attribute num_demgeoqa\n", statn);
    
  statn = SWreadattr(swid, "NumSO2FOVs",
		(void *)&airs_sup_gran->NumSO2FOVs);
  if (statn != 0)
    printf("Error %d reading attribute NumSO2FOVs\n", statn);

  statn = SWreadattr(swid, "CO_first_guess",
		(void *)airs_sup_gran->CO_first_guess);
  if (statn != 0)
    printf("Error %d reading attribute CO_first_guess\n", statn);

  statn = SWreadattr(swid, "CH4_first_guess",
		(void *)airs_sup_gran->CH4_first_guess);
  if (statn != 0)
    printf("Error %d reading attribute CH4_first_guess\n", statn);

  statn = SWreadattr(swid, "numHingeSurfInit",
		(void *)&airs_sup_gran->numHingeSurfInit);
  if (statn != 0)
    printf("Error %d reading attribute numHingeSurfInit\n", statn);

  statn = SWreadattr(swid, "nFOV_big_ang_adj",
		(void *)&airs_sup_gran->nFOV_big_ang_adj);
  if (statn != 0)
    printf("Error %d reading attribute nFOV_big_ang_adj\n", statn);

  statn = SWreadattr(swid, "num_retrieval_type_000",
		(void *)&airs_sup_gran->num_retrieval_type_000);
  if (statn != 0)
    printf("Error %d reading attribute num_retrieval_type_000\n", statn);

  statn = SWreadattr(swid, "num_retrieval_type_010",
		(void *)&airs_sup_gran->num_retrieval_type_010);
  if (statn != 0)
    printf("Error %d reading attribute num_retrieval_type_010\n", statn);

  statn = SWreadattr(swid, "num_retrieval_type_020",
		(void *)&airs_sup_gran->num_retrieval_type_020);
  if (statn != 0)
    printf("Error %d reading attribute num_retrieval_type_020\n", statn);

  statn = SWreadattr(swid, "num_retrieval_type_030",
		(void *)&airs_sup_gran->num_retrieval_type_030);
  if (statn != 0)
    printf("Error %d reading attribute num_retrieval_type_030\n", statn);

  statn = SWreadattr(swid, "num_retrieval_type_040",
		(void *)&airs_sup_gran->num_retrieval_type_040);
  if (statn != 0)
    printf("Error %d reading attribute num_retrieval_type_040\n", statn);

  statn = SWreadattr(swid, "num_retrieval_type_050",
		(void *)&airs_sup_gran->num_retrieval_type_050);
  if (statn != 0)
    printf("Error %d reading attribute num_retrieval_type_050\n", statn);

  statn = SWreadattr(swid, "num_retrieval_type_100",
		(void *)&airs_sup_gran->num_retrieval_type_100);
  if (statn != 0)
    printf("Error %d reading attribute num_retrieval_type_100\n", statn);

  statn = SWreadattr(swid, "NumMWStratIrRetOnly",
		(void *)&airs_sup_gran->NumMWStratIrRetOnly);
  if (statn != 0)
    printf("Error %d reading attribute NumMWStratIrRetOnly\n", statn);

  statn = SWreadattr(swid, "NumNoHSB",
		(void *)&airs_sup_gran->NumNoHSB);
  if (statn != 0)
    printf("Error %d reading attribute NumNoHSB\n", statn);

  statn = SWreadattr(swid, "NumNoAMSUA",
		(void *)&airs_sup_gran->NumNoAMSUA);
  if (statn != 0)
    printf("Error %d reading attribute NumNoAMSUA\n", statn);

  statn = SWreadattr(swid, "NumNoAIRS",
		(void *)&airs_sup_gran->NumNoAIRS);
  if (statn != 0)
    printf("Error %d reading attribute NumNoAIRS\n", statn);

  statn = SWreadattr(swid, "NumNoVis",
		(void *)&airs_sup_gran->NumNoVis);
  if (statn != 0)
    printf("Error %d reading attribute NumNoVis\n", statn);

  statn = SWreadattr(swid, "DCRCount",
		(void *)&airs_sup_gran->DCRCount);
  if (statn != 0)
    printf("Error %d reading attribute DCRCount\n", statn);

  statn = SWreadattr(swid, "PopCount",
		(void *)&airs_sup_gran->PopCount);
  if (statn != 0)
    printf("Error %d reading attribute PopCount\n", statn);

  statn = SWreadattr(swid, "MoonInViewMWCount",
		(void *)&airs_sup_gran->MoonInViewMWCount);
  if (statn != 0)
    printf("Error %d reading attribute MoonInViewMWCount\n", statn);


  /* Geolocation fields */
  statn = SWreadfield(swid, "Latitude", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Latitude[0][0]);
  if (statn != 0)
    printf("Error %d reading field Latitude\n", statn);

  statn = SWreadfield(swid, "Longitude", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Longitude[0][0]);
  if (statn != 0)
    printf("Error %d reading field Longitude\n", statn);

  statn = SWreadfield(swid, "Time", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Time[0][0]);
  if (statn != 0)
    printf("Error %d reading field Time\n", statn);


  /* Data Fields */
  statn = SWreadfield(swid, "satheight", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satheight[0]);
  if (statn != 0)
    printf("Error %d reading field satheight\n", statn);

  statn = SWreadfield(swid, "satroll", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satroll[0]);
  if (statn != 0)
    printf("Error %d reading field satroll\n", statn);

  statn = SWreadfield(swid, "satpitch", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satpitch[0]);
  if (statn != 0)
    printf("Error %d reading field satpitch\n", statn);

  statn = SWreadfield(swid, "satyaw", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satyaw[0]);
  if (statn != 0)
    printf("Error %d reading field satyaw\n", statn);

  statn = SWreadfield(swid, "satzen", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satzen[0][0]);
  if (statn != 0)
    printf("Error %d reading field satzen\n", statn);

  statn = SWreadfield(swid, "satazi", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satazi[0][0]);
  if (statn != 0)
    printf("Error %d reading field satazi\n", statn);

  statn = SWreadfield(swid, "solzen", NULL, NULL, NULL,
		(void *)&airs_sup_gran->solzen[0][0]);
  if (statn != 0)
    printf("Error %d reading field solzen\n", statn);

  statn = SWreadfield(swid, "solazi", NULL, NULL, NULL,
		(void *)&airs_sup_gran->solazi[0][0]);
  if (statn != 0)
    printf("Error %d reading field solazi\n", statn);

  statn = SWreadfield(swid, "glintlat", NULL, NULL, NULL,
		(void *)&airs_sup_gran->glintlat[0]);
  if (statn != 0)
    printf("Error %d reading field glintlat\n", statn);

  statn = SWreadfield(swid, "glintlon", NULL, NULL, NULL,
		(void *)&airs_sup_gran->glintlon[0]);
  if (statn != 0)
    printf("Error %d reading field glintlon\n", statn);

  statn = SWreadfield(swid, "sun_glint_distance", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sun_glint_distance[0][0]);
  if (statn != 0)
    printf("Error %d reading field sun_glint_distance\n", statn);

  statn = SWreadfield(swid, "nadirTAI", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nadirTAI[0]);
  if (statn != 0)
    printf("Error %d reading field nadirTAI\n", statn);

  statn = SWreadfield(swid, "sat_lat", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sat_lat[0]);
  if (statn != 0)
    printf("Error %d reading field sat_lat\n", statn);

  statn = SWreadfield(swid, "sat_lon", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sat_lon[0]);
  if (statn != 0)
    printf("Error %d reading field sat_lon\n", statn);

  statn = SWreadfield(swid, "scan_node_type", NULL, NULL, NULL,
		(void *)&airs_sup_gran->scan_node_type[0]);
  if (statn != 0)
    printf("Error %d reading field scan_node_type\n", statn);

  statn = SWreadfield(swid, "topog", NULL, NULL, NULL,
		(void *)&airs_sup_gran->topog[0][0]);
  if (statn != 0)
    printf("Error %d reading field topog\n", statn);

  statn = SWreadfield(swid, "topog_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->topog_err[0][0]);
  if (statn != 0)
    printf("Error %d reading field topog_err\n", statn);

  statn = SWreadfield(swid, "landFrac", NULL, NULL, NULL,
		(void *)&airs_sup_gran->landFrac[0][0]);
  if (statn != 0)
    printf("Error %d reading field landFrac\n", statn);

  statn = SWreadfield(swid, "landFrac_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->landFrac_err[0][0]);
  if (statn != 0)
    printf("Error %d reading field landFrac_err\n", statn);

  statn = SWreadfield(swid, "satgeoqa", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satgeoqa[0]);
  if (statn != 0)
    printf("Error %d reading field satgeoqa\n", statn);

  statn = SWreadfield(swid, "glintgeoqa", NULL, NULL, NULL,
		(void *)&airs_sup_gran->glintgeoqa[0]);
  if (statn != 0)
    printf("Error %d reading field glintgeoqa\n", statn);

  statn = SWreadfield(swid, "moongeoqa", NULL, NULL, NULL,
		(void *)&airs_sup_gran->moongeoqa[0]);
  if (statn != 0)
    printf("Error %d reading field moongeoqa\n", statn);

  statn = SWreadfield(swid, "latAIRS", NULL, NULL, NULL,
		(void *)&airs_sup_gran->latAIRS[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field latAIRS\n", statn);

  statn = SWreadfield(swid, "lonAIRS", NULL, NULL, NULL,
		(void *)&airs_sup_gran->lonAIRS[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field lonAIRS\n", statn);

  statn = SWreadfield(swid, "pressSupp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->pressSupp[0]);
  if (statn != 0)
    printf("Error %d reading field pressSupp\n", statn);

  statn = SWreadfield(swid, "pressStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->pressStd[0]);
  if (statn != 0)
    printf("Error %d reading field pressStd\n", statn);

  statn = SWreadfield(swid, "PSurfStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PSurfStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field PSurfStd\n", statn);

  statn = SWreadfield(swid, "PSurfStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PSurfStd_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field PSurfStd_QC\n", statn);

  statn = SWreadfield(swid, "nSurfSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nSurfSup[0][0]);
  if (statn != 0)
    printf("Error %d reading field nSurfSup\n", statn);

  statn = SWreadfield(swid, "nSurfStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nSurfStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field nSurfStd\n", statn);

  statn = SWreadfield(swid, "dust_flag", NULL, NULL, NULL,
		(void *)&airs_sup_gran->dust_flag[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field dust_flag\n", statn);

  statn = SWreadfield(swid, "dust_score", NULL, NULL, NULL,
		(void *)&airs_sup_gran->dust_score[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field dust_score\n", statn);

  statn = SWreadfield(swid, "BT_diff_SO2", NULL, NULL, NULL,
		(void *)&airs_sup_gran->BT_diff_SO2[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field BT_diff_SO2\n", statn);

  statn = SWreadfield(swid, "BT_diff_SO2_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->BT_diff_SO2_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field BT_diff_SO2_QC\n", statn);

  statn = SWreadfield(swid, "cloud_phase_3x3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cloud_phase_3x3[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field cloud_phase_3x3\n", statn);

  statn = SWreadfield(swid, "cloud_phase_bits", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cloud_phase_bits[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field cloud_phase_bits\n", statn);

  statn = SWreadfield(swid, "PBest", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PBest[0][0]);
  if (statn != 0)
    printf("Error %d reading field PBest\n", statn);

  statn = SWreadfield(swid, "PGood", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PGood[0][0]);
  if (statn != 0)
    printf("Error %d reading field PGood\n", statn);

  statn = SWreadfield(swid, "nBestSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nBestSup[0][0]);
  if (statn != 0)
    printf("Error %d reading field nBestSup\n", statn);

  statn = SWreadfield(swid, "nGoodSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nGoodSup[0][0]);
  if (statn != 0)
    printf("Error %d reading field nGoodSup\n", statn);

  statn = SWreadfield(swid, "nBestStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nBestStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field nBestStd\n", statn);

  statn = SWreadfield(swid, "nGoodStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nGoodStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field nGoodStd\n", statn);

  statn = SWreadfield(swid, "TSurfStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfStd\n", statn);

  statn = SWreadfield(swid, "TSurfStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfStd_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfStd_QC\n", statn);

  statn = SWreadfield(swid, "TSurfStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfStdErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfStdErr\n", statn);

  statn = SWreadfield(swid, "numHingeSurf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->numHingeSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field numHingeSurf\n", statn);

  statn = SWreadfield(swid, "freqEmis", NULL, NULL, NULL,
		(void *)&airs_sup_gran->freqEmis[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field freqEmis\n", statn);

  statn = SWreadfield(swid, "emisIRStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->emisIRStd[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field emisIRStd\n", statn);

  statn = SWreadfield(swid, "emisIRStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->emisIRStd_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field emisIRStd_QC\n", statn);

  statn = SWreadfield(swid, "emisIRStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->emisIRStdErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field emisIRStdErr\n", statn);

  statn = SWreadfield(swid, "Effective_Solar_Reflectance", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Effective_Solar_Reflectance[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field Effective_Solar_Reflectance\n", statn);

  statn = SWreadfield(swid, "Effective_Solar_Reflectance_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Effective_Solar_Reflectance_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field Effective_Solar_Reflectance_QC\n", statn);

  statn = SWreadfield(swid, "TAirSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirSup\n", statn);

  statn = SWreadfield(swid, "TAirSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirSup_QC\n", statn);

  statn = SWreadfield(swid, "TAirSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirSupErr\n", statn);

  statn = SWreadfield(swid, "TSurfAir", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfAir[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfAir\n", statn);

  statn = SWreadfield(swid, "TSurfAir_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfAir_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfAir_QC\n", statn);

  statn = SWreadfield(swid, "TSurfAirErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfAirErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfAirErr\n", statn);

  statn = SWreadfield(swid, "num_Temp_Func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->num_Temp_Func[0][0]);
  if (statn != 0)
    printf("Error %d reading field num_Temp_Func\n", statn);

  statn = SWreadfield(swid, "Temp_ave_kern", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Temp_ave_kern[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field Temp_ave_kern\n", statn);

  statn = SWreadfield(swid, "Temp_verticality", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Temp_verticality[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field Temp_verticality\n", statn);

  statn = SWreadfield(swid, "Temp_dof", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Temp_dof[0][0]);
  if (statn != 0)
    printf("Error %d reading field Temp_dof\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatLevSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatLevSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatLevSup\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatLevSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatLevSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatLevSup_QC\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatSurf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatSurf\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatSurf_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatSurf_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatSurf_QC\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatLevSup_liquid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatLevSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatLevSup_liquid\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatLevSup_liquid_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatLevSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatLevSup_liquid_QC\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatSurf_liquid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatSurf_liquid\n", statn);

  statn = SWreadfield(swid, "H2OMMRSatSurf_liquid_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSatSurf_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSatSurf_liquid_QC\n", statn);

  statn = SWreadfield(swid, "PTropopause", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PTropopause[0][0]);
  if (statn != 0)
    printf("Error %d reading field PTropopause\n", statn);

  statn = SWreadfield(swid, "PTropopause_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PTropopause_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field PTropopause_QC\n", statn);

  statn = SWreadfield(swid, "T_Tropopause", NULL, NULL, NULL,
		(void *)&airs_sup_gran->T_Tropopause[0][0]);
  if (statn != 0)
    printf("Error %d reading field T_Tropopause\n", statn);

  statn = SWreadfield(swid, "T_Tropopause_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->T_Tropopause_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field T_Tropopause_QC\n", statn);

  statn = SWreadfield(swid, "totH2OStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totH2OStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field totH2OStd\n", statn);

  statn = SWreadfield(swid, "totH2OStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totH2OStd_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field totH2OStd_QC\n", statn);

  statn = SWreadfield(swid, "totH2OStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totH2OStdErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field totH2OStdErr\n", statn);

  statn = SWreadfield(swid, "H2OCDSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDSup\n", statn);

  statn = SWreadfield(swid, "H2OCDSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDSup_QC\n", statn);

  statn = SWreadfield(swid, "H2OCDSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDSupErr\n", statn);

  statn = SWreadfield(swid, "H2OMMRLevSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRLevSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRLevSup\n", statn);

  statn = SWreadfield(swid, "H2OMMRLevSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRLevSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRLevSup_QC\n", statn);

  statn = SWreadfield(swid, "H2OMMRLevSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRLevSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRLevSupErr\n", statn);

  statn = SWreadfield(swid, "H2OMMRSurf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSurf\n", statn);

  statn = SWreadfield(swid, "H2OMMRSurf_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSurf_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSurf_QC\n", statn);

  statn = SWreadfield(swid, "H2OMMRSurfErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OMMRSurfErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OMMRSurfErr\n", statn);

  statn = SWreadfield(swid, "num_H2O_Func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->num_H2O_Func[0][0]);
  if (statn != 0)
    printf("Error %d reading field num_H2O_Func\n", statn);

  statn = SWreadfield(swid, "H2O_eff_press", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_eff_press[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2O_eff_press\n", statn);

  statn = SWreadfield(swid, "H2O_VMR_eff", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_VMR_eff[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2O_VMR_eff\n", statn);

  statn = SWreadfield(swid, "H2O_VMR_eff_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_VMR_eff_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2O_VMR_eff_QC\n", statn);

  statn = SWreadfield(swid, "H2O_VMR_eff_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_VMR_eff_err[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2O_VMR_eff_err\n", statn);

  statn = SWreadfield(swid, "H2O_trapezoid_layers", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_trapezoid_layers[0]);
  if (statn != 0)
    printf("Error %d reading field H2O_trapezoid_layers\n", statn);

  statn = SWreadfield(swid, "H2O_verticality", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_verticality[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2O_verticality\n", statn);

  statn = SWreadfield(swid, "H2O_dof", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_dof[0][0]);
  if (statn != 0)
    printf("Error %d reading field H2O_dof\n", statn);

  statn = SWreadfield(swid, "H2O_ave_kern", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2O_ave_kern[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2O_ave_kern\n", statn);

  statn = SWreadfield(swid, "RelHum", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHum[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHum\n", statn);

  statn = SWreadfield(swid, "RelHum_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHum_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHum_QC\n", statn);

  statn = SWreadfield(swid, "RelHumSurf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHumSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHumSurf\n", statn);

  statn = SWreadfield(swid, "RelHumSurf_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHumSurf_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHumSurf_QC\n", statn);

  statn = SWreadfield(swid, "RelHum_liquid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHum_liquid[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHum_liquid\n", statn);

  statn = SWreadfield(swid, "RelHum_liquid_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHum_liquid_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHum_liquid_QC\n", statn);

  statn = SWreadfield(swid, "RelHumSurf_liquid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHumSurf_liquid[0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHumSurf_liquid\n", statn);

  statn = SWreadfield(swid, "RelHumSurf_liquid_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->RelHumSurf_liquid_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field RelHumSurf_liquid_QC\n", statn);

  statn = SWreadfield(swid, "bndry_lyr_top", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bndry_lyr_top[0][0]);
  if (statn != 0)
    printf("Error %d reading field bndry_lyr_top\n", statn);

  statn = SWreadfield(swid, "bndry_lyr_top_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bndry_lyr_top_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field bndry_lyr_top_QC\n", statn);

  statn = SWreadfield(swid, "GP_Tropopause", NULL, NULL, NULL,
		(void *)&airs_sup_gran->GP_Tropopause[0][0]);
  if (statn != 0)
    printf("Error %d reading field GP_Tropopause\n", statn);

  statn = SWreadfield(swid, "GP_Tropopause_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->GP_Tropopause_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field GP_Tropopause_QC\n", statn);

  statn = SWreadfield(swid, "GP_HeightSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->GP_HeightSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field GP_HeightSup\n", statn);

  statn = SWreadfield(swid, "GP_HeightSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->GP_HeightSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field GP_HeightSup_QC\n", statn);

  statn = SWreadfield(swid, "GP_Surface", NULL, NULL, NULL,
		(void *)&airs_sup_gran->GP_Surface[0][0]);
  if (statn != 0)
    printf("Error %d reading field GP_Surface\n", statn);

  statn = SWreadfield(swid, "GP_Surface_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->GP_Surface_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field GP_Surface_QC\n", statn);

  statn = SWreadfield(swid, "CldFrcTot", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldFrcTot[0][0]);
  if (statn != 0)
    printf("Error %d reading field CldFrcTot\n", statn);

  statn = SWreadfield(swid, "CldFrcTot_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldFrcTot_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field CldFrcTot_QC\n", statn);

  statn = SWreadfield(swid, "CldFrcStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldFrcStd[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldFrcStd\n", statn);

  statn = SWreadfield(swid, "CldFrcStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldFrcStd_QC[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldFrcStd_QC\n", statn);

  statn = SWreadfield(swid, "CldFrcStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldFrcStdErr[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldFrcStdErr\n", statn);

  statn = SWreadfield(swid, "PCldTop", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PCldTop[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PCldTop\n", statn);

  statn = SWreadfield(swid, "PCldTop_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PCldTop_QC[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PCldTop_QC\n", statn);

  statn = SWreadfield(swid, "PCldTopErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PCldTopErr[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PCldTopErr\n", statn);

  statn = SWreadfield(swid, "TCldTop", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TCldTop[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TCldTop\n", statn);

  statn = SWreadfield(swid, "TCldTop_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TCldTop_QC[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TCldTop_QC\n", statn);

  statn = SWreadfield(swid, "TCldTopErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TCldTopErr[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TCldTopErr\n", statn);

  statn = SWreadfield(swid, "nCld", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nCld[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field nCld\n", statn);

  statn = SWreadfield(swid, "PCldTopStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PCldTopStd[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PCldTopStd\n", statn);

  statn = SWreadfield(swid, "PCldTopStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PCldTopStd_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PCldTopStd_QC\n", statn);

  statn = SWreadfield(swid, "PCldTopStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PCldTopStdErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PCldTopStdErr\n", statn);

  statn = SWreadfield(swid, "TCldTopStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TCldTopStd[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TCldTopStd\n", statn);

  statn = SWreadfield(swid, "TCldTopStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TCldTopStd_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TCldTopStd_QC\n", statn);

  statn = SWreadfield(swid, "TCldTopStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TCldTopStdErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TCldTopStdErr\n", statn);

  statn = SWreadfield(swid, "numCloud", NULL, NULL, NULL,
		(void *)&airs_sup_gran->numCloud[0][0]);
  if (statn != 0)
    printf("Error %d reading field numCloud\n", statn);

  statn = SWreadfield(swid, "numHingeCloud", NULL, NULL, NULL,
		(void *)&airs_sup_gran->numHingeCloud[0][0]);
  if (statn != 0)
    printf("Error %d reading field numHingeCloud\n", statn);

  statn = SWreadfield(swid, "cldFreq", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cldFreq[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field cldFreq\n", statn);

  statn = SWreadfield(swid, "CldEmis", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldEmis[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldEmis\n", statn);

  statn = SWreadfield(swid, "CldEmis_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldEmis_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldEmis_QC\n", statn);

  statn = SWreadfield(swid, "CldEmisErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldEmisErr[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldEmisErr\n", statn);

  statn = SWreadfield(swid, "CldRho", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldRho[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldRho\n", statn);

  statn = SWreadfield(swid, "CldRho_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldRho_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldRho_QC\n", statn);

  statn = SWreadfield(swid, "CldRhoErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldRhoErr[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldRhoErr\n", statn);

  statn = SWreadfield(swid, "ice_cld_opt_dpth", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_opt_dpth[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_opt_dpth\n", statn);

  statn = SWreadfield(swid, "ice_cld_opt_dpth_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_opt_dpth_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_opt_dpth_QC\n", statn);

  statn = SWreadfield(swid, "ice_cld_eff_diam", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_eff_diam[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_eff_diam\n", statn);
    
  statn = SWreadfield(swid, "ice_cld_eff_diam_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_eff_diam_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_eff_diam_QC\n", statn);
        
  statn = SWreadfield(swid, "ice_cld_temp_eff", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_temp_eff[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_temp_eff\n", statn);

  statn = SWreadfield(swid, "ice_cld_temp_eff_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_temp_eff_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_temp_eff_QC\n", statn);

  statn = SWreadfield(swid, "ice_cld_fit_reduced_chisq", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_fit_reduced_chisq[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_fit_reduced_chisq\n", statn);

  statn = SWreadfield(swid, "ice_cld_opt_dpth_ave_kern", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_opt_dpth_ave_kern[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_opt_dpth_ave_kern\n", statn);

  statn = SWreadfield(swid, "ice_cld_eff_diam_ave_kern", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_eff_diam_ave_kern[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_eff_diam_ave_kern\n", statn);
    
  statn = SWreadfield(swid, "ice_cld_temp_eff_ave_kern", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_temp_eff_ave_kern[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_temp_eff_ave_kern\n", statn);

  statn = SWreadfield(swid, "ice_cld_opt_dpth_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_opt_dpth_err[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_opt_dpth_err\n", statn);

  statn = SWreadfield(swid, "ice_cld_eff_diam_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_eff_diam_err[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_eff_diam_err\n", statn);
    
  statn = SWreadfield(swid, "ice_cld_temp_eff_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_temp_eff_err[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_temp_eff_err\n", statn);
    
  statn = SWreadfield(swid, "log_ice_cld_opt_dpth_prior_var", NULL, NULL, NULL,
		(void *)&airs_sup_gran->log_ice_cld_opt_dpth_prior_var[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field log_ice_cld_opt_dpth_prior_var\n", statn);

  statn = SWreadfield(swid, "log_ice_cld_eff_diam_prior_var", NULL, NULL, NULL,
		(void *)&airs_sup_gran->log_ice_cld_eff_diam_prior_var[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field log_ice_cld_eff_diam_prior_var\n", statn);

  statn = SWreadfield(swid, "ice_cld_temp_eff_prior_var", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_temp_eff_prior_var[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_temp_eff_prior_var\n", statn);

  statn = SWreadfield(swid, "ice_cld_opt_dpth_first_guess", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_opt_dpth_first_guess[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_opt_dpth_first_guess\n", statn);

  statn = SWreadfield(swid, "ice_cld_eff_diam_first_guess", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_eff_diam_first_guess[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_eff_diam_first_guess\n", statn);
    
  statn = SWreadfield(swid, "ice_cld_temp_eff_first_guess", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ice_cld_temp_eff_first_guess[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field ice_cld_temp_eff_first_guess\n", statn);

  statn = SWreadfield(swid, "totO3Std", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totO3Std[0][0]);
  if (statn != 0)
    printf("Error %d reading field totO3Std\n", statn);

  statn = SWreadfield(swid, "totO3Std_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totO3Std_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field totO3Std_QC\n", statn);

  statn = SWreadfield(swid, "totO3StdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totO3StdErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field totO3StdErr\n", statn);

  statn = SWreadfield(swid, "O3CDSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3CDSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3CDSup\n", statn);

  statn = SWreadfield(swid, "O3CDSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3CDSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3CDSup_QC\n", statn);

  statn = SWreadfield(swid, "O3CDSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3CDSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3CDSupErr\n", statn);

  statn = SWreadfield(swid, "O3VMRLevSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3VMRLevSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3VMRLevSup\n", statn);

  statn = SWreadfield(swid, "O3VMRLevSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3VMRLevSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3VMRLevSup_QC\n", statn);

  statn = SWreadfield(swid, "O3VMRLevSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3VMRLevSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3VMRLevSupErr\n", statn);

  statn = SWreadfield(swid, "O3VMRSurf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3VMRSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field O3VMRSurf\n", statn);

  statn = SWreadfield(swid, "O3VMRSurf_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3VMRSurf_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field O3VMRSurf_QC\n", statn);

  statn = SWreadfield(swid, "O3VMRSurfErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3VMRSurfErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field O3VMRSurfErr\n", statn);

  statn = SWreadfield(swid, "num_O3_Func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->num_O3_Func[0][0]);
  if (statn != 0)
    printf("Error %d reading field num_O3_Func\n", statn);

  statn = SWreadfield(swid, "O3_trapezoid_layers", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_trapezoid_layers[0]);
  if (statn != 0)
    printf("Error %d reading field O3_trapezoid_layers\n", statn);

  statn = SWreadfield(swid, "O3_eff_press", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_eff_press[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_eff_press\n", statn);

  statn = SWreadfield(swid, "O3_VMR_eff", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_VMR_eff[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_VMR_eff\n", statn);

  statn = SWreadfield(swid, "O3_VMR_eff_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_VMR_eff_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_VMR_eff_QC\n", statn);

  statn = SWreadfield(swid, "O3_VMR_eff_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_VMR_eff_err[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_VMR_eff_err\n", statn);

  statn = SWreadfield(swid, "O3_verticality", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_verticality[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_verticality\n", statn);

  statn = SWreadfield(swid, "O3_dof", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_dof[0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_dof\n", statn);

  statn = SWreadfield(swid, "O3_ave_kern", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_ave_kern[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_ave_kern\n", statn);

  statn = SWreadfield(swid, "CO_total_column", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_total_column[0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_total_column\n", statn);

  statn = SWreadfield(swid, "CO_total_column_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_total_column_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_total_column_QC\n", statn);

  statn = SWreadfield(swid, "COCDSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COCDSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field COCDSup\n", statn);

  statn = SWreadfield(swid, "COCDSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COCDSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field COCDSup_QC\n", statn);

  statn = SWreadfield(swid, "COCDSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COCDSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field COCDSupErr\n", statn);

  statn = SWreadfield(swid, "COVMRLevSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COVMRLevSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field COVMRLevSup\n", statn);

  statn = SWreadfield(swid, "COVMRLevSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COVMRLevSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field COVMRLevSup_QC\n", statn);

  statn = SWreadfield(swid, "COVMRLevSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COVMRLevSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field COVMRLevSupErr\n", statn);

  statn = SWreadfield(swid, "COVMRSurf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COVMRSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field COVMRSurf\n", statn);

  statn = SWreadfield(swid, "COVMRSurf_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COVMRSurf_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field COVMRSurf_QC\n", statn);

  statn = SWreadfield(swid, "COVMRSurfErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->COVMRSurfErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field COVMRSurfErr\n", statn);

  statn = SWreadfield(swid, "num_CO_Func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->num_CO_Func[0][0]);
  if (statn != 0)
    printf("Error %d reading field num_CO_Func\n", statn);

  statn = SWreadfield(swid, "CO_trapezoid_layers", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_trapezoid_layers[0]);
  if (statn != 0)
    printf("Error %d reading field CO_trapezoid_layers\n", statn);

  statn = SWreadfield(swid, "CO_eff_press", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_eff_press[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_eff_press\n", statn);

  statn = SWreadfield(swid, "CO_VMR_eff", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_VMR_eff[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_VMR_eff\n", statn);

  statn = SWreadfield(swid, "CO_VMR_eff_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_VMR_eff_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_VMR_eff_QC\n", statn);

  statn = SWreadfield(swid, "CO_VMR_eff_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_VMR_eff_err[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_VMR_eff_err\n", statn);

  statn = SWreadfield(swid, "CO_verticality", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_verticality[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_verticality\n", statn);

  statn = SWreadfield(swid, "CO_dof", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_dof[0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_dof\n", statn);

  statn = SWreadfield(swid, "CO_ave_kern", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_ave_kern[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_ave_kern\n", statn);

  statn = SWreadfield(swid, "CH4_total_column", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_total_column[0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_total_column\n", statn);

  statn = SWreadfield(swid, "CH4_total_column_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_total_column_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_total_column_QC\n", statn);

  statn = SWreadfield(swid, "CH4CDSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4CDSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4CDSup\n", statn);

  statn = SWreadfield(swid, "CH4CDSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4CDSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4CDSup_QC\n", statn);

  statn = SWreadfield(swid, "CH4CDSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4CDSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4CDSupErr\n", statn);

  statn = SWreadfield(swid, "CH4VMRLevSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4VMRLevSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4VMRLevSup\n", statn);

  statn = SWreadfield(swid, "CH4VMRLevSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4VMRLevSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4VMRLevSup_QC\n", statn);

  statn = SWreadfield(swid, "CH4VMRLevSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4VMRLevSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4VMRLevSupErr\n", statn);

  statn = SWreadfield(swid, "CH4VMRSurf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4VMRSurf[0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4VMRSurf\n", statn);

  statn = SWreadfield(swid, "CH4VMRSurf_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4VMRSurf_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4VMRSurf_QC\n", statn);

  statn = SWreadfield(swid, "CH4VMRSurfErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4VMRSurfErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4VMRSurfErr\n", statn);

  statn = SWreadfield(swid, "num_CH4_Func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->num_CH4_Func[0][0]);
  if (statn != 0)
    printf("Error %d reading field num_CH4_Func\n", statn);

  statn = SWreadfield(swid, "CH4_trapezoid_layers_10func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_trapezoid_layers_10func[0]);
  if (statn != 0)
    printf("Error %d reading field CH4_trapezoid_layers_10func\n", statn);

  statn = SWreadfield(swid, "CH4_eff_press_10func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_eff_press_10func[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_eff_press_10func\n", statn);

  statn = SWreadfield(swid, "CH4_VMR_eff_10func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_VMR_eff_10func[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_VMR_eff_10func\n", statn);

  statn = SWreadfield(swid, "CH4_VMR_eff_10func_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_VMR_eff_10func_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_VMR_eff_10func_QC\n", statn);

  statn = SWreadfield(swid, "CH4_VMR_eff_10func_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_VMR_eff_10func_err[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_VMR_eff_10func_err\n", statn);

  statn = SWreadfield(swid, "CH4_verticality_10func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_verticality_10func[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_verticality_10func\n", statn);

  statn = SWreadfield(swid, "CH4_dof", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_dof[0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_dof\n", statn);

  statn = SWreadfield(swid, "CH4_ave_kern_10func", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_ave_kern_10func[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_ave_kern_10func\n", statn);

  statn = SWreadfield(swid, "olr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->olr[0][0]);
  if (statn != 0)
    printf("Error %d reading field olr\n", statn);

  statn = SWreadfield(swid, "olr_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->olr_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field olr_QC\n", statn);

  statn = SWreadfield(swid, "spectralolr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->spectralolr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field spectralolr\n", statn);

  statn = SWreadfield(swid, "spectralolr_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->spectralolr_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field spectralolr_QC\n", statn);

  statn = SWreadfield(swid, "olr3x3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->olr3x3[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field olr3x3\n", statn);

  statn = SWreadfield(swid, "olr3x3_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->olr3x3_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field olr3x3_QC\n", statn);

  statn = SWreadfield(swid, "olr_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->olr_err[0][0]);
  if (statn != 0)
    printf("Error %d reading field olr_err\n", statn);

  statn = SWreadfield(swid, "clrolr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->clrolr[0][0]);
  if (statn != 0)
    printf("Error %d reading field clrolr\n", statn);

  statn = SWreadfield(swid, "clrolr_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->clrolr_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field clrolr_QC\n", statn);

  statn = SWreadfield(swid, "clrolr_err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->clrolr_err[0][0]);
  if (statn != 0)
    printf("Error %d reading field clrolr_err\n", statn);

  statn = SWreadfield(swid, "spectralclrolr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->spectralclrolr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field spectralclrolr\n", statn);

  statn = SWreadfield(swid, "spectralclrolr_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->spectralclrolr_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field spectralclrolr_QC\n", statn);

  statn = SWreadfield(swid, "ftptgeoqa", NULL, NULL, NULL,
		(void *)&airs_sup_gran->ftptgeoqa[0][0]);
  if (statn != 0)
    printf("Error %d reading field ftptgeoqa\n", statn);

  statn = SWreadfield(swid, "zengeoqa", NULL, NULL, NULL,
		(void *)&airs_sup_gran->zengeoqa[0][0]);
  if (statn != 0)
    printf("Error %d reading field zengeoqa\n", statn);

  statn = SWreadfield(swid, "demgeoqa", NULL, NULL, NULL,
		(void *)&airs_sup_gran->demgeoqa[0][0]);
  if (statn != 0)
    printf("Error %d reading field demgeoqa\n", statn);

  statn = SWreadfield(swid, "all_spots_avg", NULL, NULL, NULL,
		(void *)&airs_sup_gran->all_spots_avg[0][0]);
  if (statn != 0)
    printf("Error %d reading field all_spots_avg\n", statn);

  statn = SWreadfield(swid, "retrieval_type", NULL, NULL, NULL,
		(void *)&airs_sup_gran->retrieval_type[0][0]);
  if (statn != 0)
    printf("Error %d reading field retrieval_type\n", statn);

  statn = SWreadfield(swid, "SurfClass", NULL, NULL, NULL,
		(void *)&airs_sup_gran->SurfClass[0][0]);
  if (statn != 0)
    printf("Error %d reading field SurfClass\n", statn);

  statn = SWreadfield(swid, "IR_Precip_Est", NULL, NULL, NULL,
		(void *)&airs_sup_gran->IR_Precip_Est[0][0]);
  if (statn != 0)
    printf("Error %d reading field IR_Precip_Est\n", statn);

  statn = SWreadfield(swid, "IR_Precip_Est_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->IR_Precip_Est_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field IR_Precip_Est_QC\n", statn);

  statn = SWreadfield(swid, "IR_Precip_Est3x3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->IR_Precip_Est3x3[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field IR_Precip_Est3x3\n", statn);

  statn = SWreadfield(swid, "IR_Precip_Est3x3_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->IR_Precip_Est3x3_QC[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field IR_Precip_Est3x3_QC\n", statn);

  statn = SWreadfield(swid, "IR_Precip_Est_Err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->IR_Precip_Est_Err[0][0]);
  if (statn != 0)
    printf("Error %d reading field IR_Precip_Est_Err\n", statn);

  statn = SWreadfield(swid, "TAirMWOnly", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirMWOnly[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirMWOnly\n", statn);

  statn = SWreadfield(swid, "TAirMWOnly_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirMWOnly_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirMWOnly_QC\n", statn);

  statn = SWreadfield(swid, "TAirMWOnlyErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirMWOnlyErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirMWOnlyErr\n", statn);

  statn = SWreadfield(swid, "MWSurfClass", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWSurfClass[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWSurfClass\n", statn);

  statn = SWreadfield(swid, "sfcTbMWStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sfcTbMWStd[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field sfcTbMWStd\n", statn);

  statn = SWreadfield(swid, "sfcTbMWStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sfcTbMWStd_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field sfcTbMWStd_QC\n", statn);

  statn = SWreadfield(swid, "EmisMWStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->EmisMWStd[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field EmisMWStd\n", statn);

  statn = SWreadfield(swid, "EmisMWStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->EmisMWStd_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field EmisMWStd_QC\n", statn);

  statn = SWreadfield(swid, "EmisMWStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->EmisMWStdErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field EmisMWStdErr\n", statn);

  statn = SWreadfield(swid, "Emis50GHz", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Emis50GHz[0][0]);
  if (statn != 0)
    printf("Error %d reading field Emis50GHz\n", statn);

  statn = SWreadfield(swid, "Emis50GHz_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Emis50GHz_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field Emis50GHz_QC\n", statn);

  statn = SWreadfield(swid, "totH2OMWOnlyStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totH2OMWOnlyStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field totH2OMWOnlyStd\n", statn);

  statn = SWreadfield(swid, "totH2OMWOnlyStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totH2OMWOnlyStd_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field totH2OMWOnlyStd_QC\n", statn);

  statn = SWreadfield(swid, "H2OCDMWOnly", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDMWOnly[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDMWOnly\n", statn);

  statn = SWreadfield(swid, "H2OCDMWOnly_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDMWOnly_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDMWOnly_QC\n", statn);

  statn = SWreadfield(swid, "totCldH2OStd", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totCldH2OStd[0][0]);
  if (statn != 0)
    printf("Error %d reading field totCldH2OStd\n", statn);

  statn = SWreadfield(swid, "totCldH2OStd_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totCldH2OStd_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field totCldH2OStd_QC\n", statn);

  statn = SWreadfield(swid, "totCldH2OStdErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->totCldH2OStdErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field totCldH2OStdErr\n", statn);

  statn = SWreadfield(swid, "satzen_amsu", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satzen_amsu[0][0]);
  if (statn != 0)
    printf("Error %d reading field satzen_amsu\n", statn);

  statn = SWreadfield(swid, "satazi_amsu", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satazi_amsu[0][0]);
  if (statn != 0)
    printf("Error %d reading field satazi_amsu\n", statn);

  statn = SWreadfield(swid, "MWHingeSurfFreqGHz", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWHingeSurfFreqGHz[0]);
  if (statn != 0)
    printf("Error %d reading field MWHingeSurfFreqGHz\n", statn);

  statn = SWreadfield(swid, "PrecipAA4_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA4_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA4_50km\n", statn);

  statn = SWreadfield(swid, "PrecipAA5_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA5_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA5_50km\n", statn);

  statn = SWreadfield(swid, "PrecipAA6_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA6_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA6_50km\n", statn);

  statn = SWreadfield(swid, "PrecipAA7_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA7_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA7_50km\n", statn);

  statn = SWreadfield(swid, "PrecipAA8_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA8_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA8_50km\n", statn);

  statn = SWreadfield(swid, "PrecipAA9_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA9_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA9_50km\n", statn);

  statn = SWreadfield(swid, "PrecipAA4_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA4_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA4_15km\n", statn);

  statn = SWreadfield(swid, "PrecipAA5_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA5_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA5_15km\n", statn);

  statn = SWreadfield(swid, "PrecipAA6_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA6_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA6_15km\n", statn);

  statn = SWreadfield(swid, "PrecipAA7_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA7_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA7_15km\n", statn);

  statn = SWreadfield(swid, "PrecipAA8_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA8_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA8_15km\n", statn);

  statn = SWreadfield(swid, "PrecipAA9_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->PrecipAA9_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field PrecipAA9_15km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_4_Precip_Corr_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_4_Precip_Corr_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_4_Precip_Corr_50km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_5_Precip_Corr_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_5_Precip_Corr_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_5_Precip_Corr_50km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_6_Precip_Corr_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_6_Precip_Corr_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_6_Precip_Corr_50km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_7_Precip_Corr_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_7_Precip_Corr_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_7_Precip_Corr_50km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_8_Precip_Corr_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_8_Precip_Corr_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_8_Precip_Corr_50km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_9_Precip_Corr_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_9_Precip_Corr_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_9_Precip_Corr_50km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_4_Precip_Corr_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_4_Precip_Corr_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_4_Precip_Corr_15km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_5_Precip_Corr_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_5_Precip_Corr_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_5_Precip_Corr_15km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_6_Precip_Corr_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_6_Precip_Corr_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_6_Precip_Corr_15km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_7_Precip_Corr_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_7_Precip_Corr_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_7_Precip_Corr_15km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_8_Precip_Corr_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_8_Precip_Corr_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_8_Precip_Corr_15km\n", statn);

  statn = SWreadfield(swid, "AMSU_A_9_Precip_Corr_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_A_9_Precip_Corr_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_A_9_Precip_Corr_15km\n", statn);

  statn = SWreadfield(swid, "rain_rate_50km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->rain_rate_50km[0][0]);
  if (statn != 0)
    printf("Error %d reading field rain_rate_50km\n", statn);

  statn = SWreadfield(swid, "rain_rate_15km", NULL, NULL, NULL,
		(void *)&airs_sup_gran->rain_rate_15km[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field rain_rate_15km\n", statn);

  statn = SWreadfield(swid, "lwCDSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->lwCDSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field lwCDSup\n", statn);

  statn = SWreadfield(swid, "lwCDSup_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->lwCDSup_QC[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field lwCDSup_QC\n", statn);

  statn = SWreadfield(swid, "lwCDSupErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->lwCDSupErr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field lwCDSupErr\n", statn);

  statn = SWreadfield(swid, "cIWSup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cIWSup[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field cIWSup\n", statn);

  statn = SWreadfield(swid, "satzen_hsb", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satzen_hsb[0][0]);
  if (statn != 0)
    printf("Error %d reading field satzen_hsb\n", statn);

  statn = SWreadfield(swid, "satazi_hsb", NULL, NULL, NULL,
		(void *)&airs_sup_gran->satazi_hsb[0][0]);
  if (statn != 0)
    printf("Error %d reading field satazi_hsb\n", statn);

  statn = SWreadfield(swid, "tsurf_forecast", NULL, NULL, NULL,
		(void *)&airs_sup_gran->tsurf_forecast[0][0]);
  if (statn != 0)
    printf("Error %d reading field tsurf_forecast\n", statn);

  statn = SWreadfield(swid, "Forecast_Wind_U", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Forecast_Wind_U[0][0]);
  if (statn != 0)
    printf("Error %d reading field Forecast_Wind_U\n", statn);

  statn = SWreadfield(swid, "Forecast_Wind_V", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Forecast_Wind_V[0][0]);
  if (statn != 0)
    printf("Error %d reading field Forecast_Wind_V\n", statn);

  statn = SWreadfield(swid, "MODIS_emis", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_emis[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_emis\n", statn);

  statn = SWreadfield(swid, "MODIS_emis_dev", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_emis_dev[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_emis_dev\n", statn);

  statn = SWreadfield(swid, "MODIS_emis_qct", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_emis_qct[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_emis_qct\n", statn);

  statn = SWreadfield(swid, "MODIS_emis_spots", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_emis_spots[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_emis_spots\n", statn);

  statn = SWreadfield(swid, "MODIS_emis_spots_dev", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_emis_spots_dev[0][0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_emis_spots_dev\n", statn);

  statn = SWreadfield(swid, "MODIS_emis_10_hinge", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_emis_10_hinge[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_emis_10_hinge\n", statn);

  statn = SWreadfield(swid, "MODIS_LST", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_LST[0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_LST\n", statn);

  statn = SWreadfield(swid, "MODIS_LST_dev", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_LST_dev[0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_LST_dev\n", statn);

  statn = SWreadfield(swid, "MODIS_LST_qct", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_LST_qct[0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_LST_qct\n", statn);

  statn = SWreadfield(swid, "MODIS_LST_spots", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_LST_spots[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_LST_spots\n", statn);

  statn = SWreadfield(swid, "MODIS_LST_spots_dev", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MODIS_LST_spots_dev[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MODIS_LST_spots_dev\n", statn);

  statn = SWreadfield(swid, "CO2ppmv", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO2ppmv[0][0]);
  if (statn != 0)
    printf("Error %d reading field CO2ppmv\n", statn);

  statn = SWreadfield(swid, "CO2ppmv_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO2ppmv_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field CO2ppmv_QC\n", statn);

  statn = SWreadfield(swid, "CO2ppmvErr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO2ppmvErr[0][0]);
  if (statn != 0)
    printf("Error %d reading field CO2ppmvErr\n", statn);

  statn = SWreadfield(swid, "TSurfClim", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfClim[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfClim\n", statn);

  statn = SWreadfield(swid, "TSurfAirClim", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfAirClim[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfAirClim\n", statn);

  statn = SWreadfield(swid, "TAirClim", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirClim[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirClim\n", statn);

  statn = SWreadfield(swid, "H2OCDClim", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDClim[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDClim\n", statn);

  statn = SWreadfield(swid, "Tropo_CCI", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Tropo_CCI[0][0]);
  if (statn != 0)
    printf("Error %d reading field Tropo_CCI\n", statn);

  statn = SWreadfield(swid, "Tropo_CCI_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Tropo_CCI_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field Tropo_CCI_QC\n", statn);

  statn = SWreadfield(swid, "Tropo_CCI_Est_Err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Tropo_CCI_Est_Err[0][0]);
  if (statn != 0)
    printf("Error %d reading field Tropo_CCI_Est_Err\n", statn);

  statn = SWreadfield(swid, "Strato_CCI", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Strato_CCI[0][0]);
  if (statn != 0)
    printf("Error %d reading field Strato_CCI\n", statn);

  statn = SWreadfield(swid, "Strato_CCI_QC", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Strato_CCI_QC[0][0]);
  if (statn != 0)
    printf("Error %d reading field Strato_CCI_QC\n", statn);

  statn = SWreadfield(swid, "Strato_CCI_Est_Err", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Strato_CCI_Est_Err[0][0]);
  if (statn != 0)
    printf("Error %d reading field Strato_CCI_Est_Err\n", statn);

  statn = SWreadfield(swid, "MoonInViewIR", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MoonInViewIR[0][0]);
  if (statn != 0)
    printf("Error %d reading field MoonInViewIR\n", statn);

  statn = SWreadfield(swid, "pseudo_lapse_rate", NULL, NULL, NULL,
		(void *)&airs_sup_gran->pseudo_lapse_rate[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field pseudo_lapse_rate\n", statn);

  statn = SWreadfield(swid, "TAirSCCNN", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirSCCNN[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirSCCNN\n", statn);

  statn = SWreadfield(swid, "TAirCldyReg", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAirCldyReg[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAirCldyReg\n", statn);

  statn = SWreadfield(swid, "H2OCDSCCNN", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDSCCNN[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDSCCNN\n", statn);

  statn = SWreadfield(swid, "H2OCDCldyReg", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCDCldyReg[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCDCldyReg\n", statn);

  statn = SWreadfield(swid, "TSurfSCCNN", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfSCCNN[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfSCCNN\n", statn);

  statn = SWreadfield(swid, "TSurf1Ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurf1Ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurf1Ret\n", statn);

  statn = SWreadfield(swid, "TSurfAir1Ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfAir1Ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfAir1Ret\n", statn);

  statn = SWreadfield(swid, "TAir1Ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TAir1Ret[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field TAir1Ret\n", statn);

  statn = SWreadfield(swid, "H2OCD1Ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->H2OCD1Ret[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field H2OCD1Ret\n", statn);

  statn = SWreadfield(swid, "O3CDInit", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3CDInit[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field O3CDInit\n", statn);

  statn = SWreadfield(swid, "numHingeSurfFG", NULL, NULL, NULL,
		(void *)&airs_sup_gran->numHingeSurfFG[0][0]);
  if (statn != 0)
    printf("Error %d reading field numHingeSurfFG\n", statn);

  statn = SWreadfield(swid, "freqEmisFG", NULL, NULL, NULL,
		(void *)&airs_sup_gran->freqEmisFG[0]);
  if (statn != 0)
    printf("Error %d reading field freqEmisFG\n", statn);

  statn = SWreadfield(swid, "emisIRFG", NULL, NULL, NULL,
		(void *)&airs_sup_gran->emisIRFG[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field emisIRFG\n", statn);

  statn = SWreadfield(swid, "freqEmisInit", NULL, NULL, NULL,
		(void *)&airs_sup_gran->freqEmisInit[0]);
  if (statn != 0)
    printf("Error %d reading field freqEmisInit\n", statn);

  statn = SWreadfield(swid, "emisIRInit", NULL, NULL, NULL,
		(void *)&airs_sup_gran->emisIRInit[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field emisIRInit\n", statn);

  statn = SWreadfield(swid, "rhoIRInit", NULL, NULL, NULL,
		(void *)&airs_sup_gran->rhoIRInit[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field rhoIRInit\n", statn);

  statn = SWreadfield(swid, "FracLandPlusIce", NULL, NULL, NULL,
		(void *)&airs_sup_gran->FracLandPlusIce[0][0]);
  if (statn != 0)
    printf("Error %d reading field FracLandPlusIce\n", statn);

  statn = SWreadfield(swid, "CldClearParam", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CldClearParam[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CldClearParam\n", statn);

  statn = SWreadfield(swid, "CC1_Noise_Amp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CC1_Noise_Amp[0][0]);
  if (statn != 0)
    printf("Error %d reading field CC1_Noise_Amp\n", statn);

  statn = SWreadfield(swid, "Tsurf_4_CC1", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Tsurf_4_CC1[0][0]);
  if (statn != 0)
    printf("Error %d reading field Tsurf_4_CC1\n", statn);

  statn = SWreadfield(swid, "TotCld_4_CC1", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TotCld_4_CC1[0][0]);
  if (statn != 0)
    printf("Error %d reading field TotCld_4_CC1\n", statn);

  statn = SWreadfield(swid, "CC1_RCode", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CC1_RCode[0][0]);
  if (statn != 0)
    printf("Error %d reading field CC1_RCode\n", statn);

  statn = SWreadfield(swid, "CC2_RCode", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CC2_RCode[0][0]);
  if (statn != 0)
    printf("Error %d reading field CC2_RCode\n", statn);

  statn = SWreadfield(swid, "Phys_RCode", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_RCode[0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_RCode\n", statn);

  statn = SWreadfield(swid, "TotCld_below_500mb", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TotCld_below_500mb[0][0]);
  if (statn != 0)
    printf("Error %d reading field TotCld_below_500mb\n", statn);

  statn = SWreadfield(swid, "Phys_resid_AMSUA", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_resid_AMSUA[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_resid_AMSUA\n", statn);

  statn = SWreadfield(swid, "Phys_resid_IR_window_790", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_resid_IR_window_790[0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_resid_IR_window_790\n", statn);

  statn = SWreadfield(swid, "Phys_resid_IR_window_844", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_resid_IR_window_844[0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_resid_IR_window_844\n", statn);

  statn = SWreadfield(swid, "Phys_resid_IR_window_917", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_resid_IR_window_917[0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_resid_IR_window_917\n", statn);

  statn = SWreadfield(swid, "Phys_resid_IR_window_1231", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_resid_IR_window_1231[0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_resid_IR_window_1231\n", statn);

  statn = SWreadfield(swid, "Phys_resid_IR_window_2513", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_resid_IR_window_2513[0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_resid_IR_window_2513\n", statn);

  statn = SWreadfield(swid, "Phys_resid_IR_window_2616", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Phys_resid_IR_window_2616[0][0]);
  if (statn != 0)
    printf("Error %d reading field Phys_resid_IR_window_2616\n", statn);

  statn = SWreadfield(swid, "CBTmOBT1231", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CBTmOBT1231[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CBTmOBT1231\n", statn);

  statn = SWreadfield(swid, "CBTmOBT1231s", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CBTmOBT1231s[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field CBTmOBT1231s\n", statn);

  statn = SWreadfield(swid, "CC_noise_eff_amp_factor", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CC_noise_eff_amp_factor[0][0]);
  if (statn != 0)
    printf("Error %d reading field CC_noise_eff_amp_factor\n", statn);

  statn = SWreadfield(swid, "CC1_noise_eff_amp_factor", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CC1_noise_eff_amp_factor[0][0]);
  if (statn != 0)
    printf("Error %d reading field CC1_noise_eff_amp_factor\n", statn);

  statn = SWreadfield(swid, "CC1_Resid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CC1_Resid[0][0]);
  if (statn != 0)
    printf("Error %d reading field CC1_Resid\n", statn);

  statn = SWreadfield(swid, "CCfinal_Resid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CCfinal_Resid[0][0]);
  if (statn != 0)
    printf("Error %d reading field CCfinal_Resid\n", statn);

  statn = SWreadfield(swid, "CCfinal_Noise_Amp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CCfinal_Noise_Amp[0][0]);
  if (statn != 0)
    printf("Error %d reading field CCfinal_Noise_Amp\n", statn);

  statn = SWreadfield(swid, "Tdiff_IR_MW_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Tdiff_IR_MW_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field Tdiff_IR_MW_ret\n", statn);

  statn = SWreadfield(swid, "Tdiff_IR_4CC1", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Tdiff_IR_4CC1[0][0]);
  if (statn != 0)
    printf("Error %d reading field Tdiff_IR_4CC1\n", statn);

  statn = SWreadfield(swid, "TSurfdiff_IR_4CC1", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfdiff_IR_4CC1[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfdiff_IR_4CC1\n", statn);

  statn = SWreadfield(swid, "TSurfdiff_IR_4CC2", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TSurfdiff_IR_4CC2[0][0]);
  if (statn != 0)
    printf("Error %d reading field TSurfdiff_IR_4CC2\n", statn);

  statn = SWreadfield(swid, "AMSU_Chans_Resid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->AMSU_Chans_Resid[0][0]);
  if (statn != 0)
    printf("Error %d reading field AMSU_Chans_Resid\n", statn);

  statn = SWreadfield(swid, "TotCld_4_CCfinal", NULL, NULL, NULL,
		(void *)&airs_sup_gran->TotCld_4_CCfinal[0][0]);
  if (statn != 0)
    printf("Error %d reading field TotCld_4_CCfinal\n", statn);

  statn = SWreadfield(swid, "Surf_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Surf_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field Surf_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "Temp_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Temp_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field Temp_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "Water_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Water_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field Water_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "Cloud_Resid_Ratio3x3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Cloud_Resid_Ratio3x3[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field Cloud_Resid_Ratio3x3\n", statn);

  statn = SWreadfield(swid, "Cloud_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Cloud_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field Cloud_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "O3_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->O3_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field O3_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "CO_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CO_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field CO_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "CH4_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->CH4_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field CH4_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "MWCheck_Resid_Ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWCheck_Resid_Ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWCheck_Resid_Ratio\n", statn);

  statn = SWreadfield(swid, "invalid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->invalid[0][0]);
  if (statn != 0)
    printf("Error %d reading field invalid\n", statn);

  statn = SWreadfield(swid, "MW_ret_used", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MW_ret_used[0][0]);
  if (statn != 0)
    printf("Error %d reading field MW_ret_used\n", statn);

  statn = SWreadfield(swid, "bad_clouds", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_clouds[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_clouds\n", statn);

  statn = SWreadfield(swid, "Start_Clim", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Start_Clim[0][0]);
  if (statn != 0)
    printf("Error %d reading field Start_Clim\n", statn);

  statn = SWreadfield(swid, "Startup", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Startup[0][0]);
  if (statn != 0)
    printf("Error %d reading field Startup\n", statn);

  statn = SWreadfield(swid, "cld_surf_fallback", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cld_surf_fallback[0][0]);
  if (statn != 0)
    printf("Error %d reading field cld_surf_fallback\n", statn);

  statn = SWreadfield(swid, "nchan_big_ang_adj", NULL, NULL, NULL,
		(void *)&airs_sup_gran->nchan_big_ang_adj[0][0]);
  if (statn != 0)
    printf("Error %d reading field nchan_big_ang_adj\n", statn);
    
  statn = SWreadfield(swid, "bad_l1b", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_l1b[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_l1b\n", statn);

  statn = SWreadfield(swid, "bad_l1b_amsu", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_l1b_amsu[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_l1b_amsu\n", statn);

  statn = SWreadfield(swid, "bad_l1b_hsb", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_l1b_hsb[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_l1b_hsb\n", statn);

  statn = SWreadfield(swid, "bad_l1b_airs", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_l1b_airs[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_l1b_airs\n", statn);

  statn = SWreadfield(swid, "bad_l1b_vis", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_l1b_vis[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_l1b_vis\n", statn);

  statn = SWreadfield(swid, "forecast", NULL, NULL, NULL,
		(void *)&airs_sup_gran->forecast[0][0]);
  if (statn != 0)
    printf("Error %d reading field forecast\n", statn);

  statn = SWreadfield(swid, "no_psurf_guess", NULL, NULL, NULL,
		(void *)&airs_sup_gran->no_psurf_guess[0][0]);
  if (statn != 0)
    printf("Error %d reading field no_psurf_guess\n", statn);

  statn = SWreadfield(swid, "bad_temps", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_temps[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_temps\n", statn);

  statn = SWreadfield(swid, "bad_h2o", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_h2o[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_h2o\n", statn);

  statn = SWreadfield(swid, "bad_o3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_o3[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_o3\n", statn);

  statn = SWreadfield(swid, "bad_co", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_co[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_co\n", statn);

  statn = SWreadfield(swid, "no_tuning", NULL, NULL, NULL,
		(void *)&airs_sup_gran->no_tuning[0][0]);
  if (statn != 0)
    printf("Error %d reading field no_tuning\n", statn);

  statn = SWreadfield(swid, "no_ang_corr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->no_ang_corr[0][0]);
  if (statn != 0)
    printf("Error %d reading field no_ang_corr\n", statn);

  statn = SWreadfield(swid, "no_mw", NULL, NULL, NULL,
		(void *)&airs_sup_gran->no_mw[0][0]);
  if (statn != 0)
    printf("Error %d reading field no_mw\n", statn);

  statn = SWreadfield(swid, "no_initial", NULL, NULL, NULL,
		(void *)&airs_sup_gran->no_initial[0][0]);
  if (statn != 0)
    printf("Error %d reading field no_initial\n", statn);

  statn = SWreadfield(swid, "no_final", NULL, NULL, NULL,
		(void *)&airs_sup_gran->no_final[0][0]);
  if (statn != 0)
    printf("Error %d reading field no_final\n", statn);

  statn = SWreadfield(swid, "mw_fpe", NULL, NULL, NULL,
		(void *)&airs_sup_gran->mw_fpe[0][0]);
  if (statn != 0)
    printf("Error %d reading field mw_fpe\n", statn);

  statn = SWreadfield(swid, "cloudy_reg_fpe", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cloudy_reg_fpe[0][0]);
  if (statn != 0)
    printf("Error %d reading field cloudy_reg_fpe\n", statn);

  statn = SWreadfield(swid, "initial_fpe", NULL, NULL, NULL,
		(void *)&airs_sup_gran->initial_fpe[0][0]);
  if (statn != 0)
    printf("Error %d reading field initial_fpe\n", statn);

  statn = SWreadfield(swid, "final_fpe", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_fpe[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_fpe\n", statn);

  statn = SWreadfield(swid, "MWPrecip", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWPrecip[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWPrecip\n", statn);

  statn = SWreadfield(swid, "MWsurf_T0", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWsurf_T0[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWsurf_T0\n", statn);

  statn = SWreadfield(swid, "MWsurf_Tinf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWsurf_Tinf[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWsurf_Tinf\n", statn);

  statn = SWreadfield(swid, "MWsecant_ratio", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWsecant_ratio[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWsecant_ratio\n", statn);

  statn = SWreadfield(swid, "MWseaice_conc", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWseaice_conc[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWseaice_conc\n", statn);

  statn = SWreadfield(swid, "MWresidual_temp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWresidual_temp[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWresidual_temp\n", statn);

  statn = SWreadfield(swid, "MWresidual_mois", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWresidual_mois[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWresidual_mois\n", statn);

  statn = SWreadfield(swid, "MWresidual_AMSUA", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWresidual_AMSUA[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MWresidual_AMSUA\n", statn);

  statn = SWreadfield(swid, "MWresidual_HSB", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWresidual_HSB[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field MWresidual_HSB\n", statn);

  statn = SWreadfield(swid, "MWiter_temp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWiter_temp[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWiter_temp\n", statn);

  statn = SWreadfield(swid, "MWiter_mois", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MWiter_mois[0][0]);
  if (statn != 0)
    printf("Error %d reading field MWiter_mois\n", statn);

  statn = SWreadfield(swid, "mw_ret_code", NULL, NULL, NULL,
		(void *)&airs_sup_gran->mw_ret_code[0][0]);
  if (statn != 0)
    printf("Error %d reading field mw_ret_code\n", statn);

  statn = SWreadfield(swid, "sccnn_ret_code", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sccnn_ret_code[0][0]);
  if (statn != 0)
    printf("Error %d reading field sccnn_ret_code\n", statn);

  statn = SWreadfield(swid, "cloudy_reg_ret_code", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cloudy_reg_ret_code[0][0]);
  if (statn != 0)
    printf("Error %d reading field cloudy_reg_ret_code\n", statn);

  statn = SWreadfield(swid, "Cloudy_Reg_FOV_chan", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Cloudy_Reg_FOV_chan[0][0]);
  if (statn != 0)
    printf("Error %d reading field Cloudy_Reg_FOV_chan\n", statn);

  statn = SWreadfield(swid, "Cloudy_Reg_FOV", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Cloudy_Reg_FOV[0][0]);
  if (statn != 0)
    printf("Error %d reading field Cloudy_Reg_FOV\n", statn);

  statn = SWreadfield(swid, "Cloudy_Reg_FOV_BT", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Cloudy_Reg_FOV_BT[0][0]);
  if (statn != 0)
    printf("Error %d reading field Cloudy_Reg_FOV_BT\n", statn);

  statn = SWreadfield(swid, "Cloudy_Reg_Score", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Cloudy_Reg_Score[0][0]);
  if (statn != 0)
    printf("Error %d reading field Cloudy_Reg_Score\n", statn);

  statn = SWreadfield(swid, "cloud_ice", NULL, NULL, NULL,
		(void *)&airs_sup_gran->cloud_ice[0][0]);
  if (statn != 0)
    printf("Error %d reading field cloud_ice\n", statn);

  statn = SWreadfield(swid, "icc_too_cloudy", NULL, NULL, NULL,
		(void *)&airs_sup_gran->icc_too_cloudy[0][0]);
  if (statn != 0)
    printf("Error %d reading field icc_too_cloudy\n", statn);

  statn = SWreadfield(swid, "icc_low_contrast", NULL, NULL, NULL,
		(void *)&airs_sup_gran->icc_low_contrast[0][0]);
  if (statn != 0)
    printf("Error %d reading field icc_low_contrast\n", statn);

  statn = SWreadfield(swid, "icc_bad_rad", NULL, NULL, NULL,
		(void *)&airs_sup_gran->icc_bad_rad[0][0]);
  if (statn != 0)
    printf("Error %d reading field icc_bad_rad\n", statn);

  statn = SWreadfield(swid, "icc_contrast", NULL, NULL, NULL,
		(void *)&airs_sup_gran->icc_contrast[0][0]);
  if (statn != 0)
    printf("Error %d reading field icc_contrast\n", statn);

  statn = SWreadfield(swid, "bad_1st", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_1st[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_1st\n", statn);

  statn = SWreadfield(swid, "bad_1st_surf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_1st_surf[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_1st_surf\n", statn);

  statn = SWreadfield(swid, "bad_1st_cc", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_1st_cc[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_1st_cc\n", statn);

  statn = SWreadfield(swid, "bad_1st_regres", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_1st_regres[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_1st_regres\n", statn);

  statn = SWreadfield(swid, "bad_1st_phys", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_1st_phys[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_1st_phys\n", statn);

  statn = SWreadfield(swid, "fcc_too_cloudy", NULL, NULL, NULL,
		(void *)&airs_sup_gran->fcc_too_cloudy[0][0]);
  if (statn != 0)
    printf("Error %d reading field fcc_too_cloudy\n", statn);

  statn = SWreadfield(swid, "fcc_low_contrast", NULL, NULL, NULL,
		(void *)&airs_sup_gran->fcc_low_contrast[0][0]);
  if (statn != 0)
    printf("Error %d reading field fcc_low_contrast\n", statn);

  statn = SWreadfield(swid, "fcc_bad_rad", NULL, NULL, NULL,
		(void *)&airs_sup_gran->fcc_bad_rad[0][0]);
  if (statn != 0)
    printf("Error %d reading field fcc_bad_rad\n", statn);

  statn = SWreadfield(swid, "fcc_contrast1", NULL, NULL, NULL,
		(void *)&airs_sup_gran->fcc_contrast1[0][0]);
  if (statn != 0)
    printf("Error %d reading field fcc_contrast1\n", statn);

  statn = SWreadfield(swid, "fcc_contrast2", NULL, NULL, NULL,
		(void *)&airs_sup_gran->fcc_contrast2[0][0]);
  if (statn != 0)
    printf("Error %d reading field fcc_contrast2\n", statn);

  statn = SWreadfield(swid, "bad_final", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final\n", statn);

  statn = SWreadfield(swid, "bad_final_cc", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final_cc[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final_cc\n", statn);

  statn = SWreadfield(swid, "bad_final_ir", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final_ir[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final_ir\n", statn);

  statn = SWreadfield(swid, "bad_final_surf", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final_surf[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final_surf\n", statn);

  statn = SWreadfield(swid, "bad_final_temp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final_temp[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final_temp\n", statn);

  statn = SWreadfield(swid, "bad_final_h2o", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final_h2o[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final_h2o\n", statn);

  statn = SWreadfield(swid, "bad_final_o3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final_o3[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final_o3\n", statn);

  statn = SWreadfield(swid, "bad_final_cloud", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_final_cloud[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_final_cloud\n", statn);

  statn = SWreadfield(swid, "bad_cc_cld_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_cc_cld_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_cc_cld_ret\n", statn);

  statn = SWreadfield(swid, "MW_IR_ret_differ", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MW_IR_ret_differ[0][0]);
  if (statn != 0)
    printf("Error %d reading field MW_IR_ret_differ\n", statn);

  statn = SWreadfield(swid, "bad_MW_low_resid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_MW_low_resid[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_MW_low_resid\n", statn);

  statn = SWreadfield(swid, "MW_low_atm_resid", NULL, NULL, NULL,
		(void *)&airs_sup_gran->MW_low_atm_resid[0][0]);
  if (statn != 0)
    printf("Error %d reading field MW_low_atm_resid\n", statn);

  statn = SWreadfield(swid, "final_AMSU_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_AMSU_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_AMSU_ret\n", statn);

  statn = SWreadfield(swid, "final_HSB_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_HSB_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_HSB_ret\n", statn);

  statn = SWreadfield(swid, "final_cloud_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_cloud_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_cloud_ret\n", statn);

  statn = SWreadfield(swid, "final_cloud_spot_ret3x3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_cloud_spot_ret3x3[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field final_cloud_spot_ret3x3\n", statn);

  statn = SWreadfield(swid, "final_surf_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_surf_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_surf_ret\n", statn);

  statn = SWreadfield(swid, "final_temp_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_temp_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_temp_ret\n", statn);

  statn = SWreadfield(swid, "final_h2o_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_h2o_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_h2o_ret\n", statn);

  statn = SWreadfield(swid, "final_o3_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_o3_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_o3_ret\n", statn);

  statn = SWreadfield(swid, "final_ch4_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_ch4_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_ch4_ret\n", statn);

  statn = SWreadfield(swid, "final_co_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_co_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_co_ret\n", statn);

  statn = SWreadfield(swid, "final_co2_ret", NULL, NULL, NULL,
		(void *)&airs_sup_gran->final_co2_ret[0][0]);
  if (statn != 0)
    printf("Error %d reading field final_co2_ret\n", statn);

  statn = SWreadfield(swid, "bad_vis_rad", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_vis_rad[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_vis_rad\n", statn);

  statn = SWreadfield(swid, "bad_vis_cal", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_vis_cal[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_vis_cal\n", statn);

  statn = SWreadfield(swid, "bad_vis_det_temp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_vis_det_temp[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_vis_det_temp\n", statn);

  statn = SWreadfield(swid, "bad_scan_hd_temp", NULL, NULL, NULL,
		(void *)&airs_sup_gran->bad_scan_hd_temp[0][0]);
  if (statn != 0)
    printf("Error %d reading field bad_scan_hd_temp\n", statn);

  statn = SWreadfield(swid, "Initial_CC_score", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Initial_CC_score[0][0]);
  if (statn != 0)
    printf("Error %d reading field Initial_CC_score\n", statn);

  statn = SWreadfield(swid, "Initial_CC_subscores", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Initial_CC_subscores[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field Initial_CC_subscores\n", statn);

  statn = SWreadfield(swid, "sccnn_bt_corr", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sccnn_bt_corr[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field sccnn_bt_corr\n", statn);

  statn = SWreadfield(swid, "sccnn_bt_corr_freq", NULL, NULL, NULL,
		(void *)&airs_sup_gran->sccnn_bt_corr_freq[0][0][0]);
  if (statn != 0)
    printf("Error %d reading field sccnn_bt_corr_freq\n", statn);

  statn = SWreadfield(swid, "relayer_num_nonpos_coef_h2o", NULL, NULL, NULL,
		(void *)&airs_sup_gran->relayer_num_nonpos_coef_h2o[0][0]);
  if (statn != 0)
    printf("Error %d reading field relayer_num_nonpos_coef_h2o\n", statn);

  statn = SWreadfield(swid, "relayer_num_nonpos_coef_o3", NULL, NULL, NULL,
		(void *)&airs_sup_gran->relayer_num_nonpos_coef_o3[0][0]);
  if (statn != 0)
    printf("Error %d reading field relayer_num_nonpos_coef_o3\n", statn);

  statn = SWreadfield(swid, "relayer_num_nonpos_coef_co", NULL, NULL, NULL,
		(void *)&airs_sup_gran->relayer_num_nonpos_coef_co[0][0]);
  if (statn != 0)
    printf("Error %d reading field relayer_num_nonpos_coef_co\n", statn);

  statn = SWreadfield(swid, "relayer_num_nonpos_coef_ch4", NULL, NULL, NULL,
		(void *)&airs_sup_gran->relayer_num_nonpos_coef_ch4[0][0]);
  if (statn != 0)
    printf("Error %d reading field relayer_num_nonpos_coef_ch4\n", statn);

  statn = SWreadfield(swid, "relayer_num_knots", NULL, NULL, NULL,
		(void *)&airs_sup_gran->relayer_num_knots[0][0]);
  if (statn != 0)
    printf("Error %d reading field relayer_num_knots\n", statn);

  statn = SWreadfield(swid, "relayer_degree", NULL, NULL, NULL,
		(void *)&airs_sup_gran->relayer_degree[0][0]);
  if (statn != 0)
    printf("Error %d reading field relayer_degree\n", statn);

  statn = SWreadfield(swid, "relayer_runge_kutta_bits", NULL, NULL, NULL,
		(void *)&airs_sup_gran->relayer_runge_kutta_bits[0][0]);
  if (statn != 0)
    printf("Error %d reading field relayer_runge_kutta_bits\n", statn);

  statn = SWreadfield(swid, "Num_Fill_Chan_Cloudy_Reg", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Num_Fill_Chan_Cloudy_Reg[0][0]);
  if (statn != 0)
    printf("Error %d reading field Num_Fill_Chan_Cloudy_Reg\n", statn);

  statn = SWreadfield(swid, "Num_Fill_Chan_SCCNN", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Num_Fill_Chan_SCCNN[0][0]);
  if (statn != 0)
    printf("Error %d reading field Num_Fill_Chan_SCCNN\n", statn);

  statn = SWreadfield(swid, "Num_Fill_Chan_Ang_Adj", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Num_Fill_Chan_Ang_Adj[0][0]);
  if (statn != 0)
    printf("Error %d reading field Num_Fill_Chan_Ang_Adj\n", statn);

  statn = SWreadfield(swid, "Doppler_shift_ppm", NULL, NULL, NULL,
		(void *)&airs_sup_gran->Doppler_shift_ppm[0][0]);
  if (statn != 0)
    printf("Error %d reading field Doppler_shift_ppm\n", statn);

  statn = SWreadfield(swid, "spectral_clear_indicator", NULL, NULL, NULL,
		(void *)&airs_sup_gran->spectral_clear_indicator[0][0][0][0]);
  if (statn != 0)
    printf("Error %d reading field spectral_clear_indicator\n", statn);

  statn = SWreadfield(swid, "num_clear_spectral_indicator", NULL, NULL, NULL,
		(void *)&airs_sup_gran->num_clear_spectral_indicator[0][0]);
  if (statn != 0)
    printf("Error %d reading field num_clear_spectral_indicator\n", statn);

  statn = SWreadfield(swid, "orbit_phase_deg", NULL, NULL, NULL,
		(void *)&airs_sup_gran->orbit_phase_deg[0]);
  if (statn != 0)
    printf("Error %d reading field orbit_phase_deg\n", statn);

  statn = SWreadfield(swid, "shift_y0", NULL, NULL, NULL,
		(void *)&airs_sup_gran->shift_y0[0][0]);
  if (statn != 0)
    printf("Error %d reading field shift_y0\n", statn);

  statn = SWreadfield(swid, "scan_freq", NULL, NULL, NULL,
		(void *)&airs_sup_gran->scan_freq[0][0]);
  if (statn != 0)
    printf("Error %d reading field scan_freq\n", statn);

  statn = SWreadfield(swid, "L1cProc", NULL, NULL, NULL,
		(void *)&airs_sup_gran->L1cProc[0][0]);
  if (statn != 0)
    printf("Error %d reading field L1cProc\n", statn);

  statn = SWreadfield(swid, "L1cCleanReason", NULL, NULL, NULL,
		(void *)&airs_sup_gran->L1cCleanReason[0][0]);
  if (statn != 0)
    printf("Error %d reading field L1cCleanReason\n", statn);

  statn = SWreadfield(swid, "L1C_Reconst_Bias", NULL, NULL, NULL,
		(void *)&airs_sup_gran->L1C_Reconst_Bias[0]);
  if (statn != 0)
    printf("Error %d reading field L1C_Reconst_Bias\n", statn);

  statn = SWreadfield(swid, "L1C_Reconst_Dev", NULL, NULL, NULL,
		(void *)&airs_sup_gran->L1C_Reconst_Dev[0]);
  if (statn != 0)
    printf("Error %d reading field L1C_Reconst_Dev\n", statn);



  /* Final clean-up */
  statn = SWdetach(swid);
  if (statn != 0) printf("Error detaching from input file %s\n", file_name);

  statn = SWclose(fid);
  if (statn != 0) printf("Error closing input file %s\n", file_name);
}
