#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "airs_sup_typ.h"
#include "airs_sup_struct.h"


/*
 * Note: this struct is large.  On my system this works
 * when allocated this way but not when allocated as an automatic
 * local variable in main().  It could also be dynamically allocated
 * with malloc().
 */

#define MYTRUE  0
#define MYFALSE	1

#define SWAP_IN MYFALSE
#define SWAP_OUT MYFALSE

#define	ADDF_RECORD_LEN		4000
#define	ADDF_HEADER_WDS		ADDF_RECORD_LEN/4
#define ADDF_DATA_WDS		ADDF_RECORD_LEN/2

#define	ISPV			-32768
#define MISVAL			-9999.0

static airs_sup_gran_t airs_sup_gran;		
void convert_time(double, int *, int *, int *, int *);
float cden_to_mr(float, float *, int);

int main(int argc, char * argv[]) { 


  int layer; /* 0-based atmospheric pressure layer index. */
             /* 0 is surface (or below) */
  int track; /* 0-based index along track */
  int xtrack;/* 0-based index across-track */
  char * file_name = 0;


	int	out_header[ADDF_DATA_WDS];
	short	buffer[ADDF_DATA_WDS];		
	FILE	*out;
	struct  tm *ts;
	long	offset;
	int	frame_record, in_file_num, out_record;
	int	year, mmdd, hour, mmss;
	int	month, day, yyyymmdd; 
	double	spot_time;
	time_t	date_time;
	float	cden, mxratio,pobs[100];
	int 	i,j,k,np, nrecord=0;



/*-------------------------------------------------------------*/

	track=AIRS_SUP_GEOTRACK;
	xtrack=AIRS_SUP_GEOXTRACK;


	/* if the output file does not exist, a new header wil be created 
	   containing defalut values. If teh file exists, the header record
	   is read out */

	if ( (out=fopen("out.file","r"))==NULL)
	  {
		for (i=0; i<ADDF_HEADER_WDS; i++)
			out_header[i]= -32768;
		out_header[0]=65686870;
		out_header[1]=10;
		out_header[2]=1;
		out_header[3]=ADDF_RECORD_LEN;
		out_header[4]=ADDF_RECORD_LEN;
		out_header[6]=0;

		
		if(SWAP_OUT ==MYTRUE)
		  {
			for(i=0;i<ADDF_HEADER_WDS;i++)
			out_header[i]= htonl(out_header[i]);
		  }

	/* chech to see if the file can be open for output */
		if ((out=fopen("out.file", "w")) == NULL)
	  	{
		printf("\n the output file can not be opened for output.\n");
		exit(1);
	 	 }

		fseek(out, 0, SEEK_SET);		
		fwrite(&out_header, ADDF_RECORD_LEN, 1, out);
		fclose(out);
	  }


	/* link to the subroutine	*/
	file_name=argv[1];
  	airs_sup_rdr(file_name, &airs_sup_gran); 	


	/* open the out file for writing */      
	if ((out=fopen("out.file", "r+"))== NULL)
	  {
		printf("\n the output file can not be opened for writing.\n");
		printf("stop running.\n");
		exit(1);
	  }


	/* read the output file header */
	fread(&out_header, ADDF_RECORD_LEN, 1, out);	

	/* initilize some para */
	out_record=out_header[2];

	/*data frame record */
	out_record++;
	frame_record = out_record;
	in_file_num = out_header[6] + 1;
	
/*
	printf("\n frame_record=%d\n",frame_record);
	printf("\n in_file_num=%d\n",in_file_num);
*/


	printf("\ngranule number=%d\n",airs_sup_gran.granule_number);	
	printf("\nnum_scansets=%d\n",airs_sup_gran.num_scansets);	
	printf("\nnum_scanlines=%d\n",airs_sup_gran.num_scanlines);	

	/* loop through all of the FOV. For each FOV, scale and copy the
	 data to the output buffer and write the buffer data to the output
	 file */			
	for (j=0; j<track; j++)
	  {
		for (i=0;i<xtrack; i++)
		  {
			for(np=0; np<ADDF_DATA_WDS;np++)
				buffer[np] = ISPV;
			
			nrecord++;
			buffer[0] = 0;
			buffer[3] = airs_sup_gran.Latitude[j][i] * 128;
			buffer[4] = airs_sup_gran.Longitude[j][i] * 128; 	

			spot_time = airs_sup_gran.Time[j][i];
			convert_time (spot_time, &year, &mmdd, &hour, &mmss);
			buffer[5] = year;
			buffer[6] = mmdd;
			buffer[7] = hour;
			buffer[8] = mmss;

			buffer[12] = in_file_num;

			for (k=0;k<6;k++)
			buffer[13+k] = airs_sup_gran.DayNightFlag[k];

			for (k=0;k<10;k++)
			buffer[19+k] = airs_sup_gran.node_type[k];

			buffer[29] = airs_sup_gran.topog[j][i];
			buffer[30] = airs_sup_gran.topog_err[j][i];
			buffer[31] = airs_sup_gran.landFrac[j][i] * 1000;
			buffer[32] = airs_sup_gran.landFrac_err[j][i] * 1000;

/* bomin added 3/12/09 */
			buffer[33] = airs_sup_gran.MWSurfClass[j][i];
/*  */


			


			for (k=0;k<100; k++)
			{
			if(k<20)
			buffer[35+k] = airs_sup_gran.pressSupp[k] * 1000;
			else
			buffer[35+k] = airs_sup_gran.pressSupp[k] * 10;
			}

			for (k=0;k<100; k++)
			pobs[k] = airs_sup_gran.pressSupp[k];
/* not in v06
			buffer[135] = airs_sup_gran.Qual_Guess_PSurf[j][i];
*/
			buffer[136] = airs_sup_gran.PSurfStd[j][i] * 10;
			buffer[137] = airs_sup_gran.nSurfSup[j][i];
			buffer[138] = airs_sup_gran.nBestSup[j][i];
			buffer[139] = airs_sup_gran.nGoodSup[j][i];
			buffer[140] = airs_sup_gran.PBest[j][i]*10;
			buffer[141] = airs_sup_gran.PGood[j][i]*10;
/* not in v6
		buffer[142] = airs_sup_gran.Press_mid_top_bndry[j][i]*10;
		buffer[143] = airs_sup_gran.Press_bot_mid_bndry[j][i]*10;
		buffer[144] = airs_sup_gran.nSup_mid_top_bndry[j][i];
		buffer[145] = airs_sup_gran.nSup_bot_mid_bndry[j][i];
*/

/* not in v6
			buffer[146] = airs_sup_gran.Qual_Temp_Profile_Top[j][i];
			buffer[147] = airs_sup_gran.Qual_Temp_Profile_Mid[j][i];
			buffer[148] = airs_sup_gran.Qual_Temp_Profile_Bot[j][i];
*/

			for (k=0;k<100;k++)
/* test
			if( k == 0)
			if( k > 0)
			{
*/
			if(airs_sup_gran.TAirSup[j][i][k] != MISVAL)
			buffer[149+k] = airs_sup_gran.TAirSup[j][i][k]*64;
/*
			}
			else
			{
			if(airs_sup_gran.TAirSup[j][i][k-1] != MISVAL && airs_sup_gran.TAirSup[j][i][k] != MISVAL)
			buffer[149+k] = (airs_sup_gran.TAirSup[j][i][k-1] + airs_sup_gran.TAirSup[j][i][k] )/2.*64;
			}
*/

			for (k=0;k<100;k++)
/*
			if( k == 0)
			{
*/
			if(airs_sup_gran.TAirSupErr[j][i][k] != MISVAL)
			buffer[249+k] = airs_sup_gran.TAirSupErr[j][i][k]*64;
/*
			}
			else
			{
			if(airs_sup_gran.TAirSupErr[j][i][k-1] != MISVAL && airs_sup_gran.TAirSupErr[j][i][k] != MISVAL)
			buffer[249+k] = (airs_sup_gran.TAirSupErr[j][i][k-1] + airs_sup_gran.TAirSupErr[j][i][k] )/2.*64;
			}
*/

			if(airs_sup_gran.TSurfAir[j][i] != MISVAL)
			buffer[349] = airs_sup_gran.TSurfAir[j][i]*64;

			if(airs_sup_gran.TSurfAirErr[j][i] != MISVAL)
			buffer[350] = airs_sup_gran.TSurfAirErr[j][i]*64;

/* not in v6
			if(airs_sup_gran.Qual_Surf[j][i] != MISVAL)
			buffer[351] = airs_sup_gran.Qual_Surf[j][i];
*/

			if(airs_sup_gran.TSurfStd[j][i] != MISVAL)
			buffer[352] = airs_sup_gran.TSurfStd[j][i]*64;

			if(airs_sup_gran.TSurfStdErr[j][i] != MISVAL)
			buffer[353] = airs_sup_gran.TSurfStdErr[j][i]*64;
	
/* not in v6
			buffer[354] = airs_sup_gran.Qual_H2O[j][i];
*/


			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OCDSup[j][i][k] != MISVAL)
			{
			cden = airs_sup_gran.H2OCDSup[j][i][k];
			mxratio = cden_to_mr (cden, pobs, k);
			buffer[355+k] = log (mxratio) * 1024;
			}
			
			for (k=0;k<100;k++)
			if(airs_sup_gran.H2OCDSupErr[j][i][k] != MISVAL)
			{
			cden = airs_sup_gran.H2OCDSupErr[j][i][k];
			mxratio = cden_to_mr (cden, pobs, k);
			buffer [455+k] = log (mxratio) * 1024;
			}

			if(airs_sup_gran.totH2OStd[j][i] != MISVAL)
			buffer[555] = airs_sup_gran.totH2OStd[j][i] * 100;

			if(airs_sup_gran.totH2OStdErr[j][i] != MISVAL)
			buffer[556] = airs_sup_gran.totH2OStdErr[j][i] * 100;

			if(airs_sup_gran.PTropopause[j][i] != MISVAL)
			buffer[557] = airs_sup_gran.PTropopause[j][i] * 10;

			if(airs_sup_gran.T_Tropopause[j][i] != MISVAL)
			buffer[558] = airs_sup_gran.T_Tropopause[j][i] * 64;

			if(airs_sup_gran.GP_Tropopause[j][i] != MISVAL)	
			buffer[559] = airs_sup_gran.GP_Tropopause[j][i] + 0.5;

			if(airs_sup_gran.GP_Surface[j][i] != MISVAL)
			buffer[560] = airs_sup_gran.GP_Surface[j][i] + 0.5;
/* not in v6
		buffer[561] = airs_sup_gran.Qual_MW_Only_Temp_Strat[j][i];
		buffer[562] = airs_sup_gran.Qual_MW_Only_Temp_Tropo[j][i];
*/


		for (k=0;k<100;k++)
/*
		if ( k == 0)
		{
*/
		if(airs_sup_gran.TAirMWOnly[j][i][k] != MISVAL)
		buffer[563+k] = airs_sup_gran.TAirMWOnly[j][i][k] * 64;
/*
		}
		else
		{
		if(airs_sup_gran.TAirMWOnly[j][i][k-1] != MISVAL && airs_sup_gran.TAirMWOnly[j][i][k] != MISVAL)
		buffer[563+k] = (airs_sup_gran.TAirMWOnly[j][i][k-1]+airs_sup_gran.TAirMWOnly[j][i][k])/2. * 64;
		}
*/

		for (k=0;k<100;k++)
/*
		if (k == 0)
		{
*/
		if(airs_sup_gran.TAirCldyReg[j][i][k] != MISVAL)
		buffer[663+k] = airs_sup_gran.TAirCldyReg[j][i][k] * 64;
/*
		}
		else
		{
		if(airs_sup_gran.TAirCldyReg[j][i][k-1] != MISVAL && airs_sup_gran.TAirCldyReg[j][i][k] != MISVAL)
		buffer[663+k] = (airs_sup_gran.TAirCldyReg[j][i][k-1]+airs_sup_gran.TAirCldyReg[j][i][k])/2. * 64;
		}
*/
		
/* not in v6
		buffer[763] = airs_sup_gran.Qual_MW_Only_H2O[j][i];
*/

		if(airs_sup_gran.totH2OMWOnlyStd[j][i] != MISVAL)
		buffer[764] = airs_sup_gran.totH2OMWOnlyStd[j][i] * 100;

		for(k=0;k<100;k++)
		if(airs_sup_gran.H2OCDMWOnly[j][i][k] != MISVAL)
		{
		cden = airs_sup_gran.H2OCDMWOnly[j][i][k];
		mxratio = cden_to_mr (cden, pobs, k);
		buffer [765+k] = log (mxratio) * 1024;
		}

		for(k=0;k<100;k++)
		if(airs_sup_gran.H2OCDCldyReg[j][i][k] != MISVAL) 
		{
		cden = airs_sup_gran.H2OCDCldyReg[j][i][k];
		mxratio = cden_to_mr (cden, pobs, k);
		buffer[865+k] = log (mxratio) * 1024;
		}


		if(airs_sup_gran.TSurf1Ret[j][i] != MISVAL)
		buffer[965] = airs_sup_gran.TSurf1Ret[j][i] * 64;

		if(airs_sup_gran.TSurfAir1Ret[j][i] != MISVAL)
		buffer[966] = airs_sup_gran.TSurfAir1Ret[j][i] * 64;

		for (k=0;k<100;k++)
/*
		if (k == 0)
		{
*/
		if(airs_sup_gran.TAir1Ret[j][i][k] != MISVAL)
		buffer[967+k] = airs_sup_gran.TAir1Ret[j][i][k] * 64;
/*
		}
		else
		{
		if(airs_sup_gran.TAir1Ret[j][i][k-1] != MISVAL && airs_sup_gran.TAir1Ret[j][i][k] != MISVAL)
		buffer[967+k] = (airs_sup_gran.TAir1Ret[j][i][k-1]+airs_sup_gran.TAir1Ret[j][i][k])/2. * 64;
		}
*/

		for (k=0;k<100;k++)
		if(airs_sup_gran.H2OCD1Ret[j][i][k] != MISVAL)
		{
		cden = airs_sup_gran.H2OCD1Ret[j][i][k];
		mxratio = cden_to_mr (cden, pobs, k);
		buffer[1067+k] = log (mxratio) * 1024;
		}


/* 03/12/09  the following cloud para added		*/
		if(airs_sup_gran.numCloud[j][i] != MISVAL)
		buffer[1167] = airs_sup_gran.numCloud[j][i];

		for (k=0;k<2;k++)
		if(airs_sup_gran.TCldTopStd[j][i][k] != MISVAL)
		{
		buffer[1168+k] = airs_sup_gran.TCldTopStd[j][i][k] *64;
		}

		for (k=0;k<2;k++)
		if(airs_sup_gran.PCldTopStd[j][i][k] != MISVAL)
		{
		buffer[1170+k] = airs_sup_gran.PCldTopStd[j][i][k] *10;
		}

		for (k=0;k<2;k++)
		if(airs_sup_gran.CldFrcStd[j][i][1][1][k] != MISVAL)
		{
		buffer[1172+k] = airs_sup_gran.CldFrcStd[j][i][1][1][k]*100;
		}

/* 02/18/10  solar zenith angle para added		*/
		if(airs_sup_gran.solzen[j][i] != MISVAL)
		buffer[1174] = airs_sup_gran.solzen[j][i]*10;


		/* write the data buffer to the output file */
			out_record++;
			offset = (out_record - 1) * ADDF_RECORD_LEN;
			fseek(out, offset, SEEK_SET);
			fwrite(&buffer, ADDF_RECORD_LEN, 1, out);
		  }
	  }	  	

/*	printf("\nout_record=%d\n",out_record);	*/

	/* write the data frame */
	for (i=0; i<ADDF_DATA_WDS; i++)
		buffer[i] = ISPV;
	
	buffer[0] = 3;
	buffer[1] = in_file_num;
	buffer[2] = nrecord;       

	buffer[4] = airs_sup_gran.Latitude[0][0] * 128; 
	buffer[5] = airs_sup_gran.Latitude[0][xtrack-1] * 128; 
	buffer[6] = airs_sup_gran.Latitude[track-1][xtrack-1] * 128; 
	buffer[7] = airs_sup_gran.Latitude[track-1][0] * 128; 
	buffer[8] = airs_sup_gran.Longitude[0][0] * 128; 
	buffer[9] = airs_sup_gran.Longitude[0][xtrack-1] * 128; 
	buffer[10] = airs_sup_gran.Longitude[track-1][xtrack-1] * 128; 
	buffer[11] = airs_sup_gran.Longitude[track-1][0] * 128; 



	/* write the frame buffer to the output file */
/*	printf("\n frame_record=%d\n",frame_record);	*/
	offset = (frame_record - 1) * ADDF_RECORD_LEN;
	fseek(out, offset, SEEK_SET);
	fwrite(&buffer, ADDF_RECORD_LEN, 1, out);

	/* obtain the current time */
	time(&date_time);
	ts = localtime(&date_time);
	month = ts->tm_mon + 1;
	day = ts->tm_mday;
	year = ts->tm_year + 1900;
	yyyymmdd = year * 10000 + month * 100 + day; 

	/* update the header records */
	out_header[2] = out_record;
	out_header[5] = yyyymmdd;
	out_header[6] = in_file_num;
	
	/* write the header buffer to the output file */
	fseek(out, 0, SEEK_SET);
	fwrite(&out_header, ADDF_RECORD_LEN, 1, out);
	fclose(out);

}


