#include <stdio.h>
#include <time.h>
#include <math.h>

/* convert layer water vapor density (molcules/cm**2 to mixing ratio (g/kg)*/
/*	cden:	column density in mol/cm**2
	pobs:	pressure (array) in mb
	k:	integer for kth level	for airs L2 level is from top downards 
*/

float cden_to_mr (float cden, float *pobs, int k)		

/*float cden_to_mr (cden, pobs, k)		
float cden, *pobs;
int	k;	*/
{


float	g = 980.0, avogd = 6.02e+23, h2owgt = 18.016;
float	pk1, pk, q2;
float	mxratio;

	/* pressures	*/
	if( k == 0 )
		{
			pk1 = 0;
			pk = *pobs;
		}
	else
		{
			pk1 = *(pobs+k-1);
			pk = *(pobs+k);
		}


	/* calculate q2 	*/
	q2 = cden * 1.0e+3 / (pk-pk1);	

	/* mixing ratio in g/kg	*/
	mxratio = q2 * h2owgt / avogd;
	
	return (mxratio);

}
