/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.JPanel;

public class StatGraph
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int width;
    private int height;
    private Image offscreen_image;
    private int data_type;
    private String file_name;
    private int[] block_offsets;
    private String[] block_descriptions;
    private int current_block;
    private String[][] group_description;
    private boolean data_available;
    private boolean show_bias;
    private boolean show_stddev;
    private boolean show_rms;
    private boolean show_samplesize;
    private boolean[][][] show_profile;
    private boolean[][] profile_match_array;
    private int num_days;
    private int num_subgroups;
    private String[] subgroup_names;
    private int[] dates;
    private NarcsDataProfile[][][] data_profile;
    private int min_count;
    private int max_count;
    private float min_stat;
    private float max_stat;
    private int min_max_option;
    private float default_min;
    private float default_max;
    private float manual_min;
    private float manual_max;
    private boolean ignore_extreme_values;
    private int number_of_x_points;
    private int[] from_record;
    private int[] to_record;
    private String[] date_string;
    private int mouse_start_x;
    private int mouse_start_y;
    private int mouse_end_x;
    private int mouse_end_y;
    private int[] date_x_locations;
    private int[] date_positions;
    private int[] current_dates;
    private NarcsGlobals globals;
    private final int PASSED_QC = 1;
    private final int FAILED_QC = 2;
    private final int PASSED_AND_FAILED_QC = 0;
    private final int SEA = 1;
    private final int NONSEA = 2;
    private final int UNDEFINED = 0;
    private final int SEA_AND_NONSEA = 0;
    private final int CLEAR = 1;
    private final int CLOUDY = 2;
    private final int CLEAR_AND_CLOUDY = 0;
    private final int SAMPLESIZE = 3;
    private final int BIAS = 0;
    private final int STDDEV = 1;
    private final int RMS = 2;
    private final int TEMPERATURE = 1;
    private final int MOISTURE = 2;

    public StatGraph(int n) {
        this.data_type = n;
        this.globals = new NarcsGlobals();
        this.number_of_x_points = 0;
        this.min_count = 0;
        this.max_count = 100;
        this.min_stat = -10.0f;
        this.max_stat = 10.0f;
        this.data_available = false;
        this.offscreen_image = null;
        this.block_descriptions = new String[1];
        if (n == 1) {
            this.block_descriptions[0] = "Temperature";
        } else if (n == 2) {
            this.block_descriptions[0] = "Water Vapor (pct error)";
        }
        this.fillProfileMatchArray();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_start_x = mouseEvent.getX();
        this.mouse_start_y = mouseEvent.getY();
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
        n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        graphics.dispose();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n3 = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n4 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n5 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n6 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n5, n6, n3, n4);
        graphics.dispose();
        if (n != this.mouse_start_x && n2 != this.mouse_start_y) {
            int n7 = Math.min(this.mouse_start_x, n);
            int n8 = Math.max(this.mouse_start_x, n);
            int n9 = Short.MIN_VALUE;
            int n10 = Short.MIN_VALUE;
            int n11 = 99999;
            int n12 = 99999;
            for (int i = 0; i < this.date_positions.length; ++i) {
                int n13;
                int n14 = Math.abs(this.date_positions[i] - n7);
                if (n14 < n11) {
                    n11 = n14;
                    n9 = i;
                }
                if ((n13 = Math.abs(this.date_positions[i] - n8)) >= n12) continue;
                n12 = n13;
                n10 = i;
            }
            n9 = Math.max(n9, 0);
            n10 = Math.min(n10, this.date_positions.length - 1);
            this.globals.setCurrentStartDate(this.current_dates[n9]);
            this.globals.setCurrentEndDate(this.current_dates[n10]);
            this.newTimeWindow();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.width = n3;
        this.height = n4;
        this.setPreferredSize(new Dimension(n3, n4));
        if (this.isVisible()) {
            this.offscreen_image = this.createImage(n3, n4);
            Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
            this.drawGraph(graphics2D, 0, 0, n3, n4, true);
            graphics2D.dispose();
            this.paintComponent(this.getGraphics());
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing() && this.offscreen_image != null) {
            graphics.drawImage(this.offscreen_image, 0, 0, this.width, this.height, this);
        }
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawGraph(graphics2D, n, n2, n3, n4, false);
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        int n7 = 5;
        int n8 = (int)((float)n4 * 0.05f);
        int n9 = (int)((float)(n3 - n7 * 2) * 0.1f);
        int n10 = n3 - n7 * 2 - n9;
        int n11 = (int)((float)(n4 - n7 * 2 - n8) * 0.15f);
        int n12 = n6 = n4 - n7 * 2 - n8 - n11;
        int n13 = n10;
        int n14 = n + n7;
        int n15 = n2 + n7 + n8;
        int n16 = n + n7 + n9;
        int n17 = n2 + n7 + n8 + n6;
        int n18 = n + n16;
        int n19 = n15;
        float f = (float)n10 / (float)(this.number_of_x_points - 1);
        this.date_x_locations = new int[this.number_of_x_points];
        for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
            this.date_x_locations[n5] = (int)((float)n5 * f);
        }
        if (bl) {
            this.date_positions = new int[this.number_of_x_points];
            for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
                this.date_positions[n5] = this.date_x_locations[n5] + n9;
            }
        }
        this.drawTitle(graphics2D, n, n2, n3, n8);
        this.drawMainGraph(graphics2D, n18, n19, n10, n6);
        this.drawYAxis(graphics2D, n14, n15, n9, n12);
        this.drawXAxis(graphics2D, n16, n17, n13, n11);
    }

    private void drawTitle(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("Serif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 - 2 || fontMetrics.stringWidth(this.block_descriptions[this.current_block]) >= n3 - 4) continue;
            bl = true;
        }
        int n6 = n + (n3 - fontMetrics.stringWidth(this.block_descriptions[this.current_block])) / 2;
        int n7 = n2 + n4 - 2;
        if (this.data_available) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(Color.gray);
        }
        graphics2D.drawString(this.block_descriptions[this.current_block], n6, n7);
    }

    private void drawYAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        char c;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl = this.show_bias || this.show_stddev || this.show_rms;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (bl && this.show_samplesize) {
            n11 = n10 = (int)((float)n3 * 0.1f);
            n13 = n12 = (int)((float)n3 * 0.4f);
        } else if (this.show_samplesize) {
            n10 = (int)((float)n3 * 0.2f);
            n12 = n3 - n10;
        } else {
            n11 = (int)((float)n3 * 0.2f);
            n13 = n3 - n11;
        }
        if (!bl && !this.show_samplesize) {
            bl = true;
        }
        String string = "";
        String string2 = "";
        String[] stringArray = new String[]{};
        if (bl) {
            string = "";
            if (this.show_rms) {
                string = string + " RMS /";
            }
            if (this.show_stddev) {
                string = string + " STD DEV /";
            }
            if (this.show_bias) {
                string = string + " BIAS /";
            }
            if (string.length() > 2) {
                string = string.substring(0, string.length() - 2).trim();
            }
            stringArray = new String[]{"" + this.oneDigit(this.min_stat), "" + this.oneDigit(this.min_stat + (this.max_stat - this.min_stat) * 0.25f), "" + this.oneDigit(this.min_stat + (this.max_stat - this.min_stat) * 0.5f), "" + this.oneDigit(this.min_stat + (this.max_stat - this.min_stat) * 0.75f), "" + this.oneDigit(this.max_stat)};
        }
        String[] stringArray2 = new String[]{};
        if (this.show_samplesize) {
            string2 = "SAMPLE SIZE";
            stringArray2 = new String[]{"" + this.min_count, "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.25f)), "" + (this.min_count + (this.max_count - this.min_count) / 2), "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.75f)), "" + this.max_count};
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n14 = 25;
        boolean bl2 = false;
        while (!bl2 && n14 > 5) {
            bl2 = true;
            graphics2D.setFont(new Font("SansSerif", 0, --n14));
            fontMetrics = graphics2D.getFontMetrics();
            if (bl) {
                if (fontMetrics.getHeight() * string.length() > n4 - 4) {
                    bl2 = false;
                }
                if (fontMetrics.stringWidth("M") > n11) {
                    bl2 = false;
                }
                for (n9 = 0; n9 < stringArray.length; ++n9) {
                    if (fontMetrics.stringWidth(stringArray[n9]) <= n13) continue;
                    bl2 = false;
                }
            }
            if (!this.show_samplesize) continue;
            if (fontMetrics.getHeight() * string2.length() > n4 - 4) {
                bl2 = false;
            }
            if (fontMetrics.stringWidth("M") > n10) {
                bl2 = false;
            }
            for (n9 = 0; n9 < stringArray2.length; ++n9) {
                if (fontMetrics.stringWidth(stringArray2[n9]) <= n12) continue;
                bl2 = false;
            }
        }
        if (this.show_samplesize) {
            if (this.data_available) {
                graphics2D.setColor(Color.black);
            } else {
                graphics2D.setColor(Color.gray);
            }
            n9 = 0;
            n8 = 0;
            n7 = n;
            n6 = n + n10 + n11;
            for (n5 = 0; n5 < string2.length(); ++n5) {
                c = string2.charAt(n5);
                n9 = n7 + (fontMetrics.stringWidth("M") - fontMetrics.stringWidth("" + c) / 2);
                n8 = n2 + n4 / 2 - fontMetrics.getHeight() * string2.length() / 2;
                n8 = n8 + n5 * fontMetrics.getHeight() + fontMetrics.getAscent();
                graphics2D.drawString("" + c, n9, n8);
            }
            for (n5 = 0; n5 < stringArray2.length; ++n5) {
                n9 = n + (n3 - 2);
                n8 = n2 + (n4 - (int)((float)n5 / (float)(stringArray2.length - 1) * (float)n4));
                graphics2D.drawLine(n9, n8, n9 + 2, n8);
                n9 = n6 + (n12 - fontMetrics.stringWidth(stringArray2[n5]));
                graphics2D.drawString(stringArray2[n5], n9, n8 += fontMetrics.getAscent() / 2);
            }
        }
        if (bl) {
            if (this.data_available) {
                graphics2D.setColor(Color.black);
            } else {
                graphics2D.setColor(Color.gray);
            }
            n9 = 0;
            n8 = 0;
            n7 = n + n10;
            n6 = n + n10 + n11 + n12;
            for (n5 = 0; n5 < string.length(); ++n5) {
                c = string.charAt(n5);
                n9 = n7 + (fontMetrics.stringWidth("M") - fontMetrics.stringWidth("" + c) / 2);
                n8 = n2 + n4 / 2 - fontMetrics.getHeight() * string.length() / 2;
                n8 = n8 + n5 * fontMetrics.getHeight() + fontMetrics.getAscent();
                graphics2D.drawString("" + c, n9, n8);
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                n9 = n + (n3 - 2);
                n8 = n2 + (n4 - (int)((float)n5 / (float)(stringArray.length - 1) * (float)n4));
                graphics2D.drawLine(n9, n8, n9 + 2, n8);
                n9 = n6 + (n13 - fontMetrics.stringWidth(stringArray[n5]));
                graphics2D.drawString(stringArray[n5], n9, n8 += fontMetrics.getAscent() / 2);
            }
        }
    }

    private void drawXAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("SansSerif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            bl = true;
            for (int i = 0; i < this.number_of_x_points; ++i) {
                if (fontMetrics.stringWidth(this.date_string[i]) <= n4 - 10) continue;
                bl = false;
            }
        }
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        graphics2D.setFont(font2);
        int n6 = -999;
        for (int i = 0; i < this.number_of_x_points; ++i) {
            int n7 = n + this.date_x_locations[i];
            int n8 = n2 + 7 + fontMetrics.stringWidth(this.date_string[i]);
            int n9 = n7 + fontMetrics.getAscent() / 2;
            if (n9 > n6) {
                graphics2D.drawString(this.date_string[i], n9, n8);
                n6 = n9 + fontMetrics.getAscent();
            }
            graphics2D.drawLine(n7, n2, n7, n2 + 5);
        }
        graphics2D.setFont(font);
    }

    private void drawMainGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.data_available) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(Color.gray);
        }
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics2D.setClip(n, n2, n3, n4);
        if (this.data_available) {
            int n5;
            Stroke stroke = graphics2D.getStroke();
            for (n5 = 0; n5 < this.num_subgroups; ++n5) {
                for (int i = 0; i < 27; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        if (!this.show_profile[n5][i][j] || this.data_profile[n5][i][j] == null) continue;
                        this.plotDataProfile(graphics2D, n, n2, n3, n4, this.data_profile[n5][i][j]);
                    }
                }
            }
            if (this.show_bias || this.show_stddev || this.show_rms) {
                graphics2D.setColor(Color.gray);
                n5 = 2;
                float[] fArray = new float[]{5.0f};
                BasicStroke basicStroke = new BasicStroke(n5, 0, 1, 5.0f, fArray, 0.0f);
                graphics2D.setStroke(basicStroke);
                int n6 = n2 + this.getY(0.0f, this.min_stat, this.max_stat, n4);
                graphics2D.drawLine(n, n6, n + n3, n6);
                graphics2D.setStroke(stroke);
            }
        }
        graphics2D.setClip(null);
    }

    private void plotDataProfile(Graphics2D graphics2D, int n, int n2, int n3, int n4, NarcsDataProfile narcsDataProfile) {
        Point point;
        int n5;
        int n6;
        Stroke stroke = graphics2D.getStroke();
        int n7 = narcsDataProfile.getGroupNumber();
        int n8 = narcsDataProfile.getDataType();
        int n9 = narcsDataProfile.getStatType();
        Color color = this.globals.getSubgroupColor(n7);
        int n10 = this.globals.getSubgroupLineThickness(n7, n8, n9);
        if (n10 == 0) {
            n10 = n4 / 200;
        }
        int n11 = this.globals.getSubgroupLineStyle(n7, n8, n9);
        this.globals.setLineStyle(graphics2D, n11, n10);
        int n12 = (int)((float)n10 + (float)n10 / 4.0f);
        n12 = Math.max(n12, 4);
        boolean bl = this.globals.getShowDataPoints();
        float f = this.min_stat;
        float f2 = this.max_stat;
        if (n9 == 3) {
            f = this.min_count;
            f2 = this.max_count;
        }
        Vector vector = new Vector();
        Vector<Point> vector2 = new Vector<Point>();
        graphics2D.setColor(color);
        for (n6 = 0; n6 < this.number_of_x_points; ++n6) {
            int n13 = Short.MIN_VALUE;
            float f3 = narcsDataProfile.getValue(n6);
            if (this.ignore_extreme_values) {
                if (f3 >= f && f3 <= f2) {
                    n13 = n2 + this.getY(f3, f, f2, n4);
                }
            } else if (f3 != -32768.0f) {
                n13 = n2 + this.getY(f3, f, f2, n4);
            }
            if ((n5 = n + this.date_x_locations[n6]) == Short.MIN_VALUE || n13 == Short.MIN_VALUE) {
                vector.add(vector2);
                vector2 = new Vector<Point>();
                continue;
            }
            if (bl) {
                graphics2D.fillOval(n5 - n12, n13 - n12, n12 * 2, n12 * 2);
            }
            point = new Point(n5, n13);
            vector2.add(point);
        }
        vector.add(vector2);
        for (n6 = 0; n6 < vector.size(); ++n6) {
            vector2 = (Vector<Point>)vector.elementAt(n6);
            int[] nArray = new int[vector2.size()];
            int[] nArray2 = new int[vector2.size()];
            for (n5 = 0; n5 < vector2.size(); ++n5) {
                point = (Point)vector2.elementAt(n5);
                nArray[n5] = point.x;
                nArray2[n5] = point.y;
            }
            graphics2D.drawPolyline(nArray, nArray2, vector2.size());
        }
        graphics2D.setStroke(stroke);
    }

    public void drawLegend(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        boolean[] blArray = new boolean[this.num_subgroups];
        int n9 = 0;
        for (int i = 0; i < this.num_subgroups; ++i) {
            blArray[i] = false;
            for (n8 = 0; n8 < 27; ++n8) {
                for (n7 = 0; n7 < 4; ++n7) {
                    if (!this.show_profile[i][n8][n7]) continue;
                    blArray[i] = true;
                }
            }
            if (!blArray[i]) continue;
            ++n9;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        n8 = 25;
        n7 = 0;
        while (n7 == 0 && n8 > 5) {
            graphics2D.setFont(new Font("SansSerif", 0, --n8));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() * 3 * n9 >= n4) continue;
            n6 = 1;
            for (n5 = 0; n5 < this.num_subgroups; ++n5) {
                if (!blArray[n5] || fontMetrics.stringWidth(this.subgroup_names[n5]) < n3) continue;
                n6 = 0;
            }
            n7 = n6;
        }
        n6 = n + 2;
        n5 = (int)((float)n4 * 0.05f);
        int n10 = n2 + n5;
        for (int i = 0; i < this.num_subgroups; ++i) {
            if (!blArray[i]) continue;
            Color color = this.globals.getSubgroupColor(i);
            graphics2D.setColor(color);
            graphics2D.drawString(this.subgroup_names[i], n6, n10 += fontMetrics.getHeight());
        }
    }

    public void newDataLevel(int n) {
        this.current_block = n;
        this.newTimeWindow();
    }

    public void newTimeWindow() {
        this.data_available = false;
        for (int i = 0; i < this.num_subgroups; ++i) {
            for (int j = 0; j < 27; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.data_profile[i][j][k] = null;
                }
            }
        }
        this.calculateDateIntervals();
        this.updateGraph();
    }

    public void removeProfiles() {
        this.data_available = false;
        for (int i = 0; i < this.num_subgroups; ++i) {
            for (int j = 0; j < 27; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.data_profile[i][j][k] = null;
                }
            }
        }
    }

    public void updateGraph() {
        this.show_bias = this.globals.getShowBias();
        this.show_stddev = this.globals.getShowStdDev();
        this.show_rms = this.globals.getShowRMS();
        this.show_samplesize = this.globals.getShowSampleSize();
        if (this.data_type == 1) {
            this.min_max_option = this.globals.getTempMinMaxOption();
            this.default_min = this.globals.getTempDefaultMin();
            this.default_max = this.globals.getTempDefaultMax();
            this.manual_min = this.globals.getTempManualMin();
            this.manual_max = this.globals.getTempManualMax();
            this.ignore_extreme_values = this.globals.getTempIgnoreExtremes();
        } else if (this.data_type == 2) {
            this.min_max_option = this.globals.getWvapMinMaxOption();
            this.default_min = this.globals.getWvapDefaultMin();
            this.default_max = this.globals.getWvapDefaultMax();
            this.manual_min = this.globals.getWvapManualMin();
            this.manual_max = this.globals.getWvapManualMax();
            this.ignore_extreme_values = this.globals.getWvapIgnoreExtremes();
        }
        if (this.file_name != null) {
            this.readData();
        }
        if (this.data_available) {
            this.findMinMax();
            if (this.isVisible() && this.isValid()) {
                this.offscreen_image = this.createImage(this.width, this.height);
                Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
                this.drawGraph(graphics2D, 0, 0, this.width, this.height, true);
                graphics2D.dispose();
                this.paintComponent(this.getGraphics());
            }
        }
    }

    public void addFileInfo(String string, int[] nArray, String[] stringArray, int n, int[] nArray2, int n2, String[] stringArray2) {
        this.file_name = string;
        this.block_offsets = nArray;
        this.block_descriptions = stringArray;
        this.num_days = n;
        this.dates = nArray2;
        this.num_subgroups = n2;
        this.subgroup_names = stringArray2;
        this.show_profile = new boolean[n2][27][4];
        this.data_profile = new NarcsDataProfile[n2][27][4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 27; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.show_profile[i][j][k] = false;
                    this.data_profile[i][j][k] = null;
                }
            }
        }
        this.current_block = 0;
    }

    private void readData() {
        try {
            this.determineWhichProfilesToShow();
            DataInputStream dataInputStream = null;
            if (this.file_name.equals("narcs_default.dat")) {
                InputStream inputStream = this.getClass().getResourceAsStream(this.file_name);
                dataInputStream = new DataInputStream(inputStream);
            } else {
                dataInputStream = this.file_name.endsWith(".gz") ? new DataInputStream(new GZIPInputStream(new FileInputStream(this.file_name))) : new DataInputStream(new FileInputStream(this.file_name));
            }
            dataInputStream.skipBytes(this.block_offsets[this.current_block]);
            for (int i = 0; i < this.num_subgroups; ++i) {
                Object object;
                Object object2;
                Object object3;
                int n;
                int n2;
                boolean bl = false;
                for (int j = 0; j < 27; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        if (!this.show_profile[i][j][k] || this.data_profile[i][j][k] != null) continue;
                        bl = true;
                    }
                }
                if (!bl) {
                    dataInputStream.skipBytes(432 * this.num_days);
                    continue;
                }
                float[][][] fArray = new float[this.num_days][27][4];
                boolean[][] blArray = new boolean[this.num_days][27];
                for (n2 = 0; n2 < this.num_days; ++n2) {
                    for (n = 0; n < 27; ++n) {
                        for (int j = 0; j < 4; ++j) {
                            fArray[n2][n][j] = 0.0f;
                            blArray[n2][n] = false;
                        }
                    }
                }
                for (n2 = 0; n2 < 27; ++n2) {
                    n = 0;
                    for (int j = 0; j < 27; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            if (!this.profile_match_array[j][n2] || !this.show_profile[i][j][k] || this.data_profile[i][j][k] != null) continue;
                            n = 1;
                        }
                    }
                    if (n == 0) {
                        dataInputStream.skipBytes(4 * this.num_days * 4);
                        continue;
                    }
                    byte[] byArray = new byte[this.num_days * 4];
                    dataInputStream.readFully(byArray);
                    DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
                    object3 = new byte[this.num_days * 4];
                    dataInputStream.readFully((byte[])object3);
                    object2 = new DataInputStream(new ByteArrayInputStream((byte[])object3));
                    byte[] byArray2 = new byte[this.num_days * 4];
                    dataInputStream.readFully(byArray2);
                    object = new DataInputStream(new ByteArrayInputStream(byArray2));
                    byte[] byArray3 = new byte[this.num_days * 4];
                    dataInputStream.readFully(byArray3);
                    DataInputStream dataInputStream3 = new DataInputStream(new ByteArrayInputStream(byArray3));
                    for (int j = 0; j < this.num_days; ++j) {
                        float f = dataInputStream2.readInt();
                        float f2 = (float)((DataInputStream)object2).readInt() / 1000.0f;
                        float f3 = (float)((DataInputStream)object).readInt() / 1000.0f;
                        float f4 = (float)dataInputStream3.readInt() / 1000.0f;
                        if (f == -32768.0f) continue;
                        for (int k = 0; k < 27; ++k) {
                            boolean bl2;
                            boolean bl3 = bl2 = this.show_profile[i][k][3] || this.show_profile[i][k][0] || this.show_profile[i][k][1] || this.show_profile[i][k][2];
                            if (!this.profile_match_array[k][n2] || !bl2 || this.data_profile[i][k][3] != null) continue;
                            float[] fArray2 = fArray[j][k];
                            fArray2[3] = fArray2[3] + f;
                            float[] fArray3 = fArray[j][k];
                            fArray3[0] = fArray3[0] + f * f2;
                            float[] fArray4 = fArray[j][k];
                            fArray4[1] = fArray4[1] + f * f3;
                            float[] fArray5 = fArray[j][k];
                            fArray5[2] = fArray5[2] + f * f4;
                            blArray[j][k] = true;
                        }
                    }
                    dataInputStream2.close();
                    ((FilterInputStream)object2).close();
                    ((FilterInputStream)object).close();
                    dataInputStream3.close();
                }
                for (n2 = 0; n2 < this.num_days; ++n2) {
                    for (n = 0; n < 27; ++n) {
                        if (fArray[n2][n][3] == -32768.0f || fArray[n2][n][3] == 0.0f) continue;
                        fArray[n2][n][0] = fArray[n2][n][0] / fArray[n2][n][3];
                        fArray[n2][n][1] = fArray[n2][n][1] / fArray[n2][n][3];
                        fArray[n2][n][2] = fArray[n2][n][2] / fArray[n2][n][3];
                    }
                }
                for (n2 = 0; n2 < this.num_days; ++n2) {
                    for (n = 0; n < 27; ++n) {
                        if (blArray[n2][n]) continue;
                        fArray[n2][n][0] = -32768.0f;
                        fArray[n2][n][1] = -32768.0f;
                        fArray[n2][n][2] = -32768.0f;
                        fArray[n2][n][3] = -32768.0f;
                    }
                }
                for (n2 = 0; n2 < 27; ++n2) {
                    int n3 = n = this.show_profile[i][n2][3] || this.show_profile[i][n2][0] || this.show_profile[i][n2][1] || this.show_profile[i][n2][2] ? 1 : 0;
                    if (n == 0 || this.data_profile[i][n2][3] != null) continue;
                    float[] fArray6 = new float[this.num_days];
                    for (int j = 0; j < this.num_days; ++j) {
                        fArray6[j] = fArray[j][n2][3];
                    }
                    float[] fArray7 = this.combineCounts(fArray6);
                    object3 = this.globals.getSubgroupColor(i);
                    object2 = this.getProfileTypes(n2);
                    this.data_profile[i][n2][3] = new NarcsDataProfile(fArray7, (Color)object3, i, n2, 3, (int)object2[0], (int)object2[1], (int)object2[2], this.subgroup_names[i]);
                    for (int j = 0; j < 3; ++j) {
                        object = new float[this.num_days];
                        for (int k = 0; k < this.num_days; ++k) {
                            object[k] = fArray[k][n2][j];
                        }
                        fArray7 = this.combineStats(fArray6, (float[])object);
                        this.data_profile[i][n2][j] = new NarcsDataProfile(fArray7, (Color)object3, i, n2, j, (int)object2[0], (int)object2[1], (int)object2[2], this.subgroup_names[i]);
                    }
                }
            }
            dataInputStream.close();
            this.data_available = true;
            this.findMinMax();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void determineWhichProfilesToShow() {
        for (int i = 0; i < this.num_subgroups; ++i) {
            for (int j = 0; j < 27; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.show_profile[i][j][k] = true;
                }
            }
        }
        boolean[] blArray = this.globals.getShowSubGroups();
        boolean[] blArray2 = new boolean[]{this.globals.getShowPassedAndFailedQC(), this.globals.getShowPassedQC(), this.globals.getShowFailedQC()};
        boolean[] blArray3 = new boolean[]{this.globals.getShowSeaAndNonsea(), this.globals.getShowSea(), this.globals.getShowNonsea()};
        boolean[] blArray4 = new boolean[]{this.globals.getShowClearAndCloudy(), this.globals.getShowClear(), this.globals.getShowCloudy()};
        for (int i = 0; i < this.num_subgroups; ++i) {
            int n = -1;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        ++n;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            if (!blArray[i]) {
                                this.show_profile[i][n][i3] = false;
                                continue;
                            }
                            if (!blArray2[j]) {
                                this.show_profile[i][n][i3] = false;
                            }
                            if (!blArray3[k]) {
                                this.show_profile[i][n][i3] = false;
                            }
                            if (blArray4[i2]) continue;
                            this.show_profile[i][n][i3] = false;
                        }
                        if (!this.show_bias) {
                            this.show_profile[i][n][0] = false;
                        }
                        if (!this.show_stddev) {
                            this.show_profile[i][n][1] = false;
                        }
                        if (!this.show_rms) {
                            this.show_profile[i][n][2] = false;
                        }
                        if (this.show_samplesize) continue;
                        this.show_profile[i][n][3] = false;
                    }
                }
            }
        }
    }

    private void calculateDateIntervals() {
        block21: {
            int n;
            int n2;
            block22: {
                block20: {
                    long l = this.globals.getCurrentStartDate();
                    long l2 = this.globals.getCurrentEndDate();
                    n2 = 0;
                    for (n = this.dates.length - 1; n > 0 && l < (long)this.dates[n]; --n) {
                    }
                    while (n2 < this.dates.length - 1 && l2 > (long)this.dates[n2]) {
                        ++n2;
                    }
                    int n3 = n2 - n + 1;
                    if (this.globals.getTimeWindowOption() != 0) break block20;
                    this.number_of_x_points = n3;
                    this.from_record = new int[this.number_of_x_points];
                    this.to_record = new int[this.number_of_x_points];
                    this.date_string = new String[this.number_of_x_points];
                    this.current_dates = new int[this.number_of_x_points];
                    for (int i = 0; i < this.number_of_x_points; ++i) {
                        this.from_record[i] = n + i;
                        this.to_record[i] = n + i;
                        int n4 = this.dates[n + i] / 10000;
                        int n5 = this.dates[n + i] % 10000 / 100;
                        int n6 = this.dates[n + i] % 100;
                        String string = "" + n4 % 100;
                        if (n4 % 100 < 10) {
                            string = "0" + string;
                        }
                        this.date_string[i] = "" + n5 + "/" + n6 + "/" + string;
                        this.current_dates[i] = n4 * 10000 + n5 * 100 + n6;
                    }
                    break block21;
                }
                if (this.globals.getTimeWindowOption() != 1) break block22;
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                int n7 = this.dates[n] / 10000;
                int n8 = this.dates[n] % 10000 / 100 - 1;
                int n9 = this.dates[n] % 100;
                calendar.set(n7, n8, n9);
                while (calendar.get(7) != 1) {
                    calendar.add(5, -1);
                }
                Calendar calendar2 = Calendar.getInstance();
                calendar2.clear();
                n7 = this.dates[n2] / 10000;
                n8 = this.dates[n2] % 10000 / 100 - 1;
                n9 = this.dates[n2] % 100;
                calendar2.set(n7, n8, n9);
                while (calendar2.get(7) != 7) {
                    calendar2.add(5, 1);
                }
                this.number_of_x_points = 0;
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                n7 = this.dates[n] / 10000;
                n8 = this.dates[n] % 10000 / 100 - 1;
                n9 = this.dates[n] % 100;
                calendar3.set(n7, n8, n9);
                while (!calendar3.after(calendar2)) {
                    ++this.number_of_x_points;
                    calendar3.add(5, 7);
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                calendar3 = (Calendar)calendar.clone();
                int n10 = 0;
                while (calendar3.before(calendar2)) {
                    int n11 = calendar3.get(1);
                    int n12 = calendar3.get(2) + 1;
                    int n13 = calendar3.get(5);
                    int n14 = n11 * 10000 + n12 * 100 + n13;
                    String string = "" + n11 % 100;
                    if (n11 % 100 < 10) {
                        string = "0" + string;
                    }
                    calendar3.add(5, 6);
                    int n15 = calendar3.get(1);
                    int n16 = calendar3.get(2) + 1;
                    int n17 = calendar3.get(5);
                    int n18 = n15 * 10000 + n16 * 100 + n17;
                    String string2 = "" + n15 % 100;
                    if (n15 % 100 < 10) {
                        string2 = "0" + string2;
                    }
                    this.date_string[n10] = "" + n12 + "/" + n13 + "/" + string;
                    this.current_dates[n10] = n11 * 10000 + n12 * 100 + n13;
                    this.from_record[n10] = Short.MIN_VALUE;
                    this.to_record[n10] = Short.MIN_VALUE;
                    for (int i = 0; i < this.dates.length; ++i) {
                        if (this.dates[i] < n14 || this.dates[i] > n18) continue;
                        if (this.from_record[n10] == Short.MIN_VALUE) {
                            this.from_record[n10] = i;
                        }
                        this.to_record[n10] = i;
                    }
                    ++n10;
                    calendar3.add(5, 1);
                }
                break block21;
            }
            if (this.globals.getTimeWindowOption() != 2) break block21;
            int n19 = this.dates[n] / 100;
            int n20 = this.dates[n2] / 100;
            if (n19 == n20) {
                this.number_of_x_points = 1;
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.from_record[0] = n;
                this.to_record[0] = n2;
                this.date_string = new String[1];
                int n21 = n19 / 100;
                int n22 = n19 % 100;
                this.date_string[0] = "" + n22 + "/" + n21;
                this.current_dates = new int[1];
                this.current_dates[0] = n21 * 10000 + n22 * 100 + 1;
            } else {
                int n23;
                int n24;
                this.number_of_x_points = 0;
                int n25 = n19;
                while (n25 <= n20) {
                    n24 = n25 / 100;
                    n23 = n25 % 100;
                    if (++n23 > 12) {
                        n23 = 1;
                        ++n24;
                    }
                    n25 = n24 * 100 + n23;
                    ++this.number_of_x_points;
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                n25 = n19;
                n24 = 0;
                while (n25 <= n20) {
                    n23 = n25 / 100;
                    int n26 = n25 % 100;
                    this.from_record[n24] = Short.MIN_VALUE;
                    this.to_record[n24] = Short.MIN_VALUE;
                    for (int i = n; i <= n2; ++i) {
                        int n27 = this.dates[i] / 100;
                        if (n27 != n25) continue;
                        if (this.from_record[n24] == Short.MIN_VALUE) {
                            this.from_record[n24] = i;
                        }
                        this.to_record[n24] = i;
                    }
                    this.date_string[n24] = "" + n26 + "/" + n23;
                    this.current_dates[n24] = n23 * 10000 + n26 * 100 + 1;
                    ++n24;
                    if (++n26 > 12) {
                        n26 = 1;
                        ++n23;
                    }
                    n25 = n23 * 100 + n26;
                }
            }
        }
    }

    private float[] combineCounts(float[] fArray) {
        int n;
        float[] fArray2 = new float[this.number_of_x_points];
        Arrays.fill(fArray2, 0.0f);
        boolean[] blArray = new boolean[this.number_of_x_points];
        Arrays.fill(blArray, false);
        for (n = 0; n < this.number_of_x_points; ++n) {
            for (int i = this.from_record[n]; i <= this.to_record[n]; ++i) {
                if (fArray[i] == -32768.0f) continue;
                int n2 = n;
                fArray2[n2] = fArray2[n2] + fArray[i];
                blArray[n] = true;
            }
        }
        for (n = 0; n < this.number_of_x_points; ++n) {
            if (blArray[n]) continue;
            fArray2[n] = -32768.0f;
        }
        return fArray2;
    }

    private float[] combineStats(float[] fArray, float[] fArray2) {
        int n;
        float[] fArray3 = new float[this.number_of_x_points];
        Arrays.fill(fArray3, 0.0f);
        float[] fArray4 = new float[this.number_of_x_points];
        Arrays.fill(fArray4, 0.0f);
        boolean[] blArray = new boolean[this.number_of_x_points];
        Arrays.fill(blArray, false);
        for (n = 0; n < this.number_of_x_points; ++n) {
            for (int i = this.from_record[n]; i <= this.to_record[n]; ++i) {
                if (fArray[i] == -32768.0f || fArray[i] == 0.0f) continue;
                int n2 = n;
                fArray3[n2] = fArray3[n2] + fArray[i];
                int n3 = n;
                fArray4[n3] = fArray4[n3] + fArray[i] * fArray2[i];
                blArray[n] = true;
            }
        }
        for (n = 0; n < this.number_of_x_points; ++n) {
            if (fArray3[n] != -32768.0f && fArray3[n] != 0.0f) {
                fArray4[n] = fArray4[n] / fArray3[n];
            }
            if (blArray[n]) continue;
            fArray4[n] = -32768.0f;
        }
        return fArray4;
    }

    private void findMinMax() {
        float f;
        float f2;
        if (this.globals.getSampleSizeMinMaxOption() == 2) {
            this.min_count = this.globals.getSampleSizeManualMin();
            this.max_count = this.globals.getSampleSizeManualMax();
        } else {
            this.min_count = 9999999;
            this.max_count = -9999999;
            for (int i = 0; i < this.num_subgroups; ++i) {
                for (int j = 0; j < 27; ++j) {
                    if (!this.show_profile[i][j][3] || this.data_profile[i][j][3] == null) continue;
                    f2 = this.data_profile[i][j][3].getMinimumValue();
                    f = this.data_profile[i][j][3].getMaximumValue();
                    this.min_count = Math.min(this.min_count, (int)f2);
                    this.max_count = Math.max(this.max_count, (int)f);
                }
                if (this.min_count == 9999999) {
                    this.min_count = 0;
                }
                if (this.max_count == -9999999) {
                    this.max_count = 100;
                }
                if (this.globals.getSampleSizeMinMaxOption() != 1) continue;
                this.min_count = 0;
            }
        }
        if (this.min_max_option == 1) {
            this.min_stat = this.default_min;
            this.max_stat = this.default_max;
        } else if (this.min_max_option == 2) {
            this.min_stat = this.manual_min;
            this.max_stat = this.manual_max;
        } else {
            float f3 = 9999999.0f;
            float f4 = -9999999.0f;
            f2 = 9999999.0f;
            f = -9999999.0f;
            float f5 = 9999999.0f;
            float f6 = -9999999.0f;
            for (int i = 0; i < this.num_subgroups; ++i) {
                for (int j = 0; j < 27; ++j) {
                    float f7;
                    float f8;
                    if (this.show_profile[i][j][0] && this.data_profile[i][j][0] != null) {
                        f8 = this.data_profile[i][j][0].getMinimumValue();
                        f7 = this.data_profile[i][j][0].getMaximumValue();
                        f3 = Math.min(f3, f8);
                        f4 = Math.max(f4, f7);
                    }
                    if (this.show_profile[i][j][1] && this.data_profile[i][j][1] != null) {
                        f8 = this.data_profile[i][j][1].getMinimumValue();
                        f7 = this.data_profile[i][j][1].getMaximumValue();
                        f2 = Math.min(f2, f8);
                        f = Math.max(f, f7);
                    }
                    if (!this.show_profile[i][j][2] || this.data_profile[i][j][2] == null) continue;
                    f8 = this.data_profile[i][j][2].getMinimumValue();
                    f7 = this.data_profile[i][j][2].getMaximumValue();
                    f5 = Math.min(f5, f8);
                    f6 = Math.max(f6, f7);
                }
            }
            if (f3 == 9999999.0f || f3 == -9999999.0f || f4 == 9999999.0f || f4 == -9999999.0f) {
                f3 = -5.0f;
                f4 = 5.0f;
            }
            if (f2 == 9999999.0f || f2 == -9999999.0f || f2 == 9999999.0f || f2 == -9999999.0f) {
                f2 = -5.0f;
                f2 = 5.0f;
            }
            if (f5 == 9999999.0f || f5 == -9999999.0f || f5 == 9999999.0f || f5 == -9999999.0f) {
                f5 = -5.0f;
                f5 = 5.0f;
            }
            this.min_stat = 0.0f;
            this.max_stat = 0.0f;
            if (this.show_bias) {
                this.min_stat = Math.min(f3, this.min_stat);
                this.max_stat = Math.max(f4, this.max_stat);
            }
            if (this.show_stddev) {
                this.min_stat = Math.min(f2, this.min_stat);
                this.max_stat = Math.max(f, this.max_stat);
            }
            if (this.show_rms) {
                this.min_stat = Math.min(f5, this.min_stat);
                this.max_stat = Math.max(f6, this.max_stat);
            }
            if (this.min_stat == 0.0f && this.max_stat == 0.0f) {
                this.min_stat = -10.0f;
                this.max_stat = 10.0f;
            }
        }
    }

    public Vector getProfileData() {
        int n;
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        String[] stringArray = new String[]{"Bias", "Std Dev", "RMS", "Sample Size"};
        String[] stringArray2 = new String[]{"Pass/Fail", "Pass", "Fail"};
        String[] stringArray3 = new String[]{"Sea/Nonsea", "Sea", "Nonsea"};
        String[] stringArray4 = new String[]{"Clear/Cloudy", "Clear", "Cloudy"};
        for (int i = 0; i < this.num_subgroups; ++i) {
            for (int j = 0; j < 27; ++j) {
                for (n = 0; n < 4; ++n) {
                    if (!this.show_profile[i][j][n]) continue;
                    String string = this.data_profile[i][j][n].getLabel();
                    int n2 = this.data_profile[i][j][n].getStatType();
                    int n3 = this.data_profile[i][j][n].getQCType();
                    int n4 = this.data_profile[i][j][n].getTerrainType();
                    int n5 = this.data_profile[i][j][n].getCloudType();
                    String string2 = string + "  " + stringArray2[n3] + "  " + stringArray3[n4] + "  " + stringArray4[n5] + "  " + stringArray[n2];
                    vector.add(string2);
                    vector2.add(new Integer(i * 1000 + j * 10 + n));
                }
            }
        }
        String[] stringArray5 = new String[vector.size()];
        int[] nArray = new int[vector2.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray5[n] = (String)vector.elementAt(n);
            nArray[n] = (Integer)vector2.elementAt(n);
        }
        Vector<Object[]> vector3 = new Vector<Object[]>(2);
        vector3.add(stringArray5);
        vector3.add(nArray);
        return vector3;
    }

    public void drawBackgroundImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.data_available = false;
        for (n6 = 0; n6 < this.num_subgroups; ++n6) {
            for (n5 = 0; n5 < 27; ++n5) {
                for (int i = 0; i < 4; ++i) {
                    this.data_profile[n6][n5][i] = null;
                }
            }
        }
        this.calculateDateIntervals();
        this.show_bias = this.globals.getShowBias();
        this.show_stddev = this.globals.getShowStdDev();
        this.show_rms = this.globals.getShowRMS();
        this.show_samplesize = this.globals.getShowSampleSize();
        if (this.data_type == 1) {
            this.min_max_option = this.globals.getTempMinMaxOption();
            this.default_min = this.globals.getTempDefaultMin();
            this.default_max = this.globals.getTempDefaultMax();
            this.manual_min = this.globals.getTempManualMin();
            this.manual_max = this.globals.getTempManualMax();
            this.ignore_extreme_values = this.globals.getTempIgnoreExtremes();
        } else if (this.data_type == 2) {
            this.min_max_option = this.globals.getWvapMinMaxOption();
            this.default_min = this.globals.getWvapDefaultMin();
            this.default_max = this.globals.getWvapDefaultMax();
            this.manual_min = this.globals.getWvapManualMin();
            this.manual_max = this.globals.getWvapManualMax();
            this.ignore_extreme_values = this.globals.getWvapIgnoreExtremes();
        }
        if (this.file_name != null) {
            this.readData();
        }
        if (this.data_available) {
            n6 = (int)((double)n3 * 0.15);
            n5 = n3 - n6;
            this.drawLegend(graphics2D, n + n5, n2, n6, n4);
            this.drawGraph(graphics2D, n, n2, n5, n4);
        }
    }

    private void fillProfileMatchArray() {
        this.profile_match_array = new boolean[27][27];
        for (int i = 0; i < 27; ++i) {
            for (int j = 0; j < 27; ++j) {
                this.profile_match_array[i][j] = false;
            }
        }
        this.profile_match_array[0][0] = true;
        this.profile_match_array[0][1] = true;
        this.profile_match_array[0][2] = true;
        this.profile_match_array[0][3] = true;
        this.profile_match_array[0][4] = true;
        this.profile_match_array[0][5] = true;
        this.profile_match_array[0][6] = true;
        this.profile_match_array[0][7] = true;
        this.profile_match_array[0][8] = true;
        this.profile_match_array[0][9] = true;
        this.profile_match_array[0][10] = true;
        this.profile_match_array[0][11] = true;
        this.profile_match_array[0][12] = true;
        this.profile_match_array[0][13] = true;
        this.profile_match_array[0][14] = true;
        this.profile_match_array[0][15] = true;
        this.profile_match_array[0][16] = true;
        this.profile_match_array[0][17] = true;
        this.profile_match_array[0][18] = true;
        this.profile_match_array[0][19] = true;
        this.profile_match_array[0][20] = true;
        this.profile_match_array[0][21] = true;
        this.profile_match_array[0][22] = true;
        this.profile_match_array[0][23] = true;
        this.profile_match_array[0][24] = true;
        this.profile_match_array[0][25] = true;
        this.profile_match_array[0][26] = true;
        this.profile_match_array[1][0] = true;
        this.profile_match_array[1][3] = true;
        this.profile_match_array[1][6] = true;
        this.profile_match_array[1][9] = true;
        this.profile_match_array[1][12] = true;
        this.profile_match_array[1][15] = true;
        this.profile_match_array[1][18] = true;
        this.profile_match_array[1][21] = true;
        this.profile_match_array[1][24] = true;
        this.profile_match_array[2][1] = true;
        this.profile_match_array[2][4] = true;
        this.profile_match_array[2][7] = true;
        this.profile_match_array[2][10] = true;
        this.profile_match_array[2][13] = true;
        this.profile_match_array[2][16] = true;
        this.profile_match_array[2][19] = true;
        this.profile_match_array[2][22] = true;
        this.profile_match_array[2][25] = true;
        this.profile_match_array[3][0] = true;
        this.profile_match_array[3][1] = true;
        this.profile_match_array[3][2] = true;
        this.profile_match_array[3][9] = true;
        this.profile_match_array[3][10] = true;
        this.profile_match_array[3][11] = true;
        this.profile_match_array[3][18] = true;
        this.profile_match_array[3][19] = true;
        this.profile_match_array[3][20] = true;
        this.profile_match_array[4][0] = true;
        this.profile_match_array[4][9] = true;
        this.profile_match_array[4][18] = true;
        this.profile_match_array[5][1] = true;
        this.profile_match_array[5][10] = true;
        this.profile_match_array[5][19] = true;
        this.profile_match_array[6][3] = true;
        this.profile_match_array[6][4] = true;
        this.profile_match_array[6][5] = true;
        this.profile_match_array[6][12] = true;
        this.profile_match_array[6][13] = true;
        this.profile_match_array[6][14] = true;
        this.profile_match_array[6][21] = true;
        this.profile_match_array[6][22] = true;
        this.profile_match_array[6][23] = true;
        this.profile_match_array[7][3] = true;
        this.profile_match_array[7][12] = true;
        this.profile_match_array[7][21] = true;
        this.profile_match_array[8][4] = true;
        this.profile_match_array[8][13] = true;
        this.profile_match_array[8][22] = true;
        this.profile_match_array[9][0] = true;
        this.profile_match_array[9][1] = true;
        this.profile_match_array[9][2] = true;
        this.profile_match_array[9][3] = true;
        this.profile_match_array[9][4] = true;
        this.profile_match_array[9][5] = true;
        this.profile_match_array[9][6] = true;
        this.profile_match_array[9][7] = true;
        this.profile_match_array[9][8] = true;
        this.profile_match_array[9][18] = true;
        this.profile_match_array[9][19] = true;
        this.profile_match_array[9][20] = true;
        this.profile_match_array[9][21] = true;
        this.profile_match_array[9][22] = true;
        this.profile_match_array[9][23] = true;
        this.profile_match_array[9][24] = true;
        this.profile_match_array[9][25] = true;
        this.profile_match_array[9][26] = true;
        this.profile_match_array[10][0] = true;
        this.profile_match_array[10][3] = true;
        this.profile_match_array[10][6] = true;
        this.profile_match_array[10][18] = true;
        this.profile_match_array[10][21] = true;
        this.profile_match_array[10][24] = true;
        this.profile_match_array[11][1] = true;
        this.profile_match_array[11][4] = true;
        this.profile_match_array[11][7] = true;
        this.profile_match_array[11][19] = true;
        this.profile_match_array[11][22] = true;
        this.profile_match_array[11][25] = true;
        this.profile_match_array[12][0] = true;
        this.profile_match_array[12][1] = true;
        this.profile_match_array[12][2] = true;
        this.profile_match_array[12][18] = true;
        this.profile_match_array[12][19] = true;
        this.profile_match_array[12][20] = true;
        this.profile_match_array[13][0] = true;
        this.profile_match_array[13][18] = true;
        this.profile_match_array[14][1] = true;
        this.profile_match_array[14][19] = true;
        this.profile_match_array[15][3] = true;
        this.profile_match_array[15][4] = true;
        this.profile_match_array[15][5] = true;
        this.profile_match_array[15][21] = true;
        this.profile_match_array[15][22] = true;
        this.profile_match_array[15][23] = true;
        this.profile_match_array[16][3] = true;
        this.profile_match_array[16][21] = true;
        this.profile_match_array[17][4] = true;
        this.profile_match_array[17][22] = true;
        this.profile_match_array[18][9] = true;
        this.profile_match_array[18][10] = true;
        this.profile_match_array[18][11] = true;
        this.profile_match_array[18][12] = true;
        this.profile_match_array[18][13] = true;
        this.profile_match_array[18][14] = true;
        this.profile_match_array[18][15] = true;
        this.profile_match_array[18][16] = true;
        this.profile_match_array[18][17] = true;
        this.profile_match_array[19][9] = true;
        this.profile_match_array[19][12] = true;
        this.profile_match_array[19][15] = true;
        this.profile_match_array[20][10] = true;
        this.profile_match_array[20][13] = true;
        this.profile_match_array[20][16] = true;
        this.profile_match_array[21][9] = true;
        this.profile_match_array[21][10] = true;
        this.profile_match_array[21][11] = true;
        this.profile_match_array[22][9] = true;
        this.profile_match_array[23][10] = true;
        this.profile_match_array[24][12] = true;
        this.profile_match_array[24][13] = true;
        this.profile_match_array[24][14] = true;
        this.profile_match_array[25][12] = true;
        this.profile_match_array[26][13] = true;
    }

    private int[] getProfileTypes(int n) {
        int[] nArray = new int[]{n / 9, n / 3 % 3, n % 3};
        return nArray;
    }

    private int getY(float f, float f2, float f3, int n) {
        float f4 = f3 - f2;
        float f5 = 0.0f;
        f5 = (f - f2) / f4;
        int n2 = n - (int)((float)n * f5);
        return n2;
    }

    private float oneDigit(float f) {
        return (float)((int)(f * 10.0f)) / 10.0f;
    }
}

