/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class AutoNarcs {
    private NarcsGlobals globals;
    private String output_file_name;
    private String input_file_name;
    private String file_type;
    private int image_width;
    private int image_height;
    private int global_start_date;
    private int global_end_date;
    private int time_option;
    private int start_date;
    private int end_date;
    private int data_block;
    private int min_max_option;
    private float data_min;
    private float data_max;
    private boolean ignore_extreme_values;
    private boolean show_data_points;
    private boolean show_bias;
    private boolean show_stddev;
    private boolean show_rms;
    private boolean show_samplesize;
    private boolean show_passfail;
    private boolean show_pass;
    private boolean show_fail;
    private boolean show_seanonsea;
    private boolean show_sea;
    private boolean show_nonsea;
    private boolean show_clearcloudy;
    private boolean show_clear;
    private boolean show_cloudy;
    private int[] profile_numbers;
    private int[] profile_reds;
    private int[] profile_greens;
    private int[] profile_blues;
    private String[] profile_names;
    private int[] data_block_type;
    private int[] data_block_offset;
    private String[] data_block_name;
    private int num_days;
    private int num_subgroups;
    private int num_data_groups;
    private int[] dates;
    private String[] full_subgroup_name;
    private String[] data_group_name;
    private float version = 1.0f;
    private String version_date = "June 11, 2010";

    public static void main(String[] stringArray) {
        AutoNarcs autoNarcs = new AutoNarcs(stringArray);
        System.exit(0);
    }

    public AutoNarcs(String[] stringArray) {
        System.out.println("====================================================================");
        System.out.print("Starting AutoNarcs " + this.version + " at ");
        this.printTime();
        System.out.println("");
        if (stringArray.length == 2) {
            this.readGlobalDateRange(stringArray);
        }
        try {
            XMLParser xMLParser = new XMLParser();
            XMLTree xMLTree = xMLParser.parseFile("parameter.file");
            if (xMLTree != null) {
                Object object;
                Object object2 = xMLTree.getValue("show_file_info");
                if (object2 != null && object2 instanceof String && ((String)(object = (String)object2)).equals("yes")) {
                    object2 = xMLTree.getValue("input_file_name");
                    if (object2 != null && object2 instanceof String) {
                        this.input_file_name = (String)object2;
                        this.globals = new NarcsGlobals();
                        this.readFileHeader(true);
                    } else {
                        System.out.println("The show_file_info flag is set to yes but the input file name");
                        System.out.println("could not be read from the parameter.  Please check the parameter");
                        System.out.println("file and make sure the the input_file_name tag is included.\n\n");
                    }
                    System.exit(0);
                }
                if ((object = xMLTree.getValue()) instanceof Vector) {
                    Vector vector = (Vector)object;
                    for (int i = 0; i < vector.size(); ++i) {
                        object = vector.elementAt(i);
                        this.processImage(object);
                    }
                } else {
                    System.out.println("\nThe input parameter file could not be parsed.");
                    System.out.println("The structure of the XML data is probably not correct.");
                    System.out.println("Please check the file and try again.\n");
                    System.exit(1);
                }
            } else {
                System.out.println("\nThe input parameter file could not be parsed.");
                System.out.println("The structure of the XML data is probably not correct.");
                System.out.println("Please check the file and try again.\n");
                System.exit(1);
            }
        }
        catch (XMLParserException xMLParserException) {
            System.out.println("\nThe input parameter file could not be parsed.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("Please check the file and try again.\n");
            System.exit(1);
        }
        System.out.print("\nEnding AutoNarcs at ");
        this.printTime();
        System.out.println("\n\n\n");
    }

    private void readGlobalDateRange(String[] stringArray) {
        this.global_start_date = 0;
        this.global_end_date = 0;
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            this.global_start_date = n;
            this.global_end_date = n2;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processImage(Object object) {
        this.globals = new NarcsGlobals();
        if (object instanceof XMLTree) {
            XMLTree xMLTree = (XMLTree)object;
            this.initializeImageParameters();
            this.processImageParameters(xMLTree);
            if (this.input_file_name != null && this.output_file_name != null) {
                this.readFileHeader(false);
                this.updateGlobalSettings();
                BufferedImage bufferedImage = new BufferedImage(this.image_width, this.image_height, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                int n = (int)((float)this.image_height * 0.05f);
                int n2 = this.image_height - n;
                this.drawTitle(graphics2D, 0, 0, this.image_width, n);
                if (this.data_block < 0 || this.data_block >= this.data_block_type.length) {
                    this.data_block = 0;
                }
                if (this.data_block_type[this.data_block] == 0) {
                    SampleSizeGraph sampleSizeGraph = new SampleSizeGraph();
                    sampleSizeGraph.addFileInfo(this.input_file_name, this.data_block_offset[this.data_block], this.num_days, this.dates, this.num_data_groups, this.data_group_name);
                    sampleSizeGraph.drawBackgroundImage(graphics2D, 0, n, this.image_width, n2);
                } else {
                    StatGraph statGraph = new StatGraph(this.data_block_type[this.data_block]);
                    statGraph.addFileInfo(this.input_file_name, this.data_block_offset, this.data_block_name, this.num_days, this.dates, this.num_subgroups, this.full_subgroup_name);
                    statGraph.newDataLevel(this.data_block);
                    statGraph.drawBackgroundImage(graphics2D, 0, n, this.image_width, n2);
                }
                this.saveImage(bufferedImage);
                System.out.println("Image saved:  " + this.output_file_name);
            } else {
                if (this.input_file_name == null) {
                    System.out.println("\nThe input file name was not included in the paramter XML file.");
                    System.out.println("This image will be skipped.\n");
                }
                if (this.output_file_name == null) {
                    System.out.println("\nThe output file name was not included in the paramter XML file.");
                    System.out.println("This image will be skipped.\n");
                }
            }
        } else {
            System.out.println("\nThere was a problem trying to create an image.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("This image will be skipped.\n");
        }
        this.globals = null;
    }

    public void drawTitle(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        String string = "NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)";
        int n5 = n4;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = 25;
        boolean bl = false;
        while (!bl && n6 > 5) {
            graphics2D.setFont(new Font("Serif", 0, --n6));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 || fontMetrics.stringWidth(string) >= n3 - n5 * 2) continue;
            bl = true;
        }
        int n7 = n + (n3 / 2 - fontMetrics.stringWidth(string) / 2);
        int n8 = n2 + fontMetrics.getHeight();
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n7, n8);
        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/faded_noaa.gif")));
        JPanel jPanel = new JPanel();
        graphics2D.drawImage(imageIcon.getImage(), n, n2, n5, n5, jPanel);
    }

    private void readFileHeader(boolean bl) {
        try {
            Object object;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.input_file_name));
            if (this.input_file_name.endsWith(".gz")) {
                dataInputStream = new DataInputStream(new GZIPInputStream(new FileInputStream(this.input_file_name)));
            }
            int n11 = dataInputStream.readInt();
            float f = (float)dataInputStream.readInt() / 10.0f;
            int n12 = dataInputStream.readInt();
            for (n10 = 0; n10 < 7; ++n10) {
                n9 = dataInputStream.readInt();
            }
            n10 = dataInputStream.readInt();
            this.num_days = dataInputStream.readInt();
            n9 = dataInputStream.readInt();
            this.num_data_groups = dataInputStream.readInt();
            this.num_subgroups = dataInputStream.readInt();
            if (bl) {
                System.out.println("File Name:          " + this.input_file_name + "\n");
                System.out.println("File Type:          " + n11);
                System.out.println("File Version:       " + f);
                System.out.println("Header Length:      " + n12);
                System.out.println("Max Days:           " + n10);
                System.out.println("Num Days:           " + this.num_days);
                System.out.println("Num Levels:         " + n9);
                System.out.println("Num Groups:         " + this.num_data_groups);
                System.out.println("Num Subgroups:      " + this.num_subgroups + "\n");
            }
            for (n8 = 0; n8 < 5; ++n8) {
                n7 = dataInputStream.readInt();
            }
            n8 = dataInputStream.readInt();
            n7 = dataInputStream.readInt();
            String string = "";
            for (int i = 0; i < 8; ++i) {
                n6 = dataInputStream.readInt();
                if (n6 == Short.MIN_VALUE) continue;
                string = string + (char)n6;
            }
            string = string.trim();
            String string2 = "";
            for (n6 = 0; n6 < 50; ++n6) {
                n5 = dataInputStream.readInt();
                if (n5 == Short.MIN_VALUE) continue;
                string2 = string2 + (char)n5;
            }
            string2 = string2.trim();
            if (bl) {
                System.out.println("Baseline group:     " + n8);
                System.out.println("Baseline type:      " + n7);
                System.out.println("Radiosonde:         " + string);
                System.out.println("Baseline System:    " + string2 + "\n");
            }
            n6 = 99999999;
            n5 = -99999999;
            this.dates = new int[this.num_days];
            for (n4 = 0; n4 < this.num_days; ++n4) {
                this.dates[n4] = dataInputStream.readInt();
                n6 = Math.min(n6, this.dates[n4]);
                n5 = Math.max(n5, this.dates[n4]);
            }
            this.globals.setDates(this.dates);
            this.globals.setEarliestDataDate(n6);
            this.globals.setLatestDataDate(n5);
            this.globals.setCurrentStartDate(n6);
            this.globals.setCurrentEndDate(n5);
            if (bl) {
                System.out.println("\nDates");
                for (n4 = 0; n4 < this.num_days; ++n4) {
                    System.out.println("  " + n4 + "    " + this.dates[n4]);
                }
                System.out.println("");
                System.out.println("Date Range:         " + n6 + "   " + n5 + "\n");
            }
            this.data_block_type = new int[n9];
            float[] fArray = new float[n9];
            int[] nArray = new int[n9];
            this.data_block_name = new String[n9];
            this.data_block_offset = new int[n9];
            int n13 = n12;
            for (int i = 0; i < n9; ++i) {
                this.data_block_type[i] = dataInputStream.readInt();
                fArray[i] = (float)dataInputStream.readInt() / 100.0f;
                nArray[i] = dataInputStream.readInt();
                this.data_block_offset[i] = n13;
                n13 += nArray[i];
                this.data_block_name[i] = "";
                for (n3 = 0; n3 < 50; ++n3) {
                    n2 = dataInputStream.readInt();
                    if (n2 == Short.MIN_VALUE) continue;
                    this.data_block_name[i] = this.data_block_name[i] + (char)n2;
                }
                this.data_block_name[i] = this.data_block_name[i].trim();
                if (!bl) continue;
                System.out.println("Data Block:     " + i);
                System.out.println("Block Type:     " + this.data_block_type[i]);
                System.out.println("Block Pressure: " + fArray[i]);
                System.out.println("Block Length:   " + nArray[i]);
                System.out.println("Block Name:     " + this.data_block_name[i] + "\n");
            }
            if (bl) {
                System.out.println("");
            }
            int[] nArray2 = new int[this.num_data_groups + 5];
            this.data_group_name = new String[this.num_data_groups + 5];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            this.data_group_name[0] = "Radiosonde";
            this.data_group_name[1] = "Raob 00Z";
            this.data_group_name[2] = "Raob 06Z";
            this.data_group_name[3] = "Raob 12Z";
            this.data_group_name[4] = "Raob 18Z";
            for (n3 = 5; n3 < this.num_data_groups + 5; ++n3) {
                nArray2[n3] = dataInputStream.readInt();
                this.data_group_name[n3] = "";
                for (n2 = 0; n2 < 50; ++n2) {
                    int n14 = dataInputStream.readInt();
                    if (n14 == Short.MIN_VALUE) continue;
                    this.data_group_name[n3] = this.data_group_name[n3] + (char)n14;
                }
                this.data_group_name[n3] = this.data_group_name[n3].trim();
                if (!bl) continue;
                System.out.println("Data Group:        " + n3);
                System.out.println("Data Group ID:     " + nArray2[n3]);
                System.out.println("Data Group Name:   " + this.data_group_name[n3] + "\n");
            }
            if (bl) {
                System.out.println("");
            }
            int[] nArray3 = new int[this.num_subgroups];
            int[] nArray4 = new int[this.num_subgroups];
            int[] nArray5 = new int[this.num_subgroups];
            String[] stringArray = new String[this.num_subgroups];
            Color[] colorArray = new Color[this.num_subgroups];
            int[][][] nArray6 = new int[this.num_subgroups][27][4];
            int[][][] nArray7 = new int[this.num_subgroups][27][4];
            for (n = 0; n < this.num_subgroups; ++n) {
                int n15;
                nArray3[n] = dataInputStream.readInt();
                nArray4[n] = dataInputStream.readInt();
                nArray5[n] = dataInputStream.readInt();
                stringArray[n] = "";
                for (int i = 0; i < 50; ++i) {
                    n15 = dataInputStream.readInt();
                    if (n15 == Short.MIN_VALUE) continue;
                    stringArray[n] = stringArray[n] + (char)n15;
                }
                stringArray[n] = stringArray[n].trim();
                object = this.globals.getGroupColor(nArray3[n] + 5);
                for (n15 = 0; n15 < nArray4[n]; ++n15) {
                    object = ((Color)object).darker().darker();
                }
                colorArray[n] = object;
                for (n15 = 0; n15 < 27; ++n15) {
                    for (int i = 0; i < 4; ++i) {
                        nArray6[n][n15][i] = 0;
                        nArray7[n][n15][i] = i;
                    }
                }
                if (!bl) continue;
                System.out.println("Subgroup:                  " + n);
                System.out.println("Subgroup Group Number:     " + nArray3[n]);
                System.out.println("Subgroup Subgroup Number:  " + nArray4[n]);
                System.out.println("Subgroup Type:             " + nArray5[n]);
                System.out.println("Subgroup Name:             " + this.data_group_name[nArray3[n]] + " " + stringArray[n] + "\n");
            }
            this.full_subgroup_name = new String[this.num_subgroups];
            for (n = 0; n < this.num_subgroups; ++n) {
                this.full_subgroup_name[n] = this.data_group_name[nArray3[n]] + " " + stringArray[n];
            }
            this.globals.setDefaultSubgroupColors(colorArray);
            this.globals.setSubgroupColors(colorArray);
            this.globals.setDefaultSubgroupLineThicknesses(nArray6);
            this.globals.setSubgroupLineThicknesses(nArray6);
            this.globals.setDefaultSubgroupLineStyles(nArray7);
            this.globals.setSubgroupLineStyles(nArray7);
            boolean[] blArray = new boolean[this.num_data_groups + 5];
            Arrays.fill(blArray, false);
            blArray[0] = true;
            this.globals.setShowDataGroups(blArray);
            object = new boolean[this.num_subgroups];
            Arrays.fill((boolean[])object, false);
            object[0] = true;
            this.globals.setShowSubGroups((boolean[])object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private void saveImage(BufferedImage bufferedImage) {
        try {
            File file = new File(this.output_file_name);
            ImageIO.write((RenderedImage)bufferedImage, this.file_type, file);
        }
        catch (Exception exception) {
            System.out.println("Could not save the image: " + this.output_file_name);
        }
    }

    private void initializeImageParameters() {
        this.output_file_name = null;
        this.file_type = "png";
        this.image_width = 800;
        this.image_height = 600;
        this.input_file_name = null;
        this.start_date = Short.MIN_VALUE;
        this.end_date = Short.MIN_VALUE;
        this.data_block = 0;
        this.min_max_option = 1;
        this.data_min = -5.0f;
        this.data_max = 5.0f;
        this.ignore_extreme_values = false;
        this.time_option = 1;
        this.show_data_points = false;
        this.show_bias = true;
        this.show_stddev = true;
        this.show_rms = false;
        this.show_samplesize = false;
        this.show_passfail = false;
        this.show_pass = true;
        this.show_fail = false;
        this.show_seanonsea = true;
        this.show_sea = false;
        this.show_nonsea = false;
        this.show_clearcloudy = true;
        this.show_clear = false;
        this.show_cloudy = false;
        this.profile_names = new String[1];
        this.profile_numbers = new int[1];
        this.profile_reds = new int[1];
        this.profile_greens = new int[1];
        this.profile_blues = new int[1];
        this.profile_names[0] = null;
        this.profile_numbers[0] = 0;
        this.profile_reds[0] = Short.MIN_VALUE;
        this.profile_greens[0] = Short.MIN_VALUE;
        this.profile_blues[0] = Short.MIN_VALUE;
    }

    private void processImageParameters(XMLTree xMLTree) {
        Object object;
        Object object2 = xMLTree.getValue("output_file_name");
        if (object2 != null && object2 instanceof String) {
            this.output_file_name = (String)object2;
        }
        if ((object2 = xMLTree.getValue("file_type")) != null && object2 instanceof String) {
            this.file_type = (String)object2;
        }
        if ((object2 = xMLTree.getValue("image_height")) != null && object2 instanceof String) {
            this.image_height = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("image_width")) != null && object2 instanceof String) {
            this.image_width = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("input_file_name")) != null && object2 instanceof String) {
            this.input_file_name = (String)object2;
        }
        if ((object2 = xMLTree.getValue("time_option")) != null && object2 instanceof String) {
            object = (String)object2;
            if (((String)object).equals("daily")) {
                this.time_option = 0;
            } else if (((String)object).equals("weekly")) {
                this.time_option = 1;
            } else if (((String)object).equals("monthly")) {
                this.time_option = 2;
            }
        }
        if ((object2 = xMLTree.getValue("start_date")) != null && object2 instanceof String) {
            this.start_date = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("end_date")) != null && object2 instanceof String) {
            this.end_date = Integer.parseInt((String)object2);
        }
        if (this.global_start_date != 0 && this.global_end_date != 0) {
            this.start_date = this.global_start_date;
            this.end_date = this.global_end_date;
        }
        if ((object2 = xMLTree.getValue("data_type_block")) != null && object2 instanceof String) {
            this.data_block = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("min_max_option")) != null && object2 instanceof String) {
            this.min_max_option = Integer.parseInt((String)object2);
            if (this.min_max_option < 0 || this.min_max_option > 2) {
                this.min_max_option = 1;
            }
        }
        if ((object2 = xMLTree.getValue("data_min")) != null && object2 instanceof String) {
            this.data_min = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("data_max")) != null && object2 instanceof String) {
            this.data_max = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("ignore_extreme_values")) != null && object2 instanceof String) {
            object = (String)object2;
            this.ignore_extreme_values = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_data_points")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_data_points = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_bias")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_bias = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_stddev")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_stddev = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_rms")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_rms = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_samplesize")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_samplesize = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_passfail")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_passfail = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_pass")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_pass = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_fail")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_fail = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_seanonsea")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_seanonsea = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_sea")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_sea = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_nonsea")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_nonsea = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_clearcloudy")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_clearcloudy = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_clear")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_clear = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_cloudy")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_cloudy = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("profiles")) != null && object2 instanceof Vector) {
            object = (Vector)object2;
            this.profile_names = new String[((Vector)object).size()];
            this.profile_numbers = new int[((Vector)object).size()];
            this.profile_reds = new int[((Vector)object).size()];
            this.profile_greens = new int[((Vector)object).size()];
            this.profile_blues = new int[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.profile_names[i] = null;
                this.profile_numbers[i] = 0;
                this.profile_reds[i] = Short.MIN_VALUE;
                this.profile_greens[i] = Short.MIN_VALUE;
                this.profile_blues[i] = Short.MIN_VALUE;
                object2 = ((Vector)object).elementAt(i);
                if (!(object2 instanceof XMLTree)) continue;
                XMLTree xMLTree2 = (XMLTree)object2;
                if ((object2 = xMLTree2.getValue("name")) != null && object2 instanceof String) {
                    this.profile_names[i] = (String)object2;
                }
                if ((object2 = xMLTree2.getValue("number")) != null && object2 instanceof String) {
                    this.profile_numbers[i] = Integer.parseInt((String)object2);
                }
                if ((object2 = xMLTree2.getValue("red")) != null && object2 instanceof String) {
                    this.profile_reds[i] = Integer.parseInt((String)object2);
                    if (this.profile_reds[i] < 0 || this.profile_reds[i] > 255) {
                        this.profile_reds[i] = Short.MIN_VALUE;
                    }
                }
                if ((object2 = xMLTree2.getValue("green")) != null && object2 instanceof String) {
                    this.profile_greens[i] = Integer.parseInt((String)object2);
                    if (this.profile_greens[i] < 0 || this.profile_greens[i] > 255) {
                        this.profile_greens[i] = Short.MIN_VALUE;
                    }
                }
                if ((object2 = xMLTree2.getValue("blue")) == null || !(object2 instanceof String)) continue;
                this.profile_blues[i] = Integer.parseInt((String)object2);
                if (this.profile_blues[i] >= 0 && this.profile_blues[i] <= 255) continue;
                this.profile_blues[i] = Short.MIN_VALUE;
            }
        }
    }

    private void updateGlobalSettings() {
        this.globals.setTimeWindowOption(this.time_option);
        this.globals.setCurrentStartDate(this.start_date);
        this.globals.setCurrentEndDate(this.end_date);
        this.globals.setSampleSizeMinMaxOption(this.min_max_option);
        this.globals.setTempMinMaxOption(this.min_max_option);
        this.globals.setWvapMinMaxOption(this.min_max_option);
        this.globals.setSampleSizeManualMin(this.data_min);
        this.globals.setTempManualMin(this.data_min);
        this.globals.setWvapManualMin(this.data_min);
        this.globals.setSampleSizeManualMax(this.data_max);
        this.globals.setTempManualMax(this.data_max);
        this.globals.setWvapManualMax(this.data_max);
        this.globals.setSampleSizeIgnoreExtremes(this.ignore_extreme_values);
        this.globals.setTempIgnoreExtremes(this.ignore_extreme_values);
        this.globals.setWvapIgnoreExtremes(this.ignore_extreme_values);
        this.globals.setShowDataPoints(this.show_data_points);
        this.globals.setShowBias(this.show_bias);
        this.globals.setShowStdDev(this.show_stddev);
        this.globals.setShowRMS(this.show_rms);
        this.globals.setShowSampleSize(this.show_samplesize);
        this.globals.setShowPassedAndFailedQC(this.show_passfail);
        this.globals.setShowPassedQC(this.show_pass);
        this.globals.setShowFailedQC(this.show_fail);
        this.globals.setShowSeaAndNonsea(this.show_seanonsea);
        this.globals.setShowSea(this.show_sea);
        this.globals.setShowNonsea(this.show_nonsea);
        this.globals.setShowClearAndCloudy(this.show_clearcloudy);
        this.globals.setShowClear(this.show_clear);
        this.globals.setShowCloudy(this.show_cloudy);
        boolean[] blArray = this.globals.getShowDataGroups();
        Arrays.fill(blArray, false);
        Color[] colorArray = this.globals.getGroupColors();
        boolean[] blArray2 = this.globals.getShowSubGroups();
        Arrays.fill(blArray2, false);
        Color[] colorArray2 = this.globals.getSubgroupColors();
        for (int i = 0; i < this.profile_numbers.length; ++i) {
            if (this.profile_numbers[i] < 0) continue;
            if (this.profile_numbers[i] < blArray.length) {
                if (this.profile_names[i] != null) {
                    this.data_group_name[i] = this.profile_names[i];
                }
                blArray[this.profile_numbers[i]] = true;
                if (this.profile_reds[i] != Short.MIN_VALUE && this.profile_greens[i] != Short.MIN_VALUE && this.profile_blues[i] != Short.MIN_VALUE) {
                    colorArray[this.profile_numbers[i]] = new Color(this.profile_reds[i], this.profile_greens[i], this.profile_blues[i]);
                }
            }
            if (this.profile_numbers[i] >= blArray2.length) continue;
            if (this.profile_names[i] != null) {
                this.full_subgroup_name[this.profile_numbers[i]] = this.profile_names[i];
            }
            blArray2[this.profile_numbers[i]] = true;
            if (this.profile_reds[i] == Short.MIN_VALUE || this.profile_greens[i] == Short.MIN_VALUE || this.profile_blues[i] == Short.MIN_VALUE) continue;
            colorArray2[this.profile_numbers[i]] = new Color(this.profile_reds[i], this.profile_greens[i], this.profile_blues[i]);
        }
        this.globals.setShowDataGroups(blArray);
        this.globals.setGroupColors(colorArray);
        this.globals.setShowSubGroups(blArray2);
        this.globals.setSubgroupColors(colorArray2);
    }

    private void printTime() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(10);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        String string = "" + n + ":";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + ":";
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + n3 + "\t";
        System.out.println(string);
    }
}

