/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.JPanel;

public class SampleSizeGraph
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int width;
    private int height;
    private Image offscreen_image = null;
    private String file_name;
    private boolean data_available = false;
    private boolean[][] show_profile;
    private NarcsDataProfile[][] profiles;
    private boolean[][] profile_match_array;
    private int[] dates;
    private int min_count = 1;
    private int max_count = 1000;
    private int number_of_x_points = 0;
    private int[] from_record;
    private int[] to_record;
    private String[] date_string;
    private int mouse_start_x;
    private int mouse_start_y;
    private int mouse_end_x;
    private int mouse_end_y;
    private int[] date_x_locations;
    private int[] date_positions;
    private int[] current_dates;
    private int block_offset;
    private int num_days;
    private int num_data_groups;
    private String[] group_names;
    private NarcsGlobals globals = new NarcsGlobals();

    public SampleSizeGraph() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_start_x = mouseEvent.getX();
        this.mouse_start_y = mouseEvent.getY();
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        this.mouse_end_x = mouseEvent.getX();
        this.mouse_end_y = mouseEvent.getY();
        n = Math.abs(this.mouse_start_x - this.mouse_end_x);
        n2 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        n3 = Math.min(this.mouse_start_x, this.mouse_end_x);
        n4 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n3, n4, n, n2);
        graphics.dispose();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        int n3 = Math.abs(this.mouse_start_x - this.mouse_end_x);
        int n4 = Math.abs(this.mouse_start_y - this.mouse_end_y);
        int n5 = Math.min(this.mouse_start_x, this.mouse_end_x);
        int n6 = Math.min(this.mouse_start_y, this.mouse_end_y);
        graphics.drawRect(n5, n6, n3, n4);
        graphics.dispose();
        if (n != this.mouse_start_x && n2 != this.mouse_start_y) {
            int n7 = Math.min(this.mouse_start_x, n);
            int n8 = Math.max(this.mouse_start_x, n);
            int n9 = Short.MIN_VALUE;
            int n10 = Short.MIN_VALUE;
            int n11 = 99999;
            int n12 = 99999;
            for (int i = 0; i < this.date_positions.length; ++i) {
                int n13;
                int n14 = Math.abs(this.date_positions[i] - n7);
                if (n14 < n11) {
                    n11 = n14;
                    n9 = i;
                }
                if ((n13 = Math.abs(this.date_positions[i] - n8)) >= n12) continue;
                n12 = n13;
                n10 = i;
            }
            n9 = Math.max(n9, 0);
            n10 = Math.min(n10, this.date_positions.length - 1);
            this.globals.setCurrentStartDate(this.current_dates[n9]);
            this.globals.setCurrentEndDate(this.current_dates[n10]);
            this.newTimeWindow();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.width = n3;
        this.height = n4;
        this.setPreferredSize(new Dimension(n3, n4));
        if (this.isVisible()) {
            this.offscreen_image = this.createImage(n3, n4);
            Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
            this.drawGraph(graphics2D, 0, 0, n3, n4, true);
            graphics2D.dispose();
            this.paintComponent(this.getGraphics());
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing() && this.offscreen_image != null) {
            graphics.drawImage(this.offscreen_image, 0, 0, this.width, this.height, this);
        }
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawGraph(graphics2D, n, n2, n3, n4, false);
    }

    public void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        int n7 = 5;
        int n8 = (int)((float)n4 * 0.05f);
        int n9 = (int)((float)(n3 - n7 * 2) * 0.1f);
        int n10 = n3 - n7 * 2 - n9;
        int n11 = (int)((float)(n4 - n7 * 2 - n8) * 0.15f);
        int n12 = n6 = n4 - n7 * 2 - n8 - n11;
        int n13 = n10;
        int n14 = n + n7;
        int n15 = n2 + n7 + n8;
        int n16 = n + n7 + n9;
        int n17 = n2 + n7 + n8 + n6;
        int n18 = n + n16;
        int n19 = n15;
        float f = (float)n10 / (float)(this.number_of_x_points - 1);
        this.date_x_locations = new int[this.number_of_x_points];
        for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
            this.date_x_locations[n5] = (int)((float)n5 * f);
        }
        if (bl) {
            this.date_positions = new int[this.number_of_x_points];
            for (n5 = 0; n5 < this.number_of_x_points; ++n5) {
                this.date_positions[n5] = this.date_x_locations[n5] + n9;
            }
        }
        this.drawTitle(graphics2D, n, n2, n3, n8);
        this.drawMainGraph(graphics2D, n18, n19, n10, n6);
        this.drawYAxis(graphics2D, n14, n15, n9, n12);
        this.drawXAxis(graphics2D, n16, n17, n13, n11);
    }

    private void drawTitle(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        String string = " ";
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("Serif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 - 2 || fontMetrics.stringWidth(string) >= n3 - 4) continue;
            bl = true;
        }
        int n6 = n + (n3 - fontMetrics.stringWidth(string)) / 2;
        int n7 = n2 + n4 - 2;
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n6, n7);
    }

    public void drawLegend(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        boolean[] blArray = new boolean[this.num_data_groups + 5];
        int n8 = 0;
        for (int i = 0; i < this.num_data_groups + 5; ++i) {
            blArray[i] = false;
            for (n7 = 0; n7 < 27; ++n7) {
                if (!this.show_profile[i][n7]) continue;
                blArray[i] = true;
            }
            if (!blArray[i]) continue;
            ++n8;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        n7 = 25;
        int n9 = 0;
        while (n9 == 0 && n7 > 5) {
            graphics2D.setFont(new Font("SansSerif", 0, --n7));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() * 3 * n8 >= n4) continue;
            n6 = 1;
            for (n5 = 0; n5 < this.num_data_groups + 5; ++n5) {
                if (!blArray[n5] || fontMetrics.stringWidth(this.group_names[n5]) < n3) continue;
                n6 = 0;
            }
            n9 = n6;
        }
        n6 = n + 2;
        n5 = (int)((float)n4 * 0.05f);
        int n10 = n2 + n5;
        for (int i = 0; i < this.num_data_groups + 5; ++i) {
            if (!blArray[i]) continue;
            Color color = this.globals.getGroupColor(i);
            graphics2D.setColor(color);
            graphics2D.drawString(this.group_names[i], n6, n10 += fontMetrics.getHeight());
        }
    }

    private void drawYAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        String string = "SAMPLE SIZE";
        String[] stringArray = new String[]{"" + this.min_count, "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.25f)), "" + (this.min_count + (this.max_count - this.min_count) / 2), "" + (this.min_count + (int)((float)(this.max_count - this.min_count) * 0.75f)), "" + this.max_count};
        int n7 = (int)((float)(n3 - 4) * 0.15f);
        int n8 = (int)((float)(n3 - 4) * 0.8f);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n9 = 25;
        boolean bl = false;
        while (!bl && n9 > 5) {
            bl = true;
            graphics2D.setFont(new Font("SansSerif", 0, --n9));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.stringWidth("M") > n7) {
                bl = false;
            }
            if (fontMetrics.getHeight() * string.length() > n4 - 4) {
                bl = false;
            }
            for (n6 = 0; n6 < stringArray.length; ++n6) {
                if (fontMetrics.stringWidth(stringArray[n6]) <= n8) continue;
                bl = false;
            }
        }
        n6 = 0;
        int n10 = 0;
        if (this.data_available) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(Color.gray);
        }
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            n6 = n + (n3 - 2);
            n10 = n2 + (n4 - (int)((float)n5 / (float)(stringArray.length - 1) * (float)n4));
            graphics2D.drawLine(n6, n10, n6 + 2, n10);
            n6 = n + (n3 - 2 - fontMetrics.stringWidth(stringArray[n5]));
            graphics2D.drawString(stringArray[n5], n6, n10 += fontMetrics.getAscent() / 2);
        }
        for (n5 = 0; n5 < string.length(); ++n5) {
            char c = string.charAt(n5);
            n6 = n + 2 + (fontMetrics.stringWidth("M") - fontMetrics.stringWidth("" + c) / 2);
            n10 = n2 + n4 / 2 - fontMetrics.getHeight() * string.length() / 2;
            n10 = n10 + n5 * fontMetrics.getHeight() + fontMetrics.getAscent();
            graphics2D.drawString("" + c, n6, n10);
        }
    }

    private void drawXAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("SansSerif", 0, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            bl = true;
            for (int i = 0; i < this.number_of_x_points; ++i) {
                if (fontMetrics.stringWidth(this.date_string[i]) <= n4 - 10) continue;
                bl = false;
            }
        }
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(AffineTransform.getRotateInstance(-1.5707963267948966));
        graphics2D.setFont(font2);
        int n6 = -999;
        for (int i = 0; i < this.number_of_x_points; ++i) {
            int n7 = n + this.date_x_locations[i];
            int n8 = n2 + 7 + fontMetrics.stringWidth(this.date_string[i]);
            int n9 = n7 + fontMetrics.getAscent() / 2;
            if (n9 > n6) {
                graphics2D.drawString(this.date_string[i], n9, n8);
                n6 = n9 + fontMetrics.getAscent();
            }
            graphics2D.drawLine(n7, n2, n7, n2 + 5);
        }
        graphics2D.setFont(font);
    }

    private void drawMainGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.data_available) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(Color.gray);
        }
        graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics2D.setClip(n, n2, n3, n4);
        Stroke stroke = graphics2D.getStroke();
        boolean bl = this.globals.getShowDataPoints();
        if (this.data_available) {
            boolean bl2 = this.globals.getSampleSizeIgnoreExtremes();
            for (int i = 0; i < this.num_data_groups + 5; ++i) {
                Color color = this.globals.getGroupColor(i);
                for (int j = 0; j < 27; ++j) {
                    int n5;
                    int n6;
                    if (!this.show_profile[i][j]) continue;
                    float[] fArray = this.profiles[i][j].getValues();
                    boolean bl3 = false;
                    Vector vector = new Vector();
                    Vector<Point> vector2 = new Vector<Point>();
                    graphics2D.setColor(color);
                    int n7 = this.globals.getGroupLineThickness(i, j);
                    if (n7 == 0) {
                        n7 = n4 / 200;
                    }
                    int n8 = this.globals.getGroupLineStyle(i, j);
                    this.globals.setLineStyle(graphics2D, n8, n7);
                    int n9 = (int)((float)n7 + (float)n7 / 4.0f);
                    n9 = Math.max(n9, 4);
                    for (n6 = 0; n6 < this.number_of_x_points; ++n6) {
                        int n10 = (int)fArray[n6];
                        if (n10 > 0) {
                            bl3 = true;
                        }
                        float f = (float)(n10 - this.min_count) / (float)(this.max_count - this.min_count);
                        if ((float)n10 == -32768.0f) {
                            f = -32768.0f;
                        }
                        if (bl2 && (n10 < this.min_count || n10 > this.max_count)) {
                            f = -32768.0f;
                        }
                        n5 = Short.MIN_VALUE;
                        int n11 = Short.MIN_VALUE;
                        if (f != -32768.0f) {
                            n5 = n2 + (n4 - (int)((float)n4 * f));
                            n11 = n + this.date_x_locations[n6];
                        }
                        if (n11 != Short.MIN_VALUE && n5 != Short.MIN_VALUE) {
                            if (!bl3) continue;
                            if (bl) {
                                graphics2D.fillOval(n11 - n9, n5 - n9, n9 * 2, n9 * 2);
                            }
                            Point point = new Point(n11, n5);
                            vector2.add(point);
                            continue;
                        }
                        vector.add(vector2);
                        vector2 = new Vector<Point>();
                    }
                    vector.add(vector2);
                    graphics2D.setColor(color);
                    for (n6 = 0; n6 < vector.size(); ++n6) {
                        vector2 = (Vector<Point>)vector.elementAt(n6);
                        int[] nArray = new int[vector2.size()];
                        int[] nArray2 = new int[vector2.size()];
                        for (n5 = 0; n5 < vector2.size(); ++n5) {
                            Point point = (Point)vector2.elementAt(n5);
                            nArray[n5] = point.x;
                            nArray2[n5] = point.y;
                        }
                        graphics2D.drawPolyline(nArray, nArray2, vector2.size());
                    }
                }
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setClip(null);
    }

    public void addFileInfo(String string, int n, int n2, int[] nArray, int n3, String[] stringArray) {
        this.file_name = string;
        this.block_offset = n;
        this.num_days = n2;
        this.dates = nArray;
        this.num_data_groups = n3;
        this.group_names = stringArray;
        this.show_profile = new boolean[n3 + 5][27];
        this.profiles = new NarcsDataProfile[n3 + 5][27];
        for (int i = 0; i < n3 + 5; ++i) {
            for (int j = 0; j < 27; ++j) {
                this.show_profile[i][j] = false;
                this.profiles[i][j] = null;
            }
        }
        this.data_available = true;
        this.fillProfileMatchArray();
        this.calculateDateIntervals();
        this.determineWhichProfilesToShow();
        this.readData();
    }

    private void readData() {
        try {
            this.determineWhichProfilesToShow();
            DataInputStream dataInputStream = null;
            if (this.file_name.equals("narcs_default.dat")) {
                InputStream inputStream = this.getClass().getResourceAsStream(this.file_name);
                dataInputStream = new DataInputStream(inputStream);
            } else {
                dataInputStream = this.file_name.endsWith(".gz") ? new DataInputStream(new GZIPInputStream(new FileInputStream(this.file_name))) : new DataInputStream(new FileInputStream(this.file_name));
            }
            dataInputStream.skipBytes(this.block_offset);
            for (int i = 0; i < this.num_data_groups + 5; ++i) {
                Object object;
                int n;
                int n2;
                boolean bl = false;
                for (int j = 0; j < 27; ++j) {
                    if (!this.show_profile[i][j] || this.profiles[i][j] != null) continue;
                    bl = true;
                }
                if (!bl) {
                    dataInputStream.skipBytes(108 * this.num_days);
                    continue;
                }
                int[][] nArray = new int[this.num_days][27];
                boolean[][] blArray = new boolean[this.num_days][27];
                for (n2 = 0; n2 < this.num_days; ++n2) {
                    for (n = 0; n < 27; ++n) {
                        nArray[n2][n] = 0;
                        blArray[n2][n] = false;
                    }
                }
                for (n2 = 0; n2 < 27; ++n2) {
                    n = 0;
                    for (int j = 0; j < 27; ++j) {
                        if (!this.profile_match_array[j][n2] || !this.show_profile[i][j] || this.profiles[i][j] != null) continue;
                        n = 1;
                    }
                    if (n == 0) {
                        dataInputStream.skipBytes(this.num_days * 4);
                        continue;
                    }
                    byte[] byArray = new byte[this.num_days * 4];
                    dataInputStream.readFully(byArray);
                    object = new DataInputStream(new ByteArrayInputStream(byArray));
                    for (int j = 0; j < this.num_days; ++j) {
                        int n3 = ((DataInputStream)object).readInt();
                        if (n3 == Short.MIN_VALUE) continue;
                        for (int k = 0; k < 27; ++k) {
                            if (!this.profile_match_array[k][n2] || !this.show_profile[i][k] || this.profiles[i][k] != null) continue;
                            int[] nArray2 = nArray[j];
                            int n4 = k;
                            nArray2[n4] = nArray2[n4] + n3;
                            blArray[j][k] = true;
                        }
                    }
                    ((FilterInputStream)object).close();
                }
                for (n2 = 0; n2 < this.num_days; ++n2) {
                    for (n = 0; n < 27; ++n) {
                        if (blArray[n2][n]) continue;
                        nArray[n2][n] = Short.MIN_VALUE;
                    }
                }
                for (n2 = 0; n2 < 27; ++n2) {
                    if (!this.show_profile[i][n2] || this.profiles[i][n2] != null) continue;
                    int[] nArray3 = new int[this.num_days];
                    for (int j = 0; j < this.num_days; ++j) {
                        nArray3[j] = nArray[j][n2];
                    }
                    float[] fArray = this.combineDateStats(nArray3);
                    object = this.getProfileTypes(n2);
                    this.profiles[i][n2] = new NarcsDataProfile(fArray, Color.black, i, n2, 3, (int)object[0], (int)object[1], (int)object[2], this.group_names[i]);
                }
            }
            dataInputStream.close();
            this.data_available = true;
            this.findMinMax();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void changeSettings() {
        this.updateGraph();
    }

    public void newTimeWindow() {
        this.data_available = false;
        for (int i = 0; i < this.num_data_groups + 5; ++i) {
            for (int j = 0; j < 27; ++j) {
                this.profiles[i][j] = null;
            }
        }
        this.calculateDateIntervals();
        this.updateGraph();
    }

    public void removeProfiles() {
        this.data_available = false;
        for (int i = 0; i < this.num_data_groups + 5; ++i) {
            for (int j = 0; j < 27; ++j) {
                this.profiles[i][j] = null;
            }
        }
    }

    public void updateGraph() {
        if (this.file_name != null) {
            this.readData();
        }
        if (this.data_available && this.isVisible() && this.isValid()) {
            this.offscreen_image = this.createImage(this.width, this.height);
            Graphics2D graphics2D = (Graphics2D)this.offscreen_image.getGraphics();
            this.drawGraph(graphics2D, 0, 0, this.width, this.height, true);
            graphics2D.dispose();
            this.paintComponent(this.getGraphics());
        }
    }

    private void determineWhichProfilesToShow() {
        for (int i = 0; i < this.num_data_groups + 5; ++i) {
            for (int j = 0; j < 27; ++j) {
                this.show_profile[i][j] = true;
            }
        }
        boolean[] blArray = this.globals.getShowDataGroups();
        boolean[] blArray2 = new boolean[]{this.globals.getShowPassedAndFailedQC(), this.globals.getShowPassedQC(), this.globals.getShowFailedQC()};
        boolean[] blArray3 = new boolean[]{this.globals.getShowSeaAndNonsea(), this.globals.getShowSea(), this.globals.getShowNonsea()};
        boolean[] blArray4 = new boolean[]{this.globals.getShowClearAndCloudy(), this.globals.getShowClear(), this.globals.getShowCloudy()};
        for (int i = 0; i < this.num_data_groups + 5; ++i) {
            int n = -1;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        ++n;
                        if (!blArray[i]) {
                            this.show_profile[i][n] = false;
                            continue;
                        }
                        if (!blArray2[j]) {
                            this.show_profile[i][n] = false;
                        }
                        if (!blArray3[k]) {
                            this.show_profile[i][n] = false;
                        }
                        if (blArray4[i2]) continue;
                        this.show_profile[i][n] = false;
                    }
                }
            }
        }
    }

    private void calculateDateIntervals() {
        block21: {
            int n;
            int n2;
            block22: {
                block20: {
                    long l = this.globals.getCurrentStartDate();
                    long l2 = this.globals.getCurrentEndDate();
                    n2 = 0;
                    for (n = this.dates.length - 1; n > 0 && l < (long)this.dates[n]; --n) {
                    }
                    while (n2 < this.dates.length - 1 && l2 > (long)this.dates[n2]) {
                        ++n2;
                    }
                    int n3 = n2 - n + 1;
                    if (this.globals.getTimeWindowOption() != 0) break block20;
                    this.number_of_x_points = n3;
                    this.from_record = new int[this.number_of_x_points];
                    this.to_record = new int[this.number_of_x_points];
                    this.date_string = new String[this.number_of_x_points];
                    this.current_dates = new int[this.number_of_x_points];
                    for (int i = 0; i < this.number_of_x_points; ++i) {
                        this.from_record[i] = n + i;
                        this.to_record[i] = n + i;
                        int n4 = this.dates[n + i] / 10000;
                        int n5 = this.dates[n + i] % 10000 / 100;
                        int n6 = this.dates[n + i] % 100;
                        String string = "" + n4 % 100;
                        if (n4 % 100 < 10) {
                            string = "0" + string;
                        }
                        this.date_string[i] = "" + n5 + "/" + n6 + "/" + string;
                        this.current_dates[i] = n4 * 10000 + n5 * 100 + n6;
                    }
                    break block21;
                }
                if (this.globals.getTimeWindowOption() != 1) break block22;
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                int n7 = this.dates[n] / 10000;
                int n8 = this.dates[n] % 10000 / 100 - 1;
                int n9 = this.dates[n] % 100;
                calendar.set(n7, n8, n9);
                while (calendar.get(7) != 1) {
                    calendar.add(5, -1);
                }
                Calendar calendar2 = Calendar.getInstance();
                calendar2.clear();
                n7 = this.dates[n2] / 10000;
                n8 = this.dates[n2] % 10000 / 100 - 1;
                n9 = this.dates[n2] % 100;
                calendar2.set(n7, n8, n9);
                while (calendar2.get(7) != 7) {
                    calendar2.add(5, 1);
                }
                this.number_of_x_points = 0;
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                n7 = this.dates[n] / 10000;
                n8 = this.dates[n] % 10000 / 100 - 1;
                n9 = this.dates[n] % 100;
                calendar3.set(n7, n8, n9);
                while (!calendar3.after(calendar2)) {
                    ++this.number_of_x_points;
                    calendar3.add(5, 7);
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                calendar3 = (Calendar)calendar.clone();
                int n10 = 0;
                while (calendar3.before(calendar2)) {
                    int n11 = calendar3.get(1);
                    int n12 = calendar3.get(2) + 1;
                    int n13 = calendar3.get(5);
                    int n14 = n11 * 10000 + n12 * 100 + n13;
                    String string = "" + n11 % 100;
                    if (n11 % 100 < 10) {
                        string = "0" + string;
                    }
                    calendar3.add(5, 6);
                    int n15 = calendar3.get(1);
                    int n16 = calendar3.get(2) + 1;
                    int n17 = calendar3.get(5);
                    int n18 = n15 * 10000 + n16 * 100 + n17;
                    String string2 = "" + n15 % 100;
                    if (n15 % 100 < 10) {
                        string2 = "0" + string2;
                    }
                    this.date_string[n10] = "" + n12 + "/" + n13 + "/" + string;
                    this.current_dates[n10] = n11 * 10000 + n12 * 100 + n13;
                    this.from_record[n10] = Short.MIN_VALUE;
                    this.to_record[n10] = Short.MIN_VALUE;
                    for (int i = 0; i < this.dates.length; ++i) {
                        if (this.dates[i] < n14 || this.dates[i] > n18) continue;
                        if (this.from_record[n10] == Short.MIN_VALUE) {
                            this.from_record[n10] = i;
                        }
                        this.to_record[n10] = i;
                    }
                    ++n10;
                    calendar3.add(5, 1);
                }
                break block21;
            }
            if (this.globals.getTimeWindowOption() != 2) break block21;
            int n19 = this.dates[n] / 100;
            int n20 = this.dates[n2] / 100;
            if (n19 == n20) {
                this.number_of_x_points = 1;
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.from_record[0] = n;
                this.to_record[0] = n2;
                this.date_string = new String[1];
                int n21 = n19 / 100;
                int n22 = n19 % 100;
                this.date_string[0] = "" + n22 + "/" + n21;
                this.current_dates = new int[1];
                this.current_dates[0] = n21 * 10000 + n22 * 100 + 1;
            } else {
                int n23;
                int n24;
                this.number_of_x_points = 0;
                int n25 = n19;
                while (n25 <= n20) {
                    n24 = n25 / 100;
                    n23 = n25 % 100;
                    if (++n23 > 12) {
                        n23 = 1;
                        ++n24;
                    }
                    n25 = n24 * 100 + n23;
                    ++this.number_of_x_points;
                }
                this.from_record = new int[this.number_of_x_points];
                this.to_record = new int[this.number_of_x_points];
                this.date_string = new String[this.number_of_x_points];
                this.current_dates = new int[this.number_of_x_points];
                n25 = n19;
                n24 = 0;
                while (n25 <= n20) {
                    n23 = n25 / 100;
                    int n26 = n25 % 100;
                    this.from_record[n24] = Short.MIN_VALUE;
                    this.to_record[n24] = Short.MIN_VALUE;
                    for (int i = n; i <= n2; ++i) {
                        int n27 = this.dates[i] / 100;
                        if (n27 != n25) continue;
                        if (this.from_record[n24] == Short.MIN_VALUE) {
                            this.from_record[n24] = i;
                        }
                        this.to_record[n24] = i;
                    }
                    this.date_string[n24] = "" + n26 + "/" + n23;
                    this.current_dates[n24] = n23 * 10000 + n26 * 100 + 1;
                    ++n24;
                    if (++n26 > 12) {
                        n26 = 1;
                        ++n23;
                    }
                    n25 = n23 * 100 + n26;
                }
            }
        }
    }

    private float[] combineDateStats(int[] nArray) {
        int n;
        float[] fArray = new float[this.number_of_x_points];
        Arrays.fill(fArray, 0.0f);
        boolean[] blArray = new boolean[this.number_of_x_points];
        Arrays.fill(blArray, false);
        for (n = 0; n < this.number_of_x_points; ++n) {
            for (int i = this.from_record[n]; i <= this.to_record[n]; ++i) {
                if (nArray[i] == Short.MIN_VALUE) continue;
                int n2 = n;
                fArray[n2] = fArray[n2] + (float)nArray[i];
                blArray[n] = true;
            }
        }
        for (n = 0; n < this.number_of_x_points; ++n) {
            if (blArray[n]) continue;
            fArray[n] = -32768.0f;
        }
        return fArray;
    }

    private void findMinMax() {
        if (this.globals.getSampleSizeMinMaxOption() == 2) {
            this.min_count = this.globals.getSampleSizeManualMin();
            this.max_count = this.globals.getSampleSizeManualMax();
        } else {
            this.min_count = 9999999;
            this.max_count = -9999999;
            for (int i = 0; i < this.num_data_groups + 5; ++i) {
                for (int j = 0; j < 27; ++j) {
                    if (!this.show_profile[i][j] || this.profiles[i][j] == null) continue;
                    float[] fArray = this.profiles[i][j].getValues();
                    for (int k = 0; k < fArray.length; ++k) {
                        if (!(fArray[k] >= 0.0f)) continue;
                        this.min_count = Math.min(this.min_count, (int)fArray[k]);
                        this.max_count = Math.max(this.max_count, (int)fArray[k]);
                    }
                }
            }
            if (this.min_count == 9999999) {
                this.min_count = 0;
            }
            if (this.max_count == -9999999) {
                this.max_count = 100;
            }
            if (this.globals.getSampleSizeMinMaxOption() == 1) {
                this.min_count = 0;
            }
        }
    }

    public Vector getProfileData() {
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        String[] stringArray = new String[]{"Pass/Fail", "Pass", "Fail"};
        String[] stringArray2 = new String[]{"Sea/Nonsea", "Sea", "Nonsea"};
        String[] stringArray3 = new String[]{"Clear/Cloudy", "Clear", "Cloudy"};
        for (int i = 0; i < this.num_data_groups + 5; ++i) {
            for (int j = 0; j < 27; ++j) {
                if (!this.show_profile[i][j]) continue;
                String string = this.profiles[i][j].getLabel();
                int n = this.profiles[i][j].getQCType();
                int n2 = this.profiles[i][j].getTerrainType();
                int n3 = this.profiles[i][j].getCloudType();
                String string2 = string + "  " + stringArray[n] + "  " + stringArray2[n2] + "  " + stringArray3[n3];
                vector.add(string2);
                vector2.add(new Integer(i * 100 + j));
            }
        }
        String[] stringArray4 = new String[vector.size()];
        int[] nArray = new int[vector2.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray4[i] = (String)vector.elementAt(i);
            nArray[i] = (Integer)vector2.elementAt(i);
        }
        Vector<Object[]> vector3 = new Vector<Object[]>(2);
        vector3.add(stringArray4);
        vector3.add(nArray);
        return vector3;
    }

    public void drawBackgroundImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.data_available = false;
        for (n6 = 0; n6 < this.num_data_groups + 5; ++n6) {
            for (n5 = 0; n5 < 27; ++n5) {
                this.profiles[n6][n5] = null;
            }
        }
        this.calculateDateIntervals();
        if (this.block_offset != Short.MIN_VALUE) {
            this.readData();
        }
        if (this.data_available) {
            n6 = (int)((double)n3 * 0.15);
            n5 = n3 - n6;
            this.drawLegend(graphics2D, n + n5, n2, n6, n4);
            this.drawGraph(graphics2D, n, n2, n5, n4);
        }
    }

    private void fillProfileMatchArray() {
        this.profile_match_array = new boolean[27][27];
        for (int i = 0; i < 27; ++i) {
            for (int j = 0; j < 27; ++j) {
                this.profile_match_array[i][j] = false;
            }
        }
        this.profile_match_array[0][0] = true;
        this.profile_match_array[0][1] = true;
        this.profile_match_array[0][2] = true;
        this.profile_match_array[0][3] = true;
        this.profile_match_array[0][4] = true;
        this.profile_match_array[0][5] = true;
        this.profile_match_array[0][6] = true;
        this.profile_match_array[0][7] = true;
        this.profile_match_array[0][8] = true;
        this.profile_match_array[0][9] = true;
        this.profile_match_array[0][10] = true;
        this.profile_match_array[0][11] = true;
        this.profile_match_array[0][12] = true;
        this.profile_match_array[0][13] = true;
        this.profile_match_array[0][14] = true;
        this.profile_match_array[0][15] = true;
        this.profile_match_array[0][16] = true;
        this.profile_match_array[0][17] = true;
        this.profile_match_array[0][18] = true;
        this.profile_match_array[0][19] = true;
        this.profile_match_array[0][20] = true;
        this.profile_match_array[0][21] = true;
        this.profile_match_array[0][22] = true;
        this.profile_match_array[0][23] = true;
        this.profile_match_array[0][24] = true;
        this.profile_match_array[0][25] = true;
        this.profile_match_array[0][26] = true;
        this.profile_match_array[1][0] = true;
        this.profile_match_array[1][3] = true;
        this.profile_match_array[1][6] = true;
        this.profile_match_array[1][9] = true;
        this.profile_match_array[1][12] = true;
        this.profile_match_array[1][15] = true;
        this.profile_match_array[1][18] = true;
        this.profile_match_array[1][21] = true;
        this.profile_match_array[1][24] = true;
        this.profile_match_array[2][1] = true;
        this.profile_match_array[2][4] = true;
        this.profile_match_array[2][7] = true;
        this.profile_match_array[2][10] = true;
        this.profile_match_array[2][13] = true;
        this.profile_match_array[2][16] = true;
        this.profile_match_array[2][19] = true;
        this.profile_match_array[2][22] = true;
        this.profile_match_array[2][25] = true;
        this.profile_match_array[3][0] = true;
        this.profile_match_array[3][1] = true;
        this.profile_match_array[3][2] = true;
        this.profile_match_array[3][9] = true;
        this.profile_match_array[3][10] = true;
        this.profile_match_array[3][11] = true;
        this.profile_match_array[3][18] = true;
        this.profile_match_array[3][19] = true;
        this.profile_match_array[3][20] = true;
        this.profile_match_array[4][0] = true;
        this.profile_match_array[4][9] = true;
        this.profile_match_array[4][18] = true;
        this.profile_match_array[5][1] = true;
        this.profile_match_array[5][10] = true;
        this.profile_match_array[5][19] = true;
        this.profile_match_array[6][3] = true;
        this.profile_match_array[6][4] = true;
        this.profile_match_array[6][5] = true;
        this.profile_match_array[6][12] = true;
        this.profile_match_array[6][13] = true;
        this.profile_match_array[6][14] = true;
        this.profile_match_array[6][21] = true;
        this.profile_match_array[6][22] = true;
        this.profile_match_array[6][23] = true;
        this.profile_match_array[7][3] = true;
        this.profile_match_array[7][12] = true;
        this.profile_match_array[7][21] = true;
        this.profile_match_array[8][4] = true;
        this.profile_match_array[8][13] = true;
        this.profile_match_array[8][22] = true;
        this.profile_match_array[9][0] = true;
        this.profile_match_array[9][1] = true;
        this.profile_match_array[9][2] = true;
        this.profile_match_array[9][3] = true;
        this.profile_match_array[9][4] = true;
        this.profile_match_array[9][5] = true;
        this.profile_match_array[9][6] = true;
        this.profile_match_array[9][7] = true;
        this.profile_match_array[9][8] = true;
        this.profile_match_array[9][18] = true;
        this.profile_match_array[9][19] = true;
        this.profile_match_array[9][20] = true;
        this.profile_match_array[9][21] = true;
        this.profile_match_array[9][22] = true;
        this.profile_match_array[9][23] = true;
        this.profile_match_array[9][24] = true;
        this.profile_match_array[9][25] = true;
        this.profile_match_array[9][26] = true;
        this.profile_match_array[10][0] = true;
        this.profile_match_array[10][3] = true;
        this.profile_match_array[10][6] = true;
        this.profile_match_array[10][18] = true;
        this.profile_match_array[10][21] = true;
        this.profile_match_array[10][24] = true;
        this.profile_match_array[11][1] = true;
        this.profile_match_array[11][4] = true;
        this.profile_match_array[11][7] = true;
        this.profile_match_array[11][19] = true;
        this.profile_match_array[11][22] = true;
        this.profile_match_array[11][25] = true;
        this.profile_match_array[12][0] = true;
        this.profile_match_array[12][1] = true;
        this.profile_match_array[12][2] = true;
        this.profile_match_array[12][18] = true;
        this.profile_match_array[12][19] = true;
        this.profile_match_array[12][20] = true;
        this.profile_match_array[13][0] = true;
        this.profile_match_array[13][18] = true;
        this.profile_match_array[14][1] = true;
        this.profile_match_array[14][19] = true;
        this.profile_match_array[15][3] = true;
        this.profile_match_array[15][4] = true;
        this.profile_match_array[15][5] = true;
        this.profile_match_array[15][21] = true;
        this.profile_match_array[15][22] = true;
        this.profile_match_array[15][23] = true;
        this.profile_match_array[16][3] = true;
        this.profile_match_array[16][21] = true;
        this.profile_match_array[17][4] = true;
        this.profile_match_array[17][22] = true;
        this.profile_match_array[18][9] = true;
        this.profile_match_array[18][10] = true;
        this.profile_match_array[18][11] = true;
        this.profile_match_array[18][12] = true;
        this.profile_match_array[18][13] = true;
        this.profile_match_array[18][14] = true;
        this.profile_match_array[18][15] = true;
        this.profile_match_array[18][16] = true;
        this.profile_match_array[18][17] = true;
        this.profile_match_array[19][9] = true;
        this.profile_match_array[19][12] = true;
        this.profile_match_array[19][15] = true;
        this.profile_match_array[20][10] = true;
        this.profile_match_array[20][13] = true;
        this.profile_match_array[20][16] = true;
        this.profile_match_array[21][9] = true;
        this.profile_match_array[21][10] = true;
        this.profile_match_array[21][11] = true;
        this.profile_match_array[22][9] = true;
        this.profile_match_array[23][10] = true;
        this.profile_match_array[24][12] = true;
        this.profile_match_array[24][13] = true;
        this.profile_match_array[24][14] = true;
        this.profile_match_array[25][12] = true;
        this.profile_match_array[26][13] = true;
    }

    private int[] getProfileTypes(int n) {
        int[] nArray = new int[]{n / 9, n / 3 % 3, n % 3};
        return nArray;
    }
}

