/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class NarcsDataProfile {
    private boolean visible;
    private Color default_line_color;
    private Color line_color;
    private int default_line_thickness;
    private int line_thickness;
    private int default_line_style;
    private int line_style;
    private int group_num;
    private int prof_num;
    private int stat_type;
    private int qc_type;
    private int terrain_type;
    private int cloud_type;
    private String label;
    private float[] values;

    public NarcsDataProfile(float[] fArray, Color color, int n, int n2, int n3, int n4, int n5, int n6, String string) {
        this.values = fArray;
        this.line_color = color;
        this.group_num = n;
        this.prof_num = n2;
        this.stat_type = n3;
        this.qc_type = n4;
        this.terrain_type = n5;
        this.cloud_type = n6;
        this.label = string;
        this.default_line_color = color;
        this.default_line_thickness = this.line_thickness;
        this.default_line_style = this.line_style;
    }

    public float getValue(int n) {
        float f = -32768.0f;
        if (n < this.values.length) {
            f = this.values[n];
        }
        return f;
    }

    public float[] getValues() {
        return this.values;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getNumberOfPoints() {
        return this.values.length;
    }

    public float getMinimumValue() {
        float f = 999999.0f;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -32768.0f || this.values[i] == -32768.0f) continue;
            f = Math.min(f, this.values[i]);
        }
        return f;
    }

    public float getMaximumValue() {
        float f = -999999.0f;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == -32768.0f || this.values[i] == -32768.0f) continue;
            f = Math.max(f, this.values[i]);
        }
        return f;
    }

    public int getGroupNumber() {
        return this.group_num;
    }

    public int getDataType() {
        return this.prof_num;
    }

    public int getStatType() {
        return this.stat_type;
    }

    public int getQCType() {
        return this.qc_type;
    }

    public int getTerrainType() {
        return this.terrain_type;
    }

    public int getCloudType() {
        return this.cloud_type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setLineColor(Color color) {
        this.line_color = color;
    }

    public Color getLineColor() {
        return this.line_color;
    }

    public Color getDefaultLineColor() {
        return this.default_line_color;
    }

    public void setLineThickness(int n) {
        this.line_thickness = n;
    }

    public int getLineThickness() {
        return this.line_thickness;
    }

    public int getDefaultLineThickness() {
        return this.default_line_thickness;
    }

    public void setLineStyle(int n) {
        this.line_style = n;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public int getDefaultLineStyle() {
        return this.default_line_style;
    }
}

