/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

public class NarcsGlobals
implements Externalizable {
    static final long serialVersionUID = 1L;
    private static boolean variables_initialized;
    private static Point window_position;
    private static Dimension window_dimension;
    private static String current_file_name;
    private static String last_file_directory;
    private static String image_directory;
    private static int last_selected_tab;
    private static int last_selected_temperature_pressure;
    private static int last_selected_moisture_pressure;
    private static boolean use_sample_size_display_cutoff;
    private static float sample_size_display_cutoff;
    private static int sample_size_min_max_option;
    private static int temp_min_max_option;
    private static int wvap_min_max_option;
    private static float sample_size_default_min;
    private static float temp_default_min;
    private static float wvap_default_min;
    private static float sample_size_default_max;
    private static float temp_default_max;
    private static float wvap_default_max;
    private static float sample_size_manual_min;
    private static float temp_manual_min;
    private static float wvap_manual_min;
    private static float sample_size_manual_max;
    private static float temp_manual_max;
    private static float wvap_manual_max;
    private static boolean sample_size_ignore_extremes;
    private static boolean temp_ignore_extremes;
    private static boolean wvap_ignore_extremes;
    private static long earliest_data_date;
    private static long latest_data_date;
    private static long current_start_date;
    private static long current_end_date;
    private static int[] dates;
    private static boolean show_data_points;
    private static int time_window_option;
    private static boolean show_bias;
    private static boolean show_std_dev;
    private static boolean show_rms;
    private static boolean show_sample_size;
    private static boolean show_passed_and_failed_qc;
    private static boolean show_passed_qc;
    private static boolean show_failed_qc;
    private static boolean show_sea;
    private static boolean show_nonsea;
    private static boolean show_sea_and_nonsea;
    private static boolean show_clear;
    private static boolean show_cloudy;
    private static boolean show_clear_and_cloudy;
    private static boolean[] show_datagroup;
    private static boolean[] show_subgroup;
    private static Color[] default_group_colors;
    private static Color[] group_colors;
    private static int[][] default_group_thicknesses;
    private static int[][] group_thicknesses;
    private static int[][] default_group_styles;
    private static int[][] group_styles;
    private static Color[] default_subgroup_colors;
    private static Color[] subgroup_colors;
    private static int[][][] default_subgroup_line_thicknesses;
    private static int[][][] default_subgroup_line_styles;
    private static int[][][] subgroup_line_thicknesses;
    private static int[][][] subgroup_line_styles;
    private static int atmos_stat;
    private static int atmos_qc;
    private static int atmos_terrain;
    private static int atmos_cloud;
    private static int atmos_subgroup;
    private static int[][] atmos_min_max_option;
    private static float[][] atmos_manual_min;
    private static float[][] atmos_manual_max;
    private static int[][] atmos_color_scale;
    private static boolean[][] atmos_center_on_zero;
    private static boolean[][] atmos_ignore_out_of_bounds;

    public NarcsGlobals() {
        if (!variables_initialized) {
            this.initializeVariables();
        }
    }

    private void initializeVariables() {
        int n;
        int n2;
        int n3;
        variables_initialized = true;
        window_position = new Point(0, 0);
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n3 = (int)((double)dimension.width * 0.75);
            n2 = (int)((double)dimension.height * 0.75);
            window_dimension = new Dimension(n3, n2);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        last_selected_tab = 0;
        last_selected_temperature_pressure = 0;
        last_selected_moisture_pressure = 0;
        use_sample_size_display_cutoff = false;
        sample_size_display_cutoff = 0.25f;
        sample_size_min_max_option = 1;
        sample_size_manual_min = 1.0f;
        sample_size_manual_max = 1000.0f;
        sample_size_ignore_extremes = false;
        temp_min_max_option = 0;
        temp_default_min = -1.5f;
        temp_default_max = 5.0f;
        temp_manual_min = -1.5f;
        temp_manual_max = 5.0f;
        temp_ignore_extremes = false;
        wvap_min_max_option = 0;
        wvap_default_min = -100.0f;
        wvap_default_max = 150.0f;
        wvap_manual_min = -100.0f;
        wvap_manual_max = 150.0f;
        wvap_ignore_extremes = false;
        earliest_data_date = -32768L;
        latest_data_date = -32768L;
        current_start_date = -32768L;
        current_end_date = -32768L;
        show_data_points = false;
        time_window_option = 0;
        show_bias = true;
        show_std_dev = true;
        show_rms = false;
        show_sample_size = false;
        show_passed_and_failed_qc = true;
        show_passed_qc = false;
        show_failed_qc = false;
        show_sea_and_nonsea = true;
        show_sea = false;
        show_nonsea = false;
        show_clear_and_cloudy = true;
        show_clear = false;
        show_cloudy = false;
        show_datagroup = null;
        show_subgroup = null;
        atmos_stat = 0;
        atmos_qc = 0;
        atmos_terrain = 0;
        atmos_cloud = 0;
        atmos_subgroup = 0;
        atmos_min_max_option = new int[2][4];
        atmos_manual_min = new float[2][4];
        atmos_manual_max = new float[2][4];
        atmos_center_on_zero = new boolean[2][4];
        atmos_ignore_out_of_bounds = new boolean[2][4];
        atmos_color_scale = new int[2][4];
        NarcsGlobals.atmos_min_max_option[0][0] = 0;
        NarcsGlobals.atmos_min_max_option[0][1] = 0;
        NarcsGlobals.atmos_min_max_option[0][2] = 0;
        NarcsGlobals.atmos_min_max_option[0][3] = 0;
        NarcsGlobals.atmos_min_max_option[1][0] = 0;
        NarcsGlobals.atmos_min_max_option[1][1] = 0;
        NarcsGlobals.atmos_min_max_option[1][2] = 0;
        NarcsGlobals.atmos_min_max_option[1][3] = 0;
        NarcsGlobals.atmos_manual_min[0][0] = -2.5f;
        NarcsGlobals.atmos_manual_min[0][1] = 0.0f;
        NarcsGlobals.atmos_manual_min[0][2] = 0.0f;
        NarcsGlobals.atmos_manual_min[0][3] = 0.0f;
        NarcsGlobals.atmos_manual_min[1][0] = -50.0f;
        NarcsGlobals.atmos_manual_min[1][1] = 0.0f;
        NarcsGlobals.atmos_manual_min[1][2] = 0.0f;
        NarcsGlobals.atmos_manual_min[1][3] = 0.0f;
        NarcsGlobals.atmos_manual_max[0][0] = 2.5f;
        NarcsGlobals.atmos_manual_max[0][1] = 5.0f;
        NarcsGlobals.atmos_manual_max[0][2] = 5.0f;
        NarcsGlobals.atmos_manual_max[0][3] = 1000.0f;
        NarcsGlobals.atmos_manual_max[1][0] = 150.0f;
        NarcsGlobals.atmos_manual_max[1][1] = 150.0f;
        NarcsGlobals.atmos_manual_max[1][2] = 150.0f;
        NarcsGlobals.atmos_manual_max[1][3] = 1000.0f;
        NarcsGlobals.atmos_center_on_zero[0][0] = true;
        NarcsGlobals.atmos_center_on_zero[0][1] = false;
        NarcsGlobals.atmos_center_on_zero[0][2] = false;
        NarcsGlobals.atmos_center_on_zero[0][3] = false;
        NarcsGlobals.atmos_center_on_zero[1][0] = true;
        NarcsGlobals.atmos_center_on_zero[1][1] = false;
        NarcsGlobals.atmos_center_on_zero[1][2] = false;
        NarcsGlobals.atmos_center_on_zero[1][3] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[0][0] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[0][1] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[0][2] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[0][3] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[1][0] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[1][1] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[1][2] = false;
        NarcsGlobals.atmos_ignore_out_of_bounds[1][3] = false;
        NarcsGlobals.atmos_color_scale[0][0] = 1;
        NarcsGlobals.atmos_color_scale[0][1] = 0;
        NarcsGlobals.atmos_color_scale[0][2] = 0;
        NarcsGlobals.atmos_color_scale[0][3] = 0;
        NarcsGlobals.atmos_color_scale[1][0] = 1;
        NarcsGlobals.atmos_color_scale[1][1] = 0;
        NarcsGlobals.atmos_color_scale[1][2] = 0;
        NarcsGlobals.atmos_color_scale[1][3] = 0;
        current_file_name = null;
        last_file_directory = System.getProperty("user.dir") + System.getProperty("file.separator");
        image_directory = System.getProperty("user.dir") + System.getProperty("file.separator");
        default_group_colors = new Color[50];
        NarcsGlobals.default_group_colors[0] = Color.black;
        NarcsGlobals.default_group_colors[1] = new Color(200, 200, 200);
        NarcsGlobals.default_group_colors[2] = new Color(150, 150, 150);
        NarcsGlobals.default_group_colors[3] = new Color(50, 50, 50);
        NarcsGlobals.default_group_colors[4] = new Color(100, 100, 100);
        NarcsGlobals.default_group_colors[5] = new Color(255, 0, 0);
        NarcsGlobals.default_group_colors[6] = new Color(0, 0, 255);
        NarcsGlobals.default_group_colors[7] = new Color(0, 150, 0);
        NarcsGlobals.default_group_colors[8] = new Color(217, 0, 217);
        NarcsGlobals.default_group_colors[9] = new Color(255, 120, 0);
        NarcsGlobals.default_group_colors[10] = new Color(0, 217, 217);
        NarcsGlobals.default_group_colors[11] = new Color(128, 0, 0);
        NarcsGlobals.default_group_colors[12] = new Color(0, 0, 128);
        NarcsGlobals.default_group_colors[13] = new Color(0, 217, 0);
        NarcsGlobals.default_group_colors[14] = new Color(128, 0, 128);
        NarcsGlobals.default_group_colors[15] = new Color(128, 60, 0);
        NarcsGlobals.default_group_colors[16] = new Color(0, 128, 128);
        NarcsGlobals.default_group_colors[17] = new Color(255, 128, 128);
        NarcsGlobals.default_group_colors[18] = new Color(128, 128, 255);
        NarcsGlobals.default_group_colors[19] = new Color(75, 150, 75);
        NarcsGlobals.default_group_colors[20] = new Color(217, 108, 217);
        NarcsGlobals.default_group_colors[21] = new Color(255, 187, 128);
        NarcsGlobals.default_group_colors[22] = new Color(108, 217, 217);
        NarcsGlobals.default_group_colors[23] = new Color(128, 64, 64);
        NarcsGlobals.default_group_colors[24] = new Color(64, 64, 128);
        NarcsGlobals.default_group_colors[25] = new Color(128, 255, 128);
        NarcsGlobals.default_group_colors[26] = new Color(128, 96, 128);
        NarcsGlobals.default_group_colors[27] = new Color(128, 96, 64);
        NarcsGlobals.default_group_colors[28] = new Color(64, 128, 128);
        for (n = 29; n < 50; ++n) {
            NarcsGlobals.default_group_colors[n] = Color.black;
        }
        group_colors = new Color[50];
        for (n = 0; n < default_group_colors.length; ++n) {
            NarcsGlobals.group_colors[n] = default_group_colors[n];
        }
        default_group_thicknesses = new int[50][27];
        group_thicknesses = new int[50][27];
        default_group_styles = new int[50][27];
        group_styles = new int[50][27];
        for (n = 0; n < 50; ++n) {
            for (n3 = 0; n3 < 27; ++n3) {
                NarcsGlobals.default_group_thicknesses[n][n3] = 0;
                NarcsGlobals.group_thicknesses[n][n3] = 0;
                NarcsGlobals.default_group_styles[n][n3] = 0;
                NarcsGlobals.group_styles[n][n3] = 0;
            }
        }
        default_subgroup_colors = new Color[45];
        subgroup_colors = new Color[45];
        default_subgroup_line_thicknesses = new int[45][27][4];
        subgroup_line_thicknesses = new int[45][27][4];
        default_subgroup_line_styles = new int[45][27][4];
        subgroup_line_styles = new int[45][27][4];
        for (n = 5; n < 50; ++n) {
            NarcsGlobals.default_subgroup_colors[n - 5] = default_group_colors[n];
            NarcsGlobals.subgroup_colors[n - 5] = default_group_colors[n];
            for (n3 = 0; n3 < 27; ++n3) {
                for (n2 = 0; n2 < 4; ++n2) {
                    NarcsGlobals.default_subgroup_line_thicknesses[n - 5][n3][n2] = 0;
                    NarcsGlobals.subgroup_line_thicknesses[n - 5][n3][n2] = 0;
                    NarcsGlobals.default_subgroup_line_styles[n - 5][n3][n2] = n2;
                    NarcsGlobals.subgroup_line_styles[n - 5][n3][n2] = n2;
                }
            }
        }
    }

    public void setWindowPosition(Point point) {
        window_position = point;
    }

    public Point getWindowPosition() {
        return window_position;
    }

    public void setWindowDimension(Dimension dimension) {
        window_dimension = dimension;
    }

    public Dimension getWindowDimension() {
        return window_dimension;
    }

    public void setLastSelectedTab(int n) {
        last_selected_tab = n;
    }

    public int getLastSelectedTab() {
        return last_selected_tab;
    }

    public void setLastSelectedTemperaturePressure(int n) {
        last_selected_temperature_pressure = n;
    }

    public int getLastSelectedTemperaturePressure() {
        return last_selected_temperature_pressure;
    }

    public void setLastSelectedMoisturePressure(int n) {
        last_selected_moisture_pressure = n;
    }

    public int getLastSelectedMoisturePressure() {
        return last_selected_moisture_pressure;
    }

    public void setDefaultGroupColors(Color[] colorArray) {
        default_group_colors = colorArray;
    }

    public Color[] getDefaultGroupColors() {
        return default_group_colors;
    }

    public void setGroupColors(Color[] colorArray) {
        group_colors = colorArray;
    }

    public Color[] getGroupColors() {
        return group_colors;
    }

    public void setGroupColor(int n, Color color) {
        if (n >= 0 && n < group_colors.length) {
            NarcsGlobals.group_colors[n] = color;
        }
    }

    public Color getGroupColor(int n) {
        Color color = Color.black;
        if (n >= 0 && n < group_colors.length) {
            color = group_colors[n];
        }
        return color;
    }

    public void setDefaultGroupLineThicknesses(int[][] nArray) {
        default_group_thicknesses = nArray;
    }

    public int[][] getDefaultGroupLineThicknesses() {
        return default_group_thicknesses;
    }

    public void setGroupLineThicknesses(int[][] nArray) {
        group_thicknesses = nArray;
    }

    public int[][] getGroupLineThicknesses() {
        return group_thicknesses;
    }

    public void setGroupLineThickness(int n, int n2, int n3) {
        NarcsGlobals.group_thicknesses[n][n2] = n3;
    }

    public int getGroupLineThickness(int n, int n2) {
        int n3 = 0;
        if (n2 < 0 || n2 >= 27) {
            n2 = 0;
        }
        if (n >= 0 && n < group_colors.length) {
            n3 = group_thicknesses[n][n2];
        }
        return n3;
    }

    public void setDefaultGroupLineStyles(int[][] nArray) {
        default_group_styles = nArray;
    }

    public int[][] getDefaultGroupLineStyles() {
        return default_group_styles;
    }

    public void setGroupLineStyles(int[][] nArray) {
        group_styles = nArray;
    }

    public int[][] getGroupLineStyles() {
        return group_styles;
    }

    public int getGroupLineStyle(int n, int n2) {
        int n3 = 0;
        if (n2 < 0 || n2 >= 27) {
            n2 = 0;
        }
        if (n >= 0 && n < group_colors.length) {
            n3 = group_styles[n][n2];
        }
        return n3;
    }

    public void setDefaultSubgroupColors(Color[] colorArray) {
        default_subgroup_colors = colorArray;
    }

    public Color[] getDefaultSubgroupColors() {
        return default_subgroup_colors;
    }

    public void setSubgroupColors(Color[] colorArray) {
        subgroup_colors = colorArray;
    }

    public Color[] getSubgroupColors() {
        return subgroup_colors;
    }

    public void setSubgroupColor(int n, Color color) {
        if (n >= 0 && n < subgroup_colors.length) {
            NarcsGlobals.subgroup_colors[n] = color;
        }
    }

    public Color getSubgroupColor(int n) {
        Color color = Color.black;
        if (n >= 0 && n < subgroup_colors.length) {
            color = subgroup_colors[n];
        }
        return color;
    }

    public void setDefaultSubgroupLineThicknesses(int[][][] nArray) {
        default_subgroup_line_thicknesses = nArray;
    }

    public int[][][] getDefaultSubgroupLineThicknesses() {
        return default_subgroup_line_thicknesses;
    }

    public void setSubgroupLineThicknesses(int[][][] nArray) {
        subgroup_line_thicknesses = nArray;
    }

    public int[][][] getSubgroupLineThicknesses() {
        return subgroup_line_thicknesses;
    }

    public void setSubgroupLineThickness(int n, int n2, int n3, int n4) {
        NarcsGlobals.subgroup_line_thicknesses[n][n2][n3] = n4;
    }

    public int getSubgroupLineThickness(int n, int n2, int n3) {
        int n4 = 0;
        if (n2 < 0 || n2 >= 27) {
            n2 = 0;
        }
        if (n3 < 0 || n3 > 4) {
            n3 = 0;
        }
        if (n >= 0 && n < subgroup_line_thicknesses.length) {
            n4 = subgroup_line_thicknesses[n][n2][n3];
        }
        return n4;
    }

    public void setDefaultSubgroupLineStyles(int[][][] nArray) {
        default_subgroup_line_styles = nArray;
    }

    public int[][][] getDefaultSubgroupLineStyles() {
        return default_subgroup_line_styles;
    }

    public void setSubgroupLineStyles(int[][][] nArray) {
        subgroup_line_styles = nArray;
    }

    public int[][][] getSubgroupLineStyles() {
        return subgroup_line_styles;
    }

    public int getSubgroupLineStyle(int n, int n2, int n3) {
        int n4 = 0;
        if (n2 < 0 || n2 >= 27) {
            n2 = 0;
        }
        if (n3 < 0 || n3 > 4) {
            n3 = 0;
        }
        if (n >= 0 && n < subgroup_line_styles.length) {
            n4 = subgroup_line_styles[n][n2][n3];
        }
        return n4;
    }

    public void setSampleSizeMinMaxOption(int n) {
        sample_size_min_max_option = n;
    }

    public int getSampleSizeMinMaxOption() {
        return sample_size_min_max_option;
    }

    public void setSampleSizeManualMin(float f) {
        sample_size_manual_min = f;
    }

    public int getSampleSizeManualMin() {
        return (int)sample_size_manual_min;
    }

    public void setSampleSizeManualMax(float f) {
        sample_size_manual_max = f;
    }

    public int getSampleSizeManualMax() {
        return (int)sample_size_manual_max;
    }

    public void setSampleSizeIgnoreExtremes(boolean bl) {
        sample_size_ignore_extremes = bl;
    }

    public boolean getSampleSizeIgnoreExtremes() {
        return sample_size_ignore_extremes;
    }

    public void setTempMinMaxOption(int n) {
        temp_min_max_option = n;
    }

    public int getTempMinMaxOption() {
        return temp_min_max_option;
    }

    public void setTempManualMin(float f) {
        temp_manual_min = f;
    }

    public float getTempManualMin() {
        return temp_manual_min;
    }

    public void setTempManualMax(float f) {
        temp_manual_max = f;
    }

    public float getTempManualMax() {
        return temp_manual_max;
    }

    public float getTempDefaultMin() {
        return temp_default_min;
    }

    public float getTempDefaultMax() {
        return temp_default_max;
    }

    public void setTempIgnoreExtremes(boolean bl) {
        temp_ignore_extremes = bl;
    }

    public boolean getTempIgnoreExtremes() {
        return temp_ignore_extremes;
    }

    public void setWvapMinMaxOption(int n) {
        wvap_min_max_option = n;
    }

    public int getWvapMinMaxOption() {
        return wvap_min_max_option;
    }

    public void setWvapManualMin(float f) {
        wvap_manual_min = f;
    }

    public float getWvapManualMin() {
        return wvap_manual_min;
    }

    public void setWvapManualMax(float f) {
        wvap_manual_max = f;
    }

    public float getWvapManualMax() {
        return wvap_manual_max;
    }

    public float getWvapDefaultMin() {
        return wvap_default_min;
    }

    public float getWvapDefaultMax() {
        return wvap_default_max;
    }

    public void setWvapIgnoreExtremes(boolean bl) {
        wvap_ignore_extremes = bl;
    }

    public boolean getWvapIgnoreExtremes() {
        return wvap_ignore_extremes;
    }

    public void setDates(int[] nArray) {
        dates = nArray;
    }

    public int[] getDates() {
        return dates;
    }

    public void setEarliestDataDate(long l) {
        earliest_data_date = l;
    }

    public long getEarliestDataDate() {
        return earliest_data_date;
    }

    public void setLatestDataDate(long l) {
        latest_data_date = l;
    }

    public long getLatestDataDate() {
        return latest_data_date;
    }

    public void setCurrentStartDate(long l) {
        current_start_date = l;
    }

    public long getCurrentStartDate() {
        return current_start_date;
    }

    public void setCurrentEndDate(long l) {
        current_end_date = l;
    }

    public long getCurrentEndDate() {
        return current_end_date;
    }

    public void setUseSampleSizeDisplayCutoff(boolean bl) {
        use_sample_size_display_cutoff = bl;
    }

    public boolean getUseSampleSizeDisplayCutoff() {
        return use_sample_size_display_cutoff;
    }

    public void setSampleSizeDisplayCutoff(float f) {
        sample_size_display_cutoff = f;
    }

    public float getSampleSizeDisplayCutoff() {
        return sample_size_display_cutoff;
    }

    public void setShowDataPoints(boolean bl) {
        show_data_points = bl;
    }

    public boolean getShowDataPoints() {
        return show_data_points;
    }

    public void setTimeWindowOption(int n) {
        time_window_option = n;
    }

    public int getTimeWindowOption() {
        return time_window_option;
    }

    public void setShowBias(boolean bl) {
        show_bias = bl;
    }

    public boolean getShowBias() {
        return show_bias;
    }

    public void setShowStdDev(boolean bl) {
        show_std_dev = bl;
    }

    public boolean getShowStdDev() {
        return show_std_dev;
    }

    public void setShowRMS(boolean bl) {
        show_rms = bl;
    }

    public boolean getShowRMS() {
        return show_rms;
    }

    public void setShowSampleSize(boolean bl) {
        show_sample_size = bl;
    }

    public boolean getShowSampleSize() {
        return show_sample_size;
    }

    public void setShowPassedAndFailedQC(boolean bl) {
        show_passed_and_failed_qc = bl;
    }

    public boolean getShowPassedAndFailedQC() {
        return show_passed_and_failed_qc;
    }

    public void setShowPassedQC(boolean bl) {
        show_passed_qc = bl;
    }

    public boolean getShowPassedQC() {
        return show_passed_qc;
    }

    public void setShowFailedQC(boolean bl) {
        show_failed_qc = bl;
    }

    public boolean getShowFailedQC() {
        return show_failed_qc;
    }

    public void setShowSea(boolean bl) {
        show_sea = bl;
    }

    public boolean getShowSea() {
        return show_sea;
    }

    public void setShowNonsea(boolean bl) {
        show_nonsea = bl;
    }

    public boolean getShowNonsea() {
        return show_nonsea;
    }

    public void setShowSeaAndNonsea(boolean bl) {
        show_sea_and_nonsea = bl;
    }

    public boolean getShowSeaAndNonsea() {
        return show_sea_and_nonsea;
    }

    public void setShowClear(boolean bl) {
        show_clear = bl;
    }

    public boolean getShowClear() {
        return show_clear;
    }

    public void setShowCloudy(boolean bl) {
        show_cloudy = bl;
    }

    public boolean getShowCloudy() {
        return show_cloudy;
    }

    public void setShowClearAndCloudy(boolean bl) {
        show_clear_and_cloudy = bl;
    }

    public boolean getShowClearAndCloudy() {
        return show_clear_and_cloudy;
    }

    public void setShowDataGroups(boolean[] blArray) {
        show_datagroup = blArray;
    }

    public boolean[] getShowDataGroups() {
        return show_datagroup;
    }

    public void setShowSubGroups(boolean[] blArray) {
        show_subgroup = blArray;
    }

    public boolean[] getShowSubGroups() {
        return show_subgroup;
    }

    public void setAtmosStatistic(int n) {
        atmos_stat = n;
    }

    public int getAtmosStatistic() {
        return atmos_stat;
    }

    public void setAtmosQC(int n) {
        atmos_qc = n;
    }

    public int getAtmosQC() {
        return atmos_qc;
    }

    public void setAtmosTerrain(int n) {
        atmos_terrain = n;
    }

    public int getAtmosTerrain() {
        return atmos_terrain;
    }

    public void setAtmosCloud(int n) {
        atmos_cloud = n;
    }

    public int getAtmosCloud() {
        return atmos_cloud;
    }

    public void setAtmosSubgroup(int n) {
        atmos_subgroup = n;
    }

    public int getAtmosSubgroup() {
        return atmos_subgroup;
    }

    public void setAtmosMinMaxOption(int n, int n2, int n3) {
        NarcsGlobals.atmos_min_max_option[n][n2] = n3;
    }

    public int getAtmosMinMaxOption(int n, int n2) {
        return atmos_min_max_option[n][n2];
    }

    public void setAtmosManualMin(int n, int n2, float f) {
        NarcsGlobals.atmos_manual_min[n][n2] = f;
    }

    public float getAtmosManualMin(int n, int n2) {
        return atmos_manual_min[n][n2];
    }

    public void setAtmosManualMax(int n, int n2, float f) {
        NarcsGlobals.atmos_manual_max[n][n2] = f;
    }

    public float getAtmosManualMax(int n, int n2) {
        return atmos_manual_max[n][n2];
    }

    public void setAtmosCenterOnZero(int n, int n2, boolean bl) {
        NarcsGlobals.atmos_center_on_zero[n][n2] = bl;
    }

    public boolean getAtmosCenterOnZero(int n, int n2) {
        return atmos_center_on_zero[n][n2];
    }

    public void setAtmosIgnoreOutOfBounds(int n, int n2, boolean bl) {
        NarcsGlobals.atmos_ignore_out_of_bounds[n][n2] = bl;
    }

    public boolean getAtmosIgnoreOutOfBounds(int n, int n2) {
        return atmos_ignore_out_of_bounds[n][n2];
    }

    public void setAtmosColorScale(int n, int n2, int n3) {
        NarcsGlobals.atmos_color_scale[n][n2] = n3;
    }

    public int getAtmosColorScale(int n, int n2) {
        return atmos_color_scale[n][n2];
    }

    public void setCurrentFileName(String string) {
        current_file_name = string;
    }

    public String getCurrentFileName() {
        return current_file_name;
    }

    public void setLastFileDirectory(String string) {
        last_file_directory = string;
    }

    public String getLastFileDirectory() {
        return last_file_directory;
    }

    public void setImageDirectory(String string) {
        image_directory = string;
    }

    public String getImageDirectory() {
        return image_directory;
    }

    public void setLineStyle(Graphics2D graphics2D, int n, int n2) {
        switch (n) {
            case 0: {
                BasicStroke basicStroke = new BasicStroke(n2, 0, 1);
                graphics2D.setStroke(basicStroke);
                break;
            }
            case 1: {
                float[] fArray = new float[]{3.0f, 2.0f};
                BasicStroke basicStroke = new BasicStroke(n2, 0, 1, 5.0f, fArray, 0.0f);
                graphics2D.setStroke(basicStroke);
                break;
            }
            case 2: {
                float[] fArray = new float[]{6.0f, 3.0f};
                BasicStroke basicStroke = new BasicStroke(n2, 0, 1, 5.0f, fArray, 0.0f);
                graphics2D.setStroke(basicStroke);
                break;
            }
            case 3: {
                float[] fArray = new float[]{6.0f, 3.0f, 2.0f, 3.0f};
                BasicStroke basicStroke = new BasicStroke(n2, 0, 1, 5.0f, fArray, 0.0f);
                graphics2D.setStroke(basicStroke);
                break;
            }
            case 4: {
                float[] fArray = new float[]{6.0f, 3.0f, 2.0f, 3.0f};
                BasicStroke basicStroke = new BasicStroke(n2, 0, 1, 5.0f, fArray, 0.0f);
                graphics2D.setStroke(basicStroke);
                break;
            }
            case 5: {
                int[] nArray = new int[5];
                int[] nArray2 = new int[5];
                nArray[0] = 0;
                nArray2[0] = -n2;
                nArray[1] = -n2;
                nArray2[1] = 0;
                nArray[2] = 0;
                nArray2[2] = n2;
                nArray[3] = n2;
                nArray2[3] = 0;
                nArray[4] = 0;
                nArray2[4] = -n2;
                Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
                ShapeStroke shapeStroke = new ShapeStroke(new Shape[]{polygon}, (float)(n2 * 2));
                graphics2D.setStroke(shapeStroke);
                break;
            }
            default: {
                BasicStroke basicStroke = new BasicStroke(n2, 0, 1);
                graphics2D.setStroke(basicStroke);
                break;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("window_position", window_position);
        hashMap.put("window_dimension", window_dimension);
        if (current_file_name != null) {
            hashMap.put("current_file_name", current_file_name);
        }
        hashMap.put("last_file_directory", last_file_directory);
        hashMap.put("image_directory", image_directory);
        hashMap.put("last_selected_tab", new Integer(last_selected_tab));
        hashMap.put("last_selected_temperature_pressure", new Integer(last_selected_temperature_pressure));
        hashMap.put("last_selected_moisture_pressure", new Integer(last_selected_moisture_pressure));
        hashMap.put("sample_size_min_max_option", new Integer(sample_size_min_max_option));
        hashMap.put("sample_size_default_min", new Float(sample_size_default_min));
        hashMap.put("sample_size_default_max", new Float(sample_size_default_max));
        hashMap.put("sample_size_manual_min", new Float(sample_size_manual_min));
        hashMap.put("sample_size_manual_max", new Float(sample_size_manual_max));
        hashMap.put("sample_size_ignore_extremes", new Boolean(sample_size_ignore_extremes));
        hashMap.put("temp_min_max_option", new Integer(temp_min_max_option));
        hashMap.put("temp_default_min", new Float(temp_default_min));
        hashMap.put("temp_default_max", new Float(temp_default_max));
        hashMap.put("temp_manual_min", new Float(temp_manual_min));
        hashMap.put("temp_manual_max", new Float(temp_manual_max));
        hashMap.put("temp_ignore_extremes", new Boolean(temp_ignore_extremes));
        hashMap.put("wvap_min_max_option", new Integer(wvap_min_max_option));
        hashMap.put("wvap_default_min", new Float(wvap_default_min));
        hashMap.put("wvap_default_max", new Float(wvap_default_max));
        hashMap.put("wvap_manual_min", new Float(wvap_manual_min));
        hashMap.put("wvap_manual_max", new Float(wvap_manual_max));
        hashMap.put("wvap_ignore_extremes", new Boolean(wvap_ignore_extremes));
        hashMap.put("use_sample_size_display_cutoff", new Boolean(use_sample_size_display_cutoff));
        hashMap.put("sample_size_display_cutoff", new Float(sample_size_display_cutoff));
        hashMap.put("earliest_data_date", new Long(earliest_data_date));
        hashMap.put("latest_data_date", new Long(latest_data_date));
        hashMap.put("current_start_date", new Long(current_start_date));
        hashMap.put("current_end_date", new Long(current_end_date));
        hashMap.put("dates", dates);
        hashMap.put("show_data_points", new Boolean(show_data_points));
        hashMap.put("time_window_option", new Integer(time_window_option));
        hashMap.put("show_bias", new Boolean(show_bias));
        hashMap.put("show_std_dev", new Boolean(show_std_dev));
        hashMap.put("show_rms", new Boolean(show_rms));
        hashMap.put("show_sample_size", new Boolean(show_sample_size));
        hashMap.put("show_passed_and_failed_qc", new Boolean(show_passed_and_failed_qc));
        hashMap.put("show_passed_qc", new Boolean(show_passed_qc));
        hashMap.put("show_failed_qc", new Boolean(show_failed_qc));
        hashMap.put("show_sea", new Boolean(show_sea));
        hashMap.put("show_nonsea", new Boolean(show_nonsea));
        hashMap.put("show_sea_and_nonsea", new Boolean(show_sea_and_nonsea));
        hashMap.put("show_clear", new Boolean(show_clear));
        hashMap.put("show_cloudy", new Boolean(show_cloudy));
        hashMap.put("show_clear_and_cloudy", new Boolean(show_clear_and_cloudy));
        hashMap.put("atmos_stat", new Integer(atmos_stat));
        hashMap.put("atmos_qc", new Integer(atmos_qc));
        hashMap.put("atmos_terrain", new Integer(atmos_terrain));
        hashMap.put("atmos_cloud", new Integer(atmos_cloud));
        hashMap.put("atmos_subgroup", new Integer(atmos_subgroup));
        hashMap.put("atmos_min_max_option", atmos_min_max_option);
        hashMap.put("atmos_manual_min", atmos_manual_min);
        hashMap.put("atmos_manual_max", atmos_manual_max);
        hashMap.put("atmos_center_on_zero", atmos_center_on_zero);
        hashMap.put("atmos_ignore_out_of_bounds", atmos_ignore_out_of_bounds);
        hashMap.put("atmos_color_scale", atmos_color_scale);
        hashMap.put("show_datagroup", show_datagroup);
        hashMap.put("show_subgroup", show_subgroup);
        hashMap.put("default_group_colors", default_group_colors);
        hashMap.put("group_colors", group_colors);
        hashMap.put("default_group_thicknesses", default_group_thicknesses);
        hashMap.put("group_thicknesses", group_thicknesses);
        hashMap.put("default_group_styles", default_group_styles);
        hashMap.put("group_styles", group_styles);
        hashMap.put("default_subgroup_colors", default_subgroup_colors);
        hashMap.put("subgroup_colors", subgroup_colors);
        hashMap.put("default_subgroup_line_thicknesses", default_subgroup_line_thicknesses);
        hashMap.put("subgroup_line_thicknesses", subgroup_line_thicknesses);
        hashMap.put("default_subgroup_line_styles", default_subgroup_line_styles);
        hashMap.put("subgroup_line_styles", subgroup_line_styles);
        objectOutput.writeObject(hashMap);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.initializeVariables();
        HashMap hashMap = (HashMap)objectInput.readObject();
        if (hashMap.containsKey("window_position")) {
            window_position = (Point)hashMap.get("window_position");
        }
        if (hashMap.containsKey("window_dimension")) {
            window_dimension = (Dimension)hashMap.get("window_dimension");
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (NarcsGlobals.window_dimension.width > dimension.width || NarcsGlobals.window_dimension.height > dimension.height) {
            int n = Math.min(dimension.width, NarcsGlobals.window_dimension.width);
            int n2 = Math.min(dimension.height, NarcsGlobals.window_dimension.height);
            window_dimension = new Dimension(n, n2);
        }
        if (hashMap.containsKey("current_file_name")) {
            current_file_name = (String)hashMap.get("current_file_name");
        }
        if (hashMap.containsKey("last_file_directory")) {
            last_file_directory = (String)hashMap.get("last_file_directory");
        }
        if (hashMap.containsKey("image_directory")) {
            image_directory = (String)hashMap.get("image_directory");
        }
        try {
            File file = new File(image_directory);
            if (!file.exists()) {
                image_directory = System.getProperty("user.dir") + System.getProperty("file.separator");
            }
        }
        catch (Exception exception) {
            image_directory = System.getProperty("user.dir") + System.getProperty("file.separator");
        }
        if (hashMap.containsKey("last_selected_tab")) {
            last_selected_tab = (Integer)hashMap.get("last_selected_tab");
        }
        if (hashMap.containsKey("last_selected_temperature_pressure")) {
            last_selected_temperature_pressure = (Integer)hashMap.get("last_selected_temperature_pressure");
        }
        if (hashMap.containsKey("last_selected_moisture_pressure")) {
            last_selected_moisture_pressure = (Integer)hashMap.get("last_selected_moisture_pressure");
        }
        if (hashMap.containsKey("show_data_points")) {
            show_data_points = (Boolean)hashMap.get("show_data_points");
        }
        if (hashMap.containsKey("time_window_option")) {
            time_window_option = (Integer)hashMap.get("time_window_option");
        }
        if (hashMap.containsKey("atmos_stat")) {
            atmos_stat = (Integer)hashMap.get("atmos_stat");
        }
        if (hashMap.containsKey("atmos_qc")) {
            atmos_qc = (Integer)hashMap.get("atmos_qc");
        }
        if (hashMap.containsKey("atmos_terrain")) {
            atmos_terrain = (Integer)hashMap.get("atmos_terrain");
        }
        if (hashMap.containsKey("atmos_cloud")) {
            atmos_cloud = (Integer)hashMap.get("atmos_cloud");
        }
        if (hashMap.containsKey("atmos_subgroup")) {
            atmos_subgroup = (Integer)hashMap.get("atmos_subgroup");
        }
        if (hashMap.containsKey("atmos_min_max_option")) {
            atmos_min_max_option = (int[][])hashMap.get("atmos_min_max_option");
        }
        if (hashMap.containsKey("atmos_manual_min")) {
            atmos_manual_min = (float[][])hashMap.get("atmos_manual_min");
        }
        if (hashMap.containsKey("atmos_manual_max")) {
            atmos_manual_max = (float[][])hashMap.get("atmos_manual_max");
        }
        if (hashMap.containsKey("atmos_center_on_zero")) {
            atmos_center_on_zero = (boolean[][])hashMap.get("atmos_center_on_zero");
        }
        if (hashMap.containsKey("atmos_ignore_out_of_bounds")) {
            atmos_ignore_out_of_bounds = (boolean[][])hashMap.get("atmos_ignore_out_of_bounds");
        }
        if (hashMap.containsKey("atmos_color_scale")) {
            atmos_color_scale = (int[][])hashMap.get("atmos_color_scale");
        }
        if (hashMap.containsKey("show_datagroup")) {
            show_datagroup = (boolean[])hashMap.get("show_datagroup");
        }
        if (hashMap.containsKey("show_subgroup")) {
            show_subgroup = (boolean[])hashMap.get("show_subgroup");
        }
        if (hashMap.containsKey("default_group_colors")) {
            default_group_colors = (Color[])hashMap.get("default_group_colors");
        }
        if (hashMap.containsKey("group_colors")) {
            group_colors = (Color[])hashMap.get("group_colors");
        }
        if (hashMap.containsKey("default_group_thicknesses")) {
            default_group_thicknesses = (int[][])hashMap.get("default_group_thicknesses");
        }
        if (hashMap.containsKey("group_thicknesses")) {
            group_thicknesses = (int[][])hashMap.get("group_thicknesses");
        }
        if (hashMap.containsKey("default_group_styles")) {
            default_group_styles = (int[][])hashMap.get("default_group_styles");
        }
        if (hashMap.containsKey("group_styles")) {
            group_styles = (int[][])hashMap.get("group_styles");
        }
        if (hashMap.containsKey("default_subgroup_colors")) {
            default_subgroup_colors = (Color[])hashMap.get("default_subgroup_colors");
        }
        if (hashMap.containsKey("subgroup_colors")) {
            subgroup_colors = (Color[])hashMap.get("subgroup_colors");
        }
        if (hashMap.containsKey("default_subgroup_line_thicknesses")) {
            default_subgroup_line_thicknesses = (int[][][])hashMap.get("default_subgroup_line_thicknesses");
        }
        if (hashMap.containsKey("default_subgroup_line_styles")) {
            default_subgroup_line_styles = (int[][][])hashMap.get("default_subgroup_line_styles");
        }
        if (hashMap.containsKey("subgroup_line_thicknesses")) {
            subgroup_line_thicknesses = (int[][][])hashMap.get("subgroup_line_thicknesses");
        }
        if (hashMap.containsKey("subgroup_line_styles")) {
            subgroup_line_styles = (int[][][])hashMap.get("subgroup_line_styles");
        }
    }
}

