/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AirsRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public AirsRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public AirsRecord(String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.contains_data = false;
    }

    public AirsRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        int n;
        this.contains_data = false;
        if (this.data_group_type == 400) {
            this.buffer = AirsRecord.convertToLatestFormat(this.data_group_type, sArray);
        } else {
            this.buffer = new short[2000];
            for (n = 0; n < 2000; ++n) {
                this.buffer[n] = sArray[n];
            }
        }
        this.contains_data = false;
        for (n = 0; !this.contains_data && n < this.buffer.length; ++n) {
            if (this.buffer[n] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        String string = " (" + this.buffer[147] + ")";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "";
        return string;
    }

    public int getTerrain() {
        short s = this.buffer[33];
        return s;
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = 0;
        if (this.getTerrain() != 2) {
            n = 1;
        }
        return n;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        if (this.buffer[147] != 0) {
            bl = false;
        }
        return bl;
    }

    public boolean hasCloudFlag() {
        return true;
    }

    public int getCloudFlag() {
        int n = Short.MIN_VALUE;
        int n2 = this.buffer[1167];
        if (n2 == 0) {
            n = 0;
        } else {
            float f = 0.0f;
            for (int i = 0; i < n2; ++i) {
                if (this.buffer[1172 + i] == Short.MIN_VALUE) continue;
                f += (float)this.buffer[1172 + i];
            }
            if (f == 0.0f) {
                n = 0;
            } else if (f > 0.0f && f <= 20.0f) {
                n = 1;
            } else if (f > 20.0f) {
                n = 2;
            }
        }
        return n;
    }

    public int getCloudFlagForNarcs() {
        int n = this.getCloudFlag();
        if (n > 1) {
            n = 1;
        }
        return n;
    }

    public boolean hasDayNightFlag() {
        return true;
    }

    public int getDayNightFlag() {
        String string = "" + (char)this.buffer[13] + (char)this.buffer[14] + (char)this.buffer[15] + (char)this.buffer[16] + (char)this.buffer[17] + (char)this.buffer[18];
        string = string.trim();
        int n = Short.MIN_VALUE;
        if (string.equals("Night")) {
            n = 0;
        } else if (string.equals("Day")) {
            n = 1;
        }
        return n;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        if (this.buffer[136] != Short.MIN_VALUE) {
            f = (float)this.buffer[136] / 10.0f;
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription(), "  First Guess", "  MW-Only"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 1, 22};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[3];
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (n = 0; n < fArray2.length; ++n) {
                if (fArray[n] == -999.99f || fArray2[n] == -999.99f) continue;
                profileArray[0].addItem(fArray[n], fArray2[n]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            string = "  1st Guess";
            profileArray[1] = new Profile(1, string, 0, Color.black, 1, 0);
            fArray2 = this.getFirstGuessTemps();
            for (n = 0; n < fArray2.length; ++n) {
                if (fArray[n] == -999.99f || fArray2[n] == -999.99f) continue;
                profileArray[1].addItem(fArray[n], fArray2[n]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            string = "  MW-only";
            profileArray[2] = new Profile(2, string, 0, Color.black, 1, 0);
            fArray2 = this.getMWOnlyTemps();
            for (n = 0; n < fArray2.length; ++n) {
                if (fArray[n] == -999.99f || fArray2[n] == -999.99f) continue;
                profileArray[2].addItem(fArray[n], fArray2[n]);
            }
            profileArray[2].setSurfacePressure(f);
            profileArray[2].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[3];
        profileArray[0] = null;
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getMoisturePressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || fArray[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f2 = EdgeUtils.convertToDewPoint(fArray2[i], fArray[i]);
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            string = "  1st Guess";
            profileArray[1] = new Profile(1, string, 0, Color.black, 1, 1);
            float[] fArray3 = this.getFirstGuessDewpoints();
            for (int i = 0; i < fArray3.length; ++i) {
                if (fArray3[i] == -999.99f || fArray[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f3 = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                profileArray[1].addItem(fArray[i], fArray3[i]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            string = "  MW-only";
            profileArray[2] = new Profile(2, string, 0, Color.black, 1, 1);
            float[] fArray4 = this.getMWOnlyDewpoints();
            for (int i = 0; i < fArray4.length; ++i) {
                if (fArray4[i] == -999.99f || fArray[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f4 = EdgeUtils.convertToDewPoint(fArray4[i], fArray[i]);
                profileArray[2].addItem(fArray[i], fArray4[i]);
            }
            profileArray[2].setSurfacePressure(f);
            profileArray[2].trimProfile();
        }
        return profileArray;
    }

    private Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[3];
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getMoisturePressureLevels();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || fArray2[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            string = "  1st Guess";
            profileArray[1] = new Profile(1, string, 0, Color.black, 1, 1);
            float[] fArray3 = this.getFirstGuessWaterVapor();
            for (int i = 0; i < fArray3.length; ++i) {
                if (fArray3[i] == -999.99f || fArray2[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[1].addItem(fArray2[i], fArray3[i]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
            string = "  MW-only";
            profileArray[2] = new Profile(2, string, 0, Color.black, 1, 1);
            float[] fArray4 = this.getMWOnlyWaterVapor();
            for (int i = 0; i < fArray4.length; ++i) {
                if (fArray4[i] == -999.99f || fArray2[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[2].addItem(fArray2[i], fArray4[i]);
            }
            profileArray[2].setSurfacePressure(f);
            profileArray[2].trimProfile();
            if (profileArray[2].getNumberOfPoints() == 0) {
                profileArray[2] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n >= 6) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 3) {
                float[] fArray2 = this.getRetrievedTemps();
                if (n == 3) {
                    fArray2 = this.getFirstGuessTemps();
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray3 = this.getRetrievedWaterVapor();
                fArray = this.getMoisturePressureLevels();
                if (n == 4 || n == 5) {
                    fArray3 = this.getFirstGuessWaterVapor();
                }
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && (n == 1 || n == 4)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4), new Vector(4), new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getMoisturePressureLevels();
        float[] fArray4 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray3);
        vectorArray[0].add(fArray4);
        float[] fArray5 = this.getFirstGuessTemps();
        float[] fArray6 = this.getFirstGuessDewpoints();
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray5);
        vectorArray[1].add(fArray3);
        vectorArray[1].add(fArray6);
        float[] fArray7 = this.getMWOnlyTemps();
        float[] fArray8 = this.getMWOnlyDewpoints();
        vectorArray[2].add(fArray);
        vectorArray[2].add(fArray7);
        vectorArray[2].add(fArray3);
        vectorArray[2].add(fArray8);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[]{0.016f, 0.038f, 0.076f, 0.136f, 0.224f, 0.345f, 0.506f, 0.713f, 0.975f, 1.297f, 1.687f, 2.152f, 2.7f, 3.339f, 4.077f, 4.92f, 5.877f, 6.956f, 8.165f, 9.511f, 11.0f, 12.6f, 14.4f, 16.4f, 18.5f, 20.9f, 23.4f, 26.1f, 29.1f, 32.2f, 35.6f, 39.2f, 43.1f, 47.1f, 51.5f, 56.1f, 60.9f, 66.1f, 71.5f, 77.2f, 83.2f, 89.5f, 96.1f, 103.0f, 110.2f, 117.7f, 125.6f, 133.8f, 142.3f, 151.2f, 160.4f, 170.0f, 180.0f, 190.3f, 200.9f, 212.0f, 223.4f, 235.2f, 247.4f, 259.9f, 272.9f, 286.2f, 300.0f, 314.1f, 328.6f, 343.6f, 358.9f, 374.7f, 390.8f, 407.4f, 424.4f, 441.8f, 459.7f, 477.9f, 496.6f, 515.7f, 535.2f, 555.1f, 575.5f, 596.3f, 617.5f, 639.1f, 661.1f, 683.6f, 706.5f, 729.8f, 753.6f, 777.7f, 802.3f, 827.3f, 852.7f, 878.6f, 904.8f, 931.5f, 958.5f, 986.0f, 1013.9f, 1042.2f, 1070.9f, 1100.0f};
        return fArray;
    }

    private float[] getMoisturePressureLevels() {
        float[] fArray = new float[]{0.009f, 0.025f, 0.055f, 0.104f, 0.177f, 0.28f, 0.42f, 0.604f, 0.837f, 1.128f, 1.483f, 1.91f, 2.416f, 3.009f, 3.696f, 4.485f, 5.384f, 6.401f, 7.544f, 8.821f, 10.2f, 11.8f, 13.5f, 15.4f, 17.4f, 19.7f, 22.1f, 24.7f, 27.6f, 30.6f, 33.9f, 37.4f, 41.1f, 45.1f, 49.3f, 53.7f, 58.5f, 63.5f, 68.7f, 74.3f, 80.1f, 86.3f, 92.7f, 99.5f, 106.5f, 113.9f, 121.6f, 129.7f, 138.0f, 146.7f, 155.8f, 165.2f, 175.0f, 185.1f, 195.6f, 206.4f, 217.6f, 229.2f, 241.2f, 253.6f, 266.3f, 279.5f, 293.0f, 307.0f, 321.3f, 336.0f, 351.2f, 366.7f, 382.7f, 399.1f, 415.9f, 433.1f, 450.7f, 468.7f, 487.2f, 506.1f, 525.4f, 545.1f, 565.2f, 585.8f, 606.8f, 628.2f, 650.1f, 672.3f, 695.0f, 718.1f, 741.6f, 765.6f, 790.0f, 814.8f, 840.0f, 865.6f, 891.6f, 918.1f, 944.9f, 972.2f, 1000.0f, 1028.0f, 1056.5f, 1085.3f};
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 149] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 149] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getFirstGuessTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 967] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 967] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getMWOnlyTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 563] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 563] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 355] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 355] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getFirstGuessWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 1067] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 1067] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getMWOnlyWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 765] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 765] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getFirstGuessDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getFirstGuessWaterVapor();
        float[] fArray3 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getMWOnlyDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getMWOnlyWaterVapor();
        float[] fArray3 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLayerDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame");
        if (this.buffer[12] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[12]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Day/Night Flag");
        vector4.add("" + (char)this.buffer[13] + (char)this.buffer[14] + (char)this.buffer[15] + (char)this.buffer[16] + (char)this.buffer[17] + (char)this.buffer[18]);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Orbital Node");
        vector4.add("" + (char)this.buffer[19] + (char)this.buffer[20] + (char)this.buffer[21] + (char)this.buffer[22] + (char)this.buffer[23] + (char)this.buffer[24] + (char)this.buffer[25] + (char)this.buffer[26] + (char)this.buffer[27] + (char)this.buffer[28]);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Mean Topography");
        if (this.buffer[29] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[29] + " m");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Land Fraction");
        if (this.buffer[31] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)this.buffer[31] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure Guess Quality Flag");
        if (this.buffer[135] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[135]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure Guess Value");
        if (this.buffer[136] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[136] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Index of pressure above surface");
        if (this.buffer[137] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[137]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Index of highest pressure quality = 0");
        if (this.buffer[138] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[138]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Index of highest pressure quality = 0 or 1");
        if (this.buffer[139] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[139]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Maximum pressure where quality = 0");
        if (this.buffer[140] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[140] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Maximum pressure where quality = 0 or 1");
        if (this.buffer[141] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[141] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Pressure mid-top");
        if (this.buffer[142] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[142] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Pressure bottom-mid");
        if (this.buffer[143] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[143] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Index of pressure level nearest mid-top");
        if (this.buffer[144] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[144]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Index of pressure level nearest bottom-mid");
        if (this.buffer[145] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[145]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Temperature Quality Flag - top layer");
        if (this.buffer[146] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[146]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Temperature Quality Flag - mid layer");
        if (this.buffer[147] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[147]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Temperature Quality Flag - bottom layer");
        if (this.buffer[148] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[148]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality Flag for surface fields");
        if (this.buffer[351] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[351]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality Flag for water vapor fields");
        if (this.buffer[354] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[354]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Skin Temperature");
        if (this.buffer[352] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[352] / 64.0f) + " K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Skin Temperature Error");
        if (this.buffer[353] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[353] / 64.0f) + " K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Total Precipitable Water");
        if (this.buffer[555] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[555] / 100.0f) + " kg/m^2");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Total Precipitable Water Error");
        if (this.buffer[556] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[556] / 100.0f) + " kg/m^2");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tropopause Pressure");
        if (this.buffer[557] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[557] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tropopause Temperature");
        if (this.buffer[558] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[558] / 64.0f) + " K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tropopause Geopotential Height");
        if (this.buffer[559] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[559] / 1.0f) + " m");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface geopotential height above sea level");
        if (this.buffer[560] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[560] / 1.0f) + " m");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality flag for MW-only temperature (above 201 mb)");
        if (this.buffer[561] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[561]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality flag for MW-only temperature (below 201 mb)");
        if (this.buffer[562] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[562]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality flag for MW-only temperature (above 201 mb)");
        if (this.buffer[763] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[763]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface temperature after first retrieval");
        if (this.buffer[965] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[965] / 64.0f) + " K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface air temperature after first retrieval");
        if (this.buffer[966] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[966] / 64.0f) + " K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Number of cloud layers");
        if (this.buffer[1167] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1167]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Fraction (Layer 1/2)");
        String string = "not available";
        String string2 = "not available";
        if (this.buffer[1172] != Short.MIN_VALUE) {
            string = "" + this.buffer[1172];
        }
        if (this.buffer[1173] != Short.MIN_VALUE) {
            string2 = "" + this.buffer[1173];
        }
        vector4.add(string + " / " + string2);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Pressure (Layer 1/2)");
        string = "not available";
        string2 = "not available";
        if (this.buffer[1170] != Short.MIN_VALUE) {
            string = "" + this.buffer[1170];
        }
        if (this.buffer[1171] != Short.MIN_VALUE) {
            string2 = "" + this.buffer[1171];
        }
        vector4.add(string + " / " + string2);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Temperature (Layer 1/2)");
        string = "not available";
        string2 = "not available";
        if (this.buffer[1168] != Short.MIN_VALUE) {
            string = "" + this.buffer[1168];
        }
        if (this.buffer[1169] != Short.MIN_VALUE) {
            string2 = "" + this.buffer[1169];
        }
        vector4.add(string + " / " + string2);
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLayerDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Layer Data Values</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Pressure");
        vector2.add("Atmospheric\nTemperature");
        vector2.add("Temperature\nError");
        vector2.add("MIT\nTemperature");
        vector2.add("Cldy Regression\nTemperature");
        vector2.add("Air Temp\nAfter 1st Retr");
        vector2.add("Water Vapor\nMixing Ratio");
        vector2.add("Water Vapor\nError");
        vector2.add("MIT\nWater Vapor");
        vector2.add("Cldy Regression\nWVMR");
        vector2.add("WVMR\nAfter 1st Retr");
        float[] fArray = this.getPressureLevels();
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 0; i < 100; ++i) {
            serializable = new Vector<String>(11);
            if (fArray[i] != -32768.0f) {
                if (i < 20) {
                    ((Vector)serializable).add("" + EdgeUtils.fourDigits(fArray[i]));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit(fArray[i]));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[149 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[149 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[249 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[249 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[563 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[563 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[663 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[663 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[967 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[967 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[355 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[355 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[455 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[455 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[765 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[765 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[865 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[865 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1067 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[1067 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }

    public static short[] convertToLatestFormat(int n, short[] sArray) {
        int n2;
        short[] sArray2 = new short[2000];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = Short.MIN_VALUE;
        }
        sArray2[0] = sArray[0];
        sArray2[1] = sArray[1];
        sArray2[2] = sArray[2];
        sArray2[3] = sArray[3];
        sArray2[4] = sArray[4];
        sArray2[5] = sArray[5];
        sArray2[6] = sArray[6];
        sArray2[7] = sArray[7];
        sArray2[8] = sArray[8];
        if (sArray[30] == 65) {
            sArray2[19] = 65;
            sArray2[20] = 115;
            sArray2[21] = 99;
            sArray2[22] = 101;
            sArray2[23] = 110;
            sArray2[24] = 100;
            sArray2[25] = 105;
            sArray2[26] = 110;
            sArray2[27] = 103;
            sArray2[28] = 32;
        } else if (sArray[31] == 68) {
            sArray2[19] = 68;
            sArray2[20] = 101;
            sArray2[21] = 115;
            sArray2[22] = 99;
            sArray2[23] = 101;
            sArray2[24] = 110;
            sArray2[25] = 100;
            sArray2[26] = 105;
            sArray2[27] = 110;
            sArray2[28] = 103;
        }
        sArray2[29] = sArray[38];
        sArray2[30] = sArray[39];
        sArray2[31] = sArray[40];
        sArray2[32] = sArray[41];
        sArray2[135] = sArray[114];
        sArray2[136] = sArray[115];
        sArray2[137] = sArray[116];
        sArray2[138] = sArray[123];
        sArray2[139] = sArray[124];
        sArray2[140] = sArray[121];
        sArray2[141] = sArray[122];
        sArray2[142] = sArray[117];
        sArray2[143] = sArray[119];
        sArray2[144] = sArray[118];
        sArray2[145] = sArray[100];
        sArray2[146] = sArray[125];
        sArray2[147] = sArray[126];
        sArray2[148] = sArray[127];
        float[] fArray = new float[28];
        float[] fArray2 = new float[28];
        float[] fArray3 = new float[14];
        float[] fArray4 = new float[14];
        for (n2 = 0; n2 < 28; ++n2) {
            fArray[27 - n2] = sArray[42 + n2] != Short.MIN_VALUE ? (float)sArray[42 + n2] / 10.0f : -32768.0f;
            fArray2[27 - n2] = sArray[128 + n2] != Short.MIN_VALUE ? (float)sArray[128 + n2] / 64.0f : -32768.0f;
        }
        for (n2 = 0; n2 < 14; ++n2) {
            fArray3[n2] = fArray[n2 + 14];
            fArray4[13 - n2] = sArray[547 + n2] != Short.MIN_VALUE ? (float)Math.exp((float)sArray[547 + n2] / 1024.0f) : -32768.0f;
        }
        float[] fArray5 = new float[]{0.016f, 0.038f, 0.076f, 0.136f, 0.224f, 0.345f, 0.506f, 0.713f, 0.975f, 1.297f, 1.687f, 2.152f, 2.7f, 3.339f, 4.077f, 4.92f, 5.877f, 6.956f, 8.165f, 9.511f, 11.0f, 12.6f, 14.4f, 16.4f, 18.5f, 20.9f, 23.4f, 26.1f, 29.1f, 32.2f, 35.6f, 39.2f, 43.1f, 47.1f, 51.5f, 56.1f, 60.9f, 66.1f, 71.5f, 77.2f, 83.2f, 89.5f, 96.1f, 103.0f, 110.2f, 117.7f, 125.6f, 133.8f, 142.3f, 151.2f, 160.4f, 170.0f, 180.0f, 190.3f, 200.9f, 212.0f, 223.4f, 235.2f, 247.4f, 259.9f, 272.9f, 286.2f, 300.0f, 314.1f, 328.6f, 343.6f, 358.9f, 374.7f, 390.8f, 407.4f, 424.4f, 441.8f, 459.7f, 477.9f, 496.6f, 515.7f, 535.2f, 555.1f, 575.5f, 596.3f, 617.5f, 639.1f, 661.1f, 683.6f, 706.5f, 729.8f, 753.6f, 777.7f, 802.3f, 827.3f, 852.7f, 878.6f, 904.8f, 931.5f, 958.5f, 986.0f, 1013.9f, 1042.2f, 1070.9f, 1100.0f};
        float[] fArray6 = new float[]{0.009f, 0.025f, 0.055f, 0.104f, 0.177f, 0.28f, 0.42f, 0.604f, 0.837f, 1.128f, 1.483f, 1.91f, 2.416f, 3.009f, 3.696f, 4.485f, 5.384f, 6.401f, 7.544f, 8.821f, 10.2f, 11.8f, 13.5f, 15.4f, 17.4f, 19.7f, 22.1f, 24.7f, 27.6f, 30.6f, 33.9f, 37.4f, 41.1f, 45.1f, 49.3f, 53.7f, 58.5f, 63.5f, 68.7f, 74.3f, 80.1f, 86.3f, 92.7f, 99.5f, 106.5f, 113.9f, 121.6f, 129.7f, 138.0f, 146.7f, 155.8f, 165.2f, 175.0f, 185.1f, 195.6f, 206.4f, 217.6f, 229.2f, 241.2f, 253.6f, 266.3f, 279.5f, 293.0f, 307.0f, 321.3f, 336.0f, 351.2f, 366.7f, 382.7f, 399.1f, 415.9f, 433.1f, 450.7f, 468.7f, 487.2f, 506.1f, 525.4f, 545.1f, 565.2f, 585.8f, 606.8f, 628.2f, 650.1f, 672.3f, 695.0f, 718.1f, 741.6f, 765.6f, 790.0f, 814.8f, 840.0f, 865.6f, 891.6f, 918.1f, 944.9f, 972.2f, 1000.0f, 1028.0f, 1056.5f, 1085.3f};
        for (int i = 0; i < 100; ++i) {
            float f;
            float f2 = EdgeUtils.interpolateTemperature(fArray5[i], fArray2, fArray);
            if (f2 != -32768.0f) {
                sArray2[149 + i] = (short)(f2 * 64.0f);
            }
            if ((f = EdgeUtils.interpolateTemperature(fArray6[i], fArray4, fArray3)) == -32768.0f) continue;
            sArray2[355 + i] = (short)(Math.log(f) * 1024.0);
        }
        sArray2[349] = sArray[184];
        sArray2[350] = sArray[185];
        sArray2[351] = sArray[186];
        sArray2[352] = sArray[187];
        sArray2[353] = sArray[188];
        sArray2[354] = sArray[546];
        sArray2[555] = sArray[575];
        sArray2[556] = sArray[576];
        sArray2[558] = sArray[770];
        sArray2[560] = sArray[828];
        sArray2[561] = sArray[492];
        sArray2[562] = sArray[493];
        sArray2[1168] = sArray[830];
        sArray2[1169] = sArray[832];
        sArray2[1170] = sArray[833];
        sArray2[1171] = sArray[835];
        sArray2[1172] = sArray[836];
        sArray2[1173] = sArray[838];
        sArray2[1174] = sArray[839];
        return sArray2;
    }
}

