/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AirsVersion1Record
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public AirsVersion1Record(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public AirsVersion1Record(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public AirsVersion1Record() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[2000];
        for (int i = 0; i < 2000; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        String string = " (" + this.buffer[125] + "/" + this.buffer[126] + "/" + this.buffer[127] + ")";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "";
        return string;
    }

    public int getTerrain() {
        int n = Short.MIN_VALUE;
        return n;
    }

    public boolean hasSeaNonseaValue() {
        return false;
    }

    public int getSeaNonseaValue() {
        return Short.MIN_VALUE;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        if (this.buffer[126] != 0) {
            bl = false;
        }
        return bl;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return Short.MIN_VALUE;
    }

    public int getCloudFlagForNarcs() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return false;
    }

    public int getDayNightFlag() {
        return Short.MIN_VALUE;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        if (this.buffer[115] != Short.MIN_VALUE) {
            f = (float)this.buffer[115] / 10.0f;
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription(), "  MW-Only"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 22};
        return nArray;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[2];
        if (!this.containsData()) {
            for (int i = 0; i < 2; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (n = 0; n < fArray2.length; ++n) {
                if (fArray[n] == -999.99f || fArray2[n] == -999.99f) continue;
                profileArray[0].addItem(fArray[n], fArray2[n]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            string = "  MW-only";
            profileArray[1] = new Profile(1, string, 0, Color.black, 1, 0);
            fArray2 = this.getMWOnlyTemps();
            for (n = 0; n < fArray2.length; ++n) {
                if (fArray[n] == -999.99f || fArray2[n] == -999.99f) continue;
                profileArray[1].addItem(fArray[n], fArray2[n]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[2];
        profileArray[0] = null;
        if (!this.containsData()) {
            for (int i = 0; i < 2; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || fArray[i + 14] == -999.99f || !(fArray[i + 14] >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f2 = EdgeUtils.convertToDewPoint(fArray2[i], fArray[i + 14]);
                profileArray[0].addItem(fArray[i + 14], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            profileArray[1] = new Profile(0, "  mw-only", 0, Color.black, 1, 1);
            profileArray[1].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[2];
        if (!this.containsData()) {
            for (int i = 0; i < 2; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getWaterVaporPressures();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || fArray2[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "  mw-only", 0, Color.black, 1, 1);
            profileArray[1].trimProfile();
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            if (n >= 3) {
                f2 = -32768.0f;
            } else if (n == 0) {
                float[] fArray = this.getPressureLevels();
                float[] fArray2 = this.getRetrievedTemps();
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray = this.getWaterVaporPressures();
                float[] fArray3 = this.getRetrievedWaterVapor();
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && n == 1) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4), new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getRetrievedDewpoints();
        float[] fArray4 = this.getWaterVaporPressures();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray4);
        vectorArray[0].add(fArray3);
        fArray2 = this.getMWOnlyTemps();
        fArray3 = new float[fArray.length];
        Arrays.fill(fArray3, -999.99f);
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray3);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[28];
        float f = (float)this.buffer[122] / 10.0f;
        for (int i = 0; i < 28; ++i) {
            if (this.buffer[i + 42] == Short.MIN_VALUE) {
                fArray[27 - i] = -999.99f;
                continue;
            }
            fArray[27 - i] = (float)this.buffer[i + 42] / 10.0f;
            if (!(fArray[27 - i] > f)) continue;
            fArray[27 - i] = -999.99f;
        }
        return fArray;
    }

    private float getPressureLevelValue(int n) {
        float f;
        float f2 = -999.99f;
        int n2 = 28 - n;
        if (this.buffer[n2 + 42] != Short.MIN_VALUE) {
            f2 = (float)this.buffer[n2 + 42] / 10.0f;
        }
        if (f2 > (f = (float)this.buffer[122] / 10.0f)) {
            f2 = -999.99f;
        }
        return f2;
    }

    private float[] getWaterVaporPressures() {
        float[] fArray = new float[]{62.5f, 88.8f, 131.3f, 181.3f, 231.3f, 281.3f, 362.5f, 462.5f, 562.5f, 662.5f, 793.8f, 896.9f, 971.8f, 1062.5f};
        float f = (float)this.buffer[122] / 10.0f;
        for (int i = 0; i < 14; ++i) {
            if (!(fArray[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[28];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 28; ++i) {
            fArray[27 - i] = this.buffer[i + 128] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 128] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getMWOnlyTemps() {
        float[] fArray = new float[28];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 28; ++i) {
            fArray[27 - i] = this.buffer[i + 494] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 494] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[14];
        float[] fArray2 = this.getWaterVaporPressures();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 14; ++i) {
            fArray[13 - i] = this.buffer[i + 547] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 547] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[13 - i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[14];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getWaterVaporPressures();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 14; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector getTemperatureData() {
        Vector<Profile> vector = new Vector<Profile>();
        if (this.containsData()) {
            Profile[] profileArray = this.getTemperatureProfiles();
            if (profileArray[0] != null) {
                profileArray[0].setLabel("Retrieval");
            }
            for (int i = 0; i < profileArray.length; ++i) {
                if (profileArray[i] == null) continue;
                vector.add(profileArray[i]);
            }
        }
        return vector;
    }

    public Vector getDewpointTemperatureData() {
        Vector<Profile> vector = new Vector<Profile>();
        if (this.containsData()) {
            Profile[] profileArray = this.getDewpointProfiles();
            if (profileArray[0] != null) {
                profileArray[0].setLabel("Retrieval");
            }
            for (int i = 0; i < profileArray.length; ++i) {
                if (profileArray[i] == null) continue;
                vector.add(profileArray[i]);
            }
        }
        return vector;
    }

    public Vector getWaterVaporData() {
        Vector<Profile> vector = new Vector<Profile>();
        if (this.containsData()) {
            Profile[] profileArray = this.getWaterVaporProfiles();
            if (profileArray[0] != null) {
                profileArray[0].setLabel("Retrieval");
            }
            for (int i = 0; i < profileArray.length; ++i) {
                if (profileArray[i] == null) continue;
                vector.add(profileArray[i]);
            }
        }
        return vector;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLayerDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Flag");
        if (this.buffer[9] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[9]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Altitude At Nadir");
        if (this.buffer[14] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[14] / 10.0f) + " km");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Altitude Roll Angle At Nadir");
        if (this.buffer[15] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[15] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Altitude Pitch Angle At Nadir");
        if (this.buffer[16] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[16] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Altitude Yaw Angle At Nadir");
        if (this.buffer[17] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[17] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Geolocation QA Flag");
        if (this.buffer[18] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[18]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Glint Geolocation QA Flag");
        if (this.buffer[19] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[19]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Moon Geolocation QA Flag");
        if (this.buffer[20] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[20]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Footprint Geolocation QA Flag");
        if (this.buffer[21] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[21]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Zenith Geolocation QA Flag");
        if (this.buffer[22] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[22]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Demgeoga Geolocation QA Flag");
        if (this.buffer[23] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[23]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Nadir TAI Year");
        if (this.buffer[24] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[24]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Nadir TAI Month/Day");
        if (this.buffer[25] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[25]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Nadir TAI Hour");
        if (this.buffer[26] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[26]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Nadir TAI Minute/Second");
        if (this.buffer[27] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[27]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Geodetic Latitude");
        if (this.buffer[28] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[28] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Geodetic Longitude");
        if (this.buffer[29] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[29] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Orbital Node");
        if (this.buffer[30] == 65) {
            vector4.add("Ascending");
        } else if (this.buffer[30] == 68) {
            vector4.add("Descending");
        } else if (this.buffer[30] == 69) {
            vector4.add("E");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Spacecraft Zenith Angle");
        if (this.buffer[31] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[31] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Spacecraft Azimuth Angle");
        if (this.buffer[32] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[32] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Zenith Angle");
        if (this.buffer[33] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[33] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Azimuth Angle");
        if (this.buffer[34] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[34] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Geodetic Latitude");
        if (this.buffer[35] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[35] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Geodetic Longitude");
        if (this.buffer[36] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[36] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Footprint to Sun Glint Distance");
        if (this.buffer[37] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[37]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Mean Topography");
        if (this.buffer[38] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)this.buffer[38] / 1000.0f) + " meters");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Topography Error Estimate");
        if (this.buffer[39] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)this.buffer[39] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Land Fraction");
        if (this.buffer[40] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)this.buffer[40] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Land Fraction Error Estimate");
        if (this.buffer[41] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)this.buffer[41] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure Guess QA Flag");
        if (this.buffer[114] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[114]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure Guess QA Flag");
        if (this.buffer[114] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[114]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure 1st Guess");
        if (this.buffer[115] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[115] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Max Pressure at which Temp QA=0");
        if (this.buffer[121] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[121] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Max Pressure at which Temp QA=0/1");
        if (this.buffer[122] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[122] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("QA Flag For Temp Above");
        if (this.buffer[125] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[125]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("QA Flag For Temp Above/Below");
        if (this.buffer[126] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[126]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("QA Flag For Temp Below");
        if (this.buffer[127] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[127]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLayerDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Layer Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Pressure");
        vector2.add("Atmospheric\nTemperature");
        vector2.add("Temperature\nError Estimate");
        vector2.add("MW-Only\nTemperature");
        vector2.add("Water Vapor\nMixing Ratio");
        vector2.add("WVMR\nError Est");
        vector2.add("Satur Mixing Ratio\nEquilibrium");
        vector2.add("Satur Mixing Ratio\nLiquid");
        vector2.add("Ozone\nMixing Ratio");
        vector2.add("Ozone\nError Est");
        vector2.add("Geopotential\nHeights");
        vector2.add("Geop Height\nMW-Only");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 27; i >= 0; --i) {
            serializable = new Vector<String>(12);
            if (this.buffer[42 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[42 + i] / 10.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[128 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[128 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[156 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[156 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[494 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[494 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i < 14 && this.buffer[547 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[547 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i < 14 && this.buffer[561 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[561 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i < 14 && this.buffer[577 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[577 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i < 14 && this.buffer[591 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[591 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[624 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[624 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[652 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[652 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[772 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + this.buffer[772 + i]);
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[800 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + this.buffer[880 + i]);
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }
}

