/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AtovsRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;

    public AtovsRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public AtovsRecord(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public AtovsRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[750];
        for (int i = 0; i < 750; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    private boolean usesNewPressureLevels() {
        boolean bl = false;
        if (this.buffer[11] == 1) {
            bl = true;
        }
        return bl;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        return "";
    }

    public float getLatitude() {
        return (float)this.buffer[23] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[24] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[18];
        int n = this.buffer[25] % 100;
        int n2 = this.buffer[26] / 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[18] * 10000 + this.buffer[25] % 100 * 100 + this.buffer[26] / 100;
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[26] % 100;
        int n2 = this.buffer[27] / 100;
        int n3 = this.buffer[27] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[26] % 100 * 10000 + this.buffer[27];
        return n;
    }

    public String getTerrainString() {
        String string = this.buffer[29] == 0 ? "Sea" : (this.buffer[29] == 1 ? "Land" : (this.buffer[29] == 2 ? "Coast" : (this.buffer[29] == 10 ? "Ice" : (this.buffer[29] == 11 ? "Snow" : "(invalid value)"))));
        return string;
    }

    public int getTerrain() {
        return this.buffer[29];
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = 0;
        if (this.getTerrain() != 0) {
            n = 1;
        }
        return n;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        if (this.buffer[40] >= 2) {
            bl = false;
        }
        return bl;
    }

    public boolean hasCloudFlag() {
        return true;
    }

    public int getCloudFlag() {
        int n = Short.MIN_VALUE;
        if (this.buffer[440] != Short.MIN_VALUE) {
            float f = (float)this.buffer[440] / 1.0f;
            if (f <= 0.0f) {
                n = 0;
            } else if (f > 0.0f && f <= 20.0f) {
                n = 1;
            } else if (f > 20.0f) {
                n = 2;
            }
        }
        return n;
    }

    public int getCloudFlagForNarcs() {
        int n = Short.MIN_VALUE;
        if (this.buffer[41] == 0) {
            n = 0;
        } else if (this.buffer[41] == 32) {
            n = 1;
        }
        return n;
    }

    public boolean hasDayNightFlag() {
        return true;
    }

    public int getDayNightFlag() {
        int n = Short.MIN_VALUE;
        n = this.buffer[30] == 0 ? 0 : 1;
        return n;
    }

    public String getDayNight() {
        String string = this.buffer[30] == 0 ? "Night" : (this.buffer[30] == 1 ? "Day" : "(invalid value)");
        return string;
    }

    private int getSurfaceLevel() {
        int n = this.buffer[324];
        n = Math.min(n, 40);
        return n;
    }

    public float getSurfacePressure() {
        float f = -32768.0f;
        int n = this.getSurfaceLevel();
        if (n != Short.MIN_VALUE) {
            PressureLevels pressureLevels = new PressureLevels();
            f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsTempPressure(n) : pressureLevels.getPressure(n);
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        float f = this.getSurfacePressure();
        if (f <= 0.0f) {
            f = -32768.0f;
        }
        vector.add(new Float(f));
        float f2 = -32768.0f;
        if (f != -32768.0f && (f2 = this.getRetrievedTempValue(this.getSurfaceLevel())) <= 0.0f) {
            f2 = -32768.0f;
        }
        vector.add(new Float(f2));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public String getForecastDateString() {
        String string = "";
        if (this.buffer[19] != Short.MIN_VALUE && this.buffer[20] != 32768) {
            int n = this.buffer[19] % 100;
            int n2 = this.buffer[20] / 100;
            string = "" + n + "/";
            if (n2 < 10) {
                string = string + "0";
            }
            string = string + n2;
        }
        return string;
    }

    public String getForecastTimeString() {
        String string = "";
        short s = this.buffer[436];
        string = s != Short.MIN_VALUE ? "" + s + " hr@" : "? hr @ ";
        if (this.buffer[20] != 32768) {
            int n = this.buffer[20] % 100;
            string = string + n + "Z";
        }
        return string;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription(), "1st Guess", "GFS Fcst"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 1, 2};
        return nArray;
    }

    private float[] getPressureLevels() {
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getNewAtovsTempPressures();
        if (!this.usesNewPressureLevels()) {
            fArray = pressureLevels.getPressures();
        }
        return fArray;
    }

    private float[] getMoisturePressureLevels() {
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getNewAtovsMoisturePressures();
        if (!this.usesNewPressureLevels()) {
            fArray = pressureLevels.getWVPressures();
        }
        return fArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[3];
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f;
            int n;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = (float)this.buffer[430] / 10.0f;
            float f3 = this.getSurfacePressure();
            String string = this.getGroupDescription();
            String string2 = this.getForecastDateString() + "  " + this.getForecastTimeString();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getRetrievedTemps();
            for (n = 0; n < 42; ++n) {
                if (fArray[n] == -999.99f) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsTempPressure(n + 1) : pressureLevels.getPressure(n + 1);
                profileArray[0].addItem(f, fArray[n]);
            }
            profileArray[0].setSurfacePressure(f3);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 0);
            fArray = this.getRetrievedGuessTemps();
            for (n = 0; n < 42; ++n) {
                if (!(fArray[n] > 0.0f)) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsTempPressure(n + 1) : pressureLevels.getPressure(n + 1);
                profileArray[1].addItem(f, fArray[n]);
            }
            profileArray[1].setSurfacePressure(f3);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
            String string3 = "   GFS Fcst";
            profileArray[2] = new Profile(0, string3, 0, Color.black, 1, 0);
            fArray = this.getGFSTemps();
            for (int i = 0; i < 24; ++i) {
                f = pressureLevels.getGFSTempPressure(i + 1);
                if (!(fArray[i] > 0.0f) || !(f <= f2)) continue;
                profileArray[2].addItem(f, fArray[i]);
            }
            profileArray[2].setSurfacePressure(f2);
            profileArray[2].trimProfile();
            if (profileArray[2].getNumberOfPoints() == 0) {
                profileArray[2] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[3];
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f;
            int n;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = (float)this.buffer[430] / 10.0f;
            float f3 = this.getSurfacePressure();
            String string = this.getGroupDescription();
            String string2 = this.getForecastDateString() + "  " + this.getForecastTimeString();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedDewpoints();
            for (n = 0; n < 19; ++n) {
                if (fArray[n] == -999.99f) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(n + 1) : pressureLevels.getWVPressure(n + 1);
                profileArray[0].addItem(f, fArray[n]);
            }
            profileArray[0].setSurfacePressure(f3);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 1);
            fArray = this.getRetrievedGuessDewpoints();
            for (n = 0; n < 19; ++n) {
                if (!(fArray[n] > -999.99f)) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(n + 1) : pressureLevels.getWVPressure(n + 1);
                profileArray[1].addItem(f, fArray[n]);
            }
            profileArray[1].setSurfacePressure(f3);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
            String string3 = "   GFS Fcst";
            profileArray[2] = new Profile(0, string3, 0, Color.black, 1, 1);
            float[] fArray2 = this.getGFSDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                f = pressureLevels.getGFSWaterVaporPressure(i + 1);
                if (!(fArray2[i] > 0.0f)) continue;
                profileArray[2].addItem(f, fArray2[i]);
            }
            profileArray[2].setSurfacePressure(f2);
            profileArray[2].trimProfile();
            if (profileArray[2].getNumberOfPoints() == 0) {
                profileArray[2] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[3];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            float f;
            int n;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            for (n = 0; n < 19; ++n) {
                if (fArray[n] == -999.99f) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(n + 1) : pressureLevels.getWVPressure(n + 1);
                profileArray[0].addItem(f, fArray[n]);
            }
            profileArray[0].setSurfacePressure(f2);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 1);
            fArray = this.getRetrievedGuessWVapors();
            for (n = 0; n < 19; ++n) {
                if (!(fArray[n] > -999.99f)) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(n + 1) : pressureLevels.getWVPressure(n + 1);
                profileArray[1].addItem(pressureLevels.getPressure(n + 24), fArray[n]);
            }
            profileArray[1].setSurfacePressure(f2);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            if (n >= 9) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 3 || n == 6) {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getPressures();
                if (this.usesNewPressureLevels()) {
                    fArray = pressureLevels.getNewAtovsTempPressures();
                }
                if (n == 6) {
                    fArray = pressureLevels.getGFSTempPressures();
                }
                float[] fArray2 = this.getRetrievedTemps();
                if (n == 3) {
                    fArray2 = this.getRetrievedGuessTemps();
                } else if (n == 6) {
                    fArray2 = this.getGFSTemps();
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getWVPressures();
                if (this.usesNewPressureLevels()) {
                    fArray = pressureLevels.getNewAtovsMoisturePressures();
                }
                if (n == 7 || n == 8) {
                    fArray = pressureLevels.getGFSWaterVaporPressures();
                }
                float[] fArray3 = this.getRetrievedWaterVapor();
                if (n == 4 || n == 5) {
                    fArray3 = this.getRetrievedGuessWVapors();
                } else if (n == 7 || n == 8) {
                    fArray3 = this.getGFSWaterVapor();
                }
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && (n == 1 || n == 4 || n == 7)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        int n2;
        float f;
        int n3;
        Vector[] vectorArray = new Vector[]{new Vector(4), new Vector(4), new Vector(4)};
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getPressures();
        float[] fArray2 = pressureLevels.getWVPressures();
        float[] fArray3 = pressureLevels.getGFSTempPressures();
        float[] fArray4 = pressureLevels.getGFSWaterVaporPressures();
        if (this.usesNewPressureLevels()) {
            fArray = pressureLevels.getNewAtovsTempPressures();
            fArray2 = pressureLevels.getNewAtovsMoisturePressures();
        }
        if ((n3 = this.getSurfaceLevel()) > 0) {
            f = pressureLevels.getPressure(this.getSurfaceLevel());
            if (this.usesNewPressureLevels()) {
                f = pressureLevels.getNewAtovsTempPressure(this.getSurfaceLevel());
            }
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] > f)) continue;
                fArray[n2] = -999.99f;
            }
            for (n2 = 0; n2 < fArray2.length; ++n2) {
                if (!(fArray2[n2] > f)) continue;
                fArray2[n2] = -999.99f;
            }
        }
        f = (float)this.buffer[430] / 10.0f;
        for (n2 = 0; n2 < fArray3.length; ++n2) {
            if (!(fArray3[n2] > f)) continue;
            fArray3[n2] = -999.99f;
        }
        for (n2 = 0; n2 < fArray4.length; ++n2) {
            if (!(fArray4[n2] > f)) continue;
            fArray4[n2] = -999.99f;
        }
        float[] fArray5 = this.getRetrievedTemps();
        float[] fArray6 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray5);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray6);
        fArray5 = this.getRetrievedGuessTemps();
        fArray6 = this.getRetrievedGuessDewpoints();
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray5);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray6);
        fArray5 = this.getGFSTemps();
        fArray6 = this.getGFSDewpoints();
        vectorArray[2].add(fArray3);
        vectorArray[2].add(fArray5);
        vectorArray[2].add(fArray4);
        vectorArray[2].add(fArray6);
        return vectorArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[42];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.buffer[i + 44] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 44] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float getRetrievedTempValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 44] != Short.MIN_VALUE) {
            f = (float)this.buffer[n + 44] / 64.0f;
        }
        return f;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.buffer[i + 238] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 238] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        fArray[17] = -999.99f;
        fArray[18] = -999.99f;
        return fArray;
    }

    private float getRetrievedWVapValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 238] != Short.MIN_VALUE) {
            f = (float)Math.exp((double)this.buffer[n + 238] / 1024.0);
        }
        return f;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getGFSTemps() {
        float[] fArray = new float[24];
        for (int i = 0; i < 24; ++i) {
            fArray[i] = this.buffer[i + 126] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 126] / 64.0f;
        }
        return fArray;
    }

    private float[] getGFSWaterVapor() {
        float[] fArray = new float[19];
        for (int i = 0; i < 17; ++i) {
            fArray[i] = this.buffer[i + 471] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 471] / 1024.0);
        }
        fArray[17] = -999.99f;
        fArray[18] = -999.99f;
        return fArray;
    }

    private float[] getGFSDewpoints() {
        float[] fArray = new float[17];
        float[] fArray2 = this.getGFSWaterVapor();
        PressureLevels pressureLevels = new PressureLevels();
        for (int i = 0; i < 17; ++i) {
            if (fArray2[i] == -999.99f) {
                fArray[i] = -999.99f;
                continue;
            }
            float f = pressureLevels.getGFSWaterVaporPressure(i + 1);
            fArray[i] = EdgeUtils.convertToDewPoint(fArray2[i], f);
        }
        return fArray;
    }

    private float[] getRetrievedGuessTemps() {
        float[] fArray = new float[42];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.buffer[i + 330] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 330] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedGuessWVapors() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.buffer[i + 372] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 372] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        fArray[17] = -999.99f;
        fArray[18] = -999.99f;
        return fArray;
    }

    private float getRetrievedGuessWVapValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 372] != Short.MIN_VALUE) {
            f = (float)Math.exp((double)this.buffer[n + 372] / 1024.0);
        }
        return f;
    }

    private float[] getRetrievedGuessDewpoints() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getRetrievedGuessWVapors();
        float[] fArray3 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    public float getTPW() {
        return EdgeUtils.twoDigits((float)this.buffer[259] / 128.0f);
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        float f = (float)this.buffer[439] / 1.0f;
        if (f == 1250.0f || f == -777.0f) {
            f = -32768.0f;
        }
        vector.add(new Float(f));
        float f2 = -32768.0f;
        if (this.buffer[438] != Short.MIN_VALUE) {
            f2 = (float)this.buffer[438] / 64.0f;
        }
        if (f2 == 0.0f || f2 == -777.0f) {
            f2 = -32768.0f;
        }
        vector.add(new Float(f2));
        float f3 = (float)this.buffer[440] / 1.0f;
        if (f3 == 0.0f || f3 == -777.0f) {
            f3 = -32768.0f;
        }
        vector.add(new Float(f3));
        boolean bl = false;
        if (this.buffer[445] > 0) {
            bl = true;
        }
        vector.add(new Boolean(bl));
        return vector;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
            Vector<String> vector3 = new Vector<String>(5);
            vector3.add("   GFS Forecast");
            vector3.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector3.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector3.add(this.getForecastDateString());
            vector3.add(this.getForecastTimeString());
            vector.add(vector3);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLevelDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
            Vector vector4 = this.buildBrightnessTemperatureTable();
            for (int i = 0; i < vector4.size(); ++i) {
                vector.add((JLabel)vector4.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        int n;
        int n2;
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Satellite Number");
        if (this.buffer[1] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame");
        if (this.buffer[2] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Grid Point");
        if (this.buffer[22] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[22]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Beginning/Ending Orbit");
        if (this.buffer[3] != Short.MIN_VALUE && this.buffer[4] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[3] + " / " + this.buffer[4]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Date/Time");
        vector4.add(this.getDateString() + "   " + this.getTimeString());
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Latitude/Longitude");
        if (this.buffer[23] != Short.MIN_VALUE && this.buffer[24] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[23] / 128.0f) + " / " + EdgeUtils.twoDigits((float)this.buffer[24] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Forecast Date/Time");
        if (this.buffer[19] != Short.MIN_VALUE && this.buffer[20] != Short.MIN_VALUE) {
            n2 = 2000 + this.buffer[19] / 100;
            vector4.add(this.getForecastDateString() + "/" + n2 + "  " + this.getForecastTimeString());
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Elevation");
        if (this.buffer[10] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[10] + " m");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Spot Confidence");
        if (this.buffer[21] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[21]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Precip Flag");
        if (this.buffer[28] == 0) {
            vector4.add("No Precip");
        } else if (this.buffer[28] == 1) {
            vector4.add("Precipitating");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Terrain Type");
        vector4.add(this.getTerrainString());
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Day/Night Flag");
        if (this.buffer[30] == 0) {
            vector4.add("Night");
        } else if (this.buffer[30] == 1) {
            vector4.add("Day");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Test/Production Version Number");
        if (this.buffer[31] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[31]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Processing Flag");
        if (this.buffer[32] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[32]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Geographic Bin Number");
        if (this.buffer[35] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[35]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Zenith Angle");
        if (this.buffer[33] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[33] / 128.0f) + " deg");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Satellite Zenith Angle");
        if (this.buffer[34] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[34] / 128.0f) + " deg");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Azimuth Angle");
        if (this.buffer[36] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[36] / 128.0f) + " deg");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS Spot Number");
        if (this.buffer[37] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[37]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Orbital Node");
        if (this.buffer[38] == 0) {
            vector4.add("Ascending");
        } else if (this.buffer[38] == 1) {
            vector4.add("Descending");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Superadiabatic Flag");
        if (this.buffer[39] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[39]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Observation Quality");
        if (this.buffer[40] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[40]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AMSU-A BT Sigma Flag");
        if (this.buffer[5] == 0) {
            vector4.add("Pass");
        } else if (this.buffer[5] == 1) {
            vector4.add("Fail");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MHS BT Sigma Flag");
        if (this.buffer[6] == 0) {
            vector4.add("Pass");
        } else if (this.buffer[6] == 1) {
            vector4.add("Fail");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Flag");
        if (this.buffer[41] == 0) {
            vector4.add("Clear");
        } else if (this.buffer[41] == 32) {
            vector4.add("Cloudy");
        } else if (this.buffer[41] == 48) {
            vector4.add("No HIRS");
        } else if (this.buffer[41] == 16) {
            vector4.add("N-Star");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Filter Test Value");
        if (this.buffer[42] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[42]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Channel Combination Flag");
        if (this.buffer[43] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[43]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tropopause Temperature");
        if (this.buffer[257] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[257] / 64.0f) + " deg K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tropopause Pressure");
        if (this.buffer[258] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[258] / 1.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Total Precip Water");
        if (this.buffer[259] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[259] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        for (n2 = 0; n2 < 15; ++n2) {
            vector4 = new Vector(2);
            if (n2 == 0) {
                vector4.add("Layer Precip Water");
            } else {
                vector4.add(" ");
            }
            if (this.buffer[260 + n2] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[260 + n2] / 128.0f));
            } else {
                vector4.add("not available");
            }
            vector3.add(vector4);
        }
        for (n2 = 0; n2 < 15; ++n2) {
            vector4 = new Vector(2);
            if (n2 == 0) {
                vector4.add("Layer Mean Virt Temp");
            } else {
                vector4.add(" ");
            }
            if (this.buffer[275 + n2] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[275 + n2] / 64.0f));
            } else {
                vector4.add("not available");
            }
            vector3.add(vector4);
        }
        for (n2 = 0; n2 < 20; ++n2) {
            vector4 = new Vector(2);
            if (n2 == 0) {
                vector4.add("Layer Thicknesses");
            } else {
                vector4.add(" ");
            }
            if (this.buffer[290 + n2] != Short.MIN_VALUE) {
                vector4.add("" + (float)this.buffer[290 + n2] / 1.0f);
            } else {
                vector4.add("not available");
            }
            vector3.add(vector4);
        }
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sea Surface Temperature");
        if (this.buffer[322] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[322] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Derived Skin Temp");
        if (this.buffer[323] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[323] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Model Level");
        String string = "not available";
        if (this.buffer[324] != Short.MIN_VALUE) {
            string = "" + this.buffer[324];
            PressureLevels pressureLevels = new PressureLevels();
            string = this.usesNewPressureLevels() ? string + "  (" + pressureLevels.getNewAtovsTempPressure(this.buffer[324]) + " mb)" : string + "  (" + pressureLevels.getPressure(this.buffer[324]) + " mb)";
        }
        vector4.add(string);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieved Surface Temp");
        if (this.buffer[325] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[325] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("WVapor Corr HIRS Chan 8");
        if (this.buffer[326] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[326] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surf Temp Est HIRS Chan 8");
        if (this.buffer[327] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[327] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surf Temp Est HIRS Chan 18");
        if (this.buffer[328] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[328] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surf Temp Est HIRS Chan 19");
        if (this.buffer[329] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[329] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("NCEP Fcst Potential Temp");
        if (this.buffer[426] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[426] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("NCEP Fcst Rel Humidity");
        if (this.buffer[427] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[427] / 256.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("NCEP Fcst Surface Temp");
        if (this.buffer[428] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[428] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Adj NCEP Fcst Surf Pressure");
        if (this.buffer[429] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[429] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Forecast Pressure");
        if (this.buffer[430] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[430] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Pot Temp time - Fcst Time");
        if (this.buffer[431] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[431] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Time Diff (Sat - Fcst)");
        if (this.buffer[435] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[435]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Stability Fcst Increment");
        if (this.buffer[436] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[436]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Stability Departure");
        if (this.buffer[432] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[432] / 512.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Lower Departure");
        if (this.buffer[433] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[433] / 512.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Upper Departure");
        if (this.buffer[434] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[434] / 512.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Liquid Water");
        if (this.buffer[437] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[437]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Temperature");
        if (this.buffer[438] != Short.MIN_VALUE) {
            float f = (float)this.buffer[438] / 64.0f;
            if (f == 0.0f) {
                vector4.add("Clear");
            } else if (f == -777.0f) {
                vector4.add("Missing");
            } else {
                vector4.add("" + EdgeUtils.twoDigits(f));
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Pressure");
        if (this.buffer[439] != Short.MIN_VALUE) {
            if ((float)this.buffer[439] == 1250.0f) {
                vector4.add("Clear");
            } else if ((float)this.buffer[439] == -777.0f) {
                vector4.add("Missing");
            } else {
                vector4.add("" + this.buffer[439]);
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Amount");
        if (this.buffer[440] != Short.MIN_VALUE) {
            float f = (float)this.buffer[440] / 100.0f;
            if (f == 0.0f) {
                vector4.add("Clear");
            } else if (f == -777.0f) {
                vector4.add("Missing");
            } else {
                vector4.add("" + EdgeUtils.twoDigits(f));
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Aerosol Amount");
        if (this.buffer[445] != Short.MIN_VALUE) {
            float f = (float)this.buffer[445] / 100.0f;
            if (f == -777.0f) {
                vector4.add("Missing");
            } else {
                vector4.add("" + EdgeUtils.twoDigits(f));
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Total Ozone");
        if (this.buffer[441] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[441]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("TPW (300mb to 500mb)");
        if (this.buffer[442] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[442] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("TPW (500mb to 700mb)");
        if (this.buffer[443] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[443] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("TPW (700mb to 1000mb)");
        if (this.buffer[444] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[444] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Polar Redundancy Flag");
        if (this.buffer[446] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[446]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Outgoing Longwave Radiation");
        if (this.buffer[447] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[447] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Layer Cooling Rate (10mb to 240mb)");
        if (this.buffer[448] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[448] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Layer Cooling Rate (240mb to 500mb)");
        if (this.buffer[449] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[449] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Layer Cooling Rate (500mb to 700mb)");
        if (this.buffer[450] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[450] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Layer Cooling Rate (700mb to 1000mb)");
        if (this.buffer[451] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[451] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Comparison Flag");
        if (this.buffer[452] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[452]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Library Search Closeness (pho)");
        if (this.buffer[453] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[453]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Superadiabatic Level");
        if (this.buffer[454] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[454]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS/AMSU-A Gross Temp Flag");
        if (this.buffer[455] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[455]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Channel Avail Flags (HIRS 1-16)");
        if (this.buffer[456] != Short.MIN_VALUE) {
            String string2 = Integer.toBinaryString(this.buffer[456]);
            for (n = string2.length(); n < 32; ++n) {
                string2 = "0" + string2;
            }
            vector4.add(string2.substring(16));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Chan Avail Flags (H17-20, A1-12)");
        if (this.buffer[457] != Short.MIN_VALUE) {
            String string3 = Integer.toBinaryString(this.buffer[457]);
            for (n = string3.length(); n < 32; ++n) {
                string3 = "0" + string3;
            }
            vector4.add(string3.substring(16));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Chan Avail Flags (A13-15, B1-5)");
        if (this.buffer[458] != Short.MIN_VALUE) {
            String string4 = Integer.toBinaryString(this.buffer[458]);
            for (n = string4.length(); n < 32; ++n) {
                string4 = "0" + string4;
            }
            vector4.add(string4.substring(16));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Collocated AMSU-B Spot Number");
        if (this.buffer[459] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[459]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Ozone Quality Flag");
        if (this.buffer[470] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[470]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLevelDataTable() {
        Serializable serializable;
        int n;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Level Data</bold></font></html>"));
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = new float[]{10.0f, 20.0f, 30.0f, 50.0f, 70.0f, 100.0f, 150.0f, 200.0f, 250.0f, 300.0f, 350.0f, 400.0f, 450.0f, 500.0f, 550.0f, 600.0f, 650.0f, 700.0f, 750.0f, 800.0f, 850.0f, 900.0f, 950.0f, 1000.0f};
        Vector<Float> vector2 = new Vector<Float>();
        for (n = 0; n < fArray.length; ++n) {
            vector2.add(new Float(fArray[n]));
        }
        for (n = 0; n < fArray2.length; ++n) {
            Float f = new Float(fArray2[n]);
            if (vector2.contains(f)) continue;
            vector2.add(f);
        }
        float[] fArray3 = new float[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            fArray3[i] = ((Float)vector2.elementAt(i)).floatValue();
        }
        Arrays.sort(fArray3);
        Vector<String> vector3 = new Vector<String>();
        vector3.add("Pressure");
        vector3.add("Retrieved\nTemperature");
        vector3.add("First Guess\nTemperature");
        vector3.add("GFS Fcst\nTemperature");
        vector3.add("Water Vapor\nMixing Ratio");
        vector3.add("First Guess\nWVMR");
        vector3.add("GFS Fcst\nWVMR");
        Vector<Serializable> vector4 = new Vector<Serializable>();
        for (int i = 0; i < fArray3.length; ++i) {
            int n2;
            serializable = new Vector<String>(7);
            int n3 = Short.MIN_VALUE;
            int n4 = Short.MIN_VALUE;
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (fArray3[i] != fArray[n2]) continue;
                n3 = n2;
            }
            for (n2 = 0; n2 < fArray2.length; ++n2) {
                if (fArray3[i] != fArray2[n2]) continue;
                n4 = n2;
            }
            ((Vector)serializable).add("" + EdgeUtils.oneDigit(fArray3[i]));
            if (n3 != Short.MIN_VALUE && this.buffer[44 + n3] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[44 + n3] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (n3 != Short.MIN_VALUE && this.buffer[330 + n3] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[330 + n3] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (n4 != Short.MIN_VALUE && this.buffer[126 + n4] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[126 + n4] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i >= 23 && n3 != Short.MIN_VALUE && this.buffer[215 + n3] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[215 + n3] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i >= 23 && n3 != Short.MIN_VALUE && this.buffer[349 + n3] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[349 + n3] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (n4 >= 8 && n4 != Short.MIN_VALUE && this.buffer[463 + n4] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[463 + n4] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector4.add(serializable);
        }
        JTable jTable = new JTable(vector4, vector3);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }

    public Vector buildBrightnessTemperatureTable() {
        String[] stringArray;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Brightness Temperatures</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Level");
        vector2.add("Limb Corr\nBTemp");
        vector2.add("Non-Limb Corr\nBTemp");
        vector2.add("First Guess\nBTemp");
        vector2.add("Shrunk\nBTemp");
        String[] stringArray2 = new String[]{"HIRS 1", "HIRS 2", "HIRS 3", "HIRS 4", "HIRS 5", "HIRS 6", "HIRS 7", "HIRS 8", "HIRS 9", "HIRS 10", "HIRS 11", "HIRS 12", "HIRS 13", "HIRS 14", "HIRS 15", "HIRS 16", "HIRS 17", "HIRS 18", "HIRS 19", "HIRS 20"};
        Vector<Object> vector3 = new Vector<Object>();
        for (int i = 0; i < 20; ++i) {
            stringArray = new Vector(5);
            stringArray.add(stringArray2[i]);
            if (this.buffer[i + 86] != Short.MIN_VALUE) {
                stringArray.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 86] / 64.0f));
            } else {
                stringArray.add(" ");
            }
            if (this.buffer[i + 161] != Short.MIN_VALUE) {
                stringArray.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 161] / 64.0f));
            } else {
                stringArray.add(" ");
            }
            if (this.buffer[i + 391] != Short.MIN_VALUE) {
                stringArray.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 391] / 64.0f));
            } else {
                stringArray.add(" ");
            }
            if (this.buffer[i + 500] != Short.MIN_VALUE) {
                stringArray.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 500] / 64.0f));
            } else {
                stringArray.add(" ");
            }
            vector3.add(stringArray);
        }
        Vector<String> vector4 = new Vector<String>(5);
        vector4.add(" ");
        vector4.add(" ");
        vector4.add(" ");
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        stringArray = new String[]{"AMSU-A 1", "AMSU-A 2", "AMSU-A 3", "AMSU-A 4", "AMSU-A 5", "AMSU-A 6", "AMSU-A 7", "AMSU-A 8", "AMSU-A 9", "AMSU-A 10", "AMSU-A 11", "AMSU-A 12", "AMSU-A 13", "AMSU-A 14", "AMSU-A 15"};
        for (int i = 0; i < 15; ++i) {
            vector4 = new Vector(5);
            vector4.add(stringArray[i]);
            if (this.buffer[i + 106] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 106] / 64.0f));
            } else {
                vector4.add(" ");
            }
            if (this.buffer[i + 181] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 181] / 64.0f));
            } else {
                vector4.add(" ");
            }
            if (this.buffer[i + 411] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 411] / 64.0f));
            } else {
                vector4.add(" ");
            }
            if (this.buffer[i + 520] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 520] / 64.0f));
            } else {
                vector4.add(" ");
            }
            vector3.add(vector4);
        }
        vector4 = new Vector(5);
        vector4.add(" ");
        vector4.add(" ");
        vector4.add(" ");
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        String[] stringArray3 = new String[]{"MHS 1", "MHS 2", "MHS 3", "MHS 4", "MHS 5"};
        for (int i = 0; i < 5; ++i) {
            vector4 = new Vector(5);
            vector4.add(stringArray3[i]);
            if (this.buffer[i + 460] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 460] / 64.0f));
            } else {
                vector4.add(" ");
            }
            if (this.buffer[i + 465] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 465] / 64.0f));
            } else {
                vector4.add(" ");
            }
            if (i >= 2 && this.buffer[i + 308] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 308] / 64.0f));
            } else {
                vector4.add(" ");
            }
            if (this.buffer[i + 535] != Short.MIN_VALUE) {
                vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[i + 535] / 64.0f));
            } else {
                vector4.add(" ");
            }
            vector3.add(vector4);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer(multiLineHeaderRenderer);
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }
}

