/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.Vector;
import javax.swing.JPanel;

public class AutoVstatGraph
extends JPanel {
    private VstatStatSet stat_set;
    private int data_type;
    private float[] pressure_levels;
    private float min_pressure;
    private float max_pressure;
    private float minimum_value;
    private float maximum_value;
    private float label_interval;
    private float tick_mark_interval;
    private int[] sample_sizes;
    private String x_axis_label;
    private boolean show_bias;
    private boolean show_stddev;
    private boolean show_rms;
    private int line_thickness;
    private boolean show_data_points;
    private boolean draw_gridlines;
    private int num_profiles;
    private Profile[][] profiles;
    private String[] profile_names;
    private Color[] profile_colors;
    private Vector dash_vector;
    private String font_name = "Dialog";
    private int font_style = 1;
    private int min_font_size = 5;
    private int number_of_labels = 8;
    private int cutoff = -1;
    private int display_cutoff = 10;
    private float cutoff_difference = 0.1f;
    private final int TEMPERATURE = 0;
    private final int WATER_VAPOR = 1;
    private final int VIRTUAL_TEMP = 2;

    public AutoVstatGraph(VstatStatSet vstatStatSet, float f, float f2, int n, float f3, float f4, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, boolean bl5, String[] stringArray, Color[] colorArray) {
        int n3;
        this.stat_set = vstatStatSet;
        this.show_bias = bl;
        this.show_stddev = bl2;
        this.show_rms = bl3;
        this.line_thickness = n2;
        this.show_data_points = bl4;
        this.draw_gridlines = bl5;
        this.profile_names = stringArray;
        this.profile_colors = colorArray;
        this.data_type = 0;
        this.profiles = vstatStatSet.getProfiles(this.data_type);
        this.num_profiles = vstatStatSet.getNumberOfSubgroups(this.data_type);
        for (n3 = 0; n3 < this.num_profiles; ++n3) {
            for (int i = 0; i < 8; ++i) {
                this.profiles[n3][i].setLineColor(colorArray[n3]);
            }
        }
        this.sample_sizes = vstatStatSet.getSampleSizes(this.data_type);
        this.calculateCutoff();
        this.pressure_levels = vstatStatSet.getPressureLevels(this.data_type);
        this.min_pressure = f;
        this.max_pressure = f2;
        if (f == -32768.0f) {
            this.min_pressure = 9999.0f;
            for (n3 = 0; n3 < this.pressure_levels.length; ++n3) {
                if (!(this.pressure_levels[n3] > 0.0f)) continue;
                this.min_pressure = Math.min(this.min_pressure, this.pressure_levels[n3]);
            }
        }
        if (f2 == -32768.0f) {
            this.max_pressure = -9999.0f;
            for (n3 = 0; n3 < this.pressure_levels.length; ++n3) {
                if (!(this.pressure_levels[n3] > 0.0f)) continue;
                this.max_pressure = Math.max(this.max_pressure, this.pressure_levels[n3]);
            }
        }
        if (this.min_pressure > this.max_pressure) {
            float f5 = this.min_pressure;
            this.min_pressure = this.max_pressure;
            this.max_pressure = f5;
        }
        float f6 = vstatStatSet.getDefaultMinimumValue(this.data_type);
        float f7 = vstatStatSet.getDefaultMaximumValue(this.data_type);
        this.getDataMinMax(n, f3, f4, f6, f7);
        float f8 = this.maximum_value - this.minimum_value;
        this.tick_mark_interval = f8 / 50.0f;
        this.label_interval = this.tick_mark_interval * 5.0f;
        this.x_axis_label = vstatStatSet.getDataGroupDescription(this.data_type);
        int n4 = 0;
        if (bl) {
            if (n4 == 0) {
                this.x_axis_label = this.x_axis_label + ": ";
                ++n4;
            } else {
                this.x_axis_label = this.x_axis_label + " / ";
                ++n4;
            }
            this.x_axis_label = this.x_axis_label + "Bias";
        }
        if (bl2) {
            if (n4 == 0) {
                this.x_axis_label = this.x_axis_label + ": ";
                ++n4;
            } else {
                this.x_axis_label = this.x_axis_label + " / ";
                ++n4;
            }
            this.x_axis_label = this.x_axis_label + "Std Dev";
        }
        if (bl3) {
            if (n4 == 0) {
                this.x_axis_label = this.x_axis_label + ": ";
                ++n4;
            } else {
                this.x_axis_label = this.x_axis_label + " / ";
                ++n4;
            }
            this.x_axis_label = this.x_axis_label + "RMS";
        }
        this.dash_vector = new Vector(7);
        float[] fArray = new float[]{5.0f, 1.0f};
        this.dash_vector.add(fArray);
        float[] fArray2 = new float[]{2.0f, 1.0f};
        this.dash_vector.add(fArray2);
        float[] fArray3 = new float[]{1.0f, 1.0f};
        this.dash_vector.add(fArray3);
        float[] fArray4 = new float[]{5.0f, 1.0f, 1.0f, 1.0f};
        this.dash_vector.add(fArray4);
        float[] fArray5 = new float[]{5.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        this.dash_vector.add(fArray5);
        float[] fArray6 = new float[]{5.0f, 1.0f, 5.0f, 1.0f, 1.0f, 1.0f};
        this.dash_vector.add(fArray6);
        float[] fArray7 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f};
        this.dash_vector.add(fArray7);
    }

    public void drawImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        int n7 = (int)((double)n4 * 0.15);
        int n8 = n3;
        int n9 = (int)((double)n4 * 0.05);
        int n10 = n3;
        int n11 = n6 = n3 / 10;
        int n12 = (n4 - (n9 + n7)) / 10;
        int n13 = n5 = n4 - (n9 + n7) - n12;
        int n14 = n3 - (n6 + n11);
        int n15 = n;
        int n16 = n2;
        int n17 = n;
        int n18 = n16 + n9 + 1;
        int n19 = n + (n3 - n11);
        int n20 = n18;
        int n21 = n + n6;
        int n22 = n18 + n5;
        int n23 = n14;
        int n24 = n5;
        int n25 = n + n6;
        int n26 = n18;
        int n27 = n;
        int n28 = n22 + n12;
        int n29 = this.getMaximumPressureAxisFontSize(graphics2D, n6, n5);
        int n30 = this.getMaximumSampleSizeAxisFontSize(graphics2D, n11, n13);
        n29 = Math.min(n29, n30);
        n30 = this.getMaximumXAxisFontSize(graphics2D, n14, n12);
        n29 = Math.min(n29, n30);
        this.drawHeader(graphics2D, n15, n16, n10, n9);
        this.drawGraph(graphics2D, n25, n26, n23, n24);
        this.drawPressureAxis(graphics2D, n17, n18, n6, n5, n29);
        this.drawSampleSizeAxis(graphics2D, n19, n20, n11, n13, n29);
        this.drawXAxis(graphics2D, n21, n22, n14, n12, n29);
        this.drawLegend(graphics2D, n27, n28, n8, n7);
    }

    private void drawPressureAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        int n6 = (int)(0.25 * (double)n3);
        int n7 = n4;
        int n8 = n;
        int n9 = n2;
        int n10 = n3 - n6 - 1;
        int n11 = n4;
        int n12 = n + n6 + 1;
        int n13 = n2;
        graphics2D.setFont(new Font(this.font_name, this.font_style, n5));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Color.black);
        int n14 = n9 + n7 / 2;
        int n15 = n8 + n6 / 2;
        int n16 = fontMetrics.getAscent() + fontMetrics.getDescent() + 3;
        int n17 = n14 - 3 * n16;
        int n18 = n15 - fontMetrics.stringWidth("P") / 2;
        graphics2D.drawString("P", n18, n17);
        n17 = n14 - 2 * n16;
        n18 = n15 - fontMetrics.stringWidth("R") / 2;
        graphics2D.drawString("R", n18, n17);
        n17 = n14 - n16;
        n18 = n15 - fontMetrics.stringWidth("E") / 2;
        graphics2D.drawString("E", n18, n17);
        n17 = n14;
        n18 = n15 - fontMetrics.stringWidth("S") / 2;
        graphics2D.drawString("S", n18, n17);
        n17 = n14 + n16;
        n18 = n15 - fontMetrics.stringWidth("S") / 2;
        graphics2D.drawString("S", n18, n17);
        n17 = n14 + 2 * n16;
        n18 = n15 - fontMetrics.stringWidth("U") / 2;
        graphics2D.drawString("U", n18, n17);
        n17 = n14 + 3 * n16;
        n18 = n15 - fontMetrics.stringWidth("R") / 2;
        graphics2D.drawString("R", n18, n17);
        n17 = n14 + 4 * n16;
        n18 = n15 - fontMetrics.stringWidth("E") / 2;
        graphics2D.drawString("E", n18, n17);
        graphics2D.drawLine(n12 + n10 - 1, n13, n12 + n10 - 1, n13 + n11);
        String string = "" + (int)this.max_pressure;
        n18 = n12 + (n10 - 4 - fontMetrics.stringWidth(string));
        n17 = n13 + this.getYPoint(this.max_pressure, n11);
        int n19 = n17 + fontMetrics.getAscent() / 2;
        graphics2D.drawString(string, n18, n19);
        int n20 = n17 - fontMetrics.getAscent() / 2;
        int n21 = this.pressure_levels.length;
        for (int i = n21 - 2; i >= 0; --i) {
            n17 = n13 + this.getYPoint(this.pressure_levels[i], n11);
            if (n17 + fontMetrics.getAscent() / 2 >= n20 || !(this.pressure_levels[i] >= this.min_pressure) || !(this.pressure_levels[i] <= this.max_pressure)) continue;
            if (this.pressure_levels[i] % 1.0f == 0.0f) {
                string = "" + (int)this.pressure_levels[i];
            } else {
                float f = (float)((int)(this.pressure_levels[i] * 10.0f)) / 10.0f;
                string = "" + this.pressure_levels[i];
            }
            n18 = n12 + (n10 - 4 - fontMetrics.stringWidth(string));
            n19 = n17 + fontMetrics.getAscent() / 2;
            graphics2D.drawString(string, n18, n19);
            graphics2D.drawLine(n12 + (n10 - 3), n17, n12 + n10, n17);
            n20 = n17 - fontMetrics.getAscent() / 2;
        }
    }

    private void drawSampleSizeAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        int n6 = (int)(0.25 * (double)n3);
        int n7 = n4;
        int n8 = n + (n3 - n6 - 5);
        int n9 = n2;
        int n10 = n3 - n6 - 5;
        int n11 = n4;
        int n12 = n;
        int n13 = n2;
        graphics2D.setFont(new Font(this.font_name, this.font_style, n5));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n14 = n9 + n7 / 2;
        int n15 = n8 + n6 / 2;
        int n16 = fontMetrics.getAscent() + fontMetrics.getDescent() + 3;
        int n17 = n14 - 4 * n16;
        int n18 = n15 - fontMetrics.stringWidth("S") / 2;
        graphics2D.drawString("S", n18, n17);
        n17 = n14 - 3 * n16;
        n18 = n15 - fontMetrics.stringWidth("A") / 2;
        graphics2D.drawString("A", n18, n17);
        n17 = n14 - 2 * n16;
        n18 = n15 - fontMetrics.stringWidth("M") / 2;
        graphics2D.drawString("M", n18, n17);
        n17 = n14 - n16;
        n18 = n15 - fontMetrics.stringWidth("P") / 2;
        graphics2D.drawString("P", n18, n17);
        n17 = n14;
        n18 = n15 - fontMetrics.stringWidth("L") / 2;
        graphics2D.drawString("L", n18, n17);
        n17 = n14 + n16;
        n18 = n15 - fontMetrics.stringWidth("E") / 2;
        graphics2D.drawString("E", n18, n17);
        n17 = n14 + 2 * n16;
        n18 = n15 - fontMetrics.stringWidth(" ") / 2;
        graphics2D.drawString(" ", n18, n17);
        n17 = n14 + 3 * n16;
        n18 = n15 - fontMetrics.stringWidth("S") / 2;
        graphics2D.drawString("S", n18, n17);
        n17 = n14 + 4 * n16;
        n18 = n15 - fontMetrics.stringWidth("I") / 2;
        graphics2D.drawString("I", n18, n17);
        n17 = n14 + 5 * n16;
        n18 = n15 - fontMetrics.stringWidth("Z") / 2;
        graphics2D.drawString("Z", n18, n17);
        n17 = n14 + 6 * n16;
        n18 = n15 - fontMetrics.stringWidth("E") / 2;
        graphics2D.drawString("E", n18, n17);
        graphics2D.drawLine(n12, n13, n12, n13 + n11);
        int n19 = this.pressure_levels.length;
        int n20 = n19 - 1;
        for (int i = 0; i < this.pressure_levels.length; ++i) {
            if (this.max_pressure != this.pressure_levels[i]) continue;
            n20 = i;
        }
        String string = "";
        if (n20 != Short.MIN_VALUE) {
            string = "" + this.sample_sizes[n20];
        }
        n18 = n12 + 5;
        n17 = n13 + this.getYPoint(this.max_pressure, n11);
        int n21 = n17 + fontMetrics.getAscent() / 2;
        if (this.sample_sizes[n20] >= this.cutoff) {
            graphics2D.drawString(string, n18, n21);
        }
        int n22 = n17 - fontMetrics.getAscent() / 2;
        for (int i = n19 - 1; i >= 0; --i) {
            n17 = n13 + this.getYPoint(this.pressure_levels[i], n11);
            if (n17 + fontMetrics.getAscent() / 2 >= n22 || !(this.pressure_levels[i] >= this.min_pressure) || !(this.pressure_levels[i] <= this.max_pressure)) continue;
            if (this.sample_sizes[i] >= this.cutoff) {
                string = "" + this.sample_sizes[i];
                n21 = n17 + fontMetrics.getAscent() / 2;
                graphics2D.drawString(string, n18, n21);
                graphics2D.drawLine(n12 + 1, n17, n12 + 4, n17);
            }
            n22 = n17 - fontMetrics.getAscent() / 2;
        }
    }

    private void drawXAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        float f;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        int n6 = n3;
        int n7 = (int)(0.5 * (double)n4);
        int n8 = n;
        int n9 = n2 + (n4 - n7);
        int n10 = n3;
        int n11 = n4 - n7;
        int n12 = n;
        int n13 = n2;
        graphics2D.setFont(new Font(this.font_name, this.font_style, n5));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n14 = n8 + (n6 / 2 - fontMetrics.stringWidth(this.x_axis_label) / 2);
        int n15 = n9 + fontMetrics.getHeight();
        graphics2D.drawString(this.x_axis_label, n14, n15);
        graphics2D.drawLine(n12, n13, n12 + n10, n13);
        n15 = n13 + (2 + fontMetrics.getAscent());
        String string = "0.0";
        if (this.label_interval >= 5.0f) {
            string = "0";
        }
        n14 = n12 + (this.getXPoint(0.0f, n10) - fontMetrics.stringWidth(string) / 2);
        graphics2D.drawString(string, n14, n15);
        int n16 = n12 + this.getXPoint(0.0f, n10);
        graphics2D.drawLine(n16, n13, n16, n13 + 5);
        graphics2D.drawLine(n16 - 1, n13, n16 - 1, n13 + 5);
        int n17 = fontMetrics.stringWidth(".0");
        int n18 = n14;
        int n19 = n12;
        int n20 = n12 + n10;
        for (f = 0.0f - this.label_interval; f >= this.minimum_value; f -= this.label_interval) {
            string = this.label_interval >= 5.0f ? "" + (int)f : "" + (float)((int)(f * 10.0f)) / 10.0f;
            n6 = fontMetrics.stringWidth(string);
            n14 = n12 + (this.getXPoint(f, n10) - n6 / 2);
            if (n14 - n17 > n19 && n14 + n6 + n17 < n18) {
                graphics2D.drawString(string, n14, n15);
                n18 = n14;
            }
            n16 = n12 + this.getXPoint(f, n10);
            graphics2D.drawLine(n16, n13, n16, n13 + 5);
            graphics2D.drawLine(n16 - 1, n13, n16 - 1, n13 + 5);
        }
        n18 = fontMetrics.stringWidth("0.0") / 2 + n17;
        for (f = this.label_interval; f <= this.maximum_value; f += this.label_interval) {
            string = this.label_interval >= 5.0f ? "" + (int)f : "" + (float)((int)(f * 10.0f)) / 10.0f;
            n6 = fontMetrics.stringWidth(string);
            n14 = n12 + (this.getXPoint(f, n10) - n6 / 2);
            if (n14 - n17 > n18 && n14 + n6 + n17 < n20) {
                graphics2D.drawString(string, n14, n15);
                n18 = n14 + fontMetrics.stringWidth(string);
            }
            n16 = n12 + this.getXPoint(f, n10);
            graphics2D.drawLine(n16, n13, n16, n13 + 5);
            graphics2D.drawLine(n16 - 1, n13, n16 - 1, n13 + 5);
        }
        for (f = this.minimum_value; f <= this.maximum_value; f += this.tick_mark_interval) {
            n14 = n12 + this.getXPoint(f, n10);
            graphics2D.drawLine(n14, n13, n14, n13 + 3);
        }
    }

    private void drawGraph(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        graphics2D.setClip(n, n2, n3, n4);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        this.drawGridLines(graphics2D, n, n2, n3, n4);
        this.drawZeroLine(graphics2D, n, n2, n3, n4);
        if (this.show_bias) {
            for (n5 = 0; n5 < this.num_profiles; ++n5) {
                this.drawProfile(this.profiles[n5][1], graphics2D, n, n2, n3, n4);
            }
        }
        if (this.show_stddev) {
            for (n5 = 0; n5 < this.num_profiles; ++n5) {
                this.drawProfile(this.profiles[n5][2], graphics2D, n, n2, n3, n4);
            }
        }
        if (this.show_rms) {
            for (n5 = 0; n5 < this.num_profiles; ++n5) {
                this.drawProfile(this.profiles[n5][3], graphics2D, n, n2, n3, n4);
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n, n2, n + n3, n2);
        graphics2D.setClip(null);
    }

    private void drawProfile(Profile profile, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (profile.isVisible()) {
            int n5;
            Object object;
            int n6 = profile.getNumberOfPoints();
            Color color = profile.getLineColor();
            int n7 = profile.getLineStyle();
            int n8 = this.line_thickness;
            if (n8 == 0) {
                n8 = (int)((float)n3 * 0.005f);
            }
            n8 = Math.max(n8, 1);
            Stroke stroke = graphics2D.getStroke();
            BasicStroke basicStroke = new BasicStroke(n8, 1, 1);
            if (n7 > 1) {
                float[] fArray = (float[])this.dash_vector.elementAt(n7 - 1);
                object = new float[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    object[i] = fArray[i] * (float)n8;
                }
                basicStroke = new BasicStroke(n8, 0, 1, 10.0f, (float[])object, 0.0f);
            }
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(color);
            int n9 = (int)((float)n8 + (float)n8 / 4.0f);
            n9 = Math.max(n9, 4);
            object = new Vector();
            Vector<Point> vector = new Vector<Point>();
            for (n5 = 0; n5 < n6; ++n5) {
                int n10 = Short.MIN_VALUE;
                int n11 = Short.MIN_VALUE;
                if (this.isSampleSizeAboveCutoff(profile.getPressure(n5))) {
                    n10 = n + this.getXPoint(profile.getVal(n5), n3);
                    n11 = n2 + this.getYPoint(profile.getPressure(n5), n4);
                }
                if (n10 == Short.MIN_VALUE || n11 == Short.MIN_VALUE) {
                    ((Vector)object).add(vector);
                    vector = new Vector<Point>();
                    continue;
                }
                if (this.show_data_points) {
                    graphics2D.fillOval(n10 - n9, n11 - n9, n9 * 2, n9 * 2);
                }
                Point point = new Point(n10, n11);
                vector.add(point);
            }
            ((Vector)object).add(vector);
            for (n5 = 0; n5 < ((Vector)object).size(); ++n5) {
                vector = (Vector<Point>)((Vector)object).elementAt(n5);
                int[] nArray = new int[vector.size()];
                int[] nArray2 = new int[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    Point point = (Point)vector.elementAt(i);
                    nArray[i] = point.x;
                    nArray2[i] = point.y;
                }
                graphics2D.drawPolyline(nArray, nArray2, vector.size());
            }
            graphics2D.setStroke(stroke);
        }
    }

    private void drawZeroLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n + this.getXPoint(0.0f, n3);
        int n6 = n2;
        int n7 = n2 + n4;
        int n8 = 2;
        if (this.draw_gridlines) {
            n8 = 1;
        }
        boolean bl = true;
        Stroke stroke = graphics2D.getStroke();
        float[] fArray = (float[])this.dash_vector.elementAt(n8 - 1);
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i] * (float)bl;
        }
        BasicStroke basicStroke = new BasicStroke((float)bl, 0, 1, 10.0f, fArray2, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n5, n6, n5, n7);
        graphics2D.setStroke(stroke);
    }

    private void drawGridLines(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.draw_gridlines) {
            int n5;
            int n6;
            Stroke stroke = graphics2D.getStroke();
            int n7 = 2;
            boolean bl = true;
            float[] fArray = (float[])this.dash_vector.elementAt(n7 - 1);
            float[] fArray2 = new float[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray2[i] = fArray[i] * (float)bl;
            }
            BasicStroke basicStroke = new BasicStroke((float)bl, 0, 1, 10.0f, fArray2, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(Color.gray);
            int n8 = n;
            int n9 = n + n3;
            for (n6 = 0; n6 < this.pressure_levels.length; ++n6) {
                n5 = n2 + this.getYPoint(this.pressure_levels[n6], n4);
                graphics2D.drawLine(n8, n5, n9, n5);
            }
            n6 = n2;
            n5 = n2 + n4;
            int[] nArray = this.getTickMarkPositions(n3);
            for (int i = 0; i < nArray.length; ++i) {
                int n10 = n + nArray[i];
                graphics2D.drawLine(n10, n6, n10, n5);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setColor(Color.black);
        }
    }

    private void drawHeader(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        String string = this.stat_set.getStartingDate() + "  to  " + this.stat_set.getEndingDate();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = 25;
        boolean bl = false;
        while (!bl && n5 > 5) {
            graphics2D.setFont(new Font("Serif", 1, --n5));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 || fontMetrics.stringWidth(string) >= n3) continue;
            bl = true;
        }
        int n6 = n + (n3 / 2 - fontMetrics.stringWidth(string) / 2);
        int n7 = n2 + fontMetrics.getAscent();
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n6, n7);
    }

    private void drawLegend(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n, n2, n + n3, n2);
        int n6 = 2 + this.num_profiles % 3;
        int n7 = n4 / n6;
        int n8 = n3 / 3;
        String string = "Baseline:  " + this.stat_set.getBaselineSystemDescription(this.data_type);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n9 = 37;
        boolean bl = false;
        while (!bl && n9 > 5) {
            graphics2D.setFont(new Font("SansSerif", 1, --n9));
            fontMetrics = graphics2D.getFontMetrics();
            bl = true;
            if (fontMetrics.getHeight() >= n7) {
                bl = false;
            }
            if (fontMetrics.stringWidth(string) >= n8) {
                bl = false;
            }
            for (n5 = 0; n5 < this.num_profiles; ++n5) {
                if (fontMetrics.stringWidth(this.profile_names[n5]) < n8) continue;
                bl = false;
            }
        }
        n5 = n2 + fontMetrics.getAscent();
        int n10 = n + (n3 / 2 - fontMetrics.stringWidth(string) / 2);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n10, n5);
        int n11 = 1;
        int n12 = 0;
        for (int i = 0; i < this.num_profiles; ++i) {
            n5 = n2 + n11 * n7 + fontMetrics.getAscent();
            n10 = n + n12 * n8 + n8 / 2 - fontMetrics.stringWidth(this.profile_names[i]) / 2;
            graphics2D.setColor(this.profile_colors[i]);
            graphics2D.drawString(this.profile_names[i], n10, n5);
            if (++n12 <= 2) continue;
            n12 = 0;
            ++n11;
        }
    }

    private int getMaximumPressureAxisFontSize(Graphics2D graphics2D, int n, int n2) {
        int n3 = 5;
        int n4 = (int)(0.3 * (double)n);
        int n5 = n2;
        int n6 = n - n4 - 1;
        int n7 = n2;
        n3 = 35;
        boolean bl = false;
        graphics2D.setFont(new Font(this.font_name, this.font_style, n3));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        while (!bl && n3 > this.min_font_size) {
            graphics2D.setFont(new Font(this.font_name, this.font_style, --n3));
            fontMetrics = graphics2D.getFontMetrics();
            int n8 = 8 * (fontMetrics.getAscent() + fontMetrics.getDescent() + 3);
            if (n8 >= n5 - 10 || fontMetrics.stringWidth("P") >= n4 - 4) continue;
            bl = true;
        }
        ++n3;
        bl = false;
        while (!bl && n3 > this.min_font_size) {
            graphics2D.setFont(new Font(this.font_name, this.font_style, --n3));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.stringWidth("1000.00") >= n6) continue;
            bl = true;
        }
        return n3;
    }

    private int getMaximumSampleSizeAxisFontSize(Graphics2D graphics2D, int n, int n2) {
        int n3 = 5;
        int n4 = (int)(0.25 * (double)n);
        int n5 = n2;
        int n6 = (int)(0.75 * (double)n);
        int n7 = n2;
        n3 = 35;
        boolean bl = false;
        graphics2D.setFont(new Font(this.font_name, this.font_style, n3));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        while (!bl && n3 > this.min_font_size) {
            graphics2D.setFont(new Font(this.font_name, this.font_style, --n3));
            fontMetrics = graphics2D.getFontMetrics();
            int n8 = 8 * (fontMetrics.getAscent() + fontMetrics.getDescent() + 3);
            if (n8 >= n5 - 10 || fontMetrics.stringWidth("P") >= n4 - 4) continue;
            bl = true;
        }
        ++n3;
        bl = false;
        while (!bl && n3 > this.min_font_size) {
            graphics2D.setFont(new Font(this.font_name, this.font_style, --n3));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.stringWidth("88888") >= n6) continue;
            bl = true;
        }
        return n3;
    }

    private int getMaximumXAxisFontSize(Graphics2D graphics2D, int n, int n2) {
        int n3 = 5;
        int n4 = n;
        int n5 = (int)(0.5f * (float)n2);
        int n6 = n;
        int n7 = n2 - n5;
        n3 = 36;
        boolean bl = false;
        graphics2D.setFont(new Font(this.font_name, this.font_style, n3));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        while (!bl && n3 > this.min_font_size) {
            graphics2D.setFont(new Font(this.font_name, this.font_style, --n3));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n5) continue;
            bl = true;
        }
        ++n3;
        bl = false;
        while (!bl && n3 > this.min_font_size) {
            graphics2D.setFont(new Font(this.font_name, this.font_style, --n3));
            fontMetrics = graphics2D.getFontMetrics();
            if (this.number_of_labels * (5 + fontMetrics.stringWidth("88.8")) >= n6) continue;
            bl = true;
        }
        return n3;
    }

    private void getDataMinMax(int n, float f, float f2, float f3, float f4) {
        float f5 = this.minimum_value;
        float f6 = this.maximum_value;
        if (n == 2) {
            this.minimum_value = f;
            this.maximum_value = f2;
        } else if (n == 1) {
            this.minimum_value = f3;
            this.maximum_value = f4;
        } else if (n == 0) {
            this.minimum_value = 99999.99f;
            this.maximum_value = -99999.99f;
            for (int i = 0; i < this.num_profiles; ++i) {
                float f7;
                int n2;
                int n3;
                if (this.show_bias) {
                    n3 = this.profiles[i][1].getNumberOfPoints();
                    for (n2 = 0; n2 < n3; ++n2) {
                        f7 = this.profiles[i][1].getVal(n2);
                        if (f7 == -32768.0f || !this.isSampleSizeAboveCutoff(this.profiles[i][1].getPressure(n2))) continue;
                        this.minimum_value = Math.min(this.minimum_value, f7);
                        this.maximum_value = Math.max(this.maximum_value, f7);
                    }
                }
                if (this.show_stddev) {
                    n3 = this.profiles[i][2].getNumberOfPoints();
                    for (n2 = 0; n2 < n3; ++n2) {
                        f7 = this.profiles[i][2].getVal(n2);
                        if (f7 == -32768.0f || !this.isSampleSizeAboveCutoff(this.profiles[i][2].getPressure(n2))) continue;
                        this.minimum_value = Math.min(this.minimum_value, f7);
                        this.maximum_value = Math.max(this.maximum_value, f7);
                    }
                }
                if (!this.show_rms) continue;
                n3 = this.profiles[i][3].getNumberOfPoints();
                for (n2 = 0; n2 < n3; ++n2) {
                    f7 = this.profiles[i][3].getVal(n2);
                    if (f7 == -32768.0f || !this.isSampleSizeAboveCutoff(this.profiles[i][3].getPressure(n2))) continue;
                    this.minimum_value = Math.min(this.minimum_value, f7);
                    this.maximum_value = Math.max(this.maximum_value, f7);
                }
            }
        }
        if (this.minimum_value > this.maximum_value) {
            float f8 = this.minimum_value;
            this.minimum_value = this.maximum_value;
            this.maximum_value = f8;
        }
        this.minimum_value -= Math.abs(this.minimum_value) * 0.1f;
        this.maximum_value += Math.abs(this.maximum_value) * 0.1f;
    }

    private void calculateCutoff() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.sample_sizes.length; ++n) {
            n2 = Math.max(n2, this.sample_sizes[n]);
        }
        this.cutoff = (int)((float)n2 * this.cutoff_difference);
        this.cutoff = Math.max(this.cutoff, this.display_cutoff);
        n = 0;
        for (int i = 0; i < this.sample_sizes.length; ++i) {
            if (this.sample_sizes[i] < this.cutoff) continue;
            ++n;
        }
        if (n == 0) {
            this.cutoff = 0;
        }
    }

    public boolean isSampleSizeAboveCutoff(int n) {
        boolean bl = false;
        if (n > 0 && n < this.sample_sizes.length && this.sample_sizes[n] >= this.cutoff) {
            bl = true;
        }
        return bl;
    }

    public boolean isSampleSizeAboveCutoff(float f) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.pressure_levels.length; ++n) {
            if (f != this.pressure_levels[n]) continue;
            n2 = n;
        }
        n = this.isSampleSizeAboveCutoff(n2) ? 1 : 0;
        return n != 0;
    }

    public int[] getTickMarkPositions(int n) {
        int n2;
        int n3 = 0;
        for (float f = this.minimum_value; f <= this.maximum_value; f += this.tick_mark_interval) {
            ++n3;
        }
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = 0;
        }
        n2 = -1;
        for (float f = this.minimum_value; f <= this.maximum_value; f += this.tick_mark_interval) {
            nArray[++n2] = this.getXPoint(f, n);
        }
        return nArray;
    }

    public int getXPoint(float f, int n) {
        float f2 = (f - this.minimum_value) / (this.maximum_value - this.minimum_value);
        int n2 = (int)(f2 * (float)n);
        return n2;
    }

    private int getYPoint(float f, int n) {
        float f2 = (float)Math.pow(f, 0.2857142984867096);
        float f3 = (float)Math.pow(this.min_pressure, 0.2857142984867096);
        float f4 = (float)Math.pow(this.max_pressure, 0.2857142984867096);
        float f5 = (f2 - f3) * 99.0f / (f4 - f3) + 1.0f;
        int n2 = (int)((f5 /= 100.0f) * (float)n);
        return n2;
    }
}

