/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class EUAtovsRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public EUAtovsRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public EUAtovsRecord(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public EUAtovsRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[200];
        for (int i = 0; i < 200; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        String string = "";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "" + this.buffer[143];
        return string;
    }

    public int getTerrain() {
        return this.buffer[143];
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = this.getTerrain();
        return n;
    }

    public boolean hasQCFlag() {
        return false;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        return bl;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return Short.MIN_VALUE;
    }

    public int getCloudFlagForNarcs() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return true;
    }

    public int getDayNightFlag() {
        int n = Short.MIN_VALUE;
        return n;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(this.getSurfacePressure()));
        float f = -999.99f;
        if (this.buffer[84] != Short.MIN_VALUE) {
            f = (float)this.buffer[84] / 64.0f;
        }
        vector.add(new Float(f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        float f = -32768.0f;
        if (this.buffer[89] != Short.MIN_VALUE) {
            f = (float)this.buffer[89] / 10.0f;
        }
        vector.add(new Float(f));
        float f2 = -32768.0f;
        if (this.buffer[88] != Short.MIN_VALUE) {
            f2 = (float)this.buffer[88] / 64.0f;
        }
        vector.add(new Float(f2));
        float f3 = -32768.0f;
        if (this.buffer[87] != Short.MIN_VALUE) {
            f3 = (float)this.buffer[87] / 100.0f;
        }
        vector.add(new Float(f3));
        boolean bl = false;
        vector.add(new Boolean(bl));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription()};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[]{null};
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getWvapPressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getWvapPressureLevels();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n >= 3) {
                f2 = -32768.0f;
            } else if (n == 0) {
                float[] fArray2 = this.getRetrievedTemps();
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray3 = this.getRetrievedWaterVapor();
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && n == 1) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getWvapPressureLevels();
        float[] fArray4 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray3);
        vectorArray[0].add(fArray4);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getPressures();
        return fArray;
    }

    private float getPressureLevelValue(int n) {
        PressureLevels pressureLevels = new PressureLevels();
        float f = pressureLevels.getPressure(n + 1);
        return f;
    }

    private float[] getWvapPressureLevels() {
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getWVPressures();
        float[] fArray2 = new float[15];
        for (int i = 0; i < 15; ++i) {
            fArray2[i] = fArray[i + 2];
        }
        return fArray2;
    }

    private float getWvapPressureLevelValue(int n) {
        PressureLevels pressureLevels = new PressureLevels();
        float f = pressureLevels.getWVPressure(n + 3);
        return f;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[40];
        for (int i = 0; i < 40; ++i) {
            fArray[i] = this.buffer[i + 29] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 29] / 64.0f;
        }
        return fArray;
    }

    private float getRetrievedTempValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 299] != Short.MIN_VALUE) {
            f = (float)this.buffer[n + 299] / 64.0f;
        }
        return f;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[15];
        for (int i = 0; i < 15; ++i) {
            fArray[i] = this.buffer[i + 69] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 69] / 1024.0);
        }
        return fArray;
    }

    private float getRetrievedWVapValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 389] != Short.MIN_VALUE) {
            f = (float)Math.exp((double)this.buffer[n + 389] / 1024.0);
        }
        return f;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[15];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getWvapPressureLevels();
        for (int i = 0; i < 15; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
        }
        return fArray;
    }

    private float getRetrievedDewpointValue(int n) {
        float f = -999.99f;
        float f2 = this.getRetrievedWVapValue(n);
        float f3 = this.getWvapPressureLevelValue(n);
        if (f2 != -999.99f) {
            f = EdgeUtils.convertToDewPoint(f2, f3);
        }
        return f;
    }

    private float[] getHirsBtemps() {
        float[] fArray = new float[20];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.buffer[94 + i] != Short.MIN_VALUE ? (float)this.buffer[94 + i] / 64.0f : -999.99f;
        }
        return fArray;
    }

    private float[] getAmsuBtemps() {
        float[] fArray = new float[15];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.buffer[114 + i] != Short.MIN_VALUE ? (float)this.buffer[114 + i] / 64.0f : -999.99f;
        }
        return fArray;
    }

    private float[] getMhsBtemps() {
        float[] fArray = new float[5];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.buffer[129 + i] != Short.MIN_VALUE ? (float)this.buffer[129 + i] / 64.0f : -999.99f;
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("File Number");
        if (this.buffer[11] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[11]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame");
        if (this.buffer[12] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[12]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scan Line");
        if (this.buffer[13] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[13]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Field of View");
        if (this.buffer[14] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[14]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Zenith Angle");
        if (this.buffer[19] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[19] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Zenith Angle");
        if (this.buffer[20] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[20] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Azimuth Angle");
        if (this.buffer[21] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[21] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Azimuth Angle");
        if (this.buffer[22] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[22] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Elevation");
        if (this.buffer[23] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[23]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Type Estimate");
        if (this.buffer[143] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[143]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS Surface Type");
        if (this.buffer[150] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[150]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AMSU Surface Type");
        if (this.buffer[151] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[151]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MHS Surface Type");
        if (this.buffer[152] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[152]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Temperature");
        if (this.buffer[84] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[84] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Fractional Cloud Cover");
        if (this.buffer[87] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[87] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Pressure");
        if (this.buffer[89] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[89] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Temperature");
        if (this.buffer[88] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[88] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tropopause Height");
        if (this.buffer[90] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[90] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Liquid Water");
        if (this.buffer[91] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[91] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Total Precipitable Water");
        if (this.buffer[92] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[92] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("QC Indicator Bit Field");
        if (this.buffer[139] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[139]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Time Problem Flag");
        if (this.buffer[140] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[140]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS FOV QC");
        if (this.buffer[141] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[141]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Pre-processing QC Word");
        if (this.buffer[142] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[142]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Cost Function");
        if (this.buffer[144] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[144]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scattering Index");
        if (this.buffer[145] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[145]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Precip Probability");
        if (this.buffer[146] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[146]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Median Flag MHS");
        if (this.buffer[147] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[147]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MHS Variability");
        if (this.buffer[148] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[148]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Out of Bounds Analysis");
        if (this.buffer[149] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[149]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS Stand-alone Cloud Detect");
        if (this.buffer[153] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[153]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS Day/Night");
        if (this.buffer[154] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[154]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Pct Cloudy FOV");
        if (this.buffer[155] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[155]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS Bias Correction");
        if (this.buffer[156] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[156]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AMSU Bias Correction");
        if (this.buffer[157] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[157]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MHS Bias Correction");
        if (this.buffer[158] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[158]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("HIRS Bias Correction");
        if (this.buffer[159] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[159]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AMSU Bias Correction");
        if (this.buffer[160] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[160]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MHS Limb Correction");
        if (this.buffer[161] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[161]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AMSU Antenna Correction");
        if (this.buffer[162] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[162]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MHS Antenna Correction");
        if (this.buffer[163] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[163]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Mapped Cloud Flag");
        if (this.buffer[166] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[166]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Mapped Input Data Flag");
        if (this.buffer[167] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[167]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Clearing Flag");
        if (this.buffer[168] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[168]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("FG Initialisation");
        if (this.buffer[169] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[169]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure Flag");
        if (this.buffer[170] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[170]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Distance Rejection Flag");
        if (this.buffer[171] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[171]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Rejection Flag");
        if (this.buffer[172] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[172]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tarm Path");
        if (this.buffer[173] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[173]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Emissivity Flag");
        if (this.buffer[174] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[174]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLayerDataTable() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Layer Data</bold></font></html>"));
        return vector;
    }
}

