/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class EUIasiRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public EUIasiRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public EUIasiRecord(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public EUIasiRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[600];
        for (int i = 0; i < 600; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        String string = "";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "" + this.buffer[50];
        if (this.buffer[50] == 0) {
            string = "sea";
        } else if (this.buffer[50] == 1) {
            string = "land";
        }
        return string;
    }

    public int getTerrain() {
        return this.buffer[50];
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = 0;
        if (this.getTerrain() != 0) {
            n = 1;
        }
        return n;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        int n;
        boolean bl = true;
        if (this.buffer[45] != 0) {
            bl = false;
        }
        if ((this.buffer[44] & (n = 8192)) == n) {
            bl = false;
        }
        if (this.buffer[54] != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean hasCloudFlag() {
        return true;
    }

    public int getCloudFlag() {
        int n = Short.MIN_VALUE;
        int n2 = this.buffer[529];
        if (n2 == 0) {
            n = 0;
        } else {
            float f = 0.0f;
            for (int i = 0; i < n2; ++i) {
                if (this.buffer[530 + i] == Short.MIN_VALUE) continue;
                f += (float)this.buffer[530 + i] / 100.0f;
            }
            if (f == 0.0f) {
                n = 0;
            } else if (f > 0.0f && f <= 20.0f) {
                n = 1;
            } else if (f > 20.0f) {
                n = 2;
            }
        }
        return n;
    }

    public int getCloudFlagForNarcs() {
        int n = this.getCloudFlag();
        if (n > 1) {
            n = 1;
        }
        return n;
    }

    public boolean hasDayNightFlag() {
        return true;
    }

    public int getDayNightFlag() {
        int n = Short.MIN_VALUE;
        if (this.buffer[40] == 0) {
            n = 1;
        } else if (this.buffer[40] == 1) {
            n = 0;
        }
        return n;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        if (this.buffer[542] != Short.MIN_VALUE) {
            f = (float)this.buffer[542] / 10.0f;
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(this.getSurfacePressure()));
        float f = -999.99f;
        if (this.buffer[501] != Short.MIN_VALUE) {
            f = (float)this.buffer[501] / 64.0f;
        }
        vector.add(new Float(f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        float f = -32768.0f;
        if (this.buffer[536] != Short.MIN_VALUE) {
            f = (float)this.buffer[536] / 10.0f;
        }
        vector.add(new Float(f));
        float f2 = -32768.0f;
        if (this.buffer[533] != Short.MIN_VALUE) {
            f2 = (float)this.buffer[533] / 64.0f;
        }
        vector.add(new Float(f2));
        float f3 = -32768.0f;
        if (this.buffer[530] != Short.MIN_VALUE) {
            f3 = (float)this.buffer[530] / 100.0f;
        }
        vector.add(new Float(f3));
        boolean bl = false;
        vector.add(new Boolean(bl));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription()};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(this.getSurfacePressure());
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[]{null};
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(this.getSurfacePressure());
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getPressureLevels();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].setSurfacePressure(this.getSurfacePressure());
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n >= 3) {
                f2 = -32768.0f;
            } else if (n == 0) {
                float[] fArray2 = this.getRetrievedTemps();
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray3 = this.getRetrievedWaterVapor();
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && n == 1) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray3);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[90];
        for (int i = 0; i < 90; ++i) {
            fArray[i] = this.buffer[i + 99] == Short.MIN_VALUE ? -999.99f : (i < 30 ? (float)this.buffer[i + 99] / 1000.0f : (float)this.buffer[i + 99] / 10.0f);
        }
        return fArray;
    }

    private float[] getWaterVaporPressures() {
        float[] fArray = new float[90];
        for (int i = 0; i < 90; ++i) {
            fArray[i] = this.buffer[i + 189] == Short.MIN_VALUE ? -999.99f : (i < 30 ? (float)this.buffer[i + 189] / 1000.0f : (float)this.buffer[i + 189] / 10.0f);
        }
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[90];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 90; ++i) {
            fArray[i] = this.buffer[i + 299] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 299] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[90];
        float[] fArray2 = this.getWaterVaporPressures();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 90; ++i) {
            fArray[i] = this.buffer[i + 389] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 389] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[90];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getPressureLevels();
        for (int i = 0; i < 90; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scan Line");
        if (this.buffer[12] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[12]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Field Of View");
        if (this.buffer[13] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[13]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Spacecraft Altitude");
        if (this.buffer[15] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[15]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Zenith Angle");
        if (this.buffer[16] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[16] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Zenith Angle");
        if (this.buffer[17] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[17] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Azimuth Angle");
        if (this.buffer[18] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[18] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Azimuth Angle");
        if (this.buffer[19] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[19] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Flag For ATOVS Products");
        if (this.buffer[29] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[29]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("ATOVS Completeness");
        if (this.buffer[30] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[30]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Interpolation of ATOVS to IASI");
        if (this.buffer[31] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[31]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AVHRR Completeness");
        if (this.buffer[32] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[32]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AVHRR Validation Flag");
        if (this.buffer[33] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[33]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Channel Selection");
        if (this.buffer[34] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[34]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Num AVHRR Cloud Formations");
        if (this.buffer[35] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[35]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Origin Of Height Assignment");
        if (this.buffer[36] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[36]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Phase Flag");
        if (this.buffer[37] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[37]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Instruments");
        if (this.buffer[38] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[38]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Executed Cloud Tests");
        if (this.buffer[39] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[39]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Day/Night Flag");
        if (this.buffer[40] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[40]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("1st Guess to Iterative Retrieval");
        if (this.buffer[41] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[41]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Final Retrieval Choice");
        if (this.buffer[42] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[42]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Fractional Cloud Cover (ATOVS or AVHRR)");
        if (this.buffer[43] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[43]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("IASI Level 1 Validation");
        if (this.buffer[44] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[44]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Test Results");
        if (this.buffer[45] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[45]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("IASI Tarm Path");
        if (this.buffer[46] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[46]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Initialization");
        if (this.buffer[47] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[47]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Interative Retrieval Convergence");
        if (this.buffer[48] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[48]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Iterated State Vector Validation");
        if (this.buffer[49] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[49]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Type");
        if (this.buffer[50] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[50]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Num Iterations Used For Retrieval");
        if (this.buffer[51] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[51]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("NWP Forecast Validation");
        if (this.buffer[52] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[52]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Quality & Completeness");
        if (this.buffer[53] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[53]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Residual Acceptance Flag");
        if (this.buffer[54] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[54]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("IASI Combined or Stand-alone");
        if (this.buffer[56] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[56]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sat Manouevre");
        if (this.buffer[57] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[57]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Background State Selection");
        if (this.buffer[58] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[58]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("AVHRR Derived Surface Temp");
        if (this.buffer[59] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[59]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Topography Validation");
        if (this.buffer[60] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[60]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sun Glint");
        if (this.buffer[61] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[61]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Superadiabatic");
        if (this.buffer[62] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[62]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Supersaturation");
        if (this.buffer[63] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[63]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Thin Cirrus Cloud Test");
        if (this.buffer[64] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[64]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Thin Cirrus Correction");
        if (this.buffer[65] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[65]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Clearing");
        if (this.buffer[66] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[66]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Degraded Instrument Flag");
        if (this.buffer[69] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[69]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Degraded Processing Flag");
        if (this.buffer[70] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[70]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Nummber of Surface Temps");
        if (this.buffer[500] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[500]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Temperatures");
        String string = "";
        string = this.buffer[501] != Short.MIN_VALUE ? "" + (float)this.buffer[501] / 64.0f + " / " : "not available / ";
        string = this.buffer[502] != Short.MIN_VALUE ? string + (float)this.buffer[502] / 64.0f : string + "Missing";
        vector4.add(string);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Integrated N2O");
        if (this.buffer[503] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[503] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Integrated CO");
        if (this.buffer[504] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[504] / 32.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Integrated CH4");
        if (this.buffer[505] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[505] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Integrated CO2");
        if (this.buffer[506] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[506] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Number Of Cloud Formations");
        if (this.buffer[529] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[529]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Pressure");
        String string2 = "Missing";
        String string3 = "Missing";
        String string4 = "Missing";
        if (this.buffer[536] != Short.MIN_VALUE) {
            string2 = "" + (float)this.buffer[536] / 10.0f;
        }
        if (this.buffer[537] != Short.MIN_VALUE) {
            string3 = "" + (float)this.buffer[537] / 10.0f;
        }
        if (this.buffer[538] != Short.MIN_VALUE) {
            string3 = "" + (float)this.buffer[538] / 10.0f;
        }
        vector4.add(string2 + " / " + string3 + " / " + string4);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Temperature");
        string2 = "Missing";
        string3 = "Missing";
        string4 = "Missing";
        if (this.buffer[533] != Short.MIN_VALUE) {
            string2 = "" + (float)this.buffer[533] / 64.0f;
        }
        if (this.buffer[534] != Short.MIN_VALUE) {
            string3 = "" + (float)this.buffer[534] / 64.0f;
        }
        if (this.buffer[535] != Short.MIN_VALUE) {
            string3 = "" + (float)this.buffer[535] / 164.0f;
        }
        vector4.add(string2 + " / " + string3 + " / " + string4);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Fractional Cloud Cover");
        string2 = "Missing";
        string3 = "Missing";
        string4 = "Missing";
        if (this.buffer[530] != Short.MIN_VALUE) {
            string2 = "" + (float)this.buffer[530] / 100.0f;
        }
        if (this.buffer[531] != Short.MIN_VALUE) {
            string3 = "" + (float)this.buffer[531] / 100.0f;
        }
        if (this.buffer[532] != Short.MIN_VALUE) {
            string3 = "" + (float)this.buffer[532] / 100.0f;
        }
        vector4.add(string2 + " / " + string3 + " / " + string4);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Phase");
        string2 = "Missing";
        string3 = "Missing";
        string4 = "Missing";
        if (this.buffer[539] != Short.MIN_VALUE) {
            string2 = "" + this.buffer[539];
        }
        if (this.buffer[540] != Short.MIN_VALUE) {
            string3 = "" + this.buffer[540];
        }
        if (this.buffer[541] != Short.MIN_VALUE) {
            string3 = "" + this.buffer[541];
        }
        vector4.add(string2 + " / " + string3 + " / " + string4);
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLayerDataTable() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Layer Data</bold></font></html>"));
        return vector;
    }
}

