/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FocusDayEDRRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public FocusDayEDRRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public FocusDayEDRRecord(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public FocusDayEDRRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[1500];
        for (int i = 0; i < 1500; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        return "";
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "";
        if (this.buffer[19] == 1) {
            string = "Land";
        } else if (this.buffer[19] == 2) {
            string = "Ocean";
        } else if (this.buffer[19] == 3) {
            string = "1st Year Ice";
        } else if (this.buffer[19] == 4) {
            string = "Multi Year Ice";
        } else if (this.buffer[19] == 5) {
            string = "Snow";
        } else if (this.buffer[19] == 6) {
            string = "Glacier";
        }
        return string;
    }

    public int getTerrain() {
        return this.buffer[19];
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = 1;
        if (this.buffer[19] == 2) {
            n = 0;
        }
        return n;
    }

    public boolean hasQCFlag() {
        return false;
    }

    public boolean getQCFlag() {
        return true;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return 0;
    }

    public int getCloudFlagForNarcs() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return false;
    }

    public int getDayNightFlag() {
        return Short.MIN_VALUE;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        if (this.buffer[22] != Short.MIN_VALUE) {
            f = (float)this.buffer[22] / 10.0f;
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(this.getSurfacePressure()));
        float f = -32768.0f;
        if (this.buffer[23] != Short.MIN_VALUE) {
            f = (float)this.buffer[23] / 64.0f;
        }
        vector.add(new Float(f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        float f = (float)this.buffer[75] / 10.0f;
        vector.add(new Float(f));
        vector.add(new Float(-32768.0f));
        float f2 = (float)this.buffer[77] / 100.0f;
        vector.add(new Float(f2));
        vector.add(new Boolean(false));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription()};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[1];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = fArray2.length - 1; i >= 0; --i) {
                if (fArray2[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[1];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8) {
                f2 = -32768.0f;
            } else if (n == 0) {
                float[] fArray2 = this.getRetrievedTemps();
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray3 = this.getRetrievedDewpoints();
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && n == 1) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray3);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[100];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.buffer[i + 99] == Short.MIN_VALUE ? -999.99f : (i < 20 ? (float)this.buffer[i + 99] / 100.0f : (float)this.buffer[i + 99] / 10.0f);
        }
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.buffer[i + 199] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 199] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 299] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 299] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLevelDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Granule Number");
        if (this.buffer[9] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[9]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Profile Number");
        if (this.buffer[10] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[10]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame");
        if (this.buffer[11] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[11]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scan Position");
        if (this.buffer[12] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[12]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Orbital Node");
        if (this.buffer[13] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[13]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Class");
        if (this.buffer[19] != Short.MIN_VALUE) {
            vector4.add("" + this.getTerrain() + ": " + this.getTerrainString());
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Land Fraction");
        if (this.buffer[20] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[20] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Topography");
        if (this.buffer[21] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[21]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure");
        if (this.buffer[22] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[22] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Skin Temperature");
        if (this.buffer[23] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[23] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Emissivity at 50.3 GHz");
        if (this.buffer[24] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[24] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Satellite Height");
        if (this.buffer[25] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[25] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Viewing Angle");
        if (this.buffer[26] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[26] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Zenith Angle");
        if (this.buffer[27] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[27] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Avg CO2");
        if (this.buffer[28] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[28] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Convective Available Potential Energy");
        if (this.buffer[65] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[65] / 1.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Convection Inhibition");
        if (this.buffer[66] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[66] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Lifting Condensation Level Pressure");
        if (this.buffer[67] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[67] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Equilibrium Pressure Level");
        if (this.buffer[68] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[68] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Free Convection Level Pressure");
        if (this.buffer[69] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[69] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Lifting Condensation Level Temperature");
        if (this.buffer[70] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[70] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Free Convection Level Temperature");
        if (this.buffer[71] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[71] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Potential Temp Of Lifted Parcel");
        if (this.buffer[72] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[72] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Equiv Potential Temp Of Lifted Parcel");
        if (this.buffer[73] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[73] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Lifted Index");
        if (this.buffer[74] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[74] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Pressure 1");
        if (this.buffer[75] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[75] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Pressure 2");
        if (this.buffer[76] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[76] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Fraction 1");
        if (this.buffer[77] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[77] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Fraction 2");
        if (this.buffer[78] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[78] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        for (int i = 0; i < 26; ++i) {
            vector4 = new Vector(2);
            vector4.add("Ispare Value " + (i + 1));
            if (this.buffer[39 + i] != Short.MIN_VALUE) {
                vector4.add("" + this.buffer[39 + i]);
            } else {
                vector4.add("not available");
            }
            vector3.add(vector4);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    private Vector buildLevelDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Pressure");
        vector2.add("Temperature");
        vector2.add("Water Vapor\nMixing Ratio");
        vector2.add("Ozone\nClmn Dnsty");
        vector2.add("Water Liquid\nClmn Dnsty");
        vector2.add("CO\nClmn Dnsty");
        vector2.add("Methane\nClmn Dnsty");
        vector2.add("CO2\nClmn Dnsty");
        vector2.add("Ice Flag");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 0; i <= 100; ++i) {
            serializable = new Vector<String>(6);
            if (this.buffer[99 + i] != Short.MIN_VALUE) {
                if (i < 20) {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[99 + i] / 100.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[99 + i] / 10.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[199 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[199 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[299 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[299 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[399 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[399 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[499 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[499 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[699 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[699 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[799 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[799 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[899 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[899 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[599 + i] == 0) {
                ((Vector)serializable).add("0: Water");
            } else if (this.buffer[599 + i] == 1) {
                ((Vector)serializable).add("1: Ice");
            } else if (this.buffer[599 + i] == Short.MIN_VALUE) {
                ((Vector)serializable).add(" ");
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }
}

