/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GoesRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public GoesRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public GoesRecord(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public GoesRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[400];
        for (int i = 0; i < 400; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        return "";
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "";
        return string;
    }

    public int getTerrain() {
        return Short.MIN_VALUE;
    }

    public boolean hasSeaNonseaValue() {
        return false;
    }

    public int getSeaNonseaValue() {
        return Short.MIN_VALUE;
    }

    public boolean hasQCFlag() {
        return false;
    }

    public boolean getQCFlag() {
        return true;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return 0;
    }

    public int getCloudFlagForNarcs() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return true;
    }

    public int getDayNightFlag() {
        int n = 0;
        float f = (float)this.buffer[90] / 100.0f;
        if (f <= 90.0f) {
            n = 1;
        }
        return n;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        float[] fArray = this.getPressureLevels();
        for (int i = fArray.length - 1; i >= 0; --i) {
            if (fArray[i] == -999.99f) continue;
            f = fArray[i];
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription(), "   1st Guess"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 1};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[2];
        if (!this.containsData()) {
            for (int i = 0; i < 2; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (n = fArray2.length - 1; n >= 0; --n) {
                if (fArray2[n] == -999.99f) continue;
                profileArray[0].addItem(fArray[n], fArray2[n]);
            }
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 0);
            fArray2 = this.getRetrievedGuessTemps();
            for (n = fArray2.length - 1; n >= 0; --n) {
                if (!(fArray2[n] > 0.0f)) continue;
                profileArray[1].addItem(fArray[n], fArray2[n]);
            }
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[2];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            int n;
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (n = fArray2.length - 1; n >= 0; --n) {
                if (fArray2[n] == -999.99f || !(fArray[n] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray[n], fArray2[n]);
            }
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 1);
            fArray2 = this.getRetrievedGuessDewpoints();
            for (n = fArray2.length - 1; n >= 0; --n) {
                if (!(fArray2[n] > -999.99f) || !(fArray[n] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[1].addItem(fArray[n], fArray2[n]);
            }
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[2];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n >= 6) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 3) {
                float[] fArray2 = this.getRetrievedTemps();
                if (n == 3) {
                    fArray2 = this.getRetrievedGuessTemps();
                }
                float[] fArray3 = new float[fArray2.length];
                float[] fArray4 = new float[fArray.length];
                for (int i = 0; i < fArray2.length; ++i) {
                    fArray3[i] = fArray2[fArray2.length - 1 - i];
                    fArray4[i] = fArray[fArray.length - 1 - i];
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray4);
            } else {
                float[] fArray5 = this.getRetrievedDewpoints();
                if (n == 4 || n == 5) {
                    fArray5 = this.getRetrievedGuessWVapors();
                }
                float[] fArray6 = new float[fArray5.length];
                float[] fArray7 = new float[fArray.length];
                for (int i = 0; i < fArray5.length; ++i) {
                    fArray6[i] = fArray5[fArray5.length - 1 - i];
                    fArray7[i] = fArray[fArray.length - 1 - i];
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray6, fArray7);
                if (f2 != -32768.0f && (n == 1 || n == 4)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        int n2;
        Vector[] vectorArray = new Vector[]{new Vector(4), new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[fArray.length - 1 - i];
        }
        float[] fArray3 = this.getRetrievedTemps();
        float[] fArray4 = new float[fArray3.length];
        for (int i = 0; i < fArray3.length; ++i) {
            fArray4[i] = fArray3[fArray3.length - 1 - i];
        }
        float[] fArray5 = this.getRetrievedDewpoints();
        float[] fArray6 = new float[fArray5.length];
        for (n2 = 0; n2 < fArray5.length; ++n2) {
            fArray6[n2] = fArray5[fArray5.length - 1 - n2];
        }
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray4);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray6);
        fArray3 = this.getRetrievedGuessTemps();
        fArray4 = new float[fArray3.length];
        for (n2 = 0; n2 < fArray3.length; ++n2) {
            fArray4[n2] = fArray3[fArray3.length - 1 - n2];
        }
        fArray5 = this.getRetrievedGuessDewpoints();
        fArray6 = new float[fArray5.length];
        for (n2 = 0; n2 < fArray5.length; ++n2) {
            fArray6[n2] = fArray5[fArray5.length - 1 - n2];
        }
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray4);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray6);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[40];
        for (int i = 0; i < 40; ++i) {
            fArray[i] = this.buffer[i + 116] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 116] / 10.0f;
        }
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[40];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 40; ++i) {
            fArray[i] = this.buffer[i + 157] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 157] / 100.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[40];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 40; ++i) {
            fArray[i] = this.buffer[i + 198] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 198] / 100.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedGuessTemps() {
        float[] fArray = new float[40];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 40; ++i) {
            fArray[i] = this.buffer[i + 280] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 280] / 100.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedGuessWVapors() {
        float[] fArray = new float[19];
        return fArray;
    }

    private float[] getRetrievedGuessDewpoints() {
        float[] fArray = new float[40];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 40; ++i) {
            fArray[i] = this.buffer[i + 321] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 321] / 100.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getObservedBTemps() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 17] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 17] / 100.0f;
        }
        return fArray;
    }

    private float[] getBiasCorrectedBTemps() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 35] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 35] / 100.0f;
        }
        return fArray;
    }

    private float[] getFirstGuessBTemps() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 53] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 53] / 100.0f;
        }
        return fArray;
    }

    private float[] getSoundingBTemps() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 71] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 71] / 100.0f;
        }
        return fArray;
    }

    private double convertToMixingRatio(float f, double d, float f2) {
        double d2;
        double d3 = 0.0;
        double d4 = 6.11 * Math.exp(21.874 * (d - 273.16) / (d - 7.66));
        double d5 = 622.0 * d4 / ((double)f - d4);
        d4 = 6.11 * Math.exp(17.269 * (d - 273.16) / (d - 35.86));
        double d6 = 622.0 * d4 / ((double)f - d4);
        double d7 = Math.abs(d5 - (double)f2);
        d3 = d7 < (d2 = Math.abs(d6 - (double)f2)) ? d5 : d6;
        return d3;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLevelDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
            Vector vector4 = this.buildBrightnessTemperatureTable();
            for (int i = 0; i < vector4.size(); ++i) {
                vector.add((JLabel)vector4.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Satellite");
        if (this.buffer[397] == 1) {
            vector4.add("East");
        } else if (this.buffer[397] == 2) {
            vector4.add("West");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame");
        if (this.buffer[398] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[398]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("User Modification Flag");
        if (this.buffer[1] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Serial ID Number");
        if (this.buffer[2] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Channel Flags 1-6");
        if (this.buffer[9] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[9]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Channel Flags 7-12");
        if (this.buffer[10] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[10]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Channel Flags 13-18");
        if (this.buffer[11] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[11]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality Test Flags 1-5");
        if (this.buffer[12] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[12]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality Test Flags 6-10");
        if (this.buffer[13] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[13]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Skin Temp Chan Selection Flag");
        if (this.buffer[14] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[14]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Recursive Filter Flag");
        if (this.buffer[15] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[15]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Detector Number");
        if (this.buffer[16] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[16]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Bi-directional Reflectance");
        if (this.buffer[89] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[89] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Zenith Angle");
        if (this.buffer[90] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[90] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Local Zenith Angle");
        if (this.buffer[91] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[91] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Conv Available Pot Energy");
        if (this.buffer[92] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[92] / 1.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Retrieval Type");
        if (this.buffer[95] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[95]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Skin Temperature");
        if (this.buffer[96] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[96] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Total Precipitable Water");
        if (this.buffer[97] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[97] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Lifted Index");
        if (this.buffer[98] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[98] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Guess TPW");
        if (this.buffer[99] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[99] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Guess Lifted Index");
        if (this.buffer[100] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[100] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Precipitable Water (1000-900 mb)");
        if (this.buffer[101] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[101] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Precipitable Water (900-700 mb)");
        if (this.buffer[102] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[102] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Precipitable Water (700-300 mb)");
        if (this.buffer[103] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[103] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Long Wave Flux");
        if (this.buffer[104] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[104] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    private Vector buildLevelDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Pressure");
        vector2.add("Temperature");
        vector2.add("1st Guess\nTemperature");
        vector2.add("Dewpoint\nTemperature");
        vector2.add("1st Guess\nDwpt Temp");
        vector2.add("Geopotential\nHeight");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 40; i >= 0; --i) {
            serializable = new Vector<String>(6);
            if (this.buffer[115 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[115 + i] / 10.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[156 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[156 + i] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[279 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[279 + i] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[197 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[197 + i] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[320 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[320 + i] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[238 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + this.buffer[238 + i]);
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }

    private Vector buildBrightnessTemperatureTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Brightness Temperatures</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Level");
        vector2.add("Observed\n(TBO)");
        vector2.add("Bias Corrected\n(TBB)");
        vector2.add("1st Guess\n(TBC)");
        vector2.add("Sounding\n(TBR)");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 0; i < 18; ++i) {
            serializable = new Vector<String>(5);
            ((Vector)serializable).add("" + (i + 1));
            if (this.buffer[i + 17] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[i + 17] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[i + 35] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[i + 35] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[i + 53] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[i + 53] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[i + 71] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[i + 71] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }
}

