/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class IasiRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public IasiRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public IasiRecord(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public IasiRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[1500];
        for (int i = 0; i < 1500; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        String string = "";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "" + this.buffer[29];
        return string;
    }

    public int getTerrain() {
        return this.buffer[29];
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = 0;
        if (this.getTerrain() != 2) {
            n = 1;
        }
        return n;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        if (this.buffer[33] != 0) {
            bl = false;
        }
        return bl;
    }

    public boolean hasCloudFlag() {
        return true;
    }

    public int getCloudFlag() {
        int n = Short.MIN_VALUE;
        int n2 = this.buffer[274];
        if (n2 == 0) {
            n = 0;
        } else {
            float f = 0.0f;
            for (int i = 0; i < n2; ++i) {
                if (this.buffer[283 + i] == Short.MIN_VALUE) continue;
                f += (float)this.buffer[283 + i];
            }
            if (f == 0.0f) {
                n = 0;
            } else if (f > 0.0f && f <= 20.0f) {
                n = 1;
            } else if (f > 20.0f) {
                n = 2;
            }
        }
        return n;
    }

    public int getCloudFlagForNarcs() {
        int n = this.getCloudFlag();
        if (n > 1) {
            n = 1;
        }
        return n;
    }

    public boolean hasDayNightFlag() {
        return true;
    }

    public int getDayNightFlag() {
        int n = Short.MIN_VALUE;
        if (this.buffer[22] != Short.MIN_VALUE) {
            float f = (float)this.buffer[22] / 128.0f;
            n = f < 90.0f ? 1 : 0;
        }
        return n;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        if (this.buffer[25] != Short.MIN_VALUE) {
            f = (float)this.buffer[25] / 10.0f;
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(this.getSurfacePressure()));
        float f = -999.99f;
        if (this.buffer[26] != Short.MIN_VALUE) {
            f = (float)this.buffer[26] / 64.0f;
        }
        vector.add(new Float(f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        float f = -32768.0f;
        if (this.buffer[275] != Short.MIN_VALUE) {
            f = (float)this.buffer[275] / 10.0f;
        }
        vector.add(new Float(f));
        float f2 = -32768.0f;
        vector.add(new Float(f2));
        float f3 = -32768.0f;
        if (this.buffer[283] != Short.MIN_VALUE) {
            f3 = (float)this.buffer[283] / 100.0f;
        }
        vector.add(new Float(f3));
        boolean bl = false;
        vector.add(new Boolean(bl));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription(), "MIT", "First Guess"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 20, 1};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[3];
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            profileArray[1] = new Profile(0, "   MIT", 0, Color.black, 1, 0);
            float[] fArray3 = this.getMITTemps();
            for (int i = 0; i < fArray3.length; ++i) {
                if (fArray3[i] == -999.99f) continue;
                profileArray[1].addItem(fArray[i], fArray3[i]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            profileArray[2] = new Profile(0, "   1st Guess", 0, Color.black, 1, 0);
            float[] fArray4 = this.getFGTemps();
            for (int i = 0; i < fArray4.length; ++i) {
                if (fArray4[i] == -999.99f) continue;
                profileArray[2].addItem(fArray[i], fArray4[i]);
            }
            profileArray[2].setSurfacePressure(f);
            profileArray[2].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[3];
        profileArray[0] = null;
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getEffectivePressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            profileArray[1] = new Profile(0, "   MIT", 0, Color.black, 1, 1);
            float[] fArray3 = this.getMITDewpoints();
            for (int i = 0; i < fArray3.length; ++i) {
                if (fArray3[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[1].addItem(fArray[i], fArray3[i]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            profileArray[2] = new Profile(0, "   1st Guess", 0, Color.black, 1, 1);
            float[] fArray4 = this.getFGDewpoints();
            for (int i = 0; i < fArray4.length; ++i) {
                if (fArray4[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[2].addItem(fArray[i], fArray4[i]);
            }
            profileArray[2].setSurfacePressure(f);
            profileArray[2].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[3];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getEffectivePressureLevels();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   MIT", 0, Color.black, 1, 1);
            float[] fArray3 = this.getMITWaterVapor();
            for (int i = 0; i < fArray3.length; ++i) {
                if (fArray3[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[1].addItem(fArray2[i], fArray3[i]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
            profileArray[2] = new Profile(0, "   1st Guess", 0, Color.black, 1, 1);
            float[] fArray4 = this.getFGWaterVapor();
            for (int i = 0; i < fArray4.length; ++i) {
                if (fArray4[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[2].addItem(fArray2[i], fArray4[i]);
            }
            profileArray[2].setSurfacePressure(f);
            profileArray[2].trimProfile();
            if (profileArray[2].getNumberOfPoints() == 0) {
                profileArray[2] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            if (n == 6 || n == 7 || n == 8) {
                f2 = -32768.0f;
            }
            if (n >= 12) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 3 || n == 9) {
                float[] fArray = this.getPressureLevels();
                float[] fArray2 = this.getRetrievedTemps();
                if (n == 3) {
                    fArray2 = this.getFGTemps();
                } else if (n == 9) {
                    fArray2 = this.getMITTemps();
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray = this.getEffectivePressureLevels();
                float[] fArray3 = this.getRetrievedWaterVapor();
                if (n == 4 || n == 5) {
                    fArray3 = this.getFGWaterVapor();
                } else if (n == 10 || n == 11) {
                    fArray3 = this.getMITWaterVapor();
                }
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && (n == 1 || n == 4 || n == 10)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4), new Vector(4), new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getEffectivePressureLevels();
        float[] fArray3 = this.getRetrievedTemps();
        float[] fArray4 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray3);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray4);
        float[] fArray5 = this.getMITTemps();
        float[] fArray6 = this.getMITDewpoints();
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray5);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray6);
        float[] fArray7 = this.getFGTemps();
        float[] fArray8 = this.getFGDewpoints();
        vectorArray[2].add(fArray);
        vectorArray[2].add(fArray7);
        vectorArray[2].add(fArray2);
        vectorArray[2].add(fArray8);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[]{0.016f, 0.038f, 0.076f, 0.136f, 0.224f, 0.345f, 0.506f, 0.713f, 0.975f, 1.297f, 1.687f, 2.152f, 2.7f, 3.339f, 4.077f, 4.92f, 5.877f, 6.956f, 8.165f, 9.511f, 11.0f, 12.6f, 14.4f, 16.4f, 18.5f, 20.9f, 23.4f, 26.1f, 29.1f, 32.2f, 35.6f, 39.2f, 43.1f, 47.1f, 51.5f, 56.1f, 60.9f, 66.1f, 71.5f, 77.2f, 83.2f, 89.5f, 96.1f, 103.0f, 110.2f, 117.7f, 125.6f, 133.8f, 142.3f, 151.2f, 160.4f, 170.0f, 180.0f, 190.3f, 200.9f, 212.0f, 223.4f, 235.2f, 247.4f, 259.9f, 272.9f, 286.2f, 300.0f, 314.1f, 328.6f, 343.6f, 358.9f, 374.7f, 390.8f, 407.4f, 424.4f, 441.8f, 459.7f, 477.9f, 496.6f, 515.7f, 535.2f, 555.1f, 575.5f, 596.3f, 617.5f, 639.1f, 661.1f, 683.6f, 706.5f, 729.8f, 753.6f, 777.7f, 802.3f, 827.3f, 852.7f, 878.6f, 904.8f, 931.5f, 958.5f, 986.0f, 1013.9f, 1042.2f, 1070.9f, 1100.0f};
        return fArray;
    }

    private float getPressureLevelValue(int n) {
        float f = -999.99f;
        float[] fArray = this.getPressureLevels();
        f = fArray[n];
        return f;
    }

    private float[] getEffectivePressureLevels() {
        float[] fArray = new float[]{0.009f, 0.025f, 0.055f, 0.104f, 0.177f, 0.28f, 0.42f, 0.604f, 0.837f, 1.128f, 1.483f, 1.91f, 2.416f, 3.009f, 3.696f, 4.485f, 5.384f, 6.401f, 7.544f, 8.821f, 10.2f, 11.8f, 13.5f, 15.4f, 17.4f, 19.7f, 22.1f, 24.7f, 27.6f, 30.6f, 33.9f, 37.4f, 41.1f, 45.1f, 49.3f, 53.7f, 58.5f, 63.5f, 68.7f, 74.3f, 80.1f, 86.3f, 92.7f, 99.5f, 106.5f, 113.9f, 121.6f, 129.7f, 138.0f, 146.7f, 155.8f, 165.2f, 175.0f, 185.1f, 195.6f, 206.4f, 217.6f, 229.2f, 241.2f, 253.6f, 266.3f, 279.5f, 293.0f, 307.0f, 321.3f, 336.0f, 351.2f, 366.7f, 382.7f, 399.1f, 415.9f, 433.1f, 450.7f, 468.7f, 487.2f, 506.1f, 525.4f, 545.1f, 565.2f, 585.8f, 606.8f, 628.2f, 650.1f, 672.3f, 695.0f, 718.1f, 741.6f, 765.6f, 790.0f, 814.8f, 840.0f, 865.6f, 891.6f, 918.1f, 944.9f, 972.2f, 1000.0f, 1028.0f, 1056.5f, 1085.3f};
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 499] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 499] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getMITTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 599] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 599] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getFGTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 699] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 699] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getEffectivePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 799] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 799] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getMITWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getEffectivePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 899] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 899] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getFGWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getEffectivePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 999] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 999] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getEffectivePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getMITDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getMITWaterVapor();
        float[] fArray3 = this.getEffectivePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getFGDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getFGWaterVapor();
        float[] fArray3 = this.getEffectivePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLevelDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame");
        if (this.buffer[12] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[12]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scan Line");
        if (this.buffer[13] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[13]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Field Of View");
        if (this.buffer[14] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[14]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("View Angle");
        if (this.buffer[19] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[19] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Solar Zenith Angle");
        if (this.buffer[22] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[22] / 128.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Satellite Height");
        if (this.buffer[20] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[20] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Height");
        if (this.buffer[23] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[23]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Land Fraction");
        if (this.buffer[24] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[24] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MW Surface Class");
        if (this.buffer[29] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[29]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure");
        if (this.buffer[25] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[25] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Skin Temperature");
        if (this.buffer[26] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[26] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MIT Skin Temperature");
        if (this.buffer[27] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[27] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("1st Guess Skin Temperature");
        if (this.buffer[28] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[28] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("MW Surface Emissivity");
        if (this.buffer[30] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[30]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Column Averaged CO2");
        if (this.buffer[21] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[21] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Number Of Cloud Layers");
        if (this.buffer[274] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[274]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        String string = "";
        String string2 = "";
        for (int i = 0; i < this.buffer[274]; ++i) {
            if (i != 0) {
                string = string + " / ";
                string2 = string2 + " / ";
            }
            string = this.buffer[275 + i] != Short.MIN_VALUE ? string + EdgeUtils.oneDigit((float)this.buffer[275 + i] / 10.0f) : string + "na";
            string2 = this.buffer[283 + i] != Short.MIN_VALUE ? string2 + EdgeUtils.twoDigits((float)this.buffer[283 + i] / 100.0f) : string2 + "na";
        }
        vector4 = new Vector(2);
        vector4.add("Cloud Top Pressures");
        vector4.add(string);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top Fractional Coverage");
        vector4.add(string2);
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLevelDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Pressure");
        vector2.add("Effective\nPressure");
        vector2.add("Temperature");
        vector2.add("MIT\nTemperature");
        vector2.add("1st Guess\nTemperature");
        vector2.add("Water Vapor\nMixing Ratio");
        vector2.add("MIT WVMR");
        vector2.add("1st Guess\nWVMR");
        vector2.add("Ice Liquid\nFlag");
        vector2.add("CO2 Dry\nMixing Ratio");
        vector2.add("SO2\nMixing Ratio");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 0; i < 100; ++i) {
            serializable = new Vector<String>(11);
            if (this.buffer[299 + i] != Short.MIN_VALUE) {
                if (i < 20) {
                    ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[299 + i] / 1000.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[299 + i] / 10.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[399 + i] != Short.MIN_VALUE) {
                if (i < 20) {
                    ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[399 + i] / 1000.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[399 + i] / 10.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[499 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[499 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[599 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[599 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[699 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[699 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[799 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[799 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[899 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[899 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[999 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[999 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1099 + i] != Short.MIN_VALUE) {
                if (this.buffer[1099 + i] == 0) {
                    ((Vector)serializable).add("Water");
                } else if (this.buffer[1099 + i] == 1) {
                    ((Vector)serializable).add("Ice");
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1199 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[1199 + i] / 1.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1299 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[1299 + i] / 1.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }
}

