/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class Matchup {
    private DataGroup[] data_group_array;
    private int num_data_groups;
    private int[] group_type;
    private int[] group_length;
    private String[] group_name;
    private int raob_index;

    public Matchup(short[] sArray, int n, int[] nArray, int[] nArray2, String[] stringArray) {
        this.num_data_groups = n;
        this.group_length = nArray;
        this.group_type = nArray2;
        this.group_name = stringArray;
        this.createDataGroups();
        this.addDataBuffer(sArray);
    }

    public Matchup(int n, int[] nArray, int[] nArray2, String[] stringArray) {
        this.num_data_groups = n;
        this.group_length = nArray;
        this.group_type = nArray2;
        this.group_name = stringArray;
        this.createDataGroups();
    }

    private void createDataGroups() {
        this.data_group_array = new DataGroup[this.num_data_groups];
        this.raob_index = Short.MIN_VALUE;
        boolean bl = false;
        for (int i = 0; i < this.num_data_groups; ++i) {
            DataGroup dataGroup;
            if (this.group_type[i] == 1) {
                dataGroup = new RaobRecord(this.group_name[i], 1);
                this.data_group_array[i] = dataGroup;
                if (this.raob_index != Short.MIN_VALUE) continue;
                this.raob_index = i;
                continue;
            }
            if (this.group_type[i] == 0) {
                dataGroup = new RaobRecord(this.group_name[i], 0);
                this.data_group_array[i] = dataGroup;
                if (this.raob_index != Short.MIN_VALUE) continue;
                this.raob_index = i;
                continue;
            }
            if (this.group_type[i] == 100) {
                dataGroup = new AtovsRecord(this.group_name[i], 100);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 150) {
                dataGroup = new Atovs1000Record(this.group_name[i], 150);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 200) {
                dataGroup = new GoesRecord(this.group_name[i], 200);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 300) {
                dataGroup = new Mirs02Record(this.group_name[i], 300);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 301) {
                dataGroup = new Mirs02Record(this.group_name[i], 301);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 401) {
                dataGroup = new AirsRecord(this.group_name[i], 401);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 400) {
                dataGroup = new AirsVersion1Record(this.group_name[i], 400);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 500) {
                dataGroup = new CosmicRecord(this.group_name[i], 500);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 501) {
                dataGroup = new CosmicRecord(this.group_name[i], 501);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 502) {
                dataGroup = new CosmicRecord(this.group_name[i], 502);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 550) {
                dataGroup = new CosmicGPRSORecord(this.group_name[i], 550);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 600) {
                dataGroup = new IasiRecord(this.group_name[i], 600);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 601) {
                dataGroup = new EUIasiRecord(this.group_name[i], 601);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 190) {
                dataGroup = new EUAtovsRecord(this.group_name[i], 190);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            if (this.group_type[i] == 2000) {
                dataGroup = new FocusDayEDRRecord(this.group_name[i], 2000);
                this.data_group_array[i] = dataGroup;
                continue;
            }
            System.out.println("Invalid data group: " + this.group_type[i]);
        }
    }

    public void addDataBuffer(int n, short[] sArray) {
        this.data_group_array[n].addDataBuffer(sArray);
    }

    public void addDataBuffer(short[] sArray) {
        int n = 0;
        for (int i = 0; i < this.num_data_groups; ++i) {
            int n2 = this.group_length[i] / 2;
            short[] sArray2 = new short[n2];
            for (int j = 0; j < n2; ++j) {
                sArray2[j] = sArray[n + j];
            }
            this.data_group_array[i].addDataBuffer(sArray2);
            n += n2;
        }
    }

    public void addDataBuffer(byte[] byArray, boolean[] blArray) {
        try {
            for (int i = 0; i < this.num_data_groups; ++i) {
                if (!blArray[0]) continue;
                int n = this.group_length[i] / 2;
                short[] sArray = new short[n];
                int n2 = 0;
                for (int j = 0; j < i; ++j) {
                    n2 += this.group_length[j];
                }
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                dataInputStream.skipBytes(n2);
                for (int j = 0; j < n; ++j) {
                    sArray[j] = dataInputStream.readShort();
                }
                this.data_group_array[i].addDataBuffer(sArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getNumberOfDataGroups() {
        return this.num_data_groups;
    }

    public DataGroup getDataGroup(int n) {
        return this.data_group_array[n];
    }

    public boolean groupContainsData(int n) {
        return this.data_group_array[n].containsData();
    }

    public String getGroupDescription(int n) {
        return this.data_group_array[n].getGroupDescription();
    }

    public int getRaobGroupNumber() {
        return this.raob_index;
    }

    public DataGroup getRaobRecord() {
        DataGroup dataGroup = null;
        if (this.raob_index != Short.MIN_VALUE) {
            dataGroup = this.data_group_array[this.raob_index];
        }
        return dataGroup;
    }

    public Vector getGroupCollocationInfo(int n) {
        return this.data_group_array[n].getGroupCollocationInfo();
    }

    public Vector[] getProfileData(int n) {
        return this.data_group_array[n].getProfileData();
    }

    public Vector getDataGroupData(int n) {
        return this.data_group_array[n].getDataGroupData();
    }

    public Vector[] getSurfaceData() {
        Vector[] vectorArray = new Vector[this.data_group_array.length];
        for (int i = 0; i < this.data_group_array.length; ++i) {
            vectorArray[i] = this.data_group_array[i].getSurfaceData();
        }
        return vectorArray;
    }

    public Vector[] getCloudTopData() {
        Vector[] vectorArray = new Vector[this.data_group_array.length];
        for (int i = 0; i < this.data_group_array.length; ++i) {
            vectorArray[i] = this.data_group_array[i].getCloudTopData();
        }
        return vectorArray;
    }

    public Vector getWindData() {
        Vector<float[]> vector = null;
        DataGroup dataGroup = this.getRaobRecord();
        if (dataGroup != null && dataGroup instanceof RaobRecord) {
            RaobRecord raobRecord = (RaobRecord)dataGroup;
            short[] sArray = raobRecord.getDriftBuffer();
            float[] fArray = new float[118];
            short[] sArray2 = new short[118];
            short[] sArray3 = new short[118];
            short[] sArray4 = new short[118];
            for (int i = 0; i < 118; ++i) {
                fArray[i] = (float)sArray[i + 56] / 10.0f;
                sArray2[i] = sArray[i + 646];
                sArray3[i] = sArray[i + 764];
                sArray4[i] = sArray[i + 882];
            }
            vector = new Vector<float[]>(4);
            vector.add(fArray);
            vector.add(sArray2);
            vector.add(sArray3);
            vector.add(sArray4);
        }
        return vector;
    }
}

