/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class Mirs02Record
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public Mirs02Record(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public Mirs02Record(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public Mirs02Record() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        int n;
        this.contains_data = false;
        if (this.data_group_type == 300) {
            this.buffer = Mirs02Record.convertToLatestFormat(this.data_group_type, sArray);
        } else {
            this.buffer = new short[2400];
            for (n = 0; n < 2400; ++n) {
                this.buffer[n] = sArray[n];
            }
        }
        this.contains_data = false;
        for (n = 0; !this.contains_data && n < this.buffer.length; ++n) {
            if (this.buffer[n] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        float f = (float)this.buffer[1071] / 10.0f;
        String string = " (" + EdgeUtils.oneDigit(f) + ")";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "";
        if (this.buffer[1053] == 0) {
            string = "sea";
        } else if (this.buffer[1053] == 1) {
            string = "ice";
        } else if (this.buffer[1053] == 2) {
            string = "land";
        } else if (this.buffer[1053] == 3) {
            string = "snow";
        }
        return string;
    }

    public int getTerrain() {
        int n = 0;
        if (this.buffer[1053] == 2) {
            n = 1;
        } else if (this.buffer[1053] == 1) {
            n = 10;
        } else if (this.buffer[1053] == 3) {
            n = 11;
        }
        return n;
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = 0;
        if (this.getTerrain() != 0) {
            n = 1;
        }
        return n;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        if (this.buffer[1056] != 0 && this.buffer[1056] != 1) {
            bl = false;
        }
        boolean bl2 = (this.buffer[1057] & 8) == 8;
        bl = bl && !bl2;
        return bl;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return Short.MIN_VALUE;
    }

    public int getCloudFlagForNarcs() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return false;
    }

    public int getDayNightFlag() {
        return Short.MIN_VALUE;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        if (this.buffer[1052] != Short.MIN_VALUE) {
            f = (float)this.buffer[1052] / 10.0f;
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription()};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || fArray[i] == -999.99f) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(this.getSurfacePressure());
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[]{null};
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getMoisturePressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || fArray[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f = EdgeUtils.convertToDewPoint(fArray2[i], fArray[i]);
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].setSurfacePressure(this.getSurfacePressure());
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[1];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            PressureLevels pressureLevels = new PressureLevels();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getMoisturePressureLevels();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || fArray2[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].setSurfacePressure(this.getSurfacePressure());
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n >= 3) {
                f2 = -32768.0f;
            } else if (n == 0) {
                float[] fArray2 = this.getRetrievedTemps();
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray3 = this.getRetrievedWaterVapor();
                fArray = this.getMoisturePressureLevels();
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && n == 1) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getMoisturePressureLevels();
        float[] fArray4 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray3);
        vectorArray[0].add(fArray4);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[]{0.009f, 0.025f, 0.055f, 0.104f, 0.177f, 0.28f, 0.42f, 0.604f, 0.837f, 1.128f, 1.483f, 1.91f, 2.416f, 3.009f, 3.696f, 4.485f, 5.384f, 6.401f, 7.544f, 8.821f, 10.2f, 11.8f, 13.5f, 15.4f, 17.4f, 19.7f, 22.1f, 24.7f, 27.6f, 30.6f, 33.9f, 37.4f, 41.1f, 45.1f, 49.3f, 53.7f, 58.5f, 63.5f, 68.7f, 74.3f, 80.1f, 86.3f, 92.7f, 99.5f, 106.5f, 113.9f, 121.6f, 129.7f, 138.0f, 146.7f, 155.8f, 165.2f, 175.0f, 185.1f, 195.6f, 206.4f, 217.6f, 229.2f, 241.2f, 253.6f, 266.3f, 279.5f, 293.0f, 307.0f, 321.3f, 336.0f, 351.2f, 366.7f, 382.7f, 399.1f, 415.9f, 433.1f, 450.7f, 468.7f, 487.2f, 506.1f, 525.4f, 545.1f, 565.2f, 585.8f, 606.8f, 628.2f, 650.1f, 672.3f, 695.0f, 718.1f, 741.6f, 765.6f, 790.0f, 814.8f, 840.0f, 865.6f, 891.6f, 918.1f, 944.9f, 972.2f, 1000.0f, 1028.0f, 1056.5f, 1085.3f};
        return fArray;
    }

    private float getPressureLevelValue(int n) {
        float f = -999.99f;
        float[] fArray = this.getPressureLevels();
        f = fArray[n];
        return f;
    }

    private float[] getMoisturePressureLevels() {
        float[] fArray = new float[]{0.009f, 0.025f, 0.055f, 0.104f, 0.177f, 0.28f, 0.42f, 0.604f, 0.837f, 1.128f, 1.483f, 1.91f, 2.416f, 3.009f, 3.696f, 4.485f, 5.384f, 6.401f, 7.544f, 8.821f, 10.2f, 11.8f, 13.5f, 15.4f, 17.4f, 19.7f, 22.1f, 24.7f, 27.6f, 30.6f, 33.9f, 37.4f, 41.1f, 45.1f, 49.3f, 53.7f, 58.5f, 63.5f, 68.7f, 74.3f, 80.1f, 86.3f, 92.7f, 99.5f, 106.5f, 113.9f, 121.6f, 129.7f, 138.0f, 146.7f, 155.8f, 165.2f, 175.0f, 185.1f, 195.6f, 206.4f, 217.6f, 229.2f, 241.2f, 253.6f, 266.3f, 279.5f, 293.0f, 307.0f, 321.3f, 336.0f, 351.2f, 366.7f, 382.7f, 399.1f, 415.9f, 433.1f, 450.7f, 468.7f, 487.2f, 506.1f, 525.4f, 545.1f, 565.2f, 585.8f, 606.8f, 628.2f, 650.1f, 672.3f, 695.0f, 718.1f, 741.6f, 765.6f, 790.0f, 814.8f, 840.0f, 865.6f, 891.6f, 918.1f, 944.9f, 972.2f, 1000.0f, 1028.0f, 1056.5f, 1085.3f};
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 221] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 221] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 321] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 321] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getMoisturePressureLevels();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLayerDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Profile Index");
        if (this.buffer[14] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[14]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame Number");
        if (this.buffer[15] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[15]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scan Position");
        if (this.buffer[16] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[16]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Orbital Node");
        if (this.buffer[17] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[17]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Terrain");
        vector4.add(this.getTerrainString());
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Angle");
        if (this.buffer[1049] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1049] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Wind Speed");
        if (this.buffer[1050] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1050] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Skin Temperature");
        if (this.buffer[1051] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1051] / 64.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure");
        if (this.buffer[1052] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[1052] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("U-Direction Wind Speed");
        if (this.buffer[1054] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1054] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("V-Direction Wind Speed");
        if (this.buffer[1055] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1055] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("QC Flags");
        if (this.buffer[1056] != Short.MIN_VALUE && this.buffer[1056] != Short.MIN_VALUE && this.buffer[1056] != Short.MIN_VALUE && this.buffer[1056] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1056] + " / " + this.buffer[1057] + " / " + this.buffer[1058] + " / " + this.buffer[1059]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Chi Square");
        if (this.buffer[1055] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[1071] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("TPW");
        if (this.buffer[1160] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[1160] / 10.0f) + " mm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("CLW");
        if (this.buffer[1161] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1161] / 100.0f) + " mm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Rain Water Path");
        if (this.buffer[1162] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1162] / 100.0f) + " mm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Snow Water Path");
        if (this.buffer[1163] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1163] / 100.0f) + " mm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Ice Water Path");
        if (this.buffer[1164] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1164] / 100.0f) + " mm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Graupel Water Path");
        if (this.buffer[1165] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1165] / 100.0f) + " mm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Top");
        if (this.buffer[1166] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1166] / 100.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Base");
        if (this.buffer[1167] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1167] / 100.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Thickness");
        if (this.buffer[1168] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1168] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Rain Rate");
        if (this.buffer[1169] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[1169] / 10.0f) + " mm/hr");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Rain Flag");
        if (this.buffer[1170] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1170]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Snow Falling Rate");
        if (this.buffer[1171] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[1171] / 10.0f) + " mm/hr");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Precipitation Type");
        if (this.buffer[1172] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1172]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Snow Cover");
        if (this.buffer[1173] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1173]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Snow Water Equivalent");
        if (this.buffer[1174] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1174] / 100.0f) + " cm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Sea Ice Concentration");
        if (this.buffer[1175] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[1175] + "%");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Soil Moisture");
        if (this.buffer[1176] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[1176] / 100.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLayerDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Layer Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Pressure");
        vector2.add("Temperature");
        vector2.add("Absorbtion\n1");
        vector2.add("Absorbtion\n2");
        vector2.add("Cloud\nLiquid Water");
        vector2.add("Rain");
        vector2.add("Snow");
        vector2.add("Ice");
        vector2.add("Graupel");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 0; i < 100; ++i) {
            serializable = new Vector<String>(9);
            if (this.buffer[20 + i] != Short.MIN_VALUE) {
                if (i < 30) {
                    ((Vector)serializable).add("" + EdgeUtils.threeDigits((float)this.buffer[20 + i] / 1000.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[20 + i] / 10.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[221 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[221 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[321 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[321 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[421 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[421 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[521 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[521 + i] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[621 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[621 + i] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[721 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[721 + i] / 1.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[821 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[821 + i] / 1.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[921 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[921 + i] / 100.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }

    public static short[] convertToLatestFormat(int n, short[] sArray) {
        int n2;
        short[] sArray2 = new short[2400];
        for (n2 = 0; n2 < sArray2.length; ++n2) {
            sArray2[n2] = Short.MIN_VALUE;
        }
        for (n2 = 0; n2 < 1056; ++n2) {
            sArray2[n2] = sArray[n2];
        }
        sArray2[1071] = sArray[1071];
        for (n2 = 0; n2 < 20; ++n2) {
            sArray2[1132 + n2] = sArray[1132 + n2];
        }
        return sArray2;
    }
}

