/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class Profile
implements Externalizable {
    static final long serialVersionUID = 1L;
    private int class_version = 3;
    private int identification;
    private boolean visible;
    private int number_of_points;
    private Color line_color;
    private int line_thickness;
    private int line_style;
    private int profile_type;
    private String label;
    private float[] values;
    private float[] pressures;
    private float surface_pressure;
    public int UNDEFINED = 0;
    public int TEMPERATURE = 1;
    public int WATERVAPOR = 2;
    public int DEWPOINT = 3;

    public Profile(int n, String string, int n2, Color color, int n3, int n4) {
        this.identification = n;
        this.label = string;
        this.profile_type = n2;
        this.line_color = color;
        this.line_thickness = n3;
        this.line_style = n4;
        this.number_of_points = 0;
        this.visible = true;
        this.values = new float[100];
        this.pressures = new float[100];
        for (int i = 0; i < 100; ++i) {
            this.values[i] = -999.99f;
            this.pressures[i] = -999.99f;
        }
        this.surface_pressure = -32768.0f;
    }

    public Profile(String string, float[] fArray, float[] fArray2) {
        this.label = string;
        this.identification = 0;
        this.line_color = Color.black;
        this.line_thickness = 1;
        this.line_style = 1;
        this.visible = true;
        this.profile_type = this.UNDEFINED;
        this.number_of_points = Math.min(fArray.length, fArray2.length);
        this.values = fArray2;
        this.pressures = fArray;
        this.surface_pressure = -32768.0f;
    }

    public Profile() {
        this.identification = 0;
        this.label = "Unnamed profile";
        this.line_color = Color.black;
        this.line_thickness = 1;
        this.line_style = 1;
        this.number_of_points = 0;
        this.visible = true;
        this.profile_type = this.UNDEFINED;
        this.values = new float[100];
        this.pressures = new float[100];
        for (int i = 0; i < 100; ++i) {
            this.values[i] = -999.99f;
            this.pressures[i] = -999.99f;
        }
        this.surface_pressure = -32768.0f;
    }

    public void addItem(float f, float f2) {
        ++this.number_of_points;
        if (this.number_of_points > this.pressures.length) {
            int n;
            float[] fArray = new float[this.pressures.length];
            float[] fArray2 = new float[this.values.length];
            for (n = 0; n < this.pressures.length; ++n) {
                fArray[n] = this.pressures[n];
                fArray2[n] = this.values[n];
            }
            n = this.pressures.length + 100;
            this.pressures = new float[n];
            Arrays.fill(this.pressures, -999.99f);
            this.values = new float[n];
            Arrays.fill(this.values, -999.99f);
            for (int i = 0; i < fArray.length; ++i) {
                this.pressures[i] = fArray[i];
                this.values[i] = fArray2[i];
            }
        }
        this.pressures[this.number_of_points - 1] = f;
        this.values[this.number_of_points - 1] = f2;
    }

    public float getVal(int n) {
        float f = -999.99f;
        if (n < this.values.length) {
            f = this.values[n];
        }
        return f;
    }

    public float getVal(float f) {
        float f2 = -999.99f;
        for (int i = 0; i < this.pressures.length; ++i) {
            if (f != this.pressures[i]) continue;
            f2 = this.values[i];
        }
        return f2;
    }

    public float[] getValues() {
        return this.values;
    }

    public float[] getPressures() {
        return this.pressures;
    }

    public float getPressure(int n) {
        float f = -999.99f;
        if (n < this.pressures.length) {
            f = this.pressures[n];
        }
        return f;
    }

    public void setPressure(int n, float f) {
        this.pressures[n] = f;
    }

    public void trimProfile() {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.pressures.length; ++i) {
            if (this.pressures[i] == -999.99f || this.values[i] == -999.99f) continue;
            ++n2;
        }
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        int n3 = -1;
        for (n = 0; n < this.pressures.length; ++n) {
            if (this.pressures[n] == -999.99f || this.values[n] == -999.99f) continue;
            fArray[++n3] = this.pressures[n];
            fArray2[n3] = this.values[n];
        }
        this.pressures = new float[n2];
        this.values = new float[n2];
        for (n = 0; n < n2; ++n) {
            this.pressures[n] = fArray[n];
            this.values[n] = fArray2[n];
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getNumberOfPoints() {
        return this.number_of_points;
    }

    public int getID() {
        return this.identification;
    }

    public String getLabel() {
        return this.label;
    }

    public int getProfileType() {
        return this.profile_type;
    }

    public void setIndicator(int n) {
        this.identification = n;
        this.profile_type = this.UNDEFINED;
        if (n >= 10000 && n < 10500) {
            this.profile_type = this.TEMPERATURE;
        } else if (n >= 10500 && n < 11000) {
            this.profile_type = this.WATERVAPOR;
        } else if (n >= 11000 && n < 11500) {
            this.profile_type = this.DEWPOINT;
        }
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setProfileType(int n) {
        this.profile_type = n;
    }

    public void setLineColor(Color color) {
        this.line_color = color;
    }

    public Color getLineColor() {
        return this.line_color;
    }

    public void setLineThickness(int n) {
        this.line_thickness = n;
    }

    public int getLineThickness() {
        return this.line_thickness;
    }

    public void setLineStyle(int n) {
        this.line_style = n;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setSurfacePressure(float f) {
        this.surface_pressure = f;
        if (this.surface_pressure == -999.99f) {
            this.surface_pressure = -32768.0f;
        }
    }

    public float getSurfacePressure() {
        return this.surface_pressure;
    }

    public void sortLevels() {
        int n;
        float[] fArray = new float[this.pressures.length];
        for (int i = 0; i < this.pressures.length; ++i) {
            fArray[i] = this.pressures[i];
        }
        Arrays.sort(fArray);
        float[] fArray2 = new float[this.pressures.length];
        float[] fArray3 = new float[this.pressures.length];
        for (n = 0; n < fArray.length; ++n) {
            for (int i = 0; i < this.pressures.length; ++i) {
                if (this.pressures[i] != fArray[n]) continue;
                fArray2[n] = this.pressures[i];
                fArray3[n] = this.values[i];
            }
        }
        for (n = 0; n < this.pressures.length; ++n) {
            this.pressures[n] = fArray2[n];
            this.values[n] = fArray3[n];
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.class_version);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("identification", new Integer(this.identification));
        hashMap.put("visible", new Boolean(this.visible));
        hashMap.put("number_of_points", new Integer(this.number_of_points));
        hashMap.put("line_color", this.line_color);
        hashMap.put("line_thickness", new Integer(this.line_thickness));
        hashMap.put("line_style", new Integer(this.line_style));
        hashMap.put("profile_type", new Integer(this.profile_type));
        hashMap.put("label", this.label);
        hashMap.put("values", this.values);
        hashMap.put("pressures", this.pressures);
        hashMap.put("surface_pressure", new Float(this.surface_pressure));
        objectOutput.writeObject(hashMap);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 1: {
                this.readVersion01(objectInput);
                break;
            }
            case 2: {
                this.readVersion02(objectInput);
                break;
            }
            case 3: {
                this.readVersion03(objectInput);
            }
        }
    }

    private void readVersion01(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.identification = objectInput.readInt();
        this.visible = objectInput.readBoolean();
        this.number_of_points = objectInput.readInt();
        this.line_color = (Color)objectInput.readObject();
        this.line_thickness = objectInput.readInt();
        this.line_style = objectInput.readInt();
        this.profile_type = objectInput.readInt();
        this.label = (String)objectInput.readObject();
        Vector vector = (Vector)objectInput.readObject();
        Vector vector2 = (Vector)objectInput.readObject();
        this.values = new float[vector.size()];
        this.pressures = new float[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            this.values[i] = ((Float)vector.elementAt(i)).floatValue();
            this.pressures[i] = ((Float)vector2.elementAt(i)).floatValue();
        }
        this.UNDEFINED = objectInput.readInt();
        this.TEMPERATURE = objectInput.readInt();
        this.WATERVAPOR = objectInput.readInt();
    }

    private void readVersion02(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.identification = objectInput.readInt();
        this.visible = objectInput.readBoolean();
        this.number_of_points = objectInput.readInt();
        this.line_color = (Color)objectInput.readObject();
        this.line_thickness = objectInput.readInt();
        this.line_style = objectInput.readInt();
        this.profile_type = objectInput.readInt();
        this.label = (String)objectInput.readObject();
        this.values = (float[])objectInput.readObject();
        this.pressures = (float[])objectInput.readObject();
        this.UNDEFINED = objectInput.readInt();
        this.TEMPERATURE = objectInput.readInt();
        this.WATERVAPOR = objectInput.readInt();
    }

    private void readVersion03(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        HashMap hashMap = (HashMap)objectInput.readObject();
        if (hashMap.containsKey("identification")) {
            this.identification = (Integer)hashMap.get("identification");
        }
        if (hashMap.containsKey("visible")) {
            this.visible = (Boolean)hashMap.get("visible");
        }
        if (hashMap.containsKey("number_of_points")) {
            this.number_of_points = (Integer)hashMap.get("number_of_points");
        }
        if (hashMap.containsKey("line_color")) {
            this.line_color = (Color)hashMap.get("line_color");
        }
        if (hashMap.containsKey("line_thickness")) {
            this.line_thickness = (Integer)hashMap.get("line_thickness");
        }
        if (hashMap.containsKey("line_style")) {
            this.line_style = (Integer)hashMap.get("line_style");
        }
        if (hashMap.containsKey("profile_type")) {
            this.profile_type = (Integer)hashMap.get("profile_type");
        }
        if (hashMap.containsKey("label")) {
            this.label = (String)hashMap.get("label");
        }
        if (hashMap.containsKey("values")) {
            this.values = (float[])hashMap.get("values");
        }
        if (hashMap.containsKey("pressures")) {
            this.pressures = (float[])hashMap.get("pressures");
        }
        if (hashMap.containsKey("surface_pressure")) {
            this.surface_pressure = ((Float)hashMap.get("surface_pressure")).floatValue();
        }
    }
}

