/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class RaobRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private boolean contains_reanalysis_profiles;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public RaobRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public RaobRecord(String string, int n) {
        this.contains_data = false;
        this.contains_reanalysis_profiles = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public RaobRecord() {
        this.contains_data = false;
        this.contains_reanalysis_profiles = false;
    }

    public void addDataBuffer(short[] sArray) {
        int n;
        int n2;
        if (sArray.length == 2000) {
            this.buffer = RaobRecord.convertToLatestFormat(this.data_group_type, sArray);
        } else {
            this.buffer = new short[3000];
            for (n2 = 0; n2 < 3000; ++n2) {
                this.buffer[n2] = sArray[n2];
            }
        }
        this.contains_data = false;
        for (n2 = 0; !this.contains_data && n2 < this.buffer.length; ++n2) {
            if (this.buffer[n2] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
        this.contains_reanalysis_profiles = false;
        for (n = 0; n < 18; ++n) {
            if (this.buffer[500 + n] == Short.MIN_VALUE && this.buffer[518 + n] == Short.MIN_VALUE) continue;
            this.contains_reanalysis_profiles = true;
        }
        for (n = 0; n < 100; ++n) {
            if (this.buffer[2437 + n] == Short.MIN_VALUE && this.buffer[2537 + n] == Short.MIN_VALUE) continue;
            this.contains_reanalysis_profiles = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    private boolean usesNewPressureLevels() {
        boolean bl = false;
        if (this.buffer[10] == 1) {
            bl = true;
        }
        return bl;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return "Radiosonde " + this.getRaobID();
    }

    public String getExtraGroupInfo() {
        String string = " (" + this.getInstrumentType() + ")";
        return string;
    }

    public String getRaobID() {
        char c;
        char[] cArray = new char[6];
        short s = this.buffer[29];
        cArray[0] = c = (char)(s / 100);
        cArray[1] = c = (char)(s % 100);
        s = this.buffer[30];
        cArray[2] = c = (char)(s / 100);
        cArray[3] = c = (char)(s % 100);
        s = this.buffer[31];
        cArray[4] = c = (char)(s / 100);
        cArray[5] = c = (char)(s % 100);
        String string = new String(cArray);
        return string;
    }

    public float getLatitude() {
        float f = (float)this.buffer[39] / 128.0f;
        return f;
    }

    public float getLongitude() {
        float f = (float)this.buffer[40] / 128.0f;
        return f;
    }

    public int getDistance() {
        return this.buffer[26];
    }

    public String getTimeString() {
        int n = this.buffer[38] / 100;
        String string = "" + n;
        if (n < 10) {
            string = "0" + string;
        }
        int n2 = this.buffer[38] % 100;
        String string2 = "" + n2;
        if (n2 < 10) {
            string2 = "0" + n2;
        }
        String string3 = "" + string + ":" + string2;
        return string3;
    }

    public int getTime() {
        int n = this.buffer[38] * 100;
        return n;
    }

    public int getRaobTimeFlag() {
        int n = Short.MIN_VALUE;
        int n2 = this.buffer[38] / 100;
        if (n2 >= 21 && n2 <= 24) {
            n = 1;
        } else if (n2 >= 0 && n2 < 3) {
            n = 1;
        } else if (n2 >= 3 && n2 < 9) {
            n = 2;
        } else if (n2 >= 9 && n2 < 15) {
            n = 3;
        } else if (n2 >= 15 && n2 < 21) {
            n = 4;
        }
        return n;
    }

    public String getDateString() {
        int n;
        short s = this.buffer[36];
        short s2 = this.buffer[37];
        String string = "" + s + "/";
        if (s2 < 10) {
            string = string + "0";
        }
        if ((n = this.buffer[35]) < 2000) {
            n += 2000;
        }
        string = string + s2 + "/" + n;
        return string;
    }

    public int getDate() {
        int n = this.buffer[35] * 10000 + this.buffer[36] * 100 + this.buffer[37];
        return n;
    }

    public int getTerrain() {
        int n = this.buffer[44];
        if (n < 0 || n > 4) {
            n = 5;
        }
        return n;
    }

    public String getTerrainString() {
        String string = "Unknown";
        int n = this.getTerrain();
        switch (n) {
            case 0: {
                string = "Island Coast";
                break;
            }
            case 1: {
                string = "Mainland Inland";
                break;
            }
            case 2: {
                string = "Mainland Coast";
                break;
            }
            case 3: {
                string = "Island Inland";
                break;
            }
            case 4: {
                string = "Ship";
            }
        }
        return string;
    }

    public boolean hasSeaNonseaValue() {
        return false;
    }

    public int getSeaNonseaValue() {
        return Short.MIN_VALUE;
    }

    public boolean hasQCFlag() {
        return false;
    }

    public boolean getQCFlag() {
        return true;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return Short.MIN_VALUE;
    }

    public int getCloudFlagForNarcs() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return false;
    }

    public int getDayNightFlag() {
        return Short.MIN_VALUE;
    }

    public int[] getRaobNetworkFlags() {
        int[] nArray = new int[]{this.buffer[159], this.buffer[160], this.buffer[161]};
        return nArray;
    }

    public float getSurfacePressure() {
        return (float)this.buffer[153] / 1.0f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        float f = this.getSurfacePressure();
        if (f <= 0.0f) {
            f = -32768.0f;
        }
        vector.add(new Float(f));
        PressureLevels pressureLevels = new PressureLevels();
        int n = pressureLevels.getPressureLevel(f);
        if (this.usesNewPressureLevels()) {
            n = pressureLevels.getNewAtovsTempPressureLevel(f);
        }
        vector.add(new Float(-32768.0f));
        int n2 = this.getTerrain();
        vector.add(new Integer(n2));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public int getInstrumentType() {
        return this.buffer[43];
    }

    public int getCloudAmount() {
        return this.buffer[2744];
    }

    public int getNcepQCFlag() {
        return this.buffer[188];
    }

    public int[] getRadiationCorrectionFlags() {
        int[] nArray = new int[]{this.buffer[11], this.buffer[2747] == 0 ? 0 : (this.buffer[2747] == 1 || this.buffer[2747] == 2 || this.buffer[2747] == 4 || this.buffer[2747] == 6 ? 1 : (this.buffer[2747] == 3 || this.buffer[2747] == 5 || this.buffer[2747] == 7 ? 2 : 3))};
        return nArray;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{"Radiosonde", "   Forecast", "   Fcst Analysis", "   Std Observed", "   Std Radcor", "   Sig Observed", "   Sig Radcor"};
        if (this.contains_reanalysis_profiles) {
            stringArray = new String[]{"Radiosonde", "   Forecast", "   Fcst Analysis", "   Std Observed", "   Std Radcor", "   Std Analysis", "   Sig Observed", "   Sig Radcor", "   Sig Analysis"};
        }
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 2, 3, 10, 11, 15, 16};
        if (this.contains_reanalysis_profiles) {
            nArray = new int[]{0, 2, 3, 10, 11, 12, 15, 16, 17};
        }
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[7];
        if (this.contains_reanalysis_profiles) {
            profileArray = new Profile[9];
        }
        if (!this.containsData()) {
            for (int i = 0; i < profileArray.length; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            int n2;
            float f;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = this.getSurfacePressure();
            int n3 = 0;
            profileArray[n3] = new Profile(0, "Radiosonde", 0, Color.black, 1, 0);
            float[] fArray = this.getTemperatures();
            for (int i = 0; i < 42; ++i) {
                if (fArray[i] == -999.99f) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsTempPressure(i + 1) : pressureLevels.getPressure(i + 1);
                profileArray[n3].addItem(f, fArray[i]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Forecast", 0, Color.black, 1, 0);
            float[] fArray2 = this.getInterpolatedFcstTemperatures();
            for (int i = 0; i < 42; ++i) {
                if (fArray2[i] == -999.99f) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsTempPressure(i + 1) : pressureLevels.getPressure(i + 1);
                profileArray[n3].addItem(f, fArray2[i]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Fcst Analysis", 0, Color.black, 1, 0);
            float[] fArray3 = this.getAnalysisTemperatures();
            float[] fArray4 = this.getAnalysisPressures();
            for (int i = 0; i < 26; ++i) {
                if (fArray3[i] == -999.99f) continue;
                profileArray[n3].addItem(fArray4[i], fArray3[i]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Std Observed", 0, Color.black, 1, 0);
            float[] fArray5 = this.getStandardTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                if (!(fArray5[n2] > 0.0f)) continue;
                profileArray[n3].addItem(pressureLevels.getStdPressure(n2 + 1), fArray5[n2]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Std Radcor", 0, Color.black, 1, 0);
            fArray5 = this.getStandardRadcorTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                if (!(fArray5[n2] > 0.0f)) continue;
                profileArray[n3].addItem(pressureLevels.getStdPressure(n2 + 1), fArray5[n2]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            if (this.contains_reanalysis_profiles) {
                profileArray[++n3] = new Profile(0, "   Std Analysis", 0, Color.black, 1, 0);
                fArray5 = this.getStandardAnalysisTemperatures();
                for (n2 = 17; n2 >= 0; --n2) {
                    if (!(fArray5[n2] > 0.0f)) continue;
                    profileArray[n3].addItem(pressureLevels.getStdPressure(n2 + 1), fArray5[n2]);
                }
                profileArray[n3].setSurfacePressure(f2);
                profileArray[n3].trimProfile();
                if (profileArray[n3].getNumberOfPoints() == 0) {
                    profileArray[n3] = null;
                }
            }
            n2 = this.getNumSigLevels();
            float[] fArray6 = this.getSigPressures();
            profileArray[++n3] = new Profile(0, "   Sig Observed", 0, Color.black, 1, 0);
            float[] fArray7 = this.getSigTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray6[n] > 0.0f) || !(fArray7[n] > 0.0f)) continue;
                profileArray[n3].addItem(fArray6[n], fArray7[n]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Sig Radcor", 0, Color.black, 1, 0);
            fArray7 = this.getSigRadcorTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray6[n] > 0.0f) || !(fArray7[n] > 0.0f)) continue;
                profileArray[n3].addItem(fArray6[n], fArray7[n]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            if (this.contains_reanalysis_profiles) {
                profileArray[++n3] = new Profile(0, "   Sig Analysis", 0, Color.black, 1, 0);
                fArray7 = this.getSigAnalysisTemperatures();
                for (n = n2 - 1; n >= 0; --n) {
                    if (!(fArray6[n] > 0.0f) || !(fArray7[n] > 0.0f)) continue;
                    profileArray[n3].addItem(fArray6[n], fArray7[n]);
                }
                profileArray[n3].setSurfacePressure(f2);
                profileArray[n3].trimProfile();
                if (profileArray[n3].getNumberOfPoints() == 0) {
                    profileArray[n3] = null;
                }
            }
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[7];
        if (this.contains_reanalysis_profiles) {
            profileArray = new Profile[9];
        }
        if (!this.containsData()) {
            for (int i = 0; i < profileArray.length; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            int n2;
            float f;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = this.getSurfacePressure();
            int n3 = 0;
            profileArray[n3] = new Profile(0, "Radiosonde", 0, Color.black, 1, 1);
            float[] fArray = this.getDewpoints();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[n3].addItem(f, fArray[i]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Forecast", 0, Color.black, 1, 1);
            float[] fArray2 = this.getInterpolatedFcstWaterVapors();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray2[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f3 = EdgeUtils.convertToDewPoint(fArray2[i], f);
                profileArray[n3].addItem(f, f3);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Fcst Analysis", 0, Color.black, 1, 1);
            float[] fArray3 = this.getAnalysisWaterVapors();
            float[] fArray4 = this.getAnalysisPressures();
            for (int i = 0; i < 21; ++i) {
                if (fArray3[i] == -999.99f || !(fArray4[i + 5] >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f4 = EdgeUtils.convertToDewPoint(fArray3[i], fArray4[i + 5]);
                profileArray[n3].addItem(fArray4[i + 5], f4);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Std Observed", 0, Color.black, 1, 1);
            float[] fArray5 = this.getStandardDewpointTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                f = pressureLevels.getStdPressure(n2 + 1);
                if (!(fArray5[n2] > 0.0f) || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[n3].addItem(f, fArray5[n2]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Std Radcor", 0, Color.black, 1, 1);
            fArray5 = this.getStandardRadcorDewpointTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                f = pressureLevels.getStdPressure(n2 + 1);
                if (!(fArray5[n2] > 0.0f) || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[n3].addItem(f, fArray5[n2]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            if (this.contains_reanalysis_profiles) {
                profileArray[++n3] = new Profile(0, "   Std Analysis", 0, Color.black, 1, 1);
                fArray5 = this.getStandardAnalysisDewpointTemperatures();
                for (n2 = 17; n2 >= 0; --n2) {
                    f = pressureLevels.getStdPressure(n2 + 1);
                    if (!(fArray5[n2] > 0.0f) || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                    profileArray[n3].addItem(f, fArray5[n2]);
                }
                profileArray[n3].setSurfacePressure(f2);
                profileArray[n3].trimProfile();
                if (profileArray[n3].getNumberOfPoints() == 0) {
                    profileArray[n3] = null;
                }
            }
            n2 = this.getNumSigLevels();
            float[] fArray6 = this.getSigPressures();
            profileArray[++n3] = new Profile(0, "   Sig Observed", 0, Color.black, 1, 1);
            float[] fArray7 = this.getSigDewpointTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray6[n] > 0.0f) || !(fArray6[n] >= this.TOP_MOISTURE_PRESSURE) || !(fArray7[n] > 0.0f)) continue;
                profileArray[n3].addItem(fArray6[n], fArray7[n]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            profileArray[++n3] = new Profile(0, "   Sig Radcor", 0, Color.black, 1, 1);
            fArray7 = this.getSigRadcorDewpointTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray6[n] > 0.0f) || !(fArray6[n] >= this.TOP_MOISTURE_PRESSURE) || !(fArray7[n] > 0.0f)) continue;
                profileArray[n3].addItem(fArray6[n], fArray7[n]);
            }
            profileArray[n3].setSurfacePressure(f2);
            profileArray[n3].trimProfile();
            if (profileArray[n3].getNumberOfPoints() == 0) {
                profileArray[n3] = null;
            }
            if (this.contains_reanalysis_profiles) {
                profileArray[++n3] = new Profile(0, "   Sig Analysis", 0, Color.black, 1, 1);
                fArray7 = this.getSigAnalysisDewpointTemperatures();
                for (n = n2 - 1; n >= 0; --n) {
                    if (!(fArray6[n] > 0.0f) || !(fArray6[n] >= this.TOP_MOISTURE_PRESSURE) || !(fArray7[n] > 0.0f)) continue;
                    profileArray[n3].addItem(fArray6[n], fArray7[n]);
                }
                profileArray[n3].setSurfacePressure(f2);
                profileArray[n3].trimProfile();
                if (profileArray[n3].getNumberOfPoints() == 0) {
                    profileArray[n3] = null;
                }
            }
        }
        return profileArray;
    }

    private Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[7];
        for (int i = 0; i < 7; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            float f;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = this.getSurfacePressure();
            profileArray[0] = new Profile(0, "Radiosonde", 0, Color.black, 1, 1);
            float[] fArray = this.getWaterVapors();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(f, fArray[i]);
            }
            profileArray[0].setSurfacePressure(f2);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   Forecast", 0, Color.black, 1, 1);
            float[] fArray2 = this.getInterpolatedFcstWaterVapors();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray2[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[1].addItem(f, fArray2[i]);
            }
            profileArray[1].setSurfacePressure(f2);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            if (n == 3 || n == 4 || n == 5) {
                f2 = -32768.0f;
            } else if (n >= 9) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 6) {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getPressures();
                if (this.usesNewPressureLevels()) {
                    fArray = pressureLevels.getNewAtovsTempPressures();
                }
                float[] fArray2 = this.getTemperatures();
                if (n == 6) {
                    fArray2 = this.getInterpolatedFcstTemperatures();
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getWVPressures();
                if (this.usesNewPressureLevels()) {
                    fArray = pressureLevels.getNewAtovsMoisturePressures();
                }
                float[] fArray3 = this.getWaterVapors();
                if (n == 7 || n == 8) {
                    fArray3 = this.getInterpolatedFcstWaterVapors();
                }
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && (n == 1 || n == 7)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        int n2;
        int n3;
        int n4;
        Vector[] vectorArray = new Vector[7];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray[i] = new Vector(4);
        }
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getPressures();
        float[] fArray2 = pressureLevels.getWVPressures();
        float[] fArray3 = pressureLevels.getStdPressures();
        float[] fArray4 = this.getAnalysisPressures();
        if (this.usesNewPressureLevels()) {
            fArray = pressureLevels.getNewAtovsTempPressures();
            fArray2 = pressureLevels.getNewAtovsMoisturePressures();
        }
        float f = (float)this.buffer[182] / 10.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            fArray[i] = -999.99f;
        }
        if (n == 0) {
            float f2 = (float)this.buffer[181] / 10.0f;
            for (int i = 0; i < fArray2.length; ++i) {
                if (!(fArray2[i] < f2)) continue;
                fArray2[i] = -999.99f;
            }
        }
        float[] fArray5 = this.getTemperatures();
        float[] fArray6 = this.getDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray5);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray6);
        float[] fArray7 = this.getInterpolatedFcstTemperatures();
        float[] fArray8 = this.getInterpolatedFcstWaterVapors();
        float[] fArray9 = new float[fArray8.length];
        for (int i = 0; i < fArray8.length; ++i) {
            fArray9[i] = fArray8[i] != -999.99f ? EdgeUtils.convertToDewPoint(fArray8[i], fArray2[i]) : -999.99f;
        }
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray7);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray9);
        float[] fArray10 = this.getAnalysisTemperatures();
        float[] fArray11 = this.getAnalysisWaterVapors();
        float[] fArray12 = new float[fArray11.length];
        float[] fArray13 = new float[21];
        for (n4 = 0; n4 < 21; ++n4) {
            fArray13[n4] = fArray4[n4 + 5];
        }
        for (n4 = 0; n4 < fArray11.length; ++n4) {
            fArray12[n4] = fArray11[n4] != -999.99f ? EdgeUtils.convertToDewPoint(fArray11[n4], fArray13[n4]) : -999.99f;
        }
        vectorArray[2].add(fArray4);
        vectorArray[2].add(fArray10);
        vectorArray[2].add(fArray13);
        vectorArray[2].add(fArray12);
        float[] fArray14 = new float[fArray3.length];
        for (int i = 0; i < fArray3.length; ++i) {
            fArray14[i] = fArray3[fArray3.length - 1 - i];
        }
        fArray5 = this.getStandardTemperatures();
        float[] fArray15 = new float[fArray5.length];
        for (int i = 0; i < fArray5.length; ++i) {
            fArray15[i] = fArray5[fArray5.length - 1 - i];
        }
        fArray6 = this.getStandardDewpointTemperatures();
        float[] fArray16 = new float[fArray6.length];
        for (n3 = 0; n3 < fArray6.length; ++n3) {
            fArray16[n3] = fArray6[fArray6.length - 1 - n3];
        }
        vectorArray[3].add(fArray14);
        vectorArray[3].add(fArray15);
        vectorArray[3].add(fArray14);
        vectorArray[3].add(fArray16);
        fArray5 = this.getStandardRadcorTemperatures();
        fArray15 = new float[fArray5.length];
        for (n3 = 0; n3 < fArray5.length; ++n3) {
            fArray15[n3] = fArray5[fArray5.length - 1 - n3];
        }
        fArray6 = this.getStandardRadcorDewpointTemperatures();
        fArray16 = new float[fArray6.length];
        for (n3 = 0; n3 < fArray6.length; ++n3) {
            fArray16[n3] = fArray6[fArray6.length - 1 - n3];
        }
        vectorArray[4].add(fArray14);
        vectorArray[4].add(fArray15);
        vectorArray[4].add(fArray14);
        vectorArray[4].add(fArray16);
        float[] fArray17 = this.getSigPressures();
        float[] fArray18 = new float[fArray17.length];
        for (n2 = 0; n2 < fArray17.length; ++n2) {
            fArray18[n2] = fArray17[fArray17.length - 1 - n2];
        }
        fArray5 = this.getSigTemperatures();
        fArray15 = new float[fArray5.length];
        for (n2 = 0; n2 < fArray5.length; ++n2) {
            fArray15[n2] = fArray5[fArray5.length - 1 - n2];
        }
        fArray6 = this.getSigDewpointTemperatures();
        fArray16 = new float[fArray6.length];
        for (n2 = 0; n2 < fArray6.length; ++n2) {
            fArray16[n2] = fArray6[fArray6.length - 1 - n2];
        }
        vectorArray[5].add(fArray18);
        vectorArray[5].add(fArray15);
        vectorArray[5].add(fArray18);
        vectorArray[5].add(fArray16);
        fArray5 = this.getSigRadcorTemperatures();
        fArray15 = new float[fArray5.length];
        for (n2 = 0; n2 < fArray5.length; ++n2) {
            fArray15[n2] = fArray5[fArray5.length - 1 - n2];
        }
        fArray6 = this.getSigRadcorDewpointTemperatures();
        fArray16 = new float[fArray6.length];
        for (n2 = 0; n2 < fArray6.length; ++n2) {
            fArray16[n2] = fArray6[fArray6.length - 1 - n2];
        }
        vectorArray[6].add(fArray18);
        vectorArray[6].add(fArray15);
        vectorArray[6].add(fArray18);
        vectorArray[6].add(fArray16);
        return vectorArray;
    }

    private float[] getTemperatures() {
        float[] fArray = new float[42];
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.getTemperatureValue(i);
        }
        return fArray;
    }

    private float getTemperatureValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 71] != Short.MIN_VALUE) {
            f = (float)this.buffer[n + 71] / 64.0f;
        }
        return f;
    }

    private float[] getWaterVapors() {
        float[] fArray = new float[19];
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.getWaterVaporValue(i);
        }
        return fArray;
    }

    private float getWaterVaporValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 113] != Short.MIN_VALUE) {
            f = (float)Math.exp((double)this.buffer[n + 113] / 1024.0);
        }
        return f;
    }

    private float[] getDewpoints() {
        float[] fArray = new float[19];
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.getDewpointValue(i);
        }
        return fArray;
    }

    private float getDewpointValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 132] != Short.MIN_VALUE) {
            f = (float)this.buffer[n + 132] / 64.0f;
        }
        return f;
    }

    private float[] getInterpolatedFcstTemperatures() {
        float[] fArray = new float[42];
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.buffer[i + 2637] != Short.MIN_VALUE ? (float)this.buffer[i + 2637] / 64.0f : -999.99f;
        }
        if (this.buffer[2752] != 1) {
            float[] fArray2 = this.getInterpolatedFcstWaterVapors();
            for (int i = 23; i < 42; ++i) {
                if (fArray[i] == -999.99f || fArray2[i - 23] == -999.99f) continue;
                fArray[i] = fArray[i] / (1.0f + 0.61f * (fArray2[i - 23] / 1000.0f));
            }
        }
        return fArray;
    }

    private float[] getInterpolatedFcstWaterVapors() {
        float[] fArray = new float[19];
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.buffer[i + 2679] != Short.MIN_VALUE ? (float)Math.exp((double)this.buffer[i + 2679] / 1024.0) : -999.99f;
        }
        return fArray;
    }

    private float[] getAnalysisTemperatures() {
        float[] fArray = new float[26];
        for (int i = 0; i < 26; ++i) {
            fArray[25 - i] = this.buffer[i + 2763] != Short.MIN_VALUE ? (float)this.buffer[i + 2763] / 10.0f + 273.15f : -999.99f;
        }
        return fArray;
    }

    private float[] getAnalysisWaterVapors() {
        int n;
        float[] fArray = new float[21];
        Arrays.fill(fArray, -999.99f);
        float[] fArray2 = this.getAnalysisTemperatures();
        float[] fArray3 = this.getAnalysisPressures();
        float[] fArray4 = new float[21];
        for (n = 20; n >= 0; --n) {
            fArray4[20 - n] = this.buffer[n + 2792] > 1 ? (float)this.buffer[n + 2792] / 100.0f : -999.99f;
        }
        for (n = 0; n < 21; ++n) {
            if (fArray4[n] == -999.99f) continue;
            float f = -999.99f;
            if (fArray4[n] > 0.0f && fArray2[n + 5] != -999.99f) {
                float f2 = EdgeUtils.convertToMixingRatio(fArray3[n + 5], fArray2[n + 5]);
                f = 0.01f * fArray4[n] * f2;
            }
            fArray[n] = f;
        }
        return fArray;
    }

    private float[] getAnalysisPressures() {
        float[] fArray = new float[]{10.0f, 20.0f, 30.0f, 50.0f, 70.0f, 100.0f, 150.0f, 200.0f, 250.0f, 300.0f, 350.0f, 400.0f, 450.0f, 500.0f, 550.0f, 600.0f, 650.0f, 700.0f, 750.0f, 800.0f, 850.0f, 900.0f, 925.0f, 950.0f, 975.0f, 1000.0f};
        return fArray;
    }

    private float[] getStandardTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 194] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 194] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getStandardRadcorTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 212] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 212] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getStandardForecastTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 230] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 230] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getStandardAnalysisTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 500] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 500] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getStandardDewpointTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 248] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 248] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getStandardRadcorDewpointTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 266] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 266] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getStandardForecastDewpointTemperatures() {
        float[] fArray = new float[18];
        PressureLevels pressureLevels = new PressureLevels();
        for (int i = 0; i < 18; ++i) {
            if (this.buffer[i + 284] != Short.MIN_VALUE) {
                float f = (float)Math.exp((double)this.buffer[i + 284] / 1024.0);
                float f2 = pressureLevels.getStdPressure(i + 1);
                fArray[i] = EdgeUtils.convertToDewPoint(f, f2);
                continue;
            }
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getStandardAnalysisDewpointTemperatures() {
        float[] fArray = new float[18];
        PressureLevels pressureLevels = new PressureLevels();
        for (int i = 0; i < 18; ++i) {
            if (this.buffer[i + 518] != Short.MIN_VALUE) {
                float f = (float)Math.exp((double)this.buffer[i + 518] / 1024.0);
                float f2 = pressureLevels.getStdPressure(i + 1);
                fArray[i] = EdgeUtils.convertToDewPoint(f, f2);
                continue;
            }
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private int getNumSigLevels() {
        return this.buffer[536];
    }

    private float[] getSigPressures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 537] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 537] / 10.0f;
        }
        return fArray;
    }

    private float[] getSigTemperatures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 637] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 637] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getSigRadcorTemperatures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 737] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 737] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getSigForecastTemperatures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 837] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 837] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getSigAnalysisTemperatures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 2437] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 2437] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getSigDewpointTemperatures() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getSigTemperatures();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 937] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 937] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getSigRadcorDewpointTemperatures() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getSigTemperatures();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 1037] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 1037] / 10.0f + 273.15f;
        }
        return fArray;
    }

    private float[] getSigForecastDewpointTemperatures() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getSigForecastTemperatures();
        float[] fArray3 = this.getSigPressures();
        for (int i = 0; i < 100; ++i) {
            if (fArray2[i] != -999.99f && fArray3[i] != -999.99f) {
                if (this.buffer[i + 1137] != Short.MIN_VALUE) {
                    float f = (float)Math.exp((double)this.buffer[i + 1137] / 1024.0);
                    fArray[i] = EdgeUtils.convertToDewPoint(f, fArray3[i]);
                    continue;
                }
                fArray[i] = -999.99f;
                continue;
            }
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getSigAnalysisDewpointTemperatures() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getSigAnalysisTemperatures();
        float[] fArray3 = this.getSigPressures();
        for (int i = 0; i < 100; ++i) {
            if (fArray2[i] != -999.99f && fArray3[i] != -999.99f) {
                if (this.buffer[i + 2537] != Short.MIN_VALUE) {
                    float f = (float)Math.exp((double)this.buffer[i + 2537] / 1024.0);
                    fArray[i] = EdgeUtils.convertToDewPoint(f, fArray3[i]);
                    continue;
                }
                fArray[i] = -999.99f;
                continue;
            }
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[][] getStandardLevelData() {
        float[][] fArray = new float[18][19];
        for (int i = 0; i < 18; ++i) {
            fArray[i][0] = this.buffer[194 + i] != Short.MIN_VALUE ? (float)this.buffer[194 + i] / 10.0f : -999.99f;
            fArray[i][1] = this.buffer[212 + i] != Short.MIN_VALUE ? (float)this.buffer[212 + i] / 10.0f : -999.99f;
            fArray[i][2] = this.buffer[230 + i] != Short.MIN_VALUE ? (float)this.buffer[230 + i] / 10.0f : -999.99f;
            fArray[i][3] = this.buffer[248 + i] != Short.MIN_VALUE ? (float)this.buffer[248 + i] / 10.0f : -999.99f;
            fArray[i][4] = this.buffer[266 + i] != Short.MIN_VALUE ? (float)this.buffer[266 + i] / 10.0f : -999.99f;
            fArray[i][5] = this.buffer[284 + i] != Short.MIN_VALUE ? (float)Math.exp((float)this.buffer[284 + i] / 1024.0f) : -999.99f;
            fArray[i][6] = this.buffer[302 + i] != Short.MIN_VALUE ? (float)this.buffer[302 + i] / 1.0f : -999.99f;
            fArray[i][7] = this.buffer[320 + i] != Short.MIN_VALUE ? (float)this.buffer[320 + i] / 128.0f : -999.99f;
            fArray[i][8] = this.buffer[338 + i] != Short.MIN_VALUE ? (float)this.buffer[338 + i] / 128.0f : -999.99f;
            fArray[i][9] = this.buffer[356 + i] != Short.MIN_VALUE ? (i < 11 ? (float)this.buffer[356 + i] / 1.0f : (float)this.buffer[356 + i] * 10.0f) : -999.99f;
            fArray[i][10] = this.buffer[374 + i] != Short.MIN_VALUE ? (float)this.buffer[374 + i] / 1.0f : -999.99f;
            fArray[i][11] = this.buffer[392 + i] != Short.MIN_VALUE ? (float)this.buffer[392 + i] / 1.0f : -999.99f;
            fArray[i][12] = this.buffer[410 + i] != Short.MIN_VALUE ? (float)this.buffer[410 + i] / 1.0f : -999.99f;
            fArray[i][13] = this.buffer[428 + i] != Short.MIN_VALUE ? (float)this.buffer[428 + i] / 1.0f : -999.99f;
            fArray[i][14] = this.buffer[446 + i] != Short.MIN_VALUE ? (float)this.buffer[446 + i] / 1.0f : -999.99f;
            fArray[i][15] = this.buffer[464 + i] != Short.MIN_VALUE ? (float)this.buffer[464 + i] / 1.0f : -999.99f;
            fArray[i][16] = this.buffer[482 + i] != Short.MIN_VALUE ? (float)this.buffer[482 + i] / 1.0f : -999.99f;
            if (this.contains_reanalysis_profiles) {
                fArray[i][17] = this.buffer[500 + i] != Short.MIN_VALUE ? (float)this.buffer[500 + i] / 10.0f : -999.99f;
                fArray[i][18] = this.buffer[518 + i] != Short.MIN_VALUE ? (float)Math.exp((float)this.buffer[518 + i] / 1024.0f) : -999.99f;
            }
            if (fArray[i][2] == -999.99f || fArray[i][5] == -999.99f) continue;
            fArray[i][2] = (fArray[i][2] + 273.15f) / (1.0f + 0.61f * (fArray[i][5] / 1000.0f));
            fArray[i][2] = fArray[i][2] - 273.15f;
        }
        return fArray;
    }

    private float[][] getSignificantLevelData() {
        float[][] fArray = new float[100][21];
        for (int i = 0; i < 100; ++i) {
            fArray[i][0] = this.buffer[537 + i] != Short.MIN_VALUE ? (float)this.buffer[537 + i] / 10.0f : -999.99f;
            fArray[i][1] = this.buffer[637 + i] != Short.MIN_VALUE ? (float)this.buffer[637 + i] / 10.0f : -999.99f;
            fArray[i][2] = this.buffer[737 + i] != Short.MIN_VALUE ? (float)this.buffer[737 + i] / 10.0f : -999.99f;
            fArray[i][3] = this.buffer[837 + i] != Short.MIN_VALUE ? (float)this.buffer[837 + i] / 10.0f : -999.99f;
            fArray[i][4] = this.buffer[937 + i] != Short.MIN_VALUE ? (float)this.buffer[937 + i] / 10.0f : -999.99f;
            fArray[i][5] = this.buffer[1037 + i] != Short.MIN_VALUE ? (float)this.buffer[1037 + i] / 10.0f : -999.99f;
            fArray[i][6] = this.buffer[1137 + i] != Short.MIN_VALUE ? (float)Math.exp((float)this.buffer[1137 + i] / 1024.0f) : -999.99f;
            fArray[i][7] = this.buffer[1237 + i] != Short.MIN_VALUE ? (float)this.buffer[1237 + i] / 1.0f : -999.99f;
            fArray[i][8] = this.buffer[1337 + i] != Short.MIN_VALUE ? (float)this.buffer[1337 + i] / 128.0f : -999.99f;
            fArray[i][9] = this.buffer[1437 + i] != Short.MIN_VALUE ? (float)this.buffer[1437 + i] / 128.0f : -999.99f;
            if (this.buffer[1537 + i] != Short.MIN_VALUE) {
                float f = 1.0f;
                if (fArray[i][0] <= 80.0f) {
                    f = 0.1f;
                }
                fArray[i][10] = (float)this.buffer[1537 + i] / f;
            } else {
                fArray[i][10] = -999.99f;
            }
            fArray[i][11] = this.buffer[1637 + i] != Short.MIN_VALUE ? (float)this.buffer[1637 + i] / 1.0f : -999.99f;
            fArray[i][12] = this.buffer[1737 + i] != Short.MIN_VALUE ? (float)this.buffer[1737 + i] / 1.0f : -999.99f;
            fArray[i][13] = this.buffer[1837 + i] != Short.MIN_VALUE ? (float)this.buffer[1837 + i] / 1.0f : -999.99f;
            fArray[i][14] = this.buffer[1937 + i] != Short.MIN_VALUE ? (float)this.buffer[1937 + i] / 1.0f : -999.99f;
            fArray[i][15] = this.buffer[2037 + i] != Short.MIN_VALUE ? (float)this.buffer[2037 + i] / 1.0f : -999.99f;
            fArray[i][16] = this.buffer[2137 + i] != Short.MIN_VALUE ? (float)this.buffer[2137 + i] / 1.0f : -999.99f;
            fArray[i][17] = this.buffer[2237 + i] != Short.MIN_VALUE ? (float)this.buffer[2237 + i] / 1.0f : -999.99f;
            fArray[i][18] = this.buffer[2337 + i] != Short.MIN_VALUE ? (float)this.buffer[2337 + i] / 1.0f : -999.99f;
            if (this.contains_reanalysis_profiles) {
                fArray[i][19] = this.buffer[2437 + i] != Short.MIN_VALUE ? (float)this.buffer[2437 + i] / 10.0f : -999.99f;
                fArray[i][20] = this.buffer[2537 + i] != Short.MIN_VALUE ? (float)Math.exp((float)this.buffer[2537 + i] / 1024.0f) : -999.99f;
            }
            if (fArray[i][3] == -999.99f || fArray[i][6] == -999.99f) continue;
            fArray[i][3] = (fArray[i][3] + 273.15f) / (1.0f + 0.61f * (fArray[i][6] / 1000.0f));
            fArray[i][3] = fArray[i][3] - 273.15f;
        }
        return fArray;
    }

    public int[] getTier1Flags() {
        int[] nArray = new int[]{this.buffer[48], this.buffer[50], this.buffer[67], this.buffer[183], Short.MIN_VALUE};
        return nArray;
    }

    public int getTier2Flag() {
        return this.buffer[70];
    }

    public int getTier3Flag() {
        return this.buffer[51];
    }

    public int getRaobDriftDataFlag() {
        int n;
        float[] fArray = this.getDriftPositions();
        int n2 = (int)fArray[0];
        boolean bl = false;
        float f = fArray[5];
        float f2 = fArray[123];
        for (n = 1; n < n2; ++n) {
            if (fArray[5 + n] == f && fArray[123 + n] == f2) continue;
            bl = true;
        }
        n = 0;
        if (!bl) {
            n = 1;
        }
        return n;
    }

    public int getSondeType() {
        int n = 0;
        int n2 = this.getInstrumentType();
        if (n2 == 96 || n2 == 31) {
            n = 1;
        }
        if (this.buffer[2753] == 1) {
            n = 2;
        }
        return n;
    }

    public float[] getDriftPositions() {
        int n;
        float[][] fArray = this.getStandardLevelData();
        PressureLevels pressureLevels = new PressureLevels();
        float[][] fArray2 = new float[18][4];
        int n2 = 0;
        for (int i = 0; i < 18; ++i) {
            if (fArray[i][6] == -999.99f) continue;
            fArray2[n2][0] = pressureLevels.getStdPressure(i + 1);
            fArray2[n2][1] = fArray[i][6];
            fArray2[n2][2] = fArray[i][7];
            fArray2[n2][3] = fArray[i][8];
            ++n2;
        }
        float[][] fArray3 = this.getSignificantLevelData();
        float[][] fArray4 = new float[100][4];
        int n3 = 0;
        int n4 = this.getNumSigLevels();
        for (int i = 0; i < n4; ++i) {
            if (fArray3[i][0] == -999.99f) continue;
            fArray4[n3][0] = fArray3[i][0];
            fArray4[n3][1] = fArray3[i][7];
            fArray4[n3][2] = fArray3[i][8];
            fArray4[n3][3] = fArray3[i][9];
            ++n3;
        }
        float[] fArray5 = new float[359];
        for (int i = 0; i < 359; ++i) {
            fArray5[i] = -32768.0f;
        }
        float f = 0.0f;
        float f2 = -32768.0f;
        float f3 = 2000.0f;
        float f4 = -32768.0f;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < n2 + n3; ++n) {
            boolean bl = false;
            bl = n5 >= n2 ? false : (n6 >= n3 ? true : fArray2[n5][0] > fArray4[n6][0]);
            if (bl) {
                fArray5[5 + n] = fArray2[n5][2];
                fArray5[123 + n] = fArray2[n5][3];
                fArray5[241 + n] = fArray2[n5][0];
                if (fArray2[n5][0] > f) {
                    f = fArray2[n5][0];
                    f2 = fArray2[n5][1];
                }
                if (fArray2[n5][0] < f3) {
                    f3 = fArray2[n5][0];
                    f4 = fArray2[n5][1];
                }
                ++n5;
                continue;
            }
            fArray5[5 + n] = fArray4[n6][2];
            fArray5[123 + n] = fArray4[n6][3];
            fArray5[241 + n] = fArray4[n6][0];
            if (fArray4[n6][0] > f) {
                f = fArray4[n6][0];
                f2 = fArray4[n6][1];
            }
            if (fArray4[n6][0] < f3) {
                f3 = fArray4[n6][0];
                f4 = fArray4[n6][1];
            }
            ++n6;
        }
        if (f2 == -32768.0f) {
            f = -32768.0f;
        }
        if (f4 == -32768.0f) {
            f3 = -32768.0f;
        }
        fArray5[0] = n;
        fArray5[1] = f;
        fArray5[2] = f3;
        fArray5[3] = f2;
        fArray5[4] = f4;
        return fArray5;
    }

    public short[] getDriftBuffer() {
        int n;
        int n2;
        int n3;
        short[] sArray = new short[1000];
        Arrays.fill(sArray, (short)Short.MIN_VALUE);
        String string = this.getRaobID();
        for (int i = 0; i < 6; ++i) {
            sArray[i] = (short)string.charAt(i);
        }
        sArray[6] = this.buffer[35];
        sArray[7] = this.buffer[36];
        sArray[8] = this.buffer[37];
        sArray[9] = this.buffer[38];
        sArray[10] = (short)(this.getRaobTimeFlag() * 6);
        sArray[11] = this.buffer[39];
        sArray[12] = this.buffer[40];
        sArray[13] = (short)this.getSondeType();
        sArray[14] = this.buffer[161];
        float[][] fArray = this.getStandardLevelData();
        PressureLevels pressureLevels = new PressureLevels();
        float[][] fArray2 = new float[18][8];
        int n4 = 0;
        for (int i = 0; i < 18; ++i) {
            if (fArray[i][6] == -999.99f) continue;
            fArray2[n4][0] = pressureLevels.getStdPressure(i + 1);
            fArray2[n4][1] = fArray[i][6];
            fArray2[n4][2] = fArray[i][7];
            fArray2[n4][3] = fArray[i][8];
            float f = this.getLatitude();
            float f2 = this.getLongitude();
            float f3 = fArray[i][6];
            float f4 = fArray[i][7];
            fArray2[n4][4] = EdgeUtils.calculateDistance(f, f2, f3, f4);
            fArray2[n4][5] = fArray[i][10];
            fArray2[n4][6] = fArray[i][11];
            fArray2[n4][7] = fArray[i][15];
            ++n4;
        }
        float[][] fArray3 = this.getSignificantLevelData();
        float[][] fArray4 = new float[100][8];
        int n5 = 0;
        int n6 = this.getNumSigLevels();
        for (int i = 0; i < n6; ++i) {
            if (fArray3[i][0] == -999.99f) continue;
            fArray4[n5][0] = fArray3[i][0];
            fArray4[n5][1] = fArray3[i][7];
            fArray4[n5][2] = fArray3[i][8];
            fArray4[n5][3] = fArray3[i][9];
            float f = this.getLatitude();
            float f5 = this.getLongitude();
            float f6 = fArray3[i][8];
            float f7 = fArray3[i][9];
            fArray4[n5][4] = EdgeUtils.calculateDistance(f, f5, f6, f7);
            fArray4[n5][5] = fArray3[i][11];
            fArray4[n5][6] = fArray3[i][12];
            fArray4[n5][7] = fArray3[i][17];
            ++n5;
        }
        float[] fArray5 = new float[118];
        float[] fArray6 = new float[118];
        float[] fArray7 = new float[118];
        float[] fArray8 = new float[118];
        float[] fArray9 = new float[118];
        float[] fArray10 = new float[118];
        float[] fArray11 = new float[118];
        short[] sArray2 = new short[118];
        for (n3 = 0; n3 < 118; ++n3) {
            fArray5[n3] = -32768.0f;
            fArray6[n3] = -32768.0f;
            fArray7[n3] = -32768.0f;
            fArray8[n3] = -32768.0f;
            fArray9[n3] = -32768.0f;
            fArray10[n3] = -32768.0f;
            fArray11[n3] = -32768.0f;
            sArray2[n3] = Short.MIN_VALUE;
        }
        n3 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n4 + n5; ++n2) {
            n = 0;
            n = n3 >= n4 ? 0 : (n7 >= n5 ? 1 : (fArray2[n3][0] > fArray4[n7][0] ? 1 : 0));
            if (n != 0) {
                fArray5[n2] = fArray2[n3][0];
                fArray6[n2] = fArray2[n3][1];
                fArray7[n2] = fArray2[n3][2];
                fArray8[n2] = fArray2[n3][3];
                fArray9[n2] = fArray2[n3][4];
                fArray10[n2] = fArray2[n3][5];
                fArray11[n2] = fArray2[n3][6];
                sArray2[n2] = (short)fArray2[n3][7];
                ++n3;
                continue;
            }
            fArray5[n2] = fArray4[n7][0];
            fArray6[n2] = fArray4[n7][1];
            fArray7[n2] = fArray4[n7][2];
            fArray8[n2] = fArray4[n7][3];
            fArray9[n2] = fArray4[n7][4];
            fArray10[n2] = fArray4[n7][5];
            fArray11[n2] = fArray4[n7][6];
            sArray2[n2] = (short)fArray4[n7][7];
            ++n7;
        }
        sArray[55] = (short)n2;
        for (n = 0; n < 118; ++n) {
            sArray[n + 56] = (short)(fArray5[n] * 10.0f);
            sArray[n + 174] = (short)fArray6[n];
            sArray[n + 292] = (short)(fArray7[n] * 128.0f);
            sArray[n + 410] = (short)(fArray8[n] * 128.0f);
            sArray[n + 528] = (short)(fArray9[n] * 10.0f);
            sArray[n + 646] = (short)fArray10[n];
            sArray[n + 764] = (short)fArray11[n];
            sArray[n + 882] = sArray2[n];
        }
        return sArray;
    }

    private float getTPW() {
        return EdgeUtils.twoDigits((float)this.buffer[162] / 100.0f);
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.contains_data) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add("Radiosonde " + this.getRaobID());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = "Radiosonde";
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (i == 0) {
                vectorArray[i].add(" ");
            } else {
                vectorArray[i].add(stringArray[i].trim());
            }
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Radiosonde</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Radiosonde Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected radiosonde was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildStandardAndSigLevelTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
            Vector vector4 = this.buildForecastAnalysisPanel();
            for (int i = 0; i < vector4.size(); ++i) {
                vector.add((JLabel)vector4.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        String string;
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Station ID");
        vector4.add(this.getRaobID());
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Day of Report");
        if (this.buffer[35] != Short.MIN_VALUE && this.buffer[36] != Short.MIN_VALUE && this.buffer[37] != Short.MIN_VALUE) {
            vector4.add(this.getDateString());
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Observation Time");
        if (this.buffer[38] != Short.MIN_VALUE) {
            int n = this.buffer[38] / 100;
            int n2 = this.buffer[38] % 100;
            string = "" + n + ":";
            if (n2 < 10) {
                string = string + "0";
            }
            string = string + n2 + " Z";
            vector4.add(string);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Station Elevation");
        if (this.buffer[41] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[41] + " m");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Station Terrain");
        if (this.buffer[41] != Short.MIN_VALUE) {
            if (this.buffer[44] == 0) {
                vector4.add("Sea");
            } else if (this.buffer[44] == 1) {
                vector4.add("Land");
            } else if (this.buffer[44] == 2) {
                vector4.add("Coast");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        PdispGlobals pdispGlobals = new PdispGlobals();
        vector4 = new Vector(2);
        vector4.add("Instrument Type");
        if (this.buffer[43] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[43] + ":  " + pdispGlobals.getRaobInstrumentType(this.buffer[43]));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Report Type");
        if (this.buffer[43] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[42]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("GRUAN");
        if (this.buffer[161] != Short.MIN_VALUE) {
            if (this.buffer[161] == 0) {
                vector4.add("No");
            } else if (this.buffer[161] == 1) {
                vector4.add("Primary");
            } else if (this.buffer[161] == 2) {
                vector4.add("Secondary");
            } else if (this.buffer[161] == 3) {
                vector4.add("Primary (dummy)");
            } else if (this.buffer[161] == 4) {
                vector4.add("Secondary (dummy)");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("SUAN-250");
        if (this.buffer[159] != Short.MIN_VALUE) {
            if (this.buffer[159] == 0) {
                vector4.add("No");
            } else if (this.buffer[159] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("GCOS");
        if (this.buffer[160] != Short.MIN_VALUE) {
            if (this.buffer[160] == 0) {
                vector4.add("No");
            } else if (this.buffer[160] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Type");
        if (this.buffer[2745] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2745] + ":  " + pdispGlobals.getRaobCloudType(this.buffer[2745]));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Amount");
        if (this.buffer[2744] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2744] + ":  " + pdispGlobals.getCloudAmount(this.buffer[2744]));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Cloud Fraction");
        if (this.buffer[2746] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.threeDigits((float)this.buffer[2746] / 1000.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("NCEP QC flag");
        if (this.getSondeType() == 1) {
            vector4.add("Not Tested");
        } else if (this.buffer[188] == 0) {
            vector4.add("All levels passed");
        } else if (this.buffer[188] == 1) {
            vector4.add("At least one level failed");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Climatological Limits Test");
        if (this.buffer[183] != Short.MIN_VALUE) {
            if (this.buffer[183] == 0) {
                vector4.add("All levels passed");
            } else if (this.buffer[183] == 1) {
                vector4.add("At least one level failed");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("NCEP Radiation Correction");
        if (this.buffer[11] != Short.MIN_VALUE) {
            if (this.buffer[11] == 0) {
                vector4.add("0 - No correction");
            } else if (this.buffer[11] == 1) {
                vector4.add("1 - Correction done");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Onsite Radiation Correction");
        if (this.buffer[2747] != Short.MIN_VALUE) {
            if (this.buffer[2747] == 0) {
                vector4.add("0 - No correction");
            } else if (this.buffer[2747] == 1) {
                vector4.add("1 - CIMO solar corrected and CIMO infrared corrected");
            } else if (this.buffer[2747] == 2) {
                vector4.add("2 - CIMO solar corrected and infrared corrected");
            } else if (this.buffer[2747] == 3) {
                vector4.add("3 - CIMO solar corrected only");
            } else if (this.buffer[2747] == 4) {
                vector4.add("4 - Solar and infrared corrected by radiosonde system");
            } else if (this.buffer[2747] == 5) {
                vector4.add("5 - Solar correct automatically by radiosonde system");
            } else if (this.buffer[2747] == 6) {
                vector4.add("6 - Solar and infrared corrected as specified by country");
            } else if (this.buffer[2747] == 7) {
                vector4.add("7 - Solar corrected as specified by country");
            } else if (this.buffer[2747] >= 8 && this.buffer[2747] <= 14) {
                vector4.add("" + this.buffer[2747] + " - Reserved value");
            } else if (this.buffer[2747] == 15) {
                vector4.add("15 - Missing value");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Top Interpolated Pressure");
        if (this.buffer[46] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[46] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Bottom Interpolated Pressure");
        if (this.buffer[45] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[45] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Top Interpolated Moisture Pressure");
        if (this.buffer[58] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[58] / 10.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Pressure At Top Of Surface Bonudary Layer");
        if (this.buffer[151] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[151] / 1.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Surface Pressure");
        if (this.buffer[2735] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[2735] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Surface Temperature");
        if (this.buffer[2736] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[2736] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Rad. Corrected Surface Temp");
        if (this.buffer[2737] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[2737] / 10.0f));
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Surface Dewpoint Temp");
        if (this.buffer[2738] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[2738] / 10.0f) + " deg C");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Surface Pressure QC Flag");
        if (this.buffer[2739] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2739]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Surface Temperature QC Flag");
        if (this.buffer[2740] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2740]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Surface Humidity QC Flag");
        if (this.buffer[2741] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2741]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Wind Direction");
        if (this.buffer[2742] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2742]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Wind Speed");
        if (this.buffer[2743] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[2743]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tier 1 Flags");
        int[] nArray = this.getTier1Flags();
        vector4.add("" + nArray[0] + "  " + nArray[1] + "  " + nArray[2] + "  " + nArray[3]);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tier 2 Flag (initial/adjusted/final)");
        string = "not available";
        String string2 = "not available";
        String string3 = "not available";
        if (this.buffer[69] != Short.MIN_VALUE) {
            string = "" + this.buffer[69];
        }
        if (this.buffer[70] != Short.MIN_VALUE) {
            string2 = "" + this.buffer[70];
        }
        if (this.buffer[52] != Short.MIN_VALUE) {
            string3 = "" + this.buffer[52];
        }
        vector4.add("" + string + " / " + string2 + " / " + string3);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Tier 3 Flag");
        vector4.add("" + this.getTier3Flag());
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Boundary Layer Flag");
        if (this.buffer[57] != Short.MIN_VALUE) {
            if (this.buffer[57] == 0) {
                vector4.add("0 - No Anomalies");
            } else if (this.buffer[57] == 1) {
                vector4.add("1 - Moderate Anomalies");
            } else if (this.buffer[57] == 2) {
                vector4.add("2 - Severe Anomalies");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Temperature Profile Capped Flag");
        if (this.buffer[49] != Short.MIN_VALUE) {
            if (this.buffer[49] == 0) {
                vector4.add("Not Capped");
            } else if (this.buffer[49] == 1) {
                vector4.add("Capped");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Moisture Profile Capped Flag");
        if (this.buffer[53] != Short.MIN_VALUE) {
            if (this.buffer[53] == 0) {
                vector4.add("Not Capped");
            } else if (this.buffer[53] == 1) {
                vector4.add("Capped");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Water Vapor Anomaly Detected Flag");
        if (this.buffer[59] != Short.MIN_VALUE) {
            if (this.buffer[59] == 0) {
                vector4.add("No");
            } else if (this.buffer[59] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Water Vapor Event1 Detected Flag");
        if (this.buffer[60] != Short.MIN_VALUE) {
            if (this.buffer[60] == 0) {
                vector4.add("No");
            } else if (this.buffer[60] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Water Vapor Extreme Event1 Detected Flag");
        if (this.buffer[61] != Short.MIN_VALUE) {
            if (this.buffer[61] == 0) {
                vector4.add("No");
            } else if (this.buffer[61] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Water Vapor Event2 Detected Flag");
        if (this.buffer[62] != Short.MIN_VALUE) {
            if (this.buffer[62] == 0) {
                vector4.add("No");
            } else if (this.buffer[62] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Water Vapor Negative Event Detected Flag");
        if (this.buffer[63] != Short.MIN_VALUE) {
            if (this.buffer[63] == 0) {
                vector4.add("No");
            } else if (this.buffer[63] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Water Vapor Extreme Negative Detected Flag");
        if (this.buffer[64] != Short.MIN_VALUE) {
            if (this.buffer[64] == 0) {
                vector4.add("No");
            } else if (this.buffer[64] == 1) {
                vector4.add("Yes");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Water Vapor Replacement/Extrapolation Flag");
        if (this.buffer[65] != Short.MIN_VALUE) {
            if (this.buffer[65] == 0) {
                vector4.add("None");
            } else if (this.buffer[65] == 1) {
                vector4.add("Extrpolation");
            } else if (this.buffer[65] == 2) {
                vector4.add("Replacement");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Inversion Type Flag");
        if (this.buffer[66] != Short.MIN_VALUE) {
            if (this.buffer[66] == 0) {
                vector4.add("None");
            } else if (this.buffer[66] == 1) {
                vector4.add("Surface Inversion");
            } else if (this.buffer[66] == 2) {
                vector4.add("Inversion Aloft Only");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Constant Dewpoint Depression Flag");
        if (this.buffer[67] != Short.MIN_VALUE) {
            if (this.buffer[67] == 0) {
                vector4.add("0 - None");
            } else if (this.buffer[67] == 1) {
                vector4.add("1 - All dwpt depressions within 5 degrees");
            } else if (this.buffer[67] == 2) {
                vector4.add("2 - All dwpt depressions within 2.5 degrees");
            } else if (this.buffer[67] == 3) {
                vector4.add("3 - All dwpt depressions within 1 degree");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Duplicate Raob Flag");
        if (this.buffer[68] != Short.MIN_VALUE) {
            if (this.buffer[68] == 0) {
                vector4.add("0 - Not Duplicate");
            } else if (this.buffer[68] == 1) {
                vector4.add("1 - Accepted Duplicate");
            } else if (this.buffer[68] == 2) {
                vector4.add("2 - Rejected Duplicate");
            }
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reported Tropopause Pressure");
        if (this.buffer[152] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[152] / 1.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Calculated Tropopause Pressures");
        String string4 = "";
        for (int i = 0; i < 5; ++i) {
            if (i != 0) {
                string4 = string4 + " / ";
            }
            string4 = this.buffer[2729 + i] != Short.MIN_VALUE ? string4 + EdgeUtils.oneDigit((float)this.buffer[2729 + i] / 10.0f) + " mb" : string4 + "na";
        }
        vector4.add(string4);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Deflection Point Pressures");
        String string5 = "";
        for (int i = 0; i < 5; ++i) {
            if (i != 0) {
                string5 = string5 + " / ";
            }
            string5 = this.buffer[2699 + i] != Short.MIN_VALUE ? string5 + EdgeUtils.oneDigit((float)this.buffer[2699 + i] / 10.0f) + " mb" : string5 + "na";
        }
        vector4.add(string5);
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Pressure");
        if (this.buffer[153] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.oneDigit((float)this.buffer[153] / 1.0f) + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Temperature");
        if (this.buffer[154] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[154] / 64.0f) + " deg K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Water Vapor");
        if (this.buffer[155] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[155] / 1024.0)) + " g/kg");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Surface Dewpoint Temp");
        if (this.buffer[156] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[156] / 64.0f) + " deg K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("WVapor At Lowest Level");
        if (this.buffer[157] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[157] / 1024.0)) + " g/kg");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("WVapor At Highest Level");
        if (this.buffer[158] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[158] / 1024.0)) + " g/kg");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Total Precip Water");
        if (this.buffer[162] != Short.MIN_VALUE) {
            vector4.add("" + EdgeUtils.twoDigits((float)this.buffer[162] / 100.0f) + " mm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Extrapolated Layer Precip Water");
        String string6 = "Level 1  -  " + EdgeUtils.twoDigits((float)this.buffer[163] / 100.0f) + " mm";
        vector4.add(string6);
        vector3.add(vector4);
        for (int i = 1; i < 18; ++i) {
            vector4 = new Vector();
            vector4.add(" ");
            string6 = "Level " + (i + 1) + "  -  ";
            string6 = this.buffer[163 + i] != Short.MIN_VALUE ? string6 + EdgeUtils.twoDigits((float)this.buffer[163 + i] / 100.0f) + " mm" : string6 + "not available";
            vector4.add(string6);
            vector3.add(vector4);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildStandardAndSigLevelTable() {
        int n;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Standard (red) and Significant (white) Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Level");
        vector2.add("Pressure");
        vector2.add("Obs Temp");
        vector2.add("Radcor\nTemp");
        vector2.add("Fcst Temp");
        if (this.contains_reanalysis_profiles) {
            vector2.add("Analysis\nTemp");
        }
        vector2.add("Obs Dwpt");
        vector2.add("Radcor\nDwpt");
        vector2.add("Fcst WVMR");
        if (this.contains_reanalysis_profiles) {
            vector2.add("Analysis\nWVMR");
        }
        vector2.add("Drift\nTime");
        vector2.add("Drift\nLat");
        vector2.add("Drift\nLon");
        vector2.add("Drift\nDistance");
        vector2.add("Geop\nHeight");
        vector2.add("Wind Dir");
        vector2.add("Wind\nSpeed");
        vector2.add("Pressure\nFlag");
        vector2.add("Temp\nFlag");
        vector2.add("RH\nFlag");
        vector2.add("Height\nFlag");
        vector2.add("Wind\nFlag");
        vector2.add("Missing\nFlag");
        Vector vector3 = new Vector();
        float[][] fArray = this.getStandardLevelData();
        float[] fArray2 = new float[18];
        PressureLevels pressureLevels = new PressureLevels();
        int n2 = 0;
        for (int i = 0; i < 18; ++i) {
            if (fArray[i][6] == -999.99f) continue;
            fArray2[n2] = pressureLevels.getStdPressure(n2 + 1);
            ++n2;
        }
        float[] fArray3 = new float[100];
        float[][] fArray4 = this.getSignificantLevelData();
        int n3 = this.getNumSigLevels();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            fArray3[i] = fArray4[i][0];
            if (fArray4[i][0] == -999.99f) continue;
            ++n4;
        }
        int[] nArray = new int[118];
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < n2 + n4; ++n) {
            boolean bl = false;
            bl = n5 >= n2 ? false : (n6 >= n4 ? true : fArray2[n5] > fArray3[n6]);
            if (bl) {
                nArray[n] = -1 * (n5 + 1);
                ++n5;
                continue;
            }
            nArray[n] = n6++;
        }
        float f = this.getLatitude();
        float f2 = this.getLongitude();
        boolean[] blArray = new boolean[n];
        int n7 = -1;
        for (int i = n - 1; i >= 0; --i) {
            int n8;
            float f3;
            ++n7;
            Vector<String> vector4 = new Vector<String>();
            boolean bl = false;
            int n9 = nArray[i];
            if (nArray[i] < 0) {
                bl = true;
                n9 = -nArray[i] - 1;
            }
            if (bl) {
                int n10;
                blArray[n7] = true;
                vector4.add("" + (n9 + 1));
                vector4.add("" + EdgeUtils.oneDigit(fArray2[n9]));
                for (n10 = 0; n10 <= 2; ++n10) {
                    if (fArray[n9][n10] != -999.99f) {
                        vector4.add("" + EdgeUtils.oneDigit(fArray[n9][n10]));
                        continue;
                    }
                    vector4.add(" ");
                }
                if (this.contains_reanalysis_profiles) {
                    if (fArray[n9][17] != -999.99f) {
                        vector4.add("" + EdgeUtils.oneDigit(fArray[n9][17]));
                    } else {
                        vector4.add(" ");
                    }
                }
                for (n10 = 3; n10 <= 4; ++n10) {
                    if (fArray[n9][n10] != -999.99f) {
                        vector4.add("" + EdgeUtils.oneDigit(fArray[n9][n10]));
                        continue;
                    }
                    vector4.add(" ");
                }
                if (fArray[n9][5] != -999.99f) {
                    vector4.add("" + EdgeUtils.fourDigits(fArray[n9][5]));
                } else {
                    vector4.add(" ");
                }
                if (this.contains_reanalysis_profiles) {
                    if (fArray[n9][18] != -999.99f) {
                        vector4.add("" + EdgeUtils.fourDigits(fArray[n9][18]));
                    } else {
                        vector4.add(" ");
                    }
                }
                if (fArray[n9][6] != -999.99f) {
                    vector4.add("" + EdgeUtils.oneDigit(fArray[n9][6]));
                } else {
                    vector4.add(" ");
                }
                for (n10 = 7; n10 <= 8; ++n10) {
                    if (fArray[n9][n10] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray[n9][n10]));
                        continue;
                    }
                    vector4.add(" ");
                }
                f3 = EdgeUtils.calculateDistance(f, f2, fArray[n9][7], fArray[n9][8]);
                if (fArray[n9][7] != -999.99f && fArray[n9][8] != -999.99f) {
                    vector4.add("" + EdgeUtils.oneDigit(f3));
                } else {
                    vector4.add(" ");
                }
                for (n8 = 9; n8 <= 11; ++n8) {
                    if (fArray[n9][n8] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray[n9][n8]));
                        continue;
                    }
                    vector4.add(" ");
                }
                vector4.add(" ");
                for (n8 = 12; n8 <= 16; ++n8) {
                    if (fArray[n9][n8] != -999.99f) {
                        vector4.add("" + (int)fArray[n9][n8]);
                        continue;
                    }
                    vector4.add(" ");
                }
            } else {
                int n11;
                blArray[n7] = false;
                vector4.add("" + (n9 + 1));
                vector4.add("" + EdgeUtils.oneDigit(fArray3[n9]));
                for (n11 = 1; n11 <= 3; ++n11) {
                    if (fArray4[n9][n11] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray4[n9][n11]));
                        continue;
                    }
                    vector4.add(" ");
                }
                if (this.contains_reanalysis_profiles) {
                    if (fArray4[n9][19] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray4[n9][19]));
                    } else {
                        vector4.add(" ");
                    }
                }
                for (n11 = 4; n11 <= 5; ++n11) {
                    if (fArray4[n9][n11] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray4[n9][n11]));
                        continue;
                    }
                    vector4.add(" ");
                }
                if (fArray4[n9][6] != -999.99f) {
                    vector4.add("" + EdgeUtils.fourDigits(fArray4[n9][6]));
                } else {
                    vector4.add(" ");
                }
                if (this.contains_reanalysis_profiles) {
                    if (fArray4[n9][20] != -999.99f) {
                        vector4.add("" + EdgeUtils.fourDigits(fArray4[n9][20]));
                    } else {
                        vector4.add(" ");
                    }
                }
                if (fArray4[n9][7] != -999.99f) {
                    vector4.add("" + (int)fArray4[n9][7]);
                } else {
                    vector4.add(" ");
                }
                for (n11 = 8; n11 <= 9; ++n11) {
                    if (fArray4[n9][n11] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray4[n9][n11]));
                        continue;
                    }
                    vector4.add(" ");
                }
                f3 = EdgeUtils.calculateDistance(f, f2, fArray4[n9][8], fArray4[n9][9]);
                if (fArray4[n9][8] != -999.99f && fArray4[n9][9] != -999.99f) {
                    vector4.add("" + EdgeUtils.oneDigit(f3));
                } else {
                    vector4.add(" ");
                }
                for (n8 = 10; n8 <= 12; ++n8) {
                    if (fArray4[n9][n8] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray4[n9][n8]));
                        continue;
                    }
                    vector4.add(" ");
                }
                for (n8 = 13; n8 <= 18; ++n8) {
                    if (fArray4[n9][n8] != -999.99f) {
                        vector4.add("" + (int)fArray4[n9][n8]);
                        continue;
                    }
                    vector4.add(" ");
                }
            }
            vector3.add(vector4);
        }
        RedCellRenderer redCellRenderer = new RedCellRenderer();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            redCellRenderer.setRowToColor(i);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setDefaultRenderer(Object.class, redCellRenderer);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer(multiLineHeaderRenderer);
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }

    public Vector buildForecastAnalysisPanel() {
        Object object;
        Object object2;
        Object object3;
        Vector<Object> vector = new Vector<Object>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Forecast and Analysis Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<Object> vector4 = new Vector<Object>(2);
        vector4.add("Analysis Time");
        short s = this.buffer[2759];
        short s2 = this.buffer[2760];
        int n = s2 / 100;
        int n2 = s2 % 100;
        short s3 = this.buffer[2761];
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s + "  " + s3 + " Z";
        if (s != Short.MIN_VALUE && s2 != Short.MIN_VALUE && s3 != Short.MIN_VALUE) {
            vector4.add(string);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Distance from RAOB to grid point");
        if (this.buffer[2762] != Short.MIN_VALUE) {
            float f = (float)this.buffer[2762] / 10.0f;
            object3 = "" + f + " km";
            vector4.add(object3);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("");
        vector4.add("");
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Tropopause Pressure");
        if (this.buffer[2897] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2897] / 10.0f + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Tropopause Temperature");
        if (this.buffer[2791] != Short.MIN_VALUE) {
            vector4.add("" + ((float)this.buffer[2791] / 10.0f + 273.15f) + " deg K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Tropopause U-component Wind");
        if (this.buffer[2840] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2840] / 100.0f + " m/s");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Tropopause V-component Wind");
        if (this.buffer[2867] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2867] / 100.0f + " m/s");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Tropopause V-component Wind");
        if (this.buffer[2867] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2867] / 100.0f + " m/s");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Tropopause Geopotential Height");
        if (this.buffer[2895] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2895] / 100.0f + " dm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("");
        vector4.add("");
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Surface Pressure");
        if (this.buffer[2896] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2896] / 10.0f + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Mean Sea Level");
        if (this.buffer[2898] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2898] / 10.0f + " mb");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Surface Temperature");
        if (this.buffer[2790] != Short.MIN_VALUE) {
            vector4.add("" + ((float)this.buffer[2790] / 10.0f + 273.15f) + " deg K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Temperature (2 m above ground)");
        if (this.buffer[2789] != Short.MIN_VALUE) {
            vector4.add("" + ((float)this.buffer[2789] / 10.0f + 273.15f) + " deg K");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Relative Humidity (2 m above ground)");
        if (this.buffer[2813] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2813] / 10.0f + " %");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Surface Geopotential Height");
        if (this.buffer[2894] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2894] / 100.0f + " dm");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Surface Ice Cover");
        if (this.buffer[2899] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2899] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector();
        vector4.add("Surface Land Cover");
        if (this.buffer[2899] != Short.MIN_VALUE) {
            vector4.add("" + (float)this.buffer[2900] / 100.0f);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        object3 = new JPanel();
        ((JComponent)object3).setBackground(Color.white);
        ((Container)object3).setLayout(new FlowLayout(0));
        ((Container)object3).add(jTable);
        vector.add(object3);
        vector2 = new Vector();
        vector2.add("Pressure");
        vector2.add("Standard Level\nForecast Temp");
        vector2.add("Analysis\nTemperature");
        vector2.add("Relative\nHumidity");
        vector2.add("Wind U");
        vector2.add("Wind V");
        vector2.add("Geop Height");
        vector3 = new Vector();
        float[] fArray = this.getAnalysisPressures();
        float[] fArray2 = this.getStandardForecastTemperatures();
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray3 = pressureLevels.getStdPressures();
        for (int i = 0; i < 26; ++i) {
            vector4 = new Vector(7);
            vector4.add("" + EdgeUtils.oneDigit(fArray[i]));
            int n3 = Short.MIN_VALUE;
            for (int j = 0; j < fArray3.length; ++j) {
                if (fArray3[j] != fArray[i]) continue;
                n3 = j;
            }
            object2 = "";
            if (n3 != Short.MIN_VALUE && fArray2[n3] != -999.99f) {
                object2 = "" + EdgeUtils.oneDigit(fArray2[n3] - 273.15f);
            }
            vector4.add(object2);
            object2 = "";
            if (this.buffer[2788 - i] != Short.MIN_VALUE) {
                object2 = "" + EdgeUtils.oneDigit((float)this.buffer[2788 - i] / 10.0f);
            }
            vector4.add(object2);
            object = "";
            if (i > 4 && this.buffer[2817 - i] != Short.MIN_VALUE) {
                object = "" + EdgeUtils.twoDigits((float)this.buffer[2817 - i] / 100.0f);
            }
            vector4.add(object);
            String string2 = "";
            if (this.buffer[2839 - i] != Short.MIN_VALUE) {
                string2 = "" + EdgeUtils.twoDigits((float)this.buffer[2839 - i] / 100.0f);
            }
            vector4.add(string2);
            String string3 = "";
            if (this.buffer[2866 - i] != Short.MIN_VALUE) {
                string3 = "" + EdgeUtils.twoDigits((float)this.buffer[2866 - i] / 100.0f);
            }
            vector4.add(string3);
            String string4 = "";
            if (i > 4 && this.buffer[2893 - i] != Short.MIN_VALUE) {
                string4 = "" + EdgeUtils.oneDigit((float)this.buffer[2893 - i] / 10.0f);
            }
            vector4.add(string4);
            vector3.add(vector4);
        }
        vector.add(new JLabel(" "));
        jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer(multiLineHeaderRenderer);
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        object2 = new JPanel();
        ((JComponent)object2).setBackground(Color.white);
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add((Component)jTable.getTableHeader(), "First");
        ((Container)object2).add((Component)jTable, "Center");
        object = new JPanel();
        ((JComponent)object).setBackground(Color.white);
        ((Container)object).setLayout(new FlowLayout(0));
        ((Container)object).add((Component)object2);
        vector.add(object);
        return vector;
    }

    public static short[] convertToLatestFormat(int n, short[] sArray) {
        int n2;
        short[] sArray2 = new short[3000];
        for (n2 = 0; n2 < sArray2.length; ++n2) {
            sArray2[n2] = Short.MIN_VALUE;
        }
        for (n2 = 0; n2 < 48; ++n2) {
            sArray2[n2] = sArray[n2];
        }
        sArray2[10] = sArray[10];
        sArray2[11] = sArray[11];
        sArray2[49] = sArray[49];
        sArray2[50] = sArray[50];
        sArray2[51] = sArray[51];
        sArray2[52] = sArray[52];
        sArray2[54] = sArray[54];
        for (n2 = 71; n2 < 151; ++n2) {
            sArray2[n2] = sArray[n2];
        }
        sArray2[152] = sArray[152];
        sArray2[153] = sArray[153];
        sArray2[154] = sArray[154];
        sArray2[155] = sArray[155];
        sArray2[156] = sArray[156];
        sArray2[157] = sArray[157];
        sArray2[158] = sArray[158];
        for (n2 = 162; n2 < 183; ++n2) {
            sArray2[n2] = sArray[n2];
        }
        for (n2 = 0; n2 < 18; ++n2) {
            sArray2[194 + n2] = sArray[194 + n2];
            sArray2[212 + n2] = sArray[212 + n2];
            sArray2[230 + n2] = sArray[230 + n2];
            sArray2[248 + n2] = sArray[248 + n2];
            sArray2[266 + n2] = sArray[266 + n2];
            sArray2[284 + n2] = sArray[284 + n2];
            sArray2[302 + n2] = sArray[302 + n2];
            sArray2[320 + n2] = sArray[320 + n2];
            sArray2[338 + n2] = sArray[338 + n2];
            sArray2[410 + n2] = sArray[356 + n2];
            sArray2[428 + n2] = sArray[374 + n2];
            sArray2[482 + n2] = sArray[410 + n2];
        }
        sArray2[536] = sArray[428];
        for (n2 = 0; n2 < 100; ++n2) {
            sArray2[537 + n2] = sArray[429 + n2];
            sArray2[637 + n2] = sArray[529 + n2];
            sArray2[737 + n2] = sArray[629 + n2];
            sArray2[837 + n2] = sArray[729 + n2];
            sArray2[937 + n2] = sArray[829 + n2];
            sArray2[1037 + n2] = sArray[929 + n2];
            sArray2[1137 + n2] = sArray[1029 + n2];
            sArray2[1237 + n2] = sArray[1129 + n2];
            sArray2[1337 + n2] = sArray[1229 + n2];
            sArray2[1437 + n2] = sArray[1329 + n2];
            sArray2[1837 + n2] = sArray[1429 + n2];
            sArray2[1937 + n2] = sArray[1529 + n2];
            sArray2[2037 + n2] = sArray[1629 + n2];
            sArray2[2337 + n2] = sArray[1829 + n2];
        }
        sArray2[2735] = sArray[1959];
        sArray2[2736] = sArray[1960];
        sArray2[2737] = sArray[1961];
        sArray2[2738] = sArray[1962];
        sArray2[2739] = sArray[1963];
        sArray2[2740] = sArray[1964];
        sArray2[2741] = sArray[1965];
        sArray2[2742] = sArray[1966];
        sArray2[2743] = sArray[1967];
        sArray2[2744] = sArray[1968];
        sArray2[2745] = sArray[1969];
        sArray2[2746] = sArray[1970];
        for (n2 = 0; n2 < 42; ++n2) {
            sArray2[2637 + n2] = sArray[n2 + 1729];
        }
        for (n2 = 0; n2 < 19; ++n2) {
            sArray2[2679 + n2] = sArray[n2 + 1771];
        }
        return sArray2;
    }
}

