/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Vector;

class VstatDataGroup {
    private Satellite[] satellites;
    private int number_of_satellites;
    private int data_group_code;
    private String group_description;
    private int data_levels;
    private float scaling_factor;
    private float default_min_value;
    private float default_max_value;
    private String baseline_system_description;
    private float[] pressure_levels;
    private int[] sample_sizes;
    private float[] baseline_means;
    private int number_of_stats;
    private int[] stat_codes;
    private String[] stat_descriptions;
    private boolean contains_valid_data = false;

    public VstatDataGroup(DataInputStream dataInputStream) {
        this.readDataGroup(dataInputStream);
    }

    private void readDataGroup(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n != 68718280) {
                System.out.println("Bad data group block id: " + n);
            } else {
                int n3;
                int n4;
                this.data_group_code = dataInputStream.readInt();
                this.group_description = "";
                for (n4 = 0; n4 < 36; ++n4) {
                    n3 = dataInputStream.readInt();
                    if (n3 == 0) continue;
                    this.group_description = this.group_description + (char)n3;
                }
                this.number_of_satellites = dataInputStream.readInt();
                this.data_levels = dataInputStream.readInt();
                this.scaling_factor = dataInputStream.readInt();
                this.default_min_value = (float)dataInputStream.readInt() / this.scaling_factor;
                this.default_max_value = (float)dataInputStream.readInt() / this.scaling_factor;
                this.baseline_system_description = "";
                for (n4 = 0; n4 < 36; ++n4) {
                    n3 = (char)dataInputStream.readInt();
                    if (n3 == 0) continue;
                    this.baseline_system_description = this.baseline_system_description + (char)n3;
                }
                this.pressure_levels = new float[this.data_levels];
                for (n4 = 0; n4 < this.data_levels; ++n4) {
                    this.pressure_levels[n4] = (float)dataInputStream.readInt() / 1000.0f;
                }
                this.sample_sizes = new int[this.data_levels];
                for (n4 = 0; n4 < this.data_levels; ++n4) {
                    this.sample_sizes[n4] = dataInputStream.readInt();
                }
                this.baseline_means = new float[this.data_levels];
                for (n4 = 0; n4 < this.data_levels; ++n4) {
                    n3 = dataInputStream.readInt();
                    this.baseline_means[n4] = n3 != Short.MIN_VALUE ? (float)n3 / this.scaling_factor : -32768.0f;
                }
                this.number_of_stats = dataInputStream.readInt();
                this.stat_codes = new int[this.number_of_stats];
                for (n4 = 0; n4 < this.number_of_stats; ++n4) {
                    this.stat_codes[n4] = dataInputStream.readInt();
                }
                this.stat_descriptions = new String[this.number_of_stats];
                for (n4 = 0; n4 < this.number_of_stats; ++n4) {
                    this.stat_descriptions[n4] = "";
                    for (n3 = 0; n3 < 36; ++n3) {
                        char c = (char)dataInputStream.readInt();
                        if (c == '\u0000') continue;
                        this.stat_descriptions[n4] = this.stat_descriptions[n4] + c;
                    }
                }
                this.satellites = new Satellite[this.number_of_satellites];
                for (n4 = 0; n4 < this.number_of_satellites; ++n4) {
                    this.satellites[n4] = new Satellite(dataInputStream, this.data_levels, this.scaling_factor, this.number_of_stats);
                }
                this.contains_valid_data = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Data Group:");
            exception.printStackTrace();
        }
    }

    public String getDataGroupDescription() {
        return this.group_description;
    }

    public int getDataGroupCode() {
        return this.data_group_code;
    }

    public String[] getStatDescriptions() {
        return this.stat_descriptions;
    }

    public int[] getStatCodes() {
        return this.stat_codes;
    }

    public String[] getSatelliteNames() {
        String[] stringArray = new String[this.number_of_satellites];
        for (int i = 0; i < this.number_of_satellites; ++i) {
            stringArray[i] = this.satellites[i].getSatelliteName();
        }
        return stringArray;
    }

    public Vector getSatGroups() {
        Vector vector = new Vector();
        for (int i = 0; i < this.number_of_satellites; ++i) {
            Vector vector2 = this.satellites[i].getSubgroupNames();
            for (int j = 0; j < vector2.size(); ++j) {
                vector.add(vector2.elementAt(j));
            }
        }
        return vector;
    }

    public String getBaselineSystemDescription() {
        return this.baseline_system_description;
    }

    public float[] getPressureLevels() {
        return this.pressure_levels;
    }

    public float[] getBaselineMeans() {
        return this.baseline_means;
    }

    public int[] getSampleSizes() {
        return this.sample_sizes;
    }

    public float getDefaultMinimumValue() {
        return this.default_min_value;
    }

    public float getDefaultMaximumValue() {
        return this.default_max_value;
    }

    public Profile[][] getProfiles() {
        Vector<Profile[][]> vector = new Vector<Profile[][]>();
        int n = 0;
        for (int i = 0; i < this.number_of_satellites; ++i) {
            Profile[][] profileArray = this.satellites[i].getProfiles(i, this.number_of_stats, this.pressure_levels);
            vector.add(profileArray);
            n += this.satellites[i].getNumberOfSubgroups();
        }
        Profile[][] profileArray = new Profile[n][this.number_of_stats];
        int n2 = -1;
        for (int i = 0; i < this.number_of_satellites; ++i) {
            int n3 = this.satellites[i].getNumberOfSubgroups();
            for (int j = 0; j < n3; ++j) {
                ++n2;
                Profile[][] profileArray2 = (Profile[][])vector.elementAt(i);
                for (int k = 0; k < this.number_of_stats; ++k) {
                    profileArray[n2][k] = profileArray2[j][k];
                }
            }
        }
        return profileArray;
    }

    public Profile[][] getProfiles(Vector vector, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        Profile[][] profileArray = null;
        Vector<Profile[][]> vector2 = new Vector<Profile[][]>();
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.number_of_satellites; ++i) {
            for (n4 = 0; n4 < vector.size(); ++n4) {
                int n7;
                int[] nArray = (int[])vector.elementAt(n4);
                if (i != nArray[0]) continue;
                profileArray = this.satellites[i].getProfiles(i, this.number_of_stats, this.pressure_levels);
                n3 = this.satellites[i].getNumberOfSubgroups();
                for (n2 = 0; n2 < n3; ++n2) {
                    for (n7 = 0; n7 < this.number_of_stats; ++n7) {
                        if (profileArray[n2][n7] == null) continue;
                        profileArray[n2][n7].setVisible(false);
                    }
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    for (n7 = 1; n7 < nArray.length; ++n7) {
                        if (n2 != nArray[n7]) continue;
                        for (n = 0; n < this.number_of_stats; ++n) {
                            if (profileArray[n2][n] == null) continue;
                            profileArray[n2][n].setVisible(true);
                            if (!bl) continue;
                            String string = profileArray[n2][n].getLabel();
                            string = string + " " + this.stat_descriptions[n];
                            profileArray[n2][n].setLabel(string);
                        }
                    }
                }
                vector2.add(profileArray);
                n5 += this.satellites[i].getNumberOfSubgroups();
                ++n6;
            }
        }
        Profile[][] profileArray2 = new Profile[n5][this.number_of_stats];
        n4 = -1;
        for (int i = 0; i < n6; ++i) {
            n3 = this.satellites[i].getNumberOfSubgroups();
            for (n2 = 0; n2 < n3; ++n2) {
                ++n4;
                Profile[][] profileArray3 = (Profile[][])vector2.elementAt(i);
                for (n = 0; n < this.number_of_stats; ++n) {
                    profileArray2[n4][n] = profileArray3[n2][n];
                }
            }
        }
        return profileArray2;
    }

    public int getNumberOfSubgroups() {
        Vector vector = this.getSatGroups();
        return vector.size();
    }

    public int getNumberOfSubgroups(int n) {
        Vector vector = this.satellites[n].getSubgroupNames();
        return vector.size();
    }

    public int getNumberOfStats() {
        return this.number_of_stats;
    }
}

