/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class XMLParser {
    public XMLTree parseFile(String string) throws XMLParserException {
        XMLTree xMLTree = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                String string2 = "The parameter file " + string + " could not be found. Please check the name of " + "the file and try running the program again.";
                throw new XMLParserException(string2);
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            xMLTree = this.parseTree(dataInputStream, null);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            String string3 = "" + iOException;
            throw new XMLParserException(string3);
        }
        return xMLTree;
    }

    public XMLTree parseFile(DataInputStream dataInputStream) throws XMLParserException {
        XMLTree xMLTree = this.parseTree(dataInputStream, null);
        return xMLTree;
    }

    private XMLTree parseTree(DataInputStream dataInputStream, String string) throws XMLParserException {
        XMLTree xMLTree = null;
        try {
            String string2;
            Object object;
            String string3 = string;
            if (string3 == null) {
                string3 = this.getNextTag(dataInputStream, ' ');
            }
            String string4 = string3.substring(1, string3.length() - 1);
            xMLTree = new XMLTree(string4);
            String string5 = "";
            if (string3.startsWith("<bin_")) {
                object = this.readBinaryData(dataInputStream);
                xMLTree.addValue((byte[])object);
                string5 = this.getNextTag(dataInputStream, ' ');
            } else {
                object = new Vector();
                string2 = "";
                while (!string5.startsWith("</")) {
                    int n;
                    char c = ' ';
                    while (c != '<') {
                        n = dataInputStream.read();
                        if (n == -1) {
                            this.throwEOFException();
                        }
                        if ((c = (char)((char)n)) == 10 || c == 13 || c == 9 || c == 60) continue;
                        string2 = string2 + c;
                    }
                    string5 = "<";
                    while (c != '>') {
                        n = dataInputStream.read();
                        if (n == -1) {
                            this.throwEOFException();
                        }
                        if ((c = (char)((char)n)) == 10 || c == 13 || c == 9) continue;
                        string5 = string5 + c;
                    }
                    if (string5.startsWith("</") || string5.startsWith("<?") || string5.startsWith("<!")) continue;
                    XMLTree xMLTree2 = this.parseTree(dataInputStream, string5);
                    ((Vector)object).add(xMLTree2);
                }
                if (((Vector)object).size() == 0) {
                    xMLTree.addValue(string2.trim());
                } else {
                    xMLTree.addValue((Vector)object);
                }
            }
            object = string3.substring(1);
            string2 = string5.substring(2);
            if (!((String)object).equals(string2)) {
                String string6 = "The tag " + string3 + " either does not have a " + "matching tag or the tags are not properly " + "nested.";
                throw new XMLParserException(string6);
            }
        }
        catch (IOException iOException) {
            this.throwEOFException();
        }
        return xMLTree;
    }

    private String getNextTag(DataInputStream dataInputStream, char c) throws XMLParserException {
        String string = "";
        try {
            int n;
            char c2 = c;
            while (c2 != '<') {
                n = dataInputStream.read();
                if (n == -1) {
                    this.throwEOFException();
                }
                if ((c2 = (char)n) == '<' || c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') continue;
                String string2 = "A bad character was read from the XML data. The character \"" + c2 + "\" was read while the " + "program was looking for an XML tag. Please check " + "the XML code and try again.";
                throw new XMLParserException(string2);
            }
            n = dataInputStream.read();
            if (n == -1) {
                this.throwEOFException();
            }
            if ((c2 = (char)n) == '!' || c2 == '?') {
                while (c2 != '>') {
                    n = dataInputStream.read();
                    if (n == -1) {
                        this.throwEOFException();
                    }
                    c2 = (char)n;
                }
                string = this.getNextTag(dataInputStream, ' ');
            } else {
                string = "<" + c2;
                while (c2 != '>') {
                    n = dataInputStream.read();
                    if (n == -1) {
                        this.throwEOFException();
                    }
                    if ((c2 = (char)n) == '\n' || c2 == '\r') continue;
                    string = string + c2;
                }
            }
        }
        catch (IOException iOException) {
            this.throwEOFException();
        }
        return string;
    }

    private byte[] readBinaryData(DataInputStream dataInputStream) {
        byte[] byArray = null;
        try {
            int n = dataInputStream.read();
            int n2 = dataInputStream.read();
            int n3 = dataInputStream.read();
            int n4 = dataInputStream.read();
            int n5 = n * 0x1000000 + n2 * 65536 + n3 * 256 + n4;
            byArray = new byte[n5];
            dataInputStream.readFully(byArray);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return byArray;
    }

    private void throwEOFException() throws XMLParserException {
        String string = "The end of the XML data was reached prematurely. It is likely that the XML code is not properly formed. Please check the XML code and try again.";
        throw new XMLParserException(string);
    }
}

