/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class AutoNarcs {
    private NarcsGlobals globals;
    private String output_file_name;
    private String input_file_name;
    private String output_image_type;
    private int image_width;
    private int image_height;
    private int global_start_date;
    private int global_end_date;
    private int time_option;
    private int start_date;
    private int end_date;
    private int data_block;
    private int line_thickness;
    private String font_name;
    private int font_style;
    private int min_max_option;
    private float data_min;
    private float data_max;
    private boolean ignore_extreme_values;
    private boolean show_data_points;
    private boolean show_bias;
    private boolean show_stddev;
    private boolean show_rms;
    private boolean show_samplesize;
    private boolean show_passfail;
    private boolean show_pass;
    private boolean show_fail;
    private boolean show_seanonsea;
    private boolean show_sea;
    private boolean show_nonsea;
    private boolean show_clearcloudy;
    private boolean show_clear;
    private boolean show_cloudy;
    private int[] profile_numbers;
    private int[] profile_reds;
    private int[] profile_greens;
    private int[] profile_blues;
    private String[] profile_names;
    private int[] data_block_type;
    private int[] data_block_offset;
    private String[] data_block_name;
    private int num_days;
    private int num_subgroups;
    private int num_data_groups;
    private int[] dates;
    private String[] data_group_name;
    private String[] full_subgroup_name;
    private float version = 1.1f;
    private String version_date = "January 15, 2011";

    public static void main(String[] stringArray) {
        AutoNarcs autoNarcs = new AutoNarcs(stringArray);
        System.exit(0);
    }

    public AutoNarcs(String[] stringArray) {
        System.out.println("====================================================================");
        System.out.print("Starting AutoNarcs " + this.version + " at ");
        this.printTime();
        System.out.println("");
        if (stringArray.length == 2) {
            this.readGlobalDateRange(stringArray);
        }
        try {
            XMLParser xMLParser = new XMLParser();
            XMLTree xMLTree = xMLParser.parseFile("parameter.file");
            if (xMLTree != null) {
                Object object = xMLTree.getValue();
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    for (int i = 0; i < vector.size(); ++i) {
                        object = vector.elementAt(i);
                        this.processImage(object);
                    }
                } else {
                    System.out.println("\nThe input parameter file could not be parsed.");
                    System.out.println("The structure of the XML data is probably not correct.");
                    System.out.println("Please check the file and try again.\n");
                    System.exit(1);
                }
            } else {
                System.out.println("\nThe input parameter file could not be parsed.");
                System.out.println("The structure of the XML data is probably not correct.");
                System.out.println("Please check the file and try again.\n");
                System.exit(1);
            }
        }
        catch (XMLParserException xMLParserException) {
            System.out.println("\nThe input parameter file could not be parsed.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("Please check the file and try again.\n");
            System.exit(1);
        }
        System.out.print("\nEnding AutoNarcs at ");
        this.printTime();
        System.out.println("\n\n\n");
    }

    private void readGlobalDateRange(String[] stringArray) {
        this.global_start_date = 0;
        this.global_end_date = 0;
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            this.global_start_date = n;
            this.global_end_date = n2;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processImage(Object object) {
        System.out.println("-------------------------------------------");
        System.out.println("Processing Image...");
        System.out.println("");
        if (!(object instanceof XMLTree)) {
            System.out.println("\nThere was a problem trying to create an image.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("This image will be skipped.\n");
        } else {
            Object object2;
            XMLTree xMLTree = (XMLTree)object;
            boolean bl = false;
            Object object3 = xMLTree.getValue("show_file_info");
            if (object3 != null && object3 instanceof String && ((String)(object2 = (String)object3)).equals("yes")) {
                bl = true;
            }
            if (bl) {
                this.showFileInfo(xMLTree);
            } else {
                this.globals = new NarcsGlobals();
                this.initializeImageParameters();
                this.processImageParameters(xMLTree);
                if (this.input_file_name != null && this.output_file_name != null) {
                    this.readNarcsFileHeader();
                    this.updateGlobalSettings();
                    object2 = new BufferedImage(this.image_width, this.image_height, 1);
                    Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
                    int n = (int)((float)this.image_height * 0.05f);
                    int n2 = this.image_height - n;
                    this.drawTitle(graphics2D, 0, 0, this.image_width, n);
                    if (this.data_block < 0 || this.data_block >= this.data_block_type.length) {
                        this.data_block = 0;
                    }
                    if (this.data_block_type[this.data_block] == 0) {
                        for (int i = 0; i < this.profile_numbers.length; ++i) {
                            if (this.profile_numbers[i] < 0 || this.profile_numbers[i] >= this.num_data_groups + 5) continue;
                            if (this.profile_names[i] != null) {
                                this.data_group_name[this.profile_numbers[i]] = this.profile_names[i];
                            }
                            if (this.profile_reds[i] != Short.MIN_VALUE && this.profile_greens[i] != Short.MIN_VALUE && this.profile_blues[i] != Short.MIN_VALUE) {
                                this.globals.setGroupColor(this.profile_numbers[i], new Color(this.profile_reds[i], this.profile_greens[i], this.profile_blues[i]));
                            }
                            for (int j = 0; j < 27; ++j) {
                                this.globals.setGroupLineThickness(this.profile_numbers[i], j, this.line_thickness);
                            }
                        }
                        SampleSizeGraph sampleSizeGraph = new SampleSizeGraph();
                        sampleSizeGraph.addFileInfo(this.input_file_name, this.data_block_offset[this.data_block], this.num_days, this.dates, this.num_data_groups, this.data_group_name);
                        sampleSizeGraph.drawBackgroundImage(graphics2D, 0, n, this.image_width, n2, this.font_name, this.font_style);
                    } else {
                        for (int i = 0; i < this.profile_numbers.length; ++i) {
                            if (this.profile_numbers[i] < 0 || this.profile_numbers[i] >= this.num_subgroups) continue;
                            if (this.profile_names[i] != null) {
                                this.full_subgroup_name[this.profile_numbers[i]] = this.profile_names[i];
                            }
                            if (this.profile_reds[i] != Short.MIN_VALUE && this.profile_greens[i] != Short.MIN_VALUE && this.profile_blues[i] != Short.MIN_VALUE) {
                                this.globals.setSubgroupColor(this.profile_numbers[i], new Color(this.profile_reds[i], this.profile_greens[i], this.profile_blues[i]));
                            }
                            for (int j = 0; j < 27; ++j) {
                                for (int k = 0; k < 4; ++k) {
                                    this.globals.setSubgroupLineThickness(this.profile_numbers[i], j, k, this.line_thickness);
                                }
                            }
                        }
                        StatGraph statGraph = new StatGraph(this.data_block_type[this.data_block]);
                        statGraph.addFileInfo(this.input_file_name, this.data_block_offset, this.data_block_name, this.num_days, this.dates, this.num_subgroups, this.full_subgroup_name);
                        statGraph.newDataLevel(this.data_block);
                        statGraph.drawBackgroundImage(graphics2D, 0, n, this.image_width, n2, this.font_name, this.font_style);
                    }
                    this.saveImage((BufferedImage)object2);
                    System.out.println("Image saved:  " + this.output_file_name);
                } else {
                    if (this.input_file_name == null) {
                        System.out.println("\nThe input file name was not included in the paramter XML file.");
                        System.out.println("This image will be skipped.\n");
                    }
                    if (this.output_file_name == null) {
                        System.out.println("\nThe output file name was not included in the paramter XML file.");
                        System.out.println("This image will be skipped.\n");
                    }
                }
                this.globals = null;
            }
        }
        System.out.println("");
        System.out.println("");
    }

    private void showFileInfo(XMLTree xMLTree) {
        Object object = xMLTree.getValue("input_file_name");
        if (object != null && object instanceof String) {
            this.input_file_name = (String)object;
            try {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.input_file_name));
                if (this.input_file_name.endsWith(".gz")) {
                    dataInputStream = new DataInputStream(new GZIPInputStream(new FileInputStream(this.input_file_name)));
                }
                int n8 = dataInputStream.readInt();
                float f = (float)dataInputStream.readInt() / 10.0f;
                int n9 = dataInputStream.readInt();
                for (n7 = 0; n7 < 7; ++n7) {
                    n6 = dataInputStream.readInt();
                }
                n7 = dataInputStream.readInt();
                n6 = dataInputStream.readInt();
                int n10 = dataInputStream.readInt();
                int n11 = dataInputStream.readInt();
                int n12 = dataInputStream.readInt();
                System.out.println("File Name:          " + this.input_file_name + "\n");
                System.out.println("File Type:          " + n8);
                System.out.println("File Version:       " + f);
                System.out.println("Header Length:      " + n9);
                System.out.println("Max Days:           " + n7);
                System.out.println("Num Days:           " + n6);
                System.out.println("Num Levels:         " + n10);
                System.out.println("Num Groups:         " + n11);
                System.out.println("Num Subgroups:      " + n12 + "\n");
                for (n5 = 0; n5 < 5; ++n5) {
                    n4 = dataInputStream.readInt();
                }
                n5 = dataInputStream.readInt();
                n4 = dataInputStream.readInt();
                String string = "";
                for (int i = 0; i < 8; ++i) {
                    n3 = dataInputStream.readInt();
                    if (n3 == Short.MIN_VALUE) continue;
                    string = string + (char)n3;
                }
                string = string.trim();
                String string2 = "";
                for (n3 = 0; n3 < 50; ++n3) {
                    n2 = dataInputStream.readInt();
                    if (n2 == Short.MIN_VALUE) continue;
                    string2 = string2 + (char)n2;
                }
                string2 = string2.trim();
                System.out.println("Baseline group:     " + n5);
                System.out.println("Baseline type:      " + n4);
                System.out.println("Radiosonde:         " + string);
                System.out.println("Baseline System:    " + string2 + "\n");
                n3 = 99999999;
                n2 = -99999999;
                int[] nArray = new int[n6];
                for (int i = 0; i < n6; ++i) {
                    nArray[i] = dataInputStream.readInt();
                    n3 = Math.min(n3, nArray[i]);
                    n2 = Math.max(n2, nArray[i]);
                }
                System.out.println("Date range in file: " + n3 + "   " + n2 + "\n");
                System.out.println("Data Blocks:");
                int[] nArray2 = new int[n10];
                float[] fArray = new float[n10];
                int[] nArray3 = new int[n10];
                String[] stringArray = new String[n10];
                int[] nArray4 = new int[n10];
                String[] stringArray2 = new String[]{"(sample size)", "(temperature)", "(water vapor)"};
                int n13 = n9;
                for (int i = 0; i < n10; ++i) {
                    nArray2[i] = dataInputStream.readInt();
                    fArray[i] = (float)dataInputStream.readInt() / 100.0f;
                    nArray3[i] = dataInputStream.readInt();
                    nArray4[i] = n13;
                    n13 += nArray3[i];
                    stringArray[i] = "";
                    for (int j = 0; j < 50; ++j) {
                        n = dataInputStream.readInt();
                        if (n == Short.MIN_VALUE) continue;
                        stringArray[i] = stringArray[i] + (char)n;
                    }
                    stringArray[i] = stringArray[i].trim();
                    System.out.println("  Data Block:     " + i);
                    System.out.println("  Block Type:     " + nArray2[i] + "   " + stringArray2[nArray2[i]]);
                    System.out.println("  Block Pressure: " + fArray[i]);
                    System.out.println("  Block Name:     " + stringArray[i] + "\n");
                }
                System.out.println("");
                int[] nArray5 = new int[n11 + 5];
                String[] stringArray3 = new String[n11 + 5];
                nArray5[0] = 0;
                nArray5[1] = 0;
                nArray5[2] = 0;
                nArray5[3] = 0;
                nArray5[4] = 0;
                stringArray3[0] = "Radiosonde";
                stringArray3[1] = "Raob 00Z";
                stringArray3[2] = "Raob 06Z";
                stringArray3[3] = "Raob 12Z";
                stringArray3[4] = "Raob 18Z";
                for (n = 5; n < n11 + 5; ++n) {
                    nArray5[n] = dataInputStream.readInt();
                    stringArray3[n] = "";
                    for (int i = 0; i < 50; ++i) {
                        int n14 = dataInputStream.readInt();
                        if (n14 == Short.MIN_VALUE) continue;
                        stringArray3[n] = stringArray3[n] + (char)n14;
                    }
                    stringArray3[n] = stringArray3[n].trim();
                }
                System.out.println("Data Groups (used for sample size graphs):");
                for (n = 0; n < n11; ++n) {
                    System.out.println("  Data Group:      " + n);
                    System.out.println("  Data Group ID:   " + nArray5[n]);
                    System.out.println("  Data Group Name: " + stringArray3[n] + "\n");
                }
                System.out.println("");
                System.out.println("Subgroups (used for temperature and water vapor graphs)");
                int[] nArray6 = new int[n12];
                int[] nArray7 = new int[n12];
                int[] nArray8 = new int[n12];
                String[] stringArray4 = new String[n12];
                for (int i = 0; i < n12; ++i) {
                    nArray6[i] = dataInputStream.readInt();
                    nArray7[i] = dataInputStream.readInt();
                    nArray8[i] = dataInputStream.readInt();
                    stringArray4[i] = "";
                    for (int j = 0; j < 50; ++j) {
                        int n15 = dataInputStream.readInt();
                        if (n15 == Short.MIN_VALUE) continue;
                        stringArray4[i] = stringArray4[i] + (char)n15;
                    }
                    stringArray4[i] = stringArray4[i].trim();
                    System.out.println("  Subgroup:                  " + i);
                    System.out.println("  Group/Subbroup Number:     " + nArray6[i] + " / " + nArray7[i]);
                    System.out.println("  Subgroup Type:             " + nArray8[i]);
                    System.out.println("  Subgroup Name:             " + stringArray3[nArray6[i] + 5] + " " + stringArray4[i] + "\n");
                }
                System.out.println("");
            }
            catch (IOException iOException) {
                System.out.println("*** An error occurred reading the NARCS file.\n");
                iOException.printStackTrace();
            }
        } else {
            System.out.println("The show_file_info flag is set to 'yes' but the input file name");
            System.out.println("could not be read from the parameter file.  Please check the parameter");
            System.out.println("file and make sure the the input_file_name tag is included.\n\n");
        }
    }

    public void drawTitle(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        String string = "NOAA/NESDIS/STAR NPROVS Collocation Summary Statistics (NARCS)";
        int n5 = n4;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = 25;
        boolean bl = false;
        while (!bl && n6 > 5) {
            graphics2D.setFont(new Font(this.font_name, this.font_style, --n6));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 || fontMetrics.stringWidth(string) >= n3 - n5 * 2) continue;
            bl = true;
        }
        int n7 = n + (n3 / 2 - fontMetrics.stringWidth(string) / 2);
        int n8 = n2 + fontMetrics.getHeight();
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n7, n8);
        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/faded_noaa.gif")));
        JPanel jPanel = new JPanel();
        graphics2D.drawImage(imageIcon.getImage(), n, n2, n5, n5, jPanel);
    }

    private void readNarcsFileHeader() {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.input_file_name));
            if (this.input_file_name.endsWith(".gz")) {
                dataInputStream = new DataInputStream(new GZIPInputStream(new FileInputStream(this.input_file_name)));
            }
            int n10 = dataInputStream.readInt();
            float f = (float)dataInputStream.readInt() / 10.0f;
            int n11 = dataInputStream.readInt();
            for (n9 = 0; n9 < 7; ++n9) {
                n8 = dataInputStream.readInt();
            }
            n9 = dataInputStream.readInt();
            this.num_days = dataInputStream.readInt();
            n8 = dataInputStream.readInt();
            this.num_data_groups = dataInputStream.readInt();
            this.num_subgroups = dataInputStream.readInt();
            for (n7 = 0; n7 < 5; ++n7) {
                n6 = dataInputStream.readInt();
            }
            n7 = dataInputStream.readInt();
            n6 = dataInputStream.readInt();
            String string = "";
            for (int i = 0; i < 8; ++i) {
                n5 = dataInputStream.readInt();
                if (n5 == Short.MIN_VALUE) continue;
                string = string + (char)n5;
            }
            string = string.trim();
            String string2 = "";
            for (n5 = 0; n5 < 50; ++n5) {
                n4 = dataInputStream.readInt();
                if (n4 == Short.MIN_VALUE) continue;
                string2 = string2 + (char)n4;
            }
            string2 = string2.trim();
            n5 = 99999999;
            n4 = -99999999;
            this.dates = new int[this.num_days];
            for (int i = 0; i < this.num_days; ++i) {
                this.dates[i] = dataInputStream.readInt();
                n5 = Math.min(n5, this.dates[i]);
                n4 = Math.max(n4, this.dates[i]);
            }
            this.globals.setDates(this.dates);
            this.globals.setEarliestDataDate(n5);
            this.globals.setLatestDataDate(n4);
            this.globals.setCurrentStartDate(n5);
            this.globals.setCurrentEndDate(n4);
            this.data_block_type = new int[n8];
            float[] fArray = new float[n8];
            int[] nArray = new int[n8];
            this.data_block_name = new String[n8];
            this.data_block_offset = new int[n8];
            int n12 = n11;
            for (int i = 0; i < n8; ++i) {
                this.data_block_type[i] = dataInputStream.readInt();
                fArray[i] = (float)dataInputStream.readInt() / 100.0f;
                nArray[i] = dataInputStream.readInt();
                this.data_block_offset[i] = n12;
                n12 += nArray[i];
                this.data_block_name[i] = "";
                for (n3 = 0; n3 < 50; ++n3) {
                    n2 = dataInputStream.readInt();
                    if (n2 == Short.MIN_VALUE) continue;
                    this.data_block_name[i] = this.data_block_name[i] + (char)n2;
                }
                this.data_block_name[i] = this.data_block_name[i].trim();
            }
            int[] nArray2 = new int[this.num_data_groups + 5];
            this.data_group_name = new String[this.num_data_groups + 5];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray2[4] = 0;
            this.data_group_name[0] = "Radiosonde";
            this.data_group_name[1] = "Raob 00Z";
            this.data_group_name[2] = "Raob 06Z";
            this.data_group_name[3] = "Raob 12Z";
            this.data_group_name[4] = "Raob 18Z";
            for (n3 = 5; n3 < this.num_data_groups + 5; ++n3) {
                nArray2[n3] = dataInputStream.readInt();
                this.data_group_name[n3] = "";
                for (n2 = 0; n2 < 50; ++n2) {
                    int n13 = dataInputStream.readInt();
                    if (n13 == Short.MIN_VALUE) continue;
                    this.data_group_name[n3] = this.data_group_name[n3] + (char)n13;
                }
                this.data_group_name[n3] = this.data_group_name[n3].trim();
            }
            int[] nArray3 = new int[this.num_subgroups];
            int[] nArray4 = new int[this.num_subgroups];
            int[] nArray5 = new int[this.num_subgroups];
            String[] stringArray = new String[this.num_subgroups];
            for (n = 0; n < this.num_subgroups; ++n) {
                nArray3[n] = dataInputStream.readInt();
                nArray4[n] = dataInputStream.readInt();
                nArray5[n] = dataInputStream.readInt();
                stringArray[n] = "";
                for (int i = 0; i < 50; ++i) {
                    int n14 = dataInputStream.readInt();
                    if (n14 == Short.MIN_VALUE) continue;
                    stringArray[n] = stringArray[n] + (char)n14;
                }
                stringArray[n] = stringArray[n].trim();
            }
            this.full_subgroup_name = new String[this.num_subgroups];
            for (n = 0; n < this.num_subgroups; ++n) {
                this.full_subgroup_name[n] = this.data_group_name[nArray3[n] + 5] + " " + stringArray[n];
            }
            boolean[] blArray = new boolean[this.num_data_groups + 5];
            Arrays.fill(blArray, false);
            blArray[0] = true;
            this.globals.setShowDataGroups(blArray);
            boolean[] blArray2 = new boolean[this.num_subgroups];
            Arrays.fill(blArray2, false);
            blArray2[0] = true;
            this.globals.setShowSubGroups(blArray2);
        }
        catch (IOException iOException) {
            System.out.println("*** Error reading the NARCS file ***");
            System.out.println("The image will be skipped.\n");
            iOException.printStackTrace();
        }
    }

    private void saveImage(BufferedImage bufferedImage) {
        try {
            File file = new File(this.output_file_name);
            ImageIO.write((RenderedImage)bufferedImage, this.output_image_type, file);
        }
        catch (Exception exception) {
            System.out.println("Could not save the image: " + this.output_file_name);
        }
    }

    private void initializeImageParameters() {
        this.output_file_name = null;
        this.output_image_type = "png";
        this.image_width = 800;
        this.image_height = 600;
        this.input_file_name = null;
        this.start_date = Short.MIN_VALUE;
        this.end_date = Short.MIN_VALUE;
        this.data_block = 0;
        this.min_max_option = 1;
        this.data_min = -5.0f;
        this.data_max = 5.0f;
        this.ignore_extreme_values = false;
        this.time_option = 1;
        this.line_thickness = 0;
        this.show_data_points = false;
        this.font_name = "SansSerif";
        this.font_style = 0;
        this.show_bias = true;
        this.show_stddev = true;
        this.show_rms = false;
        this.show_samplesize = false;
        this.show_passfail = false;
        this.show_pass = true;
        this.show_fail = false;
        this.show_seanonsea = true;
        this.show_sea = false;
        this.show_nonsea = false;
        this.show_clearcloudy = true;
        this.show_clear = false;
        this.show_cloudy = false;
        this.profile_names = new String[1];
        this.profile_numbers = new int[1];
        this.profile_reds = new int[1];
        this.profile_greens = new int[1];
        this.profile_blues = new int[1];
        this.profile_names[0] = null;
        this.profile_numbers[0] = 0;
        this.profile_reds[0] = Short.MIN_VALUE;
        this.profile_greens[0] = Short.MIN_VALUE;
        this.profile_blues[0] = Short.MIN_VALUE;
    }

    private void processImageParameters(XMLTree xMLTree) {
        Object object;
        Object object2 = xMLTree.getValue("output_file_name");
        if (object2 != null && object2 instanceof String) {
            this.output_file_name = (String)object2;
        }
        if ((object2 = xMLTree.getValue("file_type")) != null && object2 instanceof String) {
            this.output_image_type = (String)object2;
        }
        if ((object2 = xMLTree.getValue("image_height")) != null && object2 instanceof String) {
            this.image_height = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("image_width")) != null && object2 instanceof String) {
            this.image_width = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("input_file_name")) != null && object2 instanceof String) {
            this.input_file_name = (String)object2;
        }
        if ((object2 = xMLTree.getValue("time_option")) != null && object2 instanceof String) {
            object = (String)object2;
            if (((String)object).equals("daily")) {
                this.time_option = 0;
            } else if (((String)object).equals("weekly")) {
                this.time_option = 1;
            } else if (((String)object).equals("monthly")) {
                this.time_option = 2;
            }
        }
        if ((object2 = xMLTree.getValue("start_date")) != null && object2 instanceof String) {
            this.start_date = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("end_date")) != null && object2 instanceof String) {
            this.end_date = Integer.parseInt((String)object2);
        }
        if (this.global_start_date != 0 && this.global_end_date != 0) {
            this.start_date = this.global_start_date;
            this.end_date = this.global_end_date;
        }
        if ((object2 = xMLTree.getValue("data_type_block")) != null && object2 instanceof String) {
            this.data_block = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("min_max_option")) != null && object2 instanceof String) {
            this.min_max_option = Integer.parseInt((String)object2);
            if (this.min_max_option < 0 || this.min_max_option > 2) {
                this.min_max_option = 1;
            }
        }
        if ((object2 = xMLTree.getValue("data_min")) != null && object2 instanceof String) {
            this.data_min = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("data_max")) != null && object2 instanceof String) {
            this.data_max = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("ignore_extreme_values")) != null && object2 instanceof String) {
            object = (String)object2;
            this.ignore_extreme_values = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("line_thickness")) != null && object2 instanceof String) {
            this.line_thickness = Integer.parseInt((String)object2);
            this.line_thickness = Math.max(this.line_thickness, 0);
        }
        if ((object2 = xMLTree.getValue("font_name")) != null && object2 instanceof String) {
            this.font_name = ((String)object2).toLowerCase();
            if (this.font_name.equals("dialog")) {
                this.font_name = "Dialog";
            } else if (this.font_name.equals("monospaced")) {
                this.font_name = "Monospaced";
            } else if (this.font_name.equals("serif")) {
                this.font_name = "Serif";
            } else if (this.font_name.equals("sansserif")) {
                this.font_name = "SansSerif";
            } else {
                System.out.println("Invalid font name: " + this.font_name);
                System.out.println("Valid names are: dialog, monospaced, serif, sansserif");
                System.out.println("SansSerif will be used by default\n");
                this.font_name = "SansSerif";
            }
        }
        if ((object2 = xMLTree.getValue("font_style")) != null && object2 instanceof String) {
            object = ((String)object2).toLowerCase();
            if (((String)object).equals("plain")) {
                this.font_style = 0;
            } else if (((String)object).equals("bold")) {
                this.font_style = 1;
            } else if (((String)object).equals("italic")) {
                this.font_style = 2;
            } else {
                System.out.println("Invalid font style: " + (String)object);
                System.out.println("Valid names are: plain, bold, italic");
                System.out.println("Plain will be used by default\n");
                this.font_style = 0;
            }
        }
        if ((object2 = xMLTree.getValue("show_data_points")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_data_points = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_bias")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_bias = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_stddev")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_stddev = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_rms")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_rms = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_samplesize")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_samplesize = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_passfail")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_passfail = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_pass")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_pass = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_fail")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_fail = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_seanonsea")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_seanonsea = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_sea")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_sea = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_nonsea")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_nonsea = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_clearcloudy")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_clearcloudy = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_clear")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_clear = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_cloudy")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_cloudy = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("profiles")) != null && object2 instanceof Vector) {
            object = (Vector)object2;
            this.profile_names = new String[((Vector)object).size()];
            this.profile_numbers = new int[((Vector)object).size()];
            this.profile_reds = new int[((Vector)object).size()];
            this.profile_greens = new int[((Vector)object).size()];
            this.profile_blues = new int[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.profile_names[i] = null;
                this.profile_numbers[i] = 0;
                this.profile_reds[i] = Short.MIN_VALUE;
                this.profile_greens[i] = Short.MIN_VALUE;
                this.profile_blues[i] = Short.MIN_VALUE;
                object2 = ((Vector)object).elementAt(i);
                if (!(object2 instanceof XMLTree)) continue;
                XMLTree xMLTree2 = (XMLTree)object2;
                if ((object2 = xMLTree2.getValue("name")) != null && object2 instanceof String) {
                    this.profile_names[i] = (String)object2;
                }
                if ((object2 = xMLTree2.getValue("number")) != null && object2 instanceof String) {
                    this.profile_numbers[i] = Integer.parseInt((String)object2);
                }
                if ((object2 = xMLTree2.getValue("red")) != null && object2 instanceof String) {
                    this.profile_reds[i] = Integer.parseInt((String)object2);
                    if (this.profile_reds[i] < 0 || this.profile_reds[i] > 255) {
                        this.profile_reds[i] = Short.MIN_VALUE;
                    }
                }
                if ((object2 = xMLTree2.getValue("green")) != null && object2 instanceof String) {
                    this.profile_greens[i] = Integer.parseInt((String)object2);
                    if (this.profile_greens[i] < 0 || this.profile_greens[i] > 255) {
                        this.profile_greens[i] = Short.MIN_VALUE;
                    }
                }
                if ((object2 = xMLTree2.getValue("blue")) == null || !(object2 instanceof String)) continue;
                this.profile_blues[i] = Integer.parseInt((String)object2);
                if (this.profile_blues[i] >= 0 && this.profile_blues[i] <= 255) continue;
                this.profile_blues[i] = Short.MIN_VALUE;
            }
        }
    }

    private void updateGlobalSettings() {
        this.globals.setTimeWindowOption(this.time_option);
        this.globals.setCurrentStartDate(this.start_date);
        this.globals.setCurrentEndDate(this.end_date);
        this.globals.setSampleSizeMinMaxOption(this.min_max_option);
        this.globals.setTempMinMaxOption(this.min_max_option);
        this.globals.setWvapMinMaxOption(this.min_max_option);
        this.globals.setSampleSizeManualMin(this.data_min);
        this.globals.setTempManualMin(this.data_min);
        this.globals.setWvapManualMin(this.data_min);
        this.globals.setSampleSizeManualMax(this.data_max);
        this.globals.setTempManualMax(this.data_max);
        this.globals.setWvapManualMax(this.data_max);
        this.globals.setSampleSizeIgnoreExtremes(this.ignore_extreme_values);
        this.globals.setTempIgnoreExtremes(this.ignore_extreme_values);
        this.globals.setWvapIgnoreExtremes(this.ignore_extreme_values);
        this.globals.setShowDataPoints(this.show_data_points);
        this.globals.setShowBias(this.show_bias);
        this.globals.setShowStdDev(this.show_stddev);
        this.globals.setShowRMS(this.show_rms);
        this.globals.setShowSampleSize(this.show_samplesize);
        this.globals.setShowPassedAndFailedQC(this.show_passfail);
        this.globals.setShowPassedQC(this.show_pass);
        this.globals.setShowFailedQC(this.show_fail);
        this.globals.setShowSeaAndNonsea(this.show_seanonsea);
        this.globals.setShowSea(this.show_sea);
        this.globals.setShowNonsea(this.show_nonsea);
        this.globals.setShowClearAndCloudy(this.show_clearcloudy);
        this.globals.setShowClear(this.show_clear);
        this.globals.setShowCloudy(this.show_cloudy);
        boolean[] blArray = this.globals.getShowDataGroups();
        Arrays.fill(blArray, false);
        boolean[] blArray2 = this.globals.getShowSubGroups();
        Arrays.fill(blArray2, false);
        for (int i = 0; i < this.profile_numbers.length; ++i) {
            if (this.profile_numbers[i] < 0) continue;
            if (this.profile_numbers[i] < blArray.length) {
                blArray[this.profile_numbers[i]] = true;
            }
            if (this.profile_numbers[i] >= blArray2.length) continue;
            if (this.profile_names[i] != null) {
                this.full_subgroup_name[this.profile_numbers[i]] = this.profile_names[i];
            }
            blArray2[this.profile_numbers[i]] = true;
        }
        this.globals.setShowDataGroups(blArray);
        this.globals.setShowSubGroups(blArray2);
    }

    private void printTime() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(10);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        String string = "" + n + ":";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + ":";
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + n3 + "\t";
        System.out.println(string);
    }
}

