/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NARCS
extends JFrame
implements ActionListener,
ChangeListener,
ComponentListener,
Printable {
    static final JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu file_menu;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miClose;
    protected JMenuItem miSave;
    protected JMenuItem miPageSetup;
    protected JMenuItem miPrintPreview;
    protected JMenuItem miPrint;
    protected JMenuItem miQuit;
    protected JMenu help_menu;
    protected JMenuItem miAbout;
    private JTabbedPane tabbed_pane;
    private SampleSizePanel sample_size_panel;
    private StatPanel temperature_panel;
    private StatPanel moisture_panel;
    private int current_panel;
    private String file_name;
    private int[] data_block_type;
    private PageFormat page_format;
    private NarcsGlobals globals;
    private final int SAMPLE_SIZE = 0;
    private final int TEMPERATURE = 1;
    private final int MOISTURE = 2;
    private final String version = "1.5.3";
    private final String date = "June 9, 2011";

    public static void main(String[] stringArray) {
        NARCS nARCS = new NARCS();
    }

    public NARCS() {
        this.setTitle("NPROVS Archive Statistics (NARCS) -- version 1.5.3");
        this.restoreSettings();
        this.addMenus();
        Point point = this.globals.getWindowPosition();
        Dimension dimension = this.globals.getWindowDimension();
        this.setBounds(point.x, point.y, dimension.width, dimension.height);
        this.sample_size_panel = new SampleSizePanel();
        this.temperature_panel = new StatPanel(1);
        this.moisture_panel = new StatPanel(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.tabbed_pane = new JTabbedPane();
        this.tabbed_pane.add("Sample Size", this.sample_size_panel);
        this.tabbed_pane.add("Temperature", this.temperature_panel);
        this.tabbed_pane.add("Moisture", this.moisture_panel);
        this.tabbed_pane.addChangeListener(this);
        this.getContentPane().add(this.tabbed_pane);
        this.setVisible(true);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NARCS.this.setVisible(false);
                NARCS.this.handleQuit();
            }
        };
        this.addWindowListener(windowAdapter);
        this.addComponentListener(this);
        this.pickAFileToOpen();
        this.tabbed_pane.setSelectedIndex(this.globals.getLastSelectedTab());
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.globals.setWindowPosition(new Point(this.getX(), this.getY()));
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.globals.setWindowDimension(new Dimension(this.getWidth(), this.getHeight()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.miOpen.getActionCommand())) {
            this.openFile();
        } else if (actionEvent.getActionCommand().equals(this.miClose.getActionCommand())) {
            this.closeFile();
        } else if (actionEvent.getActionCommand().equals(this.miSave.getActionCommand())) {
            this.saveImage();
        } else if (actionEvent.getActionCommand().equals(this.miPageSetup.getActionCommand())) {
            this.pageSetup();
        } else if (actionEvent.getActionCommand().equals(this.miPrintPreview.getActionCommand())) {
            this.printPreview();
        } else if (actionEvent.getActionCommand().equals(this.miPrint.getActionCommand())) {
            this.printImage();
        } else if (actionEvent.getActionCommand().equals(this.miQuit.getActionCommand())) {
            this.handleQuit();
        } else if (actionEvent.getActionCommand().equals(this.miAbout.getActionCommand())) {
            this.showAboutDialog();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabbed_pane) {
            int n = this.tabbed_pane.getSelectedIndex();
            this.globals.setLastSelectedTab(n);
            if (n != this.current_panel) {
                if (this.current_panel == 0) {
                    this.sample_size_panel.panelSelected();
                } else if (this.current_panel == 1) {
                    this.temperature_panel.panelSelected();
                } else if (this.current_panel == 2) {
                    this.moisture_panel.panelSelected();
                }
                this.current_panel = n;
                if (n == 0) {
                    this.sample_size_panel.panelSelected();
                } else if (n == 1) {
                    this.temperature_panel.panelSelected();
                } else if (n == 2) {
                    this.moisture_panel.panelSelected();
                }
            }
        }
    }

    private void openFile() {
        this.file_name = "summary_file.dat";
        String string = this.globals.getLastFileDirectory();
        JFileChooser jFileChooser = new JFileChooser();
        String string2 = string;
        jFileChooser.setCurrentDirectory(new File(string2));
        Dimension dimension = new Dimension(700, 400);
        jFileChooser.setMinimumSize(dimension);
        jFileChooser.setPreferredSize(dimension);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string3;
            this.file_name = jFileChooser.getSelectedFile().getName();
            string = jFileChooser.getCurrentDirectory().getPath();
            if (!string.endsWith(string3 = System.getProperty("file.separator"))) {
                string = string + string3;
            }
            this.globals.setLastFileDirectory(string);
            try {
                this.file_name = string + this.file_name;
                this.readFileHeader();
            }
            catch (Exception exception) {
                String string4 = "An error occurred while trying to open the file: " + this.file_name;
                System.out.println(string4 + "\n");
                exception.printStackTrace();
            }
        }
    }

    private void closeFile() {
        this.file_name = null;
        this.globals.setCurrentFileName(this.file_name);
        this.miClose.setEnabled(false);
        this.tabbed_pane.removeChangeListener(this);
        this.tabbed_pane.removeAll();
        this.sample_size_panel = new SampleSizePanel();
        this.temperature_panel = new StatPanel(1);
        this.moisture_panel = new StatPanel(2);
        this.tabbed_pane.add("Sample Size", this.sample_size_panel);
        this.tabbed_pane.add("Temperature", this.temperature_panel);
        this.tabbed_pane.add("Moisture", this.moisture_panel);
        this.tabbed_pane.addChangeListener(this);
    }

    private void readFileHeader() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            DataInputStream dataInputStream = null;
            if (this.file_name.equals("narcs_default.dat")) {
                InputStream inputStream = this.getClass().getResourceAsStream(this.file_name);
                dataInputStream = new DataInputStream(inputStream);
            } else {
                dataInputStream = this.file_name.endsWith(".gz") ? new DataInputStream(new GZIPInputStream(new FileInputStream(this.file_name))) : new DataInputStream(new FileInputStream(this.file_name));
            }
            int n10 = dataInputStream.readInt();
            float f = (float)dataInputStream.readInt() / 10.0f;
            int n11 = dataInputStream.readInt();
            for (n9 = 0; n9 < 7; ++n9) {
                n8 = dataInputStream.readInt();
            }
            n9 = dataInputStream.readInt();
            n8 = dataInputStream.readInt();
            int n12 = dataInputStream.readInt();
            int n13 = dataInputStream.readInt();
            int n14 = dataInputStream.readInt();
            for (n7 = 0; n7 < 5; ++n7) {
                n6 = dataInputStream.readInt();
            }
            n7 = dataInputStream.readInt();
            n6 = dataInputStream.readInt();
            String string = "";
            for (int i = 0; i < 8; ++i) {
                n5 = dataInputStream.readInt();
                if (n5 == Short.MIN_VALUE) continue;
                string = string + (char)n5;
            }
            string = string.trim();
            String string2 = "";
            for (n5 = 0; n5 < 50; ++n5) {
                n4 = dataInputStream.readInt();
                if (n4 == Short.MIN_VALUE) continue;
                string2 = string2 + (char)n4;
            }
            string2 = string2.trim();
            n5 = 99999999;
            n4 = -99999999;
            int[] nArray = new int[n8];
            for (int i = 0; i < n8; ++i) {
                nArray[i] = dataInputStream.readInt();
                n5 = Math.min(n5, nArray[i]);
                n4 = Math.max(n4, nArray[i]);
            }
            this.globals.setDates(nArray);
            this.globals.setEarliestDataDate(n5);
            this.globals.setLatestDataDate(n4);
            this.globals.setCurrentStartDate(n5);
            this.globals.setCurrentEndDate(n4);
            this.data_block_type = new int[n12];
            float[] fArray = new float[n12];
            int[] nArray2 = new int[n12];
            String[] stringArray = new String[n12];
            int[] nArray3 = new int[n12];
            int n15 = n11;
            for (int i = 0; i < n12; ++i) {
                this.data_block_type[i] = dataInputStream.readInt();
                fArray[i] = (float)dataInputStream.readInt() / 100.0f;
                nArray2[i] = dataInputStream.readInt();
                nArray3[i] = n15;
                n15 += nArray2[i];
                stringArray[i] = "";
                for (int j = 0; j < 50; ++j) {
                    n3 = dataInputStream.readInt();
                    if (n3 == Short.MIN_VALUE) continue;
                    stringArray[i] = stringArray[i] + (char)n3;
                }
                stringArray[i] = stringArray[i].trim();
            }
            int[] nArray4 = new int[n13];
            String[] stringArray2 = new String[n13];
            for (n3 = 0; n3 < n13; ++n3) {
                nArray4[n3] = dataInputStream.readInt();
                stringArray2[n3] = "";
                for (int i = 0; i < 50; ++i) {
                    int n16 = dataInputStream.readInt();
                    if (n16 == Short.MIN_VALUE) continue;
                    stringArray2[n3] = stringArray2[n3] + (char)n16;
                }
                stringArray2[n3] = stringArray2[n3].trim();
            }
            int[] nArray5 = new int[n14];
            int[] nArray6 = new int[n14];
            int[] nArray7 = new int[n14];
            String[] stringArray3 = new String[n14];
            Color[] colorArray = new Color[n14];
            int[][][] nArray8 = new int[n14][27][4];
            int[][][] nArray9 = new int[n14][27][4];
            for (int i = 0; i < n14; ++i) {
                nArray5[i] = dataInputStream.readInt();
                nArray6[i] = dataInputStream.readInt();
                nArray7[i] = dataInputStream.readInt();
                stringArray3[i] = "";
                for (int j = 0; j < 50; ++j) {
                    n2 = dataInputStream.readInt();
                    if (n2 == Short.MIN_VALUE) continue;
                    stringArray3[i] = stringArray3[i] + (char)n2;
                }
                stringArray3[i] = stringArray3[i].trim();
                object = this.globals.getGroupColor(nArray5[i] + 5);
                for (n2 = 0; n2 < nArray6[i]; ++n2) {
                    object = n2 % 2 == 0 ? ((Color)object).brighter() : ((Color)object).darker();
                }
                colorArray[i] = object;
                for (n2 = 0; n2 < 27; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        nArray8[i][n2][n] = 0;
                        nArray9[i][n2][n] = n;
                    }
                }
            }
            this.globals.setDefaultSubgroupColors(colorArray);
            this.globals.setSubgroupColors(colorArray);
            this.globals.setDefaultSubgroupLineThicknesses(nArray8);
            this.globals.setSubgroupLineThicknesses(nArray8);
            this.globals.setDefaultSubgroupLineStyles(nArray9);
            this.globals.setSubgroupLineStyles(nArray9);
            boolean[] blArray = new boolean[n13 + 5];
            Arrays.fill(blArray, false);
            blArray[0] = true;
            this.globals.setShowDataGroups(blArray);
            object = new boolean[n14];
            Arrays.fill((boolean[])object, false);
            object[0] = true;
            this.globals.setShowSubGroups((boolean[])object);
            n2 = 0;
            n = 0;
            for (int i = 0; i < n12; ++i) {
                if (this.data_block_type[i] == 1) {
                    ++n2;
                    continue;
                }
                if (this.data_block_type[i] != 2) continue;
                ++n;
            }
            int[] nArray10 = new int[n2];
            String[] stringArray4 = new String[n2];
            int[] nArray11 = new int[n];
            String[] stringArray5 = new String[n];
            int n17 = Short.MIN_VALUE;
            int n18 = -1;
            int n19 = -1;
            for (int i = 0; i < n12; ++i) {
                if (this.data_block_type[i] == 1) {
                    nArray10[++n18] = nArray3[i];
                    stringArray4[n18] = stringArray[i];
                    continue;
                }
                if (this.data_block_type[i] == 2) {
                    nArray11[++n19] = nArray3[i];
                    stringArray5[n19] = stringArray[i];
                    continue;
                }
                if (this.data_block_type[i] != 0) continue;
                n17 = nArray3[i];
            }
            this.sample_size_panel.addFileInfo(this, this.file_name, n17, n8, nArray, n13, nArray4, stringArray2);
            this.temperature_panel.addFileInfo(this, this.file_name, nArray10, stringArray4, n8, nArray, n14, nArray5, nArray6, nArray7, stringArray3, n13, stringArray2);
            this.moisture_panel.addFileInfo(this, this.file_name, nArray11, stringArray5, n8, nArray, n14, nArray5, nArray6, nArray7, stringArray3, n13, stringArray2);
            this.current_panel = this.tabbed_pane.getSelectedIndex();
            if (this.current_panel == 0) {
                this.sample_size_panel.panelSelected();
            } else if (this.current_panel == 1) {
                this.temperature_panel.panelSelected();
            } else if (this.current_panel == 2) {
                this.moisture_panel.panelSelected();
            }
            this.miSave.setEnabled(true);
            this.miPageSetup.setEnabled(true);
            this.miPrintPreview.setEnabled(true);
            this.miPrint.setEnabled(true);
            this.globals.setCurrentFileName(this.file_name);
            this.miClose.setEnabled(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        this.setCursor(cursor);
    }

    private void handleQuit() {
        this.saveSettings();
        System.exit(0);
    }

    private void saveSettings() {
        try {
            String string = System.getProperty("user.dir") + System.getProperty("file.separator") + "narcs_saved_state_v01.dat";
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.globals);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            String string = "The state of the program could not be saved because of an\nerror that occured while trying to write the saved state file.\n\n";
            ErrorHandler errorHandler = new ErrorHandler(string, "NARCS", "saveSettings", exception, false);
        }
    }

    private void restoreSettings() {
        this.globals = new NarcsGlobals();
        try {
            String string = System.getProperty("user.dir") + System.getProperty("file.separator") + "narcs_saved_state_v01.dat";
            File file = new File(string);
            if (file.isFile()) {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.globals = (NarcsGlobals)objectInputStream.readObject();
            } else {
                String string2 = "The state of the program could not be restored because\nthe saved state file could not be found. The program\nwill start with a default state. Name of saved state file:\n\n" + string;
                System.out.println(string2);
            }
        }
        catch (Exception exception) {
            String string = "The state of the program could not be restored because of an\nerror that occured while trying to read the saved state file.\nAs a result, the program will start in a default state.\nIn theory this problem should not happen but something unexpected\nhappened. If it continues, please contact the developer of this\nprogram.\n\n";
            System.out.println(string);
        }
    }

    private void saveImage() {
        String string = "nprovs_summary_stats.jpg";
        String string2 = null;
        String string3 = System.getProperty("user.dir");
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        ImageSizeDialog imageSizeDialog = new ImageSizeDialog(null, dimension);
        imageSizeDialog.setLocationRelativeTo(this);
        imageSizeDialog.setVisible(true);
        dimension = imageSizeDialog.getChosenSize();
        if (dimension.width != -1) {
            n = dimension.width;
            n2 = dimension.height;
            JFileChooser jFileChooser = new JFileChooser();
            String string4 = this.globals.getImageDirectory();
            if (string4 == null) {
                string4 = System.getProperty("user.dir");
            }
            jFileChooser.setCurrentDirectory(new File(string4));
            dimension = new Dimension(700, 400);
            jFileChooser.setMinimumSize(dimension);
            jFileChooser.setPreferredSize(dimension);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new ImageFileFilter("jpg"));
            jFileChooser.setFileFilter(new ImageFileFilter("png"));
            int n3 = jFileChooser.showSaveDialog(this);
            if (n3 == 0) {
                String string5 = jFileChooser.getFileFilter().getDescription().substring(2);
                if (!string5.equals("jpg") && !string5.equals("png")) {
                    string5 = "png";
                }
                string2 = jFileChooser.getSelectedFile().getName();
                string3 = jFileChooser.getCurrentDirectory().getPath();
                this.globals.setImageDirectory(string3);
                String string6 = System.getProperty("file.separator");
                if (!string3.endsWith(string6)) {
                    string3 = string3 + string6;
                }
                try {
                    Cursor cursor = this.getCursor();
                    this.setCursor(new Cursor(3));
                    string = string3 + string2;
                    if (!string.endsWith("." + string5)) {
                        string = string + "." + string5;
                    }
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    this.makeImage(graphics2D, 0, 0, n, n2);
                    File file = new File(string);
                    ImageIO.write((RenderedImage)bufferedImage, string5, file);
                    graphics2D.dispose();
                    this.setCursor(cursor);
                    JOptionPane.showMessageDialog(null, "The image has been saved.", "Image Saved", 1);
                }
                catch (Exception exception) {
                    String string7 = "An error occurred while trying to save the image: " + string;
                    System.out.println(string7 + "\n");
                    exception.printStackTrace();
                }
            }
        }
    }

    private void pageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.page_format == null) {
            this.page_format = printerJob.defaultPage();
            this.page_format.setOrientation(0);
        }
        this.page_format = printerJob.pageDialog(this.page_format);
    }

    private void printPreview() {
        PrintPreviewDialog printPreviewDialog = new PrintPreviewDialog(this.makeBook());
        printPreviewDialog.setVisible(true);
    }

    private void printImage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.page_format == null) {
            this.page_format = printerJob.defaultPage();
            this.page_format.setOrientation(0);
        }
        printerJob.setPageable(this.makeBook());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.black);
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        this.makeImage(graphics2D, 0, 0, n2, n3);
        return 0;
    }

    private Book makeBook() {
        Object object;
        if (this.page_format == null) {
            object = PrinterJob.getPrinterJob();
            this.page_format = ((PrinterJob)object).defaultPage();
            this.page_format.setOrientation(0);
        }
        object = new Book();
        NARCS nARCS = this;
        ((Book)object).append(nARCS, this.page_format, 1);
        return object;
    }

    private void makeImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = this.tabbed_pane.getSelectedIndex();
        if (n5 == 0) {
            this.sample_size_panel.makeImage(graphics2D, n, n2, n3, n4);
        } else if (n5 == 1) {
            this.temperature_panel.makeImage(graphics2D, n, n2, n3, n4);
        } else if (n5 == 2) {
            this.moisture_panel.makeImage(graphics2D, n, n2, n3, n4);
        }
    }

    private void showAboutDialog() {
        String[] stringArray = new String[]{"Developed by Michael Pettey (IMSG)", "for NOAA/NESDIS"};
        AboutBox aboutBox = new AboutBox("NPROVS Archive Statistical Summary (NARCS)", "1.5.3", "June 9, 2011", stringArray);
        aboutBox.setVisible(true);
    }

    private void pickAFileToOpen() {
        Object object;
        boolean bl = false;
        this.file_name = this.globals.getCurrentFileName();
        if (this.file_name != null && !this.file_name.equals("narcs_default.dat")) {
            object = new File(this.file_name);
            if (((File)object).exists()) {
                bl = true;
            } else {
                this.file_name = null;
            }
        }
        if (!bl) {
            try {
                object = this.getClass().getResourceAsStream("narcs_default.dat");
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                int n = dataInputStream.readInt();
                if (n == 78638165) {
                    bl = true;
                    this.file_name = "narcs_default.dat";
                }
                ((InputStream)object).close();
                dataInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            this.readFileHeader();
        }
    }

    private void addMenus() {
        this.file_menu = new JMenu("File");
        this.miNew = new JMenuItem("New");
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miNew);
        this.miNew.addActionListener(this);
        this.miOpen = new JMenuItem("Open");
        this.miOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miOpen).setEnabled(true);
        this.miOpen.addActionListener(this);
        this.miClose = new JMenuItem("Close");
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miClose);
        this.miClose.addActionListener(this);
        this.miSave = new JMenuItem("Save Image");
        this.miSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miSave);
        this.miSave.addActionListener(this);
        this.file_menu.addSeparator();
        this.miPageSetup = new JMenuItem("Page Setup");
        this.file_menu.add(this.miPageSetup);
        this.miPageSetup.addActionListener(this);
        this.miPrintPreview = new JMenuItem("Print Preview");
        this.file_menu.add(this.miPrintPreview);
        this.miPrintPreview.addActionListener(this);
        this.miPrint = new JMenuItem("Print");
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miPrint);
        this.miPrint.addActionListener(this);
        this.file_menu.addSeparator();
        this.miQuit = new JMenuItem("Quit");
        this.miQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.file_menu.add(this.miQuit).setEnabled(true);
        this.miQuit.addActionListener(this);
        mainMenuBar.add(this.file_menu);
        this.miNew.setEnabled(false);
        this.miClose.setEnabled(false);
        this.miSave.setEnabled(false);
        this.miPageSetup.setEnabled(false);
        this.miPrintPreview.setEnabled(false);
        this.miPrint.setEnabled(false);
        this.help_menu = new JMenu("Help");
        this.miAbout = new JMenuItem("About NARCS...");
        this.miAbout.addActionListener(this);
        this.help_menu.add(this.miAbout).setEnabled(true);
        mainMenuBar.add(this.help_menu);
        this.setJMenuBar(mainMenuBar);
    }
}

