/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

class PrintPreviewCanvas
extends JPanel {
    private Book book;
    private int current_page;
    private int number_of_pages;

    public PrintPreviewCanvas(Book book) {
        this.book = book;
        this.current_page = 0;
        this.number_of_pages = this.book.getNumberOfPages();
    }

    public void paintComponent(Graphics graphics) {
        double d;
        double d2;
        double d3;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        PageFormat pageFormat = this.book.getPageFormat(this.current_page);
        double d4 = pageFormat.getWidth();
        double d5 = pageFormat.getHeight();
        double d6 = this.getWidth() - 1;
        double d7 = this.getHeight() - 1;
        if (d4 / d5 < d6 / d7) {
            d3 = d7 / d5;
            d2 = 0.5 * (d6 - d3 * d4);
            d = 0.0;
        } else {
            d3 = d6 / d4;
            d2 = 0.0;
            d = 0.5 * (d7 - d3 * d5);
        }
        graphics2D.translate((float)d2, (float)d);
        graphics2D.scale((float)d3, (float)d3);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d4, d5);
        graphics2D.setPaint(Color.white);
        graphics2D.fill(double_);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(double_);
        Printable printable = this.book.getPrintable(this.current_page);
        try {
            printable.print(graphics2D, pageFormat, this.current_page);
        }
        catch (PrinterException printerException) {
            graphics2D.draw(new Line2D.Double(0.0, 0.0, d4, d5));
            graphics2D.draw(new Line2D.Double(0.0, d4, 0.0, d5));
        }
    }

    public void flipPage(int n) {
        int n2 = this.current_page + n;
        if (n2 >= 0 && n2 < this.number_of_pages) {
            this.current_page = n2;
            this.repaint();
        }
    }

    public int getCurrentPage() {
        return this.current_page + 1;
    }

    public int getNumberOfPages() {
        return this.number_of_pages;
    }
}

