/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrintPreviewDialog
extends JDialog
implements ActionListener {
    private PrintPreviewCanvas canvas;
    private JLabel pageLabel;
    private JButton nextButton;
    private JButton previousButton;
    private JButton closeButton;

    public PrintPreviewDialog(Printable printable, PageFormat pageFormat, int n) {
        Book book = new Book();
        book.append(printable, pageFormat, n);
        this.layoutUI(book);
    }

    public PrintPreviewDialog(Book book) {
        this.layoutUI(book);
    }

    private void layoutUI(Book book) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)((double)dimension.width * 0.6);
        int n2 = (int)((double)dimension.height * 0.67);
        this.setSize(n, n2);
        this.setTitle("Print Preview");
        Container container = this.getContentPane();
        this.canvas = new PrintPreviewCanvas(book);
        container.add((Component)this.canvas, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        int n3 = book.getNumberOfPages();
        this.pageLabel = new JLabel("Page 1 of " + n3);
        this.pageLabel.setForeground(Color.black);
        jPanel.add((Component)this.pageLabel, "West");
        JPanel jPanel2 = new JPanel();
        this.previousButton = new JButton("Previous");
        jPanel2.add(this.previousButton);
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(false);
        this.nextButton = new JButton("Next");
        jPanel2.add(this.nextButton);
        this.nextButton.addActionListener(this);
        if (n3 == 1) {
            this.nextButton.setEnabled(false);
        }
        this.closeButton = new JButton("Close");
        jPanel2.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.closeButton);
        jPanel.add((Component)jPanel2, "East");
        container.add((Component)jPanel, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nextButton) {
            this.canvas.flipPage(1);
            String string = "Page " + this.canvas.getCurrentPage() + " of " + this.canvas.getNumberOfPages();
            this.pageLabel.setText(string);
        } else if (object == this.previousButton) {
            this.canvas.flipPage(-1);
            String string = "Page " + this.canvas.getCurrentPage() + " of " + this.canvas.getNumberOfPages();
            this.pageLabel.setText(string);
        } else if (object == this.closeButton) {
            this.setVisible(false);
        }
        if (this.canvas.getCurrentPage() == this.canvas.getNumberOfPages()) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
        if (this.canvas.getCurrentPage() == 1) {
            this.previousButton.setEnabled(false);
        } else {
            this.previousButton.setEnabled(true);
        }
    }
}

