/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SampleSizeOptionsDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private JButton ok_button;
    private JButton cancel_button;
    private JRadioButton sample_size_auto_button;
    private JRadioButton sample_size_default_button;
    private JRadioButton sample_size_manual_button;
    private JTextField sample_size_min_field;
    private JTextField sample_size_max_field;
    private JCheckBox sample_size_ignore_box;
    private DateChooserPanel start_date_panel;
    private DateChooserPanel end_date_panel;
    private JButton reset_dates_button;
    private JComboBox group_list;
    private JTextField line_color_field;
    private JButton line_color_button;
    private JComboBox profile_list;
    private JSlider line_thickness_slider;
    private JComboBox line_style_list;
    private JCheckBox show_data_points_box;
    private JButton reset_lines_button;
    private int[] profile_indices;
    private Color[] current_colors;
    private int[][] current_thicknesses;
    private int[][] current_styles;
    private boolean ok_button_pressed;
    private Color text_background_color;
    private NarcsGlobals globals;
    private final int SAMPLE_SIZE = 0;
    private final int STAT_TEMP = 1;
    private final int STAT_WVAP = 2;

    public SampleSizeOptionsDialog(JFrame jFrame, String[] stringArray, String[] stringArray2, int[] nArray) {
        super(jFrame, "Change Graph Settings", true);
        int n;
        int n2;
        int n3;
        int n4;
        this.profile_indices = nArray;
        this.globals = new NarcsGlobals();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.ok_button = new JButton("OK");
        this.cancel_button = new JButton("Cancel");
        jPanel.add(this.ok_button);
        jPanel.add(this.cancel_button);
        this.getRootPane().setDefaultButton(this.ok_button);
        this.getContentPane().add((Component)jPanel, "South");
        this.ok_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new StackLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 3, 5, 5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Sample Size"));
        jPanel4.setLayout(new StackLayout());
        this.sample_size_auto_button = new JRadioButton("Automatic:  (min to max)");
        this.sample_size_default_button = new JRadioButton("Default:  (0 to max)");
        this.sample_size_manual_button = new JRadioButton("Manual: ");
        this.sample_size_min_field = new JTextField("" + this.globals.getSampleSizeManualMin(), 5);
        this.sample_size_max_field = new JTextField("" + this.globals.getSampleSizeManualMax(), 5);
        this.text_background_color = this.sample_size_min_field.getBackground();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sample_size_auto_button);
        buttonGroup.add(this.sample_size_default_button);
        buttonGroup.add(this.sample_size_manual_button);
        this.sample_size_ignore_box = new JCheckBox("Ignore values outside of min/max");
        jPanel4.add(new JLabel("Min/Max Data Range:"));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(new JLabel("    "));
        jPanel5.add(this.sample_size_auto_button);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(new JLabel("    "));
        jPanel6.add(this.sample_size_default_button);
        jPanel4.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(new JLabel("    "));
        jPanel7.add(this.sample_size_manual_button);
        jPanel7.add(this.sample_size_min_field);
        jPanel7.add(this.sample_size_max_field);
        jPanel4.add(jPanel7);
        jPanel4.add(this.sample_size_ignore_box);
        if (this.globals.getSampleSizeMinMaxOption() == 0) {
            this.sample_size_auto_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(false);
        } else if (this.globals.getSampleSizeMinMaxOption() == 1) {
            this.sample_size_default_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(true);
        } else {
            this.sample_size_manual_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(true);
        }
        this.sample_size_ignore_box.setSelected(this.globals.getSampleSizeIgnoreExtremes());
        this.sample_size_auto_button.addActionListener(this);
        this.sample_size_default_button.addActionListener(this);
        this.sample_size_manual_button.addActionListener(this);
        jPanel3.add(jPanel4);
        JPanel jPanel8 = new JPanel();
        jPanel3.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel3.add(jPanel9);
        jPanel2.add(jPanel3);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder("Graph Lines"));
        jPanel10.setLayout(new ParagraphLayout());
        this.group_list = new JComboBox<String>(stringArray);
        this.group_list.addActionListener(this);
        jPanel10.add((Component)new JLabel("Raob/Sat Data:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel10.add(this.group_list);
        this.line_color_field = new JTextField(3);
        this.line_color_field.setEditable(false);
        this.line_color_button = new JButton("Pick Color");
        JPanel jPanel11 = new JPanel();
        jPanel11.add(this.line_color_field);
        jPanel11.add(this.line_color_button);
        jPanel10.add((Component)jPanel11, ParagraphLayout.NEW_LINE);
        this.line_color_button.addActionListener(this);
        Color[] colorArray = this.globals.getGroupColors();
        this.current_colors = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            this.current_colors[i] = colorArray[i];
        }
        this.line_color_field.setBackground(this.current_colors[0]);
        if (stringArray2.length > 0) {
            this.profile_list = new JComboBox<String>(stringArray2);
        } else {
            String[] stringArray3 = new String[]{"No profiles selected"};
            this.profile_list = new JComboBox<String>(stringArray3);
        }
        this.profile_list.addActionListener(this);
        jPanel10.add((Component)new JLabel("Stat Profile:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel10.add(this.profile_list);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new ParagraphLayout());
        this.line_thickness_slider = new JSlider(0, 0, 10, 0);
        this.line_thickness_slider.setMajorTickSpacing(1);
        this.line_thickness_slider.setPaintTicks(true);
        this.line_thickness_slider.setPaintLabels(true);
        this.line_thickness_slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("A"));
        hashtable.put(new Integer(1), new JLabel("1"));
        hashtable.put(new Integer(5), new JLabel("5"));
        hashtable.put(new Integer(10), new JLabel("10"));
        this.line_thickness_slider.setLabelTable(hashtable);
        int[][] nArray2 = this.globals.getGroupLineThicknesses();
        this.current_thicknesses = new int[colorArray.length][27];
        for (n4 = 0; n4 < colorArray.length; ++n4) {
            for (n3 = 0; n3 < 27; ++n3) {
                this.current_thicknesses[n4][n3] = nArray2[n4][n3];
            }
        }
        if (nArray.length > 0) {
            n4 = nArray[this.profile_list.getSelectedIndex()];
            n3 = n4 / 100;
            n2 = n4 % 100;
            this.line_thickness_slider.setValue(this.current_thicknesses[n3][n2]);
        }
        this.line_thickness_slider.addChangeListener(this);
        jPanel12.add((Component)new JLabel("Line Thickness:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel12.add(this.line_thickness_slider);
        String[] stringArray4 = new String[]{"Solid", "Short Dash", "Long Dash", "Dots", "Short Long", "Diamonds"};
        this.line_style_list = new JComboBox<String>(stringArray4);
        int[][] nArray3 = this.globals.getGroupLineStyles();
        this.current_styles = new int[colorArray.length][27];
        for (n2 = 0; n2 < colorArray.length; ++n2) {
            for (n = 0; n < 27; ++n) {
                this.current_styles[n2][n] = nArray3[n2][n];
            }
        }
        if (nArray.length > 0) {
            n2 = nArray[this.profile_list.getSelectedIndex()];
            n = n2 / 100;
            int n5 = n2 % 100;
            this.line_style_list.setSelectedIndex(this.current_styles[n][n5]);
        }
        this.line_style_list.addActionListener(this);
        jPanel12.add((Component)new JLabel("Line Style:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel12.add(this.line_style_list);
        jPanel10.add((Component)jPanel12, ParagraphLayout.NEW_LINE);
        if (nArray.length == 0) {
            this.profile_list.setEnabled(false);
            this.line_thickness_slider.setEnabled(false);
            this.line_style_list.setEnabled(false);
        }
        this.show_data_points_box = new JCheckBox("Show Data Points");
        this.show_data_points_box.setSelected(this.globals.getShowDataPoints());
        jPanel10.add((Component)this.show_data_points_box, ParagraphLayout.NEW_PARAGRAPH);
        this.reset_lines_button = new JButton("Reset Lines");
        this.reset_lines_button.addActionListener(this);
        jPanel10.add((Component)this.reset_lines_button, ParagraphLayout.NEW_PARAGRAPH);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new StackLayout());
        jPanel13.setBorder(BorderFactory.createTitledBorder("Starting / Ending Dates"));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayout(1, 2));
        this.start_date_panel = new DateChooserPanel(this.globals.getEarliestDataDate(), this.globals.getLatestDataDate(), this.globals.getCurrentStartDate());
        this.start_date_panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.end_date_panel = new DateChooserPanel(this.globals.getEarliestDataDate(), this.globals.getLatestDataDate(), this.globals.getCurrentEndDate());
        this.end_date_panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        jPanel14.add(this.start_date_panel);
        jPanel14.add(this.end_date_panel);
        this.reset_dates_button = new JButton("Reset Dates");
        this.reset_dates_button.addActionListener(this);
        JPanel jPanel15 = new JPanel();
        jPanel15.add(this.reset_dates_button);
        jPanel13.add(jPanel14);
        jPanel13.add(jPanel15);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel16.add(jPanel10);
        jPanel16.add(jPanel13);
        jPanel2.add(jPanel16);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == this.sample_size_auto_button) {
                this.sample_size_ignore_box.setEnabled(false);
            } else if (jRadioButton == this.sample_size_default_button) {
                this.sample_size_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.sample_size_manual_button) {
                this.sample_size_ignore_box.setEnabled(true);
            }
        } else if (actionEvent.getSource() instanceof JButton) {
            if ((JButton)actionEvent.getSource() == this.ok_button) {
                boolean bl = this.checkTextValues();
                if (bl) {
                    this.updateGlobalValues();
                    this.ok_button_pressed = true;
                    this.setVisible(false);
                }
            } else if ((JButton)actionEvent.getSource() == this.cancel_button) {
                this.ok_button_pressed = false;
                this.setVisible(false);
            } else if ((JButton)actionEvent.getSource() == this.reset_dates_button) {
                this.resetDates();
            } else if ((JButton)actionEvent.getSource() == this.line_color_button) {
                this.pickColor();
            } else if ((JButton)actionEvent.getSource() == this.reset_lines_button) {
                this.resetLines();
            }
        } else if (actionEvent.getSource() instanceof JComboBox) {
            if ((JComboBox)actionEvent.getSource() == this.group_list) {
                this.line_color_field.setBackground(this.current_colors[this.group_list.getSelectedIndex()]);
            } else if ((JComboBox)actionEvent.getSource() == this.profile_list) {
                int n = this.profile_indices[this.profile_list.getSelectedIndex()];
                int n2 = n / 100;
                int n3 = n % 100;
                this.line_thickness_slider.setValue(this.current_thicknesses[n2][n3]);
                this.line_style_list.setSelectedIndex(this.current_styles[n2][n3]);
            } else if ((JComboBox)actionEvent.getSource() == this.line_style_list) {
                int n = this.profile_indices[this.profile_list.getSelectedIndex()];
                int n4 = n / 100;
                int n5 = n % 100;
                this.current_styles[n4][n5] = this.line_style_list.getSelectedIndex();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.profile_indices[this.profile_list.getSelectedIndex()];
        int n2 = n / 100;
        int n3 = n % 100;
        this.current_thicknesses[n2][n3] = this.line_thickness_slider.getValue();
    }

    private void pickColor() {
        Color color = this.line_color_field.getBackground();
        JFrame jFrame = new JFrame();
        Color color2 = JColorChooser.showDialog(jFrame, "Choose Line Color", color);
        this.line_color_field.setBackground(color2);
        this.current_colors[this.group_list.getSelectedIndex()] = color2;
    }

    private void resetLines() {
        int n;
        Color[] colorArray = this.globals.getDefaultGroupColors();
        for (n = 0; n < this.current_colors.length; ++n) {
            this.current_colors[n] = colorArray[n];
        }
        this.line_color_field.setBackground(this.current_colors[this.group_list.getSelectedIndex()]);
        if (this.profile_indices.length > 0) {
            this.current_thicknesses = this.globals.getDefaultGroupLineThicknesses();
            this.current_styles = this.globals.getDefaultGroupLineStyles();
            n = this.profile_indices[this.profile_list.getSelectedIndex()];
            int n2 = n / 100;
            int n3 = n % 100;
            this.line_thickness_slider.setValue(this.current_thicknesses[n2][n3]);
            this.line_style_list.setSelectedIndex(this.current_styles[n2][n3]);
        }
        this.show_data_points_box.setSelected(false);
    }

    private boolean checkTextValues() {
        boolean bl = true;
        if (this.sample_size_manual_button.isSelected()) {
            Float f;
            float f2 = -32768.0f;
            float f3 = -32768.0f;
            try {
                f = new Float(this.sample_size_min_field.getText());
                f2 = f.floatValue();
                this.sample_size_min_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.sample_size_min_field.setBackground(Color.red);
                bl = false;
            }
            try {
                f = new Float(this.sample_size_max_field.getText());
                f3 = f.floatValue();
                this.sample_size_max_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.sample_size_max_field.setBackground(Color.red);
                bl = false;
            }
            if (bl && f2 >= f3) {
                this.sample_size_min_field.setBackground(Color.red);
                this.sample_size_max_field.setBackground(Color.red);
                bl = false;
            }
        }
        return bl;
    }

    private void updateGlobalValues() {
        long l;
        float f;
        Float f2;
        if (this.sample_size_auto_button.isSelected()) {
            this.globals.setSampleSizeMinMaxOption(0);
        } else if (this.sample_size_default_button.isSelected()) {
            this.globals.setSampleSizeMinMaxOption(1);
        } else {
            this.globals.setSampleSizeMinMaxOption(2);
        }
        try {
            f2 = new Float(this.sample_size_min_field.getText());
            f = f2.floatValue();
            this.globals.setSampleSizeManualMin(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f2 = new Float(this.sample_size_max_field.getText());
            f = f2.floatValue();
            this.globals.setSampleSizeManualMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.globals.setSampleSizeIgnoreExtremes(this.sample_size_ignore_box.isSelected());
        long l2 = this.start_date_panel.getSelectedDate();
        long l3 = this.end_date_panel.getSelectedDate();
        if (l2 > l3) {
            l = l2;
            l2 = l3;
            l3 = l;
        }
        l = this.globals.getEarliestDataDate();
        long l4 = this.globals.getLatestDataDate();
        l2 = Math.max(l2, l);
        l3 = Math.min(l3, l4);
        this.globals.setCurrentStartDate(l2);
        this.globals.setCurrentEndDate(l3);
        this.globals.setGroupColors(this.current_colors);
        if (this.profile_indices.length > 0) {
            this.globals.setGroupLineThicknesses(this.current_thicknesses);
            this.globals.setGroupLineStyles(this.current_styles);
        }
        this.globals.setShowDataPoints(this.show_data_points_box.isSelected());
    }

    public void resetDates() {
        this.start_date_panel.setDate(this.globals.getEarliestDataDate());
        this.end_date_panel.setDate(this.globals.getLatestDataDate());
    }

    public boolean okButtonPressed() {
        return this.ok_button_pressed;
    }
}

