/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SampleSizePanel
extends JPanel
implements ActionListener {
    private NARCS parent;
    private SampleSizeGraph graph;
    private JRadioButton daily_button;
    private JRadioButton weekly_button;
    private JRadioButton monthly_button;
    private JCheckBox passed_and_failed_qc_box;
    private JCheckBox passed_qc_box;
    private JCheckBox failed_qc_box;
    private JCheckBox sea_box;
    private JCheckBox nonsea_box;
    private JCheckBox sea_and_nonsea_box;
    private JCheckBox clear_box;
    private JCheckBox cloudy_box;
    private JCheckBox clear_and_cloudy_box;
    private ScrollingPanel data_group_panel;
    private JCheckBox[] data_group_box;
    private JButton graph_options_button;
    private int num_data_groups;
    private boolean ignore_events;
    private String[] group_names;
    private NarcsGlobals globals = new NarcsGlobals();

    public SampleSizePanel() {
        this.addControls();
    }

    public void addFileInfo(NARCS nARCS, String string, int n, int n2, int[] nArray, int n3, int[] nArray2, String[] stringArray) {
        this.parent = nARCS;
        this.num_data_groups = n3;
        this.addDataGroupControls(stringArray);
        this.graph.addFileInfo(string, n, n2, nArray, n3, this.group_names);
        this.graph_options_button.setEnabled(true);
        this.daily_button.setEnabled(true);
        this.weekly_button.setEnabled(true);
        this.monthly_button.setEnabled(true);
        this.passed_and_failed_qc_box.setEnabled(true);
        this.passed_qc_box.setEnabled(true);
        this.failed_qc_box.setEnabled(true);
        this.sea_box.setEnabled(true);
        this.nonsea_box.setEnabled(true);
        this.sea_and_nonsea_box.setEnabled(true);
        this.clear_and_cloudy_box.setEnabled(true);
        this.clear_box.setEnabled(true);
        this.cloudy_box.setEnabled(true);
    }

    private void addControls() {
        this.setLayout(new BorderLayout());
        this.data_group_panel = new ScrollingPanel();
        this.data_group_panel.setBackground(Color.white);
        this.data_group_panel.setLayout(new StackLayout());
        this.add((Component)this.data_group_panel, "East");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.graph_options_button = new JButton("Graph Options");
        this.graph_options_button.addActionListener(this);
        jPanel.add(this.graph_options_button);
        jPanel.add(new JLabel("          "));
        this.daily_button = new JRadioButton("Daily");
        this.weekly_button = new JRadioButton("Weekly");
        this.monthly_button = new JRadioButton("Monthly");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.daily_button);
        buttonGroup.add(this.weekly_button);
        buttonGroup.add(this.monthly_button);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add(this.daily_button);
        jPanel2.add(this.weekly_button);
        jPanel2.add(this.monthly_button);
        jPanel.add(jPanel2);
        if (this.globals.getTimeWindowOption() == 0) {
            this.daily_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 1) {
            this.weekly_button.setSelected(true);
        } else {
            this.monthly_button.setSelected(true);
        }
        this.daily_button.addActionListener(this);
        this.weekly_button.addActionListener(this);
        this.monthly_button.addActionListener(this);
        this.passed_and_failed_qc_box = new JCheckBox("Passed / Failed QC");
        this.passed_qc_box = new JCheckBox("Passed QC");
        this.failed_qc_box = new JCheckBox("Failed QC");
        this.passed_and_failed_qc_box.setSelected(this.globals.getShowPassedAndFailedQC());
        this.passed_qc_box.setSelected(this.globals.getShowPassedQC());
        this.failed_qc_box.setSelected(this.globals.getShowFailedQC());
        this.passed_and_failed_qc_box.addActionListener(this);
        this.passed_qc_box.addActionListener(this);
        this.failed_qc_box.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel3.setLayout(new GridLayout(3, 1));
        jPanel3.add(this.passed_and_failed_qc_box);
        jPanel3.add(this.passed_qc_box);
        jPanel3.add(this.failed_qc_box);
        jPanel.add(jPanel3);
        this.sea_and_nonsea_box = new JCheckBox("Sea and Non-Sea");
        this.sea_box = new JCheckBox("Sea");
        this.nonsea_box = new JCheckBox("Non-Sea");
        this.sea_and_nonsea_box.setSelected(this.globals.getShowSeaAndNonsea());
        this.sea_box.setSelected(this.globals.getShowSea());
        this.nonsea_box.setSelected(this.globals.getShowNonsea());
        this.sea_box.addActionListener(this);
        this.nonsea_box.addActionListener(this);
        this.sea_and_nonsea_box.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel4.setLayout(new GridLayout(3, 1));
        jPanel4.add(this.sea_and_nonsea_box);
        jPanel4.add(this.sea_box);
        jPanel4.add(this.nonsea_box);
        jPanel.add(jPanel4);
        this.clear_and_cloudy_box = new JCheckBox("Clear and Cloudy");
        this.clear_box = new JCheckBox("Clear");
        this.cloudy_box = new JCheckBox("Cloudy");
        this.clear_and_cloudy_box.setSelected(this.globals.getShowClearAndCloudy());
        this.clear_box.setSelected(this.globals.getShowClear());
        this.cloudy_box.setSelected(this.globals.getShowCloudy());
        this.clear_box.addActionListener(this);
        this.cloudy_box.addActionListener(this);
        this.clear_and_cloudy_box.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel5.setLayout(new GridLayout(3, 1));
        jPanel5.add(this.clear_and_cloudy_box);
        jPanel5.add(this.clear_box);
        jPanel5.add(this.cloudy_box);
        jPanel.add(jPanel5);
        this.add((Component)jPanel, "South");
        this.graph = new SampleSizeGraph();
        this.add((Component)this.graph, "Center");
        this.graph_options_button.setEnabled(false);
        this.daily_button.setEnabled(false);
        this.weekly_button.setEnabled(false);
        this.monthly_button.setEnabled(false);
        this.passed_and_failed_qc_box.setEnabled(false);
        this.passed_qc_box.setEnabled(false);
        this.failed_qc_box.setEnabled(false);
        this.sea_box.setEnabled(false);
        this.nonsea_box.setEnabled(false);
        this.sea_and_nonsea_box.setEnabled(false);
        this.clear_and_cloudy_box.setEnabled(false);
        this.clear_box.setEnabled(false);
        this.cloudy_box.setEnabled(false);
    }

    private void addDataGroupControls(String[] stringArray) {
        int n;
        this.data_group_panel.removeAll();
        this.data_group_panel.revalidate();
        this.group_names = new String[5 + stringArray.length];
        this.group_names[0] = "Baseline";
        this.group_names[1] = "Baseline 00Z";
        this.group_names[2] = "Baseline 06Z";
        this.group_names[3] = "Baseline 12Z";
        this.group_names[4] = "Baseline 18Z";
        for (n = 0; n < stringArray.length; ++n) {
            this.group_names[5 + n] = stringArray[n];
        }
        this.data_group_box = new JCheckBox[this.num_data_groups + 5];
        this.data_group_box[0] = new JCheckBox("Baseline");
        this.data_group_box[1] = new JCheckBox("     00z");
        this.data_group_box[2] = new JCheckBox("     06z");
        this.data_group_box[3] = new JCheckBox("     12z");
        this.data_group_box[4] = new JCheckBox("     18z");
        for (n = 0; n < this.num_data_groups; ++n) {
            this.data_group_box[n + 5] = new JCheckBox(stringArray[n]);
        }
        for (n = 0; n < this.data_group_box.length; ++n) {
            this.data_group_box[n].addActionListener(this);
            this.data_group_box[n].setForeground(this.globals.getGroupColor(n));
            this.data_group_box[n].setBackground(Color.white);
            this.data_group_panel.add(this.data_group_box[n]);
        }
        boolean[] blArray = this.globals.getShowDataGroups();
        if (blArray != null) {
            for (int i = 0; i < this.data_group_box.length; ++i) {
                this.data_group_box[i].setSelected(blArray[i]);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.ignore_events) {
            if (actionEvent.getActionCommand().equals(this.graph_options_button.getActionCommand())) {
                this.changeGraphSettings();
            } else if (actionEvent.getActionCommand().equals(this.daily_button.getActionCommand()) || actionEvent.getActionCommand().equals(this.weekly_button.getActionCommand()) || actionEvent.getActionCommand().equals(this.monthly_button.getActionCommand())) {
                this.changeTimeWindow();
            } else if (actionEvent.getActionCommand().equals(this.passed_and_failed_qc_box.getActionCommand()) || actionEvent.getActionCommand().equals(this.passed_qc_box.getActionCommand()) || actionEvent.getActionCommand().equals(this.failed_qc_box.getActionCommand())) {
                this.changeQCOptions();
            } else if (actionEvent.getActionCommand().equals(this.sea_box.getActionCommand()) || actionEvent.getActionCommand().equals(this.nonsea_box.getActionCommand()) || actionEvent.getActionCommand().equals(this.sea_and_nonsea_box.getActionCommand())) {
                this.changeTerrainOptions();
            } else if (actionEvent.getActionCommand().equals(this.clear_box.getActionCommand()) || actionEvent.getActionCommand().equals(this.cloudy_box.getActionCommand()) || actionEvent.getActionCommand().equals(this.clear_and_cloudy_box.getActionCommand())) {
                this.changeCloudOptions();
            } else {
                int n;
                boolean bl = false;
                boolean bl2 = false;
                for (n = 0; n < this.data_group_box.length; ++n) {
                    if (!actionEvent.getActionCommand().equals(this.data_group_box[n].getActionCommand())) continue;
                    bl = true;
                    bl2 = this.data_group_box[n].isSelected();
                }
                if (bl) {
                    if ((actionEvent.getModifiers() & 2) != 0) {
                        for (n = 0; n < this.data_group_box.length; ++n) {
                            this.ignore_events = true;
                            this.data_group_box[n].setSelected(bl2);
                            this.ignore_events = false;
                        }
                    }
                    boolean[] blArray = new boolean[this.num_data_groups + 5];
                    for (int i = 0; i < this.num_data_groups + 5; ++i) {
                        blArray[i] = this.data_group_box[i].isSelected();
                    }
                    this.globals.setShowDataGroups(blArray);
                    this.graph.updateGraph();
                }
            }
        }
    }

    public void panelSelected() {
        this.ignore_events = true;
        if (this.globals.getTimeWindowOption() == 0) {
            this.daily_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 1) {
            this.weekly_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 2) {
            this.monthly_button.setSelected(true);
        }
        this.passed_and_failed_qc_box.setSelected(this.globals.getShowPassedAndFailedQC());
        this.passed_qc_box.setSelected(this.globals.getShowPassedQC());
        this.failed_qc_box.setSelected(this.globals.getShowFailedQC());
        this.sea_box.setSelected(this.globals.getShowSea());
        this.nonsea_box.setSelected(this.globals.getShowNonsea());
        this.sea_and_nonsea_box.setSelected(this.globals.getShowSeaAndNonsea());
        this.clear_box.setSelected(this.globals.getShowClear());
        this.cloudy_box.setSelected(this.globals.getShowCloudy());
        this.clear_and_cloudy_box.setSelected(this.globals.getShowClearAndCloudy());
        this.ignore_events = false;
        if (this.data_group_box != null) {
            for (int i = 0; i < this.data_group_box.length; ++i) {
                this.data_group_box[i].setForeground(this.globals.getGroupColor(i));
            }
            boolean[] blArray = this.globals.getShowDataGroups();
            for (int i = 0; i < this.data_group_box.length; ++i) {
                this.data_group_box[i].setSelected(blArray[i]);
            }
            this.graph.newTimeWindow();
        }
    }

    public void panelUnselected() {
        this.graph.removeProfiles();
    }

    private void changeTimeWindow() {
        int n = 0;
        if (this.weekly_button.isSelected()) {
            n = 1;
        } else if (this.monthly_button.isSelected()) {
            n = 2;
        }
        this.globals.setTimeWindowOption(n);
        this.graph.newTimeWindow();
    }

    private void changeQCOptions() {
        this.globals.setShowPassedAndFailedQC(this.passed_and_failed_qc_box.isSelected());
        this.globals.setShowPassedQC(this.passed_qc_box.isSelected());
        this.globals.setShowFailedQC(this.failed_qc_box.isSelected());
        this.graph.updateGraph();
    }

    private void changeTerrainOptions() {
        this.globals.setShowSea(this.sea_box.isSelected());
        this.globals.setShowNonsea(this.nonsea_box.isSelected());
        this.globals.setShowSeaAndNonsea(this.sea_and_nonsea_box.isSelected());
        this.graph.updateGraph();
    }

    private void changeCloudOptions() {
        this.globals.setShowClear(this.clear_box.isSelected());
        this.globals.setShowCloudy(this.cloudy_box.isSelected());
        this.globals.setShowClearAndCloudy(this.clear_and_cloudy_box.isSelected());
        this.graph.updateGraph();
    }

    public void changeGraphSettings() {
        int[] nArray;
        Vector vector = this.graph.getProfileData();
        String[] stringArray = (String[])vector.elementAt(0);
        SampleSizeOptionsDialog sampleSizeOptionsDialog = new SampleSizeOptionsDialog(this.parent, this.group_names, stringArray, nArray = (int[])vector.elementAt(1));
        if (sampleSizeOptionsDialog.okButtonPressed()) {
            for (int i = 0; i < this.data_group_box.length; ++i) {
                this.data_group_box[i].setForeground(this.globals.getGroupColor(i));
            }
            this.graph.newTimeWindow();
        }
    }

    public void makeImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        int n6 = (int)((float)n3 * 0.15f);
        int n7 = n3 - n6;
        int n8 = n + n7;
        graphics2D.setClip(n8, n2, n6, n4);
        int n9 = 46;
        graphics2D.setFont(new Font("Sans-Serif", 0, n9));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        boolean bl = false;
        while (!bl && n9 > 5) {
            bl = true;
            graphics2D.setFont(new Font("Sans-Serif", 0, --n9));
            fontMetrics = graphics2D.getFontMetrics();
            for (n5 = 0; n5 < this.data_group_box.length; ++n5) {
                String string;
                if (!this.data_group_box[n5].isSelected() || fontMetrics.stringWidth(string = this.data_group_box[n5].getText()) <= n6 - 4) continue;
                bl = false;
            }
        }
        n5 = n8 + 2;
        int n10 = n2 + (int)((float)n4 * 0.05f);
        for (int i = 0; i < this.data_group_box.length; ++i) {
            if (!this.data_group_box[i].isSelected()) continue;
            String string = this.data_group_box[i].getText();
            Color color = this.data_group_box[i].getForeground();
            graphics2D.setColor(color);
            graphics2D.drawString(string, n5, n10 += fontMetrics.getHeight());
        }
        graphics2D.setClip(null);
        graphics2D.setClip(n, n2, n7, n4);
        this.graph.drawGraph(graphics2D, n, n2, n7, n4);
        graphics2D.setClip(null);
    }
}

