/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatOptionsDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private JButton ok_button;
    private JButton cancel_button;
    private JRadioButton sample_size_auto_button;
    private JRadioButton sample_size_default_button;
    private JRadioButton sample_size_manual_button;
    private JTextField sample_size_min_field;
    private JTextField sample_size_max_field;
    private JCheckBox sample_size_ignore_box;
    private JRadioButton temp_auto_button;
    private JRadioButton temp_default_button;
    private JRadioButton temp_manual_button;
    private JLabel temp_default_label;
    private JTextField temp_min_field;
    private JTextField temp_max_field;
    private JCheckBox temp_ignore_box;
    private JRadioButton wvap_auto_button;
    private JRadioButton wvap_default_button;
    private JRadioButton wvap_manual_button;
    private JLabel wvap_default_label;
    private JTextField wvap_min_field;
    private JTextField wvap_max_field;
    private JCheckBox wvap_ignore_box;
    private JCheckBox below_cutoff_box;
    private JSlider cutoff_slider;
    private JLabel cutoff_label;
    private DateChooserPanel start_date_panel;
    private DateChooserPanel end_date_panel;
    private JButton reset_dates_button;
    private JComboBox subgroup_list;
    private JTextField line_color_field;
    private JButton line_color_button;
    private JComboBox profile_list;
    private JSlider line_thickness_slider;
    private JComboBox line_style_list;
    private JCheckBox show_data_points_box;
    private JButton reset_lines_button;
    private int[] subgroup_group_pointers;
    private int[] profile_indices;
    private Color[] current_colors;
    private int[][][] current_thicknesses;
    private int[][][] current_styles;
    private boolean ok_button_pressed;
    private Color text_background_color;
    private NarcsGlobals globals;
    private final int SAMPLE_SIZE = 0;
    private final int STAT_TEMP = 1;
    private final int STAT_WVAP = 2;

    public StatOptionsDialog(JFrame jFrame, String[] stringArray, int[] nArray, String[] stringArray2, int[] nArray2) {
        super(jFrame, "Change Graph Settings", true);
        int n;
        int n2;
        int n3;
        this.subgroup_group_pointers = nArray;
        this.profile_indices = nArray2;
        this.globals = new NarcsGlobals();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.ok_button = new JButton("OK");
        this.cancel_button = new JButton("Cancel");
        jPanel.add(this.ok_button);
        jPanel.add(this.cancel_button);
        this.getRootPane().setDefaultButton(this.ok_button);
        this.getContentPane().add((Component)jPanel, "South");
        this.ok_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new StackLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 3, 5, 5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Sample Size"));
        jPanel4.setLayout(new StackLayout());
        this.sample_size_auto_button = new JRadioButton("Automatic:  (min to max)");
        this.sample_size_default_button = new JRadioButton("Default:  (0 to max)");
        this.sample_size_manual_button = new JRadioButton("Manual: ");
        this.sample_size_min_field = new JTextField("" + this.globals.getSampleSizeManualMin(), 5);
        this.sample_size_max_field = new JTextField("" + this.globals.getSampleSizeManualMax(), 5);
        this.text_background_color = this.sample_size_min_field.getBackground();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sample_size_auto_button);
        buttonGroup.add(this.sample_size_default_button);
        buttonGroup.add(this.sample_size_manual_button);
        this.sample_size_ignore_box = new JCheckBox("Ignore values outside of min/max");
        jPanel4.add(new JLabel("Min/Max Data Range:"));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(new JLabel("    "));
        jPanel5.add(this.sample_size_auto_button);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(new JLabel("    "));
        jPanel6.add(this.sample_size_default_button);
        jPanel4.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(new JLabel("    "));
        jPanel7.add(this.sample_size_manual_button);
        jPanel7.add(this.sample_size_min_field);
        jPanel7.add(this.sample_size_max_field);
        jPanel4.add(jPanel7);
        jPanel4.add(this.sample_size_ignore_box);
        if (this.globals.getSampleSizeMinMaxOption() == 0) {
            this.sample_size_auto_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(false);
        } else if (this.globals.getSampleSizeMinMaxOption() == 1) {
            this.sample_size_default_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(true);
        } else {
            this.sample_size_manual_button.setSelected(true);
            this.sample_size_ignore_box.setEnabled(true);
        }
        this.sample_size_ignore_box.setSelected(this.globals.getSampleSizeIgnoreExtremes());
        this.sample_size_auto_button.addActionListener(this);
        this.sample_size_default_button.addActionListener(this);
        this.sample_size_manual_button.addActionListener(this);
        jPanel3.add(jPanel4);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder("Temperature"));
        jPanel8.setLayout(new StackLayout());
        this.temp_auto_button = new JRadioButton("Automatic:  (min to max)");
        this.temp_default_button = new JRadioButton("Default:  ");
        this.temp_manual_button = new JRadioButton("Manual: ");
        this.temp_default_label = new JLabel("(" + this.globals.getTempDefaultMin() + " to " + this.globals.getTempDefaultMax() + ")");
        this.temp_min_field = new JTextField("" + this.globals.getTempManualMin(), 5);
        this.temp_max_field = new JTextField("" + this.globals.getTempManualMax(), 5);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.temp_auto_button);
        buttonGroup2.add(this.temp_default_button);
        buttonGroup2.add(this.temp_manual_button);
        this.temp_ignore_box = new JCheckBox("Ignore values outside of min/max");
        jPanel8.add(new JLabel("Min/Max Data Range:"));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0));
        jPanel9.add(new JLabel("    "));
        jPanel9.add(this.temp_auto_button);
        jPanel8.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout(0));
        jPanel10.add(new JLabel("    "));
        jPanel10.add(this.temp_default_button);
        jPanel10.add(this.temp_default_label);
        jPanel8.add(jPanel10);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout(0));
        jPanel11.add(new JLabel("    "));
        jPanel11.add(this.temp_manual_button);
        jPanel11.add(this.temp_min_field);
        jPanel11.add(this.temp_max_field);
        jPanel8.add(jPanel11);
        jPanel8.add(this.temp_ignore_box);
        if (this.globals.getTempMinMaxOption() == 0) {
            this.temp_auto_button.setSelected(true);
            this.temp_ignore_box.setEnabled(false);
        } else if (this.globals.getTempMinMaxOption() == 1) {
            this.temp_default_button.setSelected(true);
            this.temp_ignore_box.setEnabled(true);
        } else {
            this.temp_manual_button.setSelected(true);
            this.temp_ignore_box.setEnabled(true);
        }
        this.temp_ignore_box.setSelected(this.globals.getTempIgnoreExtremes());
        this.temp_auto_button.addActionListener(this);
        this.temp_default_button.addActionListener(this);
        this.temp_manual_button.addActionListener(this);
        jPanel3.add(jPanel8);
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createTitledBorder("Moisture"));
        jPanel12.setLayout(new StackLayout());
        this.wvap_auto_button = new JRadioButton("Automatic:  (min to max)");
        this.wvap_default_button = new JRadioButton("Default: ");
        this.wvap_manual_button = new JRadioButton("Manual: ");
        this.wvap_default_label = new JLabel("(" + this.globals.getWvapDefaultMin() + " to " + this.globals.getWvapDefaultMax() + ")");
        this.wvap_min_field = new JTextField("" + this.globals.getWvapManualMin(), 5);
        this.wvap_max_field = new JTextField("" + this.globals.getWvapManualMax(), 5);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.wvap_auto_button);
        buttonGroup3.add(this.wvap_default_button);
        buttonGroup3.add(this.wvap_manual_button);
        this.wvap_ignore_box = new JCheckBox("Ignore values outside of min/max");
        jPanel12.add(new JLabel("Min/Max Data Range:"));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new FlowLayout(0));
        jPanel13.add(new JLabel("    "));
        jPanel13.add(this.wvap_auto_button);
        jPanel12.add(jPanel13);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new FlowLayout(0));
        jPanel14.add(new JLabel("    "));
        jPanel14.add(this.wvap_default_button);
        jPanel14.add(this.wvap_default_label);
        jPanel12.add(jPanel14);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new FlowLayout(0));
        jPanel15.add(new JLabel("    "));
        jPanel15.add(this.wvap_manual_button);
        jPanel15.add(this.wvap_min_field);
        jPanel15.add(this.wvap_max_field);
        jPanel12.add(jPanel15);
        jPanel12.add(this.wvap_ignore_box);
        if (this.globals.getWvapMinMaxOption() == 0) {
            this.wvap_auto_button.setSelected(true);
            this.wvap_ignore_box.setEnabled(false);
        } else if (this.globals.getWvapMinMaxOption() == 1) {
            this.wvap_default_button.setSelected(true);
            this.wvap_ignore_box.setEnabled(true);
        } else {
            this.wvap_manual_button.setSelected(true);
            this.wvap_ignore_box.setEnabled(true);
        }
        this.wvap_ignore_box.setSelected(this.globals.getWvapIgnoreExtremes());
        this.wvap_auto_button.addActionListener(this);
        this.wvap_default_button.addActionListener(this);
        this.wvap_manual_button.addActionListener(this);
        jPanel3.add(jPanel12);
        jPanel2.add(jPanel3);
        JPanel jPanel16 = new JPanel();
        jPanel16.setBorder(BorderFactory.createTitledBorder("Data Point Display Options"));
        int n4 = (int)(this.globals.getSampleSizeDisplayCutoff() * 100.0f);
        this.below_cutoff_box = new JCheckBox("Sample size cutoff limit: ");
        this.cutoff_slider = new JSlider(0, 0, 20, n4 / 5);
        this.cutoff_slider.setMajorTickSpacing(5);
        this.cutoff_slider.setMinorTickSpacing(1);
        this.cutoff_slider.setPaintTicks(true);
        this.cutoff_slider.setPaintLabels(true);
        this.cutoff_slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0%"));
        hashtable.put(new Integer(5), new JLabel("25%"));
        hashtable.put(new Integer(10), new JLabel("50%"));
        hashtable.put(new Integer(15), new JLabel("75%"));
        hashtable.put(new Integer(20), new JLabel("100%"));
        this.cutoff_slider.setLabelTable(hashtable);
        this.cutoff_slider.addChangeListener(this);
        this.cutoff_label = new JLabel("     " + n4 + "%");
        jPanel16.add(this.below_cutoff_box);
        jPanel16.add(this.cutoff_slider);
        jPanel16.add(this.cutoff_label);
        this.below_cutoff_box.setSelected(this.globals.getUseSampleSizeDisplayCutoff());
        this.below_cutoff_box.addActionListener(this);
        this.cutoff_slider.setEnabled(this.below_cutoff_box.isSelected());
        this.cutoff_label.setEnabled(this.below_cutoff_box.isSelected());
        jPanel2.add(jPanel16);
        JPanel jPanel17 = new JPanel();
        jPanel17.setBorder(BorderFactory.createTitledBorder("Graph Lines"));
        jPanel17.setLayout(new ParagraphLayout());
        this.subgroup_list = new JComboBox<String>(stringArray);
        this.subgroup_list.addActionListener(this);
        jPanel17.add((Component)new JLabel("Raob/Sat Data:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel17.add(this.subgroup_list);
        this.line_color_field = new JTextField(3);
        this.line_color_field.setEditable(false);
        this.line_color_button = new JButton("Pick Color");
        JPanel jPanel18 = new JPanel();
        jPanel18.add(this.line_color_field);
        jPanel18.add(this.line_color_button);
        jPanel17.add((Component)jPanel18, ParagraphLayout.NEW_LINE);
        this.line_color_button.addActionListener(this);
        Color[] colorArray = this.globals.getSubgroupColors();
        this.current_colors = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            this.current_colors[i] = colorArray[i];
        }
        this.line_color_field.setBackground(this.current_colors[0]);
        if (stringArray2.length > 0) {
            this.profile_list = new JComboBox<String>(stringArray2);
        } else {
            String[] stringArray3 = new String[]{"No profiles selected"};
            this.profile_list = new JComboBox<String>(stringArray3);
        }
        this.profile_list.addActionListener(this);
        jPanel17.add((Component)new JLabel("Stat Profile:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel17.add(this.profile_list);
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new ParagraphLayout());
        this.line_thickness_slider = new JSlider(0, 0, 10, 0);
        this.line_thickness_slider.setMajorTickSpacing(1);
        this.line_thickness_slider.setPaintTicks(true);
        this.line_thickness_slider.setPaintLabels(true);
        this.line_thickness_slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable2 = new Hashtable<Integer, JLabel>();
        hashtable2.put(new Integer(0), new JLabel("A"));
        hashtable2.put(new Integer(1), new JLabel("1"));
        hashtable2.put(new Integer(5), new JLabel("5"));
        hashtable2.put(new Integer(10), new JLabel("10"));
        this.line_thickness_slider.setLabelTable(hashtable2);
        int[][][] nArray3 = this.globals.getSubgroupLineThicknesses();
        this.current_thicknesses = new int[colorArray.length][27][4];
        for (n3 = 0; n3 < colorArray.length; ++n3) {
            for (n2 = 0; n2 < 27; ++n2) {
                for (n = 0; n < 4; ++n) {
                    this.current_thicknesses[n3][n2][n] = nArray3[n3][n2][n];
                }
            }
        }
        n3 = 0;
        n2 = 0;
        n = 0;
        if (nArray2.length > 0) {
            int n5 = nArray2[this.profile_list.getSelectedIndex()];
            n3 = n5 / 1000;
            n2 = n5 % 1000 / 10;
            n = n5 % 10;
            this.line_thickness_slider.setValue(this.current_thicknesses[n3][n2][n]);
        }
        this.line_thickness_slider.addChangeListener(this);
        jPanel19.add((Component)new JLabel("Line Thickness:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel19.add(this.line_thickness_slider);
        String[] stringArray4 = new String[]{"Solid", "Short Dash", "Long Dash", "Dots", "Short Long", "Diamonds"};
        this.line_style_list = new JComboBox<String>(stringArray4);
        int[][][] nArray4 = this.globals.getSubgroupLineStyles();
        this.current_styles = new int[colorArray.length][27][4];
        for (int i = 0; i < colorArray.length; ++i) {
            for (int j = 0; j < 27; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.current_styles[i][j][k] = nArray4[i][j][k];
                }
            }
        }
        if (nArray2.length > 0) {
            this.line_style_list.setSelectedIndex(this.current_styles[n3][n2][n]);
        }
        this.line_style_list.addActionListener(this);
        jPanel19.add((Component)new JLabel("Line Style:"), ParagraphLayout.NEW_PARAGRAPH);
        jPanel19.add(this.line_style_list);
        jPanel17.add((Component)jPanel19, ParagraphLayout.NEW_LINE);
        if (nArray2.length == 0) {
            this.profile_list.setEnabled(false);
            this.line_thickness_slider.setEnabled(false);
            this.line_style_list.setEnabled(false);
        }
        this.show_data_points_box = new JCheckBox("Show Data Points");
        this.show_data_points_box.setSelected(this.globals.getShowDataPoints());
        jPanel17.add((Component)this.show_data_points_box, ParagraphLayout.NEW_PARAGRAPH);
        this.reset_lines_button = new JButton("Reset Lines");
        this.reset_lines_button.addActionListener(this);
        jPanel17.add((Component)this.reset_lines_button, ParagraphLayout.NEW_PARAGRAPH);
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout(new StackLayout());
        jPanel20.setBorder(BorderFactory.createTitledBorder("Starting / Ending Dates"));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new GridLayout(1, 2));
        this.start_date_panel = new DateChooserPanel(this.globals.getEarliestDataDate(), this.globals.getLatestDataDate(), this.globals.getCurrentStartDate());
        this.start_date_panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.end_date_panel = new DateChooserPanel(this.globals.getEarliestDataDate(), this.globals.getLatestDataDate(), this.globals.getCurrentEndDate());
        this.end_date_panel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        jPanel21.add(this.start_date_panel);
        jPanel21.add(this.end_date_panel);
        this.reset_dates_button = new JButton("Reset Dates");
        this.reset_dates_button.addActionListener(this);
        JPanel jPanel22 = new JPanel();
        jPanel22.add(this.reset_dates_button);
        jPanel20.add(jPanel21);
        jPanel20.add(jPanel22);
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel23.add(jPanel17);
        jPanel23.add(jPanel20);
        jPanel2.add(jPanel23);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == this.sample_size_auto_button) {
                this.sample_size_ignore_box.setEnabled(false);
            } else if (jRadioButton == this.sample_size_default_button) {
                this.sample_size_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.sample_size_manual_button) {
                this.sample_size_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.temp_auto_button) {
                this.temp_ignore_box.setEnabled(false);
            } else if (jRadioButton == this.temp_default_button) {
                this.temp_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.temp_manual_button) {
                this.temp_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.wvap_auto_button) {
                this.wvap_ignore_box.setEnabled(false);
            } else if (jRadioButton == this.wvap_default_button) {
                this.wvap_ignore_box.setEnabled(true);
            } else if (jRadioButton == this.wvap_manual_button) {
                this.wvap_ignore_box.setEnabled(true);
            }
        } else if (actionEvent.getSource() instanceof JButton) {
            if ((JButton)actionEvent.getSource() == this.ok_button) {
                boolean bl = this.checkTextValues();
                if (bl) {
                    this.updateGlobalValues();
                    this.ok_button_pressed = true;
                    this.setVisible(false);
                }
            } else if ((JButton)actionEvent.getSource() == this.cancel_button) {
                this.ok_button_pressed = false;
                this.setVisible(false);
            } else if ((JButton)actionEvent.getSource() == this.reset_dates_button) {
                this.resetDates();
            } else if ((JButton)actionEvent.getSource() == this.line_color_button) {
                this.pickColor();
            } else if ((JButton)actionEvent.getSource() == this.reset_lines_button) {
                this.resetLines();
            }
        } else if (actionEvent.getSource() instanceof JComboBox) {
            if ((JComboBox)actionEvent.getSource() == this.subgroup_list) {
                this.line_color_field.setBackground(this.current_colors[this.subgroup_list.getSelectedIndex()]);
            } else if ((JComboBox)actionEvent.getSource() == this.profile_list) {
                int n = this.profile_indices[this.profile_list.getSelectedIndex()];
                int n2 = n / 1000;
                int n3 = n % 1000 / 10;
                int n4 = n % 10;
                this.line_thickness_slider.setValue(this.current_thicknesses[n2][n3][n4]);
                this.line_style_list.setSelectedIndex(this.current_styles[n2][n3][n4]);
            } else if ((JComboBox)actionEvent.getSource() == this.line_style_list) {
                int n = this.profile_indices[this.profile_list.getSelectedIndex()];
                int n5 = n / 1000;
                int n6 = n % 1000 / 10;
                int n7 = n % 10;
                this.current_styles[n5][n6][n7] = this.line_style_list.getSelectedIndex();
            }
        } else if (actionEvent.getSource() instanceof JCheckBox && (JCheckBox)actionEvent.getSource() == this.below_cutoff_box) {
            this.globals.setUseSampleSizeDisplayCutoff(this.below_cutoff_box.isSelected());
            this.cutoff_slider.setEnabled(this.below_cutoff_box.isSelected());
            this.cutoff_label.setEnabled(this.below_cutoff_box.isSelected());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if ((JSlider)changeEvent.getSource() == this.line_thickness_slider) {
            int n = this.profile_indices[this.profile_list.getSelectedIndex()];
            int n2 = n / 1000;
            int n3 = n % 1000 / 10;
            int n4 = n % 10;
            this.current_thicknesses[n2][n3][n4] = this.line_thickness_slider.getValue();
        } else if ((JSlider)changeEvent.getSource() == this.cutoff_slider) {
            float f = (float)this.cutoff_slider.getValue() * 5.0f / 100.0f;
            this.globals.setSampleSizeDisplayCutoff(f);
            this.cutoff_label.setText("     " + (int)(f * 100.0f) + "%");
        }
    }

    private void pickColor() {
        Color color = this.line_color_field.getBackground();
        JFrame jFrame = new JFrame();
        Color color2 = JColorChooser.showDialog(jFrame, "Choose Line Color", color);
        this.line_color_field.setBackground(color2);
        this.current_colors[this.subgroup_list.getSelectedIndex()] = color2;
    }

    private void resetLines() {
        int n;
        Color[] colorArray = this.globals.getDefaultSubgroupColors();
        for (n = 0; n < this.current_colors.length; ++n) {
            this.current_colors[n] = colorArray[n];
        }
        this.line_color_field.setBackground(this.current_colors[this.subgroup_list.getSelectedIndex()]);
        this.current_thicknesses = this.globals.getDefaultSubgroupLineThicknesses();
        this.current_styles = this.globals.getDefaultSubgroupLineStyles();
        if (this.profile_indices.length > 0) {
            n = this.profile_indices[this.profile_list.getSelectedIndex()];
            int n2 = n / 1000;
            int n3 = n % 1000 / 10;
            int n4 = n % 10;
            this.line_thickness_slider.setValue(this.current_thicknesses[n2][n3][n4]);
            this.line_style_list.setSelectedIndex(this.current_styles[n2][n3][n4]);
        }
        this.show_data_points_box.setSelected(false);
    }

    private boolean checkTextValues() {
        Float f;
        float f2;
        float f3;
        boolean bl = true;
        if (this.sample_size_manual_button.isSelected()) {
            f3 = -32768.0f;
            f2 = -32768.0f;
            try {
                f = new Float(this.sample_size_min_field.getText());
                f3 = f.floatValue();
                this.sample_size_min_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.sample_size_min_field.setBackground(Color.red);
                bl = false;
            }
            try {
                f = new Float(this.sample_size_max_field.getText());
                f2 = f.floatValue();
                this.sample_size_max_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.sample_size_max_field.setBackground(Color.red);
                bl = false;
            }
            if (bl && f3 >= f2) {
                this.sample_size_min_field.setBackground(Color.red);
                this.sample_size_max_field.setBackground(Color.red);
                bl = false;
            }
        }
        if (this.temp_manual_button.isSelected()) {
            f3 = -32768.0f;
            f2 = -32768.0f;
            try {
                f = new Float(this.temp_min_field.getText());
                f3 = f.floatValue();
                this.temp_min_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.temp_min_field.setBackground(Color.red);
                bl = false;
            }
            try {
                f = new Float(this.temp_max_field.getText());
                f2 = f.floatValue();
                this.temp_max_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.temp_max_field.setBackground(Color.red);
                bl = false;
            }
            if (bl && f3 >= f2) {
                this.temp_min_field.setBackground(Color.red);
                this.temp_max_field.setBackground(Color.red);
                bl = false;
            }
        }
        if (this.wvap_manual_button.isSelected()) {
            f3 = -32768.0f;
            f2 = -32768.0f;
            try {
                f = new Float(this.wvap_min_field.getText());
                f3 = f.floatValue();
                this.wvap_min_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.wvap_min_field.setBackground(Color.red);
                bl = false;
            }
            try {
                f = new Float(this.wvap_max_field.getText());
                f2 = f.floatValue();
                this.wvap_max_field.setBackground(this.text_background_color);
            }
            catch (NumberFormatException numberFormatException) {
                this.wvap_max_field.setBackground(Color.red);
                bl = false;
            }
            if (bl && f3 >= f2) {
                this.wvap_min_field.setBackground(Color.red);
                this.wvap_max_field.setBackground(Color.red);
                bl = false;
            }
        }
        return bl;
    }

    private void updateGlobalValues() {
        long l;
        float f;
        Float f2;
        if (this.sample_size_auto_button.isSelected()) {
            this.globals.setSampleSizeMinMaxOption(0);
        } else if (this.sample_size_default_button.isSelected()) {
            this.globals.setSampleSizeMinMaxOption(1);
        } else {
            this.globals.setSampleSizeMinMaxOption(2);
        }
        try {
            f2 = new Float(this.sample_size_min_field.getText());
            f = f2.floatValue();
            this.globals.setSampleSizeManualMin(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f2 = new Float(this.sample_size_max_field.getText());
            f = f2.floatValue();
            this.globals.setSampleSizeManualMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.globals.setSampleSizeIgnoreExtremes(this.sample_size_ignore_box.isSelected());
        if (this.temp_auto_button.isSelected()) {
            this.globals.setTempMinMaxOption(0);
        } else if (this.temp_default_button.isSelected()) {
            this.globals.setTempMinMaxOption(1);
        } else {
            this.globals.setTempMinMaxOption(2);
        }
        try {
            f2 = new Float(this.temp_min_field.getText());
            f = f2.floatValue();
            this.globals.setTempManualMin(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f2 = new Float(this.temp_max_field.getText());
            f = f2.floatValue();
            this.globals.setTempManualMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.globals.setTempIgnoreExtremes(this.temp_ignore_box.isSelected());
        if (this.wvap_auto_button.isSelected()) {
            this.globals.setWvapMinMaxOption(0);
        } else if (this.wvap_default_button.isSelected()) {
            this.globals.setWvapMinMaxOption(1);
        } else {
            this.globals.setWvapMinMaxOption(2);
        }
        try {
            f2 = new Float(this.wvap_min_field.getText());
            f = f2.floatValue();
            this.globals.setWvapManualMin(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f2 = new Float(this.wvap_max_field.getText());
            f = f2.floatValue();
            this.globals.setWvapManualMax(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.globals.setWvapIgnoreExtremes(this.wvap_ignore_box.isSelected());
        long l2 = this.start_date_panel.getSelectedDate();
        long l3 = this.end_date_panel.getSelectedDate();
        if (l2 > l3) {
            l = l2;
            l2 = l3;
            l3 = l;
        }
        l = this.globals.getEarliestDataDate();
        long l4 = this.globals.getLatestDataDate();
        l2 = Math.max(l2, l);
        l3 = Math.min(l3, l4);
        this.globals.setCurrentStartDate(l2);
        this.globals.setCurrentEndDate(l3);
        this.globals.setSubgroupColors(this.current_colors);
        if (this.profile_indices.length > 0) {
            this.globals.setSubgroupLineThicknesses(this.current_thicknesses);
            this.globals.setSubgroupLineStyles(this.current_styles);
        }
        this.globals.setShowDataPoints(this.show_data_points_box.isSelected());
    }

    public void resetDates() {
        this.start_date_panel.setDate(this.globals.getEarliestDataDate());
        this.end_date_panel.setDate(this.globals.getLatestDataDate());
    }

    public boolean okButtonPressed() {
        return this.ok_button_pressed;
    }
}

