/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class StatPanel
extends JPanel
implements ActionListener {
    private NARCS parent;
    private StatGraph graph;
    private JRadioButton daily_button;
    private JRadioButton weekly_button;
    private JRadioButton monthly_button;
    private JCheckBox passed_and_failed_qc_box;
    private JCheckBox passed_qc_box;
    private JCheckBox failed_qc_box;
    private JCheckBox sea_box;
    private JCheckBox nonsea_box;
    private JCheckBox sea_and_nonsea_box;
    private JCheckBox clear_box;
    private JCheckBox cloudy_box;
    private JCheckBox clear_and_cloudy_box;
    private JCheckBox bias_box;
    private JCheckBox stddev_box;
    private JCheckBox samplesize_box;
    private JCheckBox rms_box;
    private ScrollingPanel subgroup_panel;
    private JCheckBox[] subgroup_box;
    private JButton graph_options_button;
    private JComboBox level_list_box;
    private int data_type;
    private boolean ignore_events;
    private int num_subgroups;
    private int level_type;
    private String level_description;
    private String[] full_subgroup_names;
    private int[] subgroup_group_pointers;
    private NarcsGlobals globals;
    private final int TEMPERATURE = 1;
    private final int MOISTURE = 2;

    public StatPanel(int n) {
        this.data_type = n;
        this.globals = new NarcsGlobals();
        this.addControls();
    }

    public void addFileInfo(NARCS nARCS, String string, int[] nArray, String[] stringArray, int n, int[] nArray2, int n2, int[] nArray3, int[] nArray4, int[] nArray5, String[] stringArray2, int n3, String[] stringArray3) {
        int n4;
        this.parent = nARCS;
        this.num_subgroups = n2;
        this.full_subgroup_names = new String[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            this.full_subgroup_names[n4] = stringArray3[nArray3[n4]] + " " + stringArray2[n4];
        }
        this.subgroup_group_pointers = new int[n2];
        Arrays.fill(this.subgroup_group_pointers, Short.MIN_VALUE);
        for (n4 = 0; n4 < n2; ++n4) {
            if (nArray4[n4] != 0) continue;
            this.subgroup_group_pointers[n4] = nArray3[n4];
        }
        this.addSubgroupControls(nArray3, stringArray2, n3, stringArray3);
        this.level_list_box.removeActionListener(this);
        this.level_list_box.removeAllItems();
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            this.level_list_box.addItem(stringArray[n4]);
        }
        this.level_list_box.addActionListener(this);
        this.graph_options_button.setEnabled(true);
        this.daily_button.setEnabled(true);
        this.weekly_button.setEnabled(true);
        this.monthly_button.setEnabled(true);
        this.bias_box.setEnabled(true);
        this.stddev_box.setEnabled(true);
        this.samplesize_box.setEnabled(true);
        this.rms_box.setEnabled(true);
        this.passed_and_failed_qc_box.setEnabled(true);
        this.passed_qc_box.setEnabled(true);
        this.failed_qc_box.setEnabled(true);
        this.sea_box.setEnabled(true);
        this.nonsea_box.setEnabled(true);
        this.sea_and_nonsea_box.setEnabled(true);
        this.clear_and_cloudy_box.setEnabled(true);
        this.clear_box.setEnabled(true);
        this.cloudy_box.setEnabled(true);
        this.level_list_box.setEnabled(true);
        this.ignore_events = false;
        this.graph.addFileInfo(string, nArray, stringArray, n, nArray2, n2, this.full_subgroup_names);
    }

    private void addControls() {
        this.setLayout(new BorderLayout());
        this.subgroup_panel = new ScrollingPanel();
        this.subgroup_panel.setBackground(Color.white);
        this.subgroup_panel.setLayout(new StackLayout());
        this.add((Component)this.subgroup_panel, "East");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.level_list_box = new JComboBox();
        this.level_list_box.addActionListener(this);
        jPanel3.add(this.level_list_box);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.graph_options_button = new JButton("Graph Options");
        this.graph_options_button.addActionListener(this);
        jPanel4.add(this.graph_options_button);
        jPanel2.add(jPanel4);
        jPanel.add(jPanel2);
        this.daily_button = new JRadioButton("Daily");
        this.weekly_button = new JRadioButton("Weekly");
        this.monthly_button = new JRadioButton("Monthly");
        this.daily_button.addActionListener(this);
        this.weekly_button.addActionListener(this);
        this.monthly_button.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.daily_button);
        buttonGroup.add(this.weekly_button);
        buttonGroup.add(this.monthly_button);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel5.setLayout(new GridLayout(3, 1));
        jPanel5.add(this.daily_button);
        jPanel5.add(this.weekly_button);
        jPanel5.add(this.monthly_button);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel6.setLayout(new GridLayout(3, 2));
        this.bias_box = new JCheckBox("Bias");
        this.stddev_box = new JCheckBox("Std Dev");
        this.samplesize_box = new JCheckBox("Sample Size");
        this.rms_box = new JCheckBox("RMS");
        this.bias_box.setSelected(this.globals.getShowBias());
        this.stddev_box.setSelected(this.globals.getShowStdDev());
        this.samplesize_box.setSelected(this.globals.getShowSampleSize());
        this.rms_box.setSelected(this.globals.getShowRMS());
        this.bias_box.addActionListener(this);
        this.stddev_box.addActionListener(this);
        this.samplesize_box.addActionListener(this);
        this.rms_box.addActionListener(this);
        jPanel6.add(this.bias_box);
        jPanel6.add(this.samplesize_box);
        jPanel6.add(this.stddev_box);
        jPanel6.add(new JLabel(""));
        jPanel6.add(this.rms_box);
        jPanel6.add(new JLabel(""));
        jPanel.add(jPanel6);
        this.passed_and_failed_qc_box = new JCheckBox("Passed / Failed QC");
        this.passed_qc_box = new JCheckBox("Passed QC");
        this.failed_qc_box = new JCheckBox("Failed QC");
        this.passed_and_failed_qc_box.setSelected(this.globals.getShowPassedAndFailedQC());
        this.passed_qc_box.setSelected(this.globals.getShowPassedQC());
        this.failed_qc_box.setSelected(this.globals.getShowFailedQC());
        this.passed_and_failed_qc_box.addActionListener(this);
        this.passed_qc_box.addActionListener(this);
        this.failed_qc_box.addActionListener(this);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel7.setLayout(new GridLayout(3, 1));
        jPanel7.add(this.passed_and_failed_qc_box);
        jPanel7.add(this.passed_qc_box);
        jPanel7.add(this.failed_qc_box);
        jPanel.add(jPanel7);
        this.sea_and_nonsea_box = new JCheckBox("Sea and Non-Sea");
        this.sea_box = new JCheckBox("Sea");
        this.nonsea_box = new JCheckBox("Non-Sea");
        this.sea_box.addActionListener(this);
        this.nonsea_box.addActionListener(this);
        this.sea_and_nonsea_box.addActionListener(this);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel8.setLayout(new GridLayout(3, 1));
        jPanel8.add(this.sea_and_nonsea_box);
        jPanel8.add(this.sea_box);
        jPanel8.add(this.nonsea_box);
        jPanel.add(jPanel8);
        this.clear_and_cloudy_box = new JCheckBox("Clear and Cloudy");
        this.clear_box = new JCheckBox("Clear");
        this.cloudy_box = new JCheckBox("Cloudy");
        this.clear_box.addActionListener(this);
        this.cloudy_box.addActionListener(this);
        this.clear_and_cloudy_box.addActionListener(this);
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(this.getBackground().darker(), this.getBackground().brighter()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel9.setLayout(new GridLayout(3, 1));
        jPanel9.add(this.clear_and_cloudy_box);
        jPanel9.add(this.clear_box);
        jPanel9.add(this.cloudy_box);
        jPanel.add(jPanel9);
        this.add((Component)jPanel, "South");
        this.graph = new StatGraph(this.data_type);
        this.add((Component)this.graph, "Center");
        this.graph_options_button.setEnabled(false);
        this.daily_button.setEnabled(false);
        this.weekly_button.setEnabled(false);
        this.monthly_button.setEnabled(false);
        this.bias_box.setEnabled(false);
        this.stddev_box.setEnabled(false);
        this.samplesize_box.setEnabled(false);
        this.rms_box.setEnabled(false);
        this.passed_and_failed_qc_box.setEnabled(false);
        this.passed_qc_box.setEnabled(false);
        this.failed_qc_box.setEnabled(false);
        this.sea_box.setEnabled(false);
        this.nonsea_box.setEnabled(false);
        this.sea_and_nonsea_box.setEnabled(false);
        this.clear_and_cloudy_box.setEnabled(false);
        this.clear_box.setEnabled(false);
        this.cloudy_box.setEnabled(false);
        this.level_list_box.setEnabled(false);
    }

    private void addSubgroupControls(int[] nArray, String[] stringArray, int n, String[] stringArray2) {
        this.subgroup_panel.removeAll();
        this.subgroup_panel.revalidate();
        boolean[] blArray = this.globals.getShowSubGroups();
        boolean[] blArray2 = new boolean[n];
        Arrays.fill(blArray2, false);
        this.subgroup_box = new JCheckBox[this.num_subgroups];
        for (int i = 0; i < this.num_subgroups; ++i) {
            String string = "   " + stringArray[i];
            if (!blArray2[nArray[i]]) {
                string = stringArray2[nArray[i]] + " " + stringArray[i];
                blArray2[nArray[i]] = true;
            }
            this.subgroup_box[i] = new JCheckBox(string);
            this.subgroup_box[i].addActionListener(this);
            this.subgroup_box[i].setForeground(this.globals.getSubgroupColor(i));
            this.subgroup_box[i].setBackground(Color.white);
            this.subgroup_box[i].setSelected(blArray[i]);
            this.subgroup_panel.add(this.subgroup_box[i]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.ignore_events) {
            if (actionEvent.getSource() instanceof JButton) {
                this.changeGraphSettings();
            } else if (actionEvent.getSource() instanceof JRadioButton) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                if (jRadioButton == this.daily_button || jRadioButton == this.weekly_button || jRadioButton == this.monthly_button) {
                    this.changeTimeWindow();
                }
            } else if (actionEvent.getSource() instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox == this.bias_box) {
                    this.globals.setShowBias(this.bias_box.isSelected());
                    this.graph.updateGraph();
                } else if (jCheckBox == this.stddev_box) {
                    this.globals.setShowStdDev(this.stddev_box.isSelected());
                    this.graph.updateGraph();
                } else if (jCheckBox == this.samplesize_box) {
                    this.globals.setShowSampleSize(this.samplesize_box.isSelected());
                    this.graph.updateGraph();
                } else if (jCheckBox == this.rms_box) {
                    this.globals.setShowRMS(this.rms_box.isSelected());
                    this.graph.updateGraph();
                } else if (jCheckBox == this.passed_and_failed_qc_box || jCheckBox == this.passed_qc_box || jCheckBox == this.failed_qc_box) {
                    this.changeQCOptions();
                } else if (jCheckBox == this.sea_box || jCheckBox == this.nonsea_box || jCheckBox == this.sea_and_nonsea_box) {
                    this.changeTerrainOptions();
                } else if (jCheckBox == this.clear_box || jCheckBox == this.cloudy_box || jCheckBox == this.clear_and_cloudy_box) {
                    this.changeCloudOptions();
                } else {
                    int n;
                    boolean bl = false;
                    boolean bl2 = false;
                    for (n = 0; n < this.num_subgroups; ++n) {
                        if (jCheckBox != this.subgroup_box[n]) continue;
                        bl = true;
                        bl2 = this.subgroup_box[n].isSelected();
                    }
                    if (bl) {
                        if ((actionEvent.getModifiers() & 2) != 0) {
                            for (n = 0; n < this.num_subgroups; ++n) {
                                this.ignore_events = true;
                                this.subgroup_box[n].setSelected(bl2);
                                this.ignore_events = false;
                            }
                        }
                        boolean[] blArray = new boolean[this.num_subgroups];
                        for (int i = 0; i < this.num_subgroups; ++i) {
                            blArray[i] = this.subgroup_box[i].isSelected();
                        }
                        this.globals.setShowSubGroups(blArray);
                        this.graph.updateGraph();
                    }
                }
            } else if (actionEvent.getSource() instanceof JComboBox && (JComboBox)actionEvent.getSource() == this.level_list_box) {
                this.graph.newDataLevel(this.level_list_box.getSelectedIndex());
                if (this.data_type == 1) {
                    this.globals.setLastSelectedTemperaturePressure(this.level_list_box.getSelectedIndex());
                } else {
                    this.globals.setLastSelectedMoisturePressure(this.level_list_box.getSelectedIndex());
                }
            }
        }
    }

    public void panelSelected() {
        this.ignore_events = true;
        if (this.globals.getTimeWindowOption() == 0) {
            this.daily_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 1) {
            this.weekly_button.setSelected(true);
        } else if (this.globals.getTimeWindowOption() == 2) {
            this.monthly_button.setSelected(true);
        }
        this.bias_box.setSelected(this.globals.getShowBias());
        this.stddev_box.setSelected(this.globals.getShowStdDev());
        this.samplesize_box.setSelected(this.globals.getShowSampleSize());
        this.rms_box.setSelected(this.globals.getShowRMS());
        this.passed_and_failed_qc_box.setSelected(this.globals.getShowPassedAndFailedQC());
        this.passed_qc_box.setSelected(this.globals.getShowPassedQC());
        this.failed_qc_box.setSelected(this.globals.getShowFailedQC());
        this.sea_box.setSelected(this.globals.getShowSea());
        this.nonsea_box.setSelected(this.globals.getShowNonsea());
        this.sea_and_nonsea_box.setSelected(this.globals.getShowSeaAndNonsea());
        this.clear_box.setSelected(this.globals.getShowClear());
        this.cloudy_box.setSelected(this.globals.getShowCloudy());
        this.clear_and_cloudy_box.setSelected(this.globals.getShowClearAndCloudy());
        this.ignore_events = false;
        int n = 0;
        n = this.data_type == 1 ? this.globals.getLastSelectedTemperaturePressure() : this.globals.getLastSelectedMoisturePressure();
        if (n < 0 || n >= this.level_list_box.getItemCount()) {
            n = 0;
        }
        this.level_list_box.setSelectedIndex(n);
        if (this.subgroup_box != null) {
            for (int i = 0; i < this.subgroup_box.length; ++i) {
                this.subgroup_box[i].setForeground(this.globals.getSubgroupColor(i));
            }
            boolean[] blArray = this.globals.getShowSubGroups();
            for (int i = 0; i < this.num_subgroups; ++i) {
                this.subgroup_box[i].setSelected(blArray[i]);
            }
            this.graph.newTimeWindow();
        }
    }

    public void panelUnselected() {
        this.graph.removeProfiles();
    }

    private void changeTimeWindow() {
        int n = 0;
        if (this.weekly_button.isSelected()) {
            n = 1;
        } else if (this.monthly_button.isSelected()) {
            n = 2;
        }
        this.globals.setTimeWindowOption(n);
        this.graph.newTimeWindow();
    }

    private void changeQCOptions() {
        this.globals.setShowPassedAndFailedQC(this.passed_and_failed_qc_box.isSelected());
        this.globals.setShowPassedQC(this.passed_qc_box.isSelected());
        this.globals.setShowFailedQC(this.failed_qc_box.isSelected());
        this.graph.updateGraph();
    }

    private void changeTerrainOptions() {
        this.globals.setShowSea(this.sea_box.isSelected());
        this.globals.setShowNonsea(this.nonsea_box.isSelected());
        this.globals.setShowSeaAndNonsea(this.sea_and_nonsea_box.isSelected());
        this.graph.updateGraph();
    }

    private void changeCloudOptions() {
        this.globals.setShowClear(this.clear_box.isSelected());
        this.globals.setShowCloudy(this.cloudy_box.isSelected());
        this.globals.setShowClearAndCloudy(this.clear_and_cloudy_box.isSelected());
        this.graph.updateGraph();
    }

    public void changeGraphSettings() {
        int[] nArray;
        Vector vector = this.graph.getProfileData();
        String[] stringArray = (String[])vector.elementAt(0);
        StatOptionsDialog statOptionsDialog = new StatOptionsDialog(this.parent, this.full_subgroup_names, this.subgroup_group_pointers, stringArray, nArray = (int[])vector.elementAt(1));
        if (statOptionsDialog.okButtonPressed()) {
            for (int i = 0; i < this.subgroup_box.length; ++i) {
                this.subgroup_box[i].setForeground(this.globals.getSubgroupColor(i));
            }
            this.graph.newTimeWindow();
        }
    }

    public void makeImage(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(Color.black);
        int n5 = (int)((float)n3 * 0.15f);
        int n6 = n3 - n5;
        graphics2D.setClip(n + n6, n2, n5, n4);
        this.graph.drawLegend(graphics2D, n + n6, n2, n5, n4);
        graphics2D.setClip(null);
        graphics2D.setClip(n, n2, n6, n4);
        this.graph.drawGraph(graphics2D, n, n2, n6, n4);
        graphics2D.setClip(null);
    }
}

