/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class Atovs1000Record
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;

    public Atovs1000Record(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public Atovs1000Record(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public Atovs1000Record() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[500];
        for (int i = 0; i < 500; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        return "";
    }

    public float getLatitude() {
        return (float)this.buffer[23] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[24] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[18];
        int n = this.buffer[25] % 100;
        int n2 = this.buffer[26] / 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[18] * 10000 + this.buffer[25] % 100 * 100 + this.buffer[26] / 100;
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[26] % 100;
        int n2 = this.buffer[27] / 100;
        int n3 = this.buffer[27] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[26] % 100 * 10000 + this.buffer[27];
        return n;
    }

    public String getTerrainString() {
        String string = this.buffer[29] == 0 ? "Sea" : (this.buffer[29] == 1 ? "Land" : (this.buffer[29] == 2 ? "Coast" : (this.buffer[29] == 10 ? "Ice" : (this.buffer[29] == 11 ? "Snow" : "(invalid value)"))));
        return string;
    }

    public int getTerrain() {
        return this.buffer[29];
    }

    public boolean hasSeaNonseaValue() {
        return true;
    }

    public int getSeaNonseaValue() {
        int n = 0;
        if (this.getTerrain() != 0) {
            n = 1;
        }
        return n;
    }

    public boolean hasQCFlag() {
        return false;
    }

    public boolean getQCFlag() {
        return true;
    }

    public boolean hasCloudFlag() {
        return true;
    }

    public int getCloudFlag() {
        int n = Short.MIN_VALUE;
        if (this.buffer[440] != Short.MIN_VALUE) {
            float f = (float)this.buffer[440] / 1.0f;
            if (f <= 0.0f) {
                n = 0;
            } else if (f > 0.0f && f <= 20.0f) {
                n = 1;
            } else if (f > 20.0f) {
                n = 2;
            }
        }
        return n;
    }

    public boolean hasDayNightFlag() {
        return true;
    }

    public int getDayNightFlag() {
        int n = Short.MIN_VALUE;
        n = this.buffer[30] == 0 ? 0 : 1;
        return n;
    }

    public String getDayNight() {
        String string = this.buffer[30] == 0 ? "Night" : (this.buffer[30] == 1 ? "Day" : "(invalid value)");
        return string;
    }

    private int getSurfaceLevel() {
        int n = this.buffer[324];
        n = Math.min(n, 40);
        return n;
    }

    public float getSurfacePressure() {
        float f = -32768.0f;
        int n = this.getSurfaceLevel();
        if (n != Short.MIN_VALUE) {
            PressureLevels pressureLevels = new PressureLevels();
            f = pressureLevels.getPressure(n);
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        float f = this.getSurfacePressure();
        if (f <= 0.0f) {
            f = -32768.0f;
        }
        vector.add(new Float(f));
        float f2 = -32768.0f;
        if (f != -32768.0f && (f2 = this.getRetrievedTempValue(this.getSurfaceLevel())) <= 0.0f) {
            f2 = -32768.0f;
        }
        vector.add(new Float(f2));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription(), "1st Guess"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 1};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[2];
        if (!this.containsData()) {
            for (int i = 0; i < 2; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            PressureLevels pressureLevels = new PressureLevels();
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getRetrievedTemps();
            for (n = 0; n < 42; ++n) {
                if (fArray[n] == -999.99f) continue;
                profileArray[0].addItem(pressureLevels.getPressure(n + 1), fArray[n]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 0);
            fArray = this.getRetrievedGuessTemps();
            for (n = 0; n < 42; ++n) {
                if (!(fArray[n] > 0.0f)) continue;
                profileArray[1].addItem(pressureLevels.getPressure(n + 1), fArray[n]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[2];
        if (!this.containsData()) {
            for (int i = 0; i < 2; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            PressureLevels pressureLevels = new PressureLevels();
            float f = this.getSurfacePressure();
            int n2 = this.getSurfaceLevel();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedDewpoints();
            for (n = 0; n < 19; ++n) {
                if (fArray[n] == -999.99f) continue;
                profileArray[0].addItem(pressureLevels.getPressure(n + 24), fArray[n]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 1);
            fArray = this.getRetrievedGuessDewpoints();
            for (n = 0; n < 19; ++n) {
                if (!(fArray[n] > -999.99f)) continue;
                profileArray[1].addItem(pressureLevels.getPressure(n + 24), fArray[n]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[2];
        if (!this.containsData()) {
            for (int i = 0; i < 2; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            PressureLevels pressureLevels = new PressureLevels();
            float f = this.getSurfacePressure();
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            for (n = 0; n < 19; ++n) {
                if (fArray[n] == -999.99f) continue;
                profileArray[0].addItem(pressureLevels.getPressure(n + 24), fArray[n]);
            }
            profileArray[0].setSurfacePressure(f);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   1st Guess", 0, Color.black, 1, 1);
            fArray = this.getRetrievedGuessWVapors();
            for (n = 0; n < 19; ++n) {
                if (!(fArray[n] > -999.99f)) continue;
                profileArray[1].addItem(pressureLevels.getPressure(n + 24), fArray[n]);
            }
            profileArray[1].setSurfacePressure(f);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            if (n == 6 || n == 7 || n == 8) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 3) {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getPressures();
                float[] fArray2 = this.getRetrievedTemps();
                if (n == 3) {
                    fArray2 = this.getRetrievedGuessTemps();
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getWVPressures();
                float[] fArray3 = this.getRetrievedWaterVapor();
                if (n == 4 || n == 5) {
                    fArray3 = this.getRetrievedGuessWVapors();
                }
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && (n == 1 || n == 4)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4), new Vector(4)};
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getPressures();
        float[] fArray2 = pressureLevels.getWVPressures();
        int n2 = this.getSurfaceLevel();
        if (n2 != Short.MIN_VALUE) {
            int n3;
            float f = pressureLevels.getPressure(n2);
            for (n3 = 0; n3 < fArray.length; ++n3) {
                if (!(fArray[n3] > f)) continue;
                fArray[n3] = -999.99f;
            }
            for (n3 = 0; n3 < fArray2.length; ++n3) {
                if (!(fArray2[n3] > f)) continue;
                fArray2[n3] = -999.99f;
            }
        }
        float[] fArray3 = this.getRetrievedTemps();
        float[] fArray4 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray3);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray4);
        fArray3 = this.getRetrievedGuessTemps();
        fArray4 = this.getRetrievedGuessDewpoints();
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray3);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray4);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getPressures();
        return fArray;
    }

    private float[] getMoisturePressureLevels() {
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getWVPressures();
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[42];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.buffer[i + 44] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 44] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float getRetrievedTempValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 44] != Short.MIN_VALUE) {
            f = (float)this.buffer[n + 44] / 64.0f;
        }
        return f;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.buffer[i + 238] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 238] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        fArray[17] = -999.99f;
        fArray[18] = -999.99f;
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedBTemps() {
        float[] fArray = new float[35];
        for (int i = 0; i < 35; ++i) {
            fArray[i] = this.buffer[i + 86] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 86] / 64.0f;
        }
        return fArray;
    }

    private float[] getRetrievedGuessTemps() {
        float[] fArray = new float[42];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.buffer[i + 330] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 330] / 64.0f;
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedGuessWVapors() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.buffer[i + 372] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 372] / 1024.0);
            if (f == -999.99f || !(fArray2[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        fArray[17] = -999.99f;
        fArray[18] = -999.99f;
        return fArray;
    }

    private float[] getRetrievedGuessDewpoints() {
        float[] fArray = new float[19];
        float[] fArray2 = this.getRetrievedGuessWVapors();
        float[] fArray3 = this.getMoisturePressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 19; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
            if (f == -999.99f || !(fArray3[i] > f)) continue;
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedGuessBTemps() {
        float[] fArray = new float[35];
        for (int i = 0; i < 35; ++i) {
            fArray[i] = this.buffer[i + 391] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 391] / 64.0f;
        }
        return fArray;
    }

    private float[] getNonLimbCorrectedTemps() {
        float[] fArray = new float[35];
        for (int i = 0; i < 35; ++i) {
            fArray[i] = this.buffer[i + 161] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 161] / 64.0f;
        }
        return fArray;
    }

    private float[] getLimbCorrectedAmsuB() {
        float[] fArray = new float[5];
        for (int i = 0; i < 5; ++i) {
            fArray[i] = this.buffer[i + 460] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 460] / 64.0f;
        }
        return fArray;
    }

    private float[] getNonLimbCorrectedAmsuB() {
        float[] fArray = new float[5];
        for (int i = 0; i < 5; ++i) {
            fArray[i] = this.buffer[i + 465] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 465] / 64.0f;
        }
        return fArray;
    }

    private float[] getGuessAmsuB() {
        float[] fArray = new float[5];
        fArray[0] = -999.99f;
        fArray[1] = -999.99f;
        for (int i = 2; i < 5; ++i) {
            fArray[i] = this.buffer[i + 308] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 308] / 64.0f;
        }
        return fArray;
    }

    public float getTPW() {
        return EdgeUtils.twoDigits((float)this.buffer[259] / 128.0f);
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        float f = (float)this.buffer[439] / 1.0f;
        if (f == 1250.0f || f == -777.0f) {
            f = -32768.0f;
        }
        vector.add(new Float(f));
        float f2 = -32768.0f;
        if (this.buffer[438] != Short.MIN_VALUE) {
            f2 = (float)this.buffer[438] / 64.0f;
        }
        if (f2 == 0.0f || f2 == -777.0f) {
            f2 = -32768.0f;
        }
        vector.add(new Float(f2));
        float f3 = (float)this.buffer[440] / 1.0f;
        if (f3 == 0.0f || f3 == -777.0f) {
            f3 = -32768.0f;
        }
        vector.add(new Float(f3));
        boolean bl = false;
        if (this.buffer[445] > 0) {
            bl = true;
        }
        vector.add(new Boolean(bl));
        return vector;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLevelDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
            Vector vector4 = this.buildBrightnessTemperatureTable();
            for (int i = 0; i < vector4.size(); ++i) {
                vector.add((JLabel)vector4.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Serializable serializable;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        String[][] stringArray = this.getDataStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            serializable = new Vector<String>(2);
            ((Vector)serializable).add(stringArray[i][0]);
            ((Vector)serializable).add(stringArray[i][1]);
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        serializable = new JPanel();
        ((JComponent)serializable).setBackground(Color.white);
        ((Container)serializable).setLayout(new FlowLayout(0));
        ((Container)serializable).add(jTable);
        vector.add(serializable);
        return vector;
    }

    private String[][] getDataStrings() {
        int n;
        float f;
        int n2;
        int n3;
        String[][] stringArray = new String[131][2];
        for (n3 = 0; n3 < 131; ++n3) {
            stringArray[n3][0] = " ";
            stringArray[n3][1] = "not available";
        }
        n3 = 0;
        stringArray[n3][0] = "Quality Flag";
        stringArray[n3][1] = "not available";
        stringArray[++n3][0] = "";
        stringArray[n3][1] = "";
        stringArray[++n3][0] = "Satellite Number";
        if (this.buffer[1] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[1];
        }
        stringArray[++n3][0] = "Data Frame";
        if (this.buffer[2] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[2];
        }
        stringArray[++n3][0] = "Retrieval Grid Point";
        if (this.buffer[22] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[22];
        }
        stringArray[++n3][0] = "Beginning/Ending Orbit";
        if (this.buffer[2] != Short.MIN_VALUE && this.buffer[4] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[3] + " / " + this.buffer[4];
        }
        stringArray[++n3][0] = "Retrieval Date";
        stringArray[n3][1] = this.getDateString();
        stringArray[++n3][0] = "Retrieval Time";
        stringArray[n3][1] = this.getTimeString();
        stringArray[++n3][0] = "Latitude/Longitude";
        if (this.buffer[23] != Short.MIN_VALUE && this.buffer[24] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[23] / 128.0f) + " / " + EdgeUtils.twoDigits((float)this.buffer[24] / 128.0f);
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "Surface Elevation";
        if (this.buffer[10] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[10] + " m";
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "Spot Confidence";
        if (this.buffer[21] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[21];
        }
        stringArray[++n3][0] = "Precip Flag";
        if (this.buffer[28] == 0) {
            stringArray[n3][1] = "No Precip";
        } else if (this.buffer[28] == 1) {
            stringArray[n3][1] = "Precipitating";
        }
        stringArray[++n3][0] = "Terrain Type";
        stringArray[n3][1] = this.getTerrainString();
        stringArray[++n3][0] = "Day/Night Flag";
        if (this.buffer[30] == 0) {
            stringArray[n3][1] = "Night";
        } else if (this.buffer[30] == 1) {
            stringArray[n3][1] = "Day";
        }
        stringArray[++n3][0] = "Test/Production Version Number";
        if (this.buffer[31] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[31];
        }
        stringArray[++n3][0] = "Processing Flag";
        if (this.buffer[32] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[32];
        }
        stringArray[++n3][0] = "Geographic Bin Number";
        if (this.buffer[35] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[35];
        }
        stringArray[++n3][0] = "Solar Zenith Angle";
        if (this.buffer[33] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[33] / 128.0f) + " deg";
        }
        stringArray[++n3][0] = "Satellite (local) Zenith Angle";
        if (this.buffer[34] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[34] / 128.0f) + " deg";
        }
        stringArray[++n3][0] = "Solar Azimuth Angle";
        if (this.buffer[36] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[36] / 128.0f) + " deg";
        }
        stringArray[++n3][0] = "HIRS Spot Number";
        if (this.buffer[37] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[37];
        }
        stringArray[++n3][0] = "Orbital Node";
        if (this.buffer[38] == 0) {
            stringArray[n3][1] = "Ascending";
        } else if (this.buffer[38] == 1) {
            stringArray[n3][1] = "Descending";
        }
        stringArray[++n3][0] = "Superadiabatic Flag";
        if (this.buffer[39] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[39];
        }
        stringArray[++n3][0] = "Observation Quality";
        if (this.buffer[40] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[40];
        }
        stringArray[++n3][0] = "Retrieval Flag";
        if (this.buffer[41] == 0) {
            stringArray[n3][1] = "Clear";
        } else if (this.buffer[41] == 32) {
            stringArray[n3][1] = "Cloudy";
        } else if (this.buffer[41] == 48) {
            stringArray[n3][1] = "No HIRS";
        } else if (this.buffer[41] == 16) {
            stringArray[n3][1] = "N-Star";
        }
        stringArray[++n3][0] = "Filter Test Value";
        if (this.buffer[42] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[42];
        }
        stringArray[++n3][0] = "Channel Combination Flag";
        if (this.buffer[43] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[43];
        }
        stringArray[++n3][0] = "Tropopause Temperature";
        if (this.buffer[257] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[257] / 64.0f) + " deg K";
        }
        stringArray[++n3][0] = "Tropopause Pressure";
        if (this.buffer[258] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.oneDigit((float)this.buffer[258] / 1.0f) + " mb";
        }
        stringArray[++n3][0] = "Total Precip Water";
        if (this.buffer[259] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[259] / 128.0f);
        }
        for (n2 = 0; n2 < 15; ++n2) {
            stringArray[++n3][0] = n2 == 0 ? "Layer Precip Water" : " ";
            if (this.buffer[260 + n2] == Short.MIN_VALUE) continue;
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[260 + n2] / 128.0f);
        }
        for (n2 = 0; n2 < 15; ++n2) {
            stringArray[++n3][0] = n2 == 0 ? "Layer Mean Virt Temp" : " ";
            if (this.buffer[275 + n2] == Short.MIN_VALUE) continue;
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[275 + n2] / 64.0f);
        }
        for (n2 = 0; n2 < 20; ++n2) {
            stringArray[++n3][0] = n2 == 0 ? "Layer Thicknesses" : " ";
            if (this.buffer[290 + n2] == Short.MIN_VALUE) continue;
            stringArray[n3][1] = "" + (float)this.buffer[290 + n2] / 1.0f;
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "Sea Surface Temperature";
        if (this.buffer[322] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[322] / 64.0f);
        }
        stringArray[++n3][0] = "Derived Skin Temp";
        if (this.buffer[323] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[323] / 64.0f);
        }
        stringArray[++n3][0] = "Surface Model Level";
        if (this.buffer[324] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[324];
        }
        PressureLevels pressureLevels = new PressureLevels();
        stringArray[n3][1] = stringArray[83][1] + "  (" + pressureLevels.getPressure(this.buffer[324]) + " mb)";
        stringArray[++n3][0] = "Retrieved Surface Temp";
        if (this.buffer[325] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[325] / 64.0f);
        }
        stringArray[++n3][0] = "WVapor Corr HIRS Chan 8";
        if (this.buffer[326] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[326] / 64.0f);
        }
        stringArray[++n3][0] = "Surf Temp Est HIRS Chan 8";
        if (this.buffer[327] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[327] / 64.0f);
        }
        stringArray[++n3][0] = "Surf Temp Est HIRS Chan 18";
        if (this.buffer[328] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[328] / 64.0f);
        }
        stringArray[++n3][0] = "Surf Temp Est HIRS Chan 19";
        if (this.buffer[329] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[329] / 64.0f);
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "NCEP Fcst Potential Temp";
        if (this.buffer[426] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[426] / 64.0f);
        }
        stringArray[++n3][0] = "NCEP Fcst Rel Humidity";
        if (this.buffer[427] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[427] / 256.0f);
        }
        stringArray[++n3][0] = "NCEP Fcst Surface Temp";
        if (this.buffer[428] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[428] / 64.0f);
        }
        stringArray[++n3][0] = "Adj NCEP Fcst Surf Pressure";
        if (this.buffer[429] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.oneDigit((float)this.buffer[429] / 10.0f) + " mb";
        }
        stringArray[++n3][0] = "Forecast Pressure";
        if (this.buffer[430] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.oneDigit((float)this.buffer[430] / 10.0f) + " mb";
        }
        stringArray[++n3][0] = "Pot Temp time - Fcst Time";
        if (this.buffer[431] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + (float)this.buffer[431] / 100.0f;
        }
        stringArray[++n3][0] = "Time Diff (Sat - Fcst)";
        if (this.buffer[435] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[435];
        }
        stringArray[++n3][0] = "Stability Fcst Increment";
        if (this.buffer[436] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[436];
        }
        stringArray[++n3][0] = "Stability Departure";
        if (this.buffer[432] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[432] / 512.0f);
        }
        stringArray[++n3][0] = "Lower Depature";
        if (this.buffer[433] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[433] / 512.0f);
        }
        stringArray[++n3][0] = "Upper Departure";
        if (this.buffer[434] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[434] / 512.0f);
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "Cloud Liquid Water";
        if (this.buffer[437] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[437];
        }
        stringArray[++n3][0] = "Cloud Top Temperature";
        if (this.buffer[438] != Short.MIN_VALUE) {
            f = (float)this.buffer[438] / 64.0f;
            stringArray[n3][1] = f == 0.0f ? "Clear" : (f == -777.0f ? "Missing" : "" + EdgeUtils.twoDigits(f));
        }
        stringArray[++n3][0] = "Cloud Top Pressure";
        if (this.buffer[439] != Short.MIN_VALUE) {
            stringArray[n3][1] = (float)this.buffer[439] == 1250.0f ? "Clear" : ((float)this.buffer[439] == -777.0f ? "Missing" : "" + this.buffer[439]);
        }
        stringArray[++n3][0] = "Cloud Amount";
        if (this.buffer[440] != Short.MIN_VALUE) {
            f = (float)this.buffer[440] / 100.0f;
            stringArray[n3][1] = f == 0.0f ? "Clear" : (f == -777.0f ? "Missing" : "" + EdgeUtils.twoDigits(f));
        }
        stringArray[++n3][0] = "Aerosol Amount";
        if (this.buffer[445] != Short.MIN_VALUE) {
            f = (float)this.buffer[445] / 100.0f;
            stringArray[n3][1] = f == -777.0f ? "Missing" : "" + EdgeUtils.twoDigits(f);
        }
        stringArray[++n3][0] = "Total Ozone";
        if (this.buffer[441] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[441];
        }
        stringArray[++n3][0] = "TPW (300mb to 500mb)";
        if (this.buffer[442] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[442] / 128.0f);
        }
        stringArray[++n3][0] = "TPW (500mb to 700mb)";
        if (this.buffer[443] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[443] / 128.0f);
        }
        stringArray[++n3][0] = "TPW (700mb to 1000mb)";
        if (this.buffer[444] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[444] / 128.0f);
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "Polar Redundancy Flag";
        if (this.buffer[446] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[446];
        }
        stringArray[++n3][0] = "Outgoing Longwave Radiation";
        if (this.buffer[447] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.oneDigit((float)this.buffer[447] / 10.0f);
        }
        stringArray[++n3][0] = "Layer Cooling Rate (10mb to 240mb)";
        if (this.buffer[448] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[448] / 1000.0f);
        }
        stringArray[++n3][0] = "Layer Cooling Rate (240mb to 500mb)";
        if (this.buffer[449] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[449] / 1000.0f);
        }
        stringArray[++n3][0] = "Layer Cooling Rate (500mb to 700mb)";
        if (this.buffer[450] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[450] / 1000.0f);
        }
        stringArray[++n3][0] = "Layer Cooling Rate (700mb to 1000mb)";
        if (this.buffer[451] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + EdgeUtils.twoDigits((float)this.buffer[451] / 1000.0f);
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "Cloud Comparison Flag";
        if (this.buffer[452] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[452];
        }
        stringArray[++n3][0] = "Library Search Closeness (pho)";
        if (this.buffer[453] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[453];
        }
        stringArray[++n3][0] = "Superadiabatic Level";
        if (this.buffer[454] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[454];
        }
        stringArray[++n3][0] = "HIRS/AMSU-A Gross Temp Flag";
        if (this.buffer[455] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[455];
        }
        stringArray[++n3][0] = "Channel Avail Flags (HIRS 1-16)";
        if (this.buffer[456] != Short.MIN_VALUE) {
            String string = Integer.toBinaryString(this.buffer[456]);
            for (n = string.length(); n < 32; ++n) {
                string = "0" + string;
            }
            stringArray[n3][1] = string.substring(16);
        }
        stringArray[++n3][0] = "Chan Avail Flags (H17-20, A1-12)";
        if (this.buffer[457] != Short.MIN_VALUE) {
            String string = Integer.toBinaryString(this.buffer[457]);
            for (n = string.length(); n < 32; ++n) {
                string = "0" + string;
            }
            stringArray[n3][1] = string.substring(16);
        }
        stringArray[++n3][0] = "Chan Avail Flags (A13-15, B1-5)";
        if (this.buffer[458] != Short.MIN_VALUE) {
            String string = Integer.toBinaryString(this.buffer[458]);
            for (n = string.length(); n < 32; ++n) {
                string = "0" + string;
            }
            stringArray[n3][1] = string.substring(16);
        }
        stringArray[++n3][0] = " ";
        stringArray[n3][1] = " ";
        stringArray[++n3][0] = "Collocated AMSU-B Spot Number";
        if (this.buffer[459] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[459];
        }
        stringArray[++n3][0] = "Ozone Quality Flag";
        if (this.buffer[470] != Short.MIN_VALUE) {
            stringArray[n3][1] = "" + this.buffer[470];
        }
        return stringArray;
    }

    public Vector buildLevelDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Pressure");
        vector2.add("Atmospheric\nTemperature");
        vector2.add("1st Guess\nTemperature");
        vector2.add("Water Vapor\nMixing Ratio");
        vector2.add("1st Guess\nWVMR");
        vector2.add("Geopotential\nHeight");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        PressureLevels pressureLevels = new PressureLevels();
        for (int i = 0; i < 42; ++i) {
            serializable = new Vector<String>(6);
            ((Vector)serializable).add("" + EdgeUtils.twoDigits(pressureLevels.getPressure(i + 1)));
            if (this.buffer[330 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[330 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[44 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[44 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i >= 23 && this.buffer[215 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[215 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (i >= 23 && this.buffer[349 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[349 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[196 + i] != Short.MIN_VALUE) {
                if (i < 20) {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[196 + i] / 1.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[196 + i] / 10.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }

    public Vector buildBrightnessTemperatureTable() {
        Serializable serializable;
        Vector<String> vector;
        Vector<JComponent> vector2 = new Vector<JComponent>();
        vector2.add(new JLabel(" "));
        vector2.add(new JLabel("<html><font size=+1><bold>Brightness Temperatures</bold></font></html>"));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("Level");
        vector3.add("Limb Corr\nBTemp");
        vector3.add("Non-Limb Corr\nBTemp");
        vector3.add("1st Guess\nBTemp");
        String[] stringArray = new String[]{"HIRS 1", "HIRS 2", "HIRS 3", "HIRS 4", "HIRS 5", "HIRS 6", "HIRS 7", "HIRS 8", "HIRS 9", "HIRS 10", "HIRS 11", "HIRS 12", "HIRS 13", "HIRS 14", "HIRS 15", "HIRS 16", "HIRS 17", "HIRS 18", "HIRS 19", "HIRS 20", "AMSU-A 1", "AMSU-A 2", "AMSU-A 3", "AMSU-A 4", "AMSU-A 5", "AMSU-A 6", "AMSU-A 7", "AMSU-A 8", "AMSU-A 9", "AMSU-A 10", "AMSU-A 11", "AMSU-A 12", "AMSU-A 13", "AMSU-A 14", "AMSU-A 15"};
        float[] fArray = this.getRetrievedBTemps();
        float[] fArray2 = this.getNonLimbCorrectedTemps();
        float[] fArray3 = this.getRetrievedGuessBTemps();
        Vector<Serializable> vector4 = new Vector<Serializable>();
        for (int i = 0; i < 35; ++i) {
            vector = new Vector<String>(4);
            vector.add(stringArray[i]);
            if (fArray[i] != -999.99f) {
                vector.add("" + EdgeUtils.twoDigits(fArray[i]));
            } else {
                vector.add(" ");
            }
            if (fArray2[i] != -999.99f) {
                vector.add("" + EdgeUtils.twoDigits(fArray2[i]));
            } else {
                vector.add(" ");
            }
            if (fArray3[i] != -999.99f) {
                vector.add("" + EdgeUtils.twoDigits(fArray3[i]));
            } else {
                vector.add(" ");
            }
            vector4.add(vector);
            if (i != 19 && i != 34) continue;
            vector = new Vector<String>(4);
            vector.add(" ");
            vector.add(" ");
            vector.add(" ");
            vector.add(" ");
            vector4.add(vector);
        }
        float[] fArray4 = this.getLimbCorrectedAmsuB();
        vector = (Vector<String>)this.getNonLimbCorrectedAmsuB();
        float[] fArray5 = this.getGuessAmsuB();
        String[] stringArray2 = new String[]{"MHS 1", "MHS 2", "MHS 3", "MHS 4", "MHS 5"};
        for (int i = 0; i < 5; ++i) {
            serializable = new Vector<String>(4);
            ((Vector)serializable).add(stringArray2[i]);
            if (fArray4[i] != -999.99f) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits(fArray4[i]));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (vector[i] != -999.99f) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits(vector[i]));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (fArray5[i] != -999.99f) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits(fArray5[i]));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector4.add(serializable);
        }
        JTable jTable = new JTable(vector4, vector3);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector2.add(jPanel2);
        return vector2;
    }
}

