/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class AutoVstat {
    private String output_file_name;
    private String input_file_name;
    private String image_type;
    private int image_width;
    private int image_height;
    private int global_start_date;
    private int global_end_date;
    private int header_length;
    private int num_data_groups;
    private int num_records;
    private String[] data_group_name;
    private int[] data_group_type;
    private int[] data_group_length;
    private int start_date;
    private int end_date;
    private int data_type;
    private int num_levels;
    private boolean show_bias;
    private boolean show_stddev;
    private boolean show_rms;
    private float top_pressure;
    private float bottom_pressure;
    private int min_max_option;
    private float data_min;
    private float data_max;
    private int line_thickness;
    private boolean show_data_points;
    private boolean draw_gridlines;
    private String baseline_name;
    private int baseline_group;
    private int baseline_subgroup;
    private String[] profile_names;
    private int[] profile_group_numbers;
    private int[] profile_subgroup_types;
    private int[] profile_reds;
    private int[] profile_greens;
    private int[] profile_blues;
    private float version = 1.0f;
    private String version_date = "July 3, 2010";
    private final int TEMPERATURE = 0;
    private final int WATER_VAPOR = 1;
    private final int VIRTUAL_TEMP = 2;
    private final int LEVELS_42_19 = 0;
    private final int LEVELS_100_46 = 1;

    public static void main(String[] stringArray) {
        AutoVstat autoVstat = new AutoVstat(stringArray);
        System.exit(0);
    }

    public AutoVstat(String[] stringArray) {
        System.out.println("====================================================================");
        System.out.print("Starting AutoVstat " + this.version + " at ");
        this.printTime();
        System.out.println("");
        if (stringArray.length == 2) {
            this.readGlobalDateRange(stringArray);
        }
        try {
            XMLParser xMLParser = new XMLParser();
            XMLTree xMLTree = xMLParser.parseFile("parameter.file");
            if (xMLTree != null) {
                Object object = xMLTree.getValue();
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    for (int i = 0; i < vector.size(); ++i) {
                        object = vector.elementAt(i);
                        this.processImage(object);
                    }
                } else {
                    System.out.println("\nThe input parameter file could not be parsed.");
                    System.out.println("The structure of the XML data is probably not correct.");
                    System.out.println("Please check the file and try again.\n");
                    System.exit(1);
                }
            } else {
                System.out.println("\nThe input parameter file could not be parsed.");
                System.out.println("The structure of the XML data is probably not correct.");
                System.out.println("Please check the file and try again.\n");
                System.exit(1);
            }
        }
        catch (XMLParserException xMLParserException) {
            System.out.println("\nThe input parameter file could not be parsed.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("Please check the file and try again.\n");
            System.exit(1);
        }
        System.out.print("\nEnding AutoVstat at ");
        this.printTime();
        System.out.println("\n");
    }

    private void readGlobalDateRange(String[] stringArray) {
        this.global_start_date = 0;
        this.global_end_date = 0;
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            this.global_start_date = n;
            this.global_end_date = n2;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processImage(Object object) {
        if (object instanceof XMLTree) {
            Object object2;
            XMLTree xMLTree = (XMLTree)object;
            Object object3 = xMLTree.getValue("show_file_info");
            if (object3 != null && object3 instanceof String && ((String)(object2 = (String)object3)).equals("yes")) {
                object3 = xMLTree.getValue("input_file_name");
                if (object3 != null && object3 instanceof String) {
                    this.input_file_name = (String)object3;
                    this.readFileHeader(true);
                } else {
                    System.out.println("The show_file_info flag is set to yes but the input file name");
                    System.out.println("could not be read from the parameter.  Please check the parameter");
                    System.out.println("file and make sure the the input_file_name tag is included.\n\n");
                }
                System.exit(0);
            }
            this.initializeImageParameters();
            this.processImageParameters(xMLTree);
            if (this.input_file_name != null && this.output_file_name != null) {
                int n;
                this.readFileHeader(false);
                object2 = new EdgeGlobals();
                Color[][][] colorArray = ((EdgeGlobals)object2).getProfileColors();
                Color[] colorArray2 = new Color[this.profile_names.length];
                int[] nArray = new int[this.profile_names.length];
                Arrays.fill(nArray, 0);
                for (n = 0; n < this.profile_names.length; ++n) {
                    if (this.profile_reds[n] != Short.MIN_VALUE && this.profile_greens[n] != Short.MIN_VALUE && this.profile_blues[n] != Short.MIN_VALUE) {
                        colorArray2[n] = new Color(this.profile_reds[n], this.profile_greens[n], this.profile_blues[n]);
                        continue;
                    }
                    int n2 = this.profile_group_numbers[n];
                    colorArray2[n] = colorArray[n2][nArray[n]][0];
                    int n3 = n;
                    nArray[n3] = nArray[n3] + 1;
                }
                for (n = 0; n < this.profile_names.length; ++n) {
                    if (this.profile_names[n] != null) continue;
                    this.profile_names[n] = this.data_group_name[this.profile_group_numbers[n]] + " " + this.getProfileTypeString(n);
                }
                BufferedImage bufferedImage = new BufferedImage(this.image_width, this.image_height, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                int n4 = (int)((float)this.image_height * 0.05f);
                int n5 = this.image_height - n4;
                this.drawTitle(graphics2D, 0, 0, this.image_width, n4);
                AutoVstatGenerator autoVstatGenerator = new AutoVstatGenerator();
                VstatStatSet vstatStatSet = autoVstatGenerator.computeStats(this.input_file_name, this.header_length, this.num_data_groups, this.num_records, this.data_group_type, this.data_group_length, this.start_date, this.end_date, this.data_type, this.num_levels, this.baseline_name, this.baseline_group, this.baseline_subgroup, this.profile_names, this.profile_group_numbers, this.profile_subgroup_types);
                if (vstatStatSet != null) {
                    AutoVstatGraph autoVstatGraph = new AutoVstatGraph(vstatStatSet, this.top_pressure, this.bottom_pressure, this.min_max_option, this.data_min, this.data_max, this.show_bias, this.show_stddev, this.show_rms, this.line_thickness, this.show_data_points, this.draw_gridlines, this.profile_names, colorArray2);
                    autoVstatGraph.drawImage(graphics2D, 0, n4, this.image_width, n5);
                } else {
                    System.out.println("*** An error occurred while generating the statistics.\n");
                    System.out.println("    AutoVstatGenerator returned a VstatStatSet that was set to null.");
                    System.out.println("    This means that there was a problem when creating the stats. So it");
                    System.out.println("    will be necessary to track down the problem before an image can be");
                    System.out.println("    created.\n\n");
                }
                this.saveImage(bufferedImage);
                System.out.println("Image saved:  " + this.output_file_name);
            } else {
                if (this.input_file_name == null) {
                    System.out.println("\nThe input file name was not included in the paramter XML file.");
                    System.out.println("This image will be skipped.\n");
                }
                if (this.output_file_name == null) {
                    System.out.println("\nThe output file name was not included in the paramter XML file.");
                    System.out.println("This image will be skipped.\n");
                }
            }
        } else {
            System.out.println("\nThere was a problem trying to create an image.");
            System.out.println("The structure of the XML data is probably not correct.");
            System.out.println("This image will be skipped.\n");
        }
    }

    private void readFileHeader(boolean bl) {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.input_file_name));
            if (this.input_file_name.endsWith(".gz")) {
                dataInputStream = new DataInputStream(new GZIPInputStream(new FileInputStream(this.input_file_name)));
            }
            int n2 = dataInputStream.readInt();
            float f = (float)dataInputStream.readInt() / 10.0f;
            this.header_length = dataInputStream.readInt();
            this.num_data_groups = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            n3 = dataInputStream.readInt();
            this.num_records = dataInputStream.readInt();
            if (bl) {
                System.out.println("File Name:          " + this.input_file_name + "\n");
                System.out.println("File Type:          " + n2);
                System.out.println("File Version:       " + f);
                System.out.println("Header Length:      " + this.header_length);
                System.out.println("Num Data Groups:    " + this.num_data_groups);
                System.out.println("Num Records:        " + this.num_records + "\n");
            }
            for (n = 0; n < 68; ++n) {
                n3 = dataInputStream.readInt();
            }
            this.data_group_type = new int[this.num_data_groups];
            this.data_group_length = new int[this.num_data_groups];
            this.data_group_name = new String[this.num_data_groups];
            for (n = 0; n < this.num_data_groups; ++n) {
                this.data_group_type[n] = dataInputStream.readInt();
                this.data_group_name[n] = "";
                for (int i = 0; i < 36; ++i) {
                    int n4 = dataInputStream.readInt();
                    if (n4 == Short.MIN_VALUE) continue;
                    int n5 = n;
                    this.data_group_name[n5] = this.data_group_name[n5] + (char)n4;
                }
                this.data_group_name[n] = this.data_group_name[n].trim();
                this.data_group_length[n] = dataInputStream.readInt();
                if (!bl) continue;
                System.out.println("Data Group " + n);
                System.out.println("  Group Type:    " + this.data_group_type[n]);
                System.out.println("  Group Length:  " + this.data_group_length[n]);
                System.out.println("  Group Name:    " + this.data_group_name[n] + "\n");
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public void drawTitle(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(n, n2, n3, n4);
        String string = "NOAA/NESDIS/STAR NPROVS Vertical Accuracy Statistics";
        int n5 = n4;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = 25;
        boolean bl = false;
        while (!bl && n6 > 5) {
            graphics2D.setFont(new Font("Serif", 0, --n6));
            fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.getHeight() >= n4 || fontMetrics.stringWidth(string) >= n3 - n5 * 2) continue;
            bl = true;
        }
        int n7 = n + (n3 / 2 - fontMetrics.stringWidth(string) / 2);
        int n8 = n2 + fontMetrics.getHeight();
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n7, n8);
        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/faded_noaa.gif")));
        JPanel jPanel = new JPanel();
        graphics2D.drawImage(imageIcon.getImage(), n, n2, n5, n5, jPanel);
    }

    private void saveImage(BufferedImage bufferedImage) {
        try {
            File file = new File(this.output_file_name);
            ImageIO.write((RenderedImage)bufferedImage, this.image_type, file);
        }
        catch (Exception exception) {
            System.out.println("Could not save the image: " + this.output_file_name);
        }
    }

    private void initializeImageParameters() {
        this.output_file_name = null;
        this.image_type = "png";
        this.image_width = 800;
        this.image_height = 600;
        this.input_file_name = null;
        this.start_date = Short.MIN_VALUE;
        this.end_date = Short.MIN_VALUE;
        this.data_type = 0;
        this.num_levels = 0;
        this.show_bias = true;
        this.show_stddev = true;
        this.show_rms = false;
        this.top_pressure = -32768.0f;
        this.bottom_pressure = -32768.0f;
        this.min_max_option = 1;
        this.data_min = -1.0f;
        this.data_max = 4.5f;
        this.line_thickness = 0;
        this.show_data_points = false;
        this.draw_gridlines = false;
        this.baseline_name = "Baseline";
        this.baseline_group = 0;
        this.baseline_subgroup = 0;
        this.profile_names = new String[1];
        this.profile_group_numbers = new int[1];
        this.profile_subgroup_types = new int[1];
        this.profile_reds = new int[1];
        this.profile_greens = new int[1];
        this.profile_blues = new int[1];
        this.profile_names[0] = null;
        this.profile_group_numbers[0] = 1;
        this.profile_subgroup_types[0] = 0;
        this.profile_reds[0] = Short.MIN_VALUE;
        this.profile_greens[0] = Short.MIN_VALUE;
        this.profile_blues[0] = Short.MIN_VALUE;
    }

    private void processImageParameters(XMLTree xMLTree) {
        Object object;
        Object object2 = xMLTree.getValue("output_file_name");
        if (object2 != null && object2 instanceof String) {
            this.output_file_name = (String)object2;
        }
        if ((object2 = xMLTree.getValue("file_type")) != null && object2 instanceof String) {
            this.image_type = (String)object2;
        }
        if ((object2 = xMLTree.getValue("image_height")) != null && object2 instanceof String) {
            this.image_height = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("image_width")) != null && object2 instanceof String) {
            this.image_width = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("input_file_name")) != null && object2 instanceof String) {
            this.input_file_name = (String)object2;
        }
        if ((object2 = xMLTree.getValue("start_date")) != null && object2 instanceof String) {
            this.start_date = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("end_date")) != null && object2 instanceof String) {
            this.end_date = Integer.parseInt((String)object2);
        }
        if (this.global_start_date != 0 && this.global_end_date != 0) {
            this.start_date = this.global_start_date;
            this.end_date = this.global_end_date;
        }
        if ((object2 = xMLTree.getValue("data_type")) != null && object2 instanceof String && ((String)(object = (String)object2)).equals("water vapor")) {
            this.data_type = 1;
        }
        if ((object2 = xMLTree.getValue("data_type")) != null && object2 instanceof String && ((String)(object = (String)object2)).equals("water vapor")) {
            this.data_type = 1;
        }
        if ((object2 = xMLTree.getValue("num_levels")) != null && object2 instanceof String && ((String)(object = (String)object2)).equals("100/46")) {
            this.num_levels = 1;
        }
        if ((object2 = xMLTree.getValue("show_bias")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_bias = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_stddev")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_stddev = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("show_rms")) != null && object2 instanceof String) {
            object = (String)object2;
            this.show_rms = ((String)object).equals("yes") || ((String)object).equals("true");
        }
        if ((object2 = xMLTree.getValue("top_pressure")) != null && object2 instanceof String) {
            this.top_pressure = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("bottom_pressure")) != null && object2 instanceof String) {
            this.bottom_pressure = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("min_max_option")) != null && object2 instanceof String) {
            this.min_max_option = Integer.parseInt((String)object2);
            if (this.min_max_option < 0 || this.min_max_option > 2) {
                this.min_max_option = 1;
            }
        }
        if ((object2 = xMLTree.getValue("data_min")) != null && object2 instanceof String) {
            this.data_min = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("data_max")) != null && object2 instanceof String) {
            this.data_max = Float.parseFloat((String)object2);
        }
        if ((object2 = xMLTree.getValue("line_thickness")) != null && object2 instanceof String) {
            this.line_thickness = Integer.parseInt((String)object2);
            this.line_thickness = Math.max(this.line_thickness, 0);
        }
        if ((object2 = xMLTree.getValue("show_data_points")) != null && object2 instanceof String && (((String)(object = (String)object2)).equals("yes") || ((String)object).equals("true"))) {
            this.show_data_points = true;
        }
        if ((object2 = xMLTree.getValue("draw_gridlines")) != null && object2 instanceof String && (((String)(object = (String)object2)).equals("yes") || ((String)object).equals("true"))) {
            this.draw_gridlines = true;
        }
        if ((object2 = xMLTree.getValue("baseline_name")) != null && object2 instanceof String) {
            this.baseline_name = (String)object2;
        }
        if ((object2 = xMLTree.getValue("baseline_group")) != null && object2 instanceof String) {
            this.baseline_group = Integer.parseInt((String)object2);
        }
        if ((object2 = xMLTree.getValue("baseline_subgroup")) != null && object2 instanceof String) {
            object = (String)object2;
            if (((String)object).equals("first guess")) {
                this.baseline_subgroup = 1;
            } else if (((String)object).equals("forecast")) {
                this.baseline_subgroup = 2;
            } else if (((String)object).equals("analysis")) {
                this.baseline_subgroup = 3;
            }
        }
        if ((object2 = xMLTree.getValue("profiles")) != null && object2 instanceof Vector) {
            object = (Vector)object2;
            this.profile_names = new String[((Vector)object).size()];
            this.profile_group_numbers = new int[((Vector)object).size()];
            this.profile_subgroup_types = new int[((Vector)object).size()];
            this.profile_reds = new int[((Vector)object).size()];
            this.profile_greens = new int[((Vector)object).size()];
            this.profile_blues = new int[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.profile_names[i] = null;
                this.profile_group_numbers[i] = 1;
                this.profile_subgroup_types[i] = 0;
                this.profile_reds[i] = Short.MIN_VALUE;
                this.profile_greens[i] = Short.MIN_VALUE;
                this.profile_blues[i] = Short.MIN_VALUE;
                object2 = ((Vector)object).elementAt(i);
                if (!(object2 instanceof XMLTree)) continue;
                XMLTree xMLTree2 = (XMLTree)object2;
                if ((object2 = xMLTree2.getValue("name")) != null && object2 instanceof String) {
                    this.profile_names[i] = (String)object2;
                }
                if ((object2 = xMLTree2.getValue("group_number")) != null && object2 instanceof String) {
                    this.profile_group_numbers[i] = Integer.parseInt((String)object2);
                }
                if ((object2 = xMLTree2.getValue("subgroup_type")) != null && object2 instanceof String) {
                    String string = (String)object2;
                    if (string.equals("first guess")) {
                        this.profile_subgroup_types[i] = 1;
                    } else if (string.equals("forecast")) {
                        this.profile_subgroup_types[i] = 2;
                    } else if (string.equals("analysis")) {
                        this.profile_subgroup_types[i] = 3;
                    }
                }
                if ((object2 = xMLTree2.getValue("red")) != null && object2 instanceof String) {
                    this.profile_reds[i] = Integer.parseInt((String)object2);
                    if (this.profile_reds[i] < 0 || this.profile_reds[i] > 255) {
                        this.profile_reds[i] = Short.MIN_VALUE;
                    }
                }
                if ((object2 = xMLTree2.getValue("green")) != null && object2 instanceof String) {
                    this.profile_greens[i] = Integer.parseInt((String)object2);
                    if (this.profile_greens[i] < 0 || this.profile_greens[i] > 255) {
                        this.profile_greens[i] = Short.MIN_VALUE;
                    }
                }
                if ((object2 = xMLTree2.getValue("blue")) == null || !(object2 instanceof String)) continue;
                this.profile_blues[i] = Integer.parseInt((String)object2);
                if (this.profile_blues[i] >= 0 && this.profile_blues[i] <= 255) continue;
                this.profile_blues[i] = Short.MIN_VALUE;
            }
        }
    }

    private String getProfileTypeString(int n) {
        String string = "";
        switch (this.profile_subgroup_types[n]) {
            case 0: {
                string = "Retrieval";
                break;
            }
            case 1: {
                string = "First Guess";
                break;
            }
            case 2: {
                string = "Forecast";
                break;
            }
            case 3: {
                string = "Analysis";
                break;
            }
            case 10: {
                string = "Std Observed";
                break;
            }
            case 11: {
                string = "Std Radcor";
                break;
            }
            case 15: {
                string = "Sig Observed";
                break;
            }
            case 16: {
                string = "Sig Radcor";
                break;
            }
            case 20: {
                string = "MIT";
                break;
            }
            case 21: {
                string = "Raw Dry";
                break;
            }
            case 22: {
                string = "MW Only";
            }
        }
        return string;
    }

    private void printTime() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(10);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        String string = "" + n + ":";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + ":";
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + n3 + "\t";
        System.out.println(string);
    }
}

