/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class AutoVstatGenerator {
    private boolean process_rtemp = true;
    private boolean process_wvap = true;
    private String input_file_name;
    private int header_length;
    private int num_data_groups;
    private int num_records;
    private int[] data_group_type;
    private int[] data_group_length;
    private int start_date;
    private int end_date;
    private int data_type;
    private int num_level_option;
    private String baseline_name;
    private int baseline_group;
    private int baseline_subgroup;
    private String[] profile_names;
    private int[] profile_group_numbers;
    private int[] profile_subgroup_types;
    private int num_used_profiles;
    private int num_temp_levels;
    private int num_wvap_levels;
    private float[] temp_pressures_to_use;
    private float[] wvap_pressures_to_use;
    private float[] baseline_pressures;
    private float[] baseline_temperatures;
    private float[] baseline_moistures;
    private float[][] pressures;
    private float[][] temperatures;
    private float[][] moistures;
    private int[] rtemp_count;
    private float[] rtemp_baseline_sum;
    private float[][] rtemp_sum;
    private float[][] rtemp_diff;
    private float[][] rtemp_diffsq;
    private float[][] rtemp_min;
    private float[][] rtemp_max;
    private int[][] rtemp_min_rec;
    private int[][] rtemp_max_rec;
    private int[] wvap_count;
    private float[] wvap_baseline_sum;
    private float[][] wvap_sum;
    private float[][] wvap_diff;
    private float[][] wvap_diffsq;
    private float[][] wvap_min;
    private float[][] wvap_max;
    private int[][] wvap_min_rec;
    private int[][] wvap_max_rec;
    private boolean[] use_profile;
    private int[] profile_indices;
    private boolean[] do_data_type;
    private int top_pressure_option;
    private int[] used_profile_list;
    private VstatStatSet stat_set;
    private RandomAccessFile in;
    private boolean file_read_correctly;
    private boolean save_to_file;
    private String output_file_name;
    private final int TEMPERATURE = 0;
    private final int WATER_VAPOR = 1;
    private final int VIRTUAL_TEMP = 2;
    private final int LEVELS_42_19 = 0;
    private final int LEVELS_100_46 = 1;

    public VstatStatSet computeStats(String string, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String[] stringArray, int[] nArray3, int[] nArray4) {
        this.stat_set = null;
        this.input_file_name = string;
        this.header_length = n;
        this.num_data_groups = n2;
        this.num_records = n3;
        this.data_group_type = nArray;
        this.data_group_length = nArray2;
        this.start_date = n4;
        this.end_date = n5;
        this.data_type = n6;
        this.num_level_option = n7;
        this.baseline_name = string2;
        this.baseline_group = n8;
        this.baseline_subgroup = n9;
        this.profile_names = stringArray;
        this.profile_group_numbers = nArray3;
        this.profile_subgroup_types = nArray4;
        this.process_rtemp = false;
        this.process_wvap = false;
        if (n6 == 0) {
            this.process_rtemp = true;
        } else if (n6 == 1) {
            this.process_wvap = true;
        }
        this.num_used_profiles = nArray3.length;
        this.doStats();
        return this.stat_set;
    }

    private void doStats() {
        this.initializeVariables();
        this.computeRunningSums();
        if (this.file_read_correctly) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                this.writeStatSetBlock(dataOutputStream);
                if (this.process_rtemp) {
                    this.writeTemperatureStats(dataOutputStream);
                }
                if (this.process_wvap) {
                    this.writeWaterVaporStats(dataOutputStream);
                }
                dataOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.stat_set = new VstatStatSet(byArray);
            }
            catch (IOException iOException) {
                this.stat_set = null;
                iOException.printStackTrace();
            }
        } else {
            this.stat_set = null;
        }
    }

    private void initializeVariables() {
        PressureLevels pressureLevels;
        if (this.num_level_option == 0) {
            pressureLevels = new PressureLevels();
            this.temp_pressures_to_use = pressureLevels.getNewAtovsTempPressures();
            this.wvap_pressures_to_use = pressureLevels.getNewAtovsMoisturePressures();
        } else {
            pressureLevels = new PressureLevels();
            this.temp_pressures_to_use = pressureLevels.getMirsTempPressures();
            this.wvap_pressures_to_use = pressureLevels.getMirsMoisturePressures();
        }
        this.num_temp_levels = this.temp_pressures_to_use.length;
        this.num_wvap_levels = this.wvap_pressures_to_use.length;
        if (this.process_rtemp) {
            this.rtemp_count = new int[this.num_temp_levels];
            this.rtemp_baseline_sum = new float[this.num_temp_levels];
            this.rtemp_sum = new float[this.num_used_profiles][this.num_temp_levels];
            this.rtemp_diff = new float[this.num_used_profiles][this.num_temp_levels];
            this.rtemp_diffsq = new float[this.num_used_profiles][this.num_temp_levels];
            this.rtemp_min = new float[this.num_used_profiles][this.num_temp_levels];
            this.rtemp_max = new float[this.num_used_profiles][this.num_temp_levels];
            this.rtemp_min_rec = new int[this.num_used_profiles][this.num_temp_levels];
            this.rtemp_max_rec = new int[this.num_used_profiles][this.num_temp_levels];
            Arrays.fill(this.rtemp_count, 0);
        }
        if (this.process_wvap) {
            this.wvap_count = new int[this.num_wvap_levels];
            this.wvap_baseline_sum = new float[this.num_wvap_levels];
            this.wvap_sum = new float[this.num_used_profiles][this.num_wvap_levels];
            this.wvap_diff = new float[this.num_used_profiles][this.num_wvap_levels];
            this.wvap_diffsq = new float[this.num_used_profiles][this.num_wvap_levels];
            this.wvap_min = new float[this.num_used_profiles][this.num_wvap_levels];
            this.wvap_max = new float[this.num_used_profiles][this.num_wvap_levels];
            this.wvap_min_rec = new int[this.num_used_profiles][this.num_wvap_levels];
            this.wvap_max_rec = new int[this.num_used_profiles][this.num_wvap_levels];
            Arrays.fill(this.wvap_count, 0);
        }
        for (int i = 0; i < this.num_used_profiles; ++i) {
            int n;
            if (this.process_rtemp) {
                for (n = 0; n < this.num_temp_levels; ++n) {
                    this.rtemp_baseline_sum[n] = 0.0f;
                    this.rtemp_sum[i][n] = 0.0f;
                    this.rtemp_diff[i][n] = 0.0f;
                    this.rtemp_diffsq[i][n] = 0.0f;
                    this.rtemp_min[i][n] = 0.0f;
                    this.rtemp_max[i][n] = 0.0f;
                    this.rtemp_min_rec[i][n] = Short.MIN_VALUE;
                    this.rtemp_max_rec[i][n] = Short.MIN_VALUE;
                }
            }
            if (!this.process_wvap) continue;
            for (n = 0; n < this.num_wvap_levels; ++n) {
                this.wvap_baseline_sum[n] = 0.0f;
                this.wvap_sum[i][n] = 0.0f;
                this.wvap_diff[i][n] = 0.0f;
                this.wvap_diffsq[i][n] = 0.0f;
                this.wvap_min[i][n] = 0.0f;
                this.wvap_max[i][n] = 0.0f;
                this.wvap_min_rec[i][n] = Short.MIN_VALUE;
                this.wvap_max_rec[i][n] = Short.MIN_VALUE;
            }
        }
    }

    private void computeRunningSums() {
        try {
            int n = 0;
            for (int i = 0; i < this.num_data_groups; ++i) {
                n += this.data_group_length[i];
            }
            String[] stringArray = new String[this.num_data_groups];
            for (int i = 0; i < this.num_data_groups; ++i) {
                stringArray[i] = "";
            }
            Matchup matchup = new Matchup(this.num_data_groups, this.data_group_length, this.data_group_type, stringArray);
            int n2 = this.num_temp_levels;
            if (this.process_wvap) {
                n2 = this.num_wvap_levels;
            }
            byte[] byArray = new byte[n];
            short[] sArray = new short[n / 2];
            this.baseline_pressures = new float[n2];
            this.baseline_temperatures = new float[n2];
            this.baseline_moistures = new float[n2];
            this.pressures = new float[this.num_used_profiles][n2];
            this.temperatures = new float[this.num_used_profiles][n2];
            this.moistures = new float[this.num_used_profiles][n2];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.input_file_name));
            if (this.input_file_name.endsWith(".gz")) {
                dataInputStream = new DataInputStream(new GZIPInputStream(new FileInputStream(this.input_file_name)));
            }
            dataInputStream.skipBytes(this.header_length);
            this.file_read_correctly = true;
            float f = -999.99f;
            for (int i = 1; i < this.num_records; ++i) {
                Object[] objectArray;
                int n3;
                int n4;
                int n5;
                for (n5 = 0; n5 < n2; ++n5) {
                    this.baseline_pressures[n5] = -999.99f;
                    this.baseline_temperatures[n5] = -999.99f;
                    this.baseline_moistures[n5] = -999.99f;
                }
                for (n5 = 0; n5 < this.num_used_profiles; ++n5) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        this.pressures[n5][n4] = -999.99f;
                        this.temperatures[n5][n4] = -999.99f;
                        this.moistures[n5][n4] = -999.99f;
                    }
                }
                dataInputStream.readFully(byArray);
                DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
                for (n4 = 0; n4 < n / 2; ++n4) {
                    sArray[n4] = dataInputStream2.readShort();
                }
                matchup.addDataBuffer(sArray);
                DataGroup dataGroup = matchup.getDataGroup(this.baseline_group);
                if (dataGroup.getQCFlag()) {
                    int n6;
                    float[] fArray;
                    Vector[] vectorArray = dataGroup.getDataForVstats(this.top_pressure_option);
                    f = dataGroup.getSurfacePressure();
                    int[] nArray = dataGroup.getProfileTypes();
                    n3 = 0;
                    for (int j = 0; j < nArray.length; ++j) {
                        if (this.baseline_subgroup != nArray[j]) continue;
                        n3 = j;
                    }
                    if (this.process_rtemp) {
                        float[] fArray2 = (float[])vectorArray[n3].elementAt(0);
                        objectArray = (float[])vectorArray[n3].elementAt(1);
                        fArray = this.interpolateTemperatures(fArray2, (float[])objectArray);
                        for (n6 = 0; n6 < this.temp_pressures_to_use.length; ++n6) {
                            this.baseline_temperatures[n6] = fArray[n6];
                        }
                    }
                    if (this.process_wvap) {
                        float[] fArray3 = (float[])vectorArray[n3].elementAt(2);
                        objectArray = (float[])vectorArray[n3].elementAt(3);
                        fArray = this.interpolateMoistures(fArray3, (float[])objectArray, this.baseline_group);
                        for (n6 = 0; n6 < this.wvap_pressures_to_use.length; ++n6) {
                            this.baseline_moistures[n6] = fArray[n6];
                        }
                    }
                }
                for (int j = 0; j < this.num_used_profiles; ++j) {
                    int n7;
                    float[] fArray;
                    int n8 = this.profile_group_numbers[j];
                    n3 = 0;
                    dataGroup = matchup.getDataGroup(n8);
                    if (!dataGroup.getQCFlag()) continue;
                    Vector[] vectorArray = dataGroup.getDataForVstats(this.top_pressure_option);
                    objectArray = dataGroup.getProfileTypes();
                    for (int k = 0; k < objectArray.length; ++k) {
                        if (this.profile_subgroup_types[j] != objectArray[k]) continue;
                        n3 = k;
                    }
                    if (this.process_rtemp) {
                        float[] fArray4 = (float[])vectorArray[n3].elementAt(0);
                        float[] fArray5 = (float[])vectorArray[n3].elementAt(1);
                        fArray = this.interpolateTemperatures(fArray4, fArray5);
                        for (n7 = 0; n7 < this.temp_pressures_to_use.length; ++n7) {
                            this.temperatures[j][n7] = fArray[n7];
                        }
                    }
                    if (!this.process_wvap) continue;
                    float[] fArray6 = (float[])vectorArray[n3].elementAt(2);
                    float[] fArray7 = (float[])vectorArray[n3].elementAt(3);
                    fArray = this.interpolateMoistures(fArray6, fArray7, n8);
                    for (n7 = 0; n7 < this.wvap_pressures_to_use.length; ++n7) {
                        this.moistures[j][n7] = fArray[n7];
                    }
                }
                if (this.process_rtemp) {
                    this.calculateTemperatureDiffs(i);
                }
                if (!this.process_wvap) continue;
                this.calculateWaterVaporDiffs(i);
            }
            dataInputStream.close();
            this.file_read_correctly = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.file_read_correctly = false;
        }
    }

    private void calculateTemperatureDiffs(int n) {
        for (int i = 0; i < this.temp_pressures_to_use.length; ++i) {
            int n2;
            boolean bl = true;
            if (this.baseline_temperatures[i] == -999.99f) {
                bl = false;
            }
            for (n2 = 0; n2 < this.num_used_profiles; ++n2) {
                if (this.temperatures[n2][i] != -999.99f) continue;
                bl = false;
            }
            if (!bl) continue;
            this.rtemp_count[i] = this.rtemp_count[i] + 1;
            this.rtemp_baseline_sum[i] = this.rtemp_baseline_sum[i] + this.baseline_temperatures[i];
            for (n2 = 0; n2 < this.num_used_profiles; ++n2) {
                this.rtemp_sum[n2][i] = this.rtemp_sum[n2][i] + this.temperatures[n2][i];
                float f = this.temperatures[n2][i] - this.baseline_temperatures[i];
                this.rtemp_diff[n2][i] = this.rtemp_diff[n2][i] + f;
                this.rtemp_diffsq[n2][i] = this.rtemp_diffsq[n2][i] + f * f;
                if (f < this.rtemp_min[n2][i]) {
                    this.rtemp_min[n2][i] = f;
                    this.rtemp_min_rec[n2][i] = n + 1;
                }
                if (!(f > this.rtemp_max[n2][i])) continue;
                this.rtemp_max[n2][i] = f;
                this.rtemp_max_rec[n2][i] = n + 1;
            }
        }
    }

    private void calculateWaterVaporDiffs(int n) {
        for (int i = 0; i < this.wvap_pressures_to_use.length; ++i) {
            int n2;
            boolean bl = true;
            if (this.baseline_moistures[i] == -999.99f) {
                bl = false;
            }
            for (n2 = 0; n2 < this.num_used_profiles; ++n2) {
                if (this.moistures[n2][i] != -999.99f) continue;
                bl = false;
            }
            if (!bl) continue;
            this.wvap_count[i] = this.wvap_count[i] + 1;
            this.wvap_baseline_sum[i] = this.wvap_baseline_sum[i] + this.baseline_moistures[i];
            for (n2 = 0; n2 < this.num_used_profiles; ++n2) {
                if (this.moistures[n2][i] == -999.99f) continue;
                this.wvap_sum[n2][i] = this.wvap_sum[n2][i] + this.moistures[n2][i];
                float f = this.moistures[n2][i] - this.baseline_moistures[i];
                this.wvap_diff[n2][i] = this.wvap_diff[n2][i] + f;
                this.wvap_diffsq[n2][i] = this.wvap_diffsq[n2][i] + f * f;
                if (f < this.wvap_min[n2][i]) {
                    this.wvap_min[n2][i] = f;
                    this.wvap_min_rec[n2][i] = n + 1;
                }
                if (!(f > this.wvap_max[n2][i])) continue;
                this.wvap_max[n2][i] = f;
                this.wvap_max_rec[n2][i] = n + 1;
            }
        }
    }

    private void writeStatSetBlock(DataOutputStream dataOutputStream) {
        try {
            int n;
            int n2;
            int n3 = 8;
            Vector<Integer> vector = new Vector<Integer>();
            for (n2 = 0; n2 < this.num_used_profiles; ++n2) {
                Integer n4 = new Integer(this.profile_group_numbers[n2]);
                if (vector.contains(n4)) continue;
                vector.add(n4);
            }
            n2 = vector.size();
            int n5 = this.num_used_profiles;
            int n6 = this.temp_pressures_to_use.length;
            int n7 = 80 + 3 * n6 + 1 + 37 * n3 + 39 * n2 + n5 * (38 + n6 * n3);
            int n8 = this.wvap_pressures_to_use.length;
            int n9 = 80 + 3 * n8 + 1 + 37 * n3 + 39 * n2 + n5 * (38 + n8 * n3);
            int n10 = 0;
            if (!this.process_rtemp) {
                n7 = 0;
            } else {
                ++n10;
            }
            if (!this.process_wvap) {
                n9 = 0;
            } else {
                ++n10;
            }
            int n11 = 400 + 4 * n7 + 4 * n9;
            dataOutputStream.writeInt(83836984);
            dataOutputStream.writeInt(n11);
            dataOutputStream.writeInt(0);
            int[] nArray = new int[50];
            for (int i = 0; i < 50; ++i) {
                nArray[i] = 0;
            }
            String string = "";
            for (n = 0; n < string.length(); ++n) {
                if (n >= 50) continue;
                nArray[n] = string.charAt(n);
            }
            for (n = 0; n < 50; ++n) {
                dataOutputStream.writeInt(nArray[n]);
            }
            dataOutputStream.writeInt(n10);
            n = this.start_date / 10000;
            int n12 = this.start_date % 10000;
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n12);
            n = this.end_date / 10000;
            n12 = this.end_date % 10000;
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n12);
            int n13 = -23040;
            int n14 = 23040;
            int n15 = 11520;
            int n16 = -11520;
            dataOutputStream.writeInt(n15);
            dataOutputStream.writeInt(n16);
            dataOutputStream.writeInt(n13);
            dataOutputStream.writeInt(n14);
            dataOutputStream.writeInt(Short.MIN_VALUE);
            dataOutputStream.writeInt(Short.MIN_VALUE);
            dataOutputStream.writeInt(Short.MIN_VALUE);
            dataOutputStream.writeInt(Short.MIN_VALUE);
            dataOutputStream.writeInt(Short.MIN_VALUE);
            dataOutputStream.writeInt(Short.MIN_VALUE);
            dataOutputStream.writeInt(Short.MIN_VALUE);
            for (int i = 0; i < 31; ++i) {
                dataOutputStream.writeInt(Short.MIN_VALUE);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeTemperatureStats(DataOutputStream dataOutputStream) {
        int n;
        int n2;
        int n3 = this.temp_pressures_to_use.length;
        float[] fArray = new float[n3];
        float[][] fArray2 = new float[this.num_used_profiles][n3];
        float[][] fArray3 = new float[this.num_used_profiles][n3];
        float[][] fArray4 = new float[this.num_used_profiles][n3];
        float[][] fArray5 = new float[this.num_used_profiles][n3];
        float[][] fArray6 = new float[this.num_used_profiles][n3];
        float[][] fArray7 = new float[this.num_used_profiles][n3];
        int[][] nArray = new int[this.num_used_profiles][n3];
        int[][] nArray2 = new int[this.num_used_profiles][n3];
        for (n2 = 0; n2 < this.num_used_profiles; ++n2) {
            for (n = 0; n < n3; ++n) {
                fArray[n] = -999.99f;
                fArray2[n2][n] = -999.99f;
                fArray3[n2][n] = -999.99f;
                fArray4[n2][n] = -999.99f;
                fArray5[n2][n] = -999.99f;
                fArray6[n2][n] = -999.99f;
                fArray7[n2][n] = -999.99f;
                nArray[n2][n] = Short.MIN_VALUE;
                nArray2[n2][n] = Short.MIN_VALUE;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.rtemp_count[n2] <= 0) continue;
            fArray[n2] = this.rtemp_baseline_sum[n2] / (float)this.rtemp_count[n2];
            for (n = 0; n < this.num_used_profiles; ++n) {
                fArray2[n][n2] = this.rtemp_sum[n][n2] / (float)this.rtemp_count[n2];
                fArray3[n][n2] = this.rtemp_diff[n][n2] / (float)this.rtemp_count[n2];
                fArray4[n][n2] = (float)Math.sqrt(this.rtemp_diffsq[n][n2] / (float)this.rtemp_count[n2] - fArray3[n][n2] * fArray3[n][n2]);
                fArray5[n][n2] = (float)Math.sqrt(this.rtemp_diffsq[n][n2] / (float)this.rtemp_count[n2]);
                fArray6[n][n2] = this.rtemp_min[n][n2];
                fArray7[n][n2] = this.rtemp_max[n][n2];
                nArray[n][n2] = this.rtemp_min_rec[n][n2];
                nArray2[n][n2] = this.rtemp_max_rec[n][n2];
            }
        }
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            n2 = 8;
            Vector<Integer> vector = new Vector<Integer>();
            for (n7 = 0; n7 < this.num_used_profiles; ++n7) {
                Integer n8 = new Integer(this.profile_group_numbers[n7]);
                if (vector.contains(n8)) continue;
                vector.add(n8);
            }
            n7 = vector.size();
            int n9 = this.num_used_profiles;
            int n10 = 81 + 3 * n3 + 37 * n2 + 39 * n7 + n9 * (38 + n3 * n2);
            dataOutputStream.writeInt(68718280);
            dataOutputStream.writeInt(4 * n10);
            dataOutputStream.writeInt(82847780);
            int[] nArray3 = new int[36];
            for (int i = 0; i < 36; ++i) {
                nArray3[i] = 0;
            }
            String string = "Retrieved Temp";
            for (n6 = 0; n6 < string.length(); ++n6) {
                nArray3[n6] = string.charAt(n6);
            }
            for (n6 = 0; n6 < 36; ++n6) {
                dataOutputStream.writeInt(nArray3[n6]);
            }
            dataOutputStream.writeInt(n7);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(100);
            dataOutputStream.writeInt(-150);
            dataOutputStream.writeInt(500);
            int[] nArray4 = new int[36];
            for (n5 = 0; n5 < 36; ++n5) {
                nArray4[n5] = 0;
            }
            for (n5 = 0; n5 < this.baseline_name.length(); ++n5) {
                if (n5 >= nArray4.length) continue;
                nArray4[n5] = this.baseline_name.charAt(n5);
            }
            for (n5 = 0; n5 < 36; ++n5) {
                dataOutputStream.writeInt(nArray4[n5]);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                dataOutputStream.writeInt((int)(this.temp_pressures_to_use[n5] * 1000.0f));
            }
            for (n5 = 0; n5 < n3; ++n5) {
                dataOutputStream.writeInt(this.rtemp_count[n5]);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                if (this.rtemp_count[n5] > 0) {
                    dataOutputStream.writeInt((int)(fArray[n5] * 100.0f));
                    continue;
                }
                dataOutputStream.writeInt(Short.MIN_VALUE);
            }
            dataOutputStream.writeInt(8);
            dataOutputStream.writeInt(77696578);
            dataOutputStream.writeInt(66736583);
            dataOutputStream.writeInt(83686986);
            dataOutputStream.writeInt(82778332);
            dataOutputStream.writeInt(45687370);
            dataOutputStream.writeInt(43687370);
            dataOutputStream.writeInt(45826967);
            dataOutputStream.writeInt(43826967);
            int[] nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Mean";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Bias";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Std Dev";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "RMS";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Neg Diff";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Pos Diff";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Neg Diff Rec";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Pos Diff Rec";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            for (n4 = 0; n4 < vector.size(); ++n4) {
                int n11;
                int n12;
                int n13 = (Integer)vector.elementAt(n4);
                boolean[] blArray = new boolean[this.num_used_profiles];
                Arrays.fill(blArray, false);
                n9 = 0;
                for (n12 = 0; n12 < this.num_used_profiles; ++n12) {
                    int n14 = this.profile_group_numbers[n12];
                    if (n14 != n13) continue;
                    blArray[n12] = true;
                    ++n9;
                }
                dataOutputStream.writeInt(83658432);
                n12 = 4 * (39 + n9 * (n2 * n3 + 38));
                dataOutputStream.writeInt(n12);
                string = "";
                int[] nArray6 = new int[36];
                for (n11 = 0; n11 < 36; ++n11) {
                    nArray6[n11] = 0;
                }
                for (n11 = 0; n11 < string.length(); ++n11) {
                    nArray6[n11] = string.charAt(n11);
                }
                for (n11 = 0; n11 < 36; ++n11) {
                    dataOutputStream.writeInt(nArray6[n11]);
                }
                dataOutputStream.writeInt(n9);
                for (n11 = 0; n11 < this.num_used_profiles; ++n11) {
                    int n15;
                    if (!blArray[n11]) continue;
                    boolean bl = false;
                    dataOutputStream.writeInt(83856671);
                    int n16 = 4 * (38 + n2 * n3);
                    dataOutputStream.writeInt(n16);
                    int n17 = 0;
                    dataOutputStream.writeInt(n17);
                    string = "";
                    int[] nArray7 = new int[36];
                    for (n15 = 0; n15 < 36; ++n15) {
                        nArray7[n15] = 0;
                    }
                    for (n15 = 0; n15 < string.length(); ++n15) {
                        nArray7[n15] = string.charAt(n15);
                    }
                    for (n15 = 0; n15 < 36; ++n15) {
                        dataOutputStream.writeInt(nArray7[n15]);
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray2[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray3[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray4[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray5[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray6[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray7[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt(nArray[n11][n15] * 100);
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt(nArray2[n11][n15] * 100);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeWaterVaporStats(DataOutputStream dataOutputStream) {
        int n;
        int n2;
        int n3 = this.wvap_pressures_to_use.length;
        float[] fArray = new float[n3];
        float[][] fArray2 = new float[this.num_used_profiles][n3];
        float[][] fArray3 = new float[this.num_used_profiles][n3];
        float[][] fArray4 = new float[this.num_used_profiles][n3];
        float[][] fArray5 = new float[this.num_used_profiles][n3];
        float[][] fArray6 = new float[this.num_used_profiles][n3];
        float[][] fArray7 = new float[this.num_used_profiles][n3];
        int[][] nArray = new int[this.num_used_profiles][n3];
        int[][] nArray2 = new int[this.num_used_profiles][n3];
        for (n2 = 0; n2 < this.num_used_profiles; ++n2) {
            for (n = 0; n < n3; ++n) {
                fArray[n] = -999.99f;
                fArray2[n2][n] = -999.99f;
                fArray3[n2][n] = -999.99f;
                fArray4[n2][n] = -999.99f;
                fArray5[n2][n] = -999.99f;
                fArray6[n2][n] = -999.99f;
                fArray7[n2][n] = -999.99f;
                nArray[n2][n] = Short.MIN_VALUE;
                nArray2[n2][n] = Short.MIN_VALUE;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.wvap_count[n2] <= 0) continue;
            fArray[n2] = this.wvap_baseline_sum[n2] / (float)this.wvap_count[n2];
            for (n = 0; n < this.num_used_profiles; ++n) {
                fArray2[n][n2] = this.wvap_sum[n][n2] / (float)this.wvap_count[n2];
                fArray3[n][n2] = this.wvap_diff[n][n2] / (float)this.wvap_count[n2];
                fArray4[n][n2] = (float)Math.sqrt(this.wvap_diffsq[n][n2] / (float)this.wvap_count[n2] - fArray3[n][n2] * fArray3[n][n2]);
                fArray5[n][n2] = (float)Math.sqrt(this.wvap_diffsq[n][n2] / (float)this.wvap_count[n2]);
                fArray6[n][n2] = this.wvap_min[n][n2];
                fArray7[n][n2] = this.wvap_max[n][n2];
                nArray[n][n2] = this.wvap_min_rec[n][n2];
                nArray2[n][n2] = this.wvap_max_rec[n][n2];
                fArray3[n][n2] = fArray3[n][n2] / fArray[n2] * 100.0f;
                fArray4[n][n2] = fArray4[n][n2] / fArray[n2] * 100.0f;
                fArray5[n][n2] = fArray5[n][n2] / fArray[n2] * 100.0f;
                fArray6[n][n2] = fArray6[n][n2] / fArray[n2] * 100.0f;
                fArray7[n][n2] = fArray7[n][n2] / fArray[n2] * 100.0f;
            }
        }
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            n2 = 8;
            Vector<Integer> vector = new Vector<Integer>();
            for (n7 = 0; n7 < this.num_used_profiles; ++n7) {
                Integer n8 = new Integer(this.profile_group_numbers[n7]);
                if (vector.contains(n8)) continue;
                vector.add(n8);
            }
            n7 = vector.size();
            int n9 = this.num_used_profiles;
            int n10 = 81 + 3 * n3 + 37 * n2 + 39 * n7 + n9 * (38 + n3 * n2);
            dataOutputStream.writeInt(68718280);
            dataOutputStream.writeInt(4 * n10);
            dataOutputStream.writeInt(87866580);
            int[] nArray3 = new int[36];
            for (int i = 0; i < 36; ++i) {
                nArray3[i] = 0;
            }
            String string = "Retrieved Water Vapor";
            for (n6 = 0; n6 < string.length(); ++n6) {
                nArray3[n6] = string.charAt(n6);
            }
            for (n6 = 0; n6 < 36; ++n6) {
                dataOutputStream.writeInt(nArray3[n6]);
            }
            dataOutputStream.writeInt(n7);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(100);
            dataOutputStream.writeInt(-9000);
            dataOutputStream.writeInt(16000);
            int[] nArray4 = new int[36];
            for (n5 = 0; n5 < 36; ++n5) {
                nArray4[n5] = 0;
            }
            for (n5 = 0; n5 < this.baseline_name.length(); ++n5) {
                if (n5 >= nArray4.length) continue;
                nArray4[n5] = this.baseline_name.charAt(n5);
            }
            for (n5 = 0; n5 < 36; ++n5) {
                dataOutputStream.writeInt(nArray4[n5]);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                dataOutputStream.writeInt((int)(this.wvap_pressures_to_use[n5] * 1000.0f));
            }
            for (n5 = 0; n5 < n3; ++n5) {
                dataOutputStream.writeInt(this.wvap_count[n5]);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                if (this.wvap_count[n5] > 0) {
                    dataOutputStream.writeInt((int)(fArray[n5] * 100.0f));
                    continue;
                }
                dataOutputStream.writeInt(Short.MIN_VALUE);
            }
            dataOutputStream.writeInt(8);
            dataOutputStream.writeInt(77696578);
            dataOutputStream.writeInt(66736583);
            dataOutputStream.writeInt(83686986);
            dataOutputStream.writeInt(82778332);
            dataOutputStream.writeInt(45687370);
            dataOutputStream.writeInt(43687370);
            dataOutputStream.writeInt(45826967);
            dataOutputStream.writeInt(43826967);
            int[] nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Mean";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Bias";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Std Dev";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "RMS";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Neg Diff";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Pos Diff";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Neg Diff Rec";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            nArray5 = new int[36];
            for (n4 = 0; n4 < 36; ++n4) {
                nArray5[n4] = 0;
            }
            string = "Pos Diff Rec";
            for (n4 = 0; n4 < string.length(); ++n4) {
                nArray5[n4] = string.charAt(n4);
            }
            for (n4 = 0; n4 < 36; ++n4) {
                dataOutputStream.writeInt(nArray5[n4]);
            }
            for (n4 = 0; n4 < vector.size(); ++n4) {
                int n11;
                int n12;
                int n13 = (Integer)vector.elementAt(n4);
                boolean[] blArray = new boolean[this.num_used_profiles];
                Arrays.fill(blArray, false);
                n9 = 0;
                for (n12 = 0; n12 < this.num_used_profiles; ++n12) {
                    int n14 = this.profile_group_numbers[n12];
                    if (n14 != n13) continue;
                    blArray[n12] = true;
                    ++n9;
                }
                dataOutputStream.writeInt(83658432);
                n12 = 4 * (39 + n9 * (8 * n3 + 38));
                dataOutputStream.writeInt(n12);
                string = "";
                int[] nArray6 = new int[36];
                for (n11 = 0; n11 < 36; ++n11) {
                    nArray6[n11] = 0;
                }
                for (n11 = 0; n11 < string.length(); ++n11) {
                    nArray6[n11] = string.charAt(n11);
                }
                for (n11 = 0; n11 < 36; ++n11) {
                    dataOutputStream.writeInt(nArray6[n11]);
                }
                dataOutputStream.writeInt(n9);
                for (n11 = 0; n11 < this.num_used_profiles; ++n11) {
                    int n15;
                    if (!blArray[n11]) continue;
                    boolean bl = false;
                    dataOutputStream.writeInt(83856671);
                    int n16 = 4 * (38 + n2 * n3);
                    dataOutputStream.writeInt(n16);
                    int n17 = 0;
                    dataOutputStream.writeInt(n17);
                    string = "";
                    int[] nArray7 = new int[36];
                    for (n15 = 0; n15 < 36; ++n15) {
                        nArray7[n15] = 0;
                    }
                    for (n15 = 0; n15 < string.length(); ++n15) {
                        nArray7[n15] = string.charAt(n15);
                    }
                    for (n15 = 0; n15 < 36; ++n15) {
                        dataOutputStream.writeInt(nArray7[n15]);
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray2[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray3[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray4[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray5[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray6[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt((int)(fArray7[n11][n15] * 100.0f));
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt(nArray[n11][n15] * 100);
                    }
                    for (n15 = 0; n15 < n3; ++n15) {
                        dataOutputStream.writeInt(nArray2[n11][n15] * 100);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private float[] interpolateTemperatures(float[] fArray, float[] fArray2) {
        int n = this.temp_pressures_to_use.length;
        float[] fArray3 = new float[n];
        Arrays.fill(fArray3, -999.99f);
        for (int i = 0; i < n; ++i) {
            float f = -999.99f;
            int n2 = 0;
            while (f == -999.99f && n2 < fArray2.length) {
                if (fArray[n2] == this.temp_pressures_to_use[i]) {
                    f = fArray2[n2];
                    n2 = fArray2.length;
                    continue;
                }
                if (fArray[n2] > this.temp_pressures_to_use[i]) {
                    if (n2 != 0) {
                        float f2 = fArray2[n2 - 1];
                        float f3 = fArray2[n2];
                        float f4 = fArray[n2 - 1];
                        float f5 = fArray[n2];
                        if (f2 != -999.99f && f3 != -999.99f && f4 != -999.99f && f5 != -999.99f) {
                            f = (float)((double)f2 + (double)(f3 - f2) / Math.log(f5 / f4) * Math.log(this.temp_pressures_to_use[i] / f4));
                        }
                    }
                    n2 = fArray2.length;
                    continue;
                }
                ++n2;
            }
            fArray3[i] = f;
        }
        return fArray3;
    }

    private float[] interpolateMoistures(float[] fArray, float[] fArray2, int n) {
        int n2;
        int n3 = this.wvap_pressures_to_use.length;
        float[] fArray3 = new float[n3];
        Arrays.fill(fArray3, -999.99f);
        for (n2 = 0; n2 < n3; ++n2) {
            float f = -999.99f;
            int n4 = 0;
            while (f == -999.99f && n4 < fArray2.length) {
                if (fArray[n4] == this.wvap_pressures_to_use[n2]) {
                    f = fArray2[n4];
                    n4 = fArray2.length;
                    continue;
                }
                if (fArray[n4] > this.wvap_pressures_to_use[n2]) {
                    if (n4 != 0) {
                        float f2 = fArray2[n4 - 1];
                        float f3 = fArray2[n4];
                        float f4 = fArray[n4 - 1];
                        float f5 = fArray[n4];
                        if (f2 != -999.99f && f3 != -999.99f && f4 != -999.99f && f5 != -999.99f) {
                            f = (float)((double)f2 + (double)(f3 - f2) / Math.log(f5 / f4) * Math.log(this.wvap_pressures_to_use[n2] / f4));
                        }
                    }
                    n4 = fArray2.length;
                    continue;
                }
                ++n4;
            }
            fArray3[n2] = f;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            fArray3[n2] = this.convertToMixingRatio(this.wvap_pressures_to_use[n2], fArray3[n2]);
        }
        return fArray3;
    }

    private float convertToMixingRatio(float f, float f2) {
        float f3 = -999.99f;
        if (f2 != -999.99f) {
            double d = 6.1078 * Math.exp(((double)f2 - 273.16) / ((double)f2 - 273.16 + 238.3) * 17.2694);
            f3 = (float)(622.0 * d / ((double)f - d));
        }
        return f3;
    }
}

