/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.IndexColorModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class ColorRamp
implements Externalizable {
    static final long serialVersionUID = 1L;
    private int class_version = 2;
    private byte[] red;
    private byte[] green;
    private byte[] blue;
    private String description;
    private ImageIcon ramp_icon;

    public ColorRamp() {
        this.red = new byte[256];
        this.green = new byte[256];
        this.blue = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.red[i] = -1;
            this.green[i] = -1;
            this.blue[i] = -1;
        }
        this.red[254] = 0;
        this.green[254] = 0;
        this.blue[254] = 0;
        this.description = "Untitled";
        this.ramp_icon = null;
    }

    public ColorRamp(byte[] byArray, byte[] byArray2, byte[] byArray3, String string, ImageIcon imageIcon) {
        this.red = byArray;
        this.green = byArray2;
        this.blue = byArray3;
        this.description = string != null ? string : "Untitled";
        this.ramp_icon = imageIcon;
    }

    public void setColorRamp(byte[] byArray, byte[] byArray2, byte[] byArray3, String string) {
        this.red = byArray;
        this.green = byArray2;
        this.blue = byArray3;
        this.description = string != null ? string : "Untitled";
    }

    public IndexColorModel getColorScale() {
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, this.red, this.green, this.blue);
        return indexColorModel;
    }

    public int getRed(int n) {
        int n2 = this.red[n];
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public int getGreen(int n) {
        int n2 = this.green[n];
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public int getBlue(int n) {
        int n2 = this.blue[n];
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public byte[] getReds() {
        return this.red;
    }

    public byte[] getReds(int n) {
        byte[] byArray = this.contourColor(this.red, n);
        return byArray;
    }

    public byte[] getGreens() {
        return this.green;
    }

    public byte[] getGreens(int n) {
        byte[] byArray = this.contourColor(this.green, n);
        return byArray;
    }

    public byte[] getBlues() {
        return this.blue;
    }

    public byte[] getBlues(int n) {
        byte[] byArray = this.contourColor(this.blue, n);
        return byArray;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageIcon getRampIcon() {
        return this.ramp_icon;
    }

    public void setMapColor(int n, int n2, int n3) {
        this.red[253] = (byte)n;
        this.green[253] = (byte)n2;
        this.blue[253] = (byte)n3;
    }

    private byte[] contourColor(byte[] byArray, int n) {
        byte[] byArray2 = byArray;
        if (n < 240) {
            int n2;
            int n3;
            int[] nArray = new int[256];
            for (int i = 0; i < 256; ++i) {
                nArray[i] = byArray[i] >= 0 ? byArray[i] : 256 + byArray[i];
            }
            byte[] byArray3 = new byte[n];
            float f = 240.0f / (float)(n - 1);
            float f2 = -f;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = Math.min((int)(f2 += f), 239);
                byArray3[n3] = (byte)nArray[n2];
            }
            f = 240.0f / (float)n;
            byArray2 = new byte[256];
            for (n3 = 0; n3 < 240; ++n3) {
                n2 = (int)((float)n3 / f);
                byArray2[n3] = byArray3[n2];
            }
            for (n3 = 240; n3 < 256; ++n3) {
                byArray2[n3] = (byte)nArray[n3];
            }
        }
        return byArray2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.class_version);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("red", this.red);
        hashMap.put("green", this.green);
        hashMap.put("blue", this.blue);
        hashMap.put("description", this.description);
        hashMap.put("ramp_icon", this.ramp_icon);
        objectOutput.writeObject(hashMap);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 1: {
                this.readVersion01(objectInput);
                break;
            }
            case 2: {
                this.readVersion02(objectInput);
            }
        }
    }

    private void readVersion01(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.red = (byte[])objectInput.readObject();
        this.green = (byte[])objectInput.readObject();
        this.blue = (byte[])objectInput.readObject();
        this.description = (String)objectInput.readObject();
        this.ramp_icon = (ImageIcon)objectInput.readObject();
    }

    private void readVersion02(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        HashMap hashMap = (HashMap)objectInput.readObject();
        if (hashMap.containsKey("red")) {
            this.red = (byte[])hashMap.get("red");
        }
        if (hashMap.containsKey("green")) {
            this.green = (byte[])hashMap.get("green");
        }
        if (hashMap.containsKey("blue")) {
            this.blue = (byte[])hashMap.get("blue");
        }
        if (hashMap.containsKey("description")) {
            this.description = (String)hashMap.get("description");
        }
        if (hashMap.containsKey("ramp_icon")) {
            this.ramp_icon = (ImageIcon)hashMap.get("ramp_icon");
        }
    }
}

