/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class Cosmic501Record
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public Cosmic501Record(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public Cosmic501Record(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public Cosmic501Record() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[4000];
        for (int i = 0; i < 4000; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        String string = "";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "";
        return string;
    }

    public int getTerrain() {
        int n = Short.MIN_VALUE;
        return n;
    }

    public boolean hasSeaNonseaValue() {
        return false;
    }

    public int getSeaNonseaValue() {
        return Short.MIN_VALUE;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        if (this.buffer[46] == 1) {
            bl = false;
        }
        return bl;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return false;
    }

    public int getDayNightFlag() {
        return Short.MIN_VALUE;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        float[] fArray = this.getPressureLevels();
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == -999.99f) continue;
            f = fArray[i];
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription(), "  GFS Forecast", "  Raw Dry"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 2, 21};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[3];
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
            String string2 = "   GFS Fcst";
            profileArray[1] = new Profile(0, string2, 0, Color.black, 1, 0);
            fArray = this.getGFSPressureLevels();
            fArray2 = this.getGFSTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[1].addItem(fArray[i], fArray2[i]);
            }
            profileArray[1].trimProfile();
            String string3 = "   Raw Dry";
            profileArray[2] = new Profile(0, string3, 0, Color.black, 1, 0);
            fArray = this.getRawPressureLevels();
            fArray2 = this.getRawTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[2].addItem(fArray[i], fArray2[i]);
            }
            profileArray[2].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[3];
        profileArray[0] = null;
        if (!this.containsData()) {
            for (int i = 0; i < 3; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
            String string2 = "   GFS Fcst";
            profileArray[1] = new Profile(0, string2, 0, Color.black, 1, 1);
            fArray = this.getGFSPressureLevels();
            fArray2 = this.getGFSDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[1].addItem(fArray[i], fArray2[i]);
            }
            profileArray[1].trimProfile();
            String string3 = "   Raw Dry";
            profileArray[2] = new Profile(0, string3, 0, Color.black, 1, 1);
            profileArray[2].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[3];
        for (int i = 0; i < profileArray.length; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getPressureLevels();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n == 3 || n == 4 || n == 5) {
                fArray = this.getGFSPressureLevels();
            }
            if (n == 6 || n == 7 || n == 8) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 3) {
                float[] fArray2 = this.getRetrievedTemps();
                if (n == 3) {
                    fArray2 = this.getGFSTemps();
                }
                float f4 = -32768.0f;
                int n2 = Short.MIN_VALUE;
                for (int i = fArray.length - 1; i >= 0; --i) {
                    if (fArray[i] == -999.99f) continue;
                    f4 = fArray[i];
                    n2 = i;
                }
                if (f4 > 10.0f && f4 <= 10.5f) {
                    fArray[n2] = 10.0f;
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray3 = this.getRetrievedWaterVapor();
                if (n == 4 || n == 5) {
                    fArray3 = this.getGFSWaterVapor();
                }
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && (n == 1 || n == 4)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4), new Vector(4), new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray3);
        fArray = this.getGFSPressureLevels();
        fArray2 = this.getGFSTemps();
        fArray3 = this.getGFSDewpoints();
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray3);
        fArray = this.getRawPressureLevels();
        fArray2 = this.getRawTemps();
        fArray3 = new float[fArray.length];
        Arrays.fill(fArray3, -999.99f);
        vectorArray[2].add(fArray);
        vectorArray[2].add(fArray2);
        vectorArray[2].add(fArray);
        vectorArray[2].add(fArray3);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[200];
        for (int i = 0; i < 200; ++i) {
            fArray[199 - i] = this.buffer[i + 660] == Short.MIN_VALUE ? -999.99f : (i < 80 ? (float)this.buffer[i + 660] / 10.0f : (float)this.buffer[i + 660] / 100.0f);
        }
        return fArray;
    }

    private float getPressureLevelValue(int n) {
        float f = -999.99f;
        int n2 = 199 - n;
        if (this.buffer[n2 + 660] != Short.MIN_VALUE) {
            f = n2 < 81 ? (float)this.buffer[n2 + 660] / 10.0f : (float)this.buffer[n2 + 660] / 100.0f;
        }
        return f;
    }

    private float[] getWaterVaporPressures() {
        float[] fArray = new float[200];
        for (int i = 0; i < 200; ++i) {
            fArray[199 - i] = this.buffer[i + 460] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 460] / 1024.0);
        }
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[200];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 200; ++i) {
            fArray[199 - i] = this.buffer[i + 260] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 260] / 64.0f;
            if (f == -999.99f || !(fArray2[199 - i] > f)) continue;
            fArray[199 - i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[200];
        float[] fArray2 = this.getWaterVaporPressures();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 200; ++i) {
            fArray[199 - i] = this.buffer[i + 1660] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 1660] / 1024.0);
            if (f == -999.99f || !(fArray2[199 - i] > f)) continue;
            fArray[199 - i] = -999.99f;
        }
        return fArray;
    }

    private float getRetrievedWVapValue(int n) {
        float f = -999.99f;
        int n2 = 199 - n;
        if (this.buffer[n2 + 1660] != Short.MIN_VALUE) {
            f = (float)Math.exp((double)this.buffer[n2 + 1660] / 1024.0);
        }
        return f;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[200];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getPressureLevels();
        for (int i = 0; i < 200; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
        }
        return fArray;
    }

    private float[] getGFSPressureLevels() {
        float[] fArray = new float[30];
        for (int i = 0; i < 30; ++i) {
            fArray[29 - i] = this.buffer[i + 2080] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 2080] / 10.0f;
        }
        return fArray;
    }

    private float[] getGFSTemps() {
        float[] fArray = new float[30];
        for (int i = 0; i < 30; ++i) {
            fArray[29 - i] = this.buffer[i + 2020] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 2020] / 64.0f;
        }
        return fArray;
    }

    private float[] getGFSWaterVapor() {
        float[] fArray = new float[30];
        for (int i = 0; i < 30; ++i) {
            fArray[29 - i] = this.buffer[i + 2200] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 2200] / 1024.0);
        }
        return fArray;
    }

    private float[] getGFSDewpoints() {
        float[] fArray = new float[30];
        float[] fArray2 = this.getGFSWaterVapor();
        float[] fArray3 = this.getGFSPressureLevels();
        for (int i = 0; i < 30; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
        }
        return fArray;
    }

    private float[] getRawPressureLevels() {
        float[] fArray = new float[300];
        for (int i = 0; i < 300; ++i) {
            fArray[i] = this.buffer[i + 2570] == Short.MIN_VALUE ? -999.99f : (i < 19 ? (float)this.buffer[i + 2570] / 100.0f : (float)this.buffer[i + 2570] / 10.0f);
        }
        return fArray;
    }

    private float[] getRawTemps() {
        float[] fArray = new float[300];
        for (int i = 0; i < 300; ++i) {
            fArray[i] = this.buffer[i + 2270] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 2270] / 64.0f;
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildLevelDataTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
            Vector vector4 = this.buildGFSLevelDataTable();
            for (int i = 0; i < vector4.size(); ++i) {
                vector.add((JLabel)vector4.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        byte by;
        short s;
        int n;
        int n2;
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scene Type");
        if (this.buffer[1] == 0) {
            vector4.add("Scene");
        } else if (this.buffer[1] == 1) {
            vector4.add("Retrieved Scene");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame Number");
        if (this.buffer[9] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[9]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Occultation ID");
        if (this.buffer[10] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[10]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reference Sat ID");
        if (this.buffer[18] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[18]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Occulting Sat ID");
        if (this.buffer[19] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[19]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("File Stamp");
        String string = "";
        for (int i = 0; i < 12; ++i) {
            n2 = this.buffer[28 + i];
            if (n2 == Short.MIN_VALUE) continue;
            n = n2 >> 8;
            s = (short)(n2 % 128);
            string = string + (char)n + (char)s;
        }
        vector4.add(string);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Processing Center");
        String string2 = "";
        for (n2 = 0; n2 < 6; ++n2) {
            n = this.buffer[40 + n2];
            if (n == Short.MIN_VALUE) continue;
            s = (byte)(n >> 8);
            by = (byte)(n % 128);
            string2 = string2 + (char)s + (char)by;
        }
        vector4.add(string2);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality Flag");
        if (this.buffer[46] == 0) {
            vector4.add("Good");
        } else if (this.buffer[46] == 1) {
            String string3 = "Bad:  ";
            for (n = 0; n < 10; ++n) {
                s = this.buffer[48 + n];
                if (s == Short.MIN_VALUE) continue;
                by = (byte)(s >> 8);
                byte by2 = (byte)(s % 128);
                string3 = string3 + (char)by + (char)by2;
            }
            vector4.add(string3);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Closeness");
        if (this.buffer[3665] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[3665]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Distance Difference");
        if (this.buffer[3666] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[3666]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Time Difference");
        if (this.buffer[3667] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[3667]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLevelDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Altitude");
        vector2.add("Pressure");
        vector2.add("Temperature");
        vector2.add("Vapor\nPressure");
        vector2.add("Refractivity");
        vector2.add("Latitude");
        vector2.add("Longitude");
        vector2.add("Product\nRef Obs");
        vector2.add("Product\nMixing Ratio");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 199; i >= 0; --i) {
            serializable = new Vector<String>(9);
            if (this.buffer[60 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[60 + i] / 10.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[660 + i] != Short.MIN_VALUE) {
                if (i < 80) {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[660 + i] / 10.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[660 + i] / 100.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[260 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[260 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[460 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[460 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[860 + i] != Short.MIN_VALUE) {
                if (i < 80) {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[860 + i] / 10.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[860 + i] / 100.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1060 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[1060 + i] / 128.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1260 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[1260 + i] / 128.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1460 + i] != Short.MIN_VALUE) {
                if (i < 80) {
                    ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[1460 + i] / 10.0f));
                } else {
                    ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[1460 + i] / 100.0f));
                }
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[1660 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[1660 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }

    public Vector buildGFSLevelDataTable() {
        Serializable serializable;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>NCEP GFS Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Altitude");
        vector2.add("Pressure");
        vector2.add("Temperature");
        vector2.add("Vapor\nPressure");
        vector2.add("Refractivity");
        vector2.add("Latitude");
        vector2.add("Longitude");
        vector2.add("Product\nMixing Ratio");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        for (int i = 29; i >= 0; --i) {
            serializable = new Vector<String>(8);
            if (this.buffer[1990 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[1990 + i] / 10.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[2080 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[2080 + i] / 10.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[2020 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[2020 + i] / 64.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[2050 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[2050 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[2110 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.oneDigit((float)this.buffer[2110 + i] / 10.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[2140 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[2140 + i] / 128.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[2170 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.twoDigits((float)this.buffer[2170 + i] / 128.0f));
            } else {
                ((Vector)serializable).add(" ");
            }
            if (this.buffer[2200 + i] != Short.MIN_VALUE) {
                ((Vector)serializable).add("" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[2200 + i] / 1024.0)));
            } else {
                ((Vector)serializable).add(" ");
            }
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        serializable = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)((Object)serializable));
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }
}

