/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class CosmicRecord
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public CosmicRecord(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public CosmicRecord(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public CosmicRecord() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.contains_data = false;
        this.buffer = new short[4000];
        for (int i = 0; i < 4000; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return this.data_group_name;
    }

    public String getExtraGroupInfo() {
        String string = "";
        return string;
    }

    public float getLatitude() {
        return (float)this.buffer[3] / 128.0f;
    }

    public float getLongitude() {
        return (float)this.buffer[4] / 128.0f;
    }

    public String getDateString() {
        short s = this.buffer[5];
        int n = this.buffer[6] / 100;
        int n2 = this.buffer[6] % 100;
        String string = "" + n + "/";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "/" + s;
        return string;
    }

    public int getDate() {
        int n = this.buffer[5] * 10000 + this.buffer[6];
        return n;
    }

    public String getTimeString() {
        int n = this.buffer[7] % 100;
        int n2 = this.buffer[8] / 100;
        int n3 = this.buffer[8] % 100;
        String string = "" + n + ":";
        if (n < 10) {
            string = "0" + string;
        }
        string = n2 < 10 ? string + "0" + n2 + ":" : string + n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    public int getTime() {
        int n = this.buffer[7] % 100 * 10000 + this.buffer[8];
        return n;
    }

    public String getTerrainString() {
        String string = "";
        return string;
    }

    public int getTerrain() {
        int n = Short.MIN_VALUE;
        return n;
    }

    public boolean hasSeaNonseaValue() {
        return false;
    }

    public int getSeaNonseaValue() {
        return Short.MIN_VALUE;
    }

    public boolean hasQCFlag() {
        return true;
    }

    public boolean getQCFlag() {
        boolean bl = true;
        if (this.buffer[46] == 1) {
            bl = false;
        }
        return bl;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return false;
    }

    public int getDayNightFlag() {
        return Short.MIN_VALUE;
    }

    public float getSurfacePressure() {
        float f = -999.99f;
        float[] fArray = this.getPressureLevels();
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == -999.99f) continue;
            f = fArray[i];
        }
        return f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        int n = this.getTerrain();
        vector.add(new Integer(n));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{this.getGroupDescription()};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 0);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedTemps();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[]{null};
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getPressureLevels();
            float[] fArray2 = this.getRetrievedDewpoints();
            for (int i = 0; i < fArray2.length; ++i) {
                if (fArray2[i] == -999.99f || !(fArray[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray[i], fArray2[i]);
            }
            profileArray[0].trimProfile();
        }
        return profileArray;
    }

    public Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[1];
        if (!this.containsData()) {
            for (int i = 0; i < 1; ++i) {
                profileArray[i] = null;
            }
        } else {
            String string = this.getGroupDescription();
            profileArray[0] = new Profile(0, string, 0, Color.black, 1, 1);
            float[] fArray = this.getRetrievedWaterVapor();
            float[] fArray2 = this.getPressureLevels();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == -999.99f || !(fArray2[i] >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(fArray2[i], fArray[i]);
            }
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            float[] fArray = this.getPressureLevels();
            if (n == 3 || n == 4 || n == 5) {
                f2 = -32768.0f;
            }
            if (n == 6 || n == 7 || n == 8) {
                f2 = -32768.0f;
            } else if (n == 0) {
                float[] fArray2 = this.getRetrievedTemps();
                float f4 = -32768.0f;
                int n2 = Short.MIN_VALUE;
                for (int i = fArray.length - 1; i >= 0; --i) {
                    if (fArray[i] == -999.99f) continue;
                    f4 = fArray[i];
                    n2 = i;
                }
                if (f4 > 10.0f && f4 <= 10.5f) {
                    fArray[n2] = 10.0f;
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                float[] fArray3 = this.getRetrievedWaterVapor();
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && n == 1) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        Vector[] vectorArray = new Vector[]{new Vector(4)};
        float[] fArray = this.getPressureLevels();
        float[] fArray2 = this.getRetrievedTemps();
        float[] fArray3 = this.getRetrievedDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray3);
        return vectorArray;
    }

    private float[] getPressureLevels() {
        float[] fArray = new float[400];
        for (int i = 0; i < 400; ++i) {
            fArray[399 - i] = this.buffer[i + 1260] == Short.MIN_VALUE ? -999.99f : (i < 160 ? (float)this.buffer[i + 1260] / 10.0f : (float)this.buffer[i + 1260] / 100.0f);
        }
        return fArray;
    }

    private float getPressureLevelValue(int n) {
        float f = -999.99f;
        int n2 = 399 - n;
        if (this.buffer[n2 + 1260] != Short.MIN_VALUE) {
            f = n2 < 161 ? (float)this.buffer[n2 + 1260] / 10.0f : (float)this.buffer[n2 + 1260] / 100.0f;
        }
        return f;
    }

    private float[] getWaterVaporPressures() {
        float[] fArray = new float[400];
        for (int i = 0; i < 400; ++i) {
            fArray[399 - i] = this.buffer[i + 860] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 860] / 1024.0);
        }
        return fArray;
    }

    private float[] getRetrievedTemps() {
        float[] fArray = new float[400];
        float[] fArray2 = this.getPressureLevels();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 400; ++i) {
            fArray[399 - i] = this.buffer[i + 460] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 460] / 64.0f;
            if (f == -999.99f || !(fArray2[399 - i] > f)) continue;
            fArray[399 - i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedWaterVapor() {
        float[] fArray = new float[400];
        float[] fArray2 = this.getWaterVaporPressures();
        float f = this.getSurfacePressure();
        for (int i = 0; i < 400; ++i) {
            fArray[399 - i] = this.buffer[i + 3260] == Short.MIN_VALUE ? -999.99f : (float)Math.exp((double)this.buffer[i + 3260] / 1024.0);
            if (f == -999.99f || !(fArray2[399 - i] > f)) continue;
            fArray[399 - i] = -999.99f;
        }
        return fArray;
    }

    private float[] getRetrievedDewpoints() {
        float[] fArray = new float[400];
        float[] fArray2 = this.getRetrievedWaterVapor();
        float[] fArray3 = this.getPressureLevels();
        for (int i = 0; i < 400; ++i) {
            fArray[i] = fArray2[i] == -999.99f ? -999.99f : EdgeUtils.convertToDewPoint(fArray2[i], fArray3[i]);
        }
        return fArray;
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.containsData()) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add(this.getGroupDescription());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = this.getGroupDescription();
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (stringArray[i].equals(string)) {
                stringArray[i] = "Retrieval";
            }
            vectorArray[i].add(stringArray[i].trim());
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>" + this.getGroupDescription() + "</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Satellite Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected satellite was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        byte by;
        short s;
        int n;
        int n2;
        Vector<JPanel> vector = new Vector<JPanel>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>(2);
        vector4.add("Quality Flag");
        if (this.getQCFlag()) {
            vector4.add("Pass");
        } else {
            vector4.add("Fail");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Scene Type");
        if (this.buffer[1] == 0) {
            vector4.add("Scene");
        } else if (this.buffer[1] == 1) {
            vector4.add("Retrieved Scene");
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Data Frame Number");
        if (this.buffer[9] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[9]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Occultation ID");
        if (this.buffer[10] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[10]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Reference Sat ID");
        if (this.buffer[18] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[18]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Occulting Sat ID");
        if (this.buffer[19] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[19]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Occulting Sat ID");
        String string = "";
        for (int i = 0; i < 12; ++i) {
            n2 = this.buffer[28 + i];
            if (n2 == Short.MIN_VALUE) continue;
            n = n2 >> 8;
            s = (short)(n2 % 128);
            string = string + (char)n + (char)s;
        }
        vector4.add(string);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Processing center");
        String string2 = "";
        for (n2 = 0; n2 < 6; ++n2) {
            n = this.buffer[40 + n2];
            if (n == Short.MIN_VALUE) continue;
            s = (byte)(n >> 8);
            by = (byte)(n % 128);
            string2 = string2 + (char)s + (char)by;
        }
        vector4.add(string2);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Quality Flag");
        String string3 = "";
        if (this.buffer[46] == 0) {
            string3 = "Good";
        } else if (this.buffer[46] == 1) {
            string3 = "Bad:  ";
            for (n = 0; n < 10; ++n) {
                s = this.buffer[48 + n];
                if (s == Short.MIN_VALUE) continue;
                by = (byte)(s >> 8);
                byte by2 = (byte)(s % 128);
                string3 = string3 + (char)by + (char)by2;
            }
        } else {
            string3 = "not available";
        }
        vector4.add(string3);
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add(" ");
        vector4.add(" ");
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Closeness");
        if (this.buffer[3665] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[3665]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Distance Difference");
        if (this.buffer[3666] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[3666]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        vector4 = new Vector(2);
        vector4.add("Time Difference");
        if (this.buffer[3667] != Short.MIN_VALUE) {
            vector4.add("" + this.buffer[3667]);
        } else {
            vector4.add("not available");
        }
        vector3.add(vector4);
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jTable);
        vector.add(jPanel);
        return vector;
    }

    public Vector buildLayerDataTable() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Layer Data</bold></font></html>"));
        return vector;
    }
}

