/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.UIManager;

public class EdgeGlobals
implements Externalizable {
    static final long serialVersionUID = 1L;
    private int class_version = 5;
    private static boolean variables_initialized;
    private static String program_version;
    private static String default_directory;
    private static String data_directory;
    private static String image_directory;
    private static String most_recent_data_file;
    private static String file_separator;
    private static int temperature_unit;
    private static int pressure_unit;
    private static int date_label;
    private static String look_and_feel;
    private static String font_name;
    private static int font_style;
    private static int minimum_font_size;
    private static int parameter_group;
    private static int profile_plot_type;
    private static boolean show_grid_lines;
    private static boolean show_data_points;
    private static boolean show_cloud_data;
    private static Vector color_ramps;
    private static int num_default_ramps;
    private static Vector shortcuts;
    private static Color[][][] profile_colors;
    private static int[][][] profile_thicknesses;
    private static int[][][] profile_styles;
    private static int profile_plotting_option;
    private static int last_image_type;
    public int PNG = 0;
    public int JPG = 1;

    public EdgeGlobals() {
        if (!variables_initialized) {
            this.initialize();
        }
        file_separator = System.getProperty("file.separator");
        if (look_and_feel == null) {
            look_and_feel = UIManager.getSystemLookAndFeelClassName();
        }
    }

    private void initialize() {
        try {
            default_directory = System.getProperty("user.dir");
            data_directory = System.getProperty("user.dir");
            image_directory = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        parameter_group = 0;
        profile_plot_type = 1;
        show_grid_lines = true;
        show_data_points = false;
        show_cloud_data = false;
        color_ramps = new Vector();
        font_name = "Sans-Serif";
        font_style = 0;
        minimum_font_size = 5;
        profile_colors = null;
        profile_thicknesses = null;
        profile_styles = null;
        profile_plotting_option = 0;
        this.initializeProfileSettings();
        variables_initialized = true;
        last_image_type = this.PNG;
    }

    public boolean setDefaultDirectory(String string) {
        boolean bl = true;
        File file = new File(string);
        if (file.isDirectory()) {
            default_directory = string;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean setDataDirectory(String string) {
        boolean bl = true;
        File file = new File(string);
        if (file.isDirectory()) {
            data_directory = string;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean setImageDirectory(String string) {
        boolean bl = true;
        File file = new File(string);
        if (file.isDirectory()) {
            image_directory = string;
        } else {
            bl = false;
        }
        return bl;
    }

    public void setMostRecentFile(String string) {
        most_recent_data_file = string;
    }

    public void setTemperatureUnit(int n) {
        temperature_unit = n;
    }

    public void setPressureUnit(int n) {
        pressure_unit = n;
    }

    public void setDateLabelOption(int n) {
        date_label = n;
    }

    public void setShortcuts(Vector vector) {
        shortcuts = vector;
    }

    public void setParameterGroup(int n) {
        parameter_group = n;
    }

    public void setProfilePlotType(int n) {
        profile_plot_type = n;
    }

    public void setShowGridLines(boolean bl) {
        show_grid_lines = bl;
    }

    public void setShowDataPoints(boolean bl) {
        show_data_points = bl;
    }

    public void setShowCloudData(boolean bl) {
        show_cloud_data = bl;
    }

    public void setProgramVersion(String string) {
        program_version = string;
    }

    public String getProgramVersion() {
        return program_version;
    }

    public String defaultDirectory() {
        return default_directory;
    }

    public String dataDirectory() {
        if (data_directory != null) {
            return data_directory;
        }
        return System.getProperty("user.dir");
    }

    public String imageDirectory() {
        return image_directory;
    }

    public String mostRecentFile() {
        return most_recent_data_file;
    }

    public int getTemperatureUnit() {
        return temperature_unit;
    }

    public int getPressureUnit() {
        return pressure_unit;
    }

    public int getDateLabelOption() {
        return date_label;
    }

    public Vector getShortcuts() {
        return shortcuts;
    }

    public int getParameterGroup() {
        return parameter_group;
    }

    public int getProfilePlotType() {
        return profile_plot_type;
    }

    public boolean getShowGridLines() {
        return show_grid_lines;
    }

    public boolean getShowDataPoints() {
        return show_data_points;
    }

    public boolean getShowCloudData() {
        return show_cloud_data;
    }

    public void setLookAndFeel(String string) {
        look_and_feel = string;
    }

    public String getLookAndFeel() {
        return look_and_feel;
    }

    public void setFontName(String string) {
        font_name = string;
    }

    public String getFontName() {
        return font_name;
    }

    public void setFontStyle(int n) {
        font_style = n;
    }

    public int getFontStyle() {
        return font_style;
    }

    public void setMinimumFontSize(int n) {
        minimum_font_size = n;
    }

    public int getMinimumFontSize() {
        return minimum_font_size;
    }

    public void addColorRamp(ColorRamp colorRamp) {
        color_ramps.addElement(colorRamp);
    }

    public int getNumberOfColorRamps() {
        return color_ramps.size();
    }

    public void setNumberOfDefaultRamps(int n) {
        num_default_ramps = n;
    }

    public int getNumberOfDefaultRamps() {
        return num_default_ramps;
    }

    public ColorRamp getColorRamp(int n) {
        ColorRamp colorRamp = null;
        if (color_ramps.size() > 0) {
            int n2 = n;
            if (n2 < 0 || n2 >= color_ramps.size()) {
                n2 = 0;
            }
            colorRamp = (ColorRamp)color_ramps.elementAt(n2);
        } else {
            try {
                String string = "default_ramps/rainbow";
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                colorRamp = (ColorRamp)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return colorRamp;
    }

    public String fileSeparator() {
        return file_separator;
    }

    public void setProfileColors(Color[][][] colorArray) {
        profile_colors = colorArray;
    }

    public Color[][][] getProfileColors() {
        return profile_colors;
    }

    public void setProfileThicknesses(int[][][] nArray) {
        profile_thicknesses = nArray;
    }

    public int[][][] getProfileThicknesses() {
        return profile_thicknesses;
    }

    public void setProfileStyles(int[][][] nArray) {
        profile_styles = nArray;
    }

    public int[][][] getProfileStyles() {
        return profile_styles;
    }

    public void setProfilePlottingOption(int n) {
        profile_plotting_option = n;
    }

    public int getProfilePlottingOption() {
        return profile_plotting_option;
    }

    public void setLastImageType(int n) {
        last_image_type = n;
    }

    public int getLastImageType() {
        return last_image_type;
    }

    private void initializeProfileSettings() {
        int n;
        int n2;
        profile_colors = new Color[20][20][5];
        profile_thicknesses = new int[20][20][5];
        profile_styles = new int[20][20][5];
        for (n2 = 0; n2 < 20; ++n2) {
            for (n = 0; n < 20; ++n) {
                for (int i = 0; i < 5; ++i) {
                    EdgeGlobals.profile_colors[n2][n][i] = Color.black;
                    EdgeGlobals.profile_thicknesses[n2][n][i] = 3;
                    EdgeGlobals.profile_styles[n2][n][i] = 1;
                    if (i != 1) continue;
                    EdgeGlobals.profile_styles[n2][n][i] = 2;
                }
            }
        }
        EdgeGlobals.profile_colors[0][0][0] = new Color(255, 0, 0);
        EdgeGlobals.profile_colors[0][1][0] = new Color(200, 0, 0);
        EdgeGlobals.profile_colors[0][2][0] = new Color(255, 128, 0);
        EdgeGlobals.profile_colors[0][3][0] = new Color(255, 128, 128);
        EdgeGlobals.profile_colors[0][4][0] = new Color(250, 190, 190);
        EdgeGlobals.profile_colors[0][5][0] = new Color(255, 0, 85);
        EdgeGlobals.profile_colors[0][6][0] = new Color(217, 0, 72);
        EdgeGlobals.profile_colors[0][7][0] = new Color(153, 0, 51);
        EdgeGlobals.profile_colors[0][8][0] = new Color(255, 128, 170);
        EdgeGlobals.profile_colors[0][9][0] = new Color(255, 191, 213);
        EdgeGlobals.profile_colors[1][0][0] = new Color(0, 0, 255);
        EdgeGlobals.profile_colors[1][1][0] = new Color(128, 128, 255);
        EdgeGlobals.profile_colors[1][2][0] = new Color(0, 0, 153);
        EdgeGlobals.profile_colors[1][3][0] = new Color(190, 190, 255);
        EdgeGlobals.profile_colors[1][4][0] = new Color(0, 0, 217);
        EdgeGlobals.profile_colors[1][5][0] = new Color(0, 85, 255);
        EdgeGlobals.profile_colors[1][6][0] = new Color(0, 72, 217);
        EdgeGlobals.profile_colors[1][7][0] = new Color(0, 51, 153);
        EdgeGlobals.profile_colors[1][8][0] = new Color(128, 170, 255);
        EdgeGlobals.profile_colors[1][9][0] = new Color(191, 213, 255);
        EdgeGlobals.profile_colors[2][0][0] = new Color(0, 130, 0);
        EdgeGlobals.profile_colors[2][1][0] = new Color(64, 128, 64);
        EdgeGlobals.profile_colors[2][2][0] = new Color(0, 85, 0);
        EdgeGlobals.profile_colors[2][3][0] = new Color(96, 128, 96);
        EdgeGlobals.profile_colors[2][4][0] = new Color(0, 60, 0);
        EdgeGlobals.profile_colors[2][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[2][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[2][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[2][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[2][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[3][0][0] = new Color(255, 127, 0);
        EdgeGlobals.profile_colors[3][1][0] = new Color(217, 105, 0);
        EdgeGlobals.profile_colors[3][2][0] = new Color(153, 74, 0);
        EdgeGlobals.profile_colors[3][3][0] = new Color(255, 189, 128);
        EdgeGlobals.profile_colors[3][4][0] = new Color(255, 222, 191);
        EdgeGlobals.profile_colors[3][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[3][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[3][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[3][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[3][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[4][0][0] = new Color(255, 0, 255);
        EdgeGlobals.profile_colors[4][1][0] = new Color(255, 128, 255);
        EdgeGlobals.profile_colors[4][2][0] = new Color(128, 0, 128);
        EdgeGlobals.profile_colors[4][3][0] = new Color(255, 191, 255);
        EdgeGlobals.profile_colors[4][4][0] = new Color(217, 0, 217);
        EdgeGlobals.profile_colors[4][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[4][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[4][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[4][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[4][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[5][0][0] = new Color(0, 255, 255);
        EdgeGlobals.profile_colors[5][1][0] = new Color(128, 255, 255);
        EdgeGlobals.profile_colors[5][2][0] = new Color(0, 128, 128);
        EdgeGlobals.profile_colors[5][3][0] = new Color(191, 255, 255);
        EdgeGlobals.profile_colors[5][4][0] = new Color(0, 217, 217);
        EdgeGlobals.profile_colors[5][5][0] = new Color(0, 255, 175);
        EdgeGlobals.profile_colors[5][6][0] = new Color(0, 153, 105);
        EdgeGlobals.profile_colors[5][7][0] = new Color(128, 255, 215);
        EdgeGlobals.profile_colors[5][8][0] = new Color(0, 217, 148);
        EdgeGlobals.profile_colors[5][9][0] = new Color(191, 255, 235);
        EdgeGlobals.profile_colors[6][0][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[6][1][0] = new Color(191, 191, 191);
        EdgeGlobals.profile_colors[6][2][0] = new Color(64, 64, 64);
        EdgeGlobals.profile_colors[6][3][0] = new Color(128, 128, 128);
        EdgeGlobals.profile_colors[6][4][0] = new Color(217, 217, 217);
        EdgeGlobals.profile_colors[6][5][0] = new Color(40, 40, 40);
        EdgeGlobals.profile_colors[6][6][0] = new Color(166, 166, 166);
        EdgeGlobals.profile_colors[6][7][0] = new Color(89, 89, 89);
        EdgeGlobals.profile_colors[6][8][0] = new Color(148, 148, 148);
        EdgeGlobals.profile_colors[6][9][0] = new Color(107, 107, 107);
        EdgeGlobals.profile_colors[7][0][0] = new Color(215, 215, 0);
        EdgeGlobals.profile_colors[7][1][0] = new Color(191, 191, 76);
        EdgeGlobals.profile_colors[7][2][0] = new Color(175, 175, 0);
        EdgeGlobals.profile_colors[7][3][0] = new Color(128, 128, 51);
        EdgeGlobals.profile_colors[7][4][0] = new Color(255, 255, 0);
        EdgeGlobals.profile_colors[7][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[7][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[7][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[7][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[7][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[8][0][0] = new Color(0, 255, 0);
        EdgeGlobals.profile_colors[8][1][0] = new Color(128, 255, 128);
        EdgeGlobals.profile_colors[8][2][0] = new Color(0, 200, 0);
        EdgeGlobals.profile_colors[8][3][0] = new Color(191, 255, 191);
        EdgeGlobals.profile_colors[8][4][0] = new Color(0, 153, 0);
        EdgeGlobals.profile_colors[8][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[8][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[8][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[8][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[8][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[9][0][0] = new Color(128, 85, 35);
        EdgeGlobals.profile_colors[9][1][0] = new Color(128, 85, 35);
        EdgeGlobals.profile_colors[9][2][0] = new Color(128, 85, 35);
        EdgeGlobals.profile_colors[9][3][0] = new Color(128, 85, 35);
        EdgeGlobals.profile_colors[9][4][0] = new Color(128, 85, 35);
        EdgeGlobals.profile_colors[9][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[9][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[9][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[9][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[9][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[10][0][0] = new Color(40, 128, 110);
        EdgeGlobals.profile_colors[10][1][0] = new Color(40, 128, 110);
        EdgeGlobals.profile_colors[10][2][0] = new Color(40, 128, 110);
        EdgeGlobals.profile_colors[10][3][0] = new Color(40, 128, 110);
        EdgeGlobals.profile_colors[10][4][0] = new Color(40, 128, 110);
        EdgeGlobals.profile_colors[10][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[10][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[10][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[10][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[10][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[11][0][0] = new Color(191, 59, 101);
        EdgeGlobals.profile_colors[11][1][0] = new Color(191, 94, 124);
        EdgeGlobals.profile_colors[11][2][0] = new Color(191, 136, 151);
        EdgeGlobals.profile_colors[11][3][0] = new Color(191, 136, 151);
        EdgeGlobals.profile_colors[11][4][0] = new Color(191, 136, 151);
        EdgeGlobals.profile_colors[11][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[11][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[11][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[11][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[11][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[12][0][0] = new Color(255, 170, 0);
        EdgeGlobals.profile_colors[12][1][0] = new Color(217, 141, 0);
        EdgeGlobals.profile_colors[12][2][0] = new Color(153, 99, 0);
        EdgeGlobals.profile_colors[12][3][0] = new Color(255, 210, 128);
        EdgeGlobals.profile_colors[12][4][0] = new Color(255, 233, 191);
        EdgeGlobals.profile_colors[12][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[12][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[12][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[12][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[12][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[13][0][0] = new Color(128, 0, 255);
        EdgeGlobals.profile_colors[13][1][0] = new Color(64, 0, 128);
        EdgeGlobals.profile_colors[13][2][0] = new Color(191, 128, 255);
        EdgeGlobals.profile_colors[13][3][0] = new Color(108, 0, 217);
        EdgeGlobals.profile_colors[13][4][0] = new Color(225, 191, 255);
        EdgeGlobals.profile_colors[13][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[13][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[13][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[13][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[13][9][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[14][0][0] = new Color(255, 128, 128);
        EdgeGlobals.profile_colors[14][1][0] = new Color(255, 191, 191);
        EdgeGlobals.profile_colors[14][2][0] = new Color(153, 77, 77);
        EdgeGlobals.profile_colors[14][3][0] = new Color(90, 45, 45);
        EdgeGlobals.profile_colors[14][4][0] = new Color(255, 77, 77);
        EdgeGlobals.profile_colors[14][5][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[14][6][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[14][7][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[14][8][0] = new Color(0, 0, 0);
        EdgeGlobals.profile_colors[14][9][0] = new Color(0, 0, 0);
        for (n2 = 0; n2 < 20; ++n2) {
            for (n = 0; n < 20; ++n) {
                EdgeGlobals.profile_colors[n2][n][1] = profile_colors[n2][n][0];
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.class_version);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("variables_initialized", new Boolean(variables_initialized));
        hashMap.put("program_version", program_version);
        hashMap.put("default_directory", default_directory);
        hashMap.put("data_directory", data_directory);
        hashMap.put("image_directory", image_directory);
        hashMap.put("most_recent_data_file", most_recent_data_file);
        hashMap.put("temperature_unit", new Integer(temperature_unit));
        hashMap.put("pressure_unit", new Integer(pressure_unit));
        hashMap.put("date_label", new Integer(date_label));
        hashMap.put("look_and_feel", look_and_feel);
        hashMap.put("font_name", font_name);
        hashMap.put("font_style", new Integer(font_style));
        hashMap.put("minimum_font_size", new Integer(minimum_font_size));
        hashMap.put("parameter_group", new Integer(parameter_group));
        hashMap.put("profile_plot_type", new Integer(profile_plot_type));
        hashMap.put("show_grid_lines", new Boolean(show_grid_lines));
        hashMap.put("show_data_points", new Boolean(show_data_points));
        hashMap.put("shortcuts", shortcuts);
        hashMap.put("profile_colors", profile_colors);
        hashMap.put("profile_thicknesses", profile_thicknesses);
        hashMap.put("profile_styles", profile_styles);
        hashMap.put("profile_plotting_option", new Integer(profile_plotting_option));
        hashMap.put("show_cloud_data", new Boolean(show_cloud_data));
        hashMap.put("last_image_type", new Integer(last_image_type));
        objectOutput.writeObject(hashMap);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 1: {
                this.readVersion01(objectInput);
                break;
            }
            case 2: {
                this.readVersion01(objectInput);
                this.readVersion02(objectInput);
                break;
            }
            case 3: {
                this.readVersion01(objectInput);
                this.readVersion02(objectInput);
                this.readVersion03(objectInput);
                break;
            }
            case 4: {
                this.readVersion04(objectInput);
                break;
            }
            case 5: {
                this.readVersion05(objectInput);
            }
        }
    }

    private void readVersion01(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        variables_initialized = objectInput.readBoolean();
        program_version = (String)objectInput.readObject();
        String string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        temperature_unit = objectInput.readInt();
        pressure_unit = objectInput.readInt();
        date_label = objectInput.readInt();
        look_and_feel = (String)objectInput.readObject();
        font_name = (String)objectInput.readObject();
        font_style = objectInput.readInt();
        minimum_font_size = objectInput.readInt();
        parameter_group = objectInput.readInt();
        profile_plot_type = objectInput.readInt();
        show_grid_lines = objectInput.readBoolean();
        show_data_points = objectInput.readBoolean();
        Vector vector = (Vector)objectInput.readObject();
        shortcuts = new Vector();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Shortcut shortcut = (Shortcut)vector.elementAt(i);
                String string2 = shortcut.getPath();
                File file = new File(string2);
                if (!file.exists()) continue;
                shortcuts.addElement(shortcut);
            }
        }
    }

    private void readVersion02(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Color[] colorArray = (Color[])objectInput.readObject();
        int[] nArray = (int[])objectInput.readObject();
        int[] nArray2 = (int[])objectInput.readObject();
    }

    private void readVersion03(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        show_cloud_data = objectInput.readBoolean();
        boolean bl = objectInput.readBoolean();
        bl = objectInput.readBoolean();
        bl = objectInput.readBoolean();
        bl = objectInput.readBoolean();
        last_image_type = objectInput.readInt();
        int n = objectInput.readInt();
        n = objectInput.readInt();
        n = objectInput.readInt();
        n = objectInput.readInt();
    }

    private void readVersion04(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        variables_initialized = objectInput.readBoolean();
        program_version = (String)objectInput.readObject();
        String string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        string = (String)objectInput.readObject();
        temperature_unit = objectInput.readInt();
        pressure_unit = objectInput.readInt();
        date_label = objectInput.readInt();
        look_and_feel = (String)objectInput.readObject();
        font_name = (String)objectInput.readObject();
        font_style = objectInput.readInt();
        minimum_font_size = objectInput.readInt();
        parameter_group = objectInput.readInt();
        profile_plot_type = objectInput.readInt();
        show_grid_lines = objectInput.readBoolean();
        show_data_points = objectInput.readBoolean();
        Vector vector = (Vector)objectInput.readObject();
        shortcuts = new Vector();
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                Shortcut shortcut = (Shortcut)vector.elementAt(n);
                String string2 = shortcut.getPath();
                File file = new File(string2);
                if (!file.exists()) continue;
                shortcuts.addElement(shortcut);
            }
        }
        profile_colors = (Color[][][])objectInput.readObject();
        profile_thicknesses = (int[][][])objectInput.readObject();
        profile_styles = (int[][][])objectInput.readObject();
        show_cloud_data = objectInput.readBoolean();
        n = objectInput.readBoolean() ? 1 : 0;
        n = objectInput.readBoolean() ? 1 : 0;
        n = objectInput.readBoolean() ? 1 : 0;
        n = objectInput.readBoolean() ? 1 : 0;
        last_image_type = objectInput.readInt();
        int n2 = objectInput.readInt();
        n2 = objectInput.readInt();
        n2 = objectInput.readInt();
        n2 = objectInput.readInt();
    }

    private void readVersion05(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        HashMap hashMap = (HashMap)objectInput.readObject();
        if (hashMap.containsKey("variables_initialized")) {
            variables_initialized = (Boolean)hashMap.get("variables_initialized");
        }
        if (hashMap.containsKey("program_version")) {
            program_version = (String)hashMap.get("program_version");
        }
        if (hashMap.containsKey("default_directory")) {
            default_directory = (String)hashMap.get("default_directory");
        }
        if (hashMap.containsKey("data_directory")) {
            data_directory = (String)hashMap.get("data_directory");
        }
        if (hashMap.containsKey("image_directory")) {
            image_directory = (String)hashMap.get("image_directory");
        }
        if (hashMap.containsKey("most_recent_data_file")) {
            most_recent_data_file = (String)hashMap.get("most_recent_data_file");
        }
        if (hashMap.containsKey("temperature_unit")) {
            temperature_unit = (Integer)hashMap.get("temperature_unit");
        }
        if (hashMap.containsKey("pressure_unit")) {
            pressure_unit = (Integer)hashMap.get("pressure_unit");
        }
        if (hashMap.containsKey("date_label")) {
            date_label = (Integer)hashMap.get("date_label");
        }
        if (hashMap.containsKey("look_and_feel")) {
            look_and_feel = (String)hashMap.get("look_and_feel");
        }
        if (hashMap.containsKey("font_name")) {
            font_name = (String)hashMap.get("font_name");
        }
        if (hashMap.containsKey("font_style")) {
            font_style = (Integer)hashMap.get("font_style");
        }
        if (hashMap.containsKey("minimum_font_size")) {
            minimum_font_size = (Integer)hashMap.get("minimum_font_size");
        }
        if (hashMap.containsKey("parameter_group")) {
            parameter_group = (Integer)hashMap.get("parameter_group");
        }
        if (hashMap.containsKey("profile_plot_type")) {
            profile_plot_type = (Integer)hashMap.get("profile_plot_type");
        }
        if (hashMap.containsKey("show_grid_lines")) {
            show_grid_lines = (Boolean)hashMap.get("show_grid_lines");
        }
        if (hashMap.containsKey("show_data_points")) {
            show_data_points = (Boolean)hashMap.get("show_data_points");
        }
        if (hashMap.containsKey("shortcuts")) {
            Vector vector = (Vector)hashMap.get("shortcuts");
            shortcuts = new Vector();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Shortcut shortcut = (Shortcut)vector.elementAt(i);
                    String string = shortcut.getPath();
                    File file = new File(string);
                    if (!file.exists()) continue;
                    shortcuts.addElement(shortcut);
                }
            }
        }
        if (hashMap.containsKey("profile_thicknesses")) {
            profile_thicknesses = (int[][][])hashMap.get("profile_thicknesses");
        }
        if (hashMap.containsKey("profile_styles")) {
            profile_styles = (int[][][])hashMap.get("profile_styles");
        }
        if (hashMap.containsKey("profile_plotting_option")) {
            profile_plotting_option = (Integer)hashMap.get("profile_plotting_option");
        }
        if (hashMap.containsKey("show_cloud_data")) {
            show_cloud_data = (Boolean)hashMap.get("show_cloud_data");
        }
        if (hashMap.containsKey("last_image_type")) {
            last_image_type = (Integer)hashMap.get("last_image_type");
        }
    }
}

