/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class EdgeUtils {
    public static float convertToDewPoint(float f, float f2) {
        double d = (double)f2 * ((double)f / 622.0) / (1.0 + (double)f / 622.0);
        double d2 = Math.log(d / 6.1078);
        double d3 = d2 * 238.3 / (17.2694 - d2) + 273.16;
        return (float)d3;
    }

    public static float convertToMixingRatio(float f, float f2) {
        float f3 = -999.99f;
        if (f2 != -999.99f) {
            double d = 6.1078 * Math.exp(((double)f2 - 273.16) / ((double)f2 - 273.16 + 238.3) * 17.2694);
            f3 = (float)(622.0 * d / ((double)f - d));
        }
        return f3;
    }

    public static float interpolateTemperature(float f, float[] fArray, float[] fArray2) {
        float f2 = -32768.0f;
        int n = 0;
        while (f2 == -32768.0f && n < fArray2.length) {
            if (fArray2[n] == f) {
                f2 = fArray[n];
                n = fArray.length;
                continue;
            }
            if (fArray2[n] > f) {
                if (n != 0) {
                    float f3 = fArray[n - 1];
                    float f4 = fArray[n];
                    float f5 = fArray2[n - 1];
                    float f6 = fArray2[n];
                    if (f3 != -999.99f && f4 != -999.99f && f5 != -999.99f && f6 != -999.99f) {
                        f2 = (float)((double)f3 + (double)(f4 - f3) / Math.log(f6 / f5) * Math.log(f / f5));
                    }
                }
                n = fArray.length;
                continue;
            }
            ++n;
        }
        return f2;
    }

    public static float calculateDistance(float f, float f2, float f3, float f4) {
        float f5 = 999.99f;
        double d = 0.0174532925;
        double d2 = 6371.004;
        double d3 = 3.14159265;
        double d4 = -3.14159265;
        double d5 = 6.2831853;
        double d6 = (double)f * d;
        double d7 = (double)f2 * d;
        double d8 = (double)f3 * d;
        double d9 = (double)f4 * d;
        double d10 = d7 - d9;
        if (d10 > d3) {
            d10 -= d5;
        }
        if (d10 < d4) {
            d10 += d5;
        }
        double d11 = Math.cos(d10);
        double d12 = Math.sin(d6) * Math.sin(d8) + Math.cos(d6) * Math.cos(d8) * d11;
        d12 = Math.max(d12, -1.0);
        d12 = Math.min(d12, 1.0);
        f5 = (float)(Math.acos(d12) * d2);
        return f5;
    }

    public static float interpolate(float f, float f2, float f3, float f4, float f5) {
        float f6 = -32768.0f;
        f6 = f == f2 ? f3 : (f == f4 ? f5 : (float)((double)f3 + (double)(f5 - f3) / Math.log(f4 / f2) * Math.log(f / f2)));
        return f6;
    }

    public static float oneDigit(float f) {
        int n = (int)(f * 10.0f);
        float f2 = (float)n / 10.0f;
        return f2;
    }

    public static float twoDigits(float f) {
        int n = (int)(f * 100.0f);
        float f2 = (float)n / 100.0f;
        return f2;
    }

    public static float threeDigits(float f) {
        int n = (int)(f * 1000.0f);
        float f2 = (float)n / 1000.0f;
        return f2;
    }

    public static float fourDigits(float f) {
        int n = (int)(f * 10000.0f);
        float f2 = (float)n / 10000.0f;
        return f2;
    }

    public static float significantDigits(float f, int n) {
        int n2 = (int)Math.pow(10.0, n);
        int n3 = (int)(f * (float)n2);
        float f2 = (float)n3 / (float)n2;
        return f2;
    }

    public static String dateToString(int n, int n2, int n3) {
        String string = EdgeUtils.getMonthString(n2) + " " + n3 + ", " + n;
        return string;
    }

    public static String getMonthString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "January";
                break;
            }
            case 2: {
                string = "February";
                break;
            }
            case 3: {
                string = "March";
                break;
            }
            case 4: {
                string = "April";
                break;
            }
            case 5: {
                string = "May";
                break;
            }
            case 6: {
                string = "June";
                break;
            }
            case 7: {
                string = "July";
                break;
            }
            case 8: {
                string = "August";
                break;
            }
            case 9: {
                string = "September";
                break;
            }
            case 10: {
                string = "October";
                break;
            }
            case 11: {
                string = "November";
                break;
            }
            case 12: {
                string = "December";
            }
        }
        return string;
    }

    public static void adjustTableColumnPreferredWidths(JTable jTable) {
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 0);
    }

    public static void adjustTableColumnPreferredWidths(JTable jTable, int n) {
        n = Math.max(n, 0);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            Component component;
            Object object;
            TableCellRenderer tableCellRenderer;
            int n2 = 0;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                tableCellRenderer = jTable.getCellRenderer(j, i);
                object = jTable.getValueAt(j, i);
                component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, j, i);
                n2 = Math.max(component.getPreferredSize().width, n2);
            }
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
            }
            object = tableColumn.getHeaderValue();
            component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, i);
            n2 = Math.max(n2, component.getPreferredSize().width);
            tableColumn.setPreferredWidth(n2 + n);
        }
    }

    public static void adjustTableRowPreferredHeights(JTable jTable) {
        EdgeUtils.adjustTableRowPreferredHeights(jTable, 0);
    }

    public static void adjustTableRowPreferredHeights(JTable jTable, int n) {
        n = Math.max(n, 0);
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n2 = 0;
            for (int j = 0; j < jTable.getColumnCount(); ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, j);
                Object object = jTable.getValueAt(i, j);
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, i, j);
                n2 = Math.max(component.getPreferredSize().height, n2);
            }
            jTable.setRowHeight(i, n2 + n);
        }
    }
}

