/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class PdispGlobals
implements Externalizable {
    static final long serialVersionUID = 1L;
    private int class_version = 1;
    private static boolean variables_initialized;
    private static String[] raob_instrument_types;
    private static String[] cloud_amount_table;
    private static String[] cloud_type_table;
    private static String last_image_file;
    private static String last_rawdata_directory;
    public static final int RAOB_01 = 0;
    public static final int RAOB = 1;
    public static final int ATOVS = 100;
    public static final int ATOVS1000 = 150;
    public static final int HIST_TOVS = 175;
    public static final int EU_ATOVS = 190;
    public static final int GOES = 200;
    public static final int MIRS = 300;
    public static final int MIRS_02 = 301;
    public static final int AIRS_01 = 400;
    public static final int AIRS = 401;
    public static final int COSMIC = 500;
    public static final int COSMIC501 = 501;
    public static final int IASI = 600;
    public static final int EU_IASI = 601;

    public PdispGlobals() {
        if (!variables_initialized) {
            this.initialize();
        }
    }

    public void initialize() {
        this.readRaobTypes();
        this.readCloudAmounts();
        this.readCloudTypes();
        last_image_file = "";
        try {
            last_rawdata_directory = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        variables_initialized = true;
    }

    public void setLastImageFile(String string) {
        last_image_file = string;
    }

    public String getLastImageFile() {
        return last_image_file;
    }

    public void setLastRawDataDirectory(String string) {
        last_rawdata_directory = string;
    }

    public String getLastRawDataDirectory() {
        return last_rawdata_directory;
    }

    public String getRaobInstrumentType(int n) {
        int n2 = Math.max(n, 0);
        n2 = Math.min(n, raob_instrument_types.length - 1);
        return raob_instrument_types[n2];
    }

    public String getCloudAmount(int n) {
        int n2 = Math.max(n, 0);
        n2 = Math.min(n, cloud_amount_table.length - 1);
        return cloud_amount_table[n2];
    }

    public String getRaobCloudType(int n) {
        int n2 = Math.max(n, 0);
        n2 = Math.min(n, cloud_type_table.length - 1);
        return cloud_type_table[n2];
    }

    private void readRaobTypes() {
        raob_instrument_types = new String[256];
        for (int i = 0; i < 256; ++i) {
            PdispGlobals.raob_instrument_types[i] = "Undefined";
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("data/raob_types.dat");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Vector<String> vector = new Vector<String>(512);
            String string = " ";
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                vector.add(string);
            }
            int n = vector.size() / 2;
            raob_instrument_types = new String[n];
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.elementAt(i * 2);
                PdispGlobals.raob_instrument_types[i] = (String)vector.elementAt(i * 2 + 1);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void readCloudAmounts() {
        cloud_amount_table = new String[16];
        for (int i = 0; i < 16; ++i) {
            PdispGlobals.cloud_amount_table[i] = "Undefined";
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("data/cloud_amounts.txt");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Vector<String> vector = new Vector<String>(512);
            String string = " ";
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                vector.add(string);
            }
            int n = vector.size() / 2;
            cloud_amount_table = new String[n];
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.elementAt(i * 2);
                PdispGlobals.cloud_amount_table[i] = (String)vector.elementAt(i * 2 + 1);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void readCloudTypes() {
        cloud_type_table = new String[64];
        for (int i = 0; i < 64; ++i) {
            PdispGlobals.cloud_type_table[i] = "Undefined";
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("data/cloud_types.txt");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Vector<String> vector = new Vector<String>(512);
            String string = " ";
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                vector.add(string);
            }
            int n = vector.size() / 2;
            cloud_type_table = new String[n];
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.elementAt(i * 2);
                PdispGlobals.cloud_type_table[i] = (String)vector.elementAt(i * 2 + 1);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.class_version);
        objectOutput.writeObject(last_image_file);
        objectOutput.writeObject(last_rawdata_directory);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.initialize();
        int n = objectInput.readInt();
        switch (n) {
            case 1: {
                this.readVersion01(objectInput);
            }
        }
    }

    private void readVersion01(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        last_image_file = (String)objectInput.readObject();
        last_rawdata_directory = (String)objectInput.readObject();
    }
}

