/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class RaobRecordVersion01
extends DataGroup {
    private short[] buffer;
    private int data_group_type;
    private String data_group_name;
    private boolean contains_data;
    private float TOP_MOISTURE_PRESSURE = 200.0f;

    public RaobRecordVersion01(short[] sArray, String string, int n) {
        this.data_group_name = string;
        this.data_group_type = n;
        this.addDataBuffer(sArray);
    }

    public RaobRecordVersion01(String string, int n) {
        this.contains_data = false;
        this.data_group_name = string;
        this.data_group_type = n;
    }

    public RaobRecordVersion01() {
        this.contains_data = false;
    }

    public void addDataBuffer(short[] sArray) {
        this.buffer = new short[2000];
        this.contains_data = false;
        for (int i = 0; i < 2000; ++i) {
            this.buffer[i] = sArray[i];
            if (this.buffer[i] == Short.MIN_VALUE) continue;
            this.contains_data = true;
        }
    }

    public boolean containsData() {
        return this.contains_data;
    }

    private boolean usesNewPressureLevels() {
        boolean bl = false;
        if (this.buffer[10] == 1) {
            bl = true;
        }
        return bl;
    }

    public int getGroupType() {
        return this.data_group_type;
    }

    public String getGroupDescription() {
        return "Radiosonde " + this.getRaobID();
    }

    public String getExtraGroupInfo() {
        String string = " (" + this.getInstrumentType() + ")";
        return string;
    }

    public String getRaobID() {
        char c;
        char[] cArray = new char[6];
        short s = this.buffer[29];
        cArray[0] = c = (char)(s / 100);
        cArray[1] = c = (char)(s % 100);
        s = this.buffer[30];
        cArray[2] = c = (char)(s / 100);
        cArray[3] = c = (char)(s % 100);
        s = this.buffer[31];
        cArray[4] = c = (char)(s / 100);
        cArray[5] = c = (char)(s % 100);
        String string = new String(cArray);
        return string;
    }

    public float getLatitude() {
        float f = (float)this.buffer[39] / 128.0f;
        return f;
    }

    public float getLongitude() {
        float f = (float)this.buffer[40] / 128.0f;
        return f;
    }

    public int getDistance() {
        return this.buffer[26];
    }

    public String getTimeString() {
        int n = this.buffer[38] / 100;
        String string = "" + n;
        if (n < 10) {
            string = "0" + string;
        }
        int n2 = this.buffer[38] % 100;
        String string2 = "" + n2;
        if (n2 < 10) {
            string2 = "0" + n2;
        }
        String string3 = "" + string + ":" + string2;
        return string3;
    }

    public int getTime() {
        int n = this.buffer[38] * 100;
        return n;
    }

    public int getRaobTimeFlag() {
        int n = Short.MIN_VALUE;
        int n2 = this.buffer[38] / 100;
        if (n2 >= 21 && n2 <= 24) {
            n = 1;
        } else if (n2 >= 0 && n2 < 3) {
            n = 1;
        } else if (n2 >= 3 && n2 < 9) {
            n = 2;
        } else if (n2 >= 9 && n2 < 15) {
            n = 3;
        } else if (n2 >= 15 && n2 < 21) {
            n = 4;
        }
        return n;
    }

    public String getDateString() {
        int n;
        short s = this.buffer[36];
        short s2 = this.buffer[37];
        String string = "" + s + "/";
        if (s2 < 10) {
            string = string + "0";
        }
        if ((n = this.buffer[35]) < 2000) {
            n += 2000;
        }
        string = string + s2 + "/" + n;
        return string;
    }

    public int getDate() {
        int n = this.buffer[35] * 10000 + this.buffer[36] * 100 + this.buffer[37];
        return n;
    }

    public int getTerrain() {
        int n = this.buffer[44];
        if (n < 0 || n > 4) {
            n = 5;
        }
        return n;
    }

    public String getTerrainString() {
        String string = "Unknown";
        int n = this.getTerrain();
        switch (n) {
            case 0: {
                string = "Island Coast";
                break;
            }
            case 1: {
                string = "Mainland Inland";
                break;
            }
            case 2: {
                string = "Mainland Coast";
                break;
            }
            case 3: {
                string = "Island Inland";
                break;
            }
            case 4: {
                string = "Ship";
            }
        }
        return string;
    }

    public boolean hasSeaNonseaValue() {
        return false;
    }

    public int getSeaNonseaValue() {
        return Short.MIN_VALUE;
    }

    public boolean hasQCFlag() {
        return false;
    }

    public boolean getQCFlag() {
        return true;
    }

    public boolean hasCloudFlag() {
        return false;
    }

    public int getCloudFlag() {
        return Short.MIN_VALUE;
    }

    public boolean hasDayNightFlag() {
        return false;
    }

    public int getDayNightFlag() {
        return Short.MIN_VALUE;
    }

    public int[] getRaobNetworkFlags() {
        int[] nArray = new int[]{this.buffer[159], this.buffer[160], this.buffer[161]};
        return nArray;
    }

    public float getSurfacePressure() {
        return (float)this.buffer[153] / 1.0f;
    }

    public Vector getSurfaceData() {
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this.getGroupDescription());
        float f = this.getSurfacePressure();
        if (f <= 0.0f) {
            f = -32768.0f;
        }
        vector.add(new Float(f));
        PressureLevels pressureLevels = new PressureLevels();
        int n = pressureLevels.getPressureLevel(f);
        if (this.usesNewPressureLevels()) {
            n = pressureLevels.getNewAtovsTempPressureLevel(f);
        }
        vector.add(new Float(-32768.0f));
        int n2 = this.getTerrain();
        vector.add(new Integer(n2));
        return vector;
    }

    public Vector getCloudTopData() {
        Vector<Object> vector = new Vector<Object>(5);
        vector.add(this.getGroupDescription());
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Float(-32768.0f));
        vector.add(new Boolean(false));
        return vector;
    }

    public int getInstrumentType() {
        return this.buffer[43];
    }

    public int[] getRadiationCorrectionFlags() {
        int[] nArray = new int[]{this.buffer[11], 3};
        return nArray;
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[]{"Radiosonde", "   Forecast", "   Std Observed", "   Std Radcor", "   Sig Observed", "   Sig Radcor"};
        return stringArray;
    }

    public int[] getProfileTypes() {
        int[] nArray = new int[]{0, 2, 10, 11, 15, 16};
        return nArray;
    }

    public Profile[] getTemperatureProfiles() {
        Profile[] profileArray = new Profile[6];
        if (!this.containsData()) {
            for (int i = 0; i < profileArray.length; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            int n2;
            float f;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = this.getSurfacePressure();
            profileArray[0] = new Profile(0, "Radiosonde", 0, Color.black, 1, 0);
            float[] fArray = this.getTemperatures();
            for (int i = 0; i < 42; ++i) {
                if (fArray[i] == -999.99f) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsTempPressure(i + 1) : pressureLevels.getPressure(i + 1);
                profileArray[0].addItem(f, fArray[i]);
            }
            profileArray[0].setSurfacePressure(f2);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   Forecast", 0, Color.black, 1, 0);
            float[] fArray2 = this.getInterpolatedFcstTemperatures();
            for (int i = 0; i < 42; ++i) {
                if (fArray2[i] == -999.99f) continue;
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsTempPressure(i + 1) : pressureLevels.getPressure(i + 1);
                profileArray[1].addItem(f, fArray2[i]);
            }
            profileArray[1].setSurfacePressure(f2);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
            profileArray[2] = new Profile(0, "   Std Observed", 0, Color.black, 1, 0);
            float[] fArray3 = this.getStandardTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                if (!(fArray3[n2] > 0.0f)) continue;
                profileArray[2].addItem(pressureLevels.getStdPressure(n2 + 1), fArray3[n2]);
            }
            profileArray[2].setSurfacePressure(f2);
            profileArray[2].trimProfile();
            if (profileArray[2].getNumberOfPoints() == 0) {
                profileArray[2] = null;
            }
            profileArray[3] = new Profile(0, "   Std Radcor", 0, Color.black, 1, 0);
            fArray3 = this.getStandardRadcorTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                if (!(fArray3[n2] > 0.0f)) continue;
                profileArray[3].addItem(pressureLevels.getStdPressure(n2 + 1), fArray3[n2]);
            }
            profileArray[3].setSurfacePressure(f2);
            profileArray[3].trimProfile();
            if (profileArray[3].getNumberOfPoints() == 0) {
                profileArray[3] = null;
            }
            n2 = this.getNumSigLevels();
            float[] fArray4 = this.getSigPressures();
            profileArray[4] = new Profile(0, "   Sig Observed", 0, Color.black, 1, 0);
            float[] fArray5 = this.getSigTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray4[n] > 0.0f) || !(fArray5[n] > 0.0f)) continue;
                profileArray[4].addItem(fArray4[n], fArray5[n]);
            }
            profileArray[4].setSurfacePressure(f2);
            profileArray[4].trimProfile();
            if (profileArray[4].getNumberOfPoints() == 0) {
                profileArray[4] = null;
            }
            profileArray[5] = new Profile(0, "   Sig Radcor", 0, Color.black, 1, 0);
            fArray5 = this.getSigRadcorTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray4[n] > 0.0f) || !(fArray5[n] > 0.0f)) continue;
                profileArray[5].addItem(fArray4[n], fArray5[n]);
            }
            profileArray[5].setSurfacePressure(f2);
            profileArray[5].trimProfile();
            if (profileArray[5].getNumberOfPoints() == 0) {
                profileArray[5] = null;
            }
        }
        return profileArray;
    }

    public Profile[] getDewpointProfiles() {
        Profile[] profileArray = new Profile[6];
        if (!this.containsData()) {
            for (int i = 0; i < profileArray.length; ++i) {
                profileArray[i] = null;
            }
        } else {
            int n;
            int n2;
            float f;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = this.getSurfacePressure();
            profileArray[0] = new Profile(0, "Radiosonde", 0, Color.black, 1, 1);
            float[] fArray = this.getDewpoints();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(f, fArray[i]);
            }
            profileArray[0].setSurfacePressure(f2);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   Forecast", 0, Color.black, 1, 1);
            float[] fArray2 = this.getInterpolatedFcstWaterVapors();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray2[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                float f3 = EdgeUtils.convertToDewPoint(fArray2[i], f);
                profileArray[1].addItem(f, f3);
            }
            profileArray[1].setSurfacePressure(f2);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
            profileArray[2] = new Profile(0, "   Std Observed", 0, Color.black, 1, 1);
            float[] fArray3 = this.getStandardDewpointTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                f = pressureLevels.getStdPressure(n2 + 1);
                if (!(fArray3[n2] > 0.0f) || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[2].addItem(f, fArray3[n2]);
            }
            profileArray[2].setSurfacePressure(f2);
            profileArray[2].trimProfile();
            if (profileArray[2].getNumberOfPoints() == 0) {
                profileArray[2] = null;
            }
            profileArray[3] = new Profile(0, "   Std Radcor", 0, Color.black, 1, 1);
            fArray3 = this.getStandardRadcorDewpointTemperatures();
            for (n2 = 17; n2 >= 0; --n2) {
                f = pressureLevels.getStdPressure(n2 + 1);
                if (!(fArray3[n2] > 0.0f) || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[3].addItem(f, fArray3[n2]);
            }
            profileArray[3].setSurfacePressure(f2);
            profileArray[3].trimProfile();
            if (profileArray[3].getNumberOfPoints() == 0) {
                profileArray[3] = null;
            }
            n2 = this.getNumSigLevels();
            float[] fArray4 = this.getSigPressures();
            profileArray[4] = new Profile(0, "   Sig Observed", 0, Color.black, 1, 1);
            float[] fArray5 = this.getSigDewpointTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray4[n] > 0.0f) || !(fArray4[n] >= this.TOP_MOISTURE_PRESSURE) || !(fArray5[n] > 0.0f)) continue;
                profileArray[4].addItem(fArray4[n], fArray5[n]);
            }
            profileArray[4].setSurfacePressure(f2);
            profileArray[4].trimProfile();
            if (profileArray[4].getNumberOfPoints() == 0) {
                profileArray[4] = null;
            }
            profileArray[5] = new Profile(0, "   Sig Radcor", 0, Color.black, 1, 1);
            fArray5 = this.getSigRadcorDewpointTemperatures();
            for (n = n2 - 1; n >= 0; --n) {
                if (!(fArray4[n] > 0.0f) || !(fArray4[n] >= this.TOP_MOISTURE_PRESSURE) || !(fArray5[n] > 0.0f)) continue;
                profileArray[5].addItem(fArray4[n], fArray5[n]);
            }
            profileArray[5].setSurfacePressure(f2);
            profileArray[5].trimProfile();
            if (profileArray[5].getNumberOfPoints() == 0) {
                profileArray[5] = null;
            }
        }
        return profileArray;
    }

    private Profile[] getWaterVaporProfiles() {
        Profile[] profileArray = new Profile[6];
        for (int i = 0; i < 6; ++i) {
            profileArray[i] = null;
        }
        if (this.containsData()) {
            float f;
            PressureLevels pressureLevels = new PressureLevels();
            float f2 = this.getSurfacePressure();
            profileArray[0] = new Profile(0, "Radiosonde", 0, Color.black, 1, 1);
            float[] fArray = this.getWaterVapors();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[0].addItem(f, fArray[i]);
            }
            profileArray[0].setSurfacePressure(f2);
            profileArray[0].trimProfile();
            if (profileArray[0].getNumberOfPoints() == 0) {
                profileArray[0] = null;
            }
            profileArray[1] = new Profile(0, "   Forecast", 0, Color.black, 1, 1);
            float[] fArray2 = this.getInterpolatedFcstWaterVapors();
            for (int i = 0; i < 19; ++i) {
                f = this.usesNewPressureLevels() ? pressureLevels.getNewAtovsMoisturePressure(i + 1) : pressureLevels.getWVPressure(i + 1);
                if (fArray2[i] == -999.99f || !(f >= this.TOP_MOISTURE_PRESSURE)) continue;
                profileArray[1].addItem(f, fArray2[i]);
            }
            profileArray[1].setSurfacePressure(f2);
            profileArray[1].trimProfile();
            if (profileArray[1].getNumberOfPoints() == 0) {
                profileArray[1] = null;
            }
        }
        return profileArray;
    }

    public float getDataValue(int n, float f) {
        float f2 = -32768.0f;
        float f3 = this.getSurfacePressure();
        if (f3 == -999.99f || f <= f3) {
            if (n == 3 || n == 4 || n == 5) {
                f2 = -32768.0f;
            } else if (n == 0 || n == 6) {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getPressures();
                if (this.usesNewPressureLevels()) {
                    fArray = pressureLevels.getNewAtovsTempPressures();
                }
                float[] fArray2 = this.getTemperatures();
                if (n == 6) {
                    fArray2 = this.getInterpolatedFcstTemperatures();
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray2, fArray);
            } else {
                PressureLevels pressureLevels = new PressureLevels();
                float[] fArray = pressureLevels.getWVPressures();
                if (this.usesNewPressureLevels()) {
                    fArray = pressureLevels.getNewAtovsMoisturePressures();
                }
                float[] fArray3 = this.getWaterVapors();
                if (n == 7 || n == 8) {
                    fArray3 = this.getInterpolatedFcstWaterVapors();
                }
                for (int i = 0; i < fArray3.length; ++i) {
                    if (fArray3[i] == -999.99f) continue;
                    fArray3[i] = EdgeUtils.convertToDewPoint(fArray3[i], fArray[i]);
                }
                f2 = EdgeUtils.interpolateTemperature(f, fArray3, fArray);
                if (f2 != -32768.0f && (n == 1 || n == 7)) {
                    f2 = EdgeUtils.convertToMixingRatio(f, f2);
                }
            }
        }
        return f2;
    }

    public Vector[] getDataForVstats(int n) {
        int n2;
        int n3;
        Vector[] vectorArray = new Vector[6];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray[i] = new Vector(4);
        }
        PressureLevels pressureLevels = new PressureLevels();
        float[] fArray = pressureLevels.getPressures();
        float[] fArray2 = pressureLevels.getWVPressures();
        float[] fArray3 = pressureLevels.getStdPressures();
        if (this.usesNewPressureLevels()) {
            fArray = pressureLevels.getNewAtovsTempPressures();
            fArray2 = pressureLevels.getNewAtovsMoisturePressures();
        }
        float f = (float)this.buffer[182] / 10.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            fArray[i] = -999.99f;
        }
        if (n == 0) {
            float f2 = (float)this.buffer[181] / 10.0f;
            for (int i = 0; i < fArray2.length; ++i) {
                if (!(fArray2[i] < f2)) continue;
                fArray2[i] = -999.99f;
            }
        }
        float[] fArray4 = this.getTemperatures();
        float[] fArray5 = this.getDewpoints();
        vectorArray[0].add(fArray);
        vectorArray[0].add(fArray4);
        vectorArray[0].add(fArray2);
        vectorArray[0].add(fArray5);
        float[] fArray6 = this.getInterpolatedFcstTemperatures();
        float[] fArray7 = this.getInterpolatedFcstWaterVapors();
        float[] fArray8 = new float[fArray7.length];
        for (int i = 0; i < fArray7.length; ++i) {
            fArray8[i] = fArray7[i] != -999.99f ? EdgeUtils.convertToDewPoint(fArray7[i], fArray2[i]) : -999.99f;
        }
        vectorArray[1].add(fArray);
        vectorArray[1].add(fArray6);
        vectorArray[1].add(fArray2);
        vectorArray[1].add(fArray8);
        float[] fArray9 = new float[fArray3.length];
        for (int i = 0; i < fArray3.length; ++i) {
            fArray9[i] = fArray3[fArray3.length - 1 - i];
        }
        fArray4 = this.getStandardTemperatures();
        float[] fArray10 = new float[fArray4.length];
        for (int i = 0; i < fArray4.length; ++i) {
            fArray10[i] = fArray4[fArray4.length - 1 - i];
        }
        fArray5 = this.getStandardDewpointTemperatures();
        float[] fArray11 = new float[fArray5.length];
        for (n3 = 0; n3 < fArray5.length; ++n3) {
            fArray11[n3] = fArray5[fArray5.length - 1 - n3];
        }
        vectorArray[2].add(fArray9);
        vectorArray[2].add(fArray10);
        vectorArray[2].add(fArray9);
        vectorArray[2].add(fArray11);
        fArray4 = this.getStandardRadcorTemperatures();
        fArray10 = new float[fArray4.length];
        for (n3 = 0; n3 < fArray4.length; ++n3) {
            fArray10[n3] = fArray4[fArray4.length - 1 - n3];
        }
        fArray5 = this.getStandardRadcorDewpointTemperatures();
        fArray11 = new float[fArray5.length];
        for (n3 = 0; n3 < fArray5.length; ++n3) {
            fArray11[n3] = fArray5[fArray5.length - 1 - n3];
        }
        vectorArray[3].add(fArray9);
        vectorArray[3].add(fArray10);
        vectorArray[3].add(fArray9);
        vectorArray[3].add(fArray11);
        float[] fArray12 = this.getSigPressures();
        float[] fArray13 = new float[fArray12.length];
        for (n2 = 0; n2 < fArray12.length; ++n2) {
            fArray13[n2] = fArray12[fArray12.length - 1 - n2];
        }
        fArray4 = this.getSigTemperatures();
        fArray10 = new float[fArray4.length];
        for (n2 = 0; n2 < fArray4.length; ++n2) {
            fArray10[n2] = fArray4[fArray4.length - 1 - n2];
        }
        fArray5 = this.getSigDewpointTemperatures();
        fArray11 = new float[fArray5.length];
        for (n2 = 0; n2 < fArray5.length; ++n2) {
            fArray11[n2] = fArray5[fArray5.length - 1 - n2];
        }
        vectorArray[4].add(fArray13);
        vectorArray[4].add(fArray10);
        vectorArray[4].add(fArray13);
        vectorArray[4].add(fArray11);
        fArray4 = this.getSigRadcorTemperatures();
        fArray10 = new float[fArray4.length];
        for (n2 = 0; n2 < fArray4.length; ++n2) {
            fArray10[n2] = fArray4[fArray4.length - 1 - n2];
        }
        fArray5 = this.getSigRadcorDewpointTemperatures();
        fArray11 = new float[fArray5.length];
        for (n2 = 0; n2 < fArray5.length; ++n2) {
            fArray11[n2] = fArray5[fArray5.length - 1 - n2];
        }
        vectorArray[5].add(fArray13);
        vectorArray[5].add(fArray10);
        vectorArray[5].add(fArray13);
        vectorArray[5].add(fArray11);
        return vectorArray;
    }

    private float[] getTemperatures() {
        float[] fArray = new float[42];
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.getTemperatureValue(i);
        }
        return fArray;
    }

    private float getTemperatureValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 71] != Short.MIN_VALUE) {
            f = (float)this.buffer[n + 71] / 64.0f;
        }
        return f;
    }

    private float[] getWaterVapors() {
        float[] fArray = new float[19];
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.getWaterVaporValue(i);
        }
        return fArray;
    }

    private float getWaterVaporValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 113] != Short.MIN_VALUE) {
            f = (float)Math.exp((double)this.buffer[n + 113] / 1024.0);
        }
        return f;
    }

    private float[] getDewpoints() {
        float[] fArray = new float[19];
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.getDewpointValue(i);
        }
        return fArray;
    }

    private float getDewpointValue(int n) {
        float f = -999.99f;
        if (this.buffer[n + 132] != Short.MIN_VALUE) {
            f = (float)this.buffer[n + 132] / 64.0f;
        }
        return f;
    }

    private float[] getInterpolatedFcstTemperatures() {
        float[] fArray = new float[42];
        for (int i = 0; i < 42; ++i) {
            fArray[i] = this.buffer[i + 1729] != Short.MIN_VALUE ? (float)this.buffer[i + 1729] / 64.0f : -999.99f;
        }
        float[] fArray2 = this.getInterpolatedFcstWaterVapors();
        for (int i = 23; i < 42; ++i) {
            if (fArray[i] == -999.99f || fArray2[i - 23] == -999.99f) continue;
            fArray[i] = fArray[i] / (1.0f + 0.61f * (fArray2[i - 23] / 1000.0f));
        }
        return fArray;
    }

    private float[] getInterpolatedFcstWaterVapors() {
        float[] fArray = new float[19];
        for (int i = 0; i < 19; ++i) {
            fArray[i] = this.buffer[i + 1771] != Short.MIN_VALUE ? (float)Math.exp((double)this.buffer[i + 1771] / 1024.0) : -999.99f;
        }
        return fArray;
    }

    private float[] getStandardTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 194] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 194] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getStandardRadcorTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 212] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 212] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getStandardForecastTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 230] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 230] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getStandardDewpointTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 248] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 248] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getStandardRadcorDewpointTemperatures() {
        float[] fArray = new float[18];
        for (int i = 0; i < 18; ++i) {
            fArray[i] = this.buffer[i + 266] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 266] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getStandardForecastDewpointTemperatures() {
        float[] fArray = new float[18];
        PressureLevels pressureLevels = new PressureLevels();
        for (int i = 0; i < 18; ++i) {
            if (this.buffer[i + 284] != Short.MIN_VALUE) {
                float f = (float)Math.exp((double)this.buffer[i + 284] / 1024.0);
                float f2 = pressureLevels.getStdPressure(i + 1);
                fArray[i] = EdgeUtils.convertToDewPoint(f, f2);
                continue;
            }
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private int getNumSigLevels() {
        return this.buffer[428];
    }

    private float[] getSigPressures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 429] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 429] / 10.0f;
        }
        return fArray;
    }

    private float[] getSigTemperatures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 529] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 529] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getSigRadcorTemperatures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 629] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 629] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getSigForecastTemperatures() {
        float[] fArray = new float[100];
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 729] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 729] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getSigDewpointTemperatures() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getSigTemperatures();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 829] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 829] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getSigRadcorDewpointTemperatures() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getSigTemperatures();
        for (int i = 0; i < 100; ++i) {
            fArray[i] = this.buffer[i + 929] == Short.MIN_VALUE ? -999.99f : (float)this.buffer[i + 929] / 10.0f + 273.16f;
        }
        return fArray;
    }

    private float[] getSigForecastDewpointTemperatures() {
        float[] fArray = new float[100];
        float[] fArray2 = this.getSigTemperatures();
        float[] fArray3 = this.getSigPressures();
        for (int i = 0; i < 100; ++i) {
            if (fArray2[i] != -999.99f && fArray3[i] != -999.99f) {
                if (this.buffer[i + 1029] != Short.MIN_VALUE) {
                    float f = (float)Math.exp((double)this.buffer[i + 1029] / 1024.0);
                    fArray[i] = EdgeUtils.convertToDewPoint(f, fArray3[i]);
                    continue;
                }
                fArray[i] = -999.99f;
                continue;
            }
            fArray[i] = -999.99f;
        }
        return fArray;
    }

    private float[][] getCategory1Data() {
        float[][] fArray = new float[18][12];
        for (int i = 0; i < 18; ++i) {
            fArray[i][0] = this.buffer[194 + i] != Short.MIN_VALUE ? (float)this.buffer[194 + i] / 10.0f : -999.99f;
            fArray[i][1] = this.buffer[212 + i] != Short.MIN_VALUE ? (float)this.buffer[212 + i] / 10.0f : -999.99f;
            fArray[i][2] = this.buffer[230 + i] != Short.MIN_VALUE ? (float)this.buffer[230 + i] / 10.0f : -999.99f;
            fArray[i][3] = this.buffer[248 + i] != Short.MIN_VALUE ? (float)this.buffer[248 + i] / 10.0f : -999.99f;
            fArray[i][4] = this.buffer[266 + i] != Short.MIN_VALUE ? (float)this.buffer[266 + i] / 10.0f : -999.99f;
            fArray[i][5] = this.buffer[284 + i] != Short.MIN_VALUE ? (float)Math.exp((float)this.buffer[266 + i] / 1024.0f) : -999.99f;
            fArray[i][6] = this.buffer[302 + i] != Short.MIN_VALUE ? (float)this.buffer[302 + i] / 1.0f : -999.99f;
            fArray[i][7] = this.buffer[320 + i] != Short.MIN_VALUE ? (float)this.buffer[320 + i] / 128.0f : -999.99f;
            fArray[i][8] = this.buffer[338 + i] != Short.MIN_VALUE ? (float)this.buffer[338 + i] / 128.0f : -999.99f;
            fArray[i][9] = this.buffer[356 + i] != Short.MIN_VALUE ? (float)this.buffer[356 + i] / 1.0f : -999.99f;
            fArray[i][10] = this.buffer[374 + i] != Short.MIN_VALUE ? (float)this.buffer[374 + i] / 1.0f : -999.99f;
            fArray[i][11] = this.buffer[410 + i] != Short.MIN_VALUE ? (float)this.buffer[410 + i] / 1.0f : -999.99f;
            if (fArray[i][2] == -999.99f || fArray[i][5] == -999.99f) continue;
            fArray[i][2] = (fArray[i][2] + 273.15f) / (1.0f + 0.61f * (fArray[i][5] / 1000.0f));
            fArray[i][2] = fArray[i][2] - 273.15f;
        }
        return fArray;
    }

    private float[][] getCategory2Data() {
        float[][] fArray = new float[100][14];
        for (int i = 0; i < 100; ++i) {
            fArray[i][0] = this.buffer[429 + i] != Short.MIN_VALUE ? (float)this.buffer[429 + i] / 10.0f : -999.99f;
            fArray[i][1] = this.buffer[529 + i] != Short.MIN_VALUE ? (float)this.buffer[529 + i] / 10.0f : -999.99f;
            fArray[i][2] = this.buffer[629 + i] != Short.MIN_VALUE ? (float)this.buffer[629 + i] / 10.0f : -999.99f;
            fArray[i][3] = this.buffer[729 + i] != Short.MIN_VALUE ? (float)this.buffer[729 + i] / 10.0f : -999.99f;
            fArray[i][4] = this.buffer[829 + i] != Short.MIN_VALUE ? (float)this.buffer[829 + i] / 10.0f : -999.99f;
            fArray[i][5] = this.buffer[929 + i] != Short.MIN_VALUE ? (float)this.buffer[929 + i] / 10.0f : -999.99f;
            fArray[i][6] = this.buffer[1029 + i] != Short.MIN_VALUE ? (float)Math.exp((float)this.buffer[1029 + i] / 1024.0f) : -999.99f;
            fArray[i][7] = this.buffer[1129 + i] != Short.MIN_VALUE ? (float)this.buffer[1129 + i] / 1.0f : -999.99f;
            fArray[i][8] = this.buffer[1229 + i] != Short.MIN_VALUE ? (float)this.buffer[1229 + i] / 128.0f : -999.99f;
            fArray[i][9] = this.buffer[1329 + i] != Short.MIN_VALUE ? (float)this.buffer[1329 + i] / 128.0f : -999.99f;
            fArray[i][10] = this.buffer[1429 + i] != Short.MIN_VALUE ? (float)this.buffer[1429 + i] / 1.0f : -999.99f;
            fArray[i][11] = this.buffer[1529 + i] != Short.MIN_VALUE ? (float)this.buffer[1529 + i] / 1.0f : -999.99f;
            fArray[i][12] = this.buffer[1629 + i] != Short.MIN_VALUE ? (float)this.buffer[1629 + i] / 1.0f : -999.99f;
            fArray[i][13] = this.buffer[1829 + i] != Short.MIN_VALUE ? (float)this.buffer[1829 + i] / 1.0f : -999.99f;
            if (fArray[i][3] == -999.99f || fArray[i][6] == -999.99f) continue;
            fArray[i][3] = (fArray[i][3] + 273.15f) / (1.0f + 0.61f * (fArray[i][6] / 1000.0f));
            fArray[i][3] = fArray[i][3] - 273.15f;
        }
        return fArray;
    }

    private float[][] getCategory5Data() {
        float[][] fArray = new float[2][14];
        for (int i = 0; i < 2; ++i) {
            fArray[i][0] = this.buffer[1929 + i] != Short.MIN_VALUE ? (float)this.buffer[1929 + i] / 10.0f : -999.99f;
            fArray[i][1] = this.buffer[1931 + i] != Short.MIN_VALUE ? (float)this.buffer[1931 + i] / 10.0f : -999.99f;
            fArray[i][2] = this.buffer[1933 + i] != Short.MIN_VALUE ? (float)this.buffer[1933 + i] / 10.0f : -999.99f;
            fArray[i][3] = this.buffer[1935 + i] != Short.MIN_VALUE ? (float)this.buffer[1935 + i] / 10.0f : -999.99f;
            fArray[i][4] = this.buffer[1937 + i] != Short.MIN_VALUE ? (float)this.buffer[1937 + i] / 10.0f : -999.99f;
            fArray[i][5] = this.buffer[1939 + i] != Short.MIN_VALUE ? (float)this.buffer[1939 + i] / 10.0f : -999.99f;
            fArray[i][6] = this.buffer[1941 + i] != Short.MIN_VALUE ? (float)Math.exp((float)this.buffer[1941 + i] / 1024.0f) : -999.99f;
            fArray[i][7] = this.buffer[1943 + i] != Short.MIN_VALUE ? (float)this.buffer[1943 + i] / 1.0f : -999.99f;
            fArray[i][8] = this.buffer[1945 + i] != Short.MIN_VALUE ? (float)this.buffer[1945 + i] / 128.0f : -999.99f;
            fArray[i][9] = this.buffer[1947 + i] != Short.MIN_VALUE ? (float)this.buffer[1947 + i] / 128.0f : -999.99f;
            fArray[i][10] = this.buffer[1949 + i] != Short.MIN_VALUE ? (float)this.buffer[1949 + i] / 1.0f : -999.99f;
            fArray[i][11] = this.buffer[1951 + i] != Short.MIN_VALUE ? (float)this.buffer[1951 + i] / 1.0f : -999.99f;
            fArray[i][12] = this.buffer[1953 + i] != Short.MIN_VALUE ? (float)this.buffer[1953 + i] / 1.0f : -999.99f;
            fArray[i][13] = this.buffer[1957 + i] != Short.MIN_VALUE ? (float)this.buffer[1957 + i] / 1.0f : -999.99f;
        }
        return fArray;
    }

    public int[] getTier1Flags() {
        int[] nArray = new int[]{this.buffer[48], this.buffer[50], this.buffer[67], this.buffer[183], Short.MIN_VALUE};
        return nArray;
    }

    public int getTier2Flag() {
        return this.buffer[52];
    }

    public int getTier3Flag() {
        return this.buffer[51];
    }

    public int getRaobDriftDataFlag() {
        int n;
        float[] fArray = this.getDriftPositions();
        int n2 = (int)fArray[0];
        boolean bl = false;
        float f = fArray[5];
        float f2 = fArray[123];
        for (n = 1; n < n2; ++n) {
            if (fArray[5 + n] == f && fArray[123 + n] == f2) continue;
            bl = true;
        }
        n = 0;
        if (!bl) {
            n = 1;
        }
        return n;
    }

    public int getSondeType() {
        int n = 0;
        int n2 = this.getInstrumentType();
        if (n2 == 96 || n2 == 31) {
            n = 1;
        }
        return n;
    }

    public float[] getDriftPositions() {
        int n;
        float[][] fArray = this.getCategory1Data();
        PressureLevels pressureLevels = new PressureLevels();
        float[][] fArray2 = new float[18][4];
        int n2 = 0;
        for (int i = 0; i < 18; ++i) {
            if (fArray[i][6] == -999.99f) continue;
            fArray2[n2][0] = pressureLevels.getStdPressure(i + 1);
            fArray2[n2][1] = fArray[i][6];
            fArray2[n2][2] = fArray[i][7];
            fArray2[n2][3] = fArray[i][8];
            ++n2;
        }
        float[][] fArray3 = this.getCategory2Data();
        float[][] fArray4 = new float[100][4];
        int n3 = 0;
        int n4 = this.getNumSigLevels();
        for (int i = 0; i < n4; ++i) {
            if (fArray3[i][0] == -999.99f) continue;
            fArray4[n3][0] = fArray3[i][0];
            fArray4[n3][1] = fArray3[i][7];
            fArray4[n3][2] = fArray3[i][8];
            fArray4[n3][3] = fArray3[i][9];
            ++n3;
        }
        float[] fArray5 = new float[477];
        for (int i = 0; i < 477; ++i) {
            fArray5[i] = -32768.0f;
        }
        float f = 0.0f;
        float f2 = -32768.0f;
        float f3 = 2000.0f;
        float f4 = -32768.0f;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < n2 + n3; ++n) {
            boolean bl = false;
            bl = n5 >= n2 ? false : (n6 >= n3 ? true : fArray2[n5][0] > fArray4[n6][0]);
            if (bl) {
                fArray5[5 + n] = fArray2[n5][2];
                fArray5[123 + n] = fArray2[n5][3];
                fArray5[241 + n] = fArray2[n5][0];
                fArray5[359 + n] = fArray2[n5][1];
                if (fArray2[n5][0] > f) {
                    f = fArray2[n5][0];
                    f2 = fArray2[n5][1];
                }
                if (fArray2[n5][0] < f3) {
                    f3 = fArray2[n5][0];
                    f4 = fArray2[n5][1];
                }
                ++n5;
                continue;
            }
            fArray5[5 + n] = fArray4[n6][2];
            fArray5[123 + n] = fArray4[n6][3];
            fArray5[241 + n] = fArray4[n6][0];
            fArray5[359 + n] = fArray4[n6][1];
            if (fArray4[n6][0] > f) {
                f = fArray4[n6][0];
                f2 = fArray4[n6][1];
            }
            if (fArray4[n6][0] < f3) {
                f3 = fArray4[n6][0];
                f4 = fArray4[n6][1];
            }
            ++n6;
        }
        if (f2 == -32768.0f) {
            f = -32768.0f;
        }
        if (f4 == -32768.0f) {
            f3 = -32768.0f;
        }
        fArray5[0] = n;
        fArray5[1] = f;
        fArray5[2] = f3;
        fArray5[3] = f2;
        fArray5[4] = f4;
        return fArray5;
    }

    private float getTPW() {
        return EdgeUtils.twoDigits((float)this.buffer[162] / 100.0f);
    }

    public Vector getGroupCollocationInfo() {
        Vector vector = new Vector();
        if (this.contains_data) {
            Vector<String> vector2 = new Vector<String>(5);
            vector2.add("Radiosonde: " + this.getRaobID());
            vector2.add("" + EdgeUtils.twoDigits(this.getLatitude()));
            vector2.add("" + EdgeUtils.twoDigits(this.getLongitude()));
            vector2.add(this.getDateString());
            vector2.add(this.getTimeString() + " Z");
            vector.add(vector2);
        }
        return vector;
    }

    public Vector[] getProfileData() {
        String string = "Radiosonde";
        String[] stringArray = this.getProfileNames();
        Profile[] profileArray = this.getTemperatureProfiles();
        Profile[] profileArray2 = this.getDewpointProfiles();
        Profile[] profileArray3 = this.getWaterVaporProfiles();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            float f;
            int n;
            vectorArray[i] = new Vector(5);
            vectorArray[i].add(string);
            if (i == 0) {
                vectorArray[i].add(" ");
            } else {
                vectorArray[i].add(stringArray[i].trim());
            }
            if (profileArray[i] != null) {
                for (n = 0; n < profileArray[i].getNumberOfPoints(); ++n) {
                    f = profileArray[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray[i]);
            if (profileArray2[i] != null) {
                for (n = 0; n < profileArray2[i].getNumberOfPoints(); ++n) {
                    f = profileArray2[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray2[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray2[i]);
            if (profileArray3[i] != null) {
                for (n = 0; n < profileArray3[i].getNumberOfPoints(); ++n) {
                    f = profileArray3[i].getPressure(n);
                    f = f < 1.0f ? (float)((int)(f * 100.0f)) / 100.0f : (f < 10.0f ? (float)((int)(f * 10.0f)) / 10.0f : (float)((int)f) / 1.0f);
                    profileArray3[i].setPressure(n, f);
                }
            }
            vectorArray[i].add(profileArray3[i]);
        }
        return vectorArray;
    }

    public Vector getDataGroupData() {
        Vector<JLabel> vector = new Vector<JLabel>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Radiosonde</bold></font></html>"));
        vector.add(new JLabel(" "));
        if (!this.contains_data) {
            vector.add(new JLabel(" "));
            vector.add(new JLabel("Radiosonde Not Available"));
            vector.add(new JLabel(" "));
            vector.add(new JLabel("The selected radiosonde was not matched to the other"));
            vector.add(new JLabel("satellite/radiosondes in this collocation."));
        } else {
            Vector vector2 = this.buildParameterTable();
            for (int i = 0; i < vector2.size(); ++i) {
                vector.add((JLabel)vector2.elementAt(i));
            }
            Vector vector3 = this.buildStandardAndSigLevelTable();
            for (int i = 0; i < vector3.size(); ++i) {
                vector.add((JLabel)vector3.elementAt(i));
            }
        }
        return vector;
    }

    private Vector buildParameterTable() {
        Serializable serializable;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("");
        vector2.add("");
        Vector<Serializable> vector3 = new Vector<Serializable>();
        String[][] stringArray = this.getDataStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            serializable = new Vector<String>(2);
            ((Vector)serializable).add(stringArray[i][0]);
            ((Vector)serializable).add(stringArray[i][1]);
            vector3.add(serializable);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jTable.setAutoResizeMode(0);
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 10);
        serializable = new JPanel();
        ((JComponent)serializable).setBackground(Color.white);
        ((Container)serializable).setLayout(new FlowLayout(0));
        ((Container)serializable).add(jTable);
        vector.add(serializable);
        return vector;
    }

    private String[][] getDataStrings() {
        int n;
        int n2;
        String[][] stringArray = new String[78][2];
        for (n2 = 0; n2 < 76; ++n2) {
            stringArray[n2][0] = " ";
            stringArray[n2][1] = "not available";
        }
        n2 = 0;
        stringArray[n2][0] = "Station ID";
        stringArray[n2][1] = this.getRaobID();
        stringArray[++n2][0] = "Day of Report";
        if (this.buffer[35] != Short.MIN_VALUE && this.buffer[36] != Short.MIN_VALUE && this.buffer[37] != Short.MIN_VALUE) {
            stringArray[n2][1] = this.getDateString();
        }
        stringArray[++n2][0] = "Observation Time";
        if (this.buffer[38] != Short.MIN_VALUE) {
            int n3 = this.buffer[38] / 100;
            int n4 = this.buffer[38] % 100;
            stringArray[n2][1] = "" + n3 + ":";
            if (n4 < 10) {
                stringArray[n2][1] = stringArray[n2][1] + "0";
            }
            stringArray[n2][1] = stringArray[n2][1] + n4 + " Z";
        }
        stringArray[++n2][0] = "Station Elevation";
        if (this.buffer[41] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + this.buffer[41];
        }
        stringArray[++n2][0] = "Instrument Type";
        if (this.buffer[43] != Short.MIN_VALUE) {
            PdispGlobals pdispGlobals = new PdispGlobals();
            stringArray[n2][1] = "" + this.buffer[43] + ":  " + pdispGlobals.getRaobInstrumentType(this.buffer[43]);
        }
        stringArray[++n2][0] = "Report Type";
        if (this.buffer[42] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + this.buffer[42];
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "GRUAN";
        if (this.buffer[161] == 0) {
            stringArray[n2][1] = "No";
        } else if (this.buffer[161] == 1) {
            stringArray[n2][1] = "Primary";
        } else if (this.buffer[161] == 2) {
            stringArray[n2][1] = "Secondary";
        } else if (this.buffer[161] == 3) {
            stringArray[n2][1] = "Primary (dummy)";
        } else if (this.buffer[161] == 4) {
            stringArray[n2][1] = "Secondary (dummy)";
        }
        stringArray[++n2][0] = "SUAN-250";
        if (this.buffer[159] == 1) {
            stringArray[n2][1] = "Yes";
        } else if (this.buffer[159] == 0) {
            stringArray[n2][1] = "No";
        }
        stringArray[++n2][0] = "GCOS";
        if (this.buffer[160] == 1) {
            stringArray[n2][1] = "Yes";
        } else if (this.buffer[160] == 0) {
            stringArray[n2][1] = "No";
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Station Terrain";
        if (this.buffer[44] == 0) {
            stringArray[n2][1] = "Sea";
        } else if (this.buffer[44] == 1) {
            stringArray[n2][1] = "Land";
        } else if (this.buffer[44] == 2) {
            stringArray[n2][1] = "Coast";
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Top Interpolated Pressure";
        if (this.buffer[46] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.oneDigit((float)this.buffer[46] / 10.0f) + " mb";
        }
        stringArray[++n2][0] = "Bottom Interpolated Pressure";
        if (this.buffer[45] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.oneDigit((float)this.buffer[45] / 10.0f) + " mb";
        }
        stringArray[++n2][0] = "Top Interpolated Moisture Pressure";
        if (this.buffer[182] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.oneDigit((float)this.buffer[182] / 10.0f) + " mb";
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Reported Surface Pressure";
        if (this.buffer[1959] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[1959] / 10.0f);
        }
        stringArray[++n2][0] = "Reported Surface Temperature";
        if (this.buffer[1960] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[1960] / 10.0f);
        }
        stringArray[++n2][0] = "Reported Rad. Corrected Surface Temp";
        if (this.buffer[1961] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[1961] / 10.0f);
        }
        stringArray[++n2][0] = "Reported Surface Dewpoint Temp";
        if (this.buffer[1962] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[1962] / 10.0f);
        }
        stringArray[++n2][0] = "Reported Surface Pressure QC Flag";
        if (this.buffer[1963] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + this.buffer[1963];
        }
        stringArray[++n2][0] = "Reported Surface Temperature QC Flag";
        if (this.buffer[1964] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + this.buffer[1964];
        }
        stringArray[++n2][0] = "Reported Surface Humidity QC Flag";
        if (this.buffer[1965] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + this.buffer[1965];
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Tier 1 Flags";
        int[] nArray = this.getTier1Flags();
        stringArray[n2][1] = "" + nArray[0] + "  " + nArray[1] + "  " + nArray[2] + "  " + nArray[3];
        stringArray[++n2][0] = "Tier 2 Flag (initial/adjusted/final)";
        String string = "not available";
        String string2 = "not available";
        String string3 = "not available";
        if (this.buffer[69] != Short.MIN_VALUE) {
            string = "" + this.buffer[69];
        }
        if (this.buffer[70] != Short.MIN_VALUE) {
            string2 = "" + this.buffer[70];
        }
        if (this.buffer[52] != Short.MIN_VALUE) {
            string3 = "" + this.buffer[52];
        }
        stringArray[n2][1] = "" + string + " / " + string2 + " / " + string3;
        stringArray[++n2][0] = "Tier 3 Flag";
        stringArray[n2][1] = "" + this.getTier3Flag();
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Radiation Correction";
        stringArray[n2][1] = "not available";
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Surface Boundary Layer Flag";
        if (this.buffer[57] == 0) {
            stringArray[n2][1] = "0 - No Anomalies";
        } else if (this.buffer[57] == 1) {
            stringArray[n2][1] = "1 - Moderate Anomalies";
        } else if (this.buffer[57] == 2) {
            stringArray[n2][1] = "2 - Severe Anomalies";
        }
        stringArray[++n2][0] = "Temperature Profile Capped Flag";
        if (this.buffer[49] == 0) {
            stringArray[n2][1] = "Not Capped";
        } else if (this.buffer[49] == 1) {
            stringArray[n2][1] = "Capped";
        }
        stringArray[++n2][0] = "Moisture Profile Capped Flag";
        if (this.buffer[53] == 0) {
            stringArray[n2][1] = "Not Capped";
        } else if (this.buffer[53] == 1) {
            stringArray[n2][1] = "Capped";
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Water Vapor Anomaly Detected Flag";
        if (this.buffer[59] == 0) {
            stringArray[n2][1] = "No";
        } else if (this.buffer[59] == 1) {
            stringArray[n2][1] = "Yes";
        }
        stringArray[++n2][0] = "Water Vapor Event1 Detected Flag";
        if (this.buffer[60] == 0) {
            stringArray[n2][1] = "No";
        } else if (this.buffer[60] == 1) {
            stringArray[n2][1] = "Yes";
        }
        stringArray[++n2][0] = "Water Vapor Extreme Event1 Detected Flag";
        if (this.buffer[61] == 0) {
            stringArray[n2][1] = "No";
        } else if (this.buffer[61] == 1) {
            stringArray[n2][1] = "Yes";
        }
        stringArray[++n2][0] = "Water Vapor Event2 Detected Flag";
        if (this.buffer[62] == 0) {
            stringArray[n2][1] = "No";
        } else if (this.buffer[62] == 1) {
            stringArray[n2][1] = "Yes";
        }
        stringArray[++n2][0] = "Water Vapor Negative Event Detected Flag";
        if (this.buffer[63] == 0) {
            stringArray[n2][1] = "No";
        } else if (this.buffer[63] == 1) {
            stringArray[n2][1] = "Yes";
        }
        stringArray[++n2][0] = "Water Vapor Extreme Negative Detected Flag";
        if (this.buffer[64] == 0) {
            stringArray[n2][1] = "No";
        } else if (this.buffer[64] == 1) {
            stringArray[n2][1] = "Yes";
        }
        stringArray[++n2][0] = "Water Vapor Replacement/Extrapolation Flag";
        if (this.buffer[65] == 0) {
            stringArray[n2][1] = "None";
        } else if (this.buffer[65] == 1) {
            stringArray[n2][1] = "Extrapolation";
        } else if (this.buffer[65] == 2) {
            stringArray[n2][1] = "Replacement";
        }
        stringArray[++n2][0] = "Inversion Type Flag";
        if (this.buffer[66] == 0) {
            stringArray[n2][1] = "None";
        } else if (this.buffer[66] == 1) {
            stringArray[n2][1] = "Surface Inversion";
        } else if (this.buffer[66] == 2) {
            stringArray[n2][1] = "Inversion Aloft Only";
        }
        stringArray[++n2][0] = "Constant Dewpoint Depression Flag";
        if (this.buffer[67] == 0) {
            stringArray[n2][1] = "0 - None";
        } else if (this.buffer[67] == 1) {
            stringArray[n2][1] = "1 - All dwpt depressions within 5 degrees";
        } else if (this.buffer[67] == 2) {
            stringArray[n2][1] = "2 - All dwpt depressions within 2.5 degrees";
        } else if (this.buffer[67] == 3) {
            stringArray[n2][1] = "3 - All dwpt depressions within 1 degree";
        }
        stringArray[++n2][0] = "Duplicate Raob Flag";
        if (this.buffer[68] == 0) {
            stringArray[n2][1] = "Not Duplicate";
        } else if (this.buffer[68] == 1) {
            stringArray[n2][1] = "Accepted Duplicate";
        } else if (this.buffer[68] == 2) {
            stringArray[n2][1] = "Rejected Duplicate";
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Reported Tropopause Pressure";
        if (this.buffer[152] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[152] / 1.0f) + " mb";
        }
        stringArray[++n2][0] = "Calculated Tropopause Pressure";
        stringArray[n2][1] = "";
        for (n = 0; n < 5; ++n) {
            if (n != 0) {
                stringArray[n2][1] = stringArray[n2][1] + " / ";
            }
            stringArray[n2][1] = this.buffer[1953 + n] != Short.MIN_VALUE ? stringArray[n2][1] + EdgeUtils.oneDigit((float)this.buffer[1953 + n] / 10.0f) + " mb" : stringArray[n2][1] + "na";
        }
        stringArray[++n2][0] = "Deflection Point Pressures";
        stringArray[n2][1] = "";
        for (n = 0; n < 5; ++n) {
            if (n != 0) {
                stringArray[n2][1] = stringArray[n2][1] + " / ";
            }
            stringArray[n2][1] = this.buffer[1791 + n] != Short.MIN_VALUE ? stringArray[n2][1] + EdgeUtils.oneDigit((float)this.buffer[1791 + n] / 10.0f) + " mb" : stringArray[n2][1] + "na";
        }
        stringArray[++n2][0] = "Surface Pressure";
        if (this.buffer[153] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.oneDigit((float)this.buffer[153] / 1.0f) + " mb";
        }
        stringArray[++n2][0] = "Surface Temperature";
        if (this.buffer[154] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[154] / 64.0f) + " deg K";
        }
        stringArray[++n2][0] = "Surface Water Vapor";
        if (this.buffer[155] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[155] / 1024.0)) + " g/kg";
        }
        stringArray[++n2][0] = "Surface Dewpoint Temp";
        if (this.buffer[156] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[156] / 64.0f) + " deg K";
        }
        stringArray[++n2][0] = "WVapor At Lowest Level";
        if (this.buffer[157] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[157] / 1024.0)) + " g/kg";
        }
        stringArray[++n2][0] = "WVapor At Highest Level";
        if (this.buffer[158] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.fourDigits((float)Math.exp((double)this.buffer[158] / 1024.0)) + " g/kg";
        }
        stringArray[++n2][0] = " ";
        stringArray[n2][1] = " ";
        stringArray[++n2][0] = "Reported Layer Precip Water (mm)";
        if (this.buffer[159] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[159] / 100.0f);
        }
        stringArray[++n2][0] = " ";
        if (this.buffer[160] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[160] / 100.0f);
        }
        stringArray[++n2][0] = " ";
        if (this.buffer[161] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[161] / 100.0f);
        }
        stringArray[++n2][0] = "Total Precip Water (mm)";
        if (this.buffer[162] != Short.MIN_VALUE) {
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[162] / 100.0f);
        }
        for (n = 0; n < 18; ++n) {
            stringArray[++n2][0] = n == 0 ? "Extrapolated Layer Precip Water (mm)" : " ";
            if (this.buffer[163 + n] == Short.MIN_VALUE) continue;
            stringArray[n2][1] = "" + EdgeUtils.twoDigits((float)this.buffer[163 + n] / 100.0f);
        }
        return stringArray;
    }

    public Vector buildStandardAndSigLevelTable() {
        int n;
        Vector<JComponent> vector = new Vector<JComponent>();
        vector.add(new JLabel(" "));
        vector.add(new JLabel("<html><font size=+1><bold>Standard (red) and Significant (white) Level Data</bold></font></html>"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Level");
        vector2.add("Pressure");
        vector2.add("Obs Temp");
        vector2.add("Radcor\nTemp");
        vector2.add("Fcst Temp");
        vector2.add("Obs Dwpt");
        vector2.add("Radcor\nDwpt");
        vector2.add("Fcst WVMR");
        vector2.add("Drift\nTime");
        vector2.add("Drift\nLat");
        vector2.add("Drift\nLon");
        vector2.add("Drift\nDistance");
        vector2.add("Pressure\nFlag");
        vector2.add("Temp\nFlag");
        vector2.add("RH\nFlag");
        vector2.add("Missing\nFlag");
        Vector vector3 = new Vector();
        float[][] fArray = this.getCategory1Data();
        float[] fArray2 = new float[18];
        PressureLevels pressureLevels = new PressureLevels();
        int n2 = 0;
        for (int i = 0; i < 18; ++i) {
            if (fArray[i][6] == -999.99f) continue;
            fArray2[n2] = pressureLevels.getStdPressure(n2 + 1);
            ++n2;
        }
        float[] fArray3 = new float[100];
        float[][] fArray4 = this.getCategory2Data();
        int n3 = this.getNumSigLevels();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            fArray3[i] = fArray4[i][0];
            if (fArray4[i][0] == -999.99f) continue;
            ++n4;
        }
        int[] nArray = new int[118];
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < n2 + n4; ++n) {
            boolean bl = false;
            bl = n5 >= n2 ? false : (n6 >= n4 ? true : fArray2[n5] > fArray3[n6]);
            if (bl) {
                nArray[n] = -1 * (n5 + 1);
                ++n5;
                continue;
            }
            nArray[n] = n6++;
        }
        float f = this.getLatitude();
        float f2 = this.getLongitude();
        boolean[] blArray = new boolean[n];
        int n7 = -1;
        for (int i = n - 1; i >= 0; --i) {
            int n8;
            float f3;
            ++n7;
            Vector<String> vector4 = new Vector<String>();
            boolean bl = false;
            int n9 = nArray[i];
            if (nArray[i] < 0) {
                bl = true;
                n9 = -nArray[i] - 1;
            }
            if (bl) {
                int n10;
                blArray[n7] = true;
                vector4.add("" + (n9 + 1));
                vector4.add("" + EdgeUtils.oneDigit(fArray2[n9]));
                for (n10 = 0; n10 <= 4; ++n10) {
                    if (fArray[n9][n10] != -999.99f) {
                        vector4.add("" + EdgeUtils.oneDigit(fArray[n9][n10]));
                        continue;
                    }
                    vector4.add(" ");
                }
                if (fArray[n9][5] != -999.99f) {
                    vector4.add("" + EdgeUtils.fourDigits(fArray[n9][5]));
                } else {
                    vector4.add(" ");
                }
                if (fArray[n9][6] != -999.99f) {
                    vector4.add("" + EdgeUtils.oneDigit(fArray[n9][6]));
                } else {
                    vector4.add(" ");
                }
                for (n10 = 7; n10 <= 8; ++n10) {
                    if (fArray[n9][n10] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray[n9][n10]));
                        continue;
                    }
                    vector4.add(" ");
                }
                f3 = EdgeUtils.calculateDistance(f, f2, fArray[n9][7], fArray[n9][8]);
                if (fArray[n9][7] != -999.99f && fArray[n9][8] != -999.99f) {
                    vector4.add("" + EdgeUtils.oneDigit(f3));
                } else {
                    vector4.add(" ");
                }
                vector4.add(" ");
                for (n8 = 9; n8 <= 11; ++n8) {
                    if (fArray[n9][n8] != -999.99f) {
                        vector4.add("" + (int)fArray[n9][n8]);
                        continue;
                    }
                    vector4.add(" ");
                }
                vector4.add(" ");
            } else {
                int n11;
                blArray[n7] = false;
                vector4.add("" + (n9 + 1));
                vector4.add("" + EdgeUtils.oneDigit(fArray3[n9]));
                for (n11 = 1; n11 <= 5; ++n11) {
                    if (fArray4[n9][n11] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray4[n9][n11]));
                        continue;
                    }
                    vector4.add(" ");
                }
                if (fArray4[n9][6] != -999.99f) {
                    vector4.add("" + EdgeUtils.fourDigits(fArray4[n9][6]));
                } else {
                    vector4.add(" ");
                }
                if (fArray4[n9][7] != -999.99f) {
                    vector4.add("" + (int)fArray4[n9][7]);
                } else {
                    vector4.add(" ");
                }
                for (n11 = 8; n11 <= 9; ++n11) {
                    if (fArray4[n9][n11] != -999.99f) {
                        vector4.add("" + EdgeUtils.twoDigits(fArray4[n9][n11]));
                        continue;
                    }
                    vector4.add(" ");
                }
                f3 = EdgeUtils.calculateDistance(f, f2, fArray4[n9][8], fArray4[n9][9]);
                if (fArray4[n9][8] != -999.99f && fArray4[n9][9] != -999.99f) {
                    vector4.add("" + EdgeUtils.oneDigit(f3));
                } else {
                    vector4.add(" ");
                }
                for (n8 = 10; n8 <= 13; ++n8) {
                    if (fArray4[n9][n8] != -999.99f) {
                        vector4.add("" + (int)fArray4[n9][n8]);
                        continue;
                    }
                    vector4.add(" ");
                }
            }
            vector3.add(vector4);
        }
        RedCellRenderer redCellRenderer = new RedCellRenderer();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            redCellRenderer.setRowToColor(i);
        }
        JTable jTable = new JTable(vector3, vector2);
        jTable.setDefaultRenderer(Object.class, redCellRenderer);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setGridColor(Color.gray);
        jTable.setAutoResizeMode(0);
        MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer(multiLineHeaderRenderer);
        }
        EdgeUtils.adjustTableColumnPreferredWidths(jTable, 5);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        vector.add(jPanel2);
        return vector;
    }
}

