/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.DataInputStream;
import java.util.Vector;

class Satellite {
    private Subgroup[] subgroups;
    private String satellite_name;
    private int number_of_subgroups;
    private boolean contains_valid_data = false;

    public Satellite(DataInputStream dataInputStream, int n, float f, int n2) {
        this.readSatelliteBlock(dataInputStream, n, f, n2);
    }

    private void readSatelliteBlock(DataInputStream dataInputStream, int n, float f, int n2) {
        try {
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            if (n3 != 83658432) {
                System.out.println("Bad sat block id: " + n3);
            } else {
                int n5;
                this.satellite_name = "";
                for (n5 = 0; n5 < 36; ++n5) {
                    char c = (char)dataInputStream.readInt();
                    if (c == '\u0000') continue;
                    this.satellite_name = this.satellite_name + c;
                }
                this.number_of_subgroups = dataInputStream.readInt();
                this.subgroups = new Subgroup[this.number_of_subgroups];
                for (n5 = 0; n5 < this.number_of_subgroups; ++n5) {
                    this.subgroups[n5] = new Subgroup(dataInputStream, n, f, n2);
                }
                this.contains_valid_data = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Sat Group:");
            exception.printStackTrace();
        }
    }

    public String getSatelliteName() {
        return this.satellite_name;
    }

    public Vector getSubgroupNames() {
        Vector<String[]> vector = new Vector<String[]>();
        for (int i = 0; i < this.number_of_subgroups; ++i) {
            String[] stringArray = new String[]{this.satellite_name, this.subgroups[i].getSubgroupName()};
            vector.add(stringArray);
        }
        return vector;
    }

    public Profile[][] getProfiles(int n, int n2, float[] fArray) {
        Profile[][] profileArray = new Profile[this.number_of_subgroups][n2];
        VstatGlobals vstatGlobals = new VstatGlobals();
        for (int i = 0; i < this.number_of_subgroups; ++i) {
            Profile[] profileArray2 = this.subgroups[i].getProfiles(n2, fArray, this.satellite_name);
            for (int j = 0; j < n2; ++j) {
                int n3;
                profileArray[i][j] = profileArray2[j];
                Color color = vstatGlobals.getProfileColor(n);
                int n4 = (i + 1) / 2;
                for (n3 = 0; n3 < n4; ++n3) {
                    color = i % 2 == 0 ? color.brighter() : color.darker();
                }
                n3 = vstatGlobals.getProfileThickness(n);
                n3 -= i * 1;
                n3 = Math.max(n3, 1);
                int n5 = vstatGlobals.getProfileStyle(j);
                profileArray[i][j].setLineStyle(n5);
            }
        }
        return profileArray;
    }

    public int getNumberOfSubgroups() {
        return this.number_of_subgroups;
    }
}

