/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Shortcut
implements Externalizable {
    static final long serialVersionUID = 1L;
    private int class_version = 1;
    private String alias;
    private String path;
    private Color color;

    public Shortcut(String string, String string2, String string3) {
        this.alias = string;
        this.path = string2;
        this.color = this.parseColor(string3);
    }

    public Shortcut() {
        this.alias = "Alias";
        this.path = "Path";
        this.color = Color.black;
    }

    public boolean hasAlias() {
        return this.alias.length() > 0;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (this.hasAlias()) {
            return this.alias;
        }
        return this.path;
    }

    public String getDisplayName() {
        if (this.hasAlias()) {
            return '[' + this.alias + ']';
        }
        return this.path;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String string) {
        this.color = this.parseColor(string);
    }

    public String getColorString() {
        return this.colorToString(this.color);
    }

    public void setColorString(String string) {
        this.color = this.parseColor(string);
    }

    private String colorToString(Color color) {
        if (color == Color.blue) {
            return "blue";
        }
        if (color == Color.cyan) {
            return "cyan";
        }
        if (color == Color.gray) {
            return "gray";
        }
        if (color == Color.magenta) {
            return "magenta";
        }
        if (color == Color.orange) {
            return "orange";
        }
        if (color == Color.pink) {
            return "pink";
        }
        if (color == Color.red) {
            return "red";
        }
        if (color == Color.black) {
            return "black";
        }
        String string = Integer.toHexString(color.getRGB());
        String string2 = string.substring(2);
        if (string2.equals("339933")) {
            return "green";
        }
        if (string2.equals("cccc33")) {
            return "yellow";
        }
        if (string2.equals("66cc99")) {
            return "teal";
        }
        return string2;
    }

    private Color parseColor(String string) {
        try {
            int n = Integer.parseInt(string, 16);
            return new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("blue")) {
                return Color.blue;
            }
            if (string.equals("cyan")) {
                return Color.cyan;
            }
            if (string.equals("gray")) {
                return Color.gray;
            }
            if (string.equals("green")) {
                return new Color(51, 153, 51);
            }
            if (string.equals("magenta")) {
                return Color.magenta;
            }
            if (string.equals("orange")) {
                return Color.orange;
            }
            if (string.equals("pink")) {
                return Color.pink;
            }
            if (string.equals("red")) {
                return Color.red;
            }
            if (string.equals("teal")) {
                return new Color(102, 204, 153);
            }
            if (string.equals("yellow")) {
                return new Color(204, 204, 51);
            }
            return Color.black;
        }
    }

    public String toString() {
        return "[" + this.alias + "," + this.path + "," + this.colorToString(this.color) + "]";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.class_version);
        objectOutput.writeObject(this.alias);
        objectOutput.writeObject(this.path);
        objectOutput.writeObject(this.color);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 1: {
                this.readVersion01(objectInput);
            }
        }
    }

    private void readVersion01(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.alias = (String)objectInput.readObject();
        this.path = (String)objectInput.readObject();
        this.color = (Color)objectInput.readObject();
    }
}

