/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.DataInputStream;
import java.util.Vector;

class Subgroup {
    private String subgroup_name;
    private int prof_code;
    private Vector statistics;
    private boolean contains_valid_data = false;

    public Subgroup(DataInputStream dataInputStream, int n, float f, int n2) {
        this.readSubgroupBlock(dataInputStream, n, f, n2);
    }

    private void readSubgroupBlock(DataInputStream dataInputStream, int n, float f, int n2) {
        this.statistics = new Vector(n2);
        try {
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            this.prof_code = dataInputStream.readInt();
            if (n3 != 83856671) {
                System.out.println("Bad subgroup block id: " + n3);
            } else {
                int n5;
                this.subgroup_name = "";
                for (n5 = 0; n5 < 36; ++n5) {
                    char c = (char)dataInputStream.readInt();
                    if (c == '\u0000') continue;
                    this.subgroup_name = this.subgroup_name + c;
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    float[] fArray = new float[n];
                    for (int i = 0; i < n; ++i) {
                        int n6 = dataInputStream.readInt();
                        fArray[i] = n6 != Short.MIN_VALUE ? (float)n6 / f : -32768.0f;
                    }
                    this.statistics.add(fArray);
                }
                this.contains_valid_data = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Subgroup:");
            exception.printStackTrace();
        }
    }

    public String getSubgroupName() {
        return this.subgroup_name;
    }

    public Profile[] getProfiles(int n, float[] fArray, String string) {
        Profile[] profileArray = new Profile[n];
        for (int i = 0; i < n; ++i) {
            float[] fArray2 = (float[])this.statistics.elementAt(i);
            String string2 = this.subgroup_name;
            Color color = Color.black;
            int n2 = 3;
            int n3 = 1;
            profileArray[i] = new Profile(0, string2, 0, color, n2, n3);
            int n4 = Math.min(fArray2.length, fArray.length);
            for (int j = 0; j < n4; ++j) {
                if (fArray[j] == -32768.0f || fArray2[j] == -32768.0f) continue;
                profileArray[i].addItem(fArray[j], fArray2[j]);
            }
            profileArray[i].trimProfile();
            profileArray[i].setVisible(true);
            EdgeGlobals edgeGlobals = new EdgeGlobals();
            Color[][][] colorArray = edgeGlobals.getProfileColors();
            int[][][] nArray = edgeGlobals.getProfileThicknesses();
            int[][][] nArray2 = edgeGlobals.getProfileStyles();
            int n5 = this.prof_code / 1000;
            int n6 = this.prof_code % 1000;
            profileArray[i].setLineColor(colorArray[n5][n6][0]);
            profileArray[i].setLineThickness(nArray[n5][n6][0]);
        }
        return profileArray;
    }
}

