/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;

public class VstatGlobals {
    private static boolean variables_initialized;
    private static int window_width;
    private static int window_height;
    private static int window_x;
    private static int window_y;
    private static String most_recent_file_directory;
    private static String most_recent_file_name;
    private static String most_recent_image_directory;
    private static String most_recent_image_name;
    private static boolean start_at_first_set;
    private static boolean use_sample_size_cutoff;
    private static int pressure_scale;
    private static boolean show_grid_lines;
    private static int data_group;
    private static boolean[] show_stats;
    private static boolean use_default_scale;
    private static int temperature_unit;
    private static int pressure_unit;
    private static int date_label;
    private static String font_name;
    private static int font_style;
    private static int minimum_font_size;
    private static Color[] profile_color;
    private static int[] profile_thickness;
    private static int[] profile_style;

    public VstatGlobals() {
        if (!variables_initialized) {
            this.initialize();
        }
    }

    private void initialize() {
        Object object;
        try {
            object = Toolkit.getDefaultToolkit().getScreenSize();
            window_width = (int)((double)((Dimension)object).width * 0.67);
            window_height = (int)((double)((Dimension)object).height * 0.9);
        }
        catch (Exception exception) {
            window_width = 100;
            window_height = 200;
        }
        window_x = 0;
        window_y = 0;
        try {
            most_recent_file_directory = object = System.getProperty("user.dir");
            most_recent_file_name = null;
            most_recent_image_directory = object;
            most_recent_image_name = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        start_at_first_set = true;
        use_sample_size_cutoff = true;
        pressure_scale = 1;
        show_grid_lines = false;
        data_group = 0;
        show_stats = new boolean[4];
        VstatGlobals.show_stats[0] = false;
        VstatGlobals.show_stats[1] = true;
        VstatGlobals.show_stats[2] = true;
        VstatGlobals.show_stats[3] = false;
        use_default_scale = true;
        temperature_unit = 0;
        pressure_unit = 0;
        date_label = 0;
        font_name = "Sans-Serif";
        font_style = 0;
        minimum_font_size = 5;
        profile_color = new Color[8];
        profile_thickness = new int[8];
        profile_style = new int[8];
        VstatGlobals.profile_color[0] = new Color(255, 0, 0);
        VstatGlobals.profile_color[1] = new Color(0, 0, 255);
        VstatGlobals.profile_color[2] = new Color(0, 165, 0);
        VstatGlobals.profile_color[3] = new Color(255, 128, 0);
        VstatGlobals.profile_color[4] = new Color(255, 0, 255);
        VstatGlobals.profile_color[5] = new Color(0, 255, 128);
        VstatGlobals.profile_color[6] = new Color(165, 90, 0);
        VstatGlobals.profile_color[7] = new Color(128, 128, 128);
        for (int i = 0; i < 8; ++i) {
            VstatGlobals.profile_thickness[i] = 4;
            VstatGlobals.profile_style[i] = i;
        }
        VstatGlobals.profile_style[0] = 6;
        VstatGlobals.profile_style[1] = 0;
        VstatGlobals.profile_style[2] = 2;
        variables_initialized = true;
    }

    public void setWindowWidth(int n) {
        window_width = n;
    }

    public int getWindowWidth() {
        return window_width;
    }

    public void setWindowHeight(int n) {
        window_height = n;
    }

    public int getWindowHeight() {
        return window_height;
    }

    public void setWindowX(int n) {
        window_x = n;
    }

    public int getWindowX() {
        return window_x;
    }

    public void setWindowY(int n) {
        window_y = n;
    }

    public int getWindowY() {
        return window_y;
    }

    public void setFileDirectory(String string) {
        most_recent_file_directory = string;
    }

    public String getFileDirectory() {
        return most_recent_file_directory;
    }

    public void setFileName(String string) {
        most_recent_file_name = string;
    }

    public String getFileName() {
        return most_recent_file_name;
    }

    public void setImageDirectory(String string) {
        most_recent_image_directory = string;
    }

    public String getImageDirectory() {
        return most_recent_image_directory;
    }

    public void setImageName(String string) {
        most_recent_image_name = string;
    }

    public String getImageName() {
        return most_recent_image_name;
    }

    public void setStartAtFirstSet(boolean bl) {
        start_at_first_set = bl;
    }

    public boolean getStartAtFirstSet() {
        return start_at_first_set;
    }

    public void setUseSampleSizeCutoff(boolean bl) {
        use_sample_size_cutoff = bl;
    }

    public boolean useSampleSizeCutoff() {
        return use_sample_size_cutoff;
    }

    public void setPressureScale(int n) {
        pressure_scale = n;
    }

    public int getPressureScale() {
        return pressure_scale;
    }

    public void setShowGridLines(boolean bl) {
        show_grid_lines = bl;
    }

    public boolean getShowGridLines() {
        return show_grid_lines;
    }

    public void setDataGroup(int n) {
        data_group = n;
    }

    public int getDataGroup() {
        return data_group;
    }

    public void setShowStats(boolean[] blArray) {
        if (blArray.length > show_stats.length) {
            show_stats = new boolean[blArray.length];
        }
        for (int i = 0; i < blArray.length; ++i) {
            VstatGlobals.show_stats[i] = blArray[i];
        }
    }

    public boolean[] getShowStats() {
        return show_stats;
    }

    public void setUseDefaultScale(boolean bl) {
        use_default_scale = bl;
    }

    public boolean getUseDefaultScale() {
        return use_default_scale;
    }

    public void setTemperatureUnit(int n) {
        temperature_unit = n;
    }

    public int getTemperatureUnit() {
        return temperature_unit;
    }

    public void setPressureUnit(int n) {
        pressure_unit = n;
    }

    public int getPressureUnit() {
        return pressure_unit;
    }

    public void setDateLabelOption(int n) {
        date_label = n;
    }

    public int getDateLabelOption() {
        return date_label;
    }

    public void setFontName(String string) {
        font_name = string;
    }

    public String getFontName() {
        return font_name;
    }

    public void setFontStyle(int n) {
        font_style = n;
    }

    public int getFontStyle() {
        return font_style;
    }

    public void setMinimumFontSize(int n) {
        minimum_font_size = n;
    }

    public int getMinimumFontSize() {
        return minimum_font_size;
    }

    public void setProfileColor(int n, Color color) {
        if (n >= 0 && n < profile_color.length) {
            VstatGlobals.profile_color[n] = color;
        }
    }

    public Color getProfileColor(int n) {
        Color color = Color.black;
        if (n >= 0 && n < profile_color.length) {
            color = profile_color[n];
        }
        return color;
    }

    public void setProfileColors(Color[] colorArray) {
        profile_color = colorArray;
    }

    public Color[] getProfileColors() {
        return profile_color;
    }

    public void setProfileThickness(int n, int n2) {
        if (n >= 0 && n < profile_thickness.length) {
            VstatGlobals.profile_thickness[n] = n2;
        }
    }

    public int getProfileThickness(int n) {
        int n2 = 1;
        if (n >= 0 && n < profile_thickness.length) {
            n2 = profile_thickness[n];
        }
        return n2;
    }

    public void setProfileThicknesses(int[] nArray) {
        profile_thickness = nArray;
    }

    public int[] getProfileThicknesses() {
        return profile_thickness;
    }

    public void setProfileStyle(int n, int n2) {
        if (n >= 0 && n < profile_style.length) {
            VstatGlobals.profile_style[n] = n2;
        }
    }

    public int getProfileStyle(int n) {
        int n2 = 1;
        if (n >= 0 && n < profile_style.length) {
            n2 = profile_style[n];
        }
        return n2;
    }

    public void setProfileStyles(int[] nArray) {
        profile_style = nArray;
    }

    public int[] getProfileStyles() {
        return profile_style;
    }
}

