/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class VstatStatSet {
    private VstatDataGroup[] data_groups;
    private int number_of_data_groups;
    private int set_code;
    private String set_name;
    private int start_year;
    private int start_mmdd;
    private int end_year;
    private int end_mmdd;
    private float top_lat;
    private float bottom_lat;
    private float left_lon;
    private float right_lon;
    private int time_limit_before;
    private int time_limit_after;
    private int distance_limit;
    private int terrain;
    private int day_night;
    private int tarm_path;
    private int orbital_node;
    private boolean contains_valid_data = false;
    private VstatGlobals vstat_globals = new VstatGlobals();

    public VstatStatSet(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.readStatSet(dataInputStream);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public VstatStatSet(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            this.readStatSet(dataInputStream);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readStatSet(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n != 83836984) {
                System.out.println("Bad stat set block id: " + n);
            } else {
                int n3;
                int n4;
                this.set_code = dataInputStream.readInt();
                this.set_name = "";
                for (n4 = 0; n4 < 50; ++n4) {
                    n3 = dataInputStream.readInt();
                    if (n3 == 0) continue;
                    this.set_name = this.set_name + (char)n3;
                }
                this.number_of_data_groups = dataInputStream.readInt();
                this.start_year = dataInputStream.readInt();
                this.start_mmdd = dataInputStream.readInt();
                this.end_year = dataInputStream.readInt();
                this.end_mmdd = dataInputStream.readInt();
                this.top_lat = (float)dataInputStream.readInt() / 128.0f;
                this.bottom_lat = (float)dataInputStream.readInt() / 128.0f;
                this.left_lon = (float)dataInputStream.readInt() / 128.0f;
                this.right_lon = (float)dataInputStream.readInt() / 128.0f;
                this.time_limit_before = dataInputStream.readInt();
                this.time_limit_after = dataInputStream.readInt();
                this.distance_limit = dataInputStream.readInt();
                this.terrain = dataInputStream.readInt();
                this.day_night = dataInputStream.readInt();
                this.tarm_path = dataInputStream.readInt();
                this.orbital_node = dataInputStream.readInt();
                for (n4 = 0; n4 < 31; ++n4) {
                    n3 = dataInputStream.readInt();
                }
                this.data_groups = new VstatDataGroup[this.number_of_data_groups];
                for (n4 = 0; n4 < this.number_of_data_groups; ++n4) {
                    this.data_groups[n4] = new VstatDataGroup(dataInputStream);
                }
                this.contains_valid_data = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Stat Set:");
            exception.printStackTrace();
        }
    }

    public String getSetDescription() {
        return this.set_name;
    }

    public int getNumberOfDataTypes() {
        return this.number_of_data_groups;
    }

    public int getDataGroupNumber(int n) {
        int n2 = Short.MIN_VALUE;
        for (int i = 0; i < this.number_of_data_groups; ++i) {
            if (n != this.data_groups[i].getDataGroupCode()) continue;
            n2 = i;
        }
        return n2;
    }

    public String[] getDataGroupList() {
        String[] stringArray = new String[this.number_of_data_groups];
        for (int i = 0; i < this.number_of_data_groups; ++i) {
            stringArray[i] = this.data_groups[i].getDataGroupDescription();
        }
        return stringArray;
    }

    public String[] getStatNameList() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.number_of_data_groups; ++i) {
            String[] stringArray = this.data_groups[i].getStatDescriptions();
            for (int j = 0; j < stringArray.length; ++j) {
                if (vector.contains(stringArray[j])) continue;
                vector.add(stringArray[j]);
            }
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public String[] getStatNameList(int n) {
        return this.data_groups[n].getStatDescriptions();
    }

    public int[] getStatCodes(int n) {
        return this.data_groups[n].getStatCodes();
    }

    public String[] getSatelliteList() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.number_of_data_groups; ++i) {
            String[] stringArray = this.data_groups[i].getSatelliteNames();
            for (int j = 0; j < stringArray.length; ++j) {
                if (vector.contains(stringArray[j])) continue;
                vector.add(stringArray[j]);
            }
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public Vector getSatelliteGroupList() {
        Vector<String[]> vector = new Vector<String[]>();
        for (int i = 0; i < this.number_of_data_groups; ++i) {
            Vector vector2 = this.data_groups[i].getSatGroups();
            for (int j = 0; j < vector2.size(); ++j) {
                String[] stringArray = (String[])vector2.elementAt(j);
                boolean bl = false;
                for (int k = 0; k < vector.size(); ++k) {
                    String[] stringArray2 = (String[])vector.elementAt(k);
                    if (!stringArray2[0].equals(stringArray[0]) || !stringArray2[1].equals(stringArray[1])) continue;
                    bl = true;
                }
                if (bl) continue;
                vector.add(stringArray);
            }
        }
        return vector;
    }

    public String getStartingDate() {
        String string = "";
        int n = this.start_mmdd / 100;
        int n2 = this.start_mmdd % 100;
        string = this.getMonth(n) + " " + n2 + ", " + this.start_year;
        return string;
    }

    public String getEndingDate() {
        String string = "";
        int n = this.end_mmdd / 100;
        int n2 = this.end_mmdd % 100;
        string = this.getMonth(n) + " " + n2 + ", " + this.end_year;
        return string;
    }

    private String getMonth(int n) {
        String string = "";
        if (n == 1) {
            string = "January";
        } else if (n == 2) {
            string = "February";
        } else if (n == 3) {
            string = "March";
        } else if (n == 4) {
            string = "April";
        } else if (n == 5) {
            string = "May";
        } else if (n == 6) {
            string = "June";
        } else if (n == 7) {
            string = "July";
        } else if (n == 8) {
            string = "August";
        } else if (n == 9) {
            string = "September";
        } else if (n == 10) {
            string = "October";
        } else if (n == 11) {
            string = "November";
        } else if (n == 12) {
            string = "December";
        }
        return string;
    }

    public String getTopLatitude() {
        String string = "";
        int n = (int)this.top_lat;
        string = n > 0 ? string + n + "N" : string + -1 * n + "S";
        return string;
    }

    public String getBottomLatitude() {
        String string = "";
        int n = (int)this.bottom_lat;
        string = n > 0 ? string + n + "N" : string + -1 * n + "S";
        return string;
    }

    public String getLeftLongitude() {
        String string = "";
        int n = (int)this.left_lon;
        string = n > 0 ? string + n + "E" : string + -1 * n + "W";
        return string;
    }

    public String getRightLongitude() {
        String string = "";
        int n = (int)this.right_lon;
        string = n > 0 ? string + n + "E" : string + -1 * n + "W";
        return string;
    }

    public String getTerrain() {
        String string = "";
        if (this.terrain == 0) {
            string = "Sea";
        } else if (this.terrain == 1) {
            string = "Land";
        } else if (this.terrain == 2) {
            string = "Coast";
        } else if (this.terrain == 10) {
            string = "Ice";
        } else if (this.terrain == 11) {
            string = "Snow";
        } else if (this.terrain == 20) {
            string = "Sea/Ice";
        } else if (this.terrain == 21) {
            string = "Non-Sea";
        } else if (this.terrain == 30) {
            string = "All Terrain";
        }
        return string;
    }

    public String getDayNight() {
        String string = "";
        if (this.day_night == 0) {
            string = "Night";
        } else if (this.day_night == 1) {
            string = "Day";
        } else if (this.day_night == 2) {
            string = "Day & Night";
        }
        return string;
    }

    public String getTarmPath() {
        String string = "";
        if (this.tarm_path == 0) {
            string = "Clear";
        } else if (this.tarm_path == 1) {
            string = "Cloudy";
        } else if (this.tarm_path == 2) {
            string = "NStar";
        } else if (this.tarm_path == 3) {
            string = "Clear/NStar";
        } else if (this.tarm_path == 10) {
            string = "Clear & Cloudy";
        }
        return string;
    }

    public String getTimeLimit() {
        String string = "No Time Limit";
        if (this.time_limit_before != Short.MIN_VALUE) {
            string = this.time_limit_after != Short.MIN_VALUE ? "Time: " + this.time_limit_before + " hr / " + this.time_limit_after + " hr" : "Time: " + this.time_limit_before + " hr / no limit";
        } else if (this.time_limit_after != Short.MIN_VALUE) {
            string = "Time: no limit / " + this.time_limit_after + " hr";
        }
        return string;
    }

    public String getDistanceLimit() {
        String string = "No Distance Limit";
        if (this.distance_limit != Short.MIN_VALUE) {
            string = "Distance: " + this.distance_limit + " km";
        }
        return string;
    }

    public String getOrbitalNode() {
        String string = "";
        if (this.tarm_path == 0) {
            string = "Ascending";
        } else if (this.tarm_path == 1) {
            string = "Descending";
        } else if (this.tarm_path == 10) {
            string = "Ascend & Descend";
        }
        return string;
    }

    public String getBaselineSystemDescription(int n) {
        return this.data_groups[n].getBaselineSystemDescription();
    }

    public float[] getPressureLevels(int n) {
        return this.data_groups[n].getPressureLevels();
    }

    public float[] getBaselineMeans(int n) {
        return this.data_groups[n].getBaselineMeans();
    }

    public int[] getSampleSizes(int n) {
        return this.data_groups[n].getSampleSizes();
    }

    public String getDataGroupDescription(int n) {
        return this.data_groups[n].getDataGroupDescription();
    }

    public float getDefaultMinimumValue(int n) {
        return this.data_groups[n].getDefaultMinimumValue();
    }

    public float getDefaultMaximumValue(int n) {
        return this.data_groups[n].getDefaultMaximumValue();
    }

    public Profile[][] getProfiles(int n) {
        Profile[][] profileArray = this.data_groups[n].getProfiles();
        return profileArray;
    }

    public Profile[][] getProfiles(int n, Vector vector) {
        return this.getProfiles(n, vector, false);
    }

    public Profile[][] getProfiles(int n, Vector vector, boolean bl) {
        return this.data_groups[n].getProfiles(vector, bl);
    }

    public int getNumberOfSubgroups(int n) {
        return this.data_groups[n].getNumberOfSubgroups();
    }

    public int getNumberOfSubgroups(int n, int n2) {
        return this.data_groups[n].getNumberOfSubgroups(n2);
    }

    public int getNumberOfStats(int n) {
        return this.data_groups[n].getNumberOfStats();
    }
}

