/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DateChooserPanel
extends JPanel
implements ItemListener,
MouseListener,
FocusListener,
KeyListener {
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final Color WEEK_DAYS_FOREGROUND = Color.black;
    private static final Color DAYS_FOREGROUND = Color.blue;
    private static final Color SELECTED_DAY_FOREGROUND = Color.white;
    private static final Color SELECTED_DAY_BACKGROUND = Color.blue;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.yellow, 1);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private GregorianCalendar calendar;
    private JLabel[][] day_labels;
    private FocusablePanel daysGrid;
    private JComboBox month_list;
    private JComboBox year_list;
    private int offset;
    private int lastDay;
    private JLabel day;
    private long start_date;
    private long end_date;
    private int first_year;
    private int last_year;

    public DateChooserPanel(long l, long l2, long l3) {
        this.start_date = l;
        this.end_date = l2;
        long l4 = Math.max(this.start_date, l3);
        this.initialize(l4);
    }

    public DateChooserPanel() {
        this.start_date = 19000101L;
        this.end_date = 21001231L;
        long l = this.start_date;
        this.initialize(l);
    }

    private void initialize(long l) {
        int n;
        int n2;
        int n3;
        this.first_year = (int)(this.start_date / 10000L);
        this.last_year = (int)(this.end_date / 10000L);
        this.calendar = new GregorianCalendar();
        this.month_list = new JComboBox<String>(MONTHS);
        this.month_list.addItemListener(this);
        this.year_list = new JComboBox();
        for (n3 = this.first_year; n3 <= this.last_year; ++n3) {
            this.year_list.addItem(Integer.toString(n3));
        }
        this.year_list.addItemListener(this);
        this.day_labels = new JLabel[7][7];
        for (n3 = 0; n3 < 7; ++n3) {
            this.day_labels[0][n3] = new JLabel(DAYS[n3], 4);
            this.day_labels[0][n3].setForeground(WEEK_DAYS_FOREGROUND);
        }
        for (n3 = 1; n3 < 7; ++n3) {
            for (n2 = 0; n2 < 7; ++n2) {
                this.day_labels[n3][n2] = new JLabel(" ", 4);
                this.day_labels[n3][n2].setForeground(DAYS_FOREGROUND);
                this.day_labels[n3][n2].setBackground(SELECTED_DAY_BACKGROUND);
                this.day_labels[n3][n2].setBorder(EMPTY_BORDER);
                this.day_labels[n3][n2].addMouseListener(this);
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.add(this.month_list);
        jPanel.add(this.year_list);
        this.daysGrid = new FocusablePanel(new GridLayout(7, 7, 5, 0));
        this.daysGrid.addFocusListener(this);
        this.daysGrid.addKeyListener(this);
        for (n2 = 0; n2 < 7; ++n2) {
            for (n = 0; n < 7; ++n) {
                this.daysGrid.add(this.day_labels[n2][n]);
            }
        }
        this.daysGrid.setBackground(Color.white);
        this.daysGrid.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.daysGrid);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        n = (int)(l / 10000L);
        int n4 = (int)(l % 10000L) / 100;
        int n5 = (int)(l % 100L);
        this.year_list.setSelectedIndex(n - this.first_year);
        this.month_list.setSelectedIndex(n4 - 1);
        this.setSelected(n5);
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setSelected(JLabel jLabel) {
        if (this.day != null) {
            this.day.setForeground(DAYS_FOREGROUND);
            this.day.setOpaque(false);
            this.day.setBorder(EMPTY_BORDER);
        }
        this.day = jLabel;
        this.day.setForeground(SELECTED_DAY_FOREGROUND);
        this.day.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            this.day.setBorder(FOCUSED_BORDER);
        }
    }

    private void setSelected(int n) {
        this.setSelected(this.day_labels[(n + this.offset - 1) / 7 + 1][(n + this.offset - 1) % 7]);
    }

    private void update() {
        int n;
        int n2 = this.getSelectedDay();
        for (n = 0; n < 7; ++n) {
            this.day_labels[1][n].setText(" ");
            this.day_labels[5][n].setText(" ");
            this.day_labels[6][n].setText(" ");
        }
        this.calendar.set(5, 1);
        this.calendar.set(2, this.month_list.getSelectedIndex() + 0);
        this.calendar.set(1, this.year_list.getSelectedIndex() + this.first_year);
        this.offset = this.calendar.get(7) - 1;
        this.lastDay = this.calendar.getActualMaximum(5);
        for (n = 0; n < this.lastDay; ++n) {
            this.day_labels[(n + this.offset) / 7 + 1][(n + this.offset) % 7].setText(String.valueOf(n + 1));
        }
        if (n2 != -1) {
            if (n2 > this.lastDay) {
                n2 = this.lastDay;
            }
            this.setSelected(n2);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setSelected(this.day);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setSelected(this.day);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.update();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = this.getSelectedDay();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (n <= 1) break;
                this.setSelected(n - 1);
                break;
            }
            case 39: {
                if (n >= this.lastDay) break;
                this.setSelected(n + 1);
                break;
            }
            case 38: {
                if (n <= 7) break;
                this.setSelected(n - 7);
                break;
            }
            case 40: {
                if (n > this.lastDay - 7) break;
                this.setSelected(n + 7);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        if (!jLabel.getText().equals(" ")) {
            this.setSelected(jLabel);
        }
        this.daysGrid.requestFocus();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public Date select(Date date) {
        this.calendar.setTime(date);
        int n = this.calendar.get(5);
        int n2 = this.calendar.get(2);
        int n3 = this.calendar.get(1);
        this.year_list.setSelectedIndex(n3 - this.first_year);
        this.month_list.setSelectedIndex(n2 - 0);
        this.setSelected(n);
        this.setVisible(true);
        this.calendar.set(5, this.getSelectedDay());
        this.calendar.set(2, this.month_list.getSelectedIndex() + 0);
        this.calendar.set(1, this.year_list.getSelectedIndex() + this.first_year);
        return this.calendar.getTime();
    }

    public Date select() {
        return this.select(new Date());
    }

    public long getSelectedDate() {
        long l = (this.first_year + this.year_list.getSelectedIndex()) * 10000 + (this.month_list.getSelectedIndex() + 1) * 100 + this.getSelectedDay();
        return l;
    }

    public void setDate(long l) {
        int n = (int)(l / 10000L);
        int n2 = (int)(l % 10000L) / 100;
        int n3 = (int)(l % 100L);
        this.year_list.setSelectedIndex(n - this.first_year);
        this.month_list.setSelectedIndex(n2 - 1);
        this.setSelected(n3);
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public boolean isFocusable() {
            return true;
        }
    }
}

